<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Task
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class TaskController extends AppController
{
   private  $taskLogic;
   private  $taskStageLogic;
   private  $taskListLogic;
   public function __construct()
   {
     parent::__construct();
     $this->taskLogic = $this->load('task');
     $this->taskStageLogic = $this->load('taskStage');
     $this->taskListLogic  = $this->load('taskList');
   }
   /**
    * 新增任务
    * @return type 
    */
   public function actionAdd()
   {
     if(_p())
     {
        $base_name = _p('base_name');
        $cond = 'base_name ="' . $base_name . '"';
        $count = $this->taskLogic->getCount($cond);
        if($count > 1)
        {
          return $this->showMessage('task_existed');
        }
        $data = array(
            'base_name'   => $base_name,         
            'listorder'   => Common::queryInt(_p('listorder')),
            'create_time' => SYS_TIME,
            'remark'      => _p('remark'),
        );
        $res = $this->taskLogic->save($data);
        return $res ? $this->success('save_success', Common::adminURL('admin', 'task', 'list')) : $this->showMessage('save_failure');
     }
     else
     {
       Core::$htmlFile  = 'task/form';
       Core::$isdisplay = 0;
       Core::$tpl->render(Core::$htmlFile . '.htm');
     }
     
   }
   public function actionList()
   {
     $tasklist = $this->taskLogic->findAll();
     $task_ids = array();
     foreach ($tasklist as $task)
     {
       $task_ids[] = $task['id'];
     }
     $stage_count = array();
     $stage_ids   = array();
     if(!empty($task_ids))
     {
       $cond = 'task_id in (' . implode(',', $task_ids) . ')';
       $cols = array('id','task_id');
       $stages = $this->taskStageLogic->getCols($cond, $cols);
       foreach ($stages as $val)
       {
         $stage_ids[] = $val['id'];
         $stage_count[$val['task_id']][] = $val['id'];
       }
     }
     $queue = array();
     if(!empty($stage_ids))
     {
       $cond = 'task_stage_id in (' . implode(',', $stage_ids) . ') group by task_stage_id';
       $cols = array('task_stage_id','count(task_stage_id) as num');
       $tasklists = $this->taskListLogic->getCols($cond, $cols);
       foreach ($tasklists as $list)
       {
         $queue[$list['task_stage_id']] = $list['num'];
       }       
     }
     $queueByTask = array();
     foreach ($stage_count as $key => $item)
     {
       $queueByTask[$key] = 0;
       foreach ($item as $value)
       {
         if(isset($queue[$value]))
         {
           $queueByTask[$key] += $queue[$value];
         }
       }       
     }
     Core::$tpl->set('tasklist', $tasklist);
     Core::$tpl->set('stageCount', $stage_count);
     Core::$tpl->set('queueCount', $queueByTask);
   }
   /**
    * 编辑任务
    */
   public function actionEdit()
   {
     if(_p())
     {
        $task_id = Common::queryInt(_P('id'));
        $base_name = _p('base_name');
        $cond = 'id !='. $task_id. ' and base_name ="' . $base_name . '"';
        $count = $this->taskLogic->getCount($cond);
        if($count > 1)
        {
          return $this->showMessage('task_existed');
        }
        $data = array(
            'base_name'   => $base_name,           
            'listorder'   => Common::queryInt(_p('listorder')),
            'update_time' => SYS_TIME,
            'remark'      => _p('remark'),
        );
        $res = $this->taskLogic->save($data, $task_id);
        return $res ? $this->success('save_success', Common::adminURL('admin', 'task', 'list')) : $this->showMessage('save_failure');
     }
     else
     {
       $task_id = Common::queryInt(_g('id'));
       $task    = $this->taskLogic->getOneById($task_id);
       Core::$tpl->set('task', $task);
       Core::$htmlFile  = 'task/form';
       Core::$isdisplay = 0;
       Core::$tpl->render(Core::$htmlFile . '.htm');
     }
   }
   /**
    * 新增任务阶段
    * @return type 
    */
   public function actionAddStage()
   {
     if(_p())
     {
       $task_id = Common::queryInt(_p('task_id'));
       if(!$task_id)
       {
         return $this->showMessage('please_select_task');
       }
       $name = _p('base_name');
       $cond    = 'base_name="' . $name . '"';
       $count   = $this->taskStageLogic->getCount($cond);
       if($count > 1)
       {
          return $this->showMessage('task_task_stage_existed');
       }
       $data = array(
           'task_id'   => $task_id,
           'base_name' => _p('base_name'),
           'listorder' => Common::queryInt(_p('listorder')),
           'create_time' => SYS_TIME,
           'remark'      => _p('remark'),
       );
       $res = $this->taskStageLogic->save($data);
       return $res ? $this->success('save_success', Common::adminURL('admin', 'task', 'stageList')) : $this->showMessage('save_failure');
     }
     else
     {
        $task_id = Common::queryInt(_g('task_id'));
        Core::$tpl->set('tasklist', $this->taskLogic->findAll());
        Core::$tpl->set('task_id', $task_id);
        Core::$htmlFile  = 'task/stageform';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
     }
   }
   public function actionEditStage()
   {
      if(_p())
      {
        $stage_id = Common::queryInt(_p('id'));
        $task_id  = Common::queryInt(_p('task_id'));
        if(!$task_id)
        {
          return $this->showMessage('please_select_task');
        }
        $name  = _p('base_name');      
        $cond  = 'id !=' . $stage_id .' and base_name="' . $name . '"';
        $count = $this->taskStageLogic->getCount($cond);
        if($count > 1)
        {
            return $this->showMessage('task_task_stage_existed');
        }
        $data = array(
            'task_id'   => $task_id,
            'base_name' => _p('base_name'),           
            'listorder' => Common::queryInt(_p('listorder')),
            'update_time' => SYS_TIME,
            'remark'      => _p('remark'),
        );
        $res = $this->taskStageLogic->save($data, $stage_id);
        return $res ? $this->success('save_success', Common::adminURL('admin', 'task', 'stageList')) : $this->showMessage('save_failure');
      }
      else
      {
          $stage_id = Common::queryInt(_g('id'));
          $stage    = $this->taskStageLogic->getOneById($stage_id);
          if(!$stage)
          {
            return $this->showMessage('illegal_parameters');
          }
          Core::$tpl->set('task_stage', $stage);
          Core::$tpl->set('tasklist', $this->taskLogic->findAll());
          Core::$htmlFile  = 'task/stageform';
          Core::$isdisplay = 0;
          Core::$tpl->render(Core::$htmlFile . '.htm');
      } 
   }
   /**
    * 子任务列表 
    */
   public function actionStageList()
   {
     $task_id   = Common::queryInt(_g('task_id')); 
     $cond = '';
     if($task_id)
     {
       $cond = 'task_id=' . $task_id;
     }
     $stageList = $this->taskStageLogic->findALL($cond . ' order by task_id, listorder asc');
     $tasks     = $this->taskLogic->findAll('', true);
     $stage_ids = array();
     foreach ($stageList as $list)
     {
       $stage_ids[] = $list['id'];
     }
     $queue_count1 = array();
     $queue_count2 = array();
     $queue_count3 = array();
     $queue_count4 = array();
     if(!empty($stage_ids))
     {
       $cols = array('task_stage_id', 'count(task_stage_id) as num');
       $cond1 = 'task_stage_id in (' . implode(',', $stage_ids) . ') and status= 0 group by task_stage_id';
       $cond2 = 'task_stage_id in (' . implode(',', $stage_ids) . ') and status= 1 group by task_stage_id';
       $cond3 = 'task_stage_id in (' . implode(',', $stage_ids) . ') and status= 2 group by task_stage_id';
       $cond4 = 'task_stage_id in (' . implode(',', $stage_ids) . ') and status= 3 group by task_stage_id';
       $tasks1 = $this->taskListLogic->getCols($cond1, $cols);
       $tasks2 = $this->taskListLogic->getCols($cond2, $cols);
       $tasks3 = $this->taskListLogic->getCols($cond3, $cols);
       $tasks4 = $this->taskListLogic->getCols($cond4, $cols);
       foreach($tasks1 as $list1)
       {
         $queue_count1[$list1['task_stage_id']] = $list1['num'];
       }
       foreach($tasks2 as $list2)
       {
         $queue_count2[$list2['task_stage_id']] = $list2['num'];
       }
       foreach($tasks3 as $list3)
       {
         $queue_count3[$list3['task_stage_id']] = $list3['num'];
       }
       foreach($tasks4 as $list4)
       {
         $queue_count4[$list4['task_stage_id']] = $list4['num'];
       }
     }
     Core::$tpl->set('tasks', $tasks);
     Core::$tpl->set('res', $stageList);
     Core::$tpl->set('queue_count1', $queue_count1);
     Core::$tpl->set('queue_count2', $queue_count2);
     Core::$tpl->set('queue_count3', $queue_count3);
     Core::$tpl->set('queue_count4', $queue_count4);
   }
   /**
    *  信息处理
    */
   public function actionInfoDeal()
   {     
     $page  = Common::queryInt(_g('page'), 1);
     $psize = Common::queryInt(_g('psize'), 20);
     $task_stage_id = Common::queryInt(_g('task_stage_id'));
     $search_status = _g('search_status');
     $search_email  = _g('search_email');
     $where = '1=1';
     if($task_stage_id)
     {
      $where .= ' and task_stage_id=' . $task_stage_id;
     }  
     if(_g('search_status')!=='' && _g('search_status')!==NULL)
     {
         $where .= ' and status = ' . Common::queryInt($search_status);
     }
     if($search_email)
     {
       $where .= ' and base_name like"%' . $search_email . '%"';
     }
     $count = $this->taskListLogic->getCount($where);
     $page_data = Common::getPages($count, $page, $psize);
     $where .= ' order by create_time desc';
     $taskList  = $this->taskListLogic->getCurrentDatas($where, $psize, $page);
     $languages = $this->load('language')->findAll('', true);
     /*
     $result = array();
     foreach ($taskList as $value)
     {
       $params = json_decode($value['params'], true);
       $value['sent_to'] = $params['sent_to'];
       $result[] = $value;
     }
      * 
      */
     $search = array(
//         'task_id' => $task_id,
         'search_status' => $search_status,
         'search_email'  => $search_email,
     );
//   Core::$tpl->set('tasks', $tackLogic->findAll());
     Core::$tpl->set('res', $taskList);
     Core::$tpl->set('search', $search);
     Core::$tpl->set('languages', $languages);
     Core::$tpl->set('pages', $page_data);
     Core::$htmlFile = 'task/infolist';
     Core::$isdisplay = 0;
     Core::$tpl->render(Core::$htmlFile . '.htm');
   }
   /**
    * 删除一封邮件
    * @return type 
    */
   public function actionDelEmail()
   {
     $id = Common::queryInt(_g('id'));
     if($id)
     {
       $res = $this->taskListLogic->delete('id=' . $id);
       if($res)
       {
         return $this->success('delete_success');
       }
     }
     return $this->showMessage('delete_failure');
   }
   
   /**
     * 删除新闻，同步删除三张表记录
     * @return type
     */
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {
          
                $res  = $this->taskListLogic->delete('id=' . $id);
                if($res)
                {    
                  $num++;
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
}

?>
