<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Topic
 *
 * @author rongxiang.xie <QQ:1251679791,359285617 www.35zh.com>
 */
class TopicController extends AppController {

    private $topicLogic;
    private $topicTagLogic;
    private $topicLanguageLogic;
    private $topicTagLanguageLogic;
    private $topicTagGoodsRelLogic;

    public function __construct() {
        parent::__construct();
        $this->topicLogic = $this->load('topic');
        $this->topicTagLogic = $this->load('topicTag');
        $this->topicLanguageLogic = $this->load('topicLanguage');
        $this->topicTagLanguageLogic = $this->load('topicTagLanguage');
        $this->topicTagGoodsRelLogic = $this->load('topicTagGoodsRel');
    }

    public function actionAdd() {
        if (_p()) {
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('required_item');
            }

            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
                'update_time' => SYS_TIME,
            );
            $res = $this->topicLogic->saveByCond($data);
            if ($res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
                    $lang_data = array(
                        'language_id' => $key,
                        'topic_id' => $res,
                        'base_name' => Common::strEscape(_p('base_name' . $key)),
                        'top_html' => Common::strEscape(Inputer::getOrgPost('top_html' . $key), false),
                        'status' => Common::queryInt(_p('status' . $key)),
                        'listorder' => $listorder,
                        'title' => Common::strEscape(_p('title' . $key)),
                        'keywords' => Common::strEscape(_p('keywords' . $key)),
                        'descript' => Common::strEscape(_p('descript' . $key)),
                        'create_time' => SYS_TIME,
                    );
                    $this->topicLanguageLogic->saveByCond($lang_data);
                }
                $diy_url_flag = TRUE;

                $diyUrlLogic = $this->load('urlAlisa');
                $true_url = Common::frontURL('home', 'topic', 'detail', array('id' => $res), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                if ($diy_res) {
                    $new_cat_map = Zhtx::createDataMap();
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $this->topicLogic->updateById($new_cat_map, $res);
                } else {
                    $diy_url_flag = FALSE;
                }
                return $diy_url_flag ? $this->success('add_success', Common::adminURL('admin', 'topic', 'List')) : $this->showMessage('diy_url_already_exists');
            }
            return $this->error('add_failure', Common::adminURL('admin', 'topic', 'List'));
        } else {
            $tags = $this->topicTagLogic->findAll('status=1 order by listorder desc');
            $languages = $this->load('language')->findAll('status=1');
            Core::$tpl->set('tags', $tags);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'topic/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEdit() {
        if (_p()) {
            $topic_id = Common::queryInt(_p('id'));
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('required_item');
            }

            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
                'create_time' => SYS_TIME,
            );
            $res = $this->topicLogic->saveByCond($data, 'id=' . $topic_id);
            if ($res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
                    $lang_data = array(
                        'language_id' => $key,
                        'topic_id' => $topic_id,
                        'base_name' => Common::strEscape(_p('base_name' . $key)),
                        'top_html' => Common::strEscape( Inputer::getOrgPost('top_html' . $key), false),
                        'status' => Common::queryInt(_p('status' . $key)),
                        'listorder' => $listorder,
                        'title' => Common::strEscape(_p('title' . $key)),
                        'keywords' => Common::strEscape(_p('keywords' . $key)),
                        'descript' => Common::strEscape(_p('descript' . $key)),
                        'create_time' => SYS_TIME,
                    );
                    $this->topicLanguageLogic->saveByCond($lang_data, 'topic_id=' . $topic_id . ' and language_id=' . $key);
                }
                $diy_url_flag = TRUE;

                $diyUrlLogic = $this->load('urlAlisa');
                $true_url = Common::frontURL('home', 'topic', 'detail', array('id' => $topic_id), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                if ($diy_res) {
                    $new_cat_map = Zhtx::createDataMap();
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $this->topicLogic->updateById($new_cat_map, $topic_id);
                } else {
                    $diy_url_flag = FALSE;
                }

                return $diy_url_flag ? $this->success('edit_success', Common::adminURL('admin', 'topic', 'List')) : $this->showMessage('diy_url_already_exists');
            }
            return $this->success('edit_failure', Common::adminURL('admin', 'topic', 'List'));
        } else {
            $topic_id = Common::queryInt(_g('id'));
            $topic = $this->topicLogic->getOneById($topic_id);
            if (!$topic) {
                return $this->showMessage('not_found_record');
            }
            $cond = 'topic_id=' . $topic_id;
            $lang_data = array();
            $lang = $this->topicLanguageLogic->findAll($cond);
            foreach ($lang as $value) {
                $lang_data[$value['language_id']] = $value;
            }
            $tags = $this->topicTagLogic->findAll('status=1 order by listorder desc');
            $languages = $this->load('language')->findAll('status=1');

            Core::$tpl->set('topic', $topic);
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('lang_data', $lang_data);
            Core::$htmlFile = 'topic/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionList() {

        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $where = '1=1';
        $search_value = Common::strEscape(_g('search_value'));
        if ($search_value) {
            $where .= ' and base_name like "%' . $search_value . '%"';
        }
        $where .= " ORDER BY id DESC";
        $count = $this->topicLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->topicLogic->getCurrentDatas($where, $page_size, $curr_page);

        foreach ($res as $value) {
            $topic_ids[] = $value['id'];
            $tag_num[$value['id']] = 0;
        }
		if($topic_ids)
		{
			$tag_res = $this->topicTagLogic->findAll("topic_id in (" . join(',', $topic_ids) . ",0)");
			foreach ($tag_res as $value) {
				$tag_num[$value['topic_id']] ++;
			}
		}
        Core::$tpl->set("res", $res);
        Core::$tpl->set("tag_num", $tag_num);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $topic = $this->topicLogic->getOne('id='.$id);
                    $this->load('urlAlisa')->deleteDiyUrl($topic['page_url']);
                $res = $this->topicLogic->delete('id=' . $id);
                $this->topicLanguageLogic->delete('topic_id=' . $id);
                $this->topicTagGoodsRelLogic->delete('topic_id=' . $id);

                $topic_tags = $this->topicTagLogic->findAll('topic_id=' . $id . " order by listorder desc");
                $tags_ids = array();
                $tags_ids[] = 0;
                foreach ($topic_tags as $value) {
                    $tags_ids[] = $value['id'];
                }
                $this->topicTagLanguageLogic->delete("topic_tag_id in (" . join(',', $tags_ids) . ")");
                $this->topicTagLogic->delete('topic_id=' . $id);
                $this->topicTagGoodsRelLogic->delete("topic_id in (" . join(',', $tags_ids) . ")");
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionDelTag() {
        $tag_id = Common::queryInt(_g('id'));
        $topic_id = Common::queryInt(_g('topic_id'));
        $this->topicTagGoodsRelLogic->delete('topic_id=' . $topic_id);
        $this->topicTagLanguageLogic->delete('topic_tag_id=' . $tag_id);
        $this->topicTagLogic->delete('id=' . $tag_id);
        return $this->success('del_success', Common::adminURL('admin', 'topic', 'tagList', array('topic_id' => $topic_id)));
    }

    public function actionDelGoods() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->topicTagGoodsRelLogic->delete('id=' . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionAddTag() {
        if (_p()) {
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('required_item');
            }
            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
                'topic_id' => Common::queryInt(_g('topic_id')),
                'create_time' => SYS_TIME,
            );
            $tag_res = $this->topicTagLogic->saveByCond($data);
            if ($tag_res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
                    $lang_data = array(
                        'language_id' => $key,
                        'topic_tag_id' => $tag_res,
                        'base_name' => Common::strEscape(_p('base_name' . $key)),
                        'status' => Common::queryInt(_p('status' . $key)),
                        'listorder' => $listorder,
                        'create_time' => SYS_TIME,
                    );
                    $this->topicTagLanguageLogic->saveByCond($lang_data);
                }

                return $this->success('add_success', Common::adminURL('admin', 'topic', 'tagList', array('topic_id' => _g('topic_id'))));
            }
            return $this->error('add_failure', Common::adminURL('admin', 'topic', 'tagList', array('topic_id' => _g('topic_id'))));
        } else {
            $topic_id = Common::queryInt(_g('topic_id'));
            $topic = $this->topicLogic->getOneById($topic_id);
            if (!$topic) {
                return $this->error('id_error', Common::adminURL('admin', 'topic', 'list'));
            }
            $languages = $this->load('language')->findAll('status=1');
            Core::$tpl->set('topic', $topic);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'topic/tagform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionEditTag() {
        if (_p()) {
            $tag_id = Common::queryInt(_p('id'));
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('required_item');
            }
            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
                'create_time' => SYS_TIME,
            );
            $tag_res = $this->topicTagLogic->saveByCond($data, 'id=' . $tag_id);
            if ($tag_res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
                    $lang_data = array(
                        'language_id' => $key,
                        'topic_tag_id' => $tag_id,
                        'base_name' => Common::strEscape(_p('base_name' . $key)),
                        'status' => Common::queryInt(_p('status' . $key)),
                        'listorder' => $listorder,
                        'create_time' => SYS_TIME,
                    );
                    $cond = 'topic_tag_id=' . $tag_id . ' and language_id=' . $key;
                    $this->topicTagLanguageLogic->saveByCond($lang_data, $cond);
                }
                return $this->success('edit_success', Common::adminURL('admin', 'topic', 'tagList', array('topic_id' => _g('topic_id'))));
            }
            return $this->error('edit_failure', Common::adminURL('admin', 'topic', 'tagList', array('topic_id' => _g('topic_id'))));
        } else {
            $topic_id = Common::queryInt(_g('topic_id'));
            $topic = $this->topicLogic->getOneById($topic_id);
            if (!$topic) {
                return $this->error('id_error', Common::adminURL('admin', 'topic', 'list'));
            }
            $tag_id = Common::queryInt(_g('id'));
            $tag = $this->topicTagLogic->getOneById($tag_id);
            if (!$tag) {
                return $this->showMessage('not_found_record');
            }
            $tag_cond = 'topic_tag_id=' . $tag_id;
            $lang_data = array();
            $lang = $this->topicTagLanguageLogic->findAll($tag_cond);
            foreach ($lang as $value) {
                $lang_data[$value['language_id']] = $value;
            }
            $languages = $this->load('language')->findAll('status=1');
            Core::$tpl->set('topicTag', $tag);
            Core::$tpl->set('topic', $topic);
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('langtag', $lang_data);
            Core::$htmlFile = 'topic/tagform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionTagList() {
        $topic_id = Common::queryInt(_g('topic_id'));
        $topic = $this->topicLogic->getOneById($topic_id);
        if (!$topic) {
            return $this->error('id_error', Common::adminURL('admin', 'topic', 'list'));
        }
        $res = $this->topicTagLogic->findAll('topic_id=' . $topic_id . " order by listorder desc");
        if ($res) {
            foreach ($res as $value) {
                $tag_ids[] = $value['id'];
                $good_num[$value['id']] = 0;
            }
            $tag_res = $this->topicTagGoodsRelLogic->findAll("topic_tag_id in (" . join(',', $tag_ids) . ",0)");
            foreach ($tag_res as $value) {
                $good_num[$value['topic_tag_id']] ++;
            }
            Core::$tpl->set("good_num", $good_num);
        }
        Core::$tpl->set('res', $res);
        Core::$tpl->set('topic', $topic);
        Core::$htmlFile = 'topic/taglist';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    public function actionShowTagGoods() {
        $topic_id = Common::queryInt(_g('topic_id'));
        $topic_tag_id = Common::queryInt(_g('tag_id'));
        $topic = $this->topicLogic->getOneById($topic_id);
        $topicTag = $this->topicTagLogic->getOneById($topic_tag_id);
        $Exist_goods = $this->topicTagGoodsRelLogic->findAll('topic_tag_id=' . $topic_tag_id . " order by listorder desc");

        $Exist_goods_ids = array();
        foreach ($Exist_goods as $value) {
            $Exist_goods_ids[$value['goods_id']] = $value['goods_id'];
        }
        $results = array();
        $rel_categories = array();
        if (count($Exist_goods_ids)) {
            $cond = 'id in (' . implode(',', $Exist_goods_ids) . ')';
            $results = $this->load('goods')->findAll($cond, true);

            $c_cond = 'g.goods_id in(' . implode(',', $Exist_goods_ids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
        $type_ids = array();
        foreach ($results as $value) {
            $type_ids[$value['goods_type_id']] = $value['goods_type_id'];
        }
        $goods_types = array();
        if (count($type_ids) > 0) {
            $goods_types = $this->load('goodsType')->findAll('id in (' . implode(',', $type_ids) . ')', true);
        }
        foreach ($Exist_goods as $key => $value) {
            $Exist_goods[$key]["good"] = $results[$value['goods_id']];
        }
        Core::$tpl->set("res_rel", $Exist_goods);
        Core::$tpl->set("res", $results);
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("brands", $this->load('brand')->findAll('', true));
        Core::$tpl->set('topic', $topic);
        Core::$tpl->set('topicTag', $topicTag);
        Core::$htmlFile = 'topic/taggoods';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    public function actionPublicEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');

        $data['status'] = $status;
        $cond = 'topic_id=' . $id;
        $this->topicLanguageLogic->saveByCond($data, $cond);
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->topicLogic->updateById($map, $id);


        echo $res ? 1 : 0;
    }

    public function actionPublishGoods() {
        $topic_id = Common::queryInt(_g('topic_id'));
        $topic_tag_id = Common::queryInt(_g('tag_id'));
        $goods_ids = _p('ids');
        $goodsLogic = $this->load('goods');
        if (!$goods_ids) {
            echo json_encode(array('status' => 0, 'msg' => '请先选择商品！'));
            return;
        }
        $Exist_goods = $this->topicTagGoodsRelLogic->findAll('topic_id=' . $topic_id . ' and topic_tag_id=' . $topic_tag_id);
        $Exist_goods_ids = array();
        foreach ($Exist_goods as $value) {
            $Exist_goods_ids[$value['goods_id']] = $value['goods_id'];
        }
        $goods_ids_arr = explode(',', $goods_ids);
        $new_goods = array_diff($goods_ids_arr, $Exist_goods_ids);
        foreach ($new_goods as $value) {
            if ($goodsLogic->getOne('id=' . $value)) {
                $data = array(
                    'topic_id' => $topic_id,
                    'topic_tag_id' => $topic_tag_id,
                    'goods_id' => $value,
                );
                $res = $this->topicTagGoodsRelLogic->saveByCond($data);
                $this->topicTagGoodsRelLogic->saveByCond(array('listorder' => $res), 'id=' . $res);
            }
        }
        echo json_encode(array('status' => 1, 'msg' => '添加成功！'));
        return;
    }

    public function actionPublicQuickEdit() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        if (!is_numeric(_p('listorder'))) {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        if ($listorder)
            $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->topicTagLogic->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }

    public function actionPublicEditTagStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');

        $data['status'] = $status;
        $cond = 'topic_tag_id=' . $id;
        $res = $this->topicTagLanguageLogic->saveByCond($data, $cond);

        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->topicTagLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    public function actionPublicQuickEditTagsRel() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        if (!is_numeric(_p('listorder'))) {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        if ($listorder)
            $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->topicTagGoodsRelLogic->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }

}

?>
