<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author xrx
 */
class UploadController extends AppController
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * 弹窗
     * @global type $cfg
     */
    public function actionPublicDialog()
    {
        global $cfg;
        $folder = Common::queryStr(_g('folder'));
        $last_char = substr($folder, -1);
        if ($last_char != "/")
            $folder .="/";
        $targetdir = UPLOAD_DIR . $folder;
        if (_s('last_visit_folder'))
        {
            $fl_c = explode('/', $folder);
            if (count($fl_c) < 3)
            {
                $targetdir = _s('last_visit_folder');
            }
        }
        $upload_imgs = _g('default_file') ? _g('default_file') : 0;
        if ($upload_imgs)
        {
            $list_images = split(',', $upload_imgs);
            $targetdir = dirname($list_images[0]) . "/";
        }
        if ($folder == 'goods/' && $cfg['sites'][0]['upload_config'] == "1" && $targetdir == UPLOAD_DIR . $folder)
        {
            $targetdir = UPLOAD_GOODS_DIR . date('Y', SYS_TIME) . '/' . date('m', SYS_TIME) . '/' . date('d', SYS_TIME) . '/';
        }
        $data = array(
            'opendir' => UPLOAD_DIR,
            'targetdir' => $targetdir,
            'type' => Common::queryInt(_g('type')),
            'display_mode' => Common::queryInt(_g('display_mode')),
            'pagesize' => Common::queryInt(_g('pagesize'), 52),
            'method_name' => Common::queryStr(_g('method_name')),
            'editor_index' => _g('editor_index'),
            'upload_imgs' => _g('default_file'),
        );
        _setSession('last_visit_folder', $targetdir);
        Common::rmkdir($data['targetdir']);
        $showurl = Common::adminURL('admin', 'upload', 'publicOpen', $data);
        Core::$tpl->set('tageturl', $showurl);
        Core::$htmlFile = 'upload/dialog';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 获得目录树
     */
    public function getDirTree($directory, $open_dir)
    {
        $data = array(
            'type' => Common::queryInt(_g('type')),
            'display_mode' => Common::queryInt(_g('display_mode')),
            'pagesize' => Common::queryInt(_g('pagesize'), 52),
            'method_name' => Common::queryStr(_g('method_name')),
            'editor_index' => _g('editor_index'),
        );
        $showurl = Common::adminURL('admin', 'upload', 'publicOpen', $data);
        $dirTree = "<ul>";
        foreach ($directory as $v)
        {
            if (strtolower($v['name']) == 'system')
            {
                continue;
            }
            if (count($v['subdir']))
            {
                $classStyle = "root";
            }
            else
            {
                $classStyle = "not";
            }

            $curStyle = '';
            if (_g('targetdir') == $v['path'])
            {
                $curStyle = 'cur';
            }
            $marginWidth = substr_count($v['path'], '/');
            $marginWidth = ($marginWidth - 1) * 10;
            $openurl = $showurl . '&opendir=' . $open_dir . '&targetdir=' . $v['path'];
            $dirTree .= "<li>
				  <a href='" . $openurl . "' rel='{$v['path']}' class='{$curStyle}'><span style='margin-left:{$marginWidth}px' class='{$classStyle}'>{$v['name']}</span></a>";
            if (count($v['subdir']))
            {
                $dirTree .= $this->getDirTree($v['subdir'], $open_dir);
            }
            $dirTree .= "</li>";
        }
        $dirTree .= "</ul>";
        return $dirTree;
    }

    /*
     * 打开一个文件夹
     */

    public function actionPublicOpen()
    {
        $open_dir = UPLOAD_DIR; //_g('opendir');
        $tag_dir = _g('targetdir');
        $orderby = Common::queryInt(_g('o'), 1);
        $sign = Common::queryStr(_g('t'));
        $search = '';
        $data = array(
            'type' => Common::queryInt(_g('type')),
            'display_mode' => Common::queryInt(_g('display_mode')),
            'pagesize' => Common::queryInt(_g('pagesize'), 52),
            'method_name' => Common::queryStr(_g('method_name')),
            'editor_index' => _g('editor_index'),
            'page' => Common::queryStr(_g('page'), 1),
        );
        if ($sign && md5($tag_dir) == $sign)
        {
            $search = _g('s');
        }

        $upload_imgs = _p('upload_imgs') ? _p('upload_imgs') : 0;

        _setSession('last_visit_folder', $tag_dir);
        $showurl1 = Common::adminURL('admin', 'upload', 'publicOpen', $data) . '&opendir=' . $open_dir;
//        $dir_data  = $data;
//        unset($dir_data['page']);
//        $show_dir_url = Common::adminURL('admin', 'upload', 'publicOpen', $dir_data) . '&opendir=' . $open_dir;
        $showurl = $showurl1 . '&targetdir=' . $open_dir . '&o=' . $orderby . '&s=' . $search . '&t=' . $sign;
        //文件夹的路径都是不变的.所以可以直接使用初始路径        
        $directory = Dir::getDirectory($open_dir, $tag_dir);
        $dirTree = "<ul><li><a class='root' href='" . $showurl . "' rel='{$open_dir}'>{$open_dir}</a>";
        $dirTree .= $this->getDirTree($directory, $open_dir);
        $dirTree .= '</li></ul>';
        $uploadurl = urlencode(ADMIN_UPLOAD_URL . '&folder=' . $tag_dir . '&session_id='.session_id());
        $this->loadImg($tag_dir, $data['display_mode'] == 0 ? 'pic' : 'table', $data['pagesize'], $data['page'], $upload_imgs, $orderby, $search);
        $langLogic = $this->load('language');
        $lang_res = $langLogic->getOne("domain_name like '".strtolower(SITE_URL)."'");
        //var_dump($lang_res);
        if(!$lang_res)
        {
            $language_list = $langLogic->findAll('status=1', true);
            foreach ($language_list as $list)
            {
                $alias_domain = str_replace(array("\r\n", "\r", "\n"), array(",", "", ","), $list['alias_domain']);
                $arr_alias_domain = split(",", $alias_domain);
                if (in_array(SITE_URL, $arr_alias_domain) && SITE_URL != $list['domain_name'])
                {
                    $language_id = $list['id'];
                    break;
                }
            }
        }
        else
        {
            $language_id = $lang_res['id'];
        }
        Core::$tpl->set('language_id', $language_id);
        Core::$tpl->set('directory', $dirTree);
        Core::$tpl->set('uploadurl', $uploadurl);
        Core::$tpl->set('targetdir', $tag_dir);
        Core::$tpl->set('select_type', $data['type']);
        Core::$tpl->set('method_name', $data['method_name']);
        Core::$tpl->set('editor_index', $data['editor_index']);
        Core::$tpl->set('cur_url', $showurl1 . '&targetdir=' . $tag_dir . '&o=' . $orderby);
        Core::$tpl->set('order_url', $showurl1 . '&targetdir=' . $tag_dir);
        Core::$htmlFile = 'upload/showdialog';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 读取目录图片
     * @param type $path
     * @param type $display_mode
     * @param type $pagesize
     * @param type $page
     * @param type $upload_imgs
     * @param type $orderby
     * @param type $search_name
     */
    public function loadImg($path, $display_mode, $pagesize = 52, $page = 1, $upload_imgs = 0, $orderby = 1, $search_name = '')
    {
        $imglist = Dir::getImgList($path, $orderby, $search_name); //获得图片列表
        $curr_page = $page;
        $page_size = $pagesize;
        $count = count($imglist);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set("pages", $page_data);
        $start_index = $pagesize * ($curr_page - 1);
        if (count($imglist) > 0)
        {
            $curr_imglist = array_slice($imglist, $start_index, $page_size);
        }
        else
        {
            $curr_imglist = array();
        }
        $imgTree = $this->getImgTree($curr_imglist, $display_mode, $upload_imgs); //获得前台html

        Core::$tpl->set('imglist', $imgTree);
    }

    /**
     * 获得图片树
     * @param array imglist 图片列表
     * @param string liststyle 生成的html格式,是图片还是文本列表
     * @notic 请确保php页面和html页面的编码一致,不然会返回NULL
     */
    public function getImgTree($imglist = array(), $liststyle = 'pic', $upload_imgs = 0)
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        if (count($imglist))
        {
            $upload_img_array = $upload_imgs ? explode(',', $upload_imgs) : array();
            switch ($liststyle)
            {
                case 'pic':
                    $imgTree = '<ul class="u_gallery_pic">';
                    //$i = 1;
                    foreach ($imglist as $v)
                    {
                        $img_src = $v['imgpath'];
                        $type = strtolower($v['type']);
                        if (in_array($type, array('jpg', 'jpeg', 'png', 'gif', 'bmp')))
                        {
                            //$img_src    = str_replace('#','%23',($img_src)); 
                            $img_src = str_replace('upload/', '', $img_src);
                            $path_parts = pathinfo($img_src);
                            if($path_parts['dirname'] && $path_parts['dirname']!='.')
                               $img_src = $path_parts['dirname'] . '/' . rawurlencode(rawurlencode(($path_parts['filename']))) . '.' . $path_parts['extension'];
                            else
                               $img_src =  rawurlencode(rawurlencode(($path_parts['filename']))) . '.' . $path_parts['extension'];
                            $img_src = 'upload/thumb/84x84/'. $img_src;
                        }
                        else if (in_array($type, array('zip', 'jar', 'rar', '7z', 'cab', 'bz2')))
                        {
                            $img_src = 'upload/system/package.png';
                        }
                        else if (in_array($type, array('doc', 'xdoc', 'csv', 'xls')))
                        {
                            $img_src = 'upload/system/office.png';
                        }
                        else if ($type == 'pdf')
                        {
                            $img_src = 'upload/system/pdf.png';
                        }
                        else if ($type == 'txt')
                        {
                            $img_src = 'upload/system/txt.png';
                        }
                        else if ($type == 'swf')
                        {
                            $img_src = 'upload/system/video.png';
                        }
                        else if ($type == 'folder')
                        {
                            $img_src = 'upload/system/folder.png';
                        }
                        else
                        {
                            $img_src = 'upload/system/other.png';
                        }

                        $checked = '';
                        $selected = '';
                        $name_selected = '';
                        $display = '';
                        if (in_array($v['imgpath'], $upload_img_array))
                        {
                            $checked = ' hidefocus="true" checked="checked"';
                            $selected = ' class="selected"';
                            $name_selected = ' name_selected';
                            $display = ' style="display: block;"';
                        }
                        $path_parts = pathinfo($v['imgpath']);
                        if($path_parts['dirname'])
                        {
                            $path_parts_img = $path_parts["dirname"].'/'.$path_parts["basename"];
                        }
                        else 
                        {
                            $path_parts_img = $path_parts["basename"];
                        }
                        $v["imgpath"] = $path_parts["dirname"].'/'.rawurlencode($path_parts["basename"]);
                        if($type == 'folder')
                        {
                        $imgTree .= '<li' . $selected . '><a href="'.$this->getCurrentUrl($v['imgpath'].'/').'"><div class="checked"' . $display . '></div><div class="pic" title="' . $v['name'] .
                                '"><img src="' . $img_src . '" /></div><div class="name' . $name_selected . '" title="' . $v["name"] . '">' . substr($v['name'], 0, 15) . '</div></a>'; //onload='resizeimg(this, 118, 118)'
                        $imgTree .= '<input type="checkbox" name="returnimg[]" value="' . $path_parts_img . '"' . $checked . '/></li>';
                        }
                        else
                        {
                        $imgTree .= '<li' . $selected . '><div class="checked"' . $display . '></div><div class="pic" title="' . $v['name'] .
                                '"><img src="' . $img_src . '" /></div><div class="name' . $name_selected . '" title="' . $v["name"] . '">' . substr($v['name'], 0, 15) . '</div>'; //onload='resizeimg(this, 118, 118)'
                        $imgTree .= '<input type="checkbox" name="returnimg[]" value="' . $path_parts_img . '"' . $checked . '/></li>';
                        }
                    }
                    $imgTree .= '</ul>';
                    break;
                case 'table':
                    $imgTree = "<table cellpadding='0' cellspacing='0' width='100%' class='u_gallery_table'>";
                    $imgTree .= "<thead>";
                    $imgTree .= "<tr><td width='50'></td><td>" . $lang['albums_img_name'] . "</td><td align='center' width='100'>" . $lang['albums_img_size'] . "</td><td align='center' width='130'>" . $lang['albums_img_time'] . "</td></tr>";
                    $imgTree .= "</thead>";
                    $imgTree .= "<tbody>";
                    foreach ($imglist as $v)
                    {
                        $cheked = '';
                        $selected = '';
                        if (in_array($v['imgpath'], $upload_img_array))
                        {
                            $cheked = 'hidefocus="true" checked="checked"';
                            $selected = 'bwCheckboxSelected';
                        }
                        if(strtolower($v['type']) == 'folder')
                        {
                        $imgTree .='<tr><td align="center"></td><td><a href="'.$this->getCurrentUrl($v['imgpath'].'/').'">' . $v['name'] . '</a></td><td align="center">' . $v['size'] . '</td><td align="center">' . $v['time'] . '</td></tr>';
                        }
                        else
                        {
                        $imgTree .='<tr><td align="center"><label class="bwCheckbox ' . $selected . '"><input type="checkbox" name="returnimg[]" value="' . $v['imgpath'] . '" ' . $cheked . '/></label></td><td>' . $v['name'] . '</td><td align="center">' . $v['size'] . '</td><td align="center">' . $v['time'] . '</td></tr>';
                        }
                    }
                    $imgTree .= '</tbody></table>';

                    break;
            }

            return $imgTree;
        }

        return false;
    }

    /**
     * 创建一个新的目录
     * @return type
     */
    public function actionPublicCreateDir()
    {
        $dir = _p('dir_name');
        $current_dir = _p('current_dir');
        $path = $current_dir;
        if ($dir)
        {
            if(substr($current_dir, 0, strlen(UPLOAD_DIR))!=UPLOAD_DIR)
            {
                $current_dir = UPLOAD_DIR.$current_dir;
            }
            $path = $current_dir . $dir . '/';
            $arr_check = array('&', '"', "'", '`', '.', ',', '(', ')', '+', '#', ":", " ", "<", ">", "*", "?", "|", '\\', '%');
            $arr_replace = array_fill(0, count($arr_check), '-');
            $path = str_replace($arr_check, $arr_replace, $path);
            Common::rmkdir($path);
        }
        header("location:" . $this->getCurrentUrl($path));
        return;
    }

    /**
     * 文件搜索
     * @return type
     */
    public function actionPublicSearch()
    {
        $search = _p('search_name') ? _p('search_name') : '';
        $sign = md5(_p('dir'));
        $url = '';
        if (_p('target_url'))
        {
            $url = _p('target_url') . '&s=' . $search . '&t=' . $sign;
        }
        header("location:" . $url);
        return;
    }

    /**
     * 获取当前路径
     * @param type $path
     * @return string
     */
    function getCurrentUrl($path)
    {
        $url = $_SERVER['HTTP_REFERER'];
        $querystring = substr(strstr($url, '?'), 1);
        parse_str($querystring, $pars);
        $query_array = array();
        foreach ($pars as $k => $v)
        {
            if ($k == 'targetdir')
            {
                $v = $path;
            }
            $query_array[$k] = $v;
        }
        $querystring = http_build_query($query_array);
        $url = ADMIN_ROOT . '?' . $querystring;

        return $url;
    }

    public function actionPublicTest()
    {
        Core::$htmlFile = 'upload/test';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 获取图片大小
     */
    public function actionGetImageSize()
    {
        $file = _p("file");
        $arr_size = array("width" => 0, "height" => 0);
        if (is_file(APP_ROOT . $file))
        {
            $arr = getimagesize(APP_ROOT . $file);
            $arr_size["width"] = $arr[0];
            $arr_size["height"] = $arr[1];
        }
        echo json_encode($arr_size);
        exit();
    }

    /**
     * 删除一张图片
     */
    public function actionRemoveImg()
    {
        $file = str_replace('upload/thumb/84x84/', 'upload/', _p("file"));
        if (@unlink($file) && strpos($file, '/thumb/') === FALSE)
        {
            $image_base_path = APP_ROOT . UPLOAD_DIR;
            $file_name = str_replace($image_base_path, '', $file);
            $file_name = str_replace('upload/', '', $file_name);
            $thumb_dir = $image_base_path . 'thumb/';
            if ($fp = @opendir($thumb_dir))
            {
                while ($hander = readdir($fp))
                {
                    if ($hander != '.' && $hander != '..' && substr($hander, 0, 1) != '.')
                    {
                        $thubm_file = $thumb_dir . $hander . '/' . $file_name;
                        if (is_file($thubm_file))
                        {
                            @unlink($thubm_file);
                        }
                    }
                }
                closedir($fp);
            }
        }
        else
        {
            @unlink($file);
        }
            
    }

    /**
     * folder 默认系统上传目录
     * type 默认0 批量上传 1 单张上传
     * display_mode 默认0 图片 1列表
     * pagesize 默认52
     * method_name 函数名称 
     */
    public function actionPublicShow()
    {
        global $cfg;
        ////判断是否设定自动创建目录
        $auto_create = $cfg['sites'][0]['upload_config'];
        $folder = Common::queryStr(_g('folder'));
        $type = Common::queryInt(_g('type'));
        $display_mode = Common::queryInt(_g('display_mode'));
        $pagesize = Common::queryInt(_g('pagesize'), 52);
        $method_name = Common::queryStr(_g('method_name'), 0);
        $page = Common::queryInt(_g('page'), 1);
        $editor_index = _g('editor_index');
        $upload_imgs = _g('upload_imgs') ? _g('upload_imgs') : 0;
        $dirPath = '' . UPLOAD_DIR;
        $open_dir = '' . UPLOAD_DIR;

        if ($folder == 'goods/')
        {
            if ($auto_create)
            {
                $dirPath = UPLOAD_GOODS_DIR . date('Y', SYS_TIME) . '/' . date('m', SYS_TIME) . '/' . date('d', SYS_TIME) . '/';
            }
            else
            {
                //$open_dir .= UPLOAD_GOODS_DIR;
                $dirPath = $open_dir;
            }
        }
        else if ($folder)
        {
            $open_dir = $dirPath;
            $dirPath .= $folder . '/';
        }
        Common::rmkdir($dirPath);
        $showurl = Common::adminURL('admin', 'upload', 'publicOpen') . '&type=' . $type .
                '&display_mode=' . $display_mode . '&pagesize=' . $pagesize . "&method_name=" . $method_name . "&editor_index=" . $editor_index;
        //文件夹的路径都是不变的.所以可以直接使用初始路径
        $directory = Dir::getDirectory($open_dir, $dirPath);
        $dirTree = "<ul><li><a class='root' href='" . $showurl . '&opendir=' . UPLOAD_DIR . '&targetdir=' . UPLOAD_DIR . "' rel='{$open_dir}'>{$open_dir}</a>";
        $dirTree .= $this->getDirTree($directory, $open_dir);
        $dirTree .= '</li></ul>';
        $uploadurl = urlencode(ADMIN_UPLOAD_URL . '&folder=' . UPLOAD_DIR . $folder . "/". '&session_id='.session_id());
        $this->loadImg($dirPath, $display_mode == 0 ? 'pic' : 'table', $pagesize, $page, $upload_imgs);
        Core::$tpl->set('directory', $dirTree);
        Core::$tpl->set('uploadurl', $uploadurl);
        Core::$tpl->set('targetdir', $dirPath);
        Core::$tpl->set('select_type', $type);
        Core::$tpl->set('method_name', $method_name);
        Core::$tpl->set('editor_index', $editor_index);
        Core::$htmlFile = 'upload/showdialog';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

}

?>
