<?php
/**
 * @author HHH
 */
class UploaddialogController extends AppController
{
	private $dirPath = './upload/';		//初始路径
    public function __construct() {
        parent::__construct();
    }
	
	public function actionShowdialog()
    {   
		Core::$tpl->set('dirPath', $this->dirPath); //这个初始化js 中的路径
    }

    public function actionPublicDialog()
    {   
		//文件夹的路径都是不变的.所以可以直接使用初始路径
		$directory = Dir::getDirectory($this->dirPath);
		$dirTree = "<ul><li><a class='root' href='###' rel='{$this->dirPath}'>{$this->dirPath}</a>";
		$dirTree .= $this->getDirTree($directory);
		$dirTree .= '</li></ul>';	
		Core::$tpl->set('directory', $dirTree);
        Core::$htmlFile  = 'uploaddialog/dialog';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }
	
	public function actionLoadimg(){
		$query = '';
		if($path = _g('path')){ //图片路径
			$query .='&path='.$path;	
		}
		if($pagesize = _g('pagesize') ? _g('pagesize') : 20){ ///每页显示条数
			$query .='&pagesize='.$pagesize;	
		}
		$page = _g('page') ? _g('page') : 1; //获得当前页数
		if($liststyle = _g('liststyle')){ //获得显示样式
			$query .='&liststyle='.$liststyle;	
		}
		
		$imglist = Dir::getImgList($path); //获得图片列表
		$pageCount = ceil(count($imglist) / $pagesize); //获得总页数
		$thisKeyOffset = ($page - 1) * $pagesize; //获得当前图片的key offset 根据数组下标来分页
		//过滤page合法性
		$page = $page < 1 ? 1 : $page;
		$page = $page > $pageCount ? $pageCount : $page;
		$list = array_slice($imglist, $thisKeyOffset, $pagesize); ///获得最终图片数据列表
		
		/*获得分页html*/
		$pageShowLimit = 5; //每页显示几个分页按钮
		$pageGroup = array_chunk(range(1, $pageCount), $pageShowLimit); //获得所有分页组
		$thisPageGroup = floor($page/($pageShowLimit+1));  //获得当前页所属组,分组下标是从0开始的,所以用floor
		
		$pageHtml = '';
		//获得往左按钮
		if(($goLeft = $page - 1) > 0){
			$pageHtml .= "<a class='goleft' href='###' rel='admin.php?m=admin&c=uploaddialog&a=loadimg&page={$goLeft}{$query}'><span></span></a>";	
		}
		
		if($pageGroup[$thisPageGroup]){ //如果存在当前分组
			foreach($pageGroup[$thisPageGroup] as $key=>$value){
				$style = '';
				if($value == $page){//如果是当前页,则不需要有链接了
					$pageHtml .= "<a class='cur' href='###' rel=''><span>{$value}</span></a>";	
				}else{
					$pageHtml .= "<a {$style} href='###' rel='admin.php?m=admin&c=uploaddialog&a=loadimg&page={$value}{$query}'><span>{$value}</span></a>";	
				}
			}
		}
		
		//获得往右按钮
		if(($pageCount - $page) > 0 && ($goRight = $page + 1) <= $pageCount){
			$pageHtml .= "<a class='goright' href='###' rel='admin.php?m=admin&c=uploaddialog&a=loadimg&page={$goRight}{$query}'><span></span></a>";		
		}
		
		$imgTree = $this->getImgTree($list, $liststyle); //获得前台html
		if($imgTree){
			$data['status'] = 1;
			$data['page'] = $pageHtml;//str_replace('> <','><',$pageHtml);
			$data['imgTree'] = $imgTree; //$thisPageGroup;
			$this->ajaxReturn($data);
		}else{
			$data['status'] = 0;
			$data['message'] = Common::L('not_file');
			$this->ajaxReturn($data);
		}
	}
	
	/**
	* 获得图片树
	* @param array imglist 图片列表
	* @param string liststyle 生成的html格式,是图片还是文本列表
	* @notic 请确保php页面和html页面的编码一致,不然会返回NULL
	*/
	public function getImgTree($imglist = array(), $liststyle = 'pic'){
		if(count($imglist)){
			switch($liststyle){
				case 'pic':
					$imgTree = '<ul>';
					  $i = 1;
					  foreach($imglist as $v){
						 $imgTree .= "<li><div class='checked'></div><span class='pic'><img onload='resizeimg(this, 115, 85)' src='{$v['imgpath']}' /></span><span class='name'>{$v['name']}</span><input type='checkbox' name='returnimg[]' value='{$v['imgpath']}' /></li>";
						  if($i % 4 == 0){
						   $imgTree .= "<li class='other'></li>";
						  }
						  $i++;
					  }
				   $imgTree .= '</ul>';
				break;
				case 'table':
				$imgTree = "<table cellpadding='0' cellspacing='0' width='100%' class='uploadtable'>";
				$imgTree .= "<thead>";
				$imgTree .=	"<tr><td width='50'></td><td>名称</td><td align='center' width='100'>大小</td><td align='center' width='130'>修改时间</td></tr>";
				$imgTree .=	"</thead>";
				$imgTree .=	"<tbody>";
				foreach($imglist as $v){
					$imgTree .= "<tr><td align='center'><input type='checkbox' name='returnimg[]' value='{$v['imgpath']}' /></td><td>&nbsp;{$v['name']}</td><td align='center'>{$v['size']}</td><td align='center'>{$v['time']}</td></tr>";
				}
				$imgTree .= '</tbody></table>';
				
				break;
			}
		   
		   return $imgTree;
		}
		
		return false;
	}
	
	/**
	* 获得目录树
	*/
	public function getDirTree($directory){
	 	 $dirTree = "<ul>";
		 foreach($directory as $v){
		   if(count($v['subdir'])){
			  $classStyle = "root";	 
		   }else{
			  $classStyle = "not";	 
		   }
		   $dirTree .= "<li>
				  <a href='###' rel='{$v['path']}' class='{$classStyle}'>{$v['name']}</a>";
				   if(count($v['subdir'])){
					  $dirTree .= $this->getDirTree($v['subdir']); 
				  }
		  $dirTree .= "</li>";
		 }
	 	 $dirTree .= "</ul>";
		  return $dirTree;
	  }
	
	/**
	* 创建文件夹
	*/
	public function actionMkdirs(){
		if(_p()){
			$fatherPath = _p('fatherpath');
			$dirPath = _p('dirpath');
			$path = $fatherPath.$dirPath;
			
			if(Dir::mkdirs($path)){
				$data['status'] = 1;
				$this->ajaxReturn($data);
			}else{
				$data['status'] = 0;
				$this->ajaxReturn($data);	
			}
		}
	}
}
?>