<?php

/**
 * Description of DiyUrlController
 *
 * @author czy
 */
class UrlAlisaController extends AppController {

    public function __construct() {
        parent::__construct();
        $this->urlAlisaLogic = $this->load('urlAlisa'); //引入iplistLogic.php，返回实例化对象
    }

    public function actionList() {

        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $where = '1=1';
        if (_g('url')) {
            $where .= " and url like '%" . _g('url') . "%'";
        }
        $where .= " ORDER BY id DESC";
        $count = $this->urlAlisaLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);

        $res = $this->urlAlisaLogic->getCurrentDatas($where, $page_size, $curr_page);

        Core::$tpl->set("res", $res);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionAdd() {
        if (_p()) {
            $res = $this->urlAlisaLogic->getOne("url='" . _p('url') . "'");
            if ($res) {
                return $this->showMessage('search_name_exit');
            }
            $map = Zhtx::createDataMap();
            $url = strtolower(_p('url'));
            $map->addEntry('url', _p('url'), DB::VARCHAR);
            $map->addEntry('url_md5', md5($url), DB::VARCHAR);
            $map->addEntry('route', _p('route'), DB::VARCHAR);
            $map->addEntry('type', _p('type'), DB::INT);
            $res = $this->urlAlisaLogic->insert($map);
            if ($res) {
                return $this->success('add_success', Common::adminURL('admin', 'urlAlisa', 'list'));
            } else {
                return $this->error('add_failure', Common::adminURL('admin', 'urlAlisa', 'list'));
            }
        } else {
            
        }
    }

    public function actionEdit() {
        if (_p()) {
            $id = Common::queryInt(_p('id'), 0);
            $res = $this->urlAlisaLogic->getOne("url='" . _p('url') . "' and id!=" . $id);
            if ($res) {
                return $this->showMessage('search_name_exit');
            }
            $map = Zhtx::createDataMap();
            $url = strtolower(_p('url'));
            //$map->addEntry('admin_id', $_SESSION["id"], DB::VARCHAR);
            $map->addEntry('url', _p('url'), DB::VARCHAR);
            $map->addEntry('url_md5', md5($url), DB::VARCHAR);
            $map->addEntry('route', _p('route'), DB::VARCHAR);
            $map->addEntry('type', _p('type'), DB::INT);
            $res = $this->urlAlisaLogic->update($map, 'id =' . $id);
            if ($res) {
                return $this->success('edit_success', Common::adminURL('admin', 'urlAlisa', 'list'));
            } else {
                return $this->error('edit_failure', Common::adminURL('admin', 'urlAlisa', 'list'));
            }
        } else {
            $id = Common::queryInt(_g('id'), 0);
            $urlAlisa = $this->urlAlisaLogic->getOne('id=' . $id, $cols);
            if (!$urlAlisa) {
                return $this->error('id_error', Common::adminURL('admin', 'urlAlisa', 'list'));
            }

            Core::$tpl->set('urlAlisa', $urlAlisa);
        }
    }

    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->urlAlisaLogic->delete('id=' . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }



}

?>
