<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of User
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class UserController extends AppController {

    private $userLogic;
    private $userJoinInfoLogic;
    private $logLogic;
    private $userJoinCartLogic;
    private $userJoinFavoriteLogic;
    private $userApiLogic;
    private $apiSnsLogic;
    private $couponLogic;
    private $offerLogic;

    public function __construct() {
        parent::__construct();
        $this->userLogic = $this->load('user');
        $this->userJoinInfoLogic = $this->load('userJoinInfo');
        $this->logLogic = $this->load('userLoginLog');
        $this->userJoinCartLogic = $this->load('userJoinCartView');
        $this->userJoinFavoriteLogic = $this->load('userJoinFavorite');
        $this->userApiLogic = $this->load('userapi');
        $this->apiSnsLogic = $this->load('apisns');
        $this->couponLogic = $this->load('coupon');
        $this->offerLogic = $this->load('offer');
    }

    public function actionList() {
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $group_id = Common::queryInt(_g('group_id'));
        //获取数据
        $where = '1=1 ';
        if (_g('search_value')) {
            $where .= " and (u.base_name like '%" . _g('search_value') . "%' ";
            $where .= " or i.first_name like '%" . _g('search_value') . "%' or i.last_name like '%" . _g('search_value') . "%') ";
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and u.create_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and u.create_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and u.create_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('language_id')) {
            $where .= ' and u.language_id = ' . _g('language_id');
        }
        if ($group_id) {
            $where .= ' and u.user_group_id = ' . $group_id;
        }
        //分页
        $count = $this->userJoinInfoLogic->getCount($where);
        if (_g('psize')) {
            $page_size = Common::queryInt(_g('psize'));
        }
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $where .= " ORDER BY u.id DESC";

        $userList = $this->userJoinInfoLogic->getCurrentDatas($where, $page_size, $curr_page);
        $user_ids = array();
        $user_ids[] = 0;
        $user_parent = array();
        $user_parent[] = 0;
        $user_api = array();
        foreach ($userList as $key => $item) {
            $user_ids[] = $item['id'];
            if ($item['parent_user_id']) {
                $user_parent[] = $item['parent_user_id'];
            }
        }

        $userid_apiid = array();
        $cols = array('api_id', 'user_id', 'api_key');
        $user_api_cond = "user_id in (" . implode(',', $user_ids) . ")";
        $user_api_all = $this->userApiLogic->getCols($user_api_cond, $cols);
        foreach ($user_api_all as $k => $v) {
            if ($userid_apiid[$v['user_id']][$v['api_key']] != $v['api_key']) {
                $userid_apiid[$v['user_id']][$v['api_key']] = $v['api_id'];
            }
        }
        $user_api_images = $this->apiSnsLogic->getCols('1=1', array('id', 'api_type', 'language_id'), true);

        $cols = array('count(user_id) as num', 'user_id');
        $log_cond = 'user_id in (' . implode(',', $user_ids) . ') group by user_id';
        $logs = $this->logLogic->getCols($log_cond, $cols);
        $login_num = array();
        foreach ($logs as $value) {
            $login_num[$value['user_id']] = $value['num'];
        }

        $cols = array('base_name', 'id');
        $email_cond = 'id in (' . implode(',', $user_parent) . ') ';
        $emails = $this->userLogic->getCols($email_cond, $cols);
        $user_email = array();
        foreach ($emails as $value) {
            $user_email[$value['id']] = $value['base_name'];
        }

        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('sites', $this->load('language')->findAll());
        Core::$tpl->set('res', $userList);
        Core::$tpl->set('login_num', $login_num);
        Core::$tpl->set('user_email', $user_email);
        Core::$tpl->set('groups', $this->load('userGroup')->getAll());
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('userid_apiid', $userid_apiid);
        Core::$tpl->set('user_api_images', $user_api_images);
    }

    /**
     * 会员详情
     */
    public function actionDetail() {
        $page = Common::queryInt(_g('page'), 1);
        $psize = Common::queryInt(_g('psize'), 20);
        $tab = Common::queryInt(_g('tab'), 0);
        $user_id = Common::queryInt(_g('id'));
        $cond = 'u.id =' . $user_id;
        $user = $this->userJoinInfoLogic->getOne($cond);
        $countryLogic = $this->load('country');
        $addressLogic = $this->load('userAddress');
        //购物车
        $cartJoinSkuLogic = $this->load('cartJoinSku');
        $goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $language_id = $user['language_id'];
        $cart_data = $cartJoinSkuLogic->getListByUserId($user_id, $language_id, FALSE); //_debug($cart_data);
        $skulist = array();
        foreach ($cart_data as $item) {
            if (strpos($item['sku_code'], '_')) {
                $property_ids = explode('_', $item['sku_code']);
            } else {
                $property_ids = $item['sku_code'];
            }
            $properties = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
            $subtoral = round($item['price'] * intval($item['product_num']), 2);
            $total_weight = $item['weight'] * $item['product_num'];
            $totalPrice = $subtoral + $totalPrice;
            $skulist[] = array(
                'goods_id' => $item['goods_id'],
                'product_id' => $item['product_id'],
                'base_name' => $item['base_name'],
                'itemno' => $item['itemno'],
                'image' => $item['image'],
                'price' => round($item['price'], 2),
                'weight' => $item['weight'],
                'qty' => $item['product_num'],
                'sku_code' => $item['sku_code'],
                'subtoral' => $subtoral,
                'attributes' => $properties,
                'total_weight' => $total_weight,
                'stock' => $item['stock_nums'],
            );
        }
        $orderLogic = $this->load('order');
        $favoriteLogic = $this->load('userFavoriteJoinGoods');
        $commentLogic = $this->load('commentJoinGoods');
        $couponLogic = $this->load('coupon');
        //优惠券
        if ($tab == 6 && _g('page')) {
            $page = Common::queryInt(_g('page'));
        } else {
            $page = 1;
        }
        $where = 'user_id=' . $user_id;
        $count = $couponLogic->getCount($where);
        $coupon_page_data = Common::getPages($count, $page, $psize);
        if ($tab == 0 || $tab != 6) {
            $coupon_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $coupon_page_data['url']);
            $coupon_page_data['url'] = $coupon_page_data['url'] . "&tab=6";
        }
        $coupon_page_data['page_tab'] = 6;
        $where .= ' order by create_time desc';
        $conpons = $couponLogic->getCurrentDatas($where, $psize, $page);
        $offer_ids = array();
        foreach ($conpons as $val) {
            $offer_ids[] = $val['offer_id'];
        }
        if (!empty($offer_ids)) {
            $languageLogic = $this->load('language');
            $language_id = $languageLogic->language_id;
            $now = time();
            $offer_cond = 'o.id in (' . implode(',', $offer_ids) . ') and o.offer_type=2 and o.is_cart=1';
            if ($language_id) {
                $offer_cond .= ' and language_id=' . $language_id;
            }
            $offerJoinLangLogic = $this->load('offerJoinLanguage');
            $offerList = $offerJoinLangLogic->findAll($offer_cond, TRUE);
            foreach ($conpons as $_val) {
                $value = $offerList[$_val['offer_id']];
                $days = ($now - intval($_val['create_time'])) / 86400;
                $value['valid'] = 1;
                if ($value['days'] && $days > $value['days']) {
                    $value['valid'] = 0;
                } else if ($value['status'] == 0) {
                    $value['valid'] = 0;
                } else if ($value['end_time'] < $now) {
                    $value['valid'] = 0;
                }
                $value['coupon_code'] = $_val['coupon_code'];
                $value['using_time'] = $_val['using_time'];
                $value['face_value'] = $_val['face_value'];
                $result[] = $value;
            }
        }
        $coupons = $result;
        //留言
        if ($tab == 7 && _g('page')) {
            $curr_page = Common::queryInt(_g('page'));
        } else {
            $curr_page = 1;
        }
        $messageLogic = $this->load('Message');
        $where = 'parent_id=0 and user_id=' . $user_id . ' order by is_admin_readed asc,id desc';
        $count = $messageLogic->getCount($where);
        $message_page_data = Common::getPages($count, $curr_page, $psize);
        if ($tab == 0 || $tab != 7) {
            $message_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $message_page_data['url']);
            $message_page_data['url'] = $message_page_data['url'] . "&tab=7";
        }
        $message_page_data['page_tab'] = 7;
        $message = $messageLogic->getCurrentDatas($where, $psize, $curr_page);
        $userGroupLogic = $this->load('userGroup');
        $will_all_expire_credit = 0;
        foreach ($all_credits as $value) {
            $expire_time = $value['limit_time'] - SYS_TIME;
            if ($expire_time > 0 && $expire_time < 86400 * 7) {
                $will_all_expire_credit = $will_all_expire_credit + (int) $value['useful_credit'];
            }
            //echo $value['useful_credit']."<br />";
        }

        //订单
        if ($tab == 4 && _g('page')) {
            $curr_order_page = Common::queryInt(_g('page'));
        } else {
            $curr_order_page = 1;
        }
        $where = 'user_id =' . $user_id;
        $order_count = $orderLogic->getCount($where);
        $where .= ' order by create_time desc';
        $order_page_data = Common::getPages($order_count, $curr_order_page, $psize);
        if ($tab == 0 || $tab != 4) {
            $order_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $order_page_data['url']);
            $order_page_data['url'] = $order_page_data['url'] . "&tab=4";
        }
        $order_page_data['page_tab'] = 4;
        $orders = $orderLogic->getCurrentDatas($where, $psize, $curr_order_page);
        //喜好收藏
        if ($tab == 5 && _g('page')) {
            $curr_favorite_page = Common::queryInt(_g('page'));
        } else {
            $curr_favorite_page = 1;
        }
        $where = 'u.user_id=' . $user_id;
        $favorite_count = $favoriteLogic->getCount($where);
        $where .= ' order by create_time desc';
        $favorite_page_data = Common::getPages($favorite_count, $curr_favorite_page, $psize);
        if ($tab == 0 || $tab != 5) {
            $favorite_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $favorite_page_data['url']);
            $favorite_page_data['url'] = $favorite_page_data['url'] . "&tab=5";
        }
        $favorite_page_data['page_tab'] = 5;
        $favorites = $favoriteLogic->getCurrentDatas($where, $psize, $curr_favorite_page);
        //商品评论
        if ($tab == 8 && _g('page')) {
            $curr_comment_page = Common::queryInt(_g('page'));
        } else {
            $curr_comment_page = 1;
        }
        $where = 'c.user_id=' . $user_id;
        $comment_count = $commentLogic->getCount($where);
        $where .= ' order by c.create_time desc';
        $comment_page_data = Common::getPages($comment_count, $curr_comment_page, $psize);
        if ($tab == 0 || $tab != 8) {
            $comment_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $comment_page_data['url']);
            $comment_page_data['url'] = $comment_page_data['url'] . "&tab=8";
        }
        $comment_page_data['page_tab'] = 8;
        $comments = $commentLogic->getCurrentDatas($where, $psize, $curr_comment_page);
        //积分
        if ($tab == 9 && _g('page')) {
            $curr_credit_page = Common::queryInt(_g('page'));
        } else {
            $curr_credit_page = 1;
        }
        $where = 'user_id=' . $user_id;
        $creditDetailLogic = $this->load('creditDetail');
        $credit_count = $creditDetailLogic->getCount($where);
        $where .= ' order by create_time desc';
        $credit_page_data = Common::getPages($credit_count, $curr_credit_page, $psize);
        if ($tab == 0 || $tab != 9) {
            $credit_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $credit_page_data['url']);
            $credit_page_data['url'] = $credit_page_data['url'] . "&tab=9";
        }
        $credit_page_data['page_tab'] = 9;
        $credits = $creditDetailLogic->getCurrentDatas($where, $psize, $curr_credit_page);
        //成长值
        if ($tab == 10 && _g('page')) {
            $curr_growth_page = Common::queryInt(_g('page'));
        } else {
            $curr_growth_page = 1;
        }
        $where = 'user_id=' . $user_id;
        $growthDetailLogic = $this->load('growthDetail');
        $growth_count = $growthDetailLogic->getCount($where);
        $where .= ' order by create_time desc';
        $growth_page_data = Common::getPages($growth_count, $curr_growth_page, $psize);
        if ($tab == 0 || $tab != 10) {
            $growth_page_data['url'] = preg_replace("/\&tab\=[0-9]+/", '', $growth_page_data['url']);
            $growth_page_data['url'] = $growth_page_data['url'] . "&tab=10";
        }
        $growth_page_data['page_tab'] = 10;
		
        $growths = $growthDetailLogic->getCurrentDatas($where, $psize, $curr_growth_page);
		
		//搜索词
        if ($tab == 11 && _g('page')) {
            $curr_keywords_page = Common::queryInt(_g('page'));
        } else {
            $curr_keywords_page = 1;
        }
        $where = 'user_id=' . $user_id;
        $Logic = $this->load('userKeywords');
        $keywords_count = $Logic->getCount($where);
        $where .= ' order by id desc';
        $keywords_pages = Common::getPages($keywords_count, $curr_keywords_page, $psize);
        if ($tab == 0 || $tab != 11) {
            $keywords_pages['url'] = preg_replace("/\&tab\=[0-9]+/", '', $credit_page_data['url']);
            $keywords_pages['url'] = $credit_page_data['url'] . "&tab=11";
        }
        $credit_page_data['page_tab'] = 11;
        $user_keywords = $Logic->getCurrentDatas($where, $psize, $curr_credit_page);
		 Core::$tpl->set('user_keywords', $user_keywords);
		  Core::$tpl->set('keywords_pages', $keywords_pages);
		 
		 
        Core::$tpl->set('coupons', $coupons);
        Core::$tpl->set("coupons_pages", $coupon_page_data);
        Core::$tpl->set("message", $message);
        Core::$tpl->set("mespages", $message_page_data);
        Core::$tpl->set('user', $user);
        Core::$tpl->set('userlog', $this->logLogic->getLastLog($user_id));
        Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
        Core::$tpl->set('address_list', $addressLogic->getListByUserId($user_id));
        Core::$tpl->set('skulist', $skulist);
        Core::$tpl->set('orders', $orders);
        Core::$tpl->set("order_pages", $order_page_data);
        Core::$tpl->set('favorites', $favorites);
        Core::$tpl->set("favorite_pages", $favorite_page_data);
        Core::$tpl->set('comments', $comments);
        Core::$tpl->set("comment_pages", $comment_page_data);
        Core::$tpl->set('groups', $userGroupLogic->getAll());
        Core::$tpl->set('credits', $credits);
        Core::$tpl->set("credit_pages", $credit_page_data);
        Core::$tpl->set('growths', $growths);
        Core::$tpl->set("growth_pages", $growth_page_data);
        Core::$tpl->set('will_all_expire_credit', $will_all_expire_credit);
    }

    /**
     * 留言标记
     */
    public function actionMessageMarked() {
        $marked = Common::queryInt(_p('marked'));
        $message_id = Common::queryInt(_p('message_id'));
        if ($marked) {
            $marked = 0;
        } else {
            $marked = 1;
        }
        $map = Zhtx::createDataMap();
        $map->addEntry('marked', $marked, DB::INT);
        $cond = 'id=' . $message_id;
        $this->load('message')->update($map, $cond);
        echo $marked;
        exit;
    }

    /**
     * 会员中心编辑信息
     * ajax
     */
    public function actionEdit() {
        $user_id = Common::queryInt(_g('user_id'));
        $user = $this->userLogic->getOneById($user_id);
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $return = array(
            'status' => 0,
            'msg' => '',
        );
        if ($user) {
            $base_name = _p('base_name');
            $cond = 'id !=' . $user_id . ' and base_name="' . $base_name . '"';
            $count = $this->userLogic->getCount($cond);
            if ($count > 0) {
                $return['msg'] = $lang['base_name_existed'];
            } else {
                $user_data = array(
                    'base_name' => $base_name,
                    'question' => _p('question'),
                    'answer' => _p('answer'),
                    'status' => _p('status'),
                );
                if (_p('password')) {
                    $user_data['password'] = md5(md5(_p('password')));
                }
                $this->userLogic->save($user_data, $user_id);
                $info_data = array(
                    'user_id' => $user_id,
                    'first_name' => _p('first_name'),
                    'last_name' => _p('last_name'),
                    'sex' => _p('sex'),
                    'mobilephone' => _p('mobilephone'),
                    'telephone' => _p('telephone'),
                    'state' => _p('state'),
                    'city' => _p('city'),
                    'country_id' => _p('country_id'),
                );
                $infoLogic = $this->load('userInfo');
                $res = $infoLogic->updateByCond($info_data);
                if ($res) {
                    $return = array(
                        'status' => 1,
                        'msg' => $lang['edit_success'],
                    );
                } else {
                    $return['msg'] = $lang['edit_failure'];
                }
            }
        } else {
            $return['msg'] = $lang['illegal_operation'];
        }
        echo json_encode($return);
    }

    public function actionComments() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = "1=1 ";
        if (_g('goods_name')) {
            $where .= "and g.base_name like '%" . _g('goods_name') . "%' ";
        }
        if (_g('goods_id')) {
            $where .= "and c.goods_id =" . _g('goods_id');
        }
        if (_g('noreaded')) {
            $where .= "and c.is_admin_readed = 0";
        }
        $where .= " order by c.id desc";
        $commentLogic = $this->load('commentJoinGoods');
        $count = $commentLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size, $prev, $next);
        $comments = $commentLogic->getCurrentDatas($where, $page_size, $curr_page);
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('1=1', true);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set("comments", $comments);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionReplyComment() {
        $commentLogic = $this->load('goodsComment');
        if (_p()) {
            $comment_id = Common::queryInt(_p('id'));
            $comment = $commentLogic->getOneById($comment_id);
            if (!$comment) {
                return $this->showMessage('illegal_parameters');
            }
            $data = array(
                'reply_nickname' => _c('admin_name'),
                'reply_detail' => common::newAddslashes(_p('reply_detail')),
                'reply_time' => SYS_TIME,
                'status' => _p('status'),
            );
            $res = $commentLogic->save($data, $comment_id);
            //更新商品
            if ($res) {
                GrowthFactory::goodsCommentAfter($comment);
                CreditFactory::goodsCommentAfter($comment);
                $this->load('goods')->updateCommentCount($comment['goods_id']);
                return $this->success('save_success');
            }
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        } else {
            $comment_id = Common::queryInt(_g('id'));
            $comment = $commentLogic->getOneById($comment_id);
            if (!$comment) {
                return $this->showMessage('illegal_parameters');
            }
            $map = Zhtx::createDataMap();
            $map->addEntry('is_admin_readed', 1, DB::INT);
            $res = $commentLogic->update($map, 'id=' . $comment_id);
            $userJoinInfoLogic = $this->load('userJoinInfo');
            $user = $userJoinInfoLogic->getUserById($comment['user_id']);
            Core::$tpl->set('comment', $comment);
            Core::$tpl->set('user', $user);
            $languageLogic = $this->load('language');
            $languages = $languageLogic->findAll('1=1', true);
            Core::$tpl->set('languages', $languages);
        }
    }

    public function actionMessageList() {
        $messageLogic = $this->load('Message');
		$goodsLogic = $this->load('Goods');
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'parent_id=0';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        if (_g('is_readed')) {
            $where .= " and is_admin_readed = 0";
        }

        $where .= " order by id desc";
        $count = $messageLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size, $prev, $next);
        $message = $messageLogic->getCurrentDatas($where, $page_size, $curr_page);
		$ids = array(0);
		foreach($message as $key => $value)
		{
			if($value['contact'])
			{
				$obj = json_decode($value['contact'],true);
				foreach($obj as $item)
				{
					if($item[0]=="goods_codeno")
					{
						$goods = $goodsLogic->getOne("codeno='".$item[1]."'");
						$message[$key]['goods'] = $goods ;
					}
				}
			}
			$ids[] = $value['user_id'];
		}
		
		 $res_record = $this->load('user')->getCols('id in ('.join(',',$ids).')', array('id','base_name'));
		
		foreach($res_record as $value)
		{
			$user[$value['id']] = $value['base_name'];	
		}
		Core::$tpl->set("user", $user);
		
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set("res", $message);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionCouponList() {
        $couponLogic = $this->load('Coupon');
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1 ';
        if (_g('coupon_code')) {
            $where .= " and coupon_code like '%" . _g('coupon_code') . "%'";
        }
        if (_g('offer_id')) {
            $where .= " and offer_id = " . _g('offer_id');
        }
        $where .= " order by id desc";

        $count = $couponLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size, $prev, $next);

        $res = $couponLogic->getCurrentDatas($where, $page_size, $curr_page);
        $offerLogic = $this->load('offer');
        $offer = $offerLogic->findAll('1=1', true);

        $userLogic = $this->load('user');
        $orderLogic = $this->load('order');
        foreach ($res as $key => $value) {

            $user = $userLogic->getOne("id=" . $value["user_id"]);
            $order = $orderLogic->getOne("id=" . $value["order_id"]);
            $res[$key]["username"] = $user["base_name"];
            $res[$key]["itemno"] = $order["itemno"];
        }
        Core::$tpl->set('offer', $offer);
        Core::$tpl->set("res", $res);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionReplyMessage() {
        $messageLogic = $this->load('Message');
        if (_p()) {
            $id = $_REQUEST['id'] ? $_REQUEST['id'] : 0;
            $cond = 'id = ' . $id . " and parent_id=0";
            $message = $messageLogic->getOne($cond);
            if (!$message) {
                return $this->showMessage('illegal_operation', ADMIN_ROOT . '?m=admin&c=user&a=messagelist');
            }
            if (trim(_p("detail"))) {
                $reply_map = Zhtx::createDataMap();
                $reply_map->addEntry('parent_id', $id, DB::INT);
                $reply_map->addEntry('detail', Common::strEscape(_p("detail")), DB::VARCHAR);
                $reply_map->addEntry('is_user_readed', 0, DB::INT);
                $reply_map->addEntry('is_admin_readed', 0, DB::INT);
                $reply_map->addEntry('admin_id', $_SESSION["admin_id"], DB::INT);
                $reply_map->addEntry('user_name', Common::strEscape($_SESSION["real_name"]), DB::VARCHAR);
                $reply_map->addEntry('user_id', $message['user_id'], DB::INT);
                $reply_map->addEntry('type', $message['type'], DB::INT);
                $reply_map->addEntry('status', 1, DB::INT);
                $reply_map->addEntry('create_time', SYS_TIME, DB::INT);
                $res = $messageLogic->insert($reply_map);
                if ($res) {
                    $replymessage = array(
                        'id' => $res,
                        'parent_id' => $id,
                        'detail' => Common::strEscape(_p("detail")),
                        'is_user_readed' => 0,
                        'is_admin_readed' => 0,
                        'language_id' => $message['language_id'],
                        'admin_id' => $_SESSION["admin_id"],
                        'user_name' => Common::strEscape($_SESSION["real_name"]),
                        'user_id' => $message['user_id'],
                        'type' => $message['type'],
                        'status' => 1,
                    );
                    EventFactory::messageReplyAfter($message);
                    $msg_map = Zhtx::createDataMap();
                    $msg_map->addEntry('is_user_readed', 0, DB::INT);
                    $msg_map->addEntry('is_admin_readed', 1, DB::INT);
                    $msg_map->addEntry('reply_time', SYS_TIME, DB::INT);
                    $res = $messageLogic->update($msg_map, 'id=' . $id);
                    return $this->success('save_success', ADMIN_ROOT . '?m=admin&c=user&a=replymessage&id=' . $id);
                }
                return $this->success('failure_success', ADMIN_ROOT . '?m=admin&c=user&a=replymessage&id=' . $id);
            }
        } else {
            $id = $_REQUEST['id'] ? $_REQUEST['id'] : 0;
            $cond = 'id = ' . $id . " and parent_id=0";
            $message = $messageLogic->getOne($cond);
            if (!$message) {
                return $this->showMessage('illegal_operation', ADMIN_ROOT . '?m=admin&c=user&a=messagelist');
            }
            $cond = "parent_id=" . $id;
            $reply = $messageLogic->getList($cond);

            if ($message["contact"] != "") {
                $message["contact"] = json_decode($message["contact"], true);
				foreach($message["contact"] as $item)
				{
					if($item[0]=="goods_codeno")
					{
						$goods = $this->load("goods")->getOne("codeno='".$item[1]."'");
						$message['goods'] = $goods ;
					}
				}
            } else {
                $message["contact"] = array();
            }
            $msg_map = Zhtx::createDataMap();
            $msg_map->addEntry('is_admin_readed', 1, DB::INT);
            $res = $messageLogic->update($msg_map, 'id=' . $id);
            Core::$tpl->set("message", $message);
            Core::$tpl->set("reply", $reply["list"]);
            $languageLogic = $this->load('language');
            $languages = $languageLogic->findAll('1=1', true);
            Core::$tpl->set('languages', $languages);
        }
    }

    public function actionAddUserNotice() {
        $messageLogic = $this->load('Message');
        if (_p()) {
            $base_name = Common::strEscape(_p("base_name"));
            if (!$base_name) {
                return $this->showMessage('required_item');
            }
            $msg_map = Zhtx::createDataMap();
            $msg_map->addEntry('user_name', Common::strEscape(_p("user_name")), DB::VARCHAR);
            $msg_map->addEntry('base_name', $base_name, DB::VARCHAR);
            $msg_map->addEntry('language_id', Common::queryInt(_p("language_id")), DB::INT);
            $msg_map->addEntry('type', 0, DB::INT);
            $msg_map->addEntry('parent_id', 0, DB::INT);
            $msg_map->addEntry('detail', Common::strEscape(_p("detail")), DB::VARCHAR);
            $msg_map->addEntry('is_admin_readed', 1, DB::INT);
            $msg_map->addEntry('is_user_readed', 0, DB::INT);
            $msg_map->addEntry('status', 1, DB::INT);
            $msg_map->addEntry('create_time', SYS_TIME, DB::INT);
            $messageLogic->insert($msg_map);
            return $this->success('add_success', ADMIN_ROOT . '?m=admin&c=user&a=messagelist');
        } else {
            $languageLogic = $this->load('language');
            $languages = $languageLogic->findAll('1=1', true);
            Core::$tpl->set('languages', $languages);
        }
    }

    public function actionAddUserMessage() {
        $messageLogic = $this->load('Message');
        if (_p()) {
            $user_id = _p("user_id");
            $msg_map = Zhtx::createDataMap();
            $msg_map->addEntry('user_name', Common::strEscape(_p("user_name")), DB::VARCHAR);
            $msg_map->addEntry('base_name', Common::strEscape(_p("base_name")), DB::VARCHAR);
            $msg_map->addEntry('language_id', 0, DB::INT);
            $msg_map->addEntry('type', 1, DB::INT);
            $msg_map->addEntry('user_id', _p("user_id"), DB::INT);
            $msg_map->addEntry('parent_id', 0, DB::INT);
            $msg_map->addEntry('detail', Common::strEscape(_p("detail")), DB::VARCHAR);
            $msg_map->addEntry('is_user_readed', 0, DB::INT);
            $msg_map->addEntry('status', 1, DB::INT);
            $msg_map->addEntry('is_admin_readed', 1, DB::INT);
            $msg_map->addEntry('create_time', SYS_TIME, DB::INT);
            $messageLogic->insert($msg_map);
        }
        return $this->success('add_success', ADMIN_ROOT . '?m=admin&c=user&a=detail&id=' . $user_id . '&tab=7');
    }

    public function actionDelreply() {
        $id = Common::queryInt(_g('id'));
        $messageLogic = $this->load('Message');
        $messageLogic->delete('id=' . $id);
        return $this->success('success_delete', ADMIN_ROOT . '?m=admin&c=user&a=replymessage&id=' . Common::queryInt(_g('pid')));
    }

    public function actionDelGoodsComment() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $goodsCommentLogic = $this->load('goodsComment');
                $goodsCommentLogic->delete('id=' . $id);
                $this->load('goods')->updateCommentCount($id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionNewsletterList() {
        $page_size = 20;
        global $cfg;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $where .= " ORDER BY id DESC";
        $newsletterLogic = $this->load('Newsletter');
        $res = $newsletterLogic->getCurrentDatas($where, $page_size, $curr_page);
        $count = $newsletterLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('1=1', true);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('cfg', $cfg);
        Core::$tpl->set('pages', $page_list);
    }

    public function actionCreditList() {
        $page_size = 20;
        global $cfg;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('search_value')) {
			$user = $this->load('user')->getOne("base_name like '"._g('search_value')."'");
			$where .= " and user_id = " . (int)$user['id'];

        }
        $where .= " ORDER BY id DESC";
        $logic = $this->load('CreditDetail');
        $res = $logic->getCurrentDatas($where, $page_size, $curr_page);

        $user_ids = array(0);
        foreach ($res as $item) {
            $user_ids[] = $item['user_id'];
        }
        $cols = array('base_name', 'id');
        $user_cond = 'id in (' . implode(',', $user_ids) . ')';
        $user_res = $this->userLogic->getCols($user_cond, $cols);
        $user = array();
        foreach ($user_res as $value) {
            $user[$value['id']] = $value['base_name'];
        }

        $count = $logic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('1=1', true);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('user', $user);
        Core::$tpl->set('pages', $page_list);
    }

    public function actionGrowthList() {
        $page_size = 20;
        global $cfg;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
         if (_g('search_value')) {
			$user = $this->load('user')->getOne("base_name like '"._g('search_value')."'");
			$where .= " and user_id = " . (int)$user['id'];

        }
        $where .= " ORDER BY id DESC";
        $logic = $this->load('GrowthDetail');
        $res = $logic->getCurrentDatas($where, $page_size, $curr_page);

        $user_ids = array(0);
        foreach ($res as $item) {
            $user_ids[] = $item['user_id'];
        }
        $cols = array('base_name', 'id');
        $user_cond = 'id in (' . implode(',', $user_ids) . ')';
        $user_res = $this->userLogic->getCols($user_cond, $cols);
        $user = array();
        foreach ($user_res as $value) {
            $user[$value['id']] = $value['base_name'];
        }

        $count = $logic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('1=1', true);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('user', $user);
        Core::$tpl->set('pages', $page_list);
    }

    /**
     * 数据删除
     */
    public function actionNewsletterDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $newsletterLogic = $this->load('Newsletter');
                $res = $newsletterLogic->delete('id=' . $id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionMessageDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $Logic = $this->load('Message');
                $res = $Logic->delete('id=' . $id . " or parent_id=" . $id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionCommentDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $Logic = $this->load('GoodsComment');
                $res = $Logic->delete('id=' . $id);
                $this->load('goods')->updateCommentCount($id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionCouponDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $Logic = $this->load('Coupon');
                $res = $Logic->delete('id=' . $id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function actionEditUserNotice() {
        $messageLogic = $this->load('Message');
        if (_p()) {
            $id = $_REQUEST['id'] ? $_REQUEST['id'] : 0;
            $msg_map = Zhtx::createDataMap();
            $msg_map->addEntry('user_name', Common::strEscape(_p("user_name")), DB::VARCHAR);
            $msg_map->addEntry('base_name', Common::strEscape(_p("base_name")), DB::VARCHAR);
            $msg_map->addEntry('language_id', _p("language_id"), DB::INT);
            $msg_map->addEntry('is_admin_readed', 1, DB::INT);
            $msg_map->addEntry('is_user_readed', 1, DB::INT);
            $msg_map->addEntry('detail', Common::strEscape(_p("detail")), DB::VARCHAR);
            $msg_map->addEntry('create_time', SYS_TIME, DB::INT);
            $messageLogic->update($msg_map, 'id=' . $id);
            return $this->success('edit_success', ADMIN_ROOT . '?m=admin&c=user&a=messagelist');
        } else {
            $id = $_REQUEST['id'] ? $_REQUEST['id'] : 0;
            $cond = 'id = ' . $id . " and parent_id=0";
            $message = $messageLogic->getOne($cond);
            if (!$message) {
                return $this->showMessage('illegal_operation', ADMIN_ROOT . '?m=admin&c=user&a=messagelist');
            }
            $languageLogic = $this->load('language');
            $languages = $languageLogic->findAll('1=1', true);
            Core::$tpl->set("message", $message);
            Core::$tpl->set('languages', $languages);
        }
    }

    /**
     * 用户等级列表
     */
    public function actionUserGroups() {
        $userGroupLogic = $this->load('userGroup');
        $groupList = $userGroupLogic->findAll();
        $result = array();
        foreach ($groupList as $key => $value) {
            $cond = 'growth >= ' . $value['min_growth'];
            if ($value['max_growth']) {
                $cond = 'growth >= ' . $value['min_growth'] . ' and growth < ' . $value['max_growth'];
            }
            $count = $this->userLogic->getCount($cond);
            $value['count'] = $count;
            $result[$key] = $value;
            $this->userLogic->saveByCond(array('user_group_id' => $value['id']), $cond);
        }
        Core::$tpl->set('res', $result);
        Core::$htmlFile = 'user/usergroups';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 新增用户等级
     * @return type
     */
    public function actionAddUserGroup() {
        $languageLogic = $this->load('language');
        if (_p()) {
            $base_name = _p('group_base_name');
            $min_growth = Common::queryInt(_p('min_growth'));
            $max_growth = 0;
            if (!$base_name) {
                return $this->showMessage('base_name_not_empty');
            }
            $cond = 'base_name ="' . $base_name . '" or min_growth=' . $min_growth;
            $userGroupLogic = $this->load('userGroup');
            $count = $userGroupLogic->getCount($cond);
            if ($count > 0) {
                return $this->showMessage('this_group_existed');
            }

            $where = ' status=1 order by min_growth asc';
            $grouplist = $userGroupLogic->findAll($where);
            $update_id = 0;
            if ($grouplist) {
                $falg = TRUE;
                foreach ($grouplist as $val) {
                    if ($falg && $val['min_growth'] > $min_growth) {
                        $max_growth = $val['min_growth'];
                        $falg = FALSE;
                    }
                    if ($val['min_growth'] < $min_growth) {
                        $update_id = $val['id'];
                    }
                }
            }
            $is_default = Common::queryInt(_p('is_default'));
            $data = array(
                'base_name' => $base_name,
                'min_growth' => $min_growth,
                'max_growth' => $max_growth,
                'is_default' => $is_default,
                'status' => Common::queryInt(_p('status')),
                'type' => Common::queryInt(_p('type')),
                'image' => _p('image'),
                'descript' => Common::strEscape(_p('descript')),
                'create_time' => SYS_TIME,
            );
            $res = $userGroupLogic->save($data);
            if ($res) {
                if ($update_id) {
                    $update_data = array(
                        'max_growth' => $min_growth,
                    );
                    $userGroupLogic->save($update_data, $update_id);
                }
                if ($is_default) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('is_default', 0, DB::INT);
                    $userGroupLogic->update($map, 'id !=' . $res . ' and is_default=1');
                }
                $groupLangLogic = $this->load('userGroupLanguage');
                //如果主表信息更新成功,则更新附表信息
                $languages = $languageLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('user_group_id', $res, DB::INT);
                    $map->addEntry('language_id', $item["id"], DB::INT);
                    $map->addEntry('base_name', Common::strEscape(_p('base_name' . $item["id"])), DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
                    $groupLangLogic->insert($map);
                }
                $userGroupLogic->updateCache();
                return $this->success('add_success', Common::adminURL('admin', 'user', 'userGroups'));
            }
            return $this->showMessage('add_failure');
        } else {
            $languages = $languageLogic->findAll('status=1', true);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'user/groupform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 编辑用户等级
     * @return type
     */
    public function actionEditUserGroup() {
        $languageLogic = $this->load('language');
        $userGroupLogic = $this->load('userGroup');
        $groupLangLogic = $this->load('userGroupLanguage');
        if (_p()) {
            $group_id = Common::queryInt(_p('id'));
            $base_name = _p('group_base_name');
            if (!$base_name) {
                return $this->showMessage('base_name_not_empty');
            }
            $min_growth = Common::queryInt(_p('min_growth'));
            $cond = 'id !=' . $group_id . ' and (base_name ="' . $base_name . '" or min_growth=' . $min_growth . ')';
            $count = $userGroupLogic->getCount($cond);
            if ($count > 0) {
                return $this->showMessage('this_group_existed');
            }
            $max_growth = 0;
            $where = ' order by min_growth asc';
            $grouplist = $userGroupLogic->findAll($where);
            if ($grouplist) {
                $update_id = 0;
                $flag = TRUE;
                foreach ($grouplist as $val) {
                    if ($flag && $val['min_growth'] > $min_growth) {
                        $max_growth = $val['min_growth'];
                        $flag = FALSE;
                    }
                    if ($val['min_growth'] < $min_growth) {
                        $update_id = $val['id'];
                    }
                }
            }
            $is_default = Common::queryInt(_p('is_default'));
            $data = array(
                'base_name' => $base_name,
                'min_growth' => $min_growth,
                'max_growth' => $max_growth,
                'is_default' => $is_default,
                'status' => Common::queryInt(_p('status')),
                'type' => Common::queryInt(_p('type')),
                'image' => _p('image'),
                'descript' => Common::strEscape(_p('descript')),
            );
            $res = $userGroupLogic->save($data, $group_id);
            if ($res) {
                if ($update_id) {
                    $update_data = array(
                        'max_growth' => $min_growth,
                    );
                    $userGroupLogic->save($update_data, $update_id);
                }
                if ($is_default) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('is_default', 0, DB::INT);
                    $userGroupLogic->update($map, 'id !=' . $group_id . ' and is_default=1');
                }
                //如果主表信息更新成功,则更新附表信息
                $languages = $languageLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('user_group_id', $group_id, DB::INT);
                    $map->addEntry('language_id', $item["id"], DB::INT);
                    $map->addEntry('base_name', Common::strEscape(_p('base_name' . $item["id"])), DB::VARCHAR);
                    $replace_cond = 'language_id=' . $item['id'] . ' and user_group_id=' . $group_id;
                    $groupLangLogic->replaceByCond($map, $replace_cond);
                }
                $userGroupLogic->updateCache();
                return $this->success('add_success', Common::adminURL('admin', 'user', 'userGroups'));
            }
            return $this->showMessage('add_failure');
        } else {
            $group_id = Common::queryInt(_g('id'));
            $group = $userGroupLogic->getOneById($group_id);
            if (!$group) {
                return $this->showMessage('illegal_parameters');
            }
            $languages = $languageLogic->findAll('status=1', true);
            $lang_group = $groupLangLogic->findAll('user_group_id=' . $group_id);
            $lang_group_rs = array();
            foreach ($lang_group as $value) {
                $lang_group_rs[$value['language_id']] = $value;
            }
            $lang_arr = array();
            foreach ($languages as $item) {
                $lang_arr[] = array(
                    'id' => $item['id'],
                    'base_name' => $item['base_name'],
                    'country_code_2' => $item['country_code_2'],
                    'lang_name' => isset($lang_group_rs[$item['id']]) ? $lang_group_rs[$item['id']]['base_name'] : '',
                );
            }
            Core::$tpl->set('group', $group);
            Core::$tpl->set('languages', $lang_arr);
            Core::$htmlFile = 'user/groupform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionDelUserGroup() {
        
    }

    /**
     * 增加积分值
     */
    public function actionAddCredit() {
        $user_id = Common::queryInt(_g('user_id'));
        $credit = Common::queryInt(_p('credit'));
        $expire = Common::queryInt(_p('expire'));
        if (!$credit) {
            return $this->showMessage('积分不能为空', Common::adminURL('admin', 'User', 'AddCreditDetail', array('uid' => $user_id, 'expire' => $expire)));
        }
        $language_id = _c('language_id') ? _c('language_id') : 0;
        $ip = Common::_ip2long(Common::ip());
        $ipJoinCountryLogic = $this->load('ipJoinCountry');
        $settingLogic = $this->load('creditSetting');
        $limit_time = $settingLogic->getValidDate(); //获取过期时间
        $data = array(
            'user_id' => $user_id,
            'total_credit' => $credit,
            'useful_credit' => $credit,
            'create_time' => SYS_TIME,
            'language_id' => $language_id,
            'country_id' => $ipJoinCountryLogic->getCountryId($ip),
            'domain' =>   SITE_URL,
            'ip' => $ip,
            'remark' => 'system_manual_add',
            'limit_time' => $limit_time,
        );
        $detailLogic = $this->load('creditDetail');
        if ($detailLogic->save($data)) {
            $map = Zhtx::createDataMap();
            $map->addEntry('credit', 'credit+' . $credit, DB::INT);
            $this->userLogic->updateById($map, $user_id);
            return $this->success('save_success');
        }
        return $this->showMessage('save_failure');
    }

    public function actionAddGrowth() {
        $user_id = Common::queryInt(_g('user_id'));
        $growth = Common::queryInt(_p('growth'));
        if (!$growth) {
            return $this->showMessage('成长值不能为空', Common::adminURL('admin', 'User', 'AddGrowthDetail', array('uid' => $user_id)));
        }
        $language_id = _c('language_id') ? _c('language_id') : 0;
        $ip = Common::_ip2long(Common::ip());
        $ipJoinCountryLogic = $this->load('ipJoinCountry');
        $data = array(
            'user_id' => $user_id,
            'growth' => $growth,
            'language_id' => $language_id,
            'country_id' => $ipJoinCountryLogic->getCountryId($ip),
            'domain' => SITE_PROTOCOL . SITE_URL,
            'ip' => $ip,
            'remark' => 'system_manual_add',
            'create_time' => SYS_TIME,
        );
        $detailLogic = $this->load('growthDetail');
        if ($detailLogic->save($data)) {
            $user = $this->userLogic->getOneById($user_id);
            $groupLogic = $this->load('userGroup');
            $cur_growth = $user['growth'] + $growth;
            $res_group_id = $user['user_group_id'];
            foreach ($groupLogic->getAll() as $key => $value) {
                if ($cur_growth >= $value['min_growth'] && ($value['max_growth'] == 0 || $cur_growth < $value['max_growth'])) {
                    $res_group_id = $key;
                    break;
                }
            }
            $map = Zhtx::createDataMap();
            $map->addEntry('growth', $cur_growth, DB::INT);
            $map->addEntry('user_group_id', $res_group_id, DB::INT);
            $map->addEntry('update_time', SYS_TIME, DB::INT);
            $this->load('user')->updateById($map, $user['id']);
            return $this->success('save_success');
        }
        return $this->showMessage('save_failure');
    }

    public function actionPublicEditCommentStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $map->addEntry('is_admin_readed', 1, DB::INT);
        $res = $this->load("GoodsComment")->updateById($map, $id);
        //更新商品
        if ($res) {
            $comment = $this->load('goodsComment')->getOneById($id);
            GrowthFactory::goodsCommentAfter($comment);
            CreditFactory::goodsCommentAfter($comment);
            $this->load('goods')->updateCommentCount($comment['goods_id']);
            //删除缓存
            $this->load('goodsLanguage')->updateCache($comment['goods_id']);
            return $this->success('save_success');
        }
        echo $res ? 1 : 0;
    }

    /*
     * 会员购物车
     */

    public function actionShopCartList() {

        if (_p("user_id") && _p("language_id")) {
            EventFactory::shopcartReminder(_p("user_id"), _p("language_id"));
            echo 1;
            exit;
        }

        $where = '';
        if (_g('search_value')) {
            $where = "base_name like '%" . _g('search_value') . "%' ";
        }
        $where.=" group by uc.user_id having product_num>0 ";
        $curr_page = Common::queryInt(_g('page'), 1);
        $page_size = Common::queryInt(_g('psize'), 20);

        $count = $this->userJoinCartLogic->findAll($where);
        $count = count($count);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $where.=" order by u.update_time desc";
        $cartlist = $this->userJoinCartLogic->getCurrentDatas($where, $page_size, $curr_page);

        $user_ids = array(0);
        foreach ($cartlist as $item) {
            $user_ids[] = $item['id'];
        }
        $cols = array('count(user_id) as num, user_id,create_day');
        $log_cond = 'user_id in (' . implode(',', $user_ids) . ') group by user_id';
        $logs = $this->logLogic->getCols($log_cond, $cols);

        $login_num = array();
        foreach ($logs as $value) {
            $login_num[$value['user_id']] = $value['num'];
        }

        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        Core::$tpl->set('userList', $cartlist);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('login_num', $login_num);
        Core::$tpl->set('groups', $this->load('userGroup')->getAll());
        Core::$tpl->set('languages', $languages);
    }

    /*
     * 会员收藏
     */

    public function actionFavoriteList() {

        if (_p("user_id") && _p("language_id")) {
            EventFactory::wishlistReminder(_p("user_id"), _p("language_id"));
            echo 1;
            exit;
        }

        $where = '';
        if (_g('search_value')) {
            $where = "base_name like '%" . _g('search_value') . "%' ";
        }
        $where.=" group by uf.user_id HAVING collection >0 ";
        $curr_page = Common::queryInt(_g('page'), 1);
        $page_size = Common::queryInt(_g('psize'), 20);
        $count = $this->userJoinFavoriteLogic->findAll("group by uf.user_id HAVING collection >0 ");
        $count = count($count);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $where.=" order by u.update_time desc";
        $userArray = $this->userJoinFavoriteLogic->getCurrentDatas($where, $page_size, $curr_page);
        $user_ids = array(0);
        foreach ($userArray as $item) {
            $user_ids[] = $item['id'];
        }
        // 获取登录次数
        $cols = array('count(user_id) as num ', 'user_id', 'create_day');
        $log_cond = 'user_id in (' . implode(',', $user_ids) . ') group by user_id order by create_day desc';
        $logs = $this->logLogic->getCols($log_cond, $cols);
        $login_num = array();
        foreach ($logs as $value) {
            $login_num[$value['user_id']] = $value['num'];
        }
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        Core::$tpl->set('userList', $userArray);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('login_num', $login_num);
        Core::$tpl->set('groups', $this->load('userGroup')->getAll());
        Core::$tpl->set('languages', $languages);
    }

    public function actionStepOutputEmail() {
        if (_p()) {
            $language_id = _p('language_id');
            $url = '?m=admin&c=user&a=outputemail';
            if ($language_id) {
                $url.='&language_id=' . $language_id;
                $cond .= '  u.language_id = ' . $language_id;
            } else {
                $cond = "1=1";
            }
            $emailnum = $this->userJoinInfoLogic->getCount($cond);
            if ($emailnum > 5000) {
                $num = ceil($emailnum / 5000);
                for ($i = 1; $i <= $num; $i++) {
                    $temp = 5000 * $i;
                    $ulrs[$i]['step'] = $i;
                    $ulrs[$i]['url'] = $url . '&step=' . $i;
                }
            } else {
                $ulrs[1]['step'] = 1;
                $ulrs[1]['url'] = $url;
            }
            Core::$tpl->set('emailnum', $emailnum);
            Core::$tpl->set('ulrs', $ulrs);
        } else {
            $languages = $this->load('language')->getCols('1=1', $cols);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'user/exportuserdata';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionOutPutEmail() {
        $filename = 'user_email.txt';
        $where = '1=1 ';
        if (_g('language_id')) {
            $where .= ' and u.language_id = ' . _g('language_id');
        }
        $where .= " ORDER BY u.id DESC";
        if (_g('step')) {
            $start = (_g('step') - 1) * 5000;
            $end = 5000;
            $where .= ' limit ' . $start . ',' . $end;
            $filename = 'user_email_' . _g('step') . '.txt';
        }
        $userList = $this->userJoinInfoLogic->findAll($where, $asArrayId = false, $table = "", array("*"));
        foreach ($userList as $value) {
            $user_email[] = $value['base_name'];
        }
        $email_str = implode("\r\n", $user_email);
        file_put_contents($filename, $email_str);
        header("Content-Type:text/plain");
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Content-Length:' . filesize($filename));
        readfile($filename);
        @unlink($filename);
    }

    public function actionStepOutputNewsLetterEmail() {
        if (_p()) {
            $language_id = _p('language_id');
            $url = '?m=admin&c=user&a=OutPutNewsLetterEmail';
            if ($language_id) {
                $url.='&language_id=' . $language_id;
                $cond = " language_id =" . $language_id;
            } else {
                $cond = "1=1";
            }
            $newsletterLogic = $this->load('Newsletter');
            $emailnum = $newsletterLogic->getCount($cond);
            if ($emailnum > 5000) {
                $num = ceil($emailnum / 5000);
                for ($i = 1; $i <= $num; $i++) {
                    $temp = 5000 * $i;
                    $ulrs[$i]['step'] = $i;
                    $ulrs[$i]['url'] = $url . '&step=' . $i;
                }
            } else {
                $ulrs[1]['step'] = 1;
                $ulrs[1]['url'] = $url;
            }
            Core::$tpl->set('emailnum', $emailnum);
            Core::$tpl->set('ulrs', $ulrs);
        } else {
            $languages = $this->load('language')->getCols('1=1', $cols);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'user/exportdata';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionOutPutNewsLetterEmail() {
        $language_id = _g('language_id')?_g('language_id'):0;
        $filename = "EDM-site" . $language_id.'.txt';
        $where = '1=1 ';
        if ($language_id) {
            $where .= ' and language_id = ' . $language_id;
        }
        $where .= " ORDER BY id DESC";
        if (_g('step')) {
            $start = (_g('step') - 1) * 5000;
            $end = 5000;
            $where .= ' limit ' . $start . ',' . $end;
            $filename = 'EDM-site' . $language_id . '-step'._g('step').'.txt';
        }
        $newsletterLogic = $this->load('Newsletter');
        $newsletterList = $newsletterLogic->findAll($where, $asArrayId = false, $table = "", array("*"));
        foreach ($newsletterList as $value) {
            $newsletter_email[] = $value['email'];
        }
        $email_str = implode("\r\n", $newsletter_email);
        file_put_contents($filename, $email_str);
        header("Content-Type:text/plain");
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Content-Length:' . filesize($filename));
        readfile($filename);
        @unlink($filename);
    }

    public function actionSendcoupons() {
        $offerList = $this->offerLogic->findAll("status=1 and coupon_type=0 and offer_type=2 and end_time>" . SYS_TIME);
        Core::$tpl->set('offerList', $offerList);
        $user_id = Common::queryInt(_g('uid'));
        $cond = 'u.id =' . $user_id;
        $user = $this->userJoinInfoLogic->getOne($cond);
        Core::$tpl->set('user', $user);
    }

    public function actionSendcoupon() {
        $user_id = _p('user_id');
        $offer_id = _p('offer_id');
        $coupon_num = Common::queryInt(_p('coupon_num'));
        if (!$offer_id) {
            return $this->showMessage('优惠券类型未选择', Common::adminURL('admin', 'User', 'Sendcoupons', array('uid' => $user_id)));
        }
        if (!$coupon_num) {
            return $this->showMessage('优惠券张数未填写', Common::adminURL('admin', 'User', 'Sendcoupons', array('uid' => $user_id)));
        }
        $offer = $this->offerLogic->getOneById($offer_id);
        $send_num = $offer['send_num'];
        $send_limit = $offer['send_limit'];
        if ($send_limit != 0 && ($coupon_num > $send_limit - $send_num)) {
            return $this->showMessage('优惠券不足', Common::adminURL('admin', 'User', 'Sendcoupons', array('uid' => $user_id)));
        } else {
            $num = 0;
            for ($i = 0; $i < $coupon_num; $i++) {
                //优惠券编号构造
                $coupon_code = strtoupper($offer['prefix'] . date('ymdHis', time()) . Common::random(3));
                $coupon_data = array(
                    'user_id' => $user_id,
                    'offer_id' => $offer_id,
                    'coupon_code' => $coupon_code,
                    'create_time' => SYS_TIME,
                    'status' => 1,
                );
                $c_result = $this->couponLogic->save($coupon_data);
                if ($c_result) {
                    $send_num++;
                    $offer_data = array(
                        'send_num' => $send_num,
                    );
                    if ($this->offerLogic->save($offer_data, $offer_id)) {
                        $num++;
                    }
                }
            }
            if ($coupon_num == $num) {
                return $this->success('优惠券发送成功', Common::adminURL('admin', 'User', 'Sendcoupons', array('uid' => $user_id)));
            }
        }
    }

    public function actionAddCreditDetail() {
        $expire = Common::queryInt(_g('expire'));
        $user_id = Common::queryInt(_g('uid'));
        $cond = 'u.id =' . $user_id;
        $user = $this->userJoinInfoLogic->getOne($cond);
        Core::$tpl->set('user', $user);
        Core::$tpl->set('expire', $expire);
    }

    public function actionAddGrowthDetail() {
        $user_id = Common::queryInt(_g('uid'));
        $cond = 'u.id =' . $user_id;
        $user = $this->userJoinInfoLogic->getOne($cond);
        $userGroupLogic = $this->load('userGroup');
        Core::$tpl->set('user', $user);
        Core::$tpl->set('groups', $userGroupLogic->getAll());
    }
    
        public function actionToTop() {
        $commentLogic = $this->load('goodsComment');
        if (_g('id')) {
            $comment_detail = $commentLogic->getOneById(_g('id'));
            $comment_data = array(
                'goods_id' => $comment_detail['goods_id'],
                'ip' => $comment_detail['ip'],
                'value' => $comment_detail['value'],
                'base_name' => $comment_detail['value'],
                'detail' => $comment_detail['detail'],
                'user_name' => $comment_detail['user_name'],
                'user_id' => $comment_detail['user_name'],
                'status' => $comment_detail['status'],
                'is_admin_readed' => $comment_detail['is_admin_readed'],
                'reply_nickname' => $comment_detail['reply_nickname'],
                'reply_detail' => $comment_detail['reply_detail'],
                'domain' => $comment_detail['domain'],
                'country_id' => $comment_detail['country_id'],
                'reply_time' => $comment_detail['reply_time'],
                'language_id' => $comment_detail['language_id'],
                'user_email' => $comment_detail['user_email'],
                'create_time' => SYS_TIME,
            );
            $c_res = $commentLogic->save($comment_data);
            if ($c_res) {
                $res = $commentLogic->delete(' id=' . _g('id'));
            }
            if ($c_res && $res) {
                return $this->success('置顶成功', Common::adminURL('admin', 'User', 'comments'));
            } else {
                return $this->success('置顶失败', Common::adminURL('admin', 'User', 'comments'));
            }
        } else {
            return $this->success('参数错误', Common::adminURL('admin', 'User', 'comments'));
        }
    }
	
	public function actionPhoneList() {
        $page_size = 20;
        global $cfg;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
      
        $where .= " ORDER BY id DESC";
        $newsletterLogic = $this->load('userAddress');
		$country_res = $this->load('country')->findAll('1=1',true);
        $res = $newsletterLogic->getCurrentDatas($where, $page_size, $curr_page);
        $count = $newsletterLogic->getCount($where);
        $page_list = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('cfg', $cfg);
		Core::$tpl->set('country', $country_res);
        Core::$tpl->set('pages', $page_list);
    }
	
	 public function actionStepOutputPhone() {
        if (_p()) {
            $language_id = _p('language_id');
            $url = '?m=admin&c=user&a=OutPutPhone';
            if ($language_id) {
                $url.='&language_id=' . $language_id;
                $cond = " language_id =" . $language_id;
            } else {
                $cond = "1=1";
            }
            $logic = $this->load('userAddress');
            $emailnum = $logic->getCount($cond);
            if ($emailnum > 5000) {
                $num = ceil($emailnum / 5000);
                for ($i = 1; $i <= $num; $i++) {
                    $temp = 5000 * $i;
                    $ulrs[$i]['step'] = $i;
                    $ulrs[$i]['url'] = $url . '&step=' . $i;
                }
            } else {
                $ulrs[1]['step'] = 1;
                $ulrs[1]['url'] = $url;
            }
            Core::$tpl->set('emailnum', $emailnum);
            Core::$tpl->set('ulrs', $ulrs);
        } else {
            $languages = $this->load('language')->getCols('1=1', $cols);
            Core::$tpl->set('languages', $languages);
			Core::$htmlFile = 'user/exportphonedata';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
           
        }
    }
	
	public function actionOutPutPhone() {
        $language_id = _g('language_id')?_g('language_id'):0;
        $filename = "phone-site" . $language_id.'.txt';
        $where = '1=1 ';
        if ($language_id) {
            $where .= ' and language_id = ' . $language_id;
        }
        $where .= " ORDER BY id DESC";
        if (_g('step')) {
            $start = (_g('step') - 1) * 5000;
            $end = 5000;
            $where .= ' limit ' . $start . ',' . $end;
            $filename = 'phone-site' . $language_id . '-step'._g('step').'.txt';
        }
        $logic = $this->load('userAddress');
        $phone_res = $logic->findAll($where, $asArrayId = false, $table = "", array("*"));
        foreach ($phone_res as $value) {
            if($value['mobilephone'])
				$phone_list[] = $value['mobilephone'];
        }
        $phone_str = implode("\r\n", $phone_list);
        file_put_contents($filename, $phone_str);
        header("Content-Type:text/plain");
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Content-Length:' . filesize($filename));
        readfile($filename);
        @unlink($filename);
    }

}

?>
