<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ErpApi
 *
 * @author rongxiang.xie <QQ:1251679791,359285617 www.35zh.com>
 */
require_once(APP_ROOT . "conf/api.conf.php");

class ErpApiController extends AppController {

    public function __construct() {
        parent::__construct();
        ignore_user_abort(true);
        set_time_limit(0);
    }

    /**
     * 修改星标和添加订单备注
     */
    public function actionUpdateOrderMarkedOrRemark() {
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $itemno = Common::queryStr(_p('itemno'), '');
        $order_remark = _p('order_remark');
        $order_remark = json_decode(urldecode($order_remark), true);
        $update_marked = 0;
        $add_remark = 0;
        $order = $this->load('order')->getOne("itemno='" . $itemno . "'");
        if (!$order) {
            echo json_encode(array('code' => 2001)); //订单号错误
            exit;
        }
        if (_p('marked') != "") {
            if(_p('is_cover')) {
                $marked = Common::queryInt(_p('marked'), 0);
                $map = Zhtx::createDataMap();
                $map->addEntry('marked', $marked, DB::INT);
                $update_marked = $this->load('order')->update($map, "itemno='" . $itemno . "'");
            } else {
                $order_info = $this->load('order')->getOne("itemno='" . $itemno . "'");
                $marked = ($order_info['marked'] | _p('marked'));
                $map = Zhtx::createDataMap();
                $map->addEntry('marked', $marked, DB::INT);
                $update_marked = $this->load('order')->update($map, "itemno='" . $itemno . "'"); 
            }
        }
        
        if ($order_remark && is_array($order_remark)) {
            $orderRemarkLogic = $this->load('orderRemark');
            foreach ($order_remark as $key => $val) {
                $order_remark_data = array(
                    'admin_id' => 0,
                    'admin_name' => 'API',
                    'order_id' => $order['id'],
                    'ip' => Common::_ip2long(Common::ip()),
                    'remark' => Common::strEscape($val),
                    'marker' => 7,
                    'remark_type' => $order['order_status'],
                    'create_time' => SYS_TIME,
                );
                $add_return = $orderRemarkLogic->save($order_remark_data);
                if ($add_return) {
                    $add_remark++;
                }
            }
        }
        $code = -1;
        if (!$update_marked && !$add_remark) {
            $code = -2; //没有任何更新
        }
        echo json_encode(array('code' => $code));
        exit;
    }

    /**
     *  ERP获取订单接口
     *
     */
    public function actionGetOrderList() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $start_date = _p('start_date');
        $end_date = _p('end_date');
        $dateType = _p('datetype') == 2 ? 'act_time' : 'create_time'; //默认下单时间
        $status = _p('status');
        $type = _p('type');
        $pay_time = Common::queryInt(_p('pay_time'), 0);
        $page = Common::queryInt(_p('page_no'), 1);
        $psize = Common::queryInt(_p('page_size'), 40);
        $itemno = _p('itemno');
        $order_cond = 'act_time>=' . $pay_time;
        if ($itemno) {
            $order_cond .= " and o.itemno='" . mysql_escape_string($itemno) . "'";
        }
        if ($start_date && $end_date) {
            $order_cond .= ' and o.' . $dateType . ' between ' . strtotime($start_date) . ' and ' . strtotime($end_date);
        }
        if ($status == 1) {
            $order_cond .= ' and (o.shipping_status < 204 and o.payment_status = 201 )';
        } else if ($status == 2) {
            $order_cond .= ' and o.shipping_status between 203 and 300';
        } else if ($status == 3) {//缺货
            $order_cond .= ' and o.shipping_status == 402';
        } else if ($status == 4) {//退货
            $order_cond .= ' and o.shipping_status between 300 and 400';
        }
        $count_order_cond = $order_cond;
        if ($pay_time > 0)
            $order_cond .= ' order by o.act_time asc limit ' . ($page - 1) * $psize . ' ,' . $psize;
        else
            $order_cond .= ' order by o.id desc limit ' . ($page - 1) * $psize . ' ,' . $psize;

        $corp = $this->load('ShippingCorp');
        $shippingCorp = $corp->findAll('1=1', true);
        $orderJoinAddrUserLogic = $this->load('orderJoinAddress');
        $order_total_nums = $orderJoinAddrUserLogic->getCount($count_order_cond);
		
		if(!$order_total_nums)
		{
			$result['code'] = 0;
			$result['msg'] = '';
			$result['total_results'] = 0;
			echo json_encode($result);
       		exit;
		}
        $orderList = $orderJoinAddrUserLogic->findAll($order_cond);
        $order_ids = array(0);
        $shiping_ids = array(0);
        $country_ids = array(0);
        $currencies = array(0);
        foreach ($orderList as $list) {
            $order_ids[] = $list['id'];
            $shiping_ids[$list['shipping_id']] = $list['shipping_id'];
            $country_ids[$list['country_id']] = $list['country_id'];
            $country_ids[$list['address_country_id']] = $list['address_country_id'];
            $currencies[$list['id']] = $list['currency_code'];
        }
        //付款单据
        $cond = 'o.order_id in (' . implode(',', $order_ids) . ') and o.payment_type=1';
        $orderPaymentLogic = $this->load('orderPaymentJoinPayment');
        $orderPayment = $orderPaymentLogic->findAll($cond);
        $pay_order_rel = array();
        foreach ($orderPayment as $pay) {
            $pay_order_rel[$pay['order_id']] = $pay;
        }
        //物流
        $shippingLogic = $this->load('shippingJoinCorp');
        $deliveryLogic = $this->load('orderDelivery');
        $shipping_cond = 's.id in(' . implode(',', $shiping_ids) . ')';
        $logistics = $shippingLogic->findAll($shipping_cond, true);
        $deliveries = array();
        $deliveriyList = $deliveryLogic->findAll('order_id in(' . implode(',', $order_ids) . ') order by delivery_time desc');
        foreach ($deliveriyList as $deliveriy) {
            $deliveries[$deliveriy['order_id']] = $deliveriy;
            $country_ids[$deliveriy['country_id']] = $deliveriy['country_id'];
        }
        //订单商品
        $itemLogic = $this->load('orderItemJoinSkuGoods');
        $item_cond = 'i.order_id in(' . implode(',', $order_ids) . ')';
        $itemList = $itemLogic->findAll($item_cond);
        $orderItems = array();
        foreach ($itemList as $value) {
            $item = array(
                'goods_name' => $value['goods_name'],
                'codeno' => $value['codeno'],
                'goods_id' => $value['goods_id'],
                'out_sku_id' => $value['sku_codeno'],
                'price' => $value['price'],
                'currency' => $currencies[$value['order_id']],
                'nums' => $value['buy_num'],
                'gcodeno' => $value['gcodeno'],
            );
            $orderItems[$value['order_id']][] = $item;
        }
        $countries = $this->load('country')->findAll('id in(' . implode(',', $country_ids) . ')', true);
        $result['code'] = 0;
        $result['msg'] = '';
        $result['modified_time'] = date('Y-m-d H:i:s', SYS_TIME);
        $result['total_results'] = $order_total_nums;
        foreach ($orderList as $order) {
            $country = isset($countries[$order['address_country_id']]) ? $countries[$order['address_country_id']] : '';
            $payment = isset($pay_order_rel[$order['id']]) ? $pay_order_rel[$order['id']] : '';
            $delivery = isset($deliveries[$order['id']]) ? $deliveries[$order['id']] : '';
            $receiver_phone = '';
            $logistic_com_no = '';
            $logistic_no = '';
            if ($delivery) {
                $receiver_phone = $delivery['mobilephone'] ? $delivery['mobilephone'] : $delivery['telephone'];
                $logistic_com_no = $shippingCorp[$delivery['shipping_corp_id']]['codeno'];
                $logistic_no = $delivery['delivery_no'];
                $country = isset($countries[$delivery['country_id']]) ? $countries[$delivery['country_id']] : '';
            } else {
                $logistic_com_no = $shippingCorp[$order['shipping_corp_id']]['codeno'];
                $receiver_phone = $order['mobilephone'] ? $order['mobilephone'] : $order['telephone'];
            }

            $result['orderlist'][] = array(
                "order_no" => $order['itemno'],
                "num" => "1",
                "member_memo" => $order['remark'],
                "amount" => $order['final_amount'],
                "payed_amount" => $order['payed'],
                "currency" => $order['currency_code'],
                "currency_rate" => $order['currency_rate'],
                "status" => 3,
                "type" => 1,
                "payment_type" => $payment ? $payment['interface_type'] : '',
                "post_fee" => $order['cost_shipping'],
                "discount_fee" => 0,
                "create_time" => date('Y-m-d H:i:s', $order['create_time']),
                "pay_time" => $payment['end_time'] ? date('Y-m-d H:i:s', $payment['end_time']) : date('Y-m-d H:i:s', $payment['create_time']),
                "act_time" => $order['act_time'],
                "receiver_firstname" => $delivery ? $delivery['first_name'] : $order['first_name'],
                "receiver_lastname" => $delivery ? $delivery['last_name'] : $order['last_name'],
                "receiver_cuntry" => $country['base_name'],
                "receiver_country" => $country['base_name'],
                "country_code_2" => $country['country_code_2'],
                "country_code_3" => $country['country_code_3'],
                "receiver_state" => $delivery ? $delivery['state'] : $order['state'],
                "receiver_city" => $delivery ? $delivery['city'] : $order['city'],
                "receiver_address" => $$delivery ? $delivery['address'] : $order['address'],
                "receiver_phone" => $receiver_phone,
                "receiver_zip" => $delivery ? $delivery['postcode'] : $order['postcode'],
                "receiver_email" => $delivery ? $delivery['email'] : $order['email'],
                "logistic_id" => $delivery ? $delivery['shipping_id'] : $order['shipping_id'],
                "logistic_com_no" => $logistic_com_no,
                "logistic_no" => $logistic_no,
                "itemlist" => isset($orderItems[$order['id']]) ? $orderItems[$order['id']] : array(),
                "logistic_com_name" => $shippingCorp[$order['shipping_corp_id']]['codeno'],
            );
        }
        echo json_encode($result);
        exit;
    }

    /**
     * ERP 获取快递列表信息
     */
    public function actionGetDeliverylogistics() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $shippingLogic = $this->load('shippingJoinCorp');
        $logistics = $shippingLogic->findAll();
        foreach ($logistics as $logistic) {
            $item = array(
                'id' => $logistic['id'],
                'name' => $logistic['base_name'],
                'logistic_com_no' => $logistic['interface_code'],
            );
            $result['logistics_company'][] = $item;
        }
        echo json_encode($result);
        exit;
    }

    /**
     * ERP 推送的订单备注
     */
    public function actionPostTradeMemoSend() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        if (!isset($params['order_no']) || !$params['order_no']) {
            $result['code'] = 2001;
            echo json_encode($result);
            exit;
        } else if (!isset($params['body']) || !$params['body']) {
            $result['code'] = 2013;
            echo json_encode($result);
            exit;
        } else {
            $order = $this->load('order')->getOne('itemno="' . $params['order_no'] . '"');
            if (!$order) {
                $result['code'] = 2001;
                echo json_encode($result);
                exit;
            }
            $data = array(
                'order_id' => $order['id'],
                'marker' => 7,
                'remark_type' => $order['order_status'],
                'remark' => $params['body'],
                'create_time' => SYS_TIME,
            );
            $res = $this->load('orderRemark')->saveByCond($data);
            $result['code'] = $res ? 0 : -1;
            echo json_encode($result);
            exit;
        }
        $result['code'] = -1;
        echo json_encode($result);
        exit;
    }

    /**
     * ERP 推送的订单发货
     */
    public function actionPostLogisticsSend() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        if (!isset($params['order_no']) || !$params['order_no']) {
            $result['code'] = 2001;
            echo json_encode($result);
            exit;
        } else if (!isset($params['logistic_com_no']) || !$params['logistic_com_no']) {
            $result['code'] = 2007;
            echo json_encode($result);
            exit;
        } else if (!isset($params['logistic_no']) || !$params['logistic_no']) {
            $result['code'] = 2006;
            echo json_encode($result);
            exit;
        } else {
            $orderLogic = $this->load('order');
            $order = $orderLogic->getOne('itemno="' . $params['order_no'] . '"');
            if (!$order) {
                $result['code'] = 2001;
                echo json_encode($result);
                exit;
            }
            if (!$params['logistic_com_no'])
                $shipping_corp = $this->load('ShippingCorp')->getOne("shipping_corp_id = " . $order['shipping_corp_id']);
            else
                $shipping_corp = $this->load('ShippingCorp')->getOne("codeno like '" . $params['logistic_com_no'] . "'");
            if (!$shipping_corp) {
                $result['code'] = 2007;
                echo json_encode($result);
                exit;
            }

            if ($order['shipping_status'] > 203) {
                $result['code'] = 2003;
                echo json_encode($result);
                exit;
            }
            $orderAddress = $this->load('orderAddress')->getOne('order_id=' . $order['id']);
            $receipt_no = date('Ymdhsi', SYS_TIME) . Common::random(6);
            $data = array(
                'receipt_no' => $receipt_no,
                'delivery_type' => 1,
                'order_id' => $order['id'],
                'user_id' => $order['user_id'],
                'delivery_no' => $params['logistic_no'],
                'shipping_id' => 0,
                'shipping_corp_id' => $shipping_corp['id'],
                'shipping_corp_no' => $shipping_corp['interface_code'],
                'shipping_cost' => $order['cost_shipping'],
                'create_time' => SYS_TIME,
                'delivery_time' => SYS_TIME,
                'status' => 1,
                'first_name' => Common::strEscape($orderAddress['first_name']),
                'last_name' => Common::strEscape($orderAddress['last_name']),
                'country_id' => $orderAddress['country_id'],
                'state' => Common::strEscape($orderAddress['state']),
                'city' => Common::strEscape($orderAddress['city']),
                'address' => Common::strEscape($orderAddress['address']),
                'mobilephone' => Common::strEscape($orderAddress['mobilephone']),
                'telephone' => Common::strEscape($orderAddress['telephone']),
                'email' => Common::strEscape($orderAddress['email']),
                'postcode' => Common::strEscape($orderAddress['postcode']),
            );
            $res = $this->load('orderDelivery')->saveByCond($data);
            if ($res) {
                $result['code'] = 0;
                $order_data = array(
                    'shipping_status' => 204,
                    'order_status' => 204,
                    'act_time' => SYS_TIME,
                );
                $orderLogic->saveByCond($order_data, 'id=' . $order['id']);
                EventFactory::orderShipAfter($order);
            }
            echo json_encode($result);
            exit;
        }
        $result['code'] = -1;
        echo json_encode($result);
        exit;
    }

    /**
     * 单个订单或者多个订单获取接口
     */
    public function actionGetOrderInfo() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $order_no_set = _p('order_no');
        if (!$order_no_set) {
            $result['code'] = 2001;
            echo json_encode($result);
            exit;
        }
        $pay_time = Common::queryInt(_p('pay_time'), 0);
        //字符需要加上双引号
        $order_no_set_str = '"' . implode('","', explode(',', $order_no_set)) . '"';
        $order_cond = 'act_time>=' . $pay_time . ' and o.itemno in (' . $order_no_set_str . ')';
        $order_cond .= ' order by o.create_time desc';
        $orderJoinAddrUserLogic = $this->load('orderJoinAddress');
        $orderList = $orderJoinAddrUserLogic->findAll($order_cond);
        $order_ids = array();
        $shiping_ids = array();
        $country_ids = array();
        $currencies = array();
        foreach ($orderList as $list) {
            $order_ids[] = $list['id'];
            $shiping_ids[$list['shipping_id']] = $list['shipping_id'];
            $country_ids[$list['country_id']] = $list['country_id'];
            $country_ids[$list['address_country_id']] = $list['address_country_id'];
            $currencies[$list['id']] = $list['currency_code'];
        }
        //付款单据
        $cond = 'o.order_id in (' . implode(',', $order_ids) . ') and o.payment_type=1';
        $orderPaymentLogic = $this->load('orderPaymentJoinPayment');
        $orderPayment = $orderPaymentLogic->findAll($cond);
        $pay_order_rel = array();
        foreach ($orderPayment as $pay) {
            $pay_order_rel[$pay['order_id']] = $pay;
        }
        //物流
        $shippingLogic = $this->load('shippingJoinCorp');
        $deliveryLogic = $this->load('orderDelivery');
        $shipping_cond = 's.id in(' . implode(',', $shiping_ids) . ')';
        $logistics = $shippingLogic->findAll($shipping_cond, true);
        $deliveries = array();
        $deliveriyList = $deliveryLogic->findAll('order_id in(' . implode(',', $order_ids) . ') order by delivery_time desc');
        foreach ($deliveriyList as $deliveriy) {
            $deliveries[$deliveriy['order_id']] = $deliveriy;
            $country_ids[$deliveriy['country_id']] = $deliveriy['country_id'];
        }
        //订单商品
        $itemLogic = $this->load('orderItemJoinSkuProduct');
        $item_cond = 'i.order_id in(' . implode(',', $order_ids) . ')';
        $itemList = $itemLogic->findAll($item_cond);
        $orderItems = array();
        foreach ($itemList as $value) {
            $item = array(
                'goods_name' => $value['goods_name'],
                'codeno' => $value['codeno'],
                'goods_id' => $value['goods_id'],
                'out_sku_id' => $value['sku_codeno'],
                'price' => $value['price'],
                'currency' => $currencies[$value['order_id']],
                'nums' => $value['buy_num'],
            );
            $orderItems[$value['order_id']][] = $item;
        }
        $countries = $this->load('country')->findAll('id in(' . implode(',', $country_ids) . ')', true);
        $result['code'] = 0;
        $result['msg'] = '';
        $result['modified_time'] = date('Y-m-d H:i:s', SYS_TIME);
        $result['total_results'] = count($orderList);
        foreach ($orderList as $order) {
            $country = isset($countries[$order['address_country_id']]) ? $countries[$order['address_country_id']] : '';
            $payment = isset($pay_order_rel[$order['id']]) ? $pay_order_rel[$order['id']] : '';
            $logistic = isset($logistics[$order['shipping_id']]) ? $logistics[$order['shipping_id']] : '';
            $delivery = isset($deliveries[$order['id']]) ? $deliveries[$order['id']] : '';
            $receiver_phone = '';
            $logistic_com_no = '';
            $logistic_no = '';
            if ($delivery) {
                $receiver_phone = $delivery['mobilephone'] ? $delivery['mobilephone'] : $delivery['telephone'];
                $logistic_com_no = $delivery['shipping_corp_no'];
                $logistic_no = $delivery['delivery_no'];
                $country = isset($countries[$delivery['country_id']]) ? $countries[$delivery['country_id']] : '';
            } else {
                $logistic_com_no = $logistic ? $logistic['interface_code'] : '';
                $receiver_phone = $order['mobilephone'] ? $order['mobilephone'] : $order['telephone'];
            }
            $result['orderlist'][] = array(
                "order_no" => $order['itemno'],
                "num" => "1",
                "member_memo" => $order['remark'],
                "amount" => $order['final_amount'],
                "payed_amount" => $order['payed'],
                "currency" => $order['currency_code'],
                "status" => 3,
                "type" => 1,
                "payment_type" => $payment ? $payment['interface_type'] : '',
                "post_fee" => $order['cost_shipping'],
                "discount_fee" => 0,
                "create_time" => date('Y-m-d H:i:s', $order['create_time']),
                "pay_time" => $payment ? date('Y-m-d H:i:s', $payment['end_time']) : '',
                "receiver_firstname" => $delivery ? $delivery['first_name'] : $order['first_name'],
                "receiver_lastname" => $delivery ? $delivery['last_name'] : $order['last_name'],
                "receiver_cuntry" => $country['base_name'],
                "country_code_2" => $country['country_code_2'],
                "country_code_3" => $country['country_code_3'],
                "receiver_state" => $delivery ? $delivery['state'] : $order['state'],
                "receiver_city" => $delivery ? $delivery['city'] : $order['city'],
                "receiver_address" => $$delivery ? $delivery['address'] : $order['address'],
                "receiver_phone" => $receiver_phone,
                "receiver_zip" => $delivery ? $delivery['postcode'] : $order['postcode'],
                "receiver_email" => $delivery ? $delivery['email'] : $order['email'],
                "logistic_id" => $delivery ? $delivery['shipping_id'] : $order['shipping_id'],
                "logistic_com_no" => $logistic_com_no,
                "logistic_no" => $logistic_no,
                "itemlist" => isset($orderItems[$order['id']]) ? $orderItems[$order['id']] : array(),
            );
        }
        echo json_encode($result);
        exit;
    }

    /**
     * ERP订单缺货推送
     */
    public function actionPostOutOfStockSend() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $order_no = _p('order_no');
        if (!$order_no) {
            $result['code'] = 2001;
            echo json_encode($result);
            exit;
        }
    }

    /**
     * ERP获取当前系统时间
     */
    public function actionGetSystemTime() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $result['systemTime'] = date('Y-m-d H:i:s', time());
        echo json_encode($result);
        exit;
    }

    /**
     * 更新商品库存
     */
    public function actionUpdateQty() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $sku_codeno_set = _p('sku_id');
        if (!$sku_codeno_set) {
            $result['code'] = 2090;
            echo json_encode($result);
            exit;
        }
        $qtys = _p('quantity');
        if ($qtys == '') {
            $result['code'] = 2090;
            echo json_encode($result);
            exit;
        }
        $skuLogic = $this->load('sku');
        $goodsLang = $this->load('GoodsLanguage');
        $goodsLogic = $this->load('goods');
        $qtys_array = explode(",", $qtys);
        $sku_codenos = explode(',', $sku_codeno_set);
        $fail = 0;
        foreach ($sku_codenos as $key => $value) {
            $qty = isset($qtys_array[$key]) ? $qtys_array[$key] : 0;
            $sku_data = array(
                'stock_nums' => $qty,
                'status' => $qty > 0 ? 1 : 0,
            );
            if (!$value)
                continue;
            $sku_cond = "codeno ='" . $value . "'";
            $res = $skuLogic->saveByCond($sku_data, $sku_cond);
            if ($res) {
                $cur_sku = $skuLogic->getOne($sku_cond);
                if (!$cur_sku)
                    continue;

                $cols = array('goods_id', 'sum(stock_nums) as stock_nums');
                $skus = $skuLogic->getCols('goods_id=' . $cur_sku['goods_id'], $cols);
                foreach ($skus as $sku) {
                    $goods_data = array(
                        'stock_nums' => $sku['stock_nums'],
                        'status' => 1,
                    );
                    $goodsLogic->saveByCond($goods_data, 'id=' . $cur_sku['goods_id']);

                    $goods_data = array(
                        'status' => 1,
                    );
                    $goodsLang->saveByCond($goods_data, 'goods_id=' . $cur_sku['goods_id']);

                    if ($sku['stock_nums'] > 0) {
                        $map = Zhtx::createDataMap();
                        $map->addEntry('listorder', 'ABS(listorder)', DB::INT);
                        $where = 'id=' . $cur_sku['goods_id'] . " and listorder<0";
                        $goodsLogic->update($map, $where);

                        $map = Zhtx::createDataMap();
                        $map->addEntry('listorder', 'ABS(listorder)', DB::INT);
                        $where = 'goods_id=' . $cur_sku['goods_id'] . " and listorder<0";
                        $goodsLang->update($map, $where);
                    } else {
                        $map = Zhtx::createDataMap();
                        $map->addEntry('listorder', '(-1)*ABS(listorder)', DB::INT);
                        $where = 'id=' . $cur_sku['goods_id'] . " and listorder>0";
                        $goodsLogic->update($map, $where);

                        $map = Zhtx::createDataMap();
                        $map->addEntry('listorder', '(-1)*ABS(listorder)', DB::INT);
                        $where = 'goods_id=' . $cur_sku['goods_id'] . " and listorder>0";
                        $goodsLang->update($map, $where);
                    }
                }
            } else {
                $fail++;
            }
        }
        if ($fail) {
            echo json_encode(array('code' => -1));
            exit;
        }
        echo json_encode(array('code' => 0));
        exit;
    }

    /**
     * 获取商品信息
     */
    public function actionGetProduct() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $codeno_set = _p('code_no');
        $page = Common::queryInt(_p('page_no'), 1);
        $psize = Common::queryInt(_p('page_size'), 10);
        if (!$codeno_set) {
            $goodsLogic = $this->load('goodsJoinLanguage');
            $goods_cond = 'g.status=1 order by id desc limit ' . ($page - 1) * $psize . ',' . $psize;
            $cols = array('distinct g.id', 'g.id', 'g.base_name', 'g.codeno', 'g.price', 'g.image', 'g.brand_id', 'g.goods_type_id', 'g.cost_price', 'g.market_price', 'g.weight', 'g.old_price', 'g.create_time', 'l.title', 'l.keywords', 'l.descript');
            $goodslist = $goodsLogic->getCols($goods_cond, $cols);
        } else {
            $detail = _p('detail');
            $codeno_set_str = '"' . implode('","', explode(',', $codeno_set)) . '"';
            $goodsLogic = $this->load('goodsJoinLanguage');
            $goods_cond = 'g.codeno in(' . $codeno_set_str . ') limit ' . ($page - 1) * $psize . ',' . $psize;
            $cols = array('distinct g.id', 'g.id', 'g.base_name', 'g.codeno', 'g.price', 'g.image', 'g.brand_id', 'g.goods_type_id', 'g.cost_price', 'g.market_price', 'g.weight', 'g.old_price', 'g.create_time', 'l.title', 'l.keywords', 'l.descript');
            if ($detail) {
                $cols = array_merge($cols, array('l.detail'));
            }

            $goodslist = $goodsLogic->getCols($goods_cond, $cols);
        }
        $goods_ids = array();
        foreach ($goodslist as $goods) {
            $goods_ids[$goods['id']] = $goods['id'];
        }
        $productOtherimageLogic = $this->load('productOtherImage');
        $img_cond = 'goods_id in(' . implode(',', $goods_ids) . ') order by listorder asc';
        $img_cols = array('goods_id', 'image', 'listorder');
        $otherimage = $productOtherimageLogic->getCols($img_cond, $img_cols);
        $otherimageList = array();
        foreach ($otherimage as $value) {
            $item = array(
                'image' => $value['image'],
            );
            $otherimageList[$value['goods_id']][] = $item;
        }
        /*
          $skuLogic = $this->load('sku');
          $sku_cond = 'goods_id in(' . implode(',', $goods_ids) . ')';
          $sku_cols = array('goods_id','codeno as sku_id', 'stock_nums as num');
          $skus     = $skuLogic->getCols($sku_cond, $sku_cols);
          $skuList  = array();
          foreach ($skus as $value)
          {
          $item = array(
          'sku_id' => $value['sku_id'],
          'num'  => $value['num'],
          );
          $skuList[$value['goods_id']][] = $item;
          }
         * */
        //获取分类信息
        $goodsCategoryRelCategoryLogic = $this->load('goodsCategoryRelCategory');
        $cateGoryCond = ' goods_id in(' . implode(',', $goods_ids) . ') ';
        $goodsCategoryRelCategory = $goodsCategoryRelCategoryLogic->getCols($cateGoryCond);
        $cateGoryArray = array();
        foreach ($goodsCategoryRelCategory as &$val) {
            $cateGoryArray[$val['goods_id']] = $val;
        }
        foreach ($goodslist as $list) {
            $result['Data']['ProductList'][] = array(
                'id' => $list['id'],
                'codeno' => $list['codeno'],
                'goods_name' => $list['base_name'],
                'price' => $list['price'],
                'image' => $list['image'],
                'brand_id' => $list['brand_id'],
                'goods_type_id' => $list['goods_type_id'],
                'cost_price' => $list['cost_price'],
                'market_price' => $list['market_price'],
                'old_price' => $list['old_price'],
                'weight' => $list['weight'],
                'create_time' => $list['create_time'],
                'detail' => $list['detail'],
                'seo_title' => $list['title'],
                'seo_keywords' => $list['keywords'],
                'seo_descript' => $list['descript'],
                //'skulist' => isset($skuList[$list['id']]) ? $skuList[$list['id']] : array(),
                'otherimagelist' => isset($otherimageList[$list['id']]) ? $otherimageList[$list['id']] : array(),
                'category_name' => $cateGoryArray[$list['id']]['base_name'],
            );
        }
        $result['code'] = -1;
        $result['msg'] = 'Success';
        echo json_encode($result);
        exit;
    }

    /**
     * 获取最新的物流单号
     */
    public function actionGetLastestTrackno() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $max_id = (int) _p('id');
        $cond = 'id>' . $max_id;
        $page = Common::queryInt(_p('page_no'), 1);
        $psize = Common::queryInt(_p('page_size'), 40);
        $logic = $this->load('OrderDelivery');
        $total_nums = $logic->getCount($cond);
        $cond .= ' order by id asc limit ' . ($page - 1) * $psize . ' ,' . $psize;
        $result['total_results'] = $total_nums;
        $res = $logic->getList($cond, "", array("id", "delivery_no", "shipping_corp_id"));
        $corp = $this->load('ShippingCorp');
        $shippingCorp = $corp->findAll('1=1', true);

        foreach ($res['list'] as $item) {
            $item['interface_code'] = $shippingCorp[$item['shipping_corp_id']]['interface_code'];
            unset($item['shipping_corp_id']);
            $deliveryList[] = $item;
        }
        $result['deliveryList'] = $deliveryList;
        $result['code'] = -1;
        echo json_encode($result);
        exit;
    }

    /**
     *  更新 物流回调数据
     *
     */
       public function actionUpdateTrackingData() {

        $result = array();

        $params = Inputer::getOrgPost();

		//var_dump($params);

        $result['code'] = $this->checkSign($params);

        if ($result['code'] !== 0) {

            echo json_encode($result);

            exit;

        }

        //$params['body'] = str_replace('\\', '\\\\', $params['body']);



        $body = _p("body");

        $data = json_decode($params['body'], true);

		//var_dump($data);

        $deliveryLogic = $this->load("OrderDelivery");

        foreach ($data['list'] as $item) {

            $delivery_data = json_decode($item["delivery_data"], true);

            $last_string = $delivery_data['data'][count($delivery_data['data']) - 1]["context"];

            $last_time = $delivery_data['data'][count($delivery_data['data']) - 1]["time"];

            $first_time = strtotime($delivery_data['data'][0]["time"]);

            $delivery_status = 0;

            $delivery_status = $item['delivery_status'];

            if ($delivery_status == 2) {

                $sign_time = strtotime($last_time);

            } else {

                $sign_time = 0;

            }

            //echo $item["delivery_data"];

            $cond = "delivery_no = '" . $item["delivery_no"] . "'";

            $map = Zhtx::createDataMap();

            if ($sign_time) {

                $map->addEntry('sign_time', $sign_time, DB::INT);

            }

            $map->addEntry('delivery_time', $first_time, DB::INT);

            $map->addEntry('delivery_data', mysql_escape_string($item["delivery_data"]), DB::TEXT);

            $map->addEntry('delivery_status', $item["delivery_status"], DB::INT);

            $deliveryLogic->update($map, $cond, $table = "");

        }

        $result['code'] = -1;

        echo json_encode($result);

        exit;

    }


    /**
     *  插入商品基本的数据
     *
     */
    public function actionGoodsAdd() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $good_info = json_decode($params['good'], true);
        $goodsLogic = $this->load('goods');
        if ($good_info['codeno']) {
            $cond = "codeno='" . $good_info['codeno'] . "'";
            $goods_count = $goodsLogic->getCount($cond);
            if ($goods_count > 0) {
                $result = array();
                $result['code'] = 2010;
                echo json_encode($result);
                exit;
            }
        }

        $goods_data = array(
            'base_name' => Common::strEscape($good_info['base_name']),
            'codeno' => Common::strEscape($good_info['codeno']),
            'brand_id' => 0,
            'goods_type_id' => 0,
            'create_time' => SYS_TIME,
            'image' => Common::strEscape($good_info['image']),
            'price' => $good_info['price'],
            'cost_price' => $good_info['cost_price'],
            'modify_time' => SYS_TIME,
            'weight' => $good_info['weight'],
            'status' => 0,
        );

        $goods_result = $goodsLogic->save($goods_data);
        if (!$good_info['codeno']) {
            $codeno = $goods_result;
        } else
            $codeno = $good_info['codeno'];
        if ($goods_result) {
            // -- 创建文件夹
            $imageLogic = $this->load('ProductOtherImage');

            $targetdir = UPLOAD_GOODS_DIR . date('Y', SYS_TIME) . '/' . date('m', SYS_TIME) . '/' . date('d', SYS_TIME) . '/';
            Common::rmkdir($targetdir);
            $upload_path = "goods/" . date('Y', SYS_TIME) . '/' . date('m', SYS_TIME) . '/' . date('d', SYS_TIME) . '/';
            $languages = $this->load('language')->findALL('status=1', true);
            foreach ($languages as $item) {
                $lang_data = array(
                    'goods_id' => $goods_result,
                    'language_id' => $item['id'],
                    'base_name' => Common::strEscape($good_info['base_name']),
                    'detail' => Common::strEscape($good_info['detail'], FALSE),
                    'title' => Common::strEscape($good_info['seo_title']),
                    'keywords' => Common::strEscape($good_info['seo_keywords']),
                    'descript' => Common::strEscape($good_info['seo_descript']),
                    'template_page' => '',
                    'status' => 0,
                    'category_path' => '',
                    'price' => $good_info['price'],
                    'up_time' => SYS_TIME,
                    'listorder' => $goods_result * 10,
                    'search_keyword' => Common::strEscape($good_info['base_name']) . ' ' . $codeno,
                );
                $this->load('GoodsLanguage')->save($lang_data);
            }
            if ($good_info['image']) {
                $info = pathinfo($good_info['image']);
                $file_name = $codeno . "-" . $goods_result . "-1" . "." . $info['extension'];
                $img_content = Common::getRemoteData($good_info['image']);
                if ($img_content) {
                    file_put_contents($targetdir . $file_name, $img_content);
                }
                $main_image = $upload_path . $file_name;
                $img_data = array(
                    'image' => $main_image,
                    'listorder' => 1,
                    'goods_id' => $goods_result,
                    'status' => 1,
                    'type' => 0,
                );
                $imageLogic->save($img_data);
                $update_goods_data = array(
                    'listorder' => $goods_result * 10,
                    'codeno' => $codeno,
                    'image' => $main_image,
                );
                $goodsLogic->save($update_goods_data, $goods_result);
            }
            //绑定分类            
            if ($good_info['category_name']) {
                $cagegoryLogic = $this->load('goodsCategoryJoinLang');
                $cond = ' c.base_name="' . $good_info['category_name'] . '"';
                $categoryData = $cagegoryLogic->getOne($cond);                
                if ($categoryData) {
                    $goodsCategoryRelLogic = $this->load('goodsCategoryRel');
                    $map = Zhtx::createDataMap();
                    $map->addEntry('goods_id',$goods_result, DB::INT);
                    $map->addEntry('goods_category_id',$categoryData['id'], DB::INT);
                    $map->addEntry('category_path',$categoryData['path_id'], DB::VARCHAR);                          
                    if(!$goodsCategoryRelLogic->insert($map)){
                        Common::log('Insert Failure!');
                    }
                }
            }
            $index = 2;
            foreach ($good_info['other_images'] as $item) {
                if ($item) {
                    $info = pathinfo($item);
                    $file_name = $codeno . "-" . $goods_result . "-" . $index . "." . $info['extension'];
                    $img_content = Common::getRemoteData($item);
                    if ($img_content) {
                        file_put_contents($targetdir . $file_name, $img_content);
                    }
                    $main_image = $upload_path . $file_name;
                } else {
                    continue;
                }
                $img_data = array(
                    'image' => $main_image,
                    'listorder' => $index,
                    'goods_id' => $goods_result,
                    'status' => 1,
                    'type' => 0,
                );
                $imageLogic->save($img_data);
                $index++;
            }
            $result = array();
            $result['code'] = -1;
            $result['goods_id'] = $goods_result;
            echo json_encode($result);
            exit;
        }
    }

    public function actionGetAllSKUS() {
        
    }

    /**
     * 更新商品销量
     */
    public function actionUpdateSale() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $sale_info = _p('sale_info');
        if (!$sale_info) {
            $result['code'] = 2090;
            echo json_encode($result);
            exit;
        }
        $goodsLogic = $this->load('goods');

        $fail = 0;
        foreach ($sale_info as $key => $value) {
            $goods_data = array(
                'buy_counts' => $value['buy_counts'],
            );
            $goods_cond = "codeno ='" . $value['codeno'] . "'";
            $res = $goodsLogic->saveByCond($goods_data, $goods_cond);
            if (!$res) {
                $fail++;
            }
        }
        if ($fail) {
            echo json_encode(array('code' => 0));
            exit;
        }
        echo json_encode(array('code' => -1));
        exit;
    }

    /**
     * 效验签名是否匹配
     * @param type $params
     * @param type $erp_sign
     * @return type
     */
    public function checkSign($params) {
		print_r($params);
        if (!API_STATUS)
            return 1012;
        $timeout = time() - strtotime($params['timestamp']);
        if ($params['timezone']) {
            $offset = Common::get_timezone_offset($params['timezone'], date_default_timezone_get());
            $timeout = time() - strtotime(date('Y-m-d H:i:s', strtotime($params['timestamp']) + (int) $offset));
        }
        $code = 0;
        if (!isset($params['sign'])) {
            $code = 1004;
        } else if (!isset($params['timestamp'])) {
            $code = 1008;
        } else if (!preg_match("/^((?:19|20)[0-9]{2})-[0-9]{2}-[0-9]{2} [0-9]{2}(\:)[0-9]{2}(\:)[0-9]{2}$/", $params['timestamp']) || $timeout > 60) {
            //$code = 1009;
        } else {
            $erp_sign = $params['sign'];
            unset($params['sign']);
            $sign = $this->generateSign($params);
            $code = $erp_sign == $sign ? 0 : 1005;
        }
        return $code;
    }

    /**
     * 服务端签名生成
     * @param array $params ERP传输的参数数组(不包含sign)
     * @return string
     */
    function generateSign($params) {
        if ($params['api_type'] == 'product') {
            $api_signkey = md5(md5(PRODUCT_KEY));
            //定义字符串开始 结尾所包括的字符串
            $stringToBeSigned = PRODUCT_KEY;
        } else {
            $api_signkey = md5(md5(API_KEY . API_SECRET));
            $stringToBeSigned = API_KEY;
        }

        //所有请求参数按照字母先后顺序排序
        ksort($params);

        //把所有参数名和参数值串在一起
        foreach ($params as $k => $v) {
            $stringToBeSigned .= "$k$v";
        }
        unset($k, $v);
        //把venderKey夹在字符串的两端
        $stringToBeSigned .= $api_signkey;
        //使用MD5进行加密，再转化成大写
        return strtoupper(md5($stringToBeSigned));
    }

    function getKuaiDiStatus($kuaidi_str, $contents) {
        $kuaidi_str = strtolower($kuaidi_str);
        $status = 0;

        $map = array();

        $map['fedexus'][] = array('Delivered', 2);
        $map['emsinten'][] = array('Delivery', 2);
        $map['emsinten'][] = array('Attempted delivery', 3);
        $map['dhlen'][] = array('Signed for by', 2);
        $map['upsen'][] = array('Delivered', 2);
        $map['kcs'][] = array('[Delivery]Sign', 2);
        $map['tnten'][] = array('Delivered In Good Condition', 2);
        $map['youzhengguoji'][] = array('签收', 2);
        $map['ems'][] = array('签收', 2);
        $status = 0;
        if ($map[$kuaidi_str]) {
            $status = 1;
            foreach ($map[$kuaidi_str] as $value) {
                $tpl_contents = mb_ereg_replace($value[0], "@@@@@@", $contents);
                if (stripos($tpl_contents, "@@@@@@") !== false) {
                    $status = $value[1];
                }
            }
            return $status;
        } else
            return 0;
    }

    //TYPE==1 获取sku codeno  TYPE==2 获取商品codeno
    public function actionGetItemno() {
        $type = Common::queryInt(_p("type"), 1);
        $state = Common::queryInt(_p("state"));
        $itemnoArr = array();
        $cond = "status=" . $state;
        if ($type === 1) {
            $skuItemnoLogic = $this->load("sku");
            $itemnoArr = $skuItemnoLogic->findAll($cond, false, "", array("codeno"));
        } else {
            $goodsItemnoLogic = $this->load("goods");
            $itemnoArr = $goodsItemnoLogic->findAll($cond, false, "", array("codeno"));
        }
        if ($itemnoArr) {
            return json_encode(array("result" => true, "data" => $itemnoArr));
        } else {
            return json_encode(array("result" => false));
        }
    }

    /**
     * 获取Newsletter
     */
    public function actionGetNewsletter() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $page = Common::queryInt(_p('page_no'), 1);
        $psize = Common::queryInt(_p('page_size'), 10);
        $newsletterLogic = $this->load('newsletter');
        $cond = 'status=1 order by id desc limit ' . ($page - 1) * $psize . ',' . $psize;
        $cols = array('email', 'create_time', 'domain', 'source', 'language_id', 'source_device');
        $newsletterlist = $newsletterLogic->getCols($cond, $cols);
		$counts = $newsletterLogic->getCount($cond);
        $result['Data']['NewsletterList'] = $newsletterlist;
		$result['total_results'] = $counts ;
        $result['code'] = -1;
        $result['msg'] = 'Success';
        echo json_encode($result);
        exit;
    }

    /**
     * 获取User
     */
    public function actionGetUser() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $page = Common::queryInt(_p('page_no'), 1);
        $psize = Common::queryInt(_p('page_size'), 10);
        $userLogic = $this->load('user');
        $cond = 'status=1 order by id desc limit ' . ($page - 1) * $psize . ',' . $psize;
        $cols = array('id', 'base_name', 'language_id', 'parent_user_id', 'user_group_id', 'create_time', 'credit', 'growth');
        $userlist = $userLogic->getCols($cond, $cols);
		$counts = $userLogic->getCount($cond);
        $result['Data']['UserList'] = $userlist;
		$result['total_results'] = $counts ;
        $result['code'] = -1;
        $result['msg'] = 'Success';
        echo json_encode($result);
        exit;
    }
	
	public function actionGetPhone() {
        $result = array();
        $params = Inputer::getOrgPost();
        $result['code'] = $this->checkSign($params);
        if ($result['code'] !== 0) {
            echo json_encode($result);
            exit;
        }
        $page = Common::queryInt(_p('page_no'), 1);
        $psize = Common::queryInt(_p('page_size'), 10);
        $logic = $this->load('userAddress');
        $cond = 'status=1 order by id desc limit ' . ($page - 1) * $psize . ',' . $psize;
        $cols = array('first_name','last_name','mobilephone');
        $list = $logic->getCols($cond, $cols);
		$counts = $logic->getCount($cond);
        $result['Data']['phoneList'] = $list;
		$result['total_results'] = $counts ;
        $result['code'] = -1;
        $result['msg'] = 'Success';
        echo json_encode($result);
        exit;
    }

}

?>