<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Express
 *
 */
require_once(APP_ROOT . "conf/api.conf.php");
class ExpressController extends AppController
{
  public function __construct()
  {
    parent::__construct();
    ignore_user_abort(true);
    set_time_limit(0);
  }
  /**
   *  更新 物流回调数据 
   * 
   */
public function actionUpdateTrackingData()
  {
    $result   = array();
    $params   = _p();
  //  $result['code']  = $this->checkSign($params); 
    if($result['code'] !== 0)
    {
    //  echo json_encode($result);exit;
    }
   
    $body = _p("body");
	$data = json_decode($body,true);
	$deliveryLogic = $this->load("OrderDelivery");
	foreach($data as $item)
	{
		$cond = "delivery_no like '".$item["no"]."'";
		$map = Zhtx::createDataMap();
        $map->addEntry('delivery_data', Common::strEscape($item["content"],false), DB::VARCHAR);
        $map->addEntry('delivery_status', $item["status"], DB::INT);
		$deliveryLogic->update($map, $cond, $table = "");
	}
    $result['code'] = -1;
    echo json_encode($result);exit;
  }
/**
   *  更新 获取物流配送单号 
   * 
   */
   public function actionGetTrackingNo()
  {
    $result   = array();
    $params   = _p();
    //$result['code']  = $this->checkSign($params); 
    if($result['code'] !== 0)
    {
    //  echo json_encode($result);exit;
    }
   
    $max_id = Common::queryInt(_g("max_id"));
	$deliveryLogic = $this->load("OrderDelivery");
	$page_size = 1000;
    $curr_page = Common::queryInt(_g('page'), 1);
	$where = 'id > '.$max_id.' ORDER BY id DESC';
	//
	$shippingCorp = $this->load('shippingCorp')->findAll("1=1",true);
    //分页
    $count            = $deliveryLogic->getCount($where);
	$deliveryLogic = $this->load("OrderDelivery");
    $res  = $deliveryLogic->getCurrentDatas($where, $page_size, $curr_page);
    $data = array();
	foreach($res as $item)
	{
		$temp = array();
		$temp["no"] = $item["delivery_no"];
		$temp["com"] = $shippingCorp[$item['shipping_corp_id']]['interface_code'];
		if($temp["no"]=="" || $temp["com"]=="")
		{
			continue;	
		}
		$data[] = $temp ;
	}
	$result["data"] = $data ;
	$result['code'] = -1;
    echo json_encode($result);exit;
  }

  /**
   * 效验签名是否匹配
   * @param type $params
   * @param type $erp_sign
   * @return type 
   */
  public function checkSign($params)
  {  
    $code = 0;
    if(!isset($params['sign']))
    {
      $code = 1004;      
    }
    else if(!isset($params['timestamp']))
    {
      $code = 1008;      
    }
    else if (!preg_match("/^((?:19|20)[0-9]{2})-[0-9]{2}-[0-9]{2} [0-9]{2}(\:)[0-9]{2}(\:)[0-9]{2}$/",$params['timestamp']) || (time()-strtotime($params['timestamp'])) > 60)
    {
      $code = 1009;
    }
    else
    {
      $erp_sign = $params['sign'];
      unset($params['sign']);
      $sign = $this->generateSign($params);
      $code = $erp_sign == $sign ? 0 : 1005;
    }    
    return $code;
  }
  /**
   * 服务端签名生成
   * @param array $params ERP传输的参数数组(不包含sign)
   * @return string 
   */
  function generateSign($params)
  {
      $api_signkey = md5(md5(API_KEY.API_SECRET));      
      //所有请求参数按照字母先后顺序排序
      ksort($params);
      //定义字符串开始 结尾所包括的字符串
      $stringToBeSigned = API_KEY;
      //把所有参数名和参数值串在一起
      foreach ($params as $k => $v)
      {
          $stringToBeSigned .= "$k$v";
      }
      unset($k, $v);
      //把venderKey夹在字符串的两端
      $stringToBeSigned .= $api_signkey;
      //使用MD5进行加密，再转化成大写
      return strtoupper(md5($stringToBeSigned));
  }
 
}

?>
