<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Chart
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class ChartController extends AppController
{

  private $goodsPriceReportLogic;
  private $goodsReportLogic;
  private $goodsLanguageReportLogic;
  private $goodsLogic;
  private $languageLogic;
  private $countryLogic;
  private $salesReprotLogic;

  public function __construct()
  {
    parent::__construct();
    $this->goodsPriceReportLogic = $this->load('goodsPriceReport');
    $this->goodsReportLogic = $this->load('goodsReport');
    $this->goodsLanguageReportLogic = $this->load('goodsLanguageReport');
    $this->goodsLogic = $this->load('goods');
    $this->languageLogic = $this->load('language');
    $this->countryLogic = $this->load('country');
    $this->salesReprotLogic = $this->load('salesReport');
  }
 /**
  * 商品价格销售对比分析
  */
  public function actionGoodsPriceSalesCompare()
  { 
    return true; //report 表不用了
    $data_file = REPORT_ROOT . 'line-bug-report.txt';
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $month = date('Ym', SYS_TIME);
    $goods_id = explode(',', _g('goods_id'));//暂时取一个商品 后期要增加展示多个商品的chart
    $goods = $this->goodsLogic->getOneById($goods_id[0]);
    if ($goods)
    {
      $cond = 'goods_id =' . $goods_id;
      if (_g('history_time'))
      {
        $month = date('Ym', strtotime(_g('history_time')));
      }
      $cond .= ' and create_month =' . $month;
      $goods_prices = $this->goodsPriceReportLogic->findAll($cond);
      $flag = TRUE;
      if (_g('language_id'))
      {
        $cond .= ' and language_id=' . _g('language_id');
        $flag = FALSE;
      }
      if (_g('country_id'))
      {
        $cond .= ' and country_id=' . _g('country_id');
        $flag = FALSE;
      }
      $goods_sales = array();
      if ($flag)
      {
        $goods_sales = $this->goodsReportLogic->findAll($cond);
      }
      else
      {
        $goods_sales = $this->goodsLanguageReportLogic->findAll($cond);
      }
      $prices = array();
      $max_price = 0;
      foreach ($goods_prices as $value)
      {
        if($value['price'] > $max_price)
        {
          $max_price = $value['price'];
        }
        $prices[$value['create_day']] = ceil($value['price']);
      }
      $sales = array();
      $max_buy_counts = 0;
      foreach ($goods_sales as $val)
      {
        if($val['buy_counts'] > $max_buy_counts)
        {
           $max_buy_counts = $val['buy_counts'];
        }
        $sales[$val['create_day']] = $val['buy_counts'];
      }
      $prices_changes = array();
      $sales_changes = array();
      $labels = array();
      $days = Common::get_days($month);
      for ($i = 1; $i < $days+1; $i++)
      {
        $key = $i < 10 ? $month . '0' . $i : $month . $i;
        if (isset($prices[$key]))
        {
          $prices_changes[] = $prices[$key];
        }
        else
        {
          $prices[$key] = isset($prices[$key - 1]) ? $prices[$key - 1] : 0;
          $prices_changes[] = isset($prices[$key - 1]) ? $prices[$key - 1] : 0;
        }
        if (isset($sales[$key]))
        {
          $sales_changes[] = intval($sales[$key]);
        }
        else
        {
          $sales_changes[] = 0;
        }
        $labels[] = strval($i);
      }
      $title = $lang['goods'] . ": " . $goods['base_name'] . ' ' . $lang['sales_date'] . ': ' .  substr($month, 0, 4) . '年' . substr($month, 4, 6) . '月';
      $max   = 0;
      if($max_price < 500 && $max_buy_counts < 500)
      {
        $max = 500;
      }
      else if($max_price > $max_buy_counts)
      {
        $max = ceil($max_price);
      }
      else
      {
        $max = $max_buy_counts;
      }
      $text = array(
          'elements' => array(
              array(
                  "type" => "line",
                  "values" => $prices_changes,
                  "colour" => "#52aa4b",
                  "text" => $lang['goods_price_change'],
                  "font-size" => 12,
                  "width" => 2,
                  "tip" => "Unique: #val#"
              ),
              array(
                  "type" => "line",
                  "values" => $sales_changes,
                  "colour" => "#335ac9",
                  "text" => $lang['goods_sales_change'],
                  "font-size" => 12,
                  "width" => 2,
                  "tip" => "Unique: #val#"
              ),
          ),
          'title' => array(
              "text" => $title,
              "style" => array(
                  'font-size: 12px;',
                  'font-weight: 500;',
                  'padding-bottom: 10px;',
                  'text-align: center;',
                  'color: #000000;',
              ),
          ),
          'y_axis' => array(
              "stroke" => 1,
              "colour" => "#c6d9fd",
              "grid-colour" => "#dddddd",
              "tick-height" => 4,
              "min" => 0,
              "max" => $max,
              "steps" => ceil($max/10)
          ),
          'x_axis' => array(
              "offset" => false,
              "stroke" => 1,
              "colour" => "#c6d9fd",
              "grid-colour" => "#dddddd",
              "tick-height" => 5,
              "labels" => array(
                  'labels' => $labels,
              ),
          ),
          "bg_colour" => "#ffffff",
      );
      file_put_contents($data_file, json_encode($text));
      Core::$tpl->set('goods', $goods);
    }

    Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
    Core::$tpl->set('countrys', $this->countryLogic->findAll());
    Core::$tpl->set('selected_time', _g('history_time'));
    Core::$tpl->set('selected_site', _g('language_id'));
    Core::$tpl->set('selected_country', _g('country_id'));
    Core::$htmlFile = 'chart/pricesalescompare';
    Core::$isdisplay = 0;
    Core::$tpl->render(Core::$htmlFile . '.htm');
  }
  /**
   * 日销售趋势分析
   * 
   **/
  public function actionDaySalesAnlysis()
  {
     return true; //report 表不用了
    $data_file = REPORT_ROOT . 'area-point-day-sales.txt';
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $month = date('Ym', SYS_TIME);
    $cond = '1=1';
    if (_g('history_time'))
    {
      $month = date('Ym', strtotime(_g('history_time')));
    }
    $cond .= ' and create_month =' . $month;
    if (_g('language_id'))
    {
      $cond .= ' and language_id=' . _g('language_id');
    }
    if (_g('country_id'))
    {
      $cond .= ' and country_id=' . _g('country_id');
    }
    $salesReport = $this->salesReprotLogic->findAll($cond);
    $sales = array();
    $max   = 0;
    foreach ($salesReport as $val)
    {
      if($val['pay_amount'] > $max)
      {
        $max = $val['pay_amount'];
      }
      $sales[$val['create_day']] = $val;
    }
    $sales_changes = array();
    $labels = array();
    $days = Common::get_days($month);
    for ($i = 1; $i < $days+1; $i++)
    {
      $key = $i < 10 ? $month . '0' . $i : $month . $i;
      if (isset($sales[$key]))
      {
        $anlysis = $sales[$key];
        $sales_changes[] = array(
            "value"  => $anlysis['pay_amount'],
            "colour" => "#D02020",
            "tip" => ' Sales ' . $anlysis['pay_amount'],
        );
      }
      else
      {
        $sales_changes[] = array(
            "value" => 0,
            "colour" => "#D02020",
            "tip" => ' Sales 0',
        );
      }
      $labels[] = strval($i);
    }
    $title = $lang['sales_date'] . ': ' . substr($month, 0, 4). '年' . substr($month, 4, 6) . '月';
    $max   = $max > 500 ? $max : 500;
    $text = array(
        'elements' => array(
            array(
                "type" => "area",
                "fill-alpha" => 0.4,
                "text" =>"Sales",
                "values" => $sales_changes,
                "width"  => 2,
                "dot-size" => 4,
                "halo-size" => 2,
                "colour" => "#ff9900",
                "fill" => "#dbecf6"
            ),
        ),
        'title' => array(
            "text" => $title,
            "style" => array(
                'font-size: 12px;',
                'font-weight: 500;',
                'padding-bottom: 10px;',
                'text-align: center;',
                'color: #000000;',
            ),
        ),
    "bg_colour" => "#ffffff",
	"x_axis" => array(
		"colour" => "#aaaaaa",
		"grid-colour" =>  "#eeeeee",
		"stroke" => 1,
		"tick-height" => 4,
		"labels" => array(
            'labels' => $labels,
        ),               
	),
	"y_axis" => array(
		"colour" => "#aaaaaa",
		"grid-colour" => "#eeeeee",
		"stroke" =>  1,
		"tick-length" => 5,
		"min" => 0,
		"max" => $max,
		"steps" => ceil($max/10),
	),
	"tooltip" => array(
        "stroke" => 1,
		"colour" => "#000000",
		"background" => "#fffbca" 
    ),
    );
    file_put_contents($data_file, json_encode($text));
    Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
    Core::$tpl->set('countrys', $this->countryLogic->findAll());
    Core::$tpl->set('selected_time', _g('history_time'));
    Core::$tpl->set('selected_site', _g('language_id'));
    Core::$tpl->set('selected_country', _g('country_id'));
  }
 /**
  * 月销售趋势分析 
  */
  public function actionMonthSalesAnlysis()
  {
    $data_file = REPORT_ROOT . 'area-point-month-sales.txt';
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $year = date('Y', SYS_TIME);
    $cond = '1=1';
    if (_g('history_time'))
    {
      $year = date('Y', strtotime(_g('history_time')));
    }
    $cond .= ' and create_year =' . $year;
    if (_g('language_id'))
    {
      $cond .= ' and language_id=' . _g('language_id');
    }
//    _debug($year);
    if (_g('country_id'))
    {
      $cond .= ' and country_id=' . _g('country_id');
    }
    $cond .= ' group by create_month';
    $cols  = array(
         'create_month','sum(order_amount) as order_amount' , 'sum(order_counts) as order_counts', 'sum(order_item_counts) as order_item_counts',
         'sum(pay_counts) as pay_counts', 'sum(wishlist_counts) as wishlist_counts', 'sum(pay_item_counts) as pay_item_counts', 'sum(pay_amount) as pay_amount',
         'sum(cost_amount) as cost_amount', 'sum(payment_fee) as payment_fee',  'sum(cost_shipping) as cost_shipping', 'sum(customer_unit) as customer_unit', 
         'sum(passenger_value) as passenger_value', 'sum(visit_counts) as visit_counts', 'sum(comment_counts) as comment_counts', 'sum(comment_value) as comment_value',
         'sum(cost_offer) as cost_offer', 'sum(stock_out_counts) as stock_out_counts', 'sum(refund_amount) as refund_amount',
     );
    $count = $this->salesReprotLogic->getCount($cond);
    $salesReport = array();
    if($count < 200)
    {
       $salesReport = $this->salesReprotLogic->getCols($cond, $cols);
    }
    else if($count > 200)
    {
      $offset = 0;
      while ($offset < $count)
      {
         $w_cond = $cond . ' limit ' . $offset . ',' . 200;
         $salesReport = array_merge($salesReport, $this->salesReprotLogic->getCols($w_cond, $cols));
         $offset += 200;
      }
    }     
    $sales = array();
    $max   = 0;
    foreach ($salesReport as $val)
    {
      if($val['pay_amount'] > $max)
      {
        $max = $val['pay_amount'];
      }
      $sales[$val['create_month']] = $val;
    }
    $sales_changes = array();
    $labels = array();
    for ($i = 1; $i < 13; $i++)
    {
      $key = $i < 10 ? $year . '0' . $i : $year . $i;
      if (isset($sales[$key]))
      {
        $anlysis = $sales[$key];
        $sales_changes[] = array(
            "value" => $anlysis['pay_amount'],
            "colour" => "#D02020",
            "tip" => ' Sales ' . $anlysis['pay_amount'],
        );
      }
      else
      {
        $sales_changes[] = array(
            "value" => 0,
            "colour" => "#D02020",
            "tip" => ' Sales ' . 0,
        );
      }
      $labels[] = strval($i);
    }
    $title = $lang['sales_date'] . ': ' . $year . '年';
    $max   = $max > 500 ? $max : 500;
    $text = array(
        'elements' => array(
            array(
                "type" => "area",
                "fill-alpha" => 0.4,
                "text" =>"Sales",
                "values" => $sales_changes,
                "width"  => 2,
                "dot-size" => 4,
                "halo-size" => 2,
                "colour" => "#ff9900",
                "fill" => "#dbecf6"
            ),
        ),
        'title' => array(
            "text" => $title,
            "style" => array(
                'font-size: 12px;',
                'font-weight: 500;',
                'padding-bottom: 10px;',
                'text-align: center;',
                'color: #000000;',
            ),
        ),
     "bg_colour" => "#ffffff",
	"x_axis" => array(
		"colour" => "#aaaaaa",
		"grid-colour" =>  "#eeeeee",
		"stroke" => 1,
		"tick-height" => 4,
		"labels" => array(
            'labels' => $labels,
        ),               
	),
	"y_axis" => array(
		"colour" => "#aaaaaa",
		"grid-colour" => "#eeeeee",
		"stroke" =>  1,
		"tick-length" => 5,
		"min" => 0,
		"max" => $max,
		"steps" => ceil($max/10),
	),
	"tooltip" => array(
        "stroke" => 1,
		"colour" => "#000000",
		"background" => "#fffbca" 
    ),
    );
    file_put_contents($data_file, json_encode($text));
    Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
    Core::$tpl->set('countrys', $this->countryLogic->findAll());
    Core::$tpl->set('selected_time', _g('history_time'));
    Core::$tpl->set('selected_site', _g('language_id'));
    Core::$tpl->set('selected_country', _g('country_id'));
  }

}

?>
