<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Sales
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class SalesController extends AppController
{

    private $languageLogic;
    private $countryLogic;
    private $salesReportLogic;
    private $goodsReportJoinGoodsLogic;
    private $userSalesReportJoinUserLogic;
    private $goodsLanguageReportJoinGoodsLogic;

    public function __construct()
    {
        parent::__construct();
        $this->languageLogic = $this->load('language');
        $this->countryLogic = $this->load('country');
        $this->salesReportLogic = $this->load('salesReport');
        $this->goodsReportJoinGoodsLogic = $this->load('goodsReportJoinGoods');
        $this->userSalesReportJoinUserLogic = $this->load('userSalesReportJoinUser');
        $this->goodsLanguageReportJoinGoodsLogic = $this->load('goodsLanguageReportJoinGoods');
    }

    /**
     * 日报 
     */
    public function actionDaily()
    {
        return true; //report 表不用了
        $cond = '1=1';
        if (_g('history_time'))
        {
            $cond .= ' and create_month=' . date('Ym', strtotime(_g('history_time')));
        }
        if (_g('language_id'))
        {
            $cond .= ' and language_id=' . _g('language_id');
        }
        if (_g('country_id'))
        {
            $cond .= ' and country_id=' . _g('country_id');
        }
        $count = $this->salesReportLogic->getCount($cond);
        $cond .= ' order by create_day desc';
        $current_page = Common::queryInt(_g('page'), 1);
        $pages = Common::getPages($count, $current_page, 20);
        $list = $this->salesReportLogic->getCurrentDatas($cond);
        Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
        Core::$tpl->set('countrys', $this->countryLogic->findAll());
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_time', _g('history_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('selected_country', _g('country_id'));
    }

    /**
     * 月报 
     */
    public function actionMonthly()
    {
        return true; //report 表不用了
        $cond = '1=1';
        if (_g('history_time'))
        {
            $cond .= ' and create_year=' . date('Y', strtotime(_g('history_time')));
        }
        if (_g('language_id'))
        {
            $cond .= ' and language_id=' . _g('language_id');
        }
        if (_g('country_id'))
        {
            $cond .= ' and country_id=' . _g('country_id');
        }
        $cond .= ' group by create_month';
        $count = $this->salesReportLogic->getCount($cond);
        $current_page = Common::queryInt(_g('page'), 1);
        $pages = Common::getPages($count, $current_page, 20);
        $cols = array(
            'create_month', 'sum(order_amount) as order_amount', 'sum(order_counts) as order_counts', 'sum(order_item_counts) as order_item_counts',
            'sum(pay_counts) as pay_counts', 'sum(wishlist_counts) as wishlist_counts', 'sum(pay_item_counts) as pay_item_counts', 'sum(pay_amount) as pay_amount',
            'sum(cost_amount) as cost_amount', 'sum(payment_fee) as payment_fee', 'sum(cost_shipping) as cost_shipping', 'sum(customer_unit) as customer_unit',
            'sum(passenger_value) as passenger_value', 'sum(visit_counts) as visit_counts', 'sum(comment_counts) as comment_counts', 'sum(comment_value) as comment_value',
            'sum(cost_offer) as cost_offer', 'sum(stock_out_counts) as stock_out_counts', 'sum(refund_amount) as refund_amount',
        );
        $list = $this->salesReportLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
        Core::$tpl->set('countrys', $this->countryLogic->findAll());
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_time', _g('history_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('selected_country', _g('country_id'));
    }

    /**
     * 商品销售排行 
     */
    public function actionGoodsSalesRank()
    {
        $flag = TRUE;
        $cond = '1=1';
        $current_page = Common::queryInt(_g('page'), 1);
        if (_g('start_time'))
        {
            $cond .= ' and r.create_day >' . date('Ymd', strtotime(_g('start_time')));
        }
        if (_g('end_time'))
        {
            $cond .= ' and r.create_day <' . date('Ymd', strtotime(_g('end_time')));
        }
        if (_g('language_id'))
        {
            $cond .= ' and r.language_id=' . _g('language_id');
            $flag = FALSE;
        }
        if (_g('country_id'))
        {
            $cond .= ' and r.country_id=' . _g('country_id');
            $flag = FALSE;
        }
        $cond .= ' group by r.goods_id';
        /*
          if(_g('orderby'))
          {
          $cond .= ' order by r.' . _g('orderby') . ' desc';
          }
          else
          {
          $cond .= ' order by r.pay_amount desc';
          }
         * 
         */
        $cols = array(
            'r.goods_id as goods_id', 'r.brand_id as brand_id', 'sum(r.buy_counts) as buy_counts', 'sum(r.cart_counts) as cart_counts',
            'sum(r.pay_counts) as pay_counts', 'sum(r.wishlist_counts) as wishlist_counts', 'sum(r.pay_amount) as pay_amount',
            'sum(r.cost_amount) as cost_amount', 'sum(r.visit_counts) as visit_counts', 'sum(r.comment_counts) as comment_counts',
            'sum(r.comment_value) as comment_value', 'sum(r.cost_offer) as cost_offer', 'sum(r.stock_out_counts) as stock_out_counts',
            'sum(r.returned_counts) as returned_counts', 'g.base_name as base_name', 'g.image as image', 'g.codeno as codeno'
        );
        if ($flag)
        {
            $count = $this->goodsReportJoinGoodsLogic->getCount($cond);
            $list = $this->goodsReportJoinGoodsLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        }
        else
        {
            $count = $this->goodsLanguageReportJoinGoodsLogic->getCount($cond);
            $list = $this->goodsLanguageReportJoinGoodsLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        }
        $pages = Common::getPages($count, $current_page, 20);
        Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
        Core::$tpl->set('countrys', $this->countryLogic->findAll());
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_s_time', _g('start_time'));
        Core::$tpl->set('selected_e_time', _g('end_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('selected_country', _g('country_id'));
        Core::$tpl->set('orderby', _g('orderby'));
        Core::$tpl->set('brands', $this->load('brand')->findAll('status=1', true));
    }

    /*
     * 会员购买排行
     */

    public function actionUserBuyRank()
    {
        return true; //report 表不用了
        $current_page = Common::queryInt(_g('page'), 1);
        if (_g('start_time'))
        {
            $cond .= ' and r.create_day >' . date('Ymd', strtotime(_g('start_time')));
        }
        if (_g('end_time'))
        {
            $cond .= ' and r.create_day <' . date('Ymd', strtotime(_g('end_time')));
        }
        $cond .= ' group by r.user_id';
        /*
          if(_g('orderby'))
          {
          $cond .= ' order by r.' . _g('orderby') . ' desc';
          }
          else
          {
          $cond .= ' order by r.pay_amount desc';
          }
         * 
         */
        $cols = array(
            'r.create_day', 'r.user_id as user_id', 'sum(r.order_counts) as order_counts', 'sum(r.cart_counts) as cart_counts',
            'sum(r.pay_counts) as pay_counts', 'sum(r.wishlist_counts) as wishlist_counts', 'sum(r.pay_amount) as pay_amount',
            'sum(r.order_amount) as order_amount', 'sum(r.comment_counts) as comment_counts',
            'sum(r.order_item_counts) as order_item_counts', 'sum(r.pay_item_counts) as pay_item_counts', 'sum(r.cost_shipping) as cost_shipping',
            'sum(r.payment_fee) as payment_fee', 'sum(r.customer_unit) as customer_unit', 'sum(r.passenger_volume) as passenger_volume',
            'sum(r.returned_counts) as returned_counts', 'sum(r.refund_amount) as refund_amount', 'u.base_name as base_name'
        );
        $count = $this->userSalesReportJoinUserLogic->getCount($cond);
        $pages = Common::getPages($count, $current_page, 20);
        $list = $this->userSalesReportJoinUserLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_s_time', _g('start_time'));
        Core::$tpl->set('selected_e_time', _g('end_time'));
        Core::$tpl->set('orderby', _g('orderby'));
    }

    /**
     * 商品分析（访问购买率） 
     */
    public function actionGoodsAnalysis()
    {
        $flag = TRUE;
        $cond = '1=1';
        $current_page = Common::queryInt(_g('page'), 1);
        if (_g('start_time'))
        {
            $cond .= ' and r.create_day >' . date('Ymd', strtotime(_g('start_time')));
        }
        if (_g('end_time'))
        {
            $cond .= ' and r.create_day <' . date('Ymd', strtotime(_g('end_time')));
        }
        if (_g('language_id'))
        {
            $cond .= ' and r.language_id=' . _g('language_id');
            $flag = FALSE;
        }
        if (_g('country_id'))
        {
            $cond .= ' and r.country_id=' . _g('country_id');
            $flag = FALSE;
        }
        $cond .= ' group by r.goods_id';
        /*
          if(_g('orderby'))
          {
          $cond .= ' order by r.' . _g('orderby') . ' desc';
          }
          else
          {
          $cond .= ' order by r.pay_amount desc';
          }
         * 
         */
        $cols = array(
            'r.goods_id as goods_id', 'r.brand_id as brand_id', 'sum(r.buy_counts) as buy_counts', 'sum(r.cart_counts) as cart_counts',
            'sum(r.pay_counts) as pay_counts', 'sum(r.wishlist_counts) as wishlist_counts', 'sum(r.pay_amount) as pay_amount',
            'sum(r.cost_amount) as cost_amount', 'sum(r.visit_counts) as visit_counts', 'sum(r.comment_counts) as comment_counts',
            'sum(r.comment_value) as comment_value', 'sum(r.cost_offer) as cost_offer', 'sum(r.stock_out_counts) as stock_out_counts',
            'sum(r.returned_counts) as returned_counts', 'g.base_name as base_name', 'g.image as image', 'g.codeno as codeno'
        );
        if ($flag)
        {
            $count = $this->goodsReportJoinGoodsLogic->getCount($cond);
            $list = $this->goodsReportJoinGoodsLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        }
        else
        {
            $count = $this->goodsLanguageReportJoinGoodsLogic->getCount($cond);
            $list = $this->goodsLanguageReportJoinGoodsLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        }
        $pages = Common::getPages($count, $current_page, 20);
        Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
        Core::$tpl->set('countrys', $this->countryLogic->findAll());
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_s_time', _g('start_time'));
        Core::$tpl->set('selected_e_time', _g('end_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('selected_country', _g('country_id'));
        Core::$tpl->set('orderby', _g('orderby'));
        Core::$tpl->set('brands', $this->load('brand')->findAll('status=1', true));
    }

}

?>
