<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Account
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class AccountController extends AppController {

    private $userinfoLogic;
    private $userLogic;
    private $user_id;
    private $userAddressLogic;
    private $orderLogic;
    private $userFavoriteLogic;
    private $userGroupJoinLanguageLogic;
    private $language_id;

    public function __construct() {
        parent::__construct();
        $user_id = $this->checkLogin();
        if (!$user_id) {
            if (strtolower(_g('a')) != 'trackingorder' && strtolower(_g('a')) != 'trackingorderdetail' && strtolower(_g('a')) != 'trackno')
                return $this->_redirect(Common::frontURL('home', 'user', 'login', array('ref' => $_SERVER['REQUEST_URI'])));
        }
        else {
            $this->user_id = $user_id;
        }
        $this->userLogic = $this->load('user');
        $this->userinfoLogic = $this->load('userInfo');
        $this->userAddressLogic = $this->load('userAddress');
        $this->orderLogic = $this->load('order');
        $this->userFavoriteLogic = $this->load('userFavorite');
        $this->userGroupJoinLanguageLogic = $this->load('UserGroupJoinLanguage');
        $this->language_id = $this->load('language')->language_id;
        ;
        $this->before();
    }
	
	
	
    public function actionIndex() {
        //最近订单
        $recent_orders = $this->orderLogic->getListByUserId($this->user_id, 0, 5);
        foreach ($recent_orders as $key => $rows) {
            $order_ids[] = $rows['id'];
        }
        $order_ids = count($order_ids) ? implode(',', $order_ids) : 0;
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id in(' . $order_ids . ') and i.status=1');
        $order_image = array();
        foreach ($orderItems as $key => $value) {
            if (count($order_image[$value['order_id']]) >= 3) {
                continue;
            }
            if (!in_array($value['image'], $order_image[$value['order_id']])) {
                $order_image[$value['order_id']][] = $value['image'];
            }
        }
        Core::$tpl->set('order_image', $order_image);
        Core::$tpl->set('recent_orders', $recent_orders);
        Core::$tpl->set('recent_msg', $this->load('message')->getMsgByUserId($this->user_id, 0, 10));

        //会员信息
        $user = $this->userLogic->getOne('id=' . $this->user_id);
        Core::$tpl->set('user', $user);
        $userinfo = $this->userinfoLogic->getOne('user_id=' . $this->user_id);
        Core::$tpl->set('userinfo', $userinfo);
        //会员消息计数
//    $message_count=$this->load('message')->getCount('type=0 or (user_id =' . $this->user_id . ' and type=1 ) and parent_id=0 and status=1');
//    Core::$tpl->set('message_count', $message_count);
        //会员等级
        $language_id = $this->language_id;
        $user_current_level = $this->userGroupJoinLanguageLogic->getUserGroupById($user['user_group_id'], $language_id);
        if ($user_current_level) {
            $user_next_level = $this->userGroupJoinLanguageLogic->getOne('ug.min_growth>' . $user['growth'] . ' and language_id=' . $language_id . ' order by ug.min_growth asc limit 1');
            Core::$tpl->set('user_current_level', $user_current_level);
            Core::$tpl->set('user_next_level', $user_next_level);
        }
        //会员信息完成百分比
        $arrcomplete = array("first_name", "last_name", "country_id", "street", "postcode", "city", "state", "email", "mobilephone", "telephone");
        $tempuncomplete = count($arrcomplete);
        if (!$userinfo) {
            $tempuncomplete = 0;
        } else {
            for ($index = 0; $index < count($arrcomplete); $index++) {
                if ($userinfo[$arrcomplete[$index]] == "") {
                    $tempuncomplete--;
                }
            }
        }
        $userinfo_percent = (int) ($tempuncomplete * 10 / count($arrcomplete)) * 10;
        Core::$tpl->set('userinfo_percent', $userinfo_percent);
    }

    public function actionEditAddress() {
        if (_p()) {
            $address_id = Common::queryInt(_p('address_id'));
            $addr_detail = $this->userAddressLogic->getOneById($address_id);
            if (!$addr_detail || $addr_detail['user_id'] != $this->user_id) {
                return $this->showMessage('illegal_parameters');
            }
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $mobilephone = Common::strEscape(strip_tags(_p('mobilephone')));
            $telephone = Common::strEscape(strip_tags(_p('telephone')));
            $email = _p('email');
            $do = _p('do');
            $pref = _p('ref');
            $is_master = Common::queryInt(_p('is_master'));
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id || !$mobilephone || !$email) {
                return $this->showMessage('required_tip');
            }
            if (!Common::isEmail($email)) {
                return $this->showMessage('enter_email_error');
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $mobilephone,
                'telephone' => $telephone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
            );
            $res = $this->userAddressLogic->save($data, $address_id);
            if ($res && $is_master) {
                $cond = 'id !=' . $address_id . ' and user_id=' . $this->user_id . ' and is_master=1';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            if ($do == "ecstep2") {
                $ref = urldecode($pref);
                Common::redirect("./h-order-eCStep2.html?{$ref}&address_id={$address_id}");
            }
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        } else {
            $address_id = Common::queryInt(_g('id'));
            $address = $this->userAddressLogic->getOneById($address_id);
            if (!$address || $address['user_id'] != $this->user_id) {
                return $this->showMessage('illegal_parameters');
            }
            $countryLogic = $this->load('country');
            Core::$tpl->set('countries', $countryLogic->getCountries());
            Core::$tpl->set('address', $address);
        }
    }

    public function actionDelAddress() {
        $address_id = Common::queryInt(_g('id'));
        $address = $this->userAddressLogic->getOneById($address_id);
        if (!$address || $address['user_id'] != $this->user_id) {
            return $this->showMessage('illegal_parameters');
        }
        $res = $this->userAddressLogic->delete('id=' . $address_id);
        return $res ? $this->success('operation_success') : $this->showMessage('operation_failure');
    }

    public function actionMyAddress() {
        if (_p()) {
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $phone = Common::strEscape(strip_tags(_p('mobilephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'));
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id || !$email || !$phone) {
                return $this->showMessage('required_tip');
            }
            if (!Common::isEmail($email)) {
                return $this->showMessage('enter_email_error');
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $phone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
                'create_time' => SYS_TIME,
                'address_type' => 0,
            );
            $res = $this->userAddressLogic->save($data);
            if ($res && $is_master) {
                $cond = 'id !=' . $res . ' and user_id=' . $this->user_id . ' and is_master=1';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        } else {
            $addresses = $this->userAddressLogic->getListByUserId($this->user_id);
            $countryLogic = $this->load('country');
            $countries = $countryLogic->getCountries();
            $countryAsID = array();
            foreach ($countries as $value) {
                $countryAsID[$value['id']] = $value;
            }
            Core::$tpl->set('addresses', $addresses);
            Core::$tpl->set('countries', $countries);
            Core::$tpl->set('countryAsId', $countryAsID);
        }
    }

    public function actionMyBillingAddress() {
        if (_p()) {
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $phone = Common::strEscape(strip_tags(_p('mobilephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'));
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id || !$email || !$phone) {
                return $this->showMessage('required_tip');
            }
            if (!Common::isEmail($email)) {
                return $this->showMessage('enter_email_error');
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $phone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
                'create_time' => SYS_TIME,
                'address_type' => 1,
            );
            $res = $this->userAddressLogic->save($data);
            if ($res && $is_master) {
                $cond = 'id !=' . $res . ' and user_id=' . $this->user_id . ' and is_master=1 and address_type=1';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        } else {
            $addresses = $this->userAddressLogic->getListByUserId($this->user_id, 1);
            $countryLogic = $this->load('country');
            $countries = $countryLogic->getCountries();
            $countryAsID = array();
            foreach ($countries as $value) {
                $countryAsID[$value['id']] = $value;
            }
            Core::$tpl->set('addresses', $addresses);
            Core::$tpl->set('countries', $countries);
            Core::$tpl->set('countryAsId', $countryAsID);
        }
    }

    public function actionEditBillingAddress() {
        if (_p()) {
            $address_id = Common::queryInt(_p('address_id'));
            $addr_detail = $this->userAddressLogic->getOneById($address_id);
            if (!$addr_detail || $addr_detail['user_id'] != $this->user_id) {
                return $this->showMessage('illegal_parameters');
            }
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $mobilephone = Common::strEscape(strip_tags(_p('mobilephone')));
            $telephone = Common::strEscape(strip_tags(_p('telephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'));
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id || !$mobilephone || !$email) {
                return $this->showMessage('required_tip');
            }
            if (!Common::isEmail($email)) {
                return $this->showMessage('enter_email_error');
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $mobilephone,
                'telephone' => $telephone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
            );
            $res = $this->userAddressLogic->save($data, $address_id);
            if ($res && $is_master) {
                $cond = 'id !=' . $address_id . ' and user_id=' . $this->user_id . ' and is_master=1 and address_type=1';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        } else {
            $address_id = Common::queryInt(_g('id'));
            $address = $this->userAddressLogic->getOneById($address_id);
            if (!$address || $address['user_id'] != $this->user_id) {
                return $this->showMessage('illegal_parameters');
            }
            $countryLogic = $this->load('country');
            Core::$tpl->set('countries', $countryLogic->getCountries());
            Core::$tpl->set('address', $address);
        }
    }

    /**
     * 修改密码
     * @return type
     */
    public function actionEditPassword() {
        $user = $this->userLogic->getOneById($this->user_id);
        if (!$user) {
            return $this->showMessage('illegal_parameters');
        }
        if (_p()) {
            $password = _p('password');
            $confirm_password = _p('confirm_password');
            $user_data = array();
            if ($password || $confirm_password) {
                if ($confirm_password != $password) {
                    return $this->showMessage('two_password_not_match');
                }
                $user_data['password'] = md5(md5($password));
            }
            if (_p('question')) {
                $user_data['question'] = _p('question');
            }
            if (_p('answer')) {
                $user_data['answer'] = _p('answer');
            }
            if (!count($user_data)) {
                return $this->showMessage('not_enter_anything');
            }
            $res = $this->userLogic->save($user_data, $this->user_id);
            if ($res && $password) {
                _setSession('user_id', '');
                setcookie('user_id', '', 0, '/');
                $post_data = array(
                    'codeno' => 'edit_password_tip',
                    'user_id' => $user['id']
                );
            }

            return $res ? $this->success('save_success', Common::frontURL('home', 'user', 'login')) : $this->showMessage('save_failure');
        } else {
            Core::$tpl->set('user', $this->userLogic->getOneById($this->user_id));
            Core::$htmlFile = 'account/editpassword';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 修改个人信息
     * @return type
     */
    public function actionMyProfile() {
        if (_p()) {
            $user_id = $this->checkLogin();
            /*
              if (!_p('first_name')) {
              return $this->showMessage('required_item');
              }
              if (!_p('last_name')) {
              return $this->showMessage('required_item');
              }
              if (!_p('email')) {
              return $this->showMessage('required_item');
              }
              if (!_p('state')) {
              return $this->showMessage('required_item');
              }
              if (!_p('country_id')) {
              return $this->showMessage('required_item');
              }
             * */
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $user_id);
            $info_id = $userinfo ? $userinfo['id'] : 0;
            $info_data = array(
                'user_id' => $user_id,
                'email' => Common::strEscape(strip_tags(_p('email'))),
                'postcode' => Common::strEscape(strip_tags(_p('postcode'))),
                'first_name' => Common::strEscape(strip_tags(_p('first_name'))),
                'last_name' => Common::strEscape(strip_tags(_p('last_name'))),
                'sex' => _p('sex'),
                'mobilephone' => Common::strEscape(strip_tags(_p('mobilephone'))),
                'telephone' => Common::strEscape(strip_tags(_p('telephone'))),
                'street' => Common::strEscape(strip_tags(_p('street'))),
                'city' => Common::strEscape(strip_tags(_p('city'))),
                'state' => Common::strEscape(strip_tags(_p('state'))),
                'country_id' => Common::queryInt(_p('country_id')),
            );
            $res = $this->userinfoLogic->save($info_data, $info_id);
            /*
              //作为配送地址
              if ($res && _p('asShippingAdderss')) {
              unset($info_data['sex']);
              unset($info_data['street']);
              $info_data['address'] = Common::strEscape(strip_tags(_p('street')));
              $info_data['is_master'] = 1;
              $cond = 'user_id=' . $this->user_id . ' and is_master=1';
              $map = Zhtx::createDataMap();
              $map->createEntry($info_data);
              $this->userAddressLogic->replaceByCond($map, $cond);
              }
             *
             */
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        } else {
            $user_id = $this->checkLogin();
            if (!$user_id) {
                $current_url = urlencode(Common::frontURL('home', 'account', 'myProfile'));
                return $this->showMessage('please_login_after', Common::frontURL('home', 'user', 'login', array('ref' => $current_url)));
            }
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $user_id);
            $countryLogic = $this->load('country');
            Core::$tpl->set('userinfo', $userinfo);
            Core::$tpl->set('countrys', $countryLogic->findALL('status=1', TRUE));
        }
    }
	
	public function actionPurchaseList()
	{
		$language_id = $this->language_id;
        $page_size = 8;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'o.user_id =' . $this->user_id . ' and o.create_time>='.strtotime("-6 month") . ' and g.id is not null group by oi.goods_id';
		$logic = $this->load('orderJoinOrderItemJoinGoods') ;
		$count = $logic->getCount($where,true);
        $page_data = Common::getPages($count, $curr_page, $page_size);
//        Core::$tpl->set('orders', $this->orderLogic->getListByUserId($this->user_id, ($curr_page-1) * $page_size, $page_size));
        $goods_list = $logic->getCurrentDatas($where.' order by nid desc', $page_size, $curr_page);
      	$ids=array(0);
		foreach($goods_list as $value)
		{
			$ids[]=$value['goods_id'] ;	
		}
		$res = $this->load('GoodsJoinLanguage')->findALL('l.goods_id in ('.join(',',$ids).') and l.language_id='.$this->language_id,true);
		foreach($goods_list as $key => $value)
		{
			$goods_list[$key]['good'] = $res[$value['goods_id']];
		}
		 Core::$tpl->set('goods_list', $goods_list);
		 Core::$tpl->set('pages', $page_data);
		Core::$tpl->set('seo_title', 'Purchase List');
		
	}
	
    public function actionOrders() {
        global $cfg;
        /*
          $order_cancel_time = $cfg['sites'][0]['order_cancel_time'] * 86400;
          $update_cond = 'user_id =' . $this->user_id . ' and payment_status = 101 and (create_time +' . $order_cancel_time . ') < ' . time();
          $map = Zhtx::createDataMap();
          $map->addEntry('order_status', 600, DB::INT);
          $this->orderLogic->update($map, $update_cond);
         */
        //分页用的参数
        $language_id = $this->language_id;
        $page_size = $cfg['sites'][$language_id]['order_list_number'] ? $cfg['sites'][$language_id]['order_list_number'] : 20;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'user_id =' . $this->user_id;
        if (_g('type')) {
            $type = _g('type');
            switch ($type) {
                //Unpaid
                case 'Unpaid':
                    $where .= ' and order_status >= 100 and order_status <= 103';
                    break;
                //Shiped
                case 'Shiped':
                    $where .= ' and (order_status=200 or order_status=204)';
                    break;
                //Paid
                case 'Paid':
                    $where .= ' and order_status = 201';
                    break;
                //Complete
                case 'Complete':
                    $where .= ' and order_status=700';
                    break;
                //Cancel
                case 'Cancel':
                    $where .= ' and order_status >= 600 and order_status <= 603';
                    break;
                default :break;
            }
        }
        $count = $this->orderLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
//        Core::$tpl->set('orders', $this->orderLogic->getListByUserId($this->user_id, ($curr_page-1) * $page_size, $page_size));
        $where .= ' order by create_time desc limit ' . ($curr_page - 1) * $page_size . ',' . $page_size;

        $orders = $this->orderLogic->findAll($where);

        $currencyLogic = $this->load('currency');
        $currencys = $currencyLogic->findAll('status=1');
        foreach ($currencys as $ckey => $curitem) {
            $currencys[$currencys[$ckey]['standard_code']] = $curitem;
        }
        foreach ($orders as $key => $rows) {
            $orders[$key]['currency'] = $currencys[$rows['currency_code']];
            $orders[$key]['lcoin'] = $currencys[$rows['currency_code']]['symbol_left'];
            $orders[$key]['rcoin'] = $currencys[$rows['currency_code']]['symbol_right'];
            $order_ids[] = $rows['id'];
        }
        $order_ids = count($order_ids) ? implode(',', $order_ids) : 0;
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id in(' . $order_ids . ') and i.status=1');
        $order_image = array();
        foreach ($orderItems as $key => $value) {
            if (count($order_image[$value['order_id']]) >= 3) {
                continue;
            }
            if (!in_array($value['image'], $order_image[$value['order_id']])) {
                $order_image[$value['order_id']][] = $value['image'];
            }
        }
        Core::$tpl->set('order_image', $order_image);
        Core::$tpl->set('orders', $orders);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 订单详情
     * 可以考虑把订单的信息展示的更全面些
     */
    public function actionOrderDetail() {
        $order_id = Common::queryInt(_g('order_id'));
        $order = $this->orderLogic->getOneById($order_id);
        if (!$order) {
            $this->exception();
        }
        if ($order['user_id'] != $this->user_id) {
            return $this->showMessage('not_found_record');
        }
        $deliveryLogic = $this->load('orderDelivery');
        $orderAddressLogic = $this->load('orderAddress');
        $orderPaymentLogic = $this->load('orderPayment');
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $pay_cond = 'order_id=' . $order_id . ' and payment_type=1 and user_id=' . $this->user_id . ' and status=1'; //支付成功单据
        $orderPayment = $orderPaymentLogic->getOne($pay_cond);
        $orderAddress = $orderAddressLogic->getOne('order_id=' . $order_id);
        $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $order_id . ' and i.status=1');
        $item_result = array();
        $language_id = $this->language_id;
        $order['totalnum'] = 0;
        foreach ($orderItems as $item) {
            $property_ids = explode('_', $item['sku_code']);
            $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
            $item['subtotal'] = $item['price'] * $item['buy_num'];
            $item['attr'] = $attr;
            if ($item['sku_value']) {
                $sku_value = explode('_', $item['sku_value']);
                foreach ($sku_value as $key => $value) {
                    if ($value) {
                        $item['sku_value_items'][] = $value;
                    }
                }
            }
            $item_result[$item['id']] = $item;
            $order['totalnum'] += $item['buy_num'];
        }

        //物流信息
        $ship_record = array(); //发货记录
        $return_record = array();
//        $corp_ids      = array();//物流公司IDS
        $trackObj = array();
        $tracking_no = array(); //物流单号
        foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val) {
            if ($val['delivery_type'] == 1) {
                $ship_record[] = $val;
            } else {
                $return_record[] = $val;
            }
            if ($val['delivery_no'] != '')
                $tracking_no[] = $val['delivery_no'];
            if ($val['status'] == 1) {
                //$corp_ids[]      = $val['shipping_corp_id'];
                $val['delivery_data'] = json_decode($val['delivery_data'], true);
                $trackObj[] = $val;
            }
        }
        $order['tracking_no'] = join(' , ', $tracking_no);
        $payment = array();
        if ($orderPayment['payment_id']) {
            $payment = $this->load('payment')->getOne('id=' . $orderPayment['payment_id']);
        }
        $currencyLogic = $this->load('currency');
        $currency_code = $order['currency_code']; //货币三位符
        $currency_conde = 'standard_code="' . $currency_code . '"';
        $currency = $currencyLogic->getOne($currency_conde);
        $order['currency'] = $currency;
        $userAddressCountryLogic = $this->load('userAddressCountry');
        $cond = 'a.id= ' . $order['billing_address_id'] . ' and a.user_id=' . $this->user_id . ' and a.address_type=1 order by a.is_master desc';
        $userBillingAddress = $userAddressCountryLogic->getOne($cond);
        $ShippingCorp = $this->load('shippingCorp')->findAll('', true);
        Core::$tpl->set('shippingCorp', $ShippingCorp);
        Core::$tpl->set('trackObj', $trackObj);
        Core::$tpl->set('order', $order);
        Core::$tpl->set('orderPayment', $orderPayment);
        Core::$tpl->set('orderAddress', $orderAddress);
        Core::$tpl->set('orderItems', $item_result);
        Core::$tpl->set('country', $this->load('country')->getOne('id=' . $orderAddress['country_id']));
        Core::$tpl->set('payment', $payment);
        Core::$tpl->set('userBillingAddress', $userBillingAddress);
    }

    /**
     * 非会员可追踪显示订单基本信息
     */
    public function actionTrackingOrder() {
        if (_p() || _g('itemno')) {
            $order_number = Common::queryStr(_p('itemno')) ? Common::queryStr(_p('itemno')) : Common::queryStr(_g('itemno'));
            $order = $this->orderLogic->getOne("itemno='" . mysql_escape_string($order_number) . "'");
            if (!$order) {
                $this->exception();
            }
            $order_id = $order['id'];
            $deliveryLogic = $this->load('orderDelivery');
            $orderAddressLogic = $this->load('orderAddress');
            $orderPaymentLogic = $this->load('orderPayment');
            $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
            $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
            $pay_cond = 'order_id=' . $order_id . ' and payment_type=1 order by status desc'; //支付成功单据
            $orderPayment = $orderPaymentLogic->getOne($pay_cond);
            $orderAddress = $orderAddressLogic->getOne('order_id=' . $order_id);
            $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $order_id);
            $item_result = array();
            $language_id = $this->language_id;
            $order['totalnum'] = 0;
            foreach ($orderItems as $item) {
                $property_ids = explode('_', $item['sku_code']);
                $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
                $item['subtotal'] = $item['price'] * $item['buy_num'];
                $item['attr'] = $attr;
                if ($item['sku_value']) {
                    $sku_value = explode('_', $item['sku_value']);
                    foreach ($sku_value as $key => $value) {
                        if ($value) {
                            $item['sku_value_items'][] = $value;
                        }
                    }
                }
                $item_result[$item['id']] = $item;
                $order['totalnum'] += $item['buy_num'];
            }
            //物流信息
            $ship_record = array(); //发货记录
            $return_record = array();
//               $corp_ids      = array();//物流公司IDS
            $trackObj = array();
            $tracking_no = array(); //物流单号
            foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val) {
                if ($val['delivery_type'] == 1) {
                    $ship_record[] = $val;
                } else {
                    $return_record[] = $val;
                }
                if ($val['delivery_no'] != '')
                    $tracking_no[] = $val['delivery_no'];
                if ($val['status'] == 1) {
                    //$corp_ids[]      = $val['shipping_corp_id'];
                    $val['delivery_data'] = json_decode($val['delivery_data'], true);
                    $trackObj[] = $val;
                }
            }
            $order['tracking_no'] = join(' , ', $tracking_no);
            $userAddressCountryLogic = $this->load('userAddressCountry');

            $ShippingCorp = $this->load('shippingCorp')->findAll('', true);
            Core::$tpl->set('shippingCorp', $ShippingCorp);

            // $cond   = 'a.id= ' . $order['billing_address_id'] . ' and a.user_id=' . $this->user_id . ' and a.address_type=1 order by a.is_master desc';
            //$userBillingAddress = $userAddressCountryLogic->getOne($cond);
            Core::$tpl->set('order', $order);
            Core::$tpl->set('orderPayment', $orderPayment);
            Core::$tpl->set('trackObj', $trackObj);
            Core::$tpl->set('orderAddress', $orderAddress);
            Core::$tpl->set('orderItems', $item_result);
            Core::$tpl->set('country', $this->load('country')->getOne('id=' . (int) $orderAddress['country_id']));
            Core::$tpl->set('payment', $this->load('payment')->getOne('id=' . (int) $orderPayment['payment_id']));
            // Core::$tpl->set('userBillingAddress', $userBillingAddress);
            Core::$htmlFile = 'account/trackingorderdetail';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 客户订单作废
     */
    public function actionOrderCancel() {
        $order_id = Common::queryInt(_g('order_id'));
        $order = $this->orderLogic->getOne('id=' . $order_id . ' and user_id=' . ($this->user_id));
        if (!$order) {
            return $this->exception();
        }
        if ($order['order_status'] < 201 && $order['payment_status'] != 105 && $order['payment_status'] != 103) {
            $map = Zhtx::createDataMap();
            $map->addEntry('order_status', 600, DB::INT);
            $res = $this->orderLogic->update($map, 'id=' . $order['id']);
            if ($res) {
                return $this->success('delete_success');
            }
        }
        return $this->showMessage('delete_failure');
    }

    public function actionFavorites() {
        $favoriteLogic = $this->load('userFavoriteJoinGoods');
        global $cfg;
        $language_id = $this->load('language')->language_id;
        $page_size = $cfg['sites'][$language_id]['user_favorite_list_number'] ? $cfg['sites'][$language_id]['user_favorite_list_number'] : 20;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'user_id =' . $this->user_id;
        $count = $favoriteLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('favorites', $favoriteLogic->getListByUserId($this->user_id, ($curr_page - 1) * $page_size, $page_size));
        Core::$tpl->set('pages', $page_data);
    }

    public function actionDelFavorites() {
        $favoriteLogic = $this->load('userFavorite');
        $favorites_id = Common::queryInt(_g('id'));
        $cond = 'user_id =' . $this->user_id . ' and id=' . $favorites_id;
        $userfavorite = $favoriteLogic->getOne('id=' . $favorites_id);
        if (!$userfavorite) {
            return $this->exception();
        }
        $res = $favoriteLogic->delete($cond);
        $this->load('goods')->updateWishlistCount($userfavorite['goods_id'], true);
        return $res ? $this->success('delete_success') : $this->showMessage('delete_failure');
    }

    /**
     * 订单留言
     * @return type
     */
    public function actionMessage() {
        if (_p()) {
            $order_id = Common::queryInt(_p('order_id'));
            $order = $this->orderLogic->getOneById($order_id);
            if (!_p('content')) {
                return $this->showMessage('required_item');
            }
            if (!$order || $order['user_id'] != $this->user_id) {
                return $this->showMessage('illegal_parameters');
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code'))) {
                return $this->showMessage('code_error_tips');
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_URL;
            $data = array(
                'user_id' => $this->user_id,
                'order_id' => $order_id,
                'order_no' => $order['itemno'],
                'base_name' => $order['itemno'] . ' Message',
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => 1,
                'status' => 1,
                'user_name' => _s('user_base_name'),
                'language_id' => $this->language_id,
                'is_user_readed' => 1,
                'create_time' => SYS_TIME,
            );
            $res = $this->load('message')->save($data);
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        }
    }

    /**
     * 留言详情
     */
    public function actionMessageDetail() {
        $messageLogic = $this->load('message');
        if (_p()) {
            $message_id = Common::queryInt(_p('message_id'));
            $message = $this->load('message')->getOneById($message_id);
            if (!$message || $message['type'] == 0) {
                return $this->showMessage('illegal_operation');
            }
            if (!_p('content')) {
                return $this->showMessage('required_item');
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code'))) {
                return $this->showMessage('code_error_tips');
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_URL;
            ;
            $data = array(
                'user_id' => $this->user_id,
                'parent_id' => $message['id'],
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => 1,
                'status' => 1,
                'user_name' => _s('user_base_name'),
                'language_id' => $this->language_id,
                'is_user_readed' => 1,
                'create_time' => SYS_TIME,
            );
            $res = $messageLogic->save($data);
            if ($res) {
                $messageLogic->save(array('is_admin_readed' => 0), $message['id']);
            }
            return $res ? $this->_redirect(Common::frontURL('home', 'account', 'messageDetail', array('message_id' => $message_id))) : $this->showMessage('save_failure');
        } else {
            $message_id = Common::queryInt(_g('message_id'));
            $messages = $messageLogic->getMsgDetail($message_id, $this->user_id);
            if (empty($messages)) {
                return $this->showMessage('illegal_operation');
            }
            $message = array();
            $replay = array();
            foreach ($messages as $value) {
                if ($value['parent_id']) {
                    $replay[] = $value;
                } else {
                    $message = $value;
                }
            }
            $data = array(
                'is_user_readed' => 1,
            );
            $res = $messageLogic->save($data, $message_id);
            Core::$tpl->set('message', $message);
            Core::$tpl->set('replay', $replay);
        }
    }

    /**
     * 用户中心留言
     * @return type
     */
    public function actionLeaveMessage() {
        if (_p()) {
            if (!_p('content')) {
                return $this->showMessage('required_item');
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code'))) {
                return $this->showMessage('code_error_tips');
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_URL;
            //自定义变量
            $keys = _p('exp_key');
            $values = _p('exp_value');
            $contact = array();
            foreach ($keys as $k => $v) {
                if ($values[$k]) {
                    $contact[] = array($v, $values[$k]);
                }
            }
            $data = array(
                'user_id' => $this->user_id,
                'base_name' => Common::strEscape(strip_tags(_p('title'))),
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => 1,
                'status' => 1,
                'user_name' => Common::strEscape(_p('username')) == '' ? _s('user_base_name') : Common::strEscape(strip_tags(_p('username'))),
                'contact' => json_encode($contact),
                'language_id' => $this->language_id,
                'is_user_readed' => 1,
                'create_time' => SYS_TIME,
            );
            $res = $this->load('message')->save($data);
            $email = _p('exp_key');
            if ($res) {
                EventFactory::userLeaveMessageAfter($email[1], $res, $data['language_id']);                
            }
            return $res ? $this->success('save_success', Common::frontURL('home', 'account', 'messageDetail', array('message_id' => $res))) : $this->showMessage('save_failure');
        } else {
            $userInfoLogic = $this->load('UserJoinInfo');
            $user = $userInfoLogic->getOne('u.id=' . $this->user_id);
            Core::$tpl->set('user', $user);
        }
    }

    /**
     * 我的留言
     */
    public function actionMyMessage() {
        global $cfg;
        $language_id = $this->language_id;
        $page_size = $cfg['sites'][$language_id]['message_list_number'] ? $cfg['sites'][$language_id]['message_list_number'] : 15;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $messageLogic = $this->load('message');

        $where = '(type=0 or (user_id =' . $this->user_id . ' and type=1 )) and parent_id=0 and status=1 order by is_user_readed asc,id desc';
        $count = $messageLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $messages = $messageLogic->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set('messages', $messages);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 用户中心邮箱订阅
     */
    public function actionNewsletter() {
        $newsletterLogic = $this->load('newsletter');
        if (_p()) {
            $subscription = Common::queryInt(_p('subscription'));
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_PROTOCOL . SITE_URL;
            $email = _c('user_base_name') ? _c('user_base_name') : _s('user_base_name');
            $data = array(
                'email' => $email,
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'status' => $subscription,
                'language_id' => $this->language_id,
                'create_time' => SYS_TIME,
                'source' => $this->getSource(),
            );
            $cond = 'email = "' . $email . '"';
            if ($subscription) {
                $res = $newsletterLogic->saveByCond($data, $cond);
            } else {
                $res = $newsletterLogic->delete($cond);
            }
            return $res ? $this->success('operation_success', Common::frontURL('home', 'account', 'newsletter')) : $this->showMessage('operation_failure');
        } else {
            $email = _s('user_base_name');
            $cond = 'email = "' . $email . '"';
            Core::$tpl->set('newsletter', $newsletterLogic->getOne($cond));
        }
    }

    public function before() {
        if (!$this->user_id) {
            return;
        }
        $cond = 'user_id=' . $this->user_id . ' group by order_status';
        $cols = array('order_status', 'count(order_status) as num');
        $order_counts = $this->orderLogic->getCols($cond, $cols);
        $pending_count = 0;
        $unpaid_count = 0;
        $paid_count = 0;
        $shiped_count = 0;
        $completed_count = 0;
        $canceled_count = 0;
        $processing_count = 0;
        $total_count = 0;
        foreach ($order_counts as $list) {
            $total_count += $list['num'];
            if ($list['order_status'] == 100 || $list['order_status'] == 101 || $list['order_status'] == 102 || $list['order_status'] == 103) {
                $unpaid_count += $list['num'];
            } else if ($list['order_status'] == 201) {
                $paid_count += $list['num'];
            } else if (in_array($list['order_status'], array(202, 203))) {
                $processing_count += $list['num'];
            } else if (in_array($list['order_status'], array(200, 204))) {
                $shiped_count += $list['num'];
            } else if (in_array($list['order_status'], array(700))) {
                $completed_count += $list['num'];
            } else if (in_array($list['order_status'], array(501, 502, 600, 601, 602, 603))) {
                $canceled_count += $list['num'];
            }
        }

        $myorder_count = $this->orderLogic->getCount('user_id=' . $this->user_id);
        Core::$tpl->set('address_count', $this->userAddressLogic->getCount('user_id=' . $this->user_id . ' and address_type=0'));
        Core::$tpl->set('billing_address_count', $this->userAddressLogic->getCount('user_id=' . $this->user_id . ' and address_type=1'));
        Core::$tpl->set('myorder_count', $myorder_count);


        Core::$tpl->set('order_count', $total_count);
        Core::$tpl->set('pending_count', $pending_count);
        Core::$tpl->set('unpaid_count', $unpaid_count);
        Core::$tpl->set('paid_count', $paid_count);
        Core::$tpl->set('processing_count', $processing_count);
        Core::$tpl->set('shiped_count', $shiped_count);
        Core::$tpl->set('completed_count', $completed_count);
        Core::$tpl->set('canceled_count', $canceled_count);


        $favoriteLogic = $this->load('userFavoriteJoinGoods');
        Core::$tpl->set('favorite_count', $favoriteLogic->getCountByUserId($this->user_id));
        //会员未读信息
        $language_id = $this->language_id;
        $where = '(type=0 or (user_id =' . $this->user_id . ' and type=1 )) and (language_id=0 or language_id=' . $language_id . ') and parent_id=0 and status=1 and is_user_readed=0';
        $m_unread_count = $this->load('message')->getCount($where);
        Core::$tpl->set('m_unread_count', $m_unread_count);
        //优惠券
        $couponLogic = $this->load('Coupon');
        $where = 'using_time=0 and user_id =' . $this->user_id;
        $coupon_count = $couponLogic->getCount($where);
        Core::$tpl->set('coupon_count', $coupon_count['total']);
        //成长值
        $growthLogic = $this->load('GrowthDetail');
        $where = 'user_id =' . $this->user_id;
        $growth_total = $growthLogic->query('select sum(growth) as total from z_growth_detail where ' . $where);
        if (!$growth_total[0]['total']) {
            $growth_total[0]['total'] = 0;
        }
        Core::$tpl->set('growth_total', $growth_total[0]['total']);
        //积分
        $creditLogic = $this->load('CreditDetail');
        $where = 'user_id =' . $this->user_id;
        $credit_total = $creditLogic->query('select sum(useful_credit) as total from z_credit_detail where ' . $where);
        $creditsettingLogic = $this->load('CreditSetting');
        $credit_setting = $creditsettingLogic->getOne();
        $credit_total = $credit_total[0]['total'] ? $credit_total[0]['total'] : 0;
        Core::$tpl->set('credit_total', $credit_total);
        Core::$tpl->set('credit_pref_total', $credit_total / $credit_setting['exchange_credit_scale']);
    }

    /**
     * 我的积分
     */
    public function actionCreditList() {
        global $cfg;
        $language_id = $this->language_id;
        $page_size = $cfg['sites'][$language_id]['credit_list_number'] ? $cfg['sites'][$language_id]['credit_list_number'] : 15;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $creditLogic = $this->load('CreditDetail');
        $where = 'user_id =' . $this->user_id;
        $count = $creditLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $where .= ' order by create_time desc';
        $credit = $creditLogic->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set('credit', $credit);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 我的成长值
     */
    public function actionGrowthList() {
        global $cfg;
        $language_id = $this->language_id;
        $page_size = $cfg['sites'][$language_id]['growth_list_number'] ? $cfg['sites'][$language_id]['growth_list_number'] : 15;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $growthLogic = $this->load('GrowthDetail');
        $where = 'user_id =' . $this->user_id;
        $count = $growthLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $where .= ' order by create_time desc';
        $growth = $growthLogic->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set('growth', $growth);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 我的优惠券
     */
    public function actionCouponList() {
        global $cfg;
        $language_id = $this->language_id;
        $page_size = $cfg['sites'][$language_id]['coupon_list_number'] ? $cfg['sites'][$language_id]['coupon_list_number'] : 15;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $couponLogic = $this->load('Coupon');
        $where = 'user_id =' . $this->user_id . ' ORDER BY id DESC';
        $count = $couponLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $coupon = $couponLogic->getCurrentDatas($where, $page_size, $curr_page);

        if ($coupon) {
            $offer_ids = array(0);
            foreach ($coupon as $item) {
                $offer_ids[] = $item['offer_id'];
            }
            $offerList = $this->load('offer')->findAll('id in(' . implode(',', $offer_ids) . ',0)', TRUE);
            $cols = array('base_name', 'offer_id','end_time');
            $offerlanLogic = $this->load('offerLanguage');
            $offer = $offerlanLogic->findAll("offer_id in(" . implode(',', $offer_ids) . ",0) and language_id=" . $language_id);
            $coupon_offer = array();
            foreach ($offer as $value) {
                $coupon_offer[$value['offer_id']] = $value['base_name'];
            }
            foreach ($coupon as $key => $_val) {
                $cur_offer = $offerList[$_val['offer_id']];
                if ($cur_offer) 
				{
                    if ( time()>=$cur_offer['end_time']) 
					{
                        $coupon[$key]['status'] = 0;
                    }
                }
				else
				{
					$coupon[$key]['status'] = 0;	
				}
            }
            Core::$tpl->set('coupon_offer', $coupon_offer);
			Core::$tpl->set('offerList', $offerList);
			
            Core::$tpl->set('coupon', $coupon);
            Core::$tpl->set('pages', $page_data);
        }
    }

    public function actionAffiliate() {

    }

    /**
     * 评论列表
     */
    public function actionComments() {
        $page_size = Common::queryInt(_g('psize'), 10);
        $curr_page = Common::queryInt(_g('page'), 1);
        $commonLogic = $this->load("CommonJoinGoodsLangeageJoinGoods");
        $language_id = $this->load('language')->language_id;
        $where = "l.language_id=" . $language_id . " and c.status=1 order by c.id desc";
        $count = $commonLogic->getCount($where);
        $result = $commonLogic->getCurrentDatas($where, $page_size, $curr_page);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('result', $result);
        Core::$tpl->set('pages', $page_data);
    }

}

?>
