<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Module
 *
 * @author zjh www.35zh.com>
 */
class CouponController extends AppController {

    private $couponLogic;
    private $userLogic;
    private $offerLogic;
    private $offerJoinLanguageLogic;
    private $languageLogic;
    private $offerRuleLogic;

    public function __construct() {
        parent::__construct();
        $this->couponLogic = $this->load("coupon");
        $this->userLogic = $this->load("user");
        $this->offerLogic = $this->load("offer");
        $this->offerJoinLanguageLogic = $this->load("offerJoinLanguage");
        $this->languageLogic = $this->load("language");
        $this->offerRuleLogic = $this->load("offerRule");
    }

    public function actionDetail() {
		global $cfg ;
		$base_currency_id = (int)$cfg['sites'][0]['base_currency'] ;
		
		$base_currency =  $this->load('currency')->getOne("id=".$base_currency_id);
		
        $offer_id = _g("offer_id");
        if (!$offer_id) {
            return $this->exception(404);
        }
        $language_id = $this->languageLogic->language_id;
        $offer = $this->offerJoinLanguageLogic->getOne("o.id={$offer_id} and language_id={$language_id}");
        if ($offer["coupon_type"]==1) {
            return $this->exception(404);
        }
        $offerRule = $this->offerRuleLogic->getOne("offer_id={$offer_id}");

        Core::$tpl->set("seo_title", " Coupon : " . $offer["base_name"] . " - " . $_SERVER['SERVER_NAME']);
        Core::$tpl->set("seo_descript", $offer["detail"]);
        Core::$tpl->set('offer', $offer);
		Core::$tpl->set('base_currency', $base_currency);
        Core::$tpl->set('offerRule', $offerRule);
    }

    public function actionGetCouponCode() {
        $user_id = _g("user_id");
        $offer_id = _g("offer_id");
        if ($user_id) {
            if ($this->userLogic->getOneById($user_id)) {
                if ($coupons = $this->couponLogic->getOne("user_id={$user_id} and offer_id={$offer_id}")) {
                    echo json_encode(array("success" => true, "code" => $coupons["coupon_code"]));
                    exit;
                } else {
                    $code = $this->StructureCouponCode($offer_id, $user_id);
                    if ($code) {
                        echo json_encode(array("success" => true, "code" => $code));
                        exit;
                    }
                }
            }
        }
        echo json_encode(array("success" => false));
        exit;
    }

    private function StructureCouponCode($offer_id, $user_id) {
        $num = 1;
        $offer = $this->offerLogic->getOneById($offer_id);
        if (!$offer || $offer['offer_type'] != 2) {
            return false;
        }
        $send_limit = $offer['send_limit'];
        $send_num = $offer['send_num']+$num;
        if ($offer['send_limit'] == 0) {
            $limit = $num;
        } else {
            $limit = $num + $offer['send_num'] < $offer['send_limit'] ? $num : $offer['send_limit'] - $offer['send_num'];
        }
        if (!$limit) {
            return false;
        }
        //优惠券编号构造
        $coupon_code = strtoupper($offer['prefix'] . date('ymdHis', time()) . Common::random(3));
        $coupon_data = array(
            'user_id' => $user_id,
            'offer_id' => $offer_id,
            'coupon_code' => $coupon_code,
            'create_time' => SYS_TIME,
            'status' => 1,
        );
        if ($c_result = $this->couponLogic->save($coupon_data)) {
            $offer_data = array(
                //'send_limit' => $send_limit,
                'send_num' => $send_num,
            );
            $this->offerLogic->save($offer_data, $offer_id);
            return $coupon_code;
        }
        return false;
    }

}

?>