<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Deals
 *
 * @author hjp<huangjp@35zh.com>
 */
class DealsController extends AppController
{

    private $goodsJoinLangLogic;
    private $productLogic;
    private $goodsPropertyRelLogic;
    private $languageLogic;
    private $imageLogic;
    private $propertyLangLogic;
    private $goodsProRelLangLogic;
    private $goodsLogic;

    public function __construct()
    {
        parent::__construct();
        $this->goodsJoinLangLogic = $this->load('goodsJoinLanguage');
        $this->productLogic = $this->load('product');
        $this->goodsPropertyRelLogic = $this->load('goodsPropertyRel');
        $this->languageLogic = $this->load('language');
        $this->imageLogic = $this->load('productOtherImage');
        $this->propertyLangLogic = $this->load('propertyLanguage');
        $this->goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $this->goodsLogic = $this->load('goods');
    }
    public function actionDefault()
    {
        
    }
    public function actionList()
    {
        global $cfg;
        $language_id = $this->languageLogic->language_id;
        $offer_id = Common::queryInt(_g('offer_id'));

        $orderby = isset($cfg['sites'][0]['goods_default_sort']) ? $cfg['sites'][0]['goods_default_sort'] : 'goods_id ';
        $seq = ' desc';
        $orderby = $orderby == 'create_time' ? 'l.goods_id' : 'l.' . $orderby;
        //分页用的参数        
        $page_size = $cfg['sites'][$language_id]['special_list_number'] ? $cfg['sites'][$language_id]['special_list_number'] : 24;
        $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $in_stock_cond = '';
        if (_g('oquery'))
        {
            $oquery = explode('-', _g('oquery')); //oquery = 1-2-3-4 (展示方式-显示数量-字段-升降)
            $seq = $oquery[3] == 1 ? ' desc' : ' asc';
            if($oquery[1])
				$page_size = $oquery[1] ;
            switch ($oquery[2])
            {
                case 1:
                    $seq = ' desc';
                    break;
                case 2:
                    $orderby = 'g.price ';
                    break;
                case 3:
                    $orderby = 'g.buy_counts ';
                    break;
                case 4:
                    $orderby = 'g.comment_counts ';
                    break;
                case 5:
                    $orderby = 'g.wishlist_counts ';
                    break;
                case 6:
                    $orderby = 'g.visit_counts ';
                    break;
                case 7:
                    $orderby = 'l.goods_id ';
                    $seq = ' desc';
                    break;
                default :break;
            }
            $query = array(
                'listorder' => $oquery[3] ? $oquery[3] : 1,
                'order' => $oquery[2] ? $oquery[2] : 1,
                'psize' => $page_size
            );
            //只显示有货
            if($oquery[4])
            {
                $in_stock_cond = ' and g.stock_nums>0 ';
                $query['in_stock'] = 1;
            }
        }
		/*
        if ($offer_id)
            $count_sql = 'select count(g.id) as count from ' . TABLE_PREFIX . '_goods_language l left join ' . TABLE_PREFIX . '_goods g on l.goods_id=g.id and l.language_id=' . $language_id . ' and g.special_status=1 and g.special_offer_id=' . $offer_id . ' and g.start_time<' . time() . ' and g.end_time>' . time(). $in_stock_cond ;
        else
            $count_sql = 'select count(g.id) as count from ' . TABLE_PREFIX . '_goods_language l left join ' . TABLE_PREFIX . '_goods g on l.goods_id=g.id and l.language_id=' . $language_id . ' and g.special_status=1 and g.special_offer_id>0 and g.start_time<' . time() . ' and g.end_time>' . time(). $in_stock_cond ;
		*/
		
		if ($offer_id)
            $count_sql = 'select count(g.id) as count from ' . TABLE_PREFIX . '_goods_language l left join ' . TABLE_PREFIX . '_goods g on l.goods_id=g.id and l.language_id=' . $language_id . ' and g.special_status=1 and g.special_offer_id=' . $offer_id . ' ' . $in_stock_cond ;
        else
            $count_sql = 'select count(g.id) as count from ' . TABLE_PREFIX . '_goods_language l left join ' . TABLE_PREFIX . '_goods g on l.goods_id=g.id and l.language_id=' . $language_id . ' and g.special_status=1 and g.special_offer_id>0 ' . $in_stock_cond ;
		
        $sqlmd5 = md5($count_sql);
        $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
        if (!$count)
        {
            $count_array = $this->goodsJoinLangLogic->query($count_sql);
            $count = $count_array[0]['count'];
            $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
        }

        if ($offer_id)
            $where = 'l.status=1 and l.language_id=' . $language_id . ' and g.special_status=1 and g.special_offer_id=' . $offer_id . ' ' . $in_stock_cond . ' order by ' . $orderby . $seq;
        else
            $where = 'l.status=1 and l.language_id=' . $language_id . ' and g.special_status=1 and g.special_offer_id>0 ' .' '. $in_stock_cond . ' order by ' . $orderby . $seq;

        $page_data = Common::getPages($count, $curr_page, $page_size);
        $goodsList = $this->goodsJoinLangLogic->getCurrentDatas($where, $page_size, $curr_page);

        $specialOfferLogic = $this->load('SpecialOffer');
        $specialoffer = $specialOfferLogic->findAll('status=1 and start_time<' . time() . ' and end_time>' . time());
        Core::$tpl->set('specialoffer', $specialoffer);
        Core::$tpl->set('offer_id', $offer_id);
        Core::$tpl->set('deals', 1);
        Core::$tpl->set('goods_list', $goodsList);
        Core::$tpl->set('oquery', $query);
        Core::$tpl->set('total', $count);
        Core::$tpl->set('pages', $page_data);
        Core::$htmlFile = 'deals/list';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

}

?>
