<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Email
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class EmailController extends AppController
{

    private $mailtplJoinLangLogic;
    private $mailSenderLogic;

    public function __construct()
    {
        parent::__construct();
        ignore_user_abort(true);
        set_time_limit(0);
        $this->mailtplJoinLangLogic = $this->load('mailTplJoinLanguage');
        $this->mailSenderLogic = $this->load('mailSender');
    }

    /**
     * curl->发邮件
     * @return type
     */
    public function actionSentEmail()
    {
        $codeno = _g('codeno');
        $key = _g('key');
        $cond = 'codeno="' . $codeno . '" and security_key="' . $key . '"';
        $taskListLogic = $this->load('taskList');
        $task = $taskListLogic->getOne($cond);
        if (!$task)
        {
            echo "Task_404";
            return;
        }
        //更新执行状态
        $change = array('status' => 3, 'update_time' => time());
        $taskListLogic->save($change, $task['id']);
		
        $task['params']=preg_replace("/\r/i","",$task['params']);
        $task['params']=preg_replace("/\n/i","",$task['params']);
        $task['params']=preg_replace("/\t/i","",$task['params']);

        $params = json_decode($task['params'], TRUE);
        $result = $this->sent($codeno, $params);
        if ($result == true || $result == 1)
        {
            $status = 1;
            $execute_res = 'Success';
        }
        else
        {
            $status = 2;
            $execute_res = $this->mailSenderLogic->responseMsg();
        }
        //更新执行状态
        $change = array('status' => $status, 'result' => $execute_res, 'update_time' => time());
        $taskListLogic->save($change, $task['id']);
        echo $status . "-" . $execute_res;
        return;
    }

    /**
     * 执行发邮件
     * @param type $params
     * @return type
     */
    public function sent($condeno, $params)
    {		
        $language_id = $params['language_id'];
        $msg_tpl_id = $params['msg_tpl_id'];
        $email_tpl_id = $params['email_tpl_id'];
        $sent_to = $params['sent_to'];
		// 加载配置:
		global $cfg;
		Core::$tpl->set('site_cfg',$cfg['sites']);

        $content = $params['content'];
        $is_coupon = isset($params['is_coupon']) ? $params['is_coupon'] : '';
        $coupon = isset($params['coupon']) ? $params['coupon'] : '';
        $coupons = isset($params['coupons']) ? $params['coupons'] : '';		
        switch ($condeno)
        {
            case 'add_cart_after'://查询购物车是否存在该对象的商品，如没有就返回
                $user_id = isset($params['user_id']) ? $params['user_id'] : 0;
                $cartLogic = $this->load('userCart');
                $cart = $cartLogic->findAll('user_id=' . $user_id);
                if (!$cart)
                {
                    $flag = false; //购物车没有商品不能立即返回，因为还有其他邮件要发
                }
                break;
			case 'user_register_after':
				$user = $this->load('UserJoinInfo')->getUserById($content['id']);
				Core::$tpl->set('user', $user);
				break;
            case 'add_order_after':
			case 'order_complete_tip':
            case 'add_order_remind_admin':
            case 'order_pay_success_remind_admin':
            case 'order_cancel_notice':
            case 'order_refund_tip':
            case 'order_return_tip':			
            case 'recommend_user_first_pay_after':
                $user_name = $content['sub_username'];
                Core::$tpl->set('user_name', $user_name);
            case 'order_pay_success_tip':
			case 'remind_pay_for_order':
			case 'order_ship_notice':
				// 获取订单
				$order = $this->load('order')->getOneById($content['id']);
				if (!$order)
                {
                    return ;
                }
				$user = $this->load('UserJoinInfo')->getUserById($order['user_id']);
				if (!$user)
                {
                    return ;
                }
				$orderAddress = $this->load('OrderAddress')->getOne("order_id=".$order['id']);
				$shippingCorp = $this->load('ShippingCorp')->getOneById((int)$order['shipping_corp_id']);
				$orderShip = $this->load('OrderDelivery')->findAll("order_id=".$order['id']." and delivery_type=1");
				$orderReturn = $this->load('OrderDelivery')->findAll("order_id=".$order['id']." and delivery_type=2");
				$orderPay = $this->load('OrderPayment')->findAll("order_id=".$order['id']." and payment_type=1 and status = 1");
				$orderRefund = $this->load('OrderPayment')->findAll("order_id=".$order['id']." and payment_type=2");
				$currency = $this->load('Currency')->getOne("standard_code='".$order['currency_code']."'");
				$orderShipping = $this->load('shipping')->getOneById((int)$order['shipping_id']);
				$orderPayment = $this->load('payment')->getOneById((int)$orderPay[0]['payment_id']);

                $country = $this->load('country')->getOneById((int)$orderAddress[0]['country_id']);
				$orderBillAddress = $this->load('userAddress')->getOneById((int)$order['billing_address_id']);
                $AllCountry = $this->load('country')->findAll('', true);
				$AllPayment = $this->load('payment')->findAll('', true);
                $ShippingCorp = $this->load('shippingCorp')->findAll('', true);
                $AllCurrency = $this->load('Currency')->findAll('', true);
                $item_cond = 'order_id =' . $content['id'];
                $orderItemLogic = $this->load('orderItem');
                $orderItems = $orderItemLogic->findAll($item_cond);
                $productnum = 0;
                $result = array();
                $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
                foreach ($orderItems as $ky => $value)
                {
                    $property_ids = explode('_', $value['sku_code']);
                    $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($value['goods_id'], $property_ids, $language_id);
                    $value['attr']  = $attr;
                    $value['itemprice'] = $value['price'] * $value['buy_num'];
                    $productnum += $value['buy_num'];
                    $result[$ky] = $value;
                }
                Core::$tpl->set('productnum', $productnum);
                Core::$tpl->set('orderitems', $result);
				Core::$tpl->set('order', $order);
				Core::$tpl->set('user', $user);
				Core::$tpl->set('orderPayment', $orderPayment);
				Core::$tpl->set('orderShipping', $orderShipping);
				//Core::$tpl->set('shippingCorp', $shippingCorp);
				Core::$tpl->set('orderShip', $orderShip);
				Core::$tpl->set('orderItems', $result);
				Core::$tpl->set('orderPay', $orderPay);
				Core::$tpl->set('orderReturn', $orderReturn);
				Core::$tpl->set('orderRefund', $orderRefund);
				Core::$tpl->set('orderAddress', $orderAddress);
				Core::$tpl->set('currency', $currency);
                                //Core::$tpl->set('country', $country);
                Core::$tpl->set('orderBillAddress', $orderBillAddress);
                Core::$tpl->set('allCountry', $AllCountry);
				Core::$tpl->set('allPayment', $AllPayment);
                Core::$tpl->set('shippingCorp', $ShippingCorp);

                break;
            case 'message_reply_tip':
                $where = "id=" . $content['id'];
                $messageLogic = $this->load('message');
                $message = $messageLogic->getOne($where);
                if (!$message)
                {
					echo 3;
                    return;
                }
				$params['content']['domain'] = $message['domain'];
                $rep_where = "parent_id=" . $content['id']." order by id desc";
                $rep_message = $messageLogic->getOne($rep_where);
                if (!$rep_message)
                {
					echo 5;
                    return;
                }
				$message['reply_detail'] = $rep_message['detail'] ;
				Core::$tpl->set('message', $message);
                break;
          case 'user_leavemessage_after':
//              echo 999;exit;
                $where = "id=" . $content['id'];
                $messageLogic = $this->load('message');
                $message = $messageLogic->getOne($where);
                if (!$message)
                {
                    echo 3;
                    return;
                }
                if($message['user_id']){
                    $userInfoLogic = $this->load('UserJoinInfo');
                    $user_detail = $userInfoLogic->getOne('u.id=' . $message['user_id']);
                    Core::$tpl->set('user', $user_detail);

                }else{
                $message['contact'] = json_decode($message['contact'], 1);
                }
		Core::$tpl->set('message', $message);
                break;
            case 'leavemessage_sendto_guest':
                $where = "id=" . $content['id'];
                $messageLogic = $this->load('message');
                $message = $messageLogic->getOne($where);
                if (!$message)
                {
                    echo 3;
                    return;
                }
                if($message['user_id']){
                    $userInfoLogic = $this->load('UserJoinInfo');
                    $user_detail = $userInfoLogic->getOne('u.id=' . $message['user_id']);
                    Core::$tpl->set('user', $user_detail);

                }else{
                $message['contact'] = json_decode($message['contact'], 1);
                }
		Core::$tpl->set('message', $message);
                break;
            case 'goods_arrival_notice':
                $where = "id=" . $content['goods_id'];
                $goodsLogic = $this->load('goods');
                $goods = $goodsLogic->getOne($where);
                if (!$goods)
                {
                    return;
                }
                $urlMaker = AppController::load('UrlMaker');
                $goods_url = $urlMaker->getProductUrl($goods['id'],$goods['product_id'],$language_id,$rewrite,$params['res']);
                $params['content']['base_name'] = $goods['base_name'];
                Core::$tpl->set('goods', $goods);
                Core::$tpl->set('goods_url', $goods_url);
            case 'forgot_password':
                $auth_url = $content['auth_url'];
                Core::$tpl->set('auth_url', $auth_url);
            case 'send_password':
                $new_password = $content['new_password'];
                Core::$tpl->set('new_password', $new_password);

            case 'shop_cart_reminder':
                $user_id = isset($params['user_id']) ? $params['user_id'] : 0;
                $cartJoinSkuLogic = AppController::load('cartJoinSku');
                $cartinfo = $cartJoinSkuLogic->getCartInfo($user_id, $language_id);
//                if (!$cartinfo['orderitems'])
//                {
//                    exit;
//                }
                $cart["list"] = $cartinfo['orderitems'];
                $cart["totalnum"] =$cartinfo['final_qty'];
                $cart["totalprice"] =$cartinfo['totalprice'];

                $lcoin = AppController::getBaseCurrency();
//                print_r($cartinfo);
//                exit;
                Core::$tpl->set('cart', $cart);
                Core::$tpl->set('lcoin', $lcoin["symbol_left"]);
                break;

            case 'wishlist_reminder':
                $favoriteLogic = AppController::load('userFavoriteJoinGoods');
                $user_id = isset($params['user_id']) ? $params['user_id'] : 0;

                $wishlist = $favoriteLogic->findAll("user_id = {$user_id} order by id desc");
//                if (!$wishlist)
//                {
//                    exit;
//                }

                $lcoin = AppController::getBaseCurrency();
//                print_r($wishlist);
//                exit;
                Core::$tpl->set('wishlist', $wishlist);
                Core::$tpl->set('lcoin', $lcoin["symbol_left"]);
                break;
			case 'user_submitnewsletter':						
				$domain = "[http://".$content["domain"]."]";
                Core::$tpl->set('username',$content["username"]);
				Core::$tpl->set('domain',$domain);
				break;
            default : break;
        }
		
        //发送优惠券处理
        if ($is_coupon)
        {
            $offer_id = isset($coupon['offer_id']) ? $coupon['offer_id'] : 0;
            $offerLogic = $this->load('offer');
            $offer = $offerLogic->getOneById($offer_id);
            if ($offer && $offer['offer_type'] == 2)
            {
                Core::$tpl->set('offer', $offer);
                Core::$tpl->set('coupons', $coupons);
            }
        }
        foreach (explode(' ', $params['var_descript']) as $_v)
        {

           // Core::$tpl->set($_v, $content);
        }
		Core::$tpl->set("content", $content);
        Core::$tpl->left_delimiter = "{{";
        Core::$tpl->right_delimiter = "}}";
        //发站内信
        if ($this->checkEmailTpl($msg_tpl_id, $language_id))
        {
			$message_content = Core::$tpl->render(APP_ROOT . 'cache/email/' . $msg_tpl_id . '_' . $language_id . '_tpl.htm', NULL, TRUE);
			$message_content = str_replace("\r","",$message_content);
			$message_content = str_replace("\n","",$message_content);
            $messageLogic = $this->load('Message');
            if ($content['username'])
            {
                $userLogic = $this->load('user');
				$cond = 'm.id=' . $email_tpl_id . ' and l.language_id=' . $language_id;
				$mailtplLogic = $this->load('MailTplJoinLanguage');
				$tpl = $mailtplLogic->getOne($cond);
				if ($tpl)
				{
					$msg_title = $tpl['base_name'] ;
       				$msg_title = $this->str_replace_title($msg_title, $params['content']);
				}
                $user = $userLogic->getOne('base_name="'.$content['username'].'"');
                if($user)
                {
                    $msg_map = Zhtx::createDataMap();
                    $msg_map->addEntry('user_name', $user["base_name"], DB::VARCHAR);
                    $msg_map->addEntry('base_name', $msg_title, DB::VARCHAR);
                    $msg_map->addEntry('language_id', $language_id, DB::INT);
                    $msg_map->addEntry('type', 1, DB::INT);
                    $msg_map->addEntry('user_id', $user['id'], DB::INT);
					$msg_map->addEntry('admin_id', 0, DB::INT);
                    $msg_map->addEntry('parent_id', 0, DB::INT);
                    $msg_map->addEntry('detail', Common::strEscape($message_content), DB::VARCHAR);
                    $msg_map->addEntry('is_user_readed', 0, DB::INT);
                    $msg_map->addEntry('status', 1, DB::INT);
                    $msg_map->addEntry('is_admin_readed', 1, DB::INT);
                    $msg_map->addEntry('create_time', SYS_TIME, DB::INT);
                    $messageLogic->insert($msg_map);
                }
            }
        }		
        //发邮件
        if ($this->checkEmailTpl($email_tpl_id, $language_id))
        {
            $sent_content = Core::$tpl->render(APP_ROOT . 'cache/email/' . $email_tpl_id . '_' . $language_id . '_tpl.htm', NULL, TRUE);
			$cond = 'm.id=' . $email_tpl_id . ' and l.language_id=' . $language_id;
			$mailtplLogic = $this->load('MailTplJoinLanguage');
			$tpl = $mailtplLogic->getOne($cond);
			if ($tpl)
			{
				$title = $tpl['base_name'] ;
				$title = $this->str_replace_title($title, $params['content']);
			}
            //发邮件
            $this->mailSenderLogic->init($language_id);			
            $result = $this->mailSenderLogic->sendTo($sent_to, $title, $sent_content);
            return $result;
        }
    }

    public function checkEmailTpl($email_tpl_id, $language_id)
    {
        if(!$email_tpl_id)
			return false ;
		$tpl_file = APP_ROOT . 'cache/email/' . $email_tpl_id . '_' . $language_id . '_tpl.htm';
        if (!is_file($tpl_file))
        {
            $cond = 'm.id=' . $email_tpl_id . ' and l.language_id=' . $language_id;
            $mailtplLogic = $this->load('MailTplJoinLanguage');
            $email = $mailtplLogic->getOne($cond);
            if ($email)
            {
                //生成邮件模板，调用图片需保证绝对路径
                Common::_mkdir(APP_ROOT . 'cache/email');
                $content = $email['detail'];
                preg_match_all('/(<img\"?.+\ssrc=["|\'])(.*?)([a-z0-9A-Z_\-.]["|\']\"?.+>)/i', $content, $img_arr);
                foreach ($img_arr[0] as $k => $value)
                {
                    $new_value = str_replace('src="/upload', 'src="' . SITE_PROTOCOL . SITE_URL . '/upload', $value);
                    $content = str_replace($value, $new_value, $content);
                }
                $fp = fopen($tpl_file, "w+");
                @fwrite($fp, $content);
                @fclose($fp);
            }
            else
            {
                return FALSE;
            }
        }
        return TRUE;
    }

    public function str_replace_title($title, $content)
    {
        $replace = array(
            '{{domain}}' => $content['domain'],
            '{{orderno}}' => $content['itemno'],
            '{{goods_name}}' => $content['base_name'],
            '{{message_title}}' => $content['message_title'],
        );
        foreach ($replace as $key => $value)
        {
            $title = str_replace($key, $value, $title);
        }
        return $title;
    }

}

?>
