<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * 从中恒旧系统导入产品
 *
 * @author hjp <huangjp@35zh.com>
 */
class ImportGoodsFromZhOldSyController extends AppController
{    
    private $langLogic;
    private $languageJoinCountryLogic;
    private $catgoryLogic;
    private $goodsLogic;
    private $goodsLangLogic;
    private $goodsJoinLanguageLogic;
    private $goodsCatLangLogic;
    private $goodsCatRelLogic;
    private $productImageLogic;
    private $taskListLogic;
    public function __construct()
    {
       parent::__construct();
       $this->langLogic      = $this->load('language');
       $this->languageJoinCountryLogic      = $this->load('languageJoinCountry');
       $this->catgoryLogic   = $this->load('goodsCategory');
       $this->goodsLogic      = $this->load('goods');
       $this->goodsLangLogic      = $this->load('goodsLanguage');
       $this->goodsJoinLanguageLogic   = $this->load('goodsJoinLanguage');
       $this->goodsCatLangLogic = $this->load('goodsCategoryLanguage');
       $this->goodsCatRelLogic = $this->load('goodsCategoryRel');
       $this->productImageLogic = $this->load('ProductOtherImage');
       $this->taskListLogic = $this->load('taskList');
       ignore_user_abort(true);
       set_time_limit(0);
    }

    public function actionGetGoodsList()
    {
        //error_reporting(E_ALL);        
        $language_id = Common::queryInt(_g('language_id'));
        $category_id = Common::queryInt(_g('category_id'));
        $goods_remote_url = urldecode(Common::queryStr(_g('goods_remote_url')));
        $category_remote_id = Common::queryInt(_g('category_remote_id'));
        $remote_goosList_url = $goods_remote_url.'/service/serviceForGetProductList.php?category_id='.$category_remote_id;
        
        $security_key = Common::queryStr(_g('security_key'));
        $task_list_id = Common::queryInt(_p('id'));
        $tasklistitem=$this->taskListLogic->getOne('id='.$task_list_id);
        if($tasklistitem && $tasklistitem['security_key']==$security_key)
        {
            $cond = 'id=' . $category_id;
            $cate  = $this->catgoryLogic->getOne($cond);
            if(!$cate)
            {
                echo '2';
                return ;
            }
            $content     = Common::getRemoteData($remote_goosList_url);
	    $content=$this->removeUtf8Bom($content);
            //var_dump($content);
            if($content!='')
            {
                //清理旧数据
                $goodscaterellist=$this->goodsCatRelLogic->findAll("goods_category_id=".$category_id);
                foreach($goodscaterellist as $keygcr => $goodscaterows)
                {
                    $goods = $this->goodsLogic->getOneById($goodscaterows['goods_id']);
                    if($goods)
                    {
                      $res  = $this->goodsLogic->delete('id=' . $goodscaterows['goods_id']);
                      if($res)
                      {   
                        $this->goodsLangLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$this->skuLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$this->productLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        $this->productImageLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$this->goodsProRelLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        $this->goodsCatRelLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$this->goodsTagRelLogic->delete('goods_id=' . $goodscaterows['goods_id']);                   
                        //$this->goodsSelfRelLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$commentLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$outStocklogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$giftLogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //$offerItemlogic->delete('goods_id=' . $goodscaterows['goods_id']);
                        //清空缓存
                        $this->goodsLangLogic->updateCache($goodscaterows['goods_id']);
                      }
                    }
                }
                $goods_list = json_decode($content,TRUE);
                //var_dump($goods_list);
                $addcount=0;   
                $addcount1=0; 
                foreach($goods_list as $key => $value)
                {
                      $main_image = $value['pic']=='' ? '':'goods/'.$value['pic']; 
                      $goods_base_name = Common::strEscape($value['name']);
                      $codeno    = $value['itemno'];      
                      $category_ids    = array($category_id);
                      $addcount1++;
                      //
                      if (!$goods_base_name)
                      {
                            $goods_base_name = 'Please modify temporary name' ;
                      }
                      if (!isset($category_ids[0]) || !$category_ids[0])
                      {
                            $category_ids[0]=0;
                      }
                      if (!$codeno)
                      {
                            $codeno = time().  rand(100, 9999);
                      }
                      $cond = "codeno='" . $codeno . "'";
                      $goods_count = $this->goodsLogic->getCount($cond);
                      if ($goods_count > 0 && _p('itemnotype')!=2)
                      {
                          //continue;
                      }
                      $goods_type_id = $cate['goods_type_id'];
                      $goods_data = array(
                              'base_name' => $goods_base_name,
                              'codeno' => $codeno,
                              'brand_id' => _s('current_brand_id'),
                              'goods_type_id' => $goods_type_id,         
                              'create_time' => SYS_TIME,
                              'image' => Common::strEscape($main_image),
                              'price' => $value['price1'],
                              'weight' => $value['weight'],
                              'market_price' => $value['price2'],
                      );
                      $goods_result = $this->goodsLogic->save($goods_data);
                      if ($goods_result)
                      {
                            $addcount++;
                            //多语言
                            $detail = Common::strEscape($value['content']);
                            $title = Common::strEscape($value['title']);
                            $keyword = Common::strEscape($value['keywords']);
                            $descript = Common::strEscape($value['descript']);
                            $sites     = $this->langLogic->findAll('status=1');
                            if($language_id)
                            {
                                $lang_data = array(
                                        'goods_id'    => $goods_result,
                                        'language_id' => $language_id,
                                        'base_name'   => Common::strEscape($value['name']),
                                        'detail' => $detail,
                                        'title'  => $title ,
                                        'keywords' =>$keyword,
                                        'descript' => $descript,
                                        'status'        => 1,
                                );
                                $this->goodsLangLogic->save($lang_data);
                            }
                            else
                            {
                                foreach ($sites as $key => $val)
                                {
                                    $lang_data = array(
                                            'goods_id'    => $goods_result,
                                            'language_id' => $sites[$key]['id'],
                                            'base_name'   => Common::strEscape($value['name']),
                                            'detail' => $detail,
                                            'title'  => $title ,
                                            'keywords' =>$keyword,
                                            'descript' => $descript,
                                            'status'        => 1,
                                    );
                                    $this->goodsLangLogic->save($lang_data);
                                }
                            }
                            //关联分类
                            $cat_where = 'id in(' . implode(',', $category_ids) . ')';
                            $categorylist = $this->catgoryLogic->getList($cat_where);
                            foreach ($categorylist['list'] as $cat)
                            {
                              $goods_cat_arr = array(
                                      'goods_id' => $goods_result,
                                      'goods_category_id' => $cat['id'],
                                      'category_path' => $cat['path_id'],
                              );
                              $this->goodsCatRelLogic->save($goods_cat_arr);
                            }
                            //关联标签
                            $tag_ids = _p('goods_tag_id');
                            if ($tag_ids)
                            {
                              foreach ($tag_ids as $tag)
                              {
                                    $tag_map = Zhtx::createDataMap();
                                    $tag_map->addEntry('goods_id', $goods_result, DB::INT);
                                    $tag_map->addEntry('tag_id', $tag, DB::INT);
                                    $this->goodsTagRelLogic->insert($tag_map);
                              }
                            }



                            //图片存放
                            //$imagelist = _p('image');
                            //ksort($imagelist);      
                            $otherimage = '';
                            $remote_otherimage_url = $goods_remote_url.'/service/serviceForGetProductOtherImageList.php?goods_id='.$value['id'];
                            $otherimagecontent     = Common::getRemoteData($remote_otherimage_url);
			    $otherimagecontent=$this->removeUtf8Bom($otherimagecontent);
                            if($otherimagecontent!='')
                            {
                                $otherimage_list = json_decode($otherimagecontent,TRUE);
                                $otherimagearr=array();
                                foreach($otherimage_list as $keyo => $valueo)
                                {
                                    $otherimagearr[] = 'goods/'.$valueo['pic'];
                                }
                                $otherimage = join(',',$otherimagearr);
                            }
                            if(trim($otherimage)=='')
                            {
                                    $otherimage=$main_image;
                            }
                            else
                            {
                                    $otherimage=$main_image.','.$otherimage;
                            }
                            $imagelist=array();
                            if($otherimage!='')
                            {
                                    $imagelist[] = split(',',$otherimage);
                            }
                            foreach ($imagelist as $key => $imgs)
                            {
                              $current_product_id = $key != 0 && isset($has_product[$key]) ? $has_product[$key] : 0;
                              $product_con[$current_product_id]['image'] = $imgs[0];
                              foreach ($imgs as $order => $value)
                              {            
                                    $img_data = array(
                                            'goods_id' => $goods_result,
                                            'product_id' => $current_product_id,
                                            'image' => Common::strEscape($value),
                                            'listorder' => $order,
                                    );
                                    $this->productImageLogic->save($img_data);
                              }
                            }
                            sleep(1);
                      }
                }
                if($addcount>0)
                {
                    $taskstatus=1;
                    echo 1;
                }
                else
                {
                    $taskstatus=2;
                    echo 0;
                }
            }
            else
            {
                $taskstatus=2;
                echo 0;
            }
            //更新任务状态
            $tkparam=array();
            $tastlist_map  = Zhtx::createDataMap();
            if($taskstatus==1)
            {
                $tastlist_map->addEntry('result', 'Success', DB::VARCHAR);
                $tastlist_map->addEntry('status', 1, DB::VARCHAR);
            }
            else if($taskstatus==2)
            {
                $tastlist_map->addEntry('status', 2, DB::VARCHAR);
            }
            else
            {
                $tastlist_map->addEntry('status', 0, DB::VARCHAR);
            }
            $result = $this->taskListLogic->update($tastlist_map, 'id=' . $task_list_id);
            
        }
        else
        {
            echo 2;
        }
        
    }
	
    public function removeUtf8Bom($contents)
    {
            $charset[1] = substr($contents, 0, 1); 
            $charset[2] = substr($contents, 1, 1); 
            $charset[3] = substr($contents, 2, 1); 
            if(ord($charset[1]) == 239 && ord($charset[2]) == 187 && ord($charset[3]) == 191) { 
                $contents = substr($contents, 3); 
            }
            return $contents;
    }
}
?>
