<?php

/**
 * Description of Order
 *
 * @author xrx
 */
class OrderController extends AppController {

    private $orderLogic;
    private $orderItemLogic;
    private $langLogic;
    private $cartJoinSkuLogic;
    private $user_id;
    private $language_id;
    private $messageLogic;

    public function __construct() {
        parent::__construct();
        $this->orderLogic = $this->load('order');
        $this->orderItemLogic = $this->load('orderItem');
        $this->langLogic = $this->load('language');
        $this->cartJoinSkuLogic = $this->load('cartJoinSku');
        $this->user_id = $this->checkLogin();
        $this->language_id = $this->langLogic->language_id;
        $this->messageLogic = $this->load('message');
        $this->propertyLogic = $this->load('property');
        $this->creditSettingLogic = $this->load('creditSetting');
        ignore_user_abort(true);
        set_time_limit(0);
    }

    /**
     * 进入购物车结算页
     * @global type $authorize_shop
     * @return type
     */
    public function actionAdd() {
        global $cfg;
        global $authorize_shop;
        $billing_display = isset($cfg['sites'][0]['billing_display']) ? $cfg['sites'][0]['billing_display'] : 0;
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $user_id = $this->user_id;
        if (!$user_id && !$authorize_shop) {
            $ref = urlencode(Common::getUrl());
            return $this->_redirect(Common::frontURL('home', 'user', 'login', array('ref' => $ref)));
        }
        $language_id = $this->language_id;
        $cartInfo = $this->cartJoinSkuLogic->getCartInfo($user_id, $language_id);


        if (Common::toolPrice($cfg['sites'][0]['moq']) > $cartInfo['subtotalprice']) {
            Common::alertRedirect(str_replace("{0}", _s("symbol_left") . ' ' . Common::toolPrice($cfg['sites'][0]['moq']), $lang['moq_notics']), 'shopcart.html');
        }

        if (count($cartInfo['orderitems']) <= 0) {
            return $this->_redirect(Common::frontURL('home', 'cart', 'list'));
        }
        foreach ($cartInfo['orderitems'] as $key => $value) {
            if ($value['stock_nums'] == '' || $value['stock_nums'] <= 0) {
                Common::alertRedirect($lang['cart_out_of_stock'], Common::frontURL('home', 'cart', 'list'));
            }
        }
        $userAddressCountryLogic = $this->load('userAddressCountry');
        $userAddress = array();
        if ($user_id) {
            $userAddress = $userAddressCountryLogic->getListByUserId($user_id);
            $userBillingAddress = $userAddressCountryLogic->getListByUserId($user_id, 1);
        }
        $creditSetting = $this->creditSettingLogic->getOne();
        Core::$tpl->set('creditSetting', $creditSetting);
        $contryLogic = $this->load('country');
        $countrylist = $contryLogic->getCountries();
        $this->load('creditDetail')->checkCredit(); //检测及清理过期积分
        //根据sku_code查询sku的codeno
        $skuLogic = $this->load('sku');
        foreach ($cartInfo['orderitems'] as $key => $value) {
            if ($value['sku_code'] && $value['goods_id']) {
                $sku = $skuLogic->getOne('goods_id=' . $value['goods_id'] . ' and sku_code="' . $value['sku_code'] . '"');
                if ($sku['codeno']) {
                    $cartInfo['orderitems'][$key]['sku_codeno'] = $sku['codeno'];
                } else {
                    $cartInfo['orderitems'][$key]['sku_codeno'] = '';
                }
            } else {
                $cartInfo['orderitems'][$key]['sku_codeno'] = '';
            }
        }
        Core::$tpl->set('billing_display', $billing_display);
        Core::$tpl->set('countrylist', $countrylist);
        Core::$tpl->set('orderitems', $cartInfo['orderitems']);
        Core::$tpl->set('addresslist', $userAddress);
        Core::$tpl->set('billingaddresslist', $userBillingAddress);
        Core::$tpl->set('cart_save', $cartInfo['cart_save'] + $cartInfo['offer_save']);
        Core::$tpl->set('final_qty', $cartInfo['final_qty']);
        Core::$tpl->set('totalprice', $cartInfo['totalprice']);
        Core::$tpl->set('productprice', $cartInfo['subtotalprice'] + $cartInfo['cart_save'] + $cartInfo['offer_save']);
        Core::$tpl->set('subtotalprice', $cartInfo['subtotalprice']);
        Core::$tpl->set('cart_gift', $cartInfo['cart_gift']);
        Core::$tpl->set('totalweight', $cartInfo['totalweight']);
    }

    /**
     * ajax
     * 获取物流运费
     */
    public function actionGetShippingFee() {
        $shipping_id = Common::queryInt(_p('shipping_id'));
        $return = $this->getCreditInfo($shipping_id);
        $language_id = $this->language_id;
        $user_id = $this->checkLogin();
        $cartInfo = $this->cartJoinSkuLogic->getCartInfo($user_id, $language_id, false);
        if ($cartInfo['promotion_save'] > 0 && !$return['is_spec']) {
            $return['is_show_credit'] = 0;
        } else {
            $return['is_show_credit'] = 1;
        }
        echo $return ? json_encode($return) : FALSE;
    }

    /**
     * ajax
     * 验证消费的积分
     */
    public function actionValidExpCredit() {
        $shipping_id = Common::queryInt(_p('shipping_id'));
        $payment_id = Common::queryInt(_p('payment_id'));
        $insurance_selected = Common::queryInt(_p('insurance_selected'));
        $credit = _p('credit');
        $return = array('status' => 0, 'msg' => '', 'credit' => 0, 'amount' => 0);
        if (!is_numeric($credit)) {
            $return['msg'] = 'This have illegal characters';
            echo json_encode($return);
            return;
        }
        $rs = $this->getCreditInfo($shipping_id, $payment_id, $insurance_selected);
        if ($rs) {
            if ($credit > $rs['max_exp_credit']) {
                $return['status'] = 1;
                $return['msg'] = 'Use only ' . $rs['max_exp_credit'] . ' credits';
                $return['credit'] = $rs['max_exp_credit'];
                $return['amount'] = $this->toolPrice($return['credit'] / $rs['exchange_credit_scale']);
                $return['payment_amount'] = $rs['payment_amount'] - $return['amount'];
                if ($insurance_selected) {
                    $return['payment_amount'] += $rs['insurance_fee'];
                }
            } else {
                $return['status'] = 2;
                $return['credit'] = $credit;
                $return['amount'] = $this->toolPrice($credit / $rs['exchange_credit_scale']);
                $return['payment_amount'] = $rs['payment_amount'] - $return['amount'];
                if ($insurance_selected) {
                    $return['payment_amount'] += $rs['insurance_fee'];
                }
            }
        }
        echo json_encode($return);
    }

    /**
     * 效验运费险
     */
    public function actionValidInsurance() {
        $shipping_id = Common::queryInt(_p('shipping_id'));
        $insurance = Common::queryInt(_p('insurance'));
        $rs = $this->getCreditInfo($shipping_id);
        if ($insurance) {
            $return = array(
                'payment_amount' => $rs['payment_amount'] + $rs['insurance_fee'],
                'insurance_fee' => $rs['insurance_fee'],
            );
        } else {
            $return = array(
                'payment_amount' => $rs['payment_amount'],
                'insurance_fee' => 0,
            );
        }

        echo json_encode($return);
    }

    /**
     *  下单
     * @global type $current_currency
     * @return type
     */
    public function actionStep1() {
        global $cfg;
        $params = array(
            'address_id' => Common::queryInt(_p('shipping_address')),
            'shipping_id' => Common::queryInt(_p('shipping_id')),
            'payment_id' => Common::queryInt(_p('payment_id')),
            'order_remark' => Common::strEscape(strip_tags(_p('order_remark'))),
            'use_credit' => Common::queryInt(_p('use_credit')),
            'insurance' => _p('insurance'),
            'billing_address_id' => Common::queryInt(_p('billing_address_id'), 0),
            'shippingaddrasbillingaddr' => Common::queryInt(_p('shippingaddrasbillingaddr'), 0),
        );
        $do = _p('do');
        if ($do == 'save' || !$cfg['sites'][0]['order_confirm']) {
            $order = $this->insertOrder($params);
            if ($order['key']) {
                return $this->showMessage($order['key'], Common::frontURL('home', 'cart', 'list'));
            } else {
                if ($order['payment_id']) {
                    return $this->_redirect(Common::frontURL('home', 'order', 'payment', array('itemno' => $order['itemno'])));
                } else {
                    return $this->_redirect(Common::frontURL('home', 'order', 'step2', array('itemno' => $order['itemno'])));
                }
            }
            return $this->showMessage('save_failure');
        } else {
            $user_id = $this->user_id;
            $userAddressLogic = $this->load('userAddress');
            $shippingLogic = $this->load('shipping');
            $address = $userAddressLogic->getOneById($params['address_id']);
            if (!$params['address_id'] || !$address || $address['user_id'] != $user_id || !$address['country_id']) {
                return $this->showMessage('illegal_parameters', Common::frontURL('home', 'cart', 'list'));
            }
            $shipping = $shippingLogic->getOneById($params['shipping_id']);
            if (!$params['shipping_id'] || !$shipping) {
                return $this->showMessage('illegal_parameters', Common::frontURL('home', 'cart', 'list'));
            }
            global $authorize_shop;

            if (!$user_id && !$authorize_shop) {
                $ref = urlencode(Common::getUrl());
                return $this->_redirect(Common::frontURL('home', 'user', 'login', array('ref' => $ref)));
            }
            $language_id = $this->language_id;
            $cartInfo = $this->cartJoinSkuLogic->getCartInfo($user_id, $language_id);
            if (count($cartInfo['orderitems']) <= 0) {
                return $this->_redirect(Common::frontURL('home', 'cart', 'list'));
            }
            $userAddressCountryLogic = $this->load('userAddressCountry');
            $userAddress = array();
            if ($user_id) {
                $userAddress = $userAddressCountryLogic->getListByUserId($user_id);
            }
            $contryLogic = $this->load('country');
            $countrylist = $contryLogic->getCountries();
            $this->load('creditDetail')->checkCredit(); //检测及清理过期积分
            Core::$tpl->set('countrylist', $countrylist);
            Core::$tpl->set('orderitems', $cartInfo['orderitems']);
            Core::$tpl->set('addresslist', $userAddress);
            Core::$tpl->set('cart_save', $cartInfo['cart_save'] + $cartInfo['offer_save']);
            Core::$tpl->set('final_qty', $cartInfo['final_qty']);
            Core::$tpl->set('totalprice', $cartInfo['totalprice']);
            Core::$tpl->set('subtotalprice', $cartInfo['subtotalprice']);
            Core::$tpl->set('cart_gift', $cartInfo['cart_gift']);
            Core::$tpl->set('totalweight', $cartInfo['totalweight']);
            Core::$tpl->set('params', $params);

            Core::$htmlFile = 'order/confirm';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 在线支付页面跳转
     * 离线支付信息显示
     * 自定义支付页面显示
     */
    public function actionPayment() {
        $language_id = $this->langLogic->language_id;
        $paymentLogic = $this->load('payment');
        $orderPaymentLogic = $this->load('orderPayment');
        $currencyLogic = $this->load('currency');

        $where = "itemno='" . _g('itemno') . "'";
        $order = $this->orderLogic->getOne($where);
        if (!$order) {
            return $this->showMessage('illegal_parameters', Common::frontURL('home', 'account', 'index'));
        }
        $user_id = $order['user_id'];
        if ($order['payment_status'] == '201') {
            return $this->success('paid_successul_tip', Common::frontURL('home', 'account', 'index'));
        }
        $currency_code = $order['currency_code']; //货币三位符
        $currency_conde = 'standard_code="' . $currency_code . '"';
        $currency = $currencyLogic->getOne($currency_conde);
        //获取付款单据
        $orderPayment = $orderPaymentLogic->getOne('order_id=' . $order['id'] . ' and payment_type=1');
        if (!$orderPayment) {
            return $this->showMessage('illegal_parameters', Common::frontURL('home', 'account', 'index'));
        }
        $payment_id = $orderPayment['payment_id'];
        $payment = $paymentLogic->getOne('id=' . $payment_id . ' and (language_id=0 or language_id=' . $this->langLogic->real_language_id . ')');
        if (!$payment) {
            return $this->showMessage('illegal_parameters', Common::frontURL('home', 'order', 'step2', array('itemno' => $order['itemno'])));
        }

        global $cfg;
        $base_currency_id = $cfg['sites'][0]['base_currency'];
        $trade_no = date('Ymdhsi', time());
        $pay_amount = $order['final_amount'] - $order['payed'];
        $payment_data = array(
            'payment_type' => 1,
            'trade_no' => $trade_no,
            'order_id' => $order['id'],
            'user_id' => $user_id,
            'payment_id' => $payment_id,
            'amount' => $this->speChangePrice($pay_amount, $currency, TRUE),
            'base_currency_id' => $base_currency_id,
            'real_currency_id' => $currency['id'],
            'real_currency_amount' => $pay_amount,
            'status' => 0,
            'create_time' => SYS_TIME,
        );
        $res = $orderPaymentLogic->updateByCond($payment_data);
        if ($res) {
            $result = null;
            $pay = $payment;
            $interface_type = $pay['interface_type'];
            if (is_file(APP_ROOT . 'api/payment/' . $interface_type . '/script.php')) {
                require_once(APP_ROOT . "libary/BasePaymentInterface.php");
                require_once(APP_ROOT . 'api/payment/' . $interface_type . '/script.php');
                $interface = new $interface_type();
                $curOrderPayment = $orderPaymentLogic->getOne('trade_no="' . $trade_no . '"');
                if (method_exists($interface_type, 'getDiyForm')) {
                    $form = $interface->getDiyForm($curOrderPayment['id']);
                    if (!$form) {
                        $form = $interface->getInterfaceForm($curOrderPayment['id']);
                    }
                    $result = array(
                        'subtotal' => $order['cost_payment'],
                        'payment_fee' => $order['payment_fee'],
                        'payed' => $order['payed'],
                        'amount' => $payment_data['real_currency_amount'],
                        'total' => $order['final_amount'],
                        'payment_detail' => $pay['detail'],
                        'frame_form_html' => $form
                    );
                } else {
                    $form = $interface->getInterfaceForm($curOrderPayment['id']);
                    $result = array(
                        'subtotal' => $order['cost_payment'],
                        'payment_fee' => $order['payment_fee'],
                        'payed' => $order['payed'],
                        'amount' => $payment_data['real_currency_amount'],
                        'total' => $order['final_amount'],
                        'payment_detail' => $pay['detail'],
                        'form_html' => $form
                    );
                }
            } else {
                $result = array(
                    'subtotal' => $order['cost_payment'],
                    'payment_fee' => $order['payment_fee'],
                    'payed' => $order['payed'],
                    'amount' => $payment_data['real_currency_amount'],
                    'total' => $order['final_amount'],
                    'payment_detail' => $pay['detail'],
                    'form_html' => ''
                );
            }
        } else {
            return $this->showMessage('illegal_parameters', Common::frontURL('home', 'account', 'index'));
        }
        Core::$tpl->set('payment_info', $result);
        Core::$tpl->set('order', $order);
        Core::$tpl->set('currency', $currency);
    }

    /**
     * 获取支付手续费
     */
    public function actionGetPaymentFee() {
        $language_id = $this->language_id;
        $shipping_id = Common::queryInt(_p('shipping_id'));
        $payment_id = Common::queryInt(_p('payment_id'));
        $insurance_selected = Common::queryInt(_p('insurance_selected'));
        $credits_value_amount = _p('credits_value_amount');
        $return = $this->getCreditInfo($shipping_id, $payment_id, $insurance_selected, $credits_value_amount);
        if ($return && $insurance_selected) {
            $return['payment_amount'] = $return['payment_amount'] + $return['insurance_fee'];
        }
        $paymentLogic = $this->load('payment');
        $cond = '(language_id=0 or language_id=' . $language_id . ') and status=1 and id=' . $payment_id . ' order by listorder desc';
        $payment_info = $paymentLogic->getOne($cond);
        $return['status'] = 0;
        if ($return['payment_amount'] < $payment_info['min_order_amount'] && $payment_info['min_order_amount'] != 0) {
            $return['status'] = 1;
        }
        if ($return['payment_amount'] > $payment_info['max_order_amount'] && $payment_info['max_order_amount'] != 0) {
            $return['status'] = 2;
        }
        echo $return ? json_encode($return) : FALSE;
    }

    /**
     * 订单第二步选择支付
     * @return type
     */
    public function actionStep2() {

        $language_id = $this->langLogic->language_id;
        $paymentLogic = $this->load('payment');
        $orderPaymentLogic = $this->load('orderPayment');
        $currencyLogic = $this->load('currency');
        if (_p()) {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $order_id = Common::queryInt(_p('order_id'));
            $order = $this->orderLogic->getOneById($order_id);
            if (!$order) {
                echo 0;
                exit;
            }
            $user_id = $order['user_id'];
            $payment_id = Common::queryInt(_p('payment_id'));
            $payment = $paymentLogic->getOneById($payment_id);
            if (!$payment) {
                echo 0;
                exit;
            }
            $currency_code = $order['currency_code']; //货币三位符
            $currency_conde = 'standard_code="' . $currency_code . '"';
            $currency = $currencyLogic->getOne($currency_conde);
            $payment_param = $payment['config_param'];
            $payment_formula = $payment['formula'];
            $order_param = array(
                'totalprice' => $this->speChangePrice($order['total_amount'], $currency, TRUE)
            );
            $fee = $paymentLogic->getPaymentFee($order_param, $payment_param, $payment_formula);
            $payment_fee = $fee ? $this->speChangePrice($fee, $currency) : 0;
            $order_data = array(
                'payment_fee' => $payment_fee,
                'final_amount' => $order['total_amount'] + $payment_fee,
            );
            $order_res = $this->orderLogic->save($order_data, $order['id']);
            if ($order_res) {
                global $cfg;
                $base_currency_id = $cfg['sites'][0]['base_currency'];
                $trade_no = date('Ymdhsi', time());
                $pay_amount = $order_data['final_amount'] - $order['payed'];
                $payment_data = array(
                    'payment_type' => 1,
                    'trade_no' => $trade_no,
                    'order_id' => $order['id'],
                    'user_id' => $user_id,
                    'payment_id' => $payment_id,
                    'amount' => $this->speChangePrice($pay_amount, $currency, TRUE),
                    'base_currency_id' => $base_currency_id,
                    'real_currency_id' => $currency['id'],
                    'real_currency_amount' => $pay_amount,
                    'status' => 0,
                    'create_time' => SYS_TIME,
                );
                $res = $orderPaymentLogic->updateByCond($payment_data);
                if ($res) {
                    $result = null;
                    $pay = $payment;
                    $interface_type = $pay['interface_type'];
                    if ($interface_type && is_file(APP_ROOT . 'api/payment/' . $interface_type . '/script.php')) {
                        require_once(APP_ROOT . "libary/BasePaymentInterface.php");
                        require_once(APP_ROOT . 'api/payment/' . $interface_type . '/script.php');
                        $interface = new $interface_type();
                        $curOrderPayment = $orderPaymentLogic->getOne('trade_no="' . $trade_no . '"');
                        $form = $interface->getInterfaceForm($curOrderPayment['id']);
                        $result = array(
                            'subtotal' => $order['total_amount'],
                            'payment_fee' => $payment_fee,
                            'payed' => $order['payed'],
                            'amount' => $payment_data['real_currency_amount'],
                            'total' => $order_data['final_amount'],
                            'payment_detail' => $pay['detail'],
                            'form_html' => $form
                        );
                    } else {
                        $result = array(
                            'subtotal' => $order['total_amount'],
                            'payment_fee' => $payment_fee,
                            'payed' => $order['payed'],
                            'amount' => $payment_data['real_currency_amount'],
                            'total' => $order_data['final_amount'],
                            'payment_detail' => $pay['detail'],
                            'form_html' => ''
                        );
                    }
                    echo json_encode($result);
                    exit;
                }
                echo 0;
                exit;
            }
            echo 0;
            exit;
        } else {
            $where = "itemno='" . _g('itemno') . "'";
            $order = $this->orderLogic->getOne($where);
            if (!$order) {
                return $this->showMessage('illegal_parameters', Common::frontURL('home', 'account', 'index'));
            }
            $user_id = $order['user_id'];
            if ($order['payment_status'] == '201') {
                return $this->success('paid_successul_tip', Common::frontURL('home', 'account', 'index'));
            }
            $contryLogic = $this->load('country');
            $countrylist = $contryLogic->getCountries();
            $currency_code = $order['currency_code']; //货币三位符
            $currency_conde = 'standard_code="' . $currency_code . '"';
            $currency = $currencyLogic->getOne($currency_conde);
            $cond = '(language_id=0 or language_id=' . $this->langLogic->language_id . ') and status=1 order by listorder asc';
            $payments = $paymentLogic->findAll($cond);
            $payment_res = array();
            $order_param = array(
                'totalprice' => $this->speChangePrice($order['total_amount'], $currency, TRUE)
            );
            $pay_cond = 'order_id=' . $order['id'] . ' and user_id=' . $user_id . ' and status=0 order by create_time desc';
            $orderPayment = $orderPaymentLogic->getOne($pay_cond);
            $default_payment_id = 0;
            if ($orderPayment) {
                $default_payment_id = $orderPayment['payment_id'];
            }
            $login_user_id = $this->checkLogin();
            if ($login_user_id) {
                $userAddressCountryLogic = $this->load('userAddressCountry');
                $userBillingAddress = array();
                $userBillingAddress = $userAddressCountryLogic->getListByUserId($login_user_id, 1);
                Core::$tpl->set('billingaddresslist', $userBillingAddress);
            }
            $orderAddressLogic = $this->load('orderAddress');
            $orderAddress = $orderAddressLogic->getOne('order_id=' . $order['id']);
            foreach ($countrylist as $key => $value) {
                if ($value['id'] == $orderAddress['country_id']) {
                    $orderAddress['country_name'] = $value['base_name'];
                    break;
                }
            }
            Core::$tpl->set('orderaddress', $orderAddress);
            //导出支付表单
            $flag = TRUE;
            foreach ($payments as $pay) {
                if ($pay['min_order_amount'] > 0 && $order_param['totalprice'] < $pay['min_order_amount']) {
                    continue;
                }
                if ($pay['max_order_amount'] > 0 && $order_param['totalprice'] > $pay['max_order_amount']) {
                    continue;
                }
                $payment_param = $pay['config_param'];
                $payment_formula = $pay['formula'];
                $fee = $paymentLogic->getPaymentFee($order_param, $payment_param, $payment_formula);
                if ($fee !== FALSE) {
                    if ($flag && !$default_payment_id) {
                        $default_payment_id = $pay['id'];
                        $default_payment_is_billing = $pay['is_billing'];
                        $flag = FALSE;
                    }
                    $pay['fee'] = $this->speChangePrice($fee, $currency);
                    $payment_res[] = $pay;
                }
            }
            global $cfg;
            $billing_display = isset($cfg['sites'][0]['billing_display']) ? $cfg['sites'][0]['billing_display'] : 0;
            Core::$tpl->set('billing_display', $billing_display);
            Core::$tpl->set('countrylist', $countrylist);
            Core::$tpl->set('order', $order);
            Core::$tpl->set('payments', $payment_res);
            Core::$tpl->set('currency', $currency);
            Core::$tpl->set('default_payment_id', $default_payment_id);
            Core::$tpl->set('default_payment_is_billing', $default_payment_is_billing);
            Core::$tpl->set('lcoin', $currency['symbol_left']);
            Core::$tpl->set('rcoin', $currency['symbol_right']);
        }
    }

    public function actionSavePayment() {
        $language_id = $this->langLogic->language_id;
        $paymentLogic = $this->load('payment');
        $orderPaymentLogic = $this->load('orderPayment');
        $currencyLogic = $this->load('currency');
        $order_id = Common::queryInt(_p('order_id'));
        $order = $this->orderLogic->getOneById($order_id);
        $billing_address_id = Common::queryInt(_p('billing_address_id'), 0);
        if (!$order) {
            return $this->showMessage('Order_Error', Common::frontURL('home', 'account', 'index'));
        }
        $user_id = $order['user_id'];
        $payment_id = Common::queryInt(_p('payment_id'));
        $payment = $paymentLogic->getOneById($payment_id);
        if (!$payment) {
            return $this->showMessage('Order_Payment_Error', Common::frontURL('home', 'order', 'payment', array('itemno' => $order['itemno'])));
        }
        if ($billing_address_id) {
            $userAddressLogic = $this->load('userAddress');
            $billingaddress = $userAddressLogic->getOneById($billing_address_id);
            if (!$billingaddress || $billingaddress['user_id'] != $user_id || !$billingaddress['country_id']) {
                return array('key' => 'Bill_Address_Error');
            }
        }
        $currency_code = $order['currency_code']; //货币三位符
        $currency_conde = 'standard_code="' . $currency_code . '"';
        $currency = $currencyLogic->getOne($currency_conde);
        $payment_param = $payment['config_param'];
        $payment_formula = $payment['formula'];
        $order_param = array(
            'totalprice' => $this->speChangePrice($order['total_amount'], $currency, TRUE)
        );
        $fee = $paymentLogic->getPaymentFee($order_param, $payment_param, $payment_formula);
        $payment_fee = $fee ? $this->speChangePrice($fee, $currency) : 0;
        $order_data = array(
            'payment_fee' => $payment_fee,
            'final_amount' => $order['total_amount'] + $payment_fee,
        );
        $login_user_id = $this->checkLogin();
        if ($login_user_id == $user_id) {
            $order_data['billing_address_id'] = $billing_address_id;
        }
        $order_res = $this->orderLogic->save($order_data, $order['id']);
        if ($order_res) {
            global $cfg;
            $base_currency_id = $cfg['sites'][0]['base_currency'];
            $trade_no = date('Ymdhsi', time());
            $pay_amount = $order_data['final_amount'] - $order['payed'];
            $payment_data = array(
                'payment_type' => 1,
                'trade_no' => $trade_no,
                'order_id' => $order['id'],
                'user_id' => $user_id,
                'payment_id' => $payment_id,
                'amount' => $this->speChangePrice($pay_amount, $currency, TRUE),
                'base_currency_id' => $base_currency_id,
                'real_currency_id' => $currency['id'],
                'real_currency_amount' => $pay_amount,
                'status' => 0,
                'create_time' => SYS_TIME,
            );
            $orderPaymentLogic->updateByCond($payment_data);
            return $this->_redirect(Common::frontURL('home', 'order', 'payment', array('itemno' => $order['itemno'])));
        } else {
            return $this->showMessage('illegal_parameters', Common::frontURL('home', 'order', 'payment', array('itemno' => $order['itemno'])));
        }
    }

    public function actionGetPayInfo() {

    }

    public function actionPaymentInterface() {
        $orderPaymentLogic = $this->load('orderPayment');
        $PaymentLogic = $this->load('paymentJoinLanguage');
        $trade_no = _g("tradeno");
        $language_id = $this->langLogic->language_id;
        $orderPayment = $orderPaymentLogic->getOne("trade_no='" . $trade_no . "'");
        if (!$orderPayment) {
            return $this->showMessage('illegal_parameters');
        }
        $order = $this->orderLogic->getOneById($orderPayment['order_id']);
        if (!$order) {
            return $this->showMessage('illegal_parameters');
        }
        $Payment = $PaymentLogic->getPaymentById($orderPayment['payment_id'], $language_id);
        $interface_type = $Payment['interface_type'];
        if (is_file(APP_ROOT . 'api/payment/' . $interface_type . '/script.php')) {
            require_once(APP_ROOT . "libary/BasePaymentInterface.php");
            require_once APP_ROOT . 'api/payment/' . $interface_type . '/script.php';
            $interface = new $interface_type();
            $form = $interface->getInterfaceForm($orderPayment['id']);
            $Payment["form_html"] = $form;
        }
        Core::$tpl->set('order', $order);
        Core::$tpl->set('order_payment', $orderPayment);
        Core::$tpl->set('payment', $Payment);
    }

    public function actionPaymentInfo() {
//		$itemno = _g("itemno");
        require_once(APP_ROOT . "libary/BasePayment.php");
    }

    /**
     * 支付回调处理
     * @return type
     */
    public function actionPaymentCallBack() {
        $interface_type = _g("interface");
        if (is_file(APP_ROOT . 'api/payment/' . $interface_type . '/script.php')) {
            require_once(APP_ROOT . "libary/BasePaymentInterface.php");
            require_once APP_ROOT . 'api/payment/' . $interface_type . '/script.php';
            $interface = new $interface_type();
            $orderPayment = $interface->initPost();
            if (!$orderPayment) {
                Common::log('no_order_payment_error');
                return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $interface->orderNo,'msg'=>urlencode($_GET['msg']))));
            }
            if ($orderPayment['completed'] === 1 || $orderPayment['pending'] === 1) {
                $order = $this->orderLogic->getOneById($orderPayment['order_id']);
                return $this->_redirect(Common::frontURL('home', 'order', 'success', array('itemno' => $order['itemno'])));
            }
            //----- 处理回调
            if ($orderPayment["payment_type"] == 1) {
                $order = $this->orderLogic->getOneById($orderPayment['order_id']);
                if (!$order) {
                    //提示没有该订单
                    return $this->notice('no_related_orders');
                } else {
                    //更新订单状态
                    $pstatus = $orderPayment['status'];
                    $final_amount = $order['final_amount'];
                    $payed = $order['payed'];
                    $cur_payed = $payed + $orderPayment['real_currency_amount'];
                    $order_map = Zhtx::createDataMap();
                    if ($cur_payed == $final_amount) {
                        //订单完成支付
                        $order_map->addEntry('payed', $cur_payed, DB::INT);
                        $order_map->addEntry('act_time', SYS_TIME, DB::INT);
                        if ($pstatus == 1) {
                            $order_map->addEntry('order_status', 201, DB::INT);
                            $order_map->addEntry('payment_status', 201, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 201;
                            $order['payment_status'] = 201;
                        } else if ($pstatus == 3) {
                            $order_map->addEntry('order_status', 103, DB::INT);
                            $order_map->addEntry('payment_status', 103, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 103;
                            $order['payment_status'] = 103;
                        }

                        $order_res = $this->orderLogic->updateById($order_map, $orderPayment['order_id']);
                        if ($order_res) {
                            $this->load('orderItem')->updateStock($order['id']);
                            $this->load('goods')->updateBuyCounts($order['id']);
                            EventFactory::orderPayAfter($order);
                            EventFactory::recommendUserFirstPayAfter($order);
                            CreditFactory::orderPayAfter($order);
                            GrowthFactory::orderPayAfter($order);
                            GrowthFactory::recommendUserFirstPayAfter($order);
                            if ($interface->responseResult() == "") {
                                return $this->_redirect(Common::frontURL('home', 'order', 'success', array('itemno' => $order['itemno'])));
                            } else {
                                echo $interface->responseResult();
                                die();
                            }
                        } else {
                            return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $interface->orderNo,'msg'=>urlencode($_GET['msg']))));
                        }
                    } else if ($cur_payed > $final_amount) {
                        //订单付款溢出
                        $order_map->addEntry('payed', $cur_payed, DB::INT);
                        $order_map->addEntry('act_time', SYS_TIME, DB::INT);
                        if ($pstatus == 1) {
                            $order_map->addEntry('order_status', 105, DB::INT);
                            $order_map->addEntry('payment_status', 105, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 105;
                            $order['payment_status'] = 105;
                        } else if ($pstatus == 3) {
                            $order_map->addEntry('order_status', 103, DB::INT);
                            $order_map->addEntry('payment_status', 103, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 103;
                            $order['payment_status'] = 103;
                        }
                        $order_res = $this->orderLogic->updateById($order_map, $orderPayment['order_id']);
                        if ($order_res) {
                            $this->load('orderItem')->updateStock($order['id']);
                            $this->load('goods')->updateBuyCounts($order['id']);
                            EventFactory::orderPayAfter($order);
                            EventFactory::recommendUserFirstPayAfter($order);
                            CreditFactory::orderPayAfter($order);
                            GrowthFactory::orderPayAfter($order);
                            GrowthFactory::recommendUserFirstPayAfter($order);
                        }
                        if ($order_res && $interface->responseResult() == "") {
                            return $this->_redirect(Common::frontURL('home', 'order', 'success', array('itemno' => $order['itemno'])));
                        }
                        if ($interface->responseResult() == "")
                             return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $interface->orderNo,'msg'=>urlencode($_GET['msg']))));;
                    }
                    else if ($cur_payed < $final_amount) {
                        //订单部分付款
                        $order_map->addEntry('payed', $cur_payed, DB::INT);
                        $order_map->addEntry('act_time', SYS_TIME, DB::INT);
                        if ($pstatus == 1) {
                            $order_map->addEntry('order_status', 104, DB::INT);
                            $order_map->addEntry('payment_status', 104, DB::INT);
                        } else if ($pstatus == 3) {
                            $order_map->addEntry('order_status', 103, DB::INT);
                            $order_map->addEntry('payment_status', 103, DB::INT);
                        }
                        $order_res = $this->orderLogic->updateById($order_map, $orderPayment['order_id']);
                        if ($order_res && $interface->responseResult() == "") {
                            return $this->_redirect(Common::frontURL('home', 'order', 'success', array('itemno' => $order['itemno'])));
                        }
                        if ($interface->responseResult() == "")
                             return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $interface->orderNo,'msg'=>urlencode($_GET['msg']))));
                    }
                }
            }
            else if ($orderPayment["payment_type"] == 2) {

            }
            //------ 订单日志
//			$orderLogMap = $interface->getOrderLogMap();
            //------ 回调
            //echo $interface->responseResult();
            //die();
//			print_r($orderPaymentMap);
//			print_r($orderLogMap);
        }
    }

    /**
     * 获取配送方式
     */
    public function actionShippingInfo() {
        $country_id = _g('country_id');
        if (!$this->load('country')->getCount('id=' . $country_id . ' and status=1')) {
            echo 0;
            return;
        }
        $areaCountryRelLogic = $this->load('shippingAreaCountryRel');
        $shippingJoinLangLogic = $this->load('shippingJoinLanguage');
        $shippingLogic = $this->load('shipping');
        $language_id = $this->langLogic->language_id;
        $user_id = $this->checkLogin();
        $product_promotion = array();
        $cart_promotion = 0;
        if (_s('product_promotion')) {
            foreach (json_decode(_s('product_promotion')) as $key => $value) {
                $product_promotion[$key] = $value;
            }
        }
        if (_s('cart_promotion')) {
            $cart_promotion = _s('cart_promotion');
        }
        $area_ids = $areaCountryRelLogic->getListByCountryId($country_id);
        $shipping = array();
        if (!empty($area_ids)) {
            $shipping = $shippingJoinLangLogic->getShippingByAreaIds($area_ids, $language_id);
        }
        $cartInfo = $this->cartJoinSkuLogic->getCartInfo($user_id, $language_id);
        if($_GET['dev'])
        {
            var_dump($cartInfo);
        }
        $cart_param = array(
            'totalweight' => $cartInfo['totalweight'],
            'totalprice' => isset($cartInfo['subtotalprice']) ? $this->toolPrice($cartInfo['subtotalprice'], TRUE) : $this->toolPrice($cartInfo['totalprice'], TRUE),
            'totalnumber' => $cartInfo['totalqty'],
            'totalvweight' => 0,
        );
        $order_goods_ids = array();
        $order_goods_qtys = array();
        $order_goods_sku_ids = array();
        foreach ($cartInfo['orderitems'] as $item) {

            $order_goods_ids[] = $item['goods_id'];
            $order_goods_qtys[$item['goods_id']] = isset($order_goods_qtys[$item['goods_id']]) ? $order_goods_qtys[$item['goods_id']] + $item['qty'] : $item['qty'];
            $order_goods_sku_ids[] = $item['sku_id'];
            $order_sku_qtys[$item['sku_id']] = $item['qty'];
        }
        $free_shipping = $this->load('SpecialOfferShippingJoinGoods')->getShippingInfo($order_goods_ids, $order_sku_qtys, $order_goods_sku_ids);
        $result = array();
        $corp_ids = array();
        $shippingCorp = array();
        foreach ($shipping as $key => $value) {
            $cart_param['totalweight'] = $cartInfo['totalweight'];
            $cart_param['totalnumber'] = $cartInfo['totalqty'];
            $cart_param['totalprice'] = $cartInfo['totalprice'];
            //免运费处理
            if (isset($free_shipping[$value['id']])) {
                if ($free_shipping[$value['id']]['free_shipping_type'] == 1) {
                    $cart_param['totalweight'] = 0;
                    //$cart_param['totalprice'] = 0;
                    $cart_param['totalnumber'] = 0;
                    $res = 0;
                } else {
                    $cart_param['totalweight'] = $cartInfo['totalweight'] - $free_shipping[$value['id']]['weight'];
                    //$cart_param['totalprice'] = $cartInfo['totalprice'] - $free_shipping[$value['id']]['price'];
                    $cart_param['totalnumber'] = $cartInfo['totalqty'] - $free_shipping[$value['id']]['num'];
                    $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
                }
            } else {
                $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
            }
            if ($res !== FALSE) {
                $result[$key] = array(
                    'id' => $value['id'],
                    'base_name' => $value['base_name'] ? $value['base_name'] : $value['default_base_name'],
                    'price' => !$cartInfo['free_ship'] ? $this->toolPrice($res) : 0,
                    'weight' => $cartInfo['totalweight'],
                    'freeweight' => $free_shipping[$value['id']]['weight'],
                    'shipping_corp_id' => $value['shipping_corp_id'],
                    'detail' => $value['detail'],
                );
                $corp_ids[$value['shipping_corp_id']] = $value['shipping_corp_id'];
            }
        }
        if (!empty($corp_ids)) {
            $shippingCorpLogic = $this->load('shippingCorp');
            $cond = 'id in (' . implode(',', $corp_ids) . ')';
            $shippingCorp = $shippingCorpLogic->findAll($cond, TRUE);
        }
        $return = array();
        foreach ($result as $key => $item) {

            $corp = isset($shippingCorp[$item['shipping_corp_id']]) ? $shippingCorp[$item['shipping_corp_id']] : '';
            $item['image'] = isset($corp['image']) ? $corp['image'] : '';
            $item['corp_base_name'] = isset($corp['base_name']) ? $corp['base_name'] : '';
            $item['corp_href'] = isset($corp['href']) ? $corp['href'] : '';
            $return[$key] = $item;
        }
//        var_dump($cartInfo);
//        var_dump($return);
//            var_dump($cart_param);
//            _debug($free_shipping);
        echo json_encode($return);
    }

    /**
     *  支付成功展示
     * @return type
     */
    public function actionSuccess() {
        $itemno = _g('itemno');
        if (_s($itemno . '_paid_success')) {
            return $this->_redirect('/');
        }
        $order = $this->orderLogic->getOne('itemno="' . $itemno . '"');
        if (!$order) {
            return $this->notice('illegal_parameters');
        }
        _setSession($itemno . '_paid_success', 1);
        $this->cleanUserSource();
        $this->cleanSource();
        Core::$tpl->set('order', $order);
        Core::$htmlFile = 'order/success';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 支付失败提醒
     * @return type
     */
    public function actionFailure() {
        $itemno = _g('itemno');
        $order = $this->orderLogic->getOne('itemno="' . $itemno . '"');
        if (!$order) {
            return $this->notice('illegal_parameters');
        }
        $this->cleanUserSource();
        $this->cleanSource();
        Core::$tpl->set('order', $order);
        Core::$htmlFile = 'order/failure';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 获取当前用户积分的信息
     * @param type $shipping_id 配送方式ID
     * @return boolean
     */
    public function getCreditInfo($shipping_id, $payment_id = 0, $insurance_fee_selected = false, $credits_value_amount = 0) {
        $shippingLogic = $this->load('shipping');
        $cartInfo = $this->cartJoinSkuLogic->getCartInfo($this->user_id, $this->language_id, FALSE);
        $shipping = $shippingLogic->getOneById($shipping_id);
        if (!$shipping_id || !$shipping) {
            return false;
        }
        $shipping_fee = 0;
        if (!$cartInfo['free_ship']) {
            $cart_param = array(
                'totalweight' => $cartInfo['totalweight'],
                'totalprice' => isset($cartInfo['subtotalprice']) ? $cartInfo['subtotalprice'] : $cartInfo['totalprice'],
                'totalnumber' => $cartInfo['totalqty'],
                'totalvweight' => 0,
            );
            $order_goods_ids = array();
            $order_goods_qtys = array();
            $order_goods_sku_ids = array();
            //运费险
            $orderSum = 0;
            foreach ($cartInfo['orderitems'] as $item) {
                $order_goods_ids[] = $item['goods_id'];
                $order_goods_qtys[$item['goods_id']] = isset($order_goods_qtys[$item['goods_id']]) ? $order_goods_qtys[$item['goods_id']] + $item['qty'] : $item['qty'];
                $order_goods_sku_ids[] = $item['sku_id'];
                $order_sku_qtys[$item['sku_id']] = $item['qty'];
                $orderSum+=$item['qty'];
            }
            $free_shipping = $this->load('SpecialOfferShippingJoinGoods')->getShippingInfo($order_goods_ids, $order_sku_qtys, $order_goods_sku_ids);
            if (isset($free_shipping[$shipping_id])) {
                if ($free_shipping[$shipping_id]['free_shipping_type'] == 1) {
                    $cart_param['totalweight'] = 0;
                    $cart_param['totalnumber'] = 0;
                    $cost = 0;
                } else {
                    $cart_param['totalweight'] = $cartInfo['totalweight'] - $free_shipping[$shipping_id]['weight'];
                    $cart_param['totalnumber'] = $cartInfo['totalqty'] - $free_shipping[$shipping_id]['num'];
                    $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
                }
            } else {
                $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
            }
            if ($cost === FALSE) {
                return array('key' => 'Cost_Error');
            }
            $shipping_fee = $this->toolPrice($cost);
        }
        $user = $this->load('user')->getOneById($this->user_id);
        $creditSettingLogic = $this->load('creditSetting');
        $creditInfo = $creditSettingLogic->getCreditInfo($user['credit'], $cartInfo['subtotalprice'], $cartInfo['subtotalprice'] + $shipping_fee);
        //运费险
        $insuranceLogic = $this->load('InsuranceJoinLanguage');
        $insurance = $insuranceLogic->getConfig($this->language_id);
        $insurance_param = array(
            'order_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE) + $this->toolPrice($shipping_fee, TRUE),
            'goods_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE),
            'shipping_fee' => $this->toolPrice($shipping_fee, TRUE),
            'orderSum' => $orderSum,
        );
        $insurance_fee = $insuranceLogic->getCost($insurance_param, $insurance['formula_param'], $insurance['formula']);
        $payment_fee = 0;
        $minus_credits_value_amount = 0;
        if ($payment_id) {
            $paymentLogic = $this->load('payment');
            $cond = '(language_id=0 or language_id=' . $this->language_id . ') and status=1 and id=' . $payment_id . ' order by listorder asc';
            $payment = $paymentLogic->getOne($cond);
            if ($payment) {
                $temptotalprice = $cartInfo['subtotalprice'] + $shipping_fee;
                if ($insurance_fee_selected) {
                    $temptotalprice += $this->toolPrice($insurance_fee);
                }
                //积分抵用费用
                if ($credits_value_amount) {
                    $temptotalprice -= $this->toolPrice($credits_value_amount);
                }
                $order_param = array(
                    'totalprice' => $this->toolPrice($temptotalprice, TRUE)
                );
                $fee = $paymentLogic->getPaymentFee($order_param, $payment['config_param'], $payment['formula']);
                if ($fee) {
                    $payment_fee = $fee;
                } else {
                    $payment_fee = 0;
                }
            } else {
                $payment_fee = 0;
            }
            $payment_fee = $this->toolPrice($payment_fee);
        }
        if (!$payment_fee)
            $minus_credits_value_amount = $credits_value_amount;

        $return = array(
            'shipping_fee' => $shipping_fee,
            'payment_fee' => $payment_fee,
            'total_credit' => $user['credit'],
            'max_exp_credit' => $creditInfo ? $creditInfo['max_exp_credit'] : 0,
            'payment_amount' => $cartInfo['subtotalprice'] + $shipping_fee + $payment_fee - $minus_credits_value_amount,
            'exchange_credit_scale' => $creditInfo ? $creditInfo['exchange_credit_scale'] : 1,
            'insurance_fee' => $this->toolPrice($insurance_fee),
            'insurance_default' => $insurance['is_default'],
            'is_spec' => $creditInfo['is_spec'],
        );
        return $return;
    }

    /* 统一域名支付跳转 */

    public function actionRedirectPay() {
        $pay_url = _p('pay_url');
        Core::$tpl->set('pay_url', $pay_url);
        Core::$tpl->set('params', _p());
    }

    /**
     * paypal快捷支付
     */
    public function actionECPay() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $interface = $this->getECApiInfo();
        $_setting = $interface->_setting;
        if (!$_setting) {
            return $this->showMessage('website_not_payment');
        }

        global $cfg, $current_currency;
        $user_id = $this->checkLogin();
        $language_id = $this->language_id;
        $product_promotion = json_decode(_s('product_promotion'), TRUE);
        $promotion_gift = json_decode(_s('gift_promotion'), TRUE);
        $cart_promotion = Common::queryInt(_s('cart_promotion'));
        $cart_counpon = _s('cart_coupon');
        $cartInfo = $this->cartJoinSkuLogic->getCartPrice($user_id, $product_promotion, $promotion_gift, $language_id, $cart_promotion, $cart_counpon);
        if (Common::toolPrice($cfg['sites'][0]['moq']) > $cartInfo['subtotalprice']) {
            Common::alertRedirect(str_replace("{0}", _s("symbol_left") . ' ' . Common::toolPrice($cfg['sites'][0]['moq']), $lang['moq_notics']), 'shopcart.html');
        }
        if (!$cartInfo || !$cartInfo['totalqty']) {
            return $this->showMessage('cart_is_empty');
        }
        if ($cartInfo['subtotalprice'] < $_setting['min_order_amount'] && $_setting['min_order_amount'] != 0) {
            return $this->showMessage('price_range_error');
        }
        if ($cartInfo['subtotalprice'] > $_setting['max_order_amount'] && $_setting['max_order_amount'] != 0) {
            return $this->showMessage('price_range_error');
        }
        $data = array(
            'L_NAME0' => $_SERVER['SERVER_NAME'] . ' Purchase (Does not include shipping costs)',
            'L_AMT0' => (string) round($cartInfo['subtotalprice'], 2),
            'L_QTY0' => 1,
            'CURRENCYCODE' => strtoupper($current_currency['standard_code']),
            'INSURANCEAMT' => 0.0,
            'MAXAMT' => (string) round($cartInfo['subtotalprice'], 2),
            'AMT' => (string) round($cartInfo['subtotalprice'], 2),
        );
        $http_url = SITE_PROTOCOL . SITE_URL;
        $returnURL = urlencode($http_url . $_setting['returnurl'] . '?currencyCodeType=' . $current_currency['standard_code'] . '&paymentType=' . $_setting['paymentType']);
        $cancelURL = urlencode($http_url . $_setting['cancelurl'] . '?paymentType=' . $_setting['paymentType']);
        $data['ReturnUrl'] = $returnURL;
        $data['CANCELURL'] = $cancelURL;
        $data['PAYMENTACTION'] = $_setting['paymentType'];
//       _debug($data);
        $resArray = $interface->ecpay($data);

        if (strtoupper($resArray['ACK']) == "SUCCESS") {

            $payPalURL = $_setting['PAYPAL_URL'] . urldecode($resArray["TOKEN"]);

            header("Location: " . $payPalURL);
        } else {
            _debug($resArray);
        }
    }

    /**
     * 快捷支付回传
     * 如果用户已登录 注册用户地址 计算运费
     * 如果用户未登录  注册用户及地址 计算运费
     */
    public function actionECStep2() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $token = urlencode(_g('token'));
        $payerId = _g('PayerID');
        $get_address_id = (int) _g('address_id');
        if ($get_address_id || ($token && $payerId)) {

            _setSession('token', _g('token'));
            _setSession('payer_id', _g('PayerID'));
            $interface = $this->getECApiInfo();
            $_setting = $interface->_setting;
            if (!$_setting) {
                return $this->showMessage('website_not_payment');
            }
            $resArray = $interface->ectokenpay($token);   //    取客户paypal信息.

            if (strtoupper($resArray['ACK']) == "SUCCESS" || strtoupper($resArray['ACK']) == "SUCCESSWITHWARNING") {
                $country_code = $resArray['PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE'];
                $email = $resArray['EMAIL'];
                $user_id = $this->checkLogin();
                if (!$user_id) {
                    $userLogic = $this->load('user');
                    $user = $userLogic->register($email);
                    $user_id = $user ? $user['id'] : 0;
                }
                $contryLogic = $this->load('country');
                $countrylist = $contryLogic->getAll('status=1');
                $country = array();
                foreach ($countrylist as $list) {
                    if ($list['country_code_2'] == $country_code || $list['country_code_3'] == $country_code) {
                        $country = $list;
                        break;
                    }
                }
                if (!$country) {
                    return $this->showMessage('address_not_delivery');
                }
                $country_id = $country['id'];
                /*
                  $shipping_address = array(
                  'first_name' => $resArray['FIRSTNAME'],
                  'last_name' => $resArray['LASTNAME'],
                  'state' => $resArray['SHIPTOSTATE'],
                  'city' => $resArray['SHIPTOCITY'],
                  'postcode' => $resArray['SHIPTOZIP'],
                  'email' => $resArray['EMAIL'],
                  'address' => $resArray['SHIPTOSTREET'],
                  'mobilephone' => $resArray['PHONENUM'],
                  'country_id' => $country_id,
                  'user_id' => $user_id,
                  );
                 */
//						print_r($resArray);
//						die();
                $shipping_address = array(
                    'first_name' => $resArray['PAYMENTREQUEST_0_SHIPTONAME'],
                    'last_name' => ' ',
                    'state' => $resArray['PAYMENTREQUEST_0_SHIPTOSTATE'],
                    'city' => $resArray['PAYMENTREQUEST_0_SHIPTOCITY'],
                    'postcode' => $resArray['PAYMENTREQUEST_0_SHIPTOZIP'],
                    'email' => $resArray['EMAIL'],
                    'address' => $resArray['PAYMENTREQUEST_0_SHIPTOSTREET'],
                    'mobilephone' => $resArray['PHONENUM'],
                    'country_id' => $country_id,
                    'user_id' => $user_id,
                );
                $hasempty = 0;
                foreach ($shipping_address as $key => $value) {
                    if ($value == "") {
                        $hasempty = 1;
                    }
                }


                if (!$get_address_id) {
                    $addressLogic = $this->load('userAddress');
                    $addr_cond = 'user_id=' . (int) $user_id;
                    foreach ($shipping_address as $skey => $sv) {
                        $addr_cond .= ' and ' . $skey . "='" . $sv . "'";
                    }
                    $exist_address = $addressLogic->getOne($addr_cond);
                    $address_id = 0;
                    if ($exist_address) {
                        $address_id = $exist_address['id'];
                    } else {
                        $address_id = $addressLogic->saveByCond($shipping_address);
                    }

                    if ($hasempty && $address_id) {
                        $ref = explode("?", $_SERVER['REQUEST_URI']);
                        $enref = urlencode($ref[1]);
                        Common::alertRedirect($lang['edit_paypal_ecstep_again'], "/h-account-editAddress.html?id={$address_id}&do=ecstep2&ref={$enref}");
                    }
                    if ($address_id) {
                        $shipping_address['id'] = $address_id;
                        $shipping_address['country_name'] = $country['base_name'];
                    }
                } else {
                    $shipping_address = $this->load('userAddress')->getOne("id = '{$get_address_id}' and user_id=" . (int) $user_id);
                    $shipping_address['country_name'] = $country['base_name'];
                    if (!$shipping_address['country_id'] || !$shipping_address['state'] || !$shipping_address['city'] || !$shipping_address['postcode'] || !$shipping_address['address'] || !$shipping_address['mobilephone']) {
                        $ref = explode("?", $_SERVER['REQUEST_URI']);
                        $enref = urlencode($ref[1]);
                        Common::alertRedirect($lang['edit_paypal_ecstep_again'], "/h-account-editAddress.html?id={$get_address_id}&do=ecstep2&ref={$enref}");
                    }
                }
            }

            $language_id = $this->language_id;
            $cartInfo = $this->cartJoinSkuLogic->getCartInfo($user_id, $language_id);

            if (count($cartInfo['orderitems']) <= 0) {
                return $this->_redirect(Common::frontURL('home', 'cart', 'list'));
            }
            foreach ($cartInfo['orderitems'] as $key => $value) {
                if ($value['stock_nums'] == '' || $value['stock_nums'] <= 0) {
                    Common::alertRedirect($lang['cart_out_of_stock'], Common::frontURL('home', 'cart', 'list'));
                }
            }

            $areaCountryRelLogic = $this->load('shippingAreaCountryRel');
            $shippingJoinLangLogic = $this->load('shippingJoinLanguage');
            $shippingLogic = $this->load('shipping');
            $area_ids = $areaCountryRelLogic->getListByCountryId($country_id);
            $shipping = array();
            if (!empty($area_ids)) {
                $shipping = $shippingJoinLangLogic->getShippingByAreaIds($area_ids, $language_id);
            }
            $cart_param = array(
                'totalweight' => $cartInfo['totalweight'],
                'totalprice' => isset($cartInfo['subtotalprice']) ? $this->toolPrice($cartInfo['subtotalprice'], TRUE) : $this->toolPrice($cartInfo['totalprice'], TRUE),
                'totalnumber' => $cartInfo['totalqty'],
                'totalvweight' => 0,
            );
            $result = array();
            $corp_ids = array();
            $shippingCorp = array();
            foreach ($shipping as $value) {
                $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
                if ($res !== FALSE) {
                    $result[$value['id']] = array(
                        'id' => $value['id'],
                        'base_name' => $value['base_name'] ? $value['base_name'] : $value['default_base_name'],
                        'price' => !$cartInfo['free_ship'] ? $this->toolPrice($res) : 0,
                        'shipping_corp_id' => $value['shipping_corp_id'],
                        'detail' => $value['detail'],
                    );
                    $corp_ids[$value['shipping_corp_id']] = $value['shipping_corp_id'];
                }
            }
            if (!empty($corp_ids)) {
                $shippingCorpLogic = $this->load('shippingCorp');
                $cond = 'id in (' . implode(',', $corp_ids) . ')';
                $shippingCorp = $shippingCorpLogic->findAll($cond, TRUE);
            }
            $return = array();
            foreach ($result as $key => $item) {
                $corp = isset($shippingCorp[$item['shipping_corp_id']]) ? $shippingCorp[$item['shipping_corp_id']] : '';
                $item['image'] = isset($corp['image']) ? $corp['image'] : '';
                $item['corp_base_name'] = isset($corp['base_name']) ? $corp['base_name'] : '';
                $item['corp_href'] = isset($corp['href']) ? $corp['href'] : '';
                $return[$key] = $item;
            }
            $this->load('creditDetail')->checkCredit(); //检测及清理过期积分
            $creditSetting = $this->creditSettingLogic->getOne();
            global $cfg;
            $billing_display = isset($cfg['sites'][0]['billing_display']) ? $cfg['sites'][0]['billing_display'] : 0;
            //根据sku_code查询sku的codeno
            $skuLogic = $this->load('sku');
            foreach ($cartInfo['orderitems'] as $key => $value) {
                if ($value['sku_code'] && $value['goods_id']) {
                    $sku = $skuLogic->getOne('goods_id=' . $value['goods_id'] . ' and sku_code="' . $value['sku_code'] . '"');
                    if ($sku['codeno']) {
                        $cartInfo['orderitems'][$key]['sku_codeno'] = $sku['codeno'];
                    } else {
                        $cartInfo['orderitems'][$key]['sku_codeno'] = '';
                    }
                } else {
                    $cartInfo['orderitems'][$key]['sku_codeno'] = '';
                }
            }
            Core::$tpl->set('billing_display', $billing_display);
            Core::$tpl->set('creditSetting', $creditSetting);
            Core::$tpl->set('countrylist', $countrylist);
            Core::$tpl->set('orderitems', $cartInfo['orderitems']);
            Core::$tpl->set('address', $shipping_address);
            Core::$tpl->set('cart_save', $cartInfo['cart_save'] + $cartInfo['offer_save']);
            Core::$tpl->set('final_qty', $cartInfo['final_qty']);
            Core::$tpl->set('totalprice', $cartInfo['totalprice']);
            Core::$tpl->set('productprice', $cartInfo['subtotalprice'] + $cartInfo['cart_save'] + $cartInfo['offer_save']);
            Core::$tpl->set('subtotalprice', $cartInfo['subtotalprice']);
            Core::$tpl->set('cart_gift', $cartInfo['cart_gift']);
            Core::$tpl->set('shippings', $return);

            Core::$htmlFile = 'order/ecstep2';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
//          $cache=$this->process_to_order($resArray);
//        }
//        else
//        {
////          $this->sapierror($resArray);
//            _debug($resArray);
//        }
        } else {
            return $this->showMessage('illegal_parameters');
        }
    }

    public function actionEcPayment() {
        ini_set('session.bug_compat_42', 0);
        ini_set('session.bug_compat_warn', 0);
        $params = array(
            'address_id' => Common::queryInt(_p('shipping_address')),
            'shipping_id' => Common::queryInt(_p('shipping_id')),
            'payment_id' => Common::queryInt(_p('payment_id')),
            'order_remark' => Common::strEscape(strip_tags(_p('order_remark'))),
            'use_credit' => _p('use_credit'),
            'insurance' => _p('insurance'),
        );
        $order = $this->insertOrder($params);
        if ($order['key']) {
            return $this->showMessage($order['key']);
        } else {
            global $cfg;
            $apiInfo = $this->getECApiInfo();
            $_setting = $apiInfo->_setting;
            $orderPaymentLogic = $this->load('orderPayment');
            $currencyLogic = $this->load('currency');
            $base_currency_id = $cfg['sites'][0]['base_currency'];
            $trade_no = date('Ymdhsi', time());
            $pay_amount = $order['final_amount'] - $order['payed'];
            $currency_code = $order['currency_code']; //货币三位符
            $currency_cond = 'standard_code="' . $currency_code . '"';
            $currency = $currencyLogic->getOne($currency_cond);

            $orderPaymentRes = $orderPaymentLogic->getOne('order_id=' . $order['id']);
            $trade_no = $orderPaymentRes['trade_no'];
            if ($trade_no) {
                $token = urlencode($_SESSION['token']);
                $paymentType = $_setting['paymentType'];
                $currCodeType = $currency['standard_code'];
                $payerID = urlencode($_SESSION['payer_id']);
                $serverName = urlencode($_SERVER['SERVER_NAME']);
                $nvpstr = '&TOKEN=' . $token . '&PAYERID=' . $payerID . '&PAYMENTACTION=' . $paymentType . '&AMT=' . $pay_amount . '&CURRENCYCODE=' . $currCodeType . '&IPADDRESS=' . $serverName . '&INVNUM=' . $order['itemno'] . '&DESC=' . $order['itemno'];

                $resArray = $apiInfo->ecPayment($nvpstr);
                $ack = strtoupper($resArray["ACK"]);
                if ($ack != 'SUCCESS' && $ack != 'SUCCESSWITHWARNING') {
                    // $_SESSION['reshash'] = $resArray;
                    return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $order['itemno'])));
                }
                $pay_no = $resArray["TRANSACTIONID"];
                $pay_status = $resArray["PAYMENTSTATUS"];
                $cpay_amount = $resArray["AMT"];
                $cpay_currency_code = $resArray["CURRENCYCODE"];
                $cur_payed = $order['payed'] + $cpay_amount;
                $pstatus = 0;
                $cond = 'trade_no= "' . $trade_no . '"';

                if (strtolower($pay_status) == 'completed') {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('status', 1, DB::INT);
                    $map->addEntry('pay_method_no', $pay_no, DB::VARCHAR);
                    $pay_res = $orderPaymentLogic->update($map, $cond);
                    if ($pay_res) {
                        $pstatus = 1;
                    }
                }

                $final_amount = $order['final_amount'];
                $order_map = Zhtx::createDataMap();
                if ($pstatus > 0) {
                    if ((int) $cur_payed == (int) $final_amount) {
                        //订单完成支付
                        $order_map->addEntry('payed', $cur_payed, DB::INT);
                        $order_map->addEntry('act_time', SYS_TIME, DB::INT);
                        if ($pstatus == 1) {
                            $order_map->addEntry('order_status', 201, DB::INT);
                            $order_map->addEntry('payment_status', 201, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 201;
                            $order['payment_status'] = 201;
                        } else if ($pstatus == 3) {
                            $order_map->addEntry('order_status', 103, DB::INT);
                            $order_map->addEntry('payment_status', 103, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 103;
                            $order['payment_status'] = 103;
                        }

                        $order_res = $this->orderLogic->updateById($order_map, $order['id']);
                        if ($order_res) {
                            //更新库存
                            $this->load('orderItem')->updateStock($order['id']);
                            $this->load('goods')->updateBuyCounts($order['id']);
                            EventFactory::orderPayAfter($order);
                            EventFactory::recommendUserFirstPayAfter($order);
                            CreditFactory::orderPayAfter($order);
                            GrowthFactory::orderPayAfter($order);
                            GrowthFactory::recommendUserFirstPayAfter($order);
                            return $this->_redirect(Common::frontURL('home', 'order', 'success', array('itemno' => $order['itemno'])));
                        }
                        return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $order['itemno'])));
                    } else if ((int) $cur_payed > (int) $final_amount) {
                        //订单付款溢出
                        $order_map->addEntry('payed', $cur_payed, DB::INT);
                        $order_map->addEntry('act_time', SYS_TIME, DB::INT);
                        if ($pstatus == 1) {
                            $order_map->addEntry('order_status', 105, DB::INT);
                            $order_map->addEntry('payment_status', 105, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 105;
                            $order['payment_status'] = 105;
                        } else if ($pstatus == 3) {
                            $order_map->addEntry('order_status', 103, DB::INT);
                            $order_map->addEntry('payment_status', 103, DB::INT);
                            $order['payed'] = $cur_payed;
                            $order['order_status'] = 103;
                            $order['payment_status'] = 103;
                        }
                        $order_res = $this->orderLogic->updateById($order_map, $order['id']);
                        if ($order_res) {
                            //更新库存
                            $this->load('orderItem')->updateStock($order['id']);
                            $this->load('goods')->updateBuyCounts($order['id']);
                            EventFactory::orderPayAfter($order);
                            EventFactory::recommendUserFirstPayAfter($order);
                            CreditFactory::orderPayAfter($order);
                            GrowthFactory::orderPayAfter($order);
                            GrowthFactory::recommendUserFirstPayAfter($order);
                            return $this->_redirect(Common::frontURL('home', 'order', 'success', array('itemno' => $order['itemno'])));
                        }
                        return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $order['itemno'])));
                    }
                }
            }
            return $this->_redirect(Common::frontURL('home', 'order', 'failure', array('itemno' => $order['itemno'])));
        }
    }

    public function actionApierror() {
        echo 'sorry payment error';
    }

    public function actionECCancel() {
//      echo 'sorry payment error';
        return $this->_redirect(Common::frontURL('home', 'cart', 'list'));
    }

    /**
     *  获取快捷支付的配置对象
     */
    public function getECApiInfo() {
        $paymentLogic = $this->load('payment');
        $payment = $paymentLogic->getOne("interface_type='paypal' and (language_id=0 or language_id=" . $this->language_id . ')');
        if (!$payment) {
            return FALSE;
        }
        $config_param = json_decode($payment['config_param'], true);
        if (!$config_param['exp_express_checkout'] || !$config_param['exp_api_username'] || !$config_param['exp_api_password'] || !$config_param['exp_api_sign']) {
            return FALSE;
        }
        $interface = NULL;
        if (is_file(APP_ROOT . 'api/payment/paypal/ecpaypal.php')) {
            require_once(APP_ROOT . "libary/BasePaymentInterface.php");
            require_once APP_ROOT . 'api/payment/paypal/ecpaypal.php';
            $interface = new ecpaypal();
            $interface->_setting['API_USERNAME'] = $config_param['exp_api_username'];
            $interface->_setting['API_PASSWORD'] = $config_param['exp_api_password'];
            $interface->_setting['API_SIGNATURE'] = $config_param['exp_api_sign'];
            $interface->_setting['payment_id'] = $payment['id'];
            $interface->_setting['min_order_amount'] = $payment['min_order_amount'];
            $interface->_setting['max_order_amount'] = $payment['max_order_amount'];
        }
        return $interface;
    }

    public function insertOrder($params) {
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $user_id = $this->user_id;
        if (!$user_id) {
            return array('key' => 'User_Error');
        }
        $userAddressLogic = $this->load('userAddress');
        $shippingLogic = $this->load('shipping');
        $address_id = $params['address_id'];
        $shipping_id = $params['shipping_id'];
        $payment_id = $params['payment_id'];
        $order_remark = $params['order_remark'];
        $billing_address_id = $params['billing_address_id'];
        $shippingaddrasbillingaddr = $params['shippingaddrasbillingaddr'];
        $address = $userAddressLogic->getOneById($address_id);
        if (!$address_id || !$address || $address['user_id'] != $user_id || !$address['country_id']) {
            return array('key' => 'Address_Error');
        }
        if ($billing_address_id) {
            $billingaddress = $userAddressLogic->getOneById($billing_address_id);
            if (!$billingaddress || $billingaddress['user_id'] != $user_id || !$billingaddress['country_id']) {
                return array('key' => 'Bill_Address_Error');
            }
        }
        if ($shippingaddrasbillingaddr) {
            $billing_address_id = $address_id;
        }
        $shipping = $shippingLogic->getOneById($shipping_id);
        if (!$shipping_id || !$shipping) {
            return array('key' => 'Shipping_Error');
        }
        $language_id = $this->language_id;
        $cartInfo = $this->cartJoinSkuLogic->getCartInfo($user_id, $language_id, false);
        if (count($cartInfo['orderitems']) == 0 || count($cartInfo['orderitems']) < 0) {
            return array('key' => 'Cart_Empty');
        }
        foreach ($cartInfo['orderitems'] as $key => $value) {
            if ($value['stock_nums'] == '' || $value['stock_nums'] <= 0) {
                return array('key' => 'Cart_Sku_Error');
            }
        }

        $shipping_fee = 0;
        if (!$cartInfo['free_ship']) {
            $cart_param = array(
                'totalweight' => $cartInfo['totalweight'],
                'totalprice' => isset($cartInfo['subtotalprice']) ? $cartInfo['subtotalprice'] : $cartInfo['totalprice'],
                'totalnumber' => $cartInfo['totalqty'],
                'totalvweight' => 0,
            );
            $order_goods_ids = array();
            $order_goods_qtys = array();
            $order_goods_sku_ids = array();
            $orderSum = 0;
            foreach ($cartInfo['orderitems'] as $item) {

                $order_goods_ids[] = $item['goods_id'];
                $order_goods_qtys[$item['goods_id']] = isset($order_goods_qtys[$item['goods_id']]) ? $order_goods_qtys[$item['goods_id']] + $item['qty'] : $item['qty'];
                $order_goods_sku_ids[] = $item['sku_id'];
                $order_sku_qtys[$item['sku_id']] = $item['qty'];
                $orderSum+=$item['qty'];
            }
            $free_shipping = $this->load('SpecialOfferShippingJoinGoods')->getShippingInfo($order_goods_ids, $order_sku_qtys, $order_goods_sku_ids);

            if (isset($free_shipping[$shipping_id])) {
                if ($free_shipping[$shipping_id]['free_shipping_type'] == 1) {
                    $cart_param['totalweight'] = 0;
                    $cart_param['totalnumber'] = 0;
                    $cost = 0;
                } else {
                    $cart_param['totalweight'] = $cartInfo['totalweight'] - $free_shipping[$shipping_id]['weight'];
                    $cart_param['totalnumber'] = $cartInfo['totalqty'] - $free_shipping[$shipping_id]['num'];
                    $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
                }
            } else {
                $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
            }
            if ($cost === FALSE) {
                return array('key' => 'Cost_Error');
            }
            $shipping_fee = $this->toolPrice($cost);
        }
        global $current_currency;
        $ipJoinCountryLogic = $this->load('ipJoinCountry');
        $ip = Common::_ip2long(Common::ip());
        $domain = SITE_URL;
        $country_id = $ipJoinCountryLogic->getCountryId($ip);
        $order_itemno = date('ymdhsi');
        $insurance_fee = 0;
        if (_p('insurance')) {
            //运费险
            $insuranceLogic = $this->load('InsuranceJoinLanguage');
            $insurance = $insuranceLogic->getConfig($this->language_id);
            $insurance_param = array(
                'order_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE) + $this->toolPrice($shipping_fee, TRUE),
                'goods_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE),
                'shipping_fee' => $this->toolPrice($shipping_fee, TRUE),
                'orderSum' => $orderSum,
            );
            $insurance_fee = $insuranceLogic->getCost($insurance_param, $insurance['formula_param'], $insurance['formula']);
            $insurance_fee = $this->toolPrice($insurance_fee);
        }
        //积分处理
        $exp_amout = 0;
        $use_credit = 0;
        if ($params['use_credit']) {
            if (!is_numeric($params['use_credit'])) {
                return array('key' => 'use_credit_illegal_characters');
            }
            $use_credit = Common::queryInt($params['use_credit']);
            $user = $this->load('user')->getOneById($user_id);
            $creditSettingLogic = $this->load('creditSetting');
            $creditInfo = $creditSettingLogic->getCreditInfo($user['credit'], $cartInfo['subtotalprice'], $cartInfo['subtotalprice'] + $shipping_fee);
            if ($use_credit > $creditInfo['max_exp_credit']) {
                return array('key' => 'use_credit_overlow');
            }
            $exp_amout = $this->toolPrice($use_credit / $creditInfo['exchange_credit_scale']);
        }
        //支付手续费处理
        $payment_fee = 0;
        if ($params['payment_id']) {

            $paymentLogic = $this->load('payment');
            $cond = '(language_id=0 or language_id=' . $this->language_id . ') and status=1 and id=' . $payment_id . ' order by listorder asc';
            $payment = $paymentLogic->getOne($cond);
            if ($payment) {
                $temptotalprice = $cartInfo['subtotalprice'] + $shipping_fee + $insurance_fee - $exp_amout;
                $order_param = array(
                    'totalprice' => $this->toolPrice($temptotalprice, TRUE)
                );
                $fee = $paymentLogic->getPaymentFee($order_param, $payment['config_param'], $payment['formula']);
                if ($fee) {
                    $payment_fee = $fee;
                } else {
                    $payment_fee = 0;
                }
            } else {
                return array('key' => 'Payment_Error');
            }
            $payment_fee = $this->toolPrice($payment_fee);
        }
        $cost_payment = $cartInfo['subtotalprice'] - $exp_amout;
        $total_amount = $cartInfo['subtotalprice'] + $shipping_fee - $exp_amout + $insurance_fee;
        $order_payment_amount = $cartInfo['subtotalprice'] + $shipping_fee - $exp_amout + $insurance_fee + $payment_fee;
        $order_data = array(
            'user_id' => $user_id,
            'itemno' => $order_itemno,
            'coupon_code_used' => isset($cartInfo['cart_coupon'][1]) ? $cartInfo['cart_coupon'][1] : 0,
            'total_weight' => $cartInfo['totalweight'],
            'currency_rate' => $current_currency['exchange_rate'],
            'currency_code' => $current_currency['standard_code'],
            'shipping_id' => $shipping_id,
            'payment_fee' => $payment_fee,
            'shipping_corp_id' => $shipping['shipping_corp_id'],
            'cost_shipping' => $shipping_fee,
            'cost_payment' => $cost_payment, //商品支付的金额
            'cost_offer' => $cartInfo['cart_save'] + $exp_amout,
            'total_amount' => $total_amount,
            'final_amount' => $order_payment_amount,
            'ip' => $ip,
            'language_id' => $language_id,
            'country_id' => $country_id,
            'remark' => $order_remark,
            'domain' => Common::strEscape($domain),
            'used_credit' => $use_credit,
            'insurance' => $insurance_fee,
            'create_time' => SYS_TIME,
            'source_device' => $deviceType,
            'source' => $this->getSource(),
            'billing_address_id' => $billing_address_id,
            'payed' => 0,
        );
        $order_res = $this->orderLogic->save($order_data);
        if ($order_res) {
            /* 原来的订单备注，使用错了
              $msg_data = array(
              'user_id' => $user_id ? $user_id : 0,
              'user_name' => _c('user_base_name'),
              'base_name' => Common::strEscape($order_remark),
              'ip' => $ip,
              'domain' => Common::strEscape($domain),
              'detail' => Common::strEscape($order_remark),
              'type' => $user_id ? 1 : 2,
              'contact' => json_encode($contact),
              'status' => 1,
              'language_id' => $language_id,
              'is_user_readed' => 1,
              'order_id' => $order_res,
              'source_device' => $deviceType,
              'create_time'    => SYS_TIME,
              );
              $this->messageLogic->save($msg_data);
             */
            if ($params['payment_id']) {
                global $cfg;
                $orderPaymentLogic = $this->load('orderPayment');
                $currencyLogic = $this->load('currency');
                $base_currency_id = $cfg['sites'][0]['base_currency'];
                $trade_no = date('Ymdhsi', time());
                $pay_amount = $order_data['final_amount'];
                $currency_code = $order_data['currency_code']; //货币三位符
                $currency_conde = 'standard_code="' . $currency_code . '"';
                $currency = $currencyLogic->getOne($currency_conde);
                $payment_data = array(
                    'payment_type' => 1,
                    'trade_no' => $trade_no,
                    'order_id' => $order_res,
                    'user_id' => $user_id,
                    'payment_id' => $payment_id,
                    'amount' => $this->speChangePrice($pay_amount, $currency, TRUE),
                    'base_currency_id' => $base_currency_id,
                    'real_currency_id' => $currency['id'],
                    'real_currency_amount' => $pay_amount,
                    'status' => 0,
                    'create_time' => SYS_TIME,
                );
                $orderPaymentLogic->updateByCond($payment_data);
            }
            $map = Zhtx::createDataMap();
            if (!ORDER_FORMATE) {
                $itemno = date("Ymd") . "-" . $order_res;
            } else {
                global $cfg_order_format;
                $str_format = '';
                if ($cfg_order_format) {
                    eval('$str_format=' . $cfg_order_format);
                } else {
                    $str_format = ORDER_FORMATE;
                }
                $itemno = str_replace("@id", $order_res, $str_format);
            }
            $map->addEntry('itemno', $itemno, DB::VARCHAR);
            $res = $this->orderLogic->update($map, 'id=' . $order_res);
            $order_data['id'] = $order_res;
            $order_data['itemno'] = $itemno;
            $orderAddressLogic = $this->load('orderAddress');
            $orderItemLogic = $this->orderItemLogic;
            $orderOfferLogic = $this->load('orderOffer');
            $order_address_data = array(
                'order_id' => $order_res,
                'first_name' => Common::strEscape($address['first_name']),
                'last_name' => Common::strEscape($address['last_name']),
                'country_id' => $address['country_id'],
                'state' => Common::strEscape($address['state']),
                'city' => Common::strEscape($address['city']),
                'address' => Common::strEscape($address['address']),
                'address_spare' => Common::strEscape($address['address_spare']),
                'postcode' => Common::strEscape($address['postcode']),
                'telephone' => $address['telephone'],
                'mobilephone' => $address['mobilephone'],
                'email' => $address['email'],
            );
            $address_res = $orderAddressLogic->save($order_address_data);
            if (!$address_res) {
                return array('key' => 'address_save_failure');
            }
            $skuLogic = $this->load('sku');
            $product_promotion_amount = 0;
            $property_ids = array();
            $propertys = array();
            foreach ($cartInfo['orderitems'] as $item) {
                $skucode = explode('_', $item['sku_code']);
                foreach ($skucode as $key => $value) {
                    if ($value) {
                        $property_ids[] = $value;
                    }
                }
            }
            if ($property_ids) {
                $res = $this->propertyLogic->findAll("id in(" . join(',', $property_ids) . ")");
                foreach ($res as $key => $value) {
                    $propertys[$value['id']] = $value;
                }
            }
            foreach ($cartInfo['orderitems'] as $item) {
                $sku_code_pid = explode('_', $item['sku_code']);
                $order_item_data = array(
                    'order_id' => $order_res,
                    'goods_id' => $item['goods_id'],
                    'sku_code' => $item['sku_code'],
                    'goods_name' => Common::strEscape($item['base_name']),
                    'buy_num' => $item['qty'],
                    'price' => $item['price'],
                    'cost_price' => $item['cost_price'],
                    'weight' => $item['weight'],
                    'product_image' => $item['image'],
                    'status' => 1,
                );
                if ($propertys[$sku_code_pid[0]] || $propertys[$sku_code_pid[1]]) {
                    $order_item_data['sku_value'] = $propertys[$sku_code_pid[0]]['base_name'] . '_' . $propertys[$sku_code_pid[1]]['base_name'];
                }
                $order_item_data['sku_value'] = mysql_escape_string($order_item_data['sku_value']);
                $item_res = $orderItemLogic->save($order_item_data);
                if ($item_res) {
                    //冻结库存
                    $sku = $skuLogic->getOne('goods_id=' . $item['goods_id'] . ' and sku_code="' . $item['sku_code'] . '"');
                    $sku_data = array(
                        'freeze_nums' => $sku['freeze_nums'] + $item['qty'],
                    );
                    $skuLogic->save($sku_data, $sku['id']);
                    $offer = $item['offer_id'] ? $item['promotions'][$item['offer_id']] : '';
                    if ($item['offer_id'] && empty($item['gifts'])) {//不是赠品促销的情况
                        if ($item['promotion_save'] > 0) {
                            $order_offer_data = array(
                                'offer_base_name' => $offer['default_base_name'],
                                'order_id' => $order_res,
                                'item_id' => $item_res,
                                'offer_id' => $offer['id'],
                                'rule_id' => $item['rule_id'],
                                'amount' => $item['promotion_save'],
                                'order_offer_type' => 301,
                            );
                            $orderOfferLogic->save($order_offer_data);
                            $product_promotion_amount += $item['promotion_save'];
                        }
                    } else {
                        foreach ($item['gifts'] as $gift) {
                            $order_item_gift_data = array(
                                'order_id' => $order_res,
                                'goods_id' => $gift['goods_id'],
                                'sku_code' => $gift['sku_code'],
                                'goods_name' => Common::strEscape($gift['base_name']),
                                'buy_num' => $gift['num'],
                                'price' => $this->toolPrice($gift['price']),
                                'cost_price' => $this->toolPrice($gift['cost_price']),
                                'weight' => $gift['weight'],
                                'product_image' => $gift['image'],
                                'is_gift' => 1,
                                'status' => 1,
                            );
                            $gift_res = $orderItemLogic->save($order_item_gift_data);
                            if ($gift_res) {
                                $order_offer_data = array(
                                    'offer_base_name' => $offer['default_base_name'],
                                    'order_id' => $order_res,
                                    'goods_id' => $gift['goods_id'],
                                    'item_id' => $item_res,
                                    'offer_id' => $offer['id'],
                                    'rule_id' => $item['rule_id'],
                                    'sku_code' => $gift['sku_code'],
                                    'amount' => $this->toolPrice(($gift['sku_price'] - $gift['price']) * $gift['num']),
                                    'order_offer_type' => 301,
                                    'gift_item_id' => $gift_res,
                                );
                                $orderOfferLogic->save($order_offer_data);
                                $product_promotion_amount += $order_offer_data['amount'];
                                //冻结库存
                                $sku = $skuLogic->getOne('goods_id=' . $gift['goods_id'] . ' and sku_code="' . $gift['sku_code'] . '"');
                                $sku_data = array(
                                    'freeze_nums' => $sku['freeze_nums'] + $gift['num'],
                                );
                                $skuLogic->save($sku_data, $sku['id']);
                            }
                        }
                    }
                    $params = array(
                        'buy_counts' => $item['qty'],
                        'cost_offer' => $this->toolPrice($item['aftersave'], TRUE),
                        'cost_amount' => $item['cost_price'] * $item['qty'],
                    );
                    //报表数据
                    ReportFactory::goodsReportAndGoodsLanguageReport($item['goods_id'], $language_id, $country_id, $params);
                }
                //报表数据处理
                ReportFactory::reduceCartCount($item['goods_id'], $item['qty'], $item['add_cart_time'], $user_id);
            }
            if ($cartInfo['cart_promotion'] && $cartInfo['cart_promotion'] != 'nothing') {
                if ($cartInfo['promotion_save'] > 0) {
                    $order_offer_data = array(
                        'offer_base_name' => $cartInfo['promotion_offer']['default_base_name'],
                        'order_id' => $order_res,
                        'offer_id' => $cartInfo['promotion_offer']['id'],
                        'rule_id' => $cartInfo['promotion_rule_id'],
                        'amount' => $cartInfo['promotion_save'],
                        'order_offer_type' => 301,
                    );
                    $orderOfferLogic->save($order_offer_data);
                }
                //礼品
                foreach ($cartInfo['cart_gift'] as $gift) {
                    $order_item_gift_data = array(
                        'order_id' => $order_res,
                        'goods_id' => $gift['goods_id'],
                        'sku_code' => $gift['sku_code'],
                        'goods_name' => Common::strEscape($gift['base_name']),
                        'buy_num' => $gift['num'],
                        'price' => $this->toolPrice($gift['price']),
                        'cost_price' => $this->toolPrice($gift['cost_price']),
                        'weight' => $gift['weight'],
                        'product_image' => $gift['image'],
                        'is_gift' => 1,
                        'status' => 1,
                    );
                    $gift_res = $orderItemLogic->save($order_item_gift_data);
                    if ($gift_res) {
                        $order_offer_data = array(
                            'offer_base_name' => $cartInfo['promotion_offer']['default_base_name'],
                            'order_id' => $order_res,
                            'goods_id' => $gift['goods_id'],
                            'item_id' => $item_res,
                            'offer_id' => $cartInfo['promotion_offer']['id'],
                            'rule_id' => $cartInfo['promotion_rule_id'],
                            'sku_code' => $gift['sku_code'],
                            'amount' => $this->toolPrice($gift['sku_price'] - $gift['price']) * $gift['num'],
                            'order_offer_type' => 301,
                            'gift_item_id' => $gift_res,
                        );
                        $orderOfferLogic->save($order_offer_data);
                        $product_promotion_amount += $order_offer_data['amount'];
                        //冻结库存
                        $sku = $skuLogic->getOne('goods_id=' . $gift['goods_id'] . ' and sku_code="' . $gift['sku_code'] . '"');
                        $sku_data = array(
                            'freeze_nums' => $sku['freeze_nums'] + $gift['num'],
                        );
                        $skuLogic->save($sku_data, $sku['id']);
                    }
                }
            }
            //更新cost_offer
            $update_costPayment_map = Zhtx::createDataMap();
            $update_costPayment_map->addEntry('cost_offer', $cartInfo['cart_save'] + $exp_amout + $product_promotion_amount, DB::FLOAT);
            $this->orderLogic->update($update_costPayment_map, 'id=' . $order_res);
            if (isset($cartInfo['cart_coupon'][1])) {
                $order_offer_data = array(
                    'offer_base_name' => $cartInfo['coupon_offer']['base_name'],
                    'order_id' => $order_res,
                    'offer_id' => $cartInfo['coupon_offer']['id'],
                    'rule_id' => $cartInfo['coupon_rule_id'],
                    'coupon' => $cartInfo['cart_coupon'][1],
                    'amount' => $cartInfo['coupon_save'],
                    'order_offer_type' => 302,
                );
                $c_res = $orderOfferLogic->save($order_offer_data);
                if ($c_res) {
                    //冻结优惠券
                    $couponLogic = $this->load('coupon');
                    $offerLogic = $this->load('offer');
                    $coupon = $couponLogic->getOne('coupon_code ="' . $cartInfo['cart_coupon'][1] . '"');
                    if ($coupon) {
                        $offer = $offerLogic->getOne('id=' . $coupon['offer_id']);
                        if ($offer['coupon_type'] != 1) {
                            $c_data = array(
                                'order_id' => $order_res,
                                'status' => 3,
                                'using_time' => SYS_TIME,
                            );
                            $couponLogic->save($c_data, $coupon['id']);
                        } else {
                            $c_data = array(
                                'order_id' => $order_res,
                                'using_time' => SYS_TIME,
                            );
                            $couponLogic->save($c_data, $coupon['id']);
                            //更新通用优惠券使用次数
                            $send_num = $offer['send_num'] + 1;
                            $o_data = array(
                                'send_num' => $send_num,
                            );
                            $offerLogic->save($o_data, $offer['id']);
                            $couponuserLogic = $this->load('couponUser');
                            $ou_data = array(
                                'user_id' => $user_id,
                                'order_id' => $order_res,
                                'offer_id' => $coupon['offer_id'],
                                'using_time' => SYS_TIME,
                            );
                            $couponuserLogic->save($ou_data);
                        }
                        _setSession('coupon_code_list', '');
                    }
                }
            }
            //积分抵用金额记录
            if ($use_credit) {
                $order_offer_data = array(
                    'offer_base_name' => '积分抵用',
                    'order_id' => $order_res,
                    'amount' => $exp_amout,
                    'order_offer_type' => 303,
                );
                $orderOfferLogic->save($order_offer_data);
                $this->load('creditDetail')->expCredit($use_credit);
            }
            $params2 = array(
                'order_counts' => 1,
                'order_amount' => $this->toolPrice($cartInfo['subtotalprice'], TRUE),
                'cost_offer' => $this->toolPrice($cartInfo['cart_save'], TRUE),
                'cost_shipping' => $res,
                'order_item_counts' => $cartInfo['totalqty'],
            );
            ReportFactory::salesReportAndUserSalesReport($user_id, $language_id, $country_id, $params2);
            //清除购物车数据
            $this->load('userCart')->clearCart($user_id, $language_id);
            $order_data['payment_id'] = $payment_id;
            EventFactory::addOrderAfter($order_data);
            $this->cleanUserSource();
            $this->cleanSource();
            return $order_data;
        }
    }

    /**
     *  付款不足， 付款溢出， 会跳转到这里
     * @return type
     */
    public function actionPaymentChecking() {
        $itemno = _g('itemno');
        $order = $this->orderLogic->getOne('itemno="' . $itemno . '"');
        if (!$order) {
            return $this->notice('illegal_parameters');
        }
        $this->cleanUserSource();
        $this->cleanSource();
        Core::$tpl->set('order', $order);
        Core::$htmlFile = 'order/paymentchecking';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

}

?>
