<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of product
 *
 * @author xrx
 */
class ProductController extends AppController {

    private $goodsJoinLangLogic;
    private $goodsLangLogic;
    private $productLogic;
    private $goodsPropertyRelLogic;
    private $languageLogic;
    private $imageLogic;
    private $propertyLangLogic;
    private $goodsProRelLangLogic;
    private $propertyLogic;
    private $goodsCatLangLogic;

    public function __construct() {
        parent::__construct();
        $this->goodsJoinLangLogic = $this->load('goodsJoinLanguage');
        $this->goodsLangLogic = $this->load('goodsLanguage');
        $this->productLogic = $this->load('product');
        $this->goodsPropertyRelLogic = $this->load('goodsPropertyRel');
        $this->languageLogic = $this->load('language');
        $this->imageLogic = $this->load('productOtherImage');
        $this->propertyLangLogic = $this->load('propertyLanguage');
        $this->goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $this->propertyLogic = $this->load('property');
        $this->goodsCatLangLogic = $this->load('goodsCategoryLanguage');
    }

    /**
     * 商品详情页
     * 多语言
     */
    public function actionDetail() {
		global $cfg;
                $language_id = $this->languageLogic->language_id;
        $goods_id = Common::queryInt(_g('goods_id'));
        $product_id = Common::queryInt(_g('product_id'));
        $this->goodsJoinLangLogic->setHistory($goods_id);
//商品详细页
        $detail = $this->goodsJoinLangLogic->getDetailByGoodsId($goods_id, $language_id);
        if (!$detail) {
            return $this->exception();
        }
        $goods = $detail['goods'];
		
// 获取详细页URL
		$rewrite_type = isset($cfg['sites'][$language_id]['rewrite_type']) ? $cfg['sites'][$language_id]['rewrite_type'] : 0;
		$rewrite["type"] = $rewrite_type;
    	$rewrite["name_type"] = "";
		$urlMaker = $this->load('UrlMaker');
		$goods_url = $urlMaker->getProductUrl($goods_id, '', $language_id, $rewrite);
                if(strpos($uri, '?'))
                    $query_string = substr($_SERVER['REQUEST_URI'], strpos($_SERVER['REQUEST_URI'], '?'), strlen($_SERVER['REQUEST_URI']));
                if(!strstr(str_replace('-html','.html','/'.Common::makeUrlName($_SERVER['REQUEST_URI'])), $goods_url)&&!$goods['page_url']){
                    //Header("HTTP/1.0 301 Moved Permanently");
                    //Header("Location: " . $goods_url . $query_string);
                }
//单品集合
        $productList = $detail['products'];
//商品属性
        $propertylist = $detail['propertylist'];
        $goods['special_discount'] = $goods['discount'];
        if ($goods['product_id'] && !$product_id) {
            $product_id = $goods['product_id']; //主单品
        }
        $sale_property = array();
        $master_sale_parent = array();
        $sale_parent = array();
        $master_show_image = TRUE;
        $master_show_attributes_image=false;
        foreach ($propertylist['sale'] as $item) {
            if ($item['property_type'] == 1) {
                if (empty($master_sale_parent)) {
                    $master_sale_parent = array(
                        'id' => $item['property_id'],
                        'base_name' => $item['property_name'],
                    );
                }
            //主销售属性图片
                $item['image'] = isset($productList[$item['vid']]) ? $productList[$item['vid']]['image'] : '';
                if (!$item['image']) {
                    $master_show_image = FALSE;
                }
                $sale_property['master'][$item['property_id']][$item['vid']] = $item;
            } else {
                if (empty($sale_parent)) {
                    $sale_parent = array(
                        'id' => $item['property_id'],
                        'base_name' => $item['property_name'],
                    );
                }
                $sale_property['sale'][$item['property_id']][$item['vid']] = $item;
            }
        }        
        //商品图片
        $images = $detail['images'];        
        //过滤重复图片
        $tempimagelist = array();
        foreach ($images as $ikey => $idata) {            
            if (in_array($idata['image'], $tempimagelist)) {
                unset($images[$ikey]);
            } else {
                $tempimagelist[] = $idata['image'];
            }            
        }        
        if ($product_id) {
            foreach ($productList as $key => $product) {
                if ($product['id'] == $product_id) {
                    $goods['image'] = $product['image'];
                    $goods['save'] = $product['old_price'] - $product['price'];
                    $goods['discount'] = 100 - $goods['discount'] * 10;
                    Core::$tpl->set('property_id', $key);
                }
            }
        } else {
            $goods['save'] = $goods['old_price'] - $goods['price'];
            $goods['discount'] = 100 - $goods['discount'] * 10;
        }
        $categoryJoinLangLogic = $this->load('goodsCategoryJoinLang');
        $commentLogic = $this->load('goodsComment');
        $current_category = $categoryJoinLangLogic->getCurrentCategory($detail['category_ids'], $language_id);
        $comments = $commentLogic->getComment($goods_id, $language_id, 0, 20);
        $country_ids = array();
        foreach ($comments as $val) {
            $country_ids[$val['country_id']] = $val['country_id'];
        }
//免邮处理
        $free_shipping = false;
        $cur_country_id = Common::queryInt(_s('clientCountryID'));
        if ($goods['is_free_shipping'] && $goods['is_free_shipping']) {
//当前国家IP
            $cur_country_id = _s('clientCountryID');
            $free_shipping = $this->load('specialJoinShippingJoinArea')->validFreeShipping($cur_country_id, $goods_id);
            $country_ids[$cur_country_id] = $cur_country_id;
        }
//查询所有国家
        $countryLogic = $this->load('country');
        $country = array();
        if (!empty($country_ids)) {
            foreach ($countryLogic->getAll() as $_val) {
                if (in_array($_val['id'], $country_ids)) {
                    $country[$_val['id']] = $_val;
                }
            }
        }
        $sale_pro = array();
        $sale_pro_idarray = array();
        $attributes_image_arr = array();
        $attributes_image_boole = true;        
        foreach ($sale_property['sale'] as $skey => $svalue) {
            Common::sort_rows($svalue, 'listorder', SORT_DESC);
            $sale_pro['sale'][$skey] = $svalue;
            foreach ($svalue as $pkey => $pvalue) {
                $sale_pro_idarray['sale'][$pvalue['vid']] = $pvalue;
            }
        }        
        foreach ($sale_property['master'] as $skey => $svalue) {
            Common::sort_rows($svalue, 'listorder', SORT_DESC);
            $sale_pro['master'][$skey] = $svalue;
            foreach ($svalue as $pkey => $pvalue) {
                $sale_pro_idarray['master'][$pvalue['vid']] = $pvalue;
                //取得属性图
                if(!$master_show_image){
                    $at_images = $this->propertyLogic->getOneById($pvalue['vid'],array("image"));                     
                    if(!$at_images['image']){
                        $attributes_image_boole=false;
                    }
                    $attributes_image_arr[$pvalue['vid']]=$at_images['image'];
                }
            }            
        }        
        if(!$master_show_image && $attributes_image_boole){
            $master_show_attributes_image=true;
        }        
        //取得sku列表
        $skuJoinProductLogic = $this->load('skuJoinProduct');
        $skulist = $skuJoinProductLogic->getListByGoodsId($goods_id);
        if (!$skulist) {
            $skulist = array();
        }
        foreach ($skulist as $key => $data) {
            if($data['price']<=0)
            {
                $data['price'] = $data['gprice'];
            }
            if($data['market_price']<=0)
            {
                $data['market_price'] = $data['gmarket_price'];
            }
            if($data['old_price']<=0)
            {
                $data['old_price'] = $data['gold_price'];
            }
            if($data['cost_price']<=0)
            {
                $data['cost_price'] = $data['gcost_price'];
            }
            $skulist[$key]['market_price'] = $this->toolPrice(Common::getMarketPrice($data['price'], $data['market_price']));
            $skulist[$key]['price'] = $this->toolPrice($data['price']);
            $skulist[$key]['old_price'] = $this->toolPrice($data['old_price']);
            $skulist[$key]['save_money'] = $this->toolPrice($data['old_price'] - $data['price']);
            $skulist[$key]['cost_price'] = $this->toolPrice($data['cost_price']);
            $sku_code_split = explode('_', $data['sku_code']);
            $skulist[$key]['master_id'] = $sku_code_split[0];
            $skulist[$key]['sale_id'] = $sku_code_split[1];
        }
//var_dump($skulist);
//var_dump($sale_pro_idarray);
        if ($goods['status'] == 0 && $cfg['sites'][0]['sold_out']) {
            $this->exception();
        }
        $search = array("'", '"');
        $goods['safe_name'] = str_replace($search, ' ', $goods['base_name']);
        $rating = $this->commentRating($goods_id, $where);
        if ($goods['special_offer_id']) {
            $cond = 'id=' . $goods['special_offer_id'];
            $specialLogic = $this->load('specialOffer');
            $special = $specialLogic->getOne($cond);
        }
        $countrylist = $countryLogic->getCountries();
        $category_template = $this->goodsCatLangLogic->getOne('goods_category_id='.(int)$current_category['id'] . ' and language_id=' . $language_id);
        Core::$tpl->set('category_template', $category_template['goods_template'] ? $category_template['goods_template'] : 'product/detail');
        Core::$tpl->set('master_show_attributes_image', $master_show_attributes_image);
        Core::$tpl->set('attributes_image_arr', $attributes_image_arr);        
        Core::$tpl->set('rating', $rating['rating']);
        Core::$tpl->set('special', $special);
        Core::$tpl->set('skulist', json_encode($skulist));
        Core::$tpl->set('skus', $skulist);
        Core::$tpl->set('goods', $goods);
        Core::$tpl->set('goods_url', $goods_url);
        Core::$tpl->set('master_sale_parent', $master_sale_parent);
        Core::$tpl->set('sale_parent', $sale_parent);
        Core::$tpl->set('saleproperty', $sale_pro);
        Core::$tpl->set('sale_pro_idarray', $sale_pro_idarray);
        Core::$tpl->set('images', $images);
        Core::$tpl->set('category', $current_category); //print_r($current_category);die;
        Core::$tpl->set('common_property', $propertylist['common']);
        Core::$tpl->set('comments', $comments);
        Core::$tpl->set('forindex', array(1, 2, 3, 4, 5));
        Core::$tpl->set('countries', $country);
        Core::$tpl->set('cur_country_id', $cur_country_id);
        Core::$tpl->set('free_shipping', $free_shipping);
        Core::$tpl->set('master_show_image', $master_show_image);
        Core::$tpl->set('countrylist', $countrylist);
        $brand = $this->load('brand')->getOne('id='.$goods['brand_id']);
        Core::$tpl->set('brand', $brand);
        Core::$htmlFile = $goods['template_page'] ? $goods['template_page'] : 'product/detail'; //'product/detail2';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        $this->goodsJoinLangLogic->validRead($goods_id, $goods['visit_counts']);
        $params = array(
            'brand_id' => $goods['brand_id'],
            'domain' => isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '',
            'category_ids' => !empty($detail['category_ids']) ? Common::strEscape(implode(',', $detail['category_ids']) . ',') : '',
            'visit_counts' => 1
        );
        $country_id = $this->load('ipJoinCountry')->getCountryId(Common::_ip2long(Common::ip()));
        ReportFactory::goodsReportAndGoodsLanguageReport($goods_id, $language_id, $country_id, $params);
    }

    /**
     * 快速添加到购物车
     */
    public function actionQuickCart() {
        $language_id = $this->languageLogic->language_id;
        $goods_id = Common::queryInt(_g('goods_id'));
        $product_id = Common::queryInt(_g('product_id'));
        $this->goodsJoinLangLogic->setHistory($goods_id);
//商品详细页
        $detail = $this->goodsJoinLangLogic->getDetailByGoodsId($goods_id, $language_id);
        if (!$detail) {
            return '';
        }
        $goods = $detail['goods'];
//单品集合
        $productList = $detail['products'];
//商品属性
        $propertylist = $detail['propertylist'];
        $goods['special_discount'] = $goods['discount'];
        if ($goods['product_id'] && !$product_id) {
            $product_id = $goods['product_id']; //主单品
        }
        $sale_property = array();
        $master_sale_parent = array();
        $sale_parent = array();
        $master_show_image = TRUE;
        foreach ($propertylist['sale'] as $item) {
            if ($item['property_type'] == 1) {
                if (empty($master_sale_parent)) {
                    $master_sale_parent = array(
                        'id' => $item['property_id'],
                        'base_name' => $item['property_name'],
                    );
                }
//主销售属性图片
                $item['image'] = isset($productList[$item['vid']]) ? $productList[$item['vid']]['image'] : '';
                if (!$item['image']) {
                    $master_show_image = FALSE;
                }
                $sale_property['master'][$item['property_id']][$item['vid']] = $item;
            } else {
                if (empty($sale_parent)) {
                    $sale_parent = array(
                        'id' => $item['property_id'],
                        'base_name' => $item['property_name'],
                    );
                }
                $sale_property['sale'][$item['property_id']][$item['vid']] = $item;
            }
        }
//商品图片
        $images = $detail['images'];
//过滤重复图片
        $tempimagelist = array();
        foreach ($images as $ikey => $idata) {
            if (in_array($idata['image'], $tempimagelist)) {
                array_splice($images, $ikey, 1);
            } else {
                $tempimagelist[] = $idata['image'];
            }
        }
        if ($product_id) {
            foreach ($productList as $key => $product) {
                if ($product['id'] == $product_id) {
                    $goods['image'] = $product['image'];
                    $goods['save'] = $this->toolPrice($product['old_price'] - $product['price']);
                    $goods['discount'] = 100 - $goods['discount'] * 10;
                    Core::$tpl->set('property_id', $key);
                }
            }
        } else {
            $goods['save'] = $this->toolPrice($goods['old_price'] - $goods['price']);
//            $goods['discount'] = round($goods['save'] * 100 / $goods['old_price']);
            $goods['discount'] = 100 - $goods['discount'] * 10;
        }
        $categoryJoinLangLogic = $this->load('goodsCategoryJoinLang');
        $commentLogic = $this->load('goodsComment');
        $current_category = $categoryJoinLangLogic->getCurrentCategory($detail['category_ids'], $language_id);
        $comments = $commentLogic->getComment($goods_id, $language_id, 0, 20);
        $country_ids = array();
        foreach ($comments as $val) {
            $country_ids[$val['country_id']] = $val['country_id'];
        }
        $free_shipping = false;
        $cur_country_id = Common::queryInt(_s('clientCountryID'));
        if ($goods['is_free_shipping'] && $goods['special_offer_id']) {
//当前国家IP
            $cur_country_id = _s('clientCountryID');
            $free_shipping = $this->load('specialJoinShippingJoinArea')->validFreeShipping($cur_country_id, $goods['special_offer_id']);
            $country_ids[$cur_country_id] = $cur_country_id;
        }
//查询所有国家
        $countryLogic = $this->load('country');
        $country = array();
        if (!empty($country_ids)) {
            foreach ($countryLogic->getAll() as $_val) {
                if (in_array($_val['id'], $country_ids)) {
                    $country[$_val['id']] = $_val;
                }
            }
        }
        $sale_pro = array();
        foreach ($sale_property['sale'] as $skey => $svalue) {
            Common::sort_rows($svalue, 'listorder', SORT_DESC);
            $sale_pro['sale'][$skey] = $svalue;
        }
        foreach ($sale_property['master'] as $skey => $svalue) {
            Common::sort_rows($svalue, 'listorder', SORT_DESC);
            $sale_pro['master'][$skey] = $svalue;
        }

//取得sku列表
        $skuJoinProductLogic = $this->load('skuJoinProduct');
        $skulist = $skuJoinProductLogic->getListByGoodsId($goods_id);
        if (!$skulist) {
            $skulist = array();
        }
        foreach ($skulist as $key => $data) {
            $skulist[$key]['market_price'] = $this->toolPrice(Common::getMarketPrice($data['price'], $data['market_price']));
            $skulist[$key]['old_price'] = $this->toolPrice($data['old_price']);
            $skulist[$key]['price'] = $this->toolPrice($data['price']);
            $skulist[$key]['save_money'] = $this->toolPrice($data['old_price'] - $data['price']);
            $skulist[$key]['cost_price'] = $this->toolPrice($data['cost_price']);
        }
        $search = array("'", '"');
        $goods['safe_name'] = str_replace($search, ' ', $goods['base_name']);
        Core::$tpl->set('skulist', json_encode($skulist));
        Core::$tpl->set('goods', $goods);
        Core::$tpl->set('master_sale_parent', $master_sale_parent);
        Core::$tpl->set('sale_parent', $sale_parent);
        Core::$tpl->set('saleproperty', $sale_pro);
        Core::$tpl->set('images', $images);
        Core::$tpl->set('category', $current_category); //print_r($current_category);die;
        Core::$tpl->set('common_property', $propertylist['common']);
        Core::$tpl->set('comments', $comments);
        Core::$tpl->set('forindex', array(1, 2, 3, 4, 5));
        Core::$tpl->set('countries', $country);
        Core::$tpl->set('cur_country_id', $cur_country_id);
        Core::$tpl->set('free_shipping', $free_shipping);
        Core::$tpl->set('master_show_image', $master_show_image);
    }

    /**
     * 商品的列表页
     *
     */
    public function actionList() {
        global $cfg;
        $language_id = $this->languageLogic->language_id;
        $urlMaker = $this->load('UrlMaker');
        $rewrite=array();
        $rewrite["type"] = $cfg['sites'][$language_id]['rewrite_type'];
       	$rewrite["name_type"] = $cfg['sites'][$language_id]['rewrite_prename'];
        $uri = $_SERVER['REQUEST_URI'];
        if(strpos($uri, '?'))
            $query_string = substr($uri, strpos($uri, '?'), strlen($uri));
        $category_id = Common::queryInt(_g('category_id'));
        $brands = _g('brand_id');

        if (is_array($brands)) {
            foreach ($brands as $item) {
                $brand_ids[$item] = $item;
            }
            if (count($brands) == 1) {
                $brand_id = $brands[0];
            }
        } else {
            $brand_id = Common::queryInt(_g('brand_id'));
        }
        if($brand_id)
            $brand_res = $this->load('brand')->getOne('id='.$brand_id);
        if($brand_res){
            $href = $urlMaker->getBrandUrl($brand_id,$language_id,$rewrite);
            if(!strstr(str_replace('-html','.html','/'.Common::makeUrlName($uri)), $href)&&!$brand_res['page_url']){
                //Header("HTTP/1.0 301 Moved Permanently");
                //Header("Location: " . $href . $query_string);
            }
        }
        $tags = _g('tag_id');
        if (is_array($tags)) {
            foreach ($tags as $item) {
                $tag_ids[$item] = $item;
            }
            if (count($tags) == 1) {
                $tag_id = $tags[0];
            }
        } else {
            $tag_id = Common::queryInt(_g('tag_id'));
        }
        if($tag_id)
            $goodsTag_res = $this->load('goodsTag')->getOne('id='.$tag_id);
        if($goodsTag_res){
            $href = $urlMaker->getTagUrl($tags,$language_id,$rewrite);
            if(!strstr(str_replace('-html','.html','/'.Common::makeUrlName($uri)), $href)&&!$goodsTag_res['page_url']){
                //Header("HTTP/1.0 301 Moved Permanently");
                //Header("Location: " . $href . $query_string);
            }
        }
        $property_ids = _g('property_id');
        $orderby = isset($cfg['sites'][0]['goods_default_sort']) ? $cfg['sites'][0]['goods_default_sort'] : 'goods_id ';
        $seq = ' desc';
        $orderby = $orderby == 'create_time' ? 'l.goods_id' : 'l.' . $orderby;
//分页用的参数
        $page_size = $cfg['sites'][$language_id]['disp_list1_number'] ? $cfg['sites'][$language_id]['disp_list1_number'] : 24;
        $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $show_in_stock = false;
        if (_g('oquery')) {
            $oquery = explode('-', _g('oquery')); //oquery = 1-2-3-4 (展示方式-显示数量-字段-升降)
            
            Core::$tpl->set('display_type', $oquery[0]);
            
            $seq = $oquery[3] == 1 ? ' desc' : ' asc';
            if ($oquery[1])
                $page_size = $oquery[1];
            switch ($oquery[2]) {
                case 1:
                    $orderby = 'l.up_time desc,l.listorder ';
                    $seq = ' desc';
                    break;
                case 2:
                    $orderby = 'g.price ';
                    break;
                case 3:
                    $orderby = 'g.buy_counts ';
                    break;
                case 4:
                    $orderby = 'g.comment_counts ';
                    break;
                case 5:
                    $orderby = 'g.wishlist_counts ';
                    break;
                case 6:
                    $orderby = 'g.visit_counts ';
                    break;
                case 7:
                    $orderby = 'l.goods_id ';
                    $seq = ' desc';
                    break;
                default :break;
            }
            $query = array(
                'listorder' => $oquery[3] ? $oquery[3] : 1,
                'order' => $oquery[2] ? $oquery[2] : 1,
                'psize' => $page_size
            );
            //只显示有货
            if($oquery[4])
            {
                $show_in_stock = true;
                //$cond .= ' and g.stock_nums>0';
                $query['in_stock'] = 1;
            }
        }
        $pids = array();
        if ($property_ids) {
            foreach ($property_ids as $pid) {
                $pids[$pid] = $pid;
            }
        }
        $goodsList = array();
        $category = array();
        if ($category_id) {
            $ccond = 'l.goods_category_id=' . $category_id . ' and l.language_id=' . $language_id;
            $categoryLogic = $this->load('goodsCategoryJoinLang');
            $category = $categoryLogic->getOne($ccond);
            if (!$category) {
                return $this->notice('not_found');
            }
            $href = $urlMaker->getCategoryUrl($category_id,$language_id,$rewrite);
            if(!strstr(str_replace('-html','.html','/'.Common::makeUrlName($uri)), $href)&&!$category['page_url']){
                //Header("HTTP/1.0 301 Moved Permanently");
                //Header("Location: " . $href . $query_string);
            }
        }
        if ($category_id && !$tags && !$property_ids) {
            $cond = 'l.category_path like"' . $category['path_id'] . '%"';
            if ($brand_id) {
                $cond .= ' and g.brand_id=' . $brand_id;
            } else if ($brand_ids) {
                $cond .= " and g.brand_id in (" . join(',', $brand_ids) . ")";
            }
            $cond .= '  AND l.language_id =' . $language_id . ' and g.status=1 and l.status=1';            
            if($show_in_stock)
            {
                $cond .= ' and g.stock_nums>0';
            }
            $sqlmd5 = md5($cond);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count = $this->goodsJoinLangLogic->getCount($cond);
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $cond .= ' order by ' . $orderby . $seq . ' limit ' . ($curr_page - 1) * $page_size . ',' . $page_size;
            $goodsList = $this->goodsJoinLangLogic->getGoodsList($cond, $curr_page);
        } else if ($category_id && $tags && !$property_ids) {
            $sql = 'select count(distinct g.id) as count ';
            $mid_sql = 'from (' . TABLE_PREFIX . '_goods as g ';
            if ($tag_id) {
                $mid_sql .= ' inner join ' . TABLE_PREFIX . '_goods_tag_rel as t on t.goods_id = g.id and t.tag_id=' . $tag_id;
            } else if ($tag_ids) {
                $mid_sql .= ' inner join ' . TABLE_PREFIX . '_goods_tag_rel as t on t.goods_id = g.id and t.tag_id in(' . join(',', $tag_ids) . ')';
            }
            $mid_sql .= ') left join ' . TABLE_PREFIX . '_goods_language as l on l.goods_id = g.id where l.category_path like"' . $category['path_id'] . '%"';
            if ($brand_id) {
                $mid_sql .= ' and g.brand_id=' . $brand_id;
            } else if ($brand_ids) {
                $mid_sql .= " and g.brand_id in (" . join(',', $brand_ids) . ")";
            }
            $mid_sql .= '  AND l.language_id =' . $language_id . ' and g.status=1 and l.status=1';
            if($show_in_stock)
            {
                $mid_sql .= ' and g.stock_nums>0';
            }
            $count_sql = $sql . $mid_sql;
            $sqlmd5 = md5($count_sql);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count_array = $this->goodsJoinLangLogic->query($count_sql);
                $count = $count_array[0]['count'];
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $find_sql = 'SELECT distinct g.id AS id ' . $mid_sql . ' order by ' . $orderby . $seq . ' limit ' . ($curr_page - 1) * $page_size . ',' . $page_size;
            $goods_array = $this->goodsJoinLangLogic->query($find_sql);
            $goodsIds = array();
            foreach ($goods_array as $_v) {
                $goodsIds[] = $_v['id'];
            }
            if (count($goodsIds)) {
                $page_data = Common::getPages($count, $curr_page, $page_size);
                $where = 'l.goods_id in (' . implode(',', $goodsIds) . ') and l.language_id =' . $language_id . ' order by ' . $orderby . $seq;
                $goodsList = $this->goodsJoinLangLogic->getGoodsList($where, $curr_page);
            }
        } else if ($category_id && $property_ids && !$tags) {
            $sql = 'select count(distinct g.id) as count ';
            $mid_sql = 'from (' . TABLE_PREFIX . '_goods as g ';
//属性分类别：分color 或 size 等
            $propertyParentSon = $this->propertyLogic->getParentAndSonByIds($property_ids);
            foreach ($propertyParentSon as $pk => $rows) {
                $alias = 'p' . $pk;
                $mid_sql .= ' inner join ' . TABLE_PREFIX . '_goods_property_rel as ' . $alias . ' on g.id=' . $alias . '.goods_id and ' . $alias . '.vid in(';
                $pro_ids = array();
                foreach ($rows as $vk => $value) {
                    $pro_ids[] = $value['id'];
                }
                $mid_sql .= join(',', $pro_ids);
                $mid_sql .=')';
            }
            $mid_sql .= ') left join ' . TABLE_PREFIX . '_goods_language as l on l.goods_id = g.id where l.category_path like"' . $category['path_id'] . '%"';
            if ($brand_id) {
                $mid_sql .= ' and g.brand_id=' . $brand_id;
            } else if ($brand_ids) {
                $mid_sql .= " and g.brand_id in (" . join(',', $brand_ids) . ")";
            }
            $mid_sql .= '  AND l.language_id =' . $language_id . ' and g.status=1 and l.status=1';
            if($show_in_stock)
            {
                $mid_sql .= ' and g.stock_nums>0';
            }
            $count_sql = $sql . $mid_sql;
            $sqlmd5 = md5($count_sql);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count_array = $this->goodsJoinLangLogic->query($count_sql);
                $count = $count_array[0]['count'];
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $find_sql = 'SELECT distinct g.id AS id ' . $mid_sql . ' order by ' . $orderby . $seq . ' limit ' . ($curr_page - 1) * $page_size . ',' . $page_size;
            $goods_array = $this->goodsJoinLangLogic->query($find_sql);
            $goodsIds = array();
            foreach ($goods_array as $_v) {
                $goodsIds[] = $_v['id'];
            }
            if (count($goodsIds)) {
                $page_data = Common::getPages($count, $curr_page, $page_size);
                $where = 'l.goods_id in (' . implode(',', $goodsIds) . ') and l.language_id =' . $language_id . ' order by ' . $orderby . $seq;
                $goodsList = $this->goodsJoinLangLogic->getGoodsList($where, $curr_page);
            }
        } else if ($category_id && $tags && $property_ids) {
            $sql = 'select count(distinct g.id) as count ';
            $mid_sql = 'from ((' . TABLE_PREFIX . '_goods as g ';

//属性分类别：分color 或 size 等
            $propertyParentSon = $this->propertyLogic->getParentAndSonByIds($property_ids);
            foreach ($propertyParentSon as $pk => $rows) {
                $alias = 'p' . $pk;
                $mid_sql .= ' inner join ' . TABLE_PREFIX . '_goods_property_rel as ' . $alias . ' on g.id=' . $alias . '.goods_id and ' . $alias . '.vid in(';
                $pro_ids = array();
                foreach ($rows as $vk => $value) {
                    $pro_ids[] = $value['id'];
                }
                $mid_sql .= join(',', $pro_ids);
                $mid_sql .=')';
            }

            if ($tag_id) {
                $mid_sql .= ') inner join ' . TABLE_PREFIX . '_goods_tag_rel as t on t.goods_id = g.id and t.tag_id=' . $tag_id;
            } else if ($tag_ids) {
                $mid_sql .= ') inner join ' . TABLE_PREFIX . '_goods_tag_rel as t on t.goods_id = g.id and t.tag_id in(' . join(',', $tag_ids) . ')';
            }
            $mid_sql .= ') left join ' . TABLE_PREFIX . '_goods_language as l on l.goods_id = g.id where l.category_path like"' . $category['path_id'] . '%"';

            if ($brand_id) {
                $mid_sql .= ' and g.brand_id=' . $brand_id;
            } else if ($brand_ids) {
                $mid_sql .= " and g.brand_id in (" . join(',', $brand_ids) . ")";
            }
            $mid_sql .= '  AND l.language_id =' . $language_id . ' and g.status=1 and l.status=1';
            if($show_in_stock)
            {
                $mid_sql .= ' and g.stock_nums>0';
            }
            $count_sql = $sql . $mid_sql;
            $sqlmd5 = md5($count_sql);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count_array = $this->goodsJoinLangLogic->query($count_sql);
                $count = $count_array[0]['count'];
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $find_sql = 'SELECT distinct g.id AS id ' . $mid_sql . ' order by ' . $orderby . $seq . ' limit ' . ($curr_page - 1) * $page_size . ',' . $page_size;
            $goods_array = $this->goodsJoinLangLogic->query($find_sql);
            $goodsIds = array();
            foreach ($goods_array as $_v) {
                $goodsIds[] = $_v['id'];
            }
            if (count($goodsIds)) {
                $page_data = Common::getPages($count, $curr_page, $page_size);
                $where = 'l.goods_id in (' . implode(',', $goodsIds) . ') and l.language_id =' . $language_id . ' order by ' . $orderby . $seq;
                $goodsList = $this->goodsJoinLangLogic->getGoodsList($where, $curr_page);
            }
        } else if (!$category_id && $tags && !$property_ids) {
            $page_size = $cfg['sites'][$language_id]['tag_list_number'] ? $cfg['sites'][$language_id]['tag_list_number'] : 24;
            $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
            if (_g('oquery')) {
                if ($oquery[1])
                    $page_size = $oquery[1];
                $query = array(
                    'listorder' => $oquery[3] ? $oquery[3] : 1,
                    'order' => $oquery[2] ? $oquery[2] : 1,
                    'psize' => $page_size
                );
            }
            $cond = 't.tag_id=' . $tag_id;
            if ($brand_id) {
                $cond .= ' and g.brand_id=' . $brand_id;
            } else if ($brand_ids) {
                $mid_sql .= " and g.brand_id in (" . join(',', $brand_ids) . ")";
            }
            $cond .= '  AND l.language_id =' . $language_id . ' and g.status=1 and l.status=1';
            if($show_in_stock)
            {
                $cond .= ' and g.stock_nums>0';
                $query['in_stock'] = 1;
            }
            $tagRelGoodsJoinLanguageLogic = $this->load('tagRelGoodsJoinLanguage');
            $sqlmd5 = md5($cond);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count = $tagRelGoodsJoinLanguageLogic->getCount($cond);
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $cond .= ' order by ' . $orderby . $seq;
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $goodsList = $tagRelGoodsJoinLanguageLogic->getGoods($cond, $page_size, $curr_page);
            $goodsTagLogic = $this->load('GoodsTagJoinLanguage');
            $tag = $goodsTagLogic->getOne('l.language_id=' . $language_id . ' and ' . ' l.goods_tag_id=' . $tag_id);
            Core::$tpl->set('tag', $tag);
        } else if (!$category_id && !$tags && !$property_ids && $brand_id) {
            $page_size = $cfg['sites'][$language_id]['brands_list_number'] ? $cfg['sites'][$language_id]['brands_list_number'] : 24;
            $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
            if (_g('oquery')) {
                if ($oquery[1])
                    $page_size = $oquery[1];
                $query = array(
                    'listorder' => $oquery[3] ? $oquery[3] : 1,
                    'order' => $oquery[2] ? $oquery[2] : 1,
                    'psize' => $page_size
                );
            }
            $cond = 'g.brand_id=' . $brand_id;
            $cond .= '  AND l.language_id =' . $language_id . ' and g.status=1 and l.status=1';
            if($show_in_stock)
            {
                $cond .= ' and g.stock_nums>0';
                $query['in_stock'] = 1;
            }
            $sqlmd5 = md5($cond);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count = $this->goodsJoinLangLogic->getCount($cond);
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $cond .= ' order by ' . $orderby . $seq . ' limit ' . $page_size * ($curr_page - 1) . ',' . $page_size;
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $goodsList = $this->goodsJoinLangLogic->getGoodsList($cond, $curr_page);
            $brandLogic = $this->load('brandJoinLanguage');
            $brand = $brandLogic->getOne('l.language_id=' . $language_id . ' and ' . ' l.brand_id=' . $brand_id);
            Core::$tpl->set('brand', $brand);
        } else if (!$category_id && !$tags && !$brand_id && $property_ids[0]) {
            $page_size = $cfg['sites'][$language_id]['tag_list_number'] ? $cfg['sites'][$language_id]['tag_list_number'] : 24;
            $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
            if (_g('oquery')) {
                if ($oquery[1])
                    $page_size = $oquery[1];
                $query = array(
                    'listorder' => $oquery[3] ? $oquery[3] : 1,
                    'order' => $oquery[2] ? $oquery[2] : 1,
                    'psize' => $page_size
                );
            }
            $cond = 'p.vid=' . $property_ids[0];
            $cond .= '  AND language_id =' . $language_id . ' and g.status=1 ';
            if($show_in_stock)
            {
                $cond .= ' and g.stock_nums>0';
                $query['in_stock'] = 1;
            }
            $propertyRelGoodsJoinLanguageLogic = $this->load('PropertyRelGoodsJoinLanguage');
            $sqlmd5 = md5($cond);
            $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
            if (!$count) {
                $count = $propertyRelGoodsJoinLanguageLogic->getCount($cond);
                $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
            }
            $cond .= ' order by ' . $orderby . $seq;
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $goodsList = $propertyRelGoodsJoinLanguageLogic->getGoods($cond, $page_size, $curr_page);
            $property = $this->propertyLogic->getOneById($property_ids[0]);
            Core::$tpl->set('property', $property);
        }
        $goods_ids = array();
        foreach ($goodsList as $g) {
            $goods_ids[] = $g['id'];
        }
        $promotionsList = $this->load('offerJoinLanguage')->getPromotionsList($goods_ids, array($category_id), $brand_id, $language_id);
        Core::$tpl->set('goods_list', $goodsList);
        Core::$tpl->set('promotionsList', $promotionsList);
        Core::$tpl->set('current_category', $category_id);
        Core::$tpl->set('current_brand', $brand_id);
        Core::$tpl->set('current_tag', $tag_id);
        Core::$tpl->set('property_ids', $pids);
        Core::$tpl->set('brand_ids', $brand_ids);
        Core::$tpl->set('tag_ids', $tag_ids);
        Core::$tpl->set('oquery', $query);
        Core::$tpl->set('total', $count);
        Core::$tpl->set('pages', $page_data);
        if (!$category_id && !$tag_id && !$property_ids && $brand_id) {
            Core::$htmlFile = 'product/brandlist';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        } elseif (!$category_id && $tag_id && !$property_ids) {
            Core::$htmlFile = 'product/taglist';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }elseif (!$category_id && !$tags && !$brand_id && $property_ids[0]) {
            Core::$htmlFile = 'product/propertylist';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    else {
            Core::$htmlFile = !empty($category) && $category['template_page'] ? $category['template_page'] : 'product/list';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 点击主销售属性 读取信息
     */
    public function actionGetDataByMaster() {
        $language_id = $this->languageLogic->language_id;
        $goods_id = _p('goods_id') ? intval(_p('goods_id')) : 0;
        $property_id = _p('property_id') ? intval(_p('property_id')) : 0;
        $sale_id = _p('sale_id') ? intval(_p('sale_id')) : 0;
        $skulist = $this->productLogic->getSkusByMaster($goods_id, $property_id);
        $sale_property_ids = array();
        $sku_array = array();
        $product_id = 0;
        $current_sku = '';
        foreach ($skulist as $value) {
            $product_id = $value['product_id'];
            if (strpos($value['sku_code'], '_') !== FALSE) {
                if ($value['sku_code'] == $property_id . '_' . $sale_id) {
                    $current_sku = $value;
                }
                $sku_code_array = explode('_', $value['sku_code']);
                $sale_property_ids[] = $sku_code_array[1];
                $sku_array[$sku_code_array[1]] = $value['stock_nums'];
            } else {
                $current_sku = $value;
                $sale_property_ids[] = $value['sku_code'];
                $sku_array[$value['sku_code']] = $value['stock_nums'];
            }
        }
//商品图片
        $product = $this->productLogic->getOneById($product_id);
        $images = $this->imageLogic->getListByProductId($goods_id, $product_id);
//过滤重复图片
        $tempimagelist = array();
        foreach ($images as $ikey => $idata) {
            if (in_array($idata['image'], $tempimagelist)) {
                array_splice($images, $ikey, 1);
            } else {
                $tempimagelist[] = $idata['image'];
            }
        }
//查询所有的销售属性
        $sale_propertys = $this->goodsProRelLangLogic->getSalePropertys($goods_id, $language_id, 2);
        Common::sort_rows($sale_propertys, 'listorder', SORT_DESC);
        $sale_property_array = array();
        foreach ($sale_propertys as $key => $value) {
            $sale_property_array[$key] = array(
                'id' => $value['vid'],
                'base_name' => $value['base_name'],
                'stock' => isset($sku_array[$value['vid']]) ? $sku_array[$value['vid']] : 0,
                'showed' => in_array($value['vid'], $sale_property_ids) ? 1 : 0,
            );
        }
        $product['price'] = $this->toolPrice($current_sku ? $current_sku['price'] : $product['price']);
        $product['save'] = $this->toolPrice($current_sku ? $current_sku['old_price'] - $current_sku['price'] : $product['old_price'] - $product['price']);
        $product['discount'] = $current_sku ? round($product['save'] * 100 / $current_sku['market_price']) : round($product['save'] * 100 / $product['market_price']);
        $product['stock'] = $current_sku ? $current_sku['stock_nums'] : $product['stock'];
        $product['market_price'] = $this->toolPrice($current_sku ? $current_sku['market_price'] : $product['market_price']);
        $product['market_price'] = Common::getMarketPrice($product['price'], $product['market_price']);
        $return = array(
            'status' => 1,
            'product' => $product,
            'imagelist' => $images,
            'sale_property_list' => $sale_property_array
        );
        echo json_encode($return);
    }

    /**
     * 点击销售属性 读取信息
     */
    public function actionGetDataBySale() {
        $language_id = $this->languageLogic->language_id;
        $goods_id = _p('goods_id') ? intval(_p('goods_id')) : 0;
        $property_id = _p('property_id') ? intval(_p('property_id')) : 0;
        $master_sale_id = _p('master_sale_id') ? intval(_p('master_sale_id')) : 0;
        $skulist = $this->productLogic->getSkusBySale($goods_id, $property_id);
        $sale_property_ids = array();
        $sku_array = array();
        $product_id = 0;
        $current_sku = '';
        foreach ($skulist as $value) {
            $product_id = $value['product_id'];
            if (strpos($value['sku_code'], '_') !== FALSE) {
                if ($value['sku_code'] == $master_sale_id . '_' . $property_id) {
                    $current_sku = $value;
                }
                $sku_code_array = explode('_', $value['sku_code']);
                $sale_property_ids[] = $sku_code_array[0];
                $sku_array[$sku_code_array[0]] = $value['stock_nums'];
            } else {
                $current_sku = $value;
                $sale_property_ids[] = $value['sku_code'];
                $sku_array[$value['sku_code']] = $value['stock_nums'];
            }
        }
//单品列表
        $productList = $this->productLogic->getListByGoodsId($goods_id);
        $product = isset($productList[$master_sale_id]) ? $productList[$master_sale_id] : '';
//查询所有的主销售属性
        $sale_propertys = $this->goodsProRelLangLogic->getSalePropertys($goods_id, $language_id, 1);
        Common::sort_rows($sale_propertys, 'listorder', SORT_DESC);
        $sale_property_array = array();
        foreach ($sale_propertys as $key => $value) {
            $sale_property_array[$key] = array(
                'id' => $value['vid'],
                'base_name' => $value['base_name'],
                'stock' => isset($sku_array[$value['vid']]) ? $sku_array[$value['vid']] : 0,
                'showed' => in_array($value['vid'], $sale_property_ids) ? 1 : 0,
                'image' => isset($productList[$value['vid']]) ? $productList[$value['vid']]['image'] : '',
            );
        }
        if ($product) {
            $product['price'] = $current_sku ? $this->toolPrice($current_sku['price']) : $this->toolPrice($product['price']);
            $product['save'] = $this->toolPrice($current_sku ? $current_sku['market_price'] - $current_sku['price'] : $product['market_price'] - $product['price']);
            $product['discount'] = $current_sku ? round($product['save'] * 100 / $current_sku['market_price']) : round($product['save'] * 100 / $product['market_price']);
            $product['stock'] = $current_sku ? $current_sku['stock_nums'] : $product['stock'];
            $product['market_price'] = $this->toolPrice($current_sku ? $current_sku['market_price'] : $product['market_price']);
            $product['market_price'] = Common::getMarketPrice($product['price'], $product['market_price']);
        }
        $return = array(
            'status' => 1,
            'product' => $product ? $product : 1,
            'sale_property_list' => $sale_property_array,
        );
        echo json_encode($return);
    }

    /**
     * 商品评论
     * @return type
     */
    public function actionComment() {
        $user_id = $this->checkLogin();
        $goods_id = _g('goods_id');
        $goodsLogic = $this->load('goods');
        $goods = $goodsLogic->getOneById($goods_id);
        if (!$goods) {
            return $this->showMessage('illegal_parameters');
        }
        $base_name = _p('base_name');
        $detail = Common::strEscape(strip_tags(_p('detail')));
        $code = strtolower(_p('valid_code'));
        if (!$base_name) {
            return $this->showMessage('title_not_empty');
        }
        if (!$code || $code != strtolower(_s('validate_code'))) {
            return $this->showMessage('code_error_tips');
        }
        $user_nickname = Common::strEscape(strip_tags(_p('nickname')));
        $ipJoinCountryLogic = $this->load('ipJoinCountry');
        $commentLogic = $this->load('goodsComment');
        $ip = Common::_ip2long(Common::ip());
        $value = Common::queryInt(_p('score'));
        $comment_data = array(
            'goods_id' => $goods_id,
            'value' => $value,
            'base_name' => Common::strEscape($base_name),
            'detail' => Common::strEscape($detail),
            'user_id' => $user_id ? $user_id : 0,
            'ip' => $ip,
            'country_id' => $ipJoinCountryLogic->getCountryId($ip),
            'domain' => SITE_PROTOCOL . SITE_URL,
            'reply_nickname' => $user_nickname,
            'Language_id' => $this->languageLogic->language_id,
            'user_email' => _p('user_email'),
            'create_time' => SYS_TIME,
        );
        $c_res = $commentLogic->save($comment_data);

        if ($c_res) {
            $this->load('goods')->updateCommentCount($goods_id);
            return $this->success('save_success');
        } else {
            return $this->showMessage('save_failure');
        }
    }

    /**
     * 商品评论
     * @return type
     */
    public function actionAjaxComment() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $user_id = $this->checkLogin();
        $goods_id = _p('goods_id');
        $goodsLogic = $this->load('goods');
        $goods = $goodsLogic->getOneById($goods_id);
        $status = 0;
        if (!$goods) {
            $msg = $lang['illegal_parameters'];
        }
        $base_name = Common::strEscape(strip_tags(_p('nickname')));
        $detail = Common::strEscape(strip_tags(_p('detail')));

        if (!$base_name) {
            $msg = $lang['title_not_empty'];
        }
        if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code'))) {
            $msg = $lang['code_error_tips'];
        } else {
            $user_nickname = Common::strEscape(strip_tags(_p('nickname')));
            $ipJoinCountryLogic = $this->load('ipJoinCountry');
            $commentLogic = $this->load('goodsComment');
            $ip = Common::_ip2long(Common::ip());
            $value = Common::queryInt(_p('score'));
            $comment_data = array(
                'goods_id' => $goods_id,
                'value' => $value,
                'base_name' => $base_name,
                'detail' => $detail,
                'user_id' => $user_id ? $user_id : 0,
                'user_name' => $user_nickname,
                'ip' => $ip,
                'country_id' => $ipJoinCountryLogic->getCountryId($ip),
                'domain' => SITE_URL,
                'reply_nickname' => '',
                'Language_id' => $this->languageLogic->language_id,
                'user_email' => _p('user_email'),
                'create_time' => SYS_TIME,
            );
            $c_res = $commentLogic->save($comment_data);

//更新商品
            if ($c_res) {
                $this->load('goods')->updateCommentCount($goods_id);
//删除缓存
                $this->load('goodsLanguage')->updateCache($goods_id);
                $status = 1;
            } else {
                $status = 0;
            }
        }
        $return = array(
            'status' => $status,
            'msg' => $msg,
        );
        echo json_encode($return);
        exit;
    }

    /**
     * 商品评论列表
     * @return type
     */
    public function actionCommentList() {
        global $cfg, $site_info;
        $page_size = 20;
        $goods_id = Common::queryInt(_g('goods_id'), 0);
        $curr_page = Common::queryInt(_g('page'), 1);
        $goodsLogic = $this->load('goods');
        $goods = $goodsLogic->getOneById($goods_id);
        if (!$goods) {
            return $this->showMessage('illegal_parameters');
        }
        $language_id = $this->languageLogic->language_id;
//商品详细页
        $detail = $this->goodsJoinLangLogic->getDetailByGoodsId($goods_id, $language_id);
        if (!$detail) {
            $this->exception();
        }
        $goods = $detail['goods'];
        $category_ids = $detail['category_ids'];

        $where = "1=1 ";
        $where .= "and goods_id =" . $goods_id;
        $where .= " and status = 1";
        $where .= " order by is_admin_readed asc,id desc";
        $commentLogic = $this->load('GoodsComment');
        $rating = $this->commentRating($goods_id, $where);
        $page_size = $cfg['sites'][$language_id]['comment_list_number'] ? $cfg['sites'][$language_id]['comment_list_number'] : $page_size;
        $page_data = Common::getPages($rating['count'], $curr_page, $page_size, $prev, $next);
        $comments = $commentLogic->getCurrentDatas($where, $page_size, $curr_page);
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('1=1', true);
        Core::$tpl->set('theme_name', $site_info['theme_name']);
        Core::$tpl->set('goods', $goods);
        Core::$tpl->set('category_ids', $category_ids);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set("comments", $comments);
        Core::$tpl->set('rating', $rating['rating']);
        Core::$tpl->set("pages", $page_data);
        Core::$htmlFile = 'product/commentlist';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 所有商品评论列表
     * @return type
     */
    public function actionCommentAll() {
        global $cfg;
        $category_id = Common::queryInt(_g("category_id"));
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        $GoodsCategoryLogic = $this->load("GoodsCategory");
        $commonLogic = $this->load("CommonJoinGoodsLangeageJoinGoods");
        $language_id = $this->languageLogic->language_id;
        if ($category_id === 0) {
            $where = "l.language_id=" . $language_id . " and c.status=1 order by c.id desc";
            $count = $commonLogic->getCount($where);
            $result = $commonLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else {
            $Category = $GoodsCategoryLogic->getOneById($category_id);
            $where = 'l.category_path like "' . $Category['path_id'] . '%" and c.status=1 and l.language_id=' . $language_id . ' order by c.id desc';
            $count = $commonLogic->getCount($where);
            $result = $commonLogic->getCurrentDatas($where, $page_size, $curr_page);
        }
        //评论
      
        $page_data = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('Category', $Category);
        Core::$tpl->set('result', $result);
        Core::$tpl->set('pages', $page_data);
        Core::$htmlFile = 'product/commentall';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 关键字搜索
     * WHERE MATCH(content) AGAINST ('search keyword' IN BOOLEAN MODE)
     */
public function actionSearch() {
        $category_id = Common::queryInt(_g('category_id'));
        $keywords = Common::strEscape(strip_tags(_g('keywords')));
        $tag = _g('tag');
        if (!$keywords) {
            return $this->showMessage('not_keywords');
        }
        $language_id = $this->languageLogic->language_id;
        $keywordsurlLogic = $this->load("keywordsurl");
        $keywordsurl = $keywordsurlLogic->getOne(" base_name like '" . $keywords . "' and type=0 and status=1 and (language_id=0 or language_id=" . $language_id . ")");

        if ($keywordsurl) {
            $reslut = array(
                'user_id' => $this->checkLogin(),
                'result_ids' => '',
                'result_num' => -1,
            );
            ReportFactory::userKeywords($keywords, $reslut);
        }

        if ($keywordsurl) {
            self::_redirect($keywordsurl['query_name']);
            die();
        } else {
            $keywordsurl_query = $keywordsurlLogic->getOne(" base_name like '" . $keywords . "' and type=1 and status=1 and (language_id=0 or language_id=" . $language_id . ")");
            if ($keywordsurl_query) {
                $keywordsurl = $keywordsurlLogic->getOne(" base_name like '" . $keywordsurl_query['query_name'] . "' and type=0 and status=1 and (language_id=0 or language_id=" . $language_id . ")");
                if ($keywordsurl) {
                    self::_redirect($keywordsurl['query_name']);
                    die();
                }
            }
        }

        $cond = ' l.search_keyword like "%' . $keywords . '%"';

        global $cfg;
        $orderby = isset($cfg['sites'][0]['goods_default_sort']) ? $cfg['sites'][0]['goods_default_sort'] : 'goods_id ';
        $seq = ' desc';
        $orderby = $orderby == 'create_time' ? 'l.goods_id' : 'l.' . $orderby;
        if ($tag == 1 && $keywords != "") {
            if ($keywords == '0-9') {
                $cond = ' (l.search_keyword like "' . 0 . '%" or ';
                $cond .= ' l.search_keyword like "' . 1 . '%" or ';
                $cond .= ' l.search_keyword like "' . 2 . '%" or ';
                $cond .= ' l.search_keyword like "' . 3 . '%" or ';
                $cond .= ' l.search_keyword like "' . 4 . '%" or ';
                $cond .= ' l.search_keyword like "' . 5 . '%" or ';
                $cond .= ' l.search_keyword like "' . 6 . '%" or ';
                $cond .= ' l.search_keyword like "' . 7 . '%" or ';
                $cond .= ' l.search_keyword like "' . 8 . '%" or ';
                $cond .= ' l.search_keyword like "' . 9 . '%" )';
            } else {
                $cond = ' l.search_keyword like "' . $keywords . '%"';
            }
        } else if (strlen($keywords) == 1) {
            $cond = ' l.search_keyword like "' . $keywords . '%"';
        } else if ($cfg['sites'][0]['search_type'] == 2 || $cfg['sites'][0]['search_type'] == 3) {
            if ($cfg['sites'][0]['search_type'] == 2) { //同时匹配（模糊LIKE）
                $likewords_arr = explode(' ', $keywords); 
                $like_keywords = ' ( ';
                $likewords_arr_count = count($likewords_arr);
                foreach ($likewords_arr as $key => $value) {
                    if ($key < $likewords_arr_count - 1) {
                        $like_keywords .= ' l.search_keyword like "%' . $value . '%" and ';
                    } else {
                        $like_keywords .= ' l.search_keyword like "%' . $value . '%") ';
                    }
                }
                $cond = $like_keywords;
            } else {
                $likewords_arr = explode(' ', $keywords); //匹配其中之一 (模糊LIKE)
                $like_keywords = ' ( ';
                $likewords_arr_count = count($likewords_arr);
                foreach ($likewords_arr as $key => $value) {
                    if ($key < $likewords_arr_count - 1) {
                        $like_keywords .= ' l.search_keyword like "%' . $value . '%" or ';
                    } else {
                        $like_keywords .= ' l.search_keyword like "%' . $value . '%") ';
                    }
                }
                $cond = $like_keywords;
            }
            $orderby = 'l.goods_id ';
        } else {
            if ($cfg['sites'][0]['search_type']) {
//同时满足多个关键词
                $keywords_arr = explode(' ', $keywords);
                foreach ($keywords_arr as $key => $value) {
                    $new_keywords .= '+' . $value . ' ';
                }
            } else {
                $new_keywords = $keywords;
            }
            $cond = 'MATCH(l.search_keyword)  AGAINST("' . $new_keywords . '" IN BOOLEAN MODE ) ';
//默认按全文索引排序
            $orderby = 'MATCH(l.search_keyword)  AGAINST("' . $new_keywords . '" IN BOOLEAN MODE ) desc,l.listorder ';
        }
//分页用的参数
        $page_size = $cfg['sites'][$language_id]['search_list_number'] ? $cfg['sites'][$language_id]['search_list_number'] : 24;
        $query = array('listorder' => 1, 'order' => 0, 'psize' => $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        if (_g('oquery')) {
            $oquery = explode('-', _g('oquery')); //oquery = 1-2-3-4 (展示方式-显示数量-字段-升降)
            $seq = $oquery[3] == 1 ? ' desc' : ' asc';
            if ($oquery[1])
                $page_size = $oquery[1];
            switch ($oquery[2]) {
                case 1:
                    $orderby = 'l.up_time desc,l.listorder ';
                    $seq = 'desc';
                    break;
                case 2:
                    $orderby = 'g.price ';
                    $seq = $oquery[3] == 1 ? ' desc' : ' asc';
                    break;
                case 3:
                    $orderby = 'g.buy_counts ';
                    break;
                case 4:
                    $orderby = 'g.comment_counts ';
                    break;
                case 5:
                    $orderby = 'g.wishlist_counts ';
                    break;
                case 6:
                    $orderby = 'g.visit_counts ';
                    break;
                default :break;
            }
            $query = array(
                'listorder' => $oquery[3] ? $oquery[3] : 1,
                'order' => $oquery[2] ? $oquery[2] : 0,
                'psize' => $page_size
            );
            //只显示有货
            if($oquery[4])
            {
                $cond .= ' and g.stock_nums>0';
                $query['in_stock'] = 1;
            }
        }
        $language_id = $this->load('language')->language_id;
        $category = array();
        if ($category_id) {
            $ccond = 'l.goods_category_id=' . $category_id . ' and l.language_id=' . $language_id;
            $categoryLogic = $this->load('goodsCategoryJoinLang');
            $category = $categoryLogic->getOne($ccond);
            if (!$category) {
                return $this->notice('not_found');
            }
        }
        if ($category_id) {
            $cond .= ' and l.category_path like"' . $category['path_id'] . '%"';
        }
        $cond .= '  AND l.language_id =' . $language_id . ' and l.status=1';
        
        //$cond_count = str_replace('l.', '', $cond); 
        $cond_count = $cond;
        $count_array = $this->goodsJoinLangLogic->getOne($cond_count, array('count(*) as count'));
        $count = $count_array['count'];

        //更新到搜索推荐表
        if($count){
        $searchKeywordsLogic = $this->load('searchkeywords');
        $s_map = Zhtx::createDataMap();
        $s_map->addEntry('result_num', $count, DB::INT);
        $searchKeywordsLogic->update($s_map,"base_name='".$keywords."'");
        }
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $cond .= ' order by ' . $orderby . $seq . ' limit ' . ($curr_page - 1) * $page_size . ',' . $page_size;
        $goodsList = $this->goodsJoinLangLogic->getGoodsList($cond, $page_size, $curr_page);

        $goods_ids = array();
        foreach ($goodsList as $g) {
            $goods_ids[] = $g['id'];
        }
        $promotionsList = $this->load('offerJoinLanguage')->getPromotionsList($goods_ids, array($category_id), 0, $language_id);
        $related_searches_list_number = $cfg['sites'][$language_id]['related_searches_list_number'] ? $cfg['sites'][$language_id]['related_searches_list_number'] : 12;
        $cond = 'MATCH(base_name)  AGAINST("' . $keywords . '" IN BOOLEAN MODE )  ORDER BY MATCH(base_name)  AGAINST("' . $keywords . '" IN BOOLEAN MODE ) desc,listorder desc limit ' . $related_searches_list_number;
        $related_searches = $this->load('searchkeywords')->getList($cond);
        Core::$tpl->set('related_searches', $related_searches);
        Core::$tpl->set('goods_list', $goodsList);
        Core::$tpl->set('promotionsList', $promotionsList);
        Core::$tpl->set('current_category', $category_id);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('oquery', $query);
        Core::$tpl->set('keywords', Common::jsUnescape($_GET['keywords']));
        Core::$tpl->set('count', $count);

        Core::$htmlFile = 'product/search_list';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        if ($keywords && strlen($keywords)>1 && $keywords!="0-9") {
            $reslut = array(
                'user_id' => $this->checkLogin(),
                'result_num' => $count,
            );
            ReportFactory::userKeywords($keywords, $reslut);
        }
    }

    /**
     * 检测是否有库存
     */
    public function actionCheckStock() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $master_id = _p('master_sale_id');
        $sale_id = _p('sale_id');
        $goods_id = _p('goods_id');
        $qty = Common::queryInt(_p('qty')) + 1;
        $sku_code = $master_id . '_' . $sale_id;
        $cond = 'goods_id =' . $goods_id . ' and sku_code="' . $sku_code . '"';
        $sku = $this->load('sku')->getOne($cond);
        $status = 1;
        $msg = '';
        $cartJoinSkuLogic = $this->load('cartJoinSku');
        $cartdata = $cartJoinSkuLogic->getListByUserId($this->checkLogin(), $this->load('language')->language_id);
        foreach ($cartdata as $value) {
            if ($goods_id == $value['goods_id'] && $sku_code == $value['sku_code']) {
                $qty += $value['product_num'];
                break;
            }
        }
        if ($sku) {
            if ($qty > $sku['stock_nums']) {
                $status = 0;
                $msg = $lang['not_enough_stock'];
            }
        } else {
            $status = 0;
            $msg = $lang['illegal_parameters'];
        }
        echo json_encode(array('status' => $status, 'msg' => $msg));
    }

    /**
     * 登记到货通知
     */
    public function actionArrivalNotice() {
        $goods_id = _p('goods_id');
        $mask_id = _p('master_sale_id');
        $sale_id = _p('sale_id');
        $email = _p('email');
        $code = _p('code');
        if (!$email || !Common::isEmail($email)) {
            echo json_encode(array('status' => 0, 'msg' => 'Please enter your e-mail correctly'));
            return;
        }
        if (!$code || strtolower($code) != strtolower(_s('validate_code'))) {
            echo json_encode(array('status' => 0, 'msg' => 'Please enter code correctly'));
            return;
        }
        $sku_code = $mask_id . '_' . $sale_id;
        $outStockLogic = $this->load('outStock');
        $attr = $this->load('property')->getSkuAttr($sku_code);
        $out_stock_data = array(
            'order_id' => 0,
            'goods_id' => $goods_id,
            'order_item_id' => 0,
            'base_name' => _p('goods_name'),
            'sku_code' => $sku_code,
            'sku_info' => $attr,
            'is_stock' => 0,
            'is_send' => 0,
            'num' => 1,
            'user_id' => $this->checkLogin(),
            'email' => $email,
            'create_time' => SYS_TIME,
        );
        $res = $outStockLogic->save($out_stock_data);
        if ($res) {
            echo json_encode(array('status' => 1, 'msg' => 'Submit Successfully'));
            return;
        }
        echo json_encode(array('status' => 0, 'msg' => 'Sorry,Registration is failure'));
        return;
    }

    public function actionAutocomplete() {
        $language_id = $this->languageLogic->language_id;
        $searchkeywordsLogic = $this->load("searchkeywords");
        $keywords = trim(_g('query'));
        if ($keywords) {
            global $cfg;
            $limit = $cfg['sites'][$language_id]['search_autocomplete_number'] ? $cfg['sites'][$language_id]['search_autocomplete_number'] : 10;
            $cond = 'base_name like "' . $keywords . '%" and status=1 and (language_id=0 or language_id=' . $language_id . ') ';
            $orderby = ' order by listorder desc,search_num desc limit ' . $limit;
            $searchkeywords_list = $searchkeywordsLogic->findAll($cond . $orderby, false, '', array('id', 'base_name'));
            if ($searchkeywords_list) {
                $searchkeywords = array();
                $searchkeywords['query'] = $keywords;
                foreach ($searchkeywords_list as $key => $rows) {
                    $searchkeywords['suggestions'][] = $rows['base_name'];
                    $searchkeywords['data'][] = $rows['base_name'];
                }
                echo json_encode($searchkeywords);
            }
        }
    }

    public function commentRating($goods_id, $where = '') {
        $commentLogic = $this->load('GoodsComment');
        $count = $commentLogic->getCount($where);
        $rating = array(0, 0, 0, 0, 0);
        $rating[0] = $commentLogic->getCount("1=1 and goods_id =" . $goods_id . " and value=0 and status = 1");
        $rating[1] = $commentLogic->getCount("1=1 and goods_id =" . $goods_id . " and value=1 and status = 1");
        $rating[2] = $commentLogic->getCount("1=1 and goods_id =" . $goods_id . " and value=2 and status = 1");
        $rating[3] = $commentLogic->getCount("1=1 and goods_id =" . $goods_id . " and value=3 and status = 1");
        $rating[4] = $commentLogic->getCount("1=1 and goods_id =" . $goods_id . " and value=4 and status = 1");
        $rating[5] = $commentLogic->getCount("1=1 and goods_id =" . $goods_id . " and value=5 and status = 1");
        $rating[6] = ($rating[1] * 1 + $rating[2] * 2 + $rating[3] * 3 + $rating[4] * 4 + $rating[5] * 5) / ($rating[0] + $rating[1] + $rating[2] + $rating[3] + $rating[4] + $rating[5]);
        $rating[7] = $rating[6] > 0 ? $rating[6] : 0;
        $rating[7] = round($rating[7], 1);
        $rating[6] = floor($rating[6]);
        $rating[8] = $rating[0] + $rating[1] + $rating[2] + $rating[3] + $rating[4] + $rating[5];
        $res = array(
            'rating' => $rating,
            'count' => $count
        );
        return $res;
    }

    /**
     * 分享产品
     */
    public function actionShare() {
        $language_id = $this->languageLogic->language_id;
        $goods_id = Common::queryInt(_g('goods_id'), 0);
//商品详细页
        $detail = $this->goodsJoinLangLogic->getDetailByGoodsId($goods_id, $language_id);
        if (!$detail) {
            return '';
        }
        $goods = $detail['goods'];
        Core::$tpl->set('goods', $goods);
    }

    public function actionMiniDetail() {
        $language_id = $this->languageLogic->language_id;
        $goods_id = Common::queryInt(_g('goods_id'), 0);
        $source_user = Common::queryInt(_g('source_user'), 0);
        $source = Common::queryStr(_g('source'));
//商品详细页
        $detail = $this->goodsJoinLangLogic->getDetailByGoodsId($goods_id, $language_id);
        if (!$detail) {
            return '';
        }
        $goods = $detail['goods'];
        Core::$tpl->set('goods', $goods);
        Core::$tpl->set('source_user', $source_user);
        Core::$tpl->set('source', $source);
    }

        public function actionAllList() {
        global $cfg;
        $language_id = $this->languageLogic->language_id;
        $orderby = isset($cfg['sites'][0]['goods_default_sort']) ? $cfg['sites'][0]['goods_default_sort'] : 'goods_id ';
        $seq = ' desc';
        $orderby = $orderby == 'create_time' ? 'l.goods_id' : 'l.' . $orderby;
        //分页用的参数        
        $page_size = $cfg['sites'][$language_id]['special_list_number'] ? $cfg['sites'][$language_id]['special_list_number'] : 24;
        $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $in_stock_cond = '';
        if (_g('oquery')) {
            $oquery = explode('-', _g('oquery')); //oquery = 1-2-3-4 (展示方式-显示数量-字段-升降)
            $seq = $oquery[3] == 1 ? ' desc' : ' asc';
            if ($oquery[1])
                $page_size = $oquery[1];
            switch ($oquery[2]) {
                case 1:
                    $seq = ' desc';
                    break;
                case 2:
                    $orderby = 'g.price ';
                    break;
                case 3:
                    $orderby = 'g.buy_counts ';
                    break;
                case 4:
                    $orderby = 'g.comment_counts ';
                    break;
                case 5:
                    $orderby = 'g.wishlist_counts ';
                    break;
                case 6:
                    $orderby = 'g.visit_counts ';
                    break;
                case 7:
                    $orderby = 'l.goods_id ';
                    $seq = ' desc';
                    break;
                default :break;
            }
            $query = array(
                'listorder' => $oquery[3] ? $oquery[3] : 1,
                'order' => $oquery[2] ? $oquery[2] : 1,
                'psize' => $page_size
            );
            //只显示有货
            if ($oquery[4]) {
                $in_stock_cond = ' and g.stock_nums>0 ';
                $query['in_stock'] = 1;
            }
        }
        $count_sql = 'select count(g.id) as count from ' . TABLE_PREFIX . '_goods_language l left join ' . TABLE_PREFIX . '_goods g on l.goods_id=g.id and l.status=1 and l.language_id=' . $language_id . $in_stock_cond;

        $sqlmd5 = md5($count_sql);
        $count = $this->goodsJoinLangLogic->getCountByKey($sqlmd5);
        if (!$count) {
            $count_array = $this->goodsJoinLangLogic->query($count_sql);
            $count = $count_array[0]['count'];
            $this->goodsJoinLangLogic->getCountByKey($sqlmd5, $count);
        }
        $where = 'l.status=1 and l.language_id=' . $language_id . $in_stock_cond . ' order by ' . $orderby . $seq;
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $goodsList = $this->goodsJoinLangLogic->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set('allproduct', 1);
        Core::$tpl->set('goods_list', $goodsList);
        Core::$tpl->set('oquery', $query);
        Core::$tpl->set('total', $count);
        Core::$tpl->set('pages', $page_data);
        Core::$htmlFile = 'product/alllist';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }
	
	
	public function actionHistory()
	{
		$lang = Common::lang(Core::$controller, Core::$module, Core::$language);
		Core::$tpl->set('seo_title', $lang['your_recent_history'] . ' - ' . $_SERVER['SERVER_NAME']);
	}
    
}

?>