<?php

/**
 * Description of QuickOrder
 *
 * @author NT
 */
class QuickOrderController extends AppController {

    private $orderLogic;
    private $orderItemLogic;
    private $langLogic;
    private $skuJoinGoodsLogic;
    private $user_id;
    private $language_id;

    public function __construct() {
        parent::__construct();
        $this->orderLogic = $this->load('order');
        $this->orderItemLogic = $this->load('orderItem');
        $this->propertyLogic = $this->load('property');
        $this->langLogic = $this->load('language');
        $this->skuJoinGoodsLogic = $this->load('skuJoinGoods');
        $this->user_id = $this->checkLogin();
        $this->language_id = $this->langLogic->language_id;
        $this->creditSettingLogic = $this->load('creditSetting');
        ignore_user_abort(true);
        set_time_limit(0);
    }

    /**
     * 快速购买
     * @return type 
     */
    public function actionAdd() {
        global $cfg, $current_currency;
        $billing_display=isset($cfg['sites'][0]['billing_display']) ? $cfg['sites'][0]['billing_display'] : 0;
        $sku_id = _g('sku_id');
        $sku_num = _g('sku_num');
        $type = _g('type');
        if (!$sku_id || !$sku_num || !$type)
        {
            return $this->showMessage('illegal_parameters', '/');
        }
        $package_id = _g('package_id');
        $user_id = $this->user_id;
        if (!$user_id) {
            $ref = urlencode(Common::getUrl());
            return $this->_redirect(Common::frontURL('home', 'user', 'login', array('ref' => $ref)));
        }
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        if (_p()) {
            //下单
            $params = array(
                'address_id' => Common::queryInt(_p('shipping_address')),
                'shipping_id' => Common::queryInt(_p('shipping_id')),
                'payment_id' => Common::queryInt(_p('payment_id')),
                'order_remark' => Common::strEscape(strip_tags(_p('order_remark'))),
                'use_credit' => _p('use_credit'),
                'insurance' => _p('insurance'),
                'sku_id' => $sku_id,
                'sku_num' => $sku_num,
                'type' => $type,
                'package_id' => $package_id,
                'billing_address_id' => Common::queryInt(_p('billing_address_id'),0),
            );
            $order = $this->insertOrder($params);
            if ($order['key']) {
                return $this->showMessage($order['key'], Common::frontURL('home', 'cart', 'list'));
            } else {
                if ($order['payment_id']) {
                    return $this->_redirect(Common::frontURL('home', 'order', 'payment', array('itemno' => $order['itemno'])));
                } else {
                    return $this->_redirect(Common::frontURL('home', 'order', 'step2', array('itemno' => $order['itemno'])));
                }
            }
            return $this->showMessage('save_failure');
        } else {
            //订单提交页面
            $language_id = $this->language_id;
            $params = array(
                'sku_id' => $sku_id,
                'sku_num' => $sku_num,
                'type' => $type,
                'package_id' => $package_id,
            );
            $cartInfo = $this->getGoodsInfo($params, $user_id, $language_id, false);
            if(Common::toolPrice($cfg['sites'][0]['moq']) > $cartInfo['subtotalprice']){
                Common::alertRedirect(str_replace("{0}",_s("symbol_left").' '.Common::toolPrice($cfg['sites'][0]['moq']) , $lang['moq_notics']),  'shopcart.html');
            }
            if (count($cartInfo['orderitems']) <= 0)
            {
                return $this->_redirect(_g('ref'));
            }
            foreach ($cartInfo['orderitems'] as $key => $value) {
                if($value['stock_nums']=='' || $value['stock_nums']<=0) {
                    Common::alertRedirect($lang['cart_out_of_stock'],  _g('ref'));
                }
            }
            $userAddressCountryLogic = $this->load('userAddressCountry');
            $userAddress = array();
            if ($user_id)
            {
                $userAddress = $userAddressCountryLogic->getListByUserId($user_id);
                $userBillingAddress = $userAddressCountryLogic->getListByUserId($user_id,1);
            }
            $contryLogic = $this->load('country');
            $countrylist = $contryLogic->getCountries();
            $this->load('creditDetail')->checkCredit(); //检测及清理过期积分 
            Core::$tpl->set('countrylist', $countrylist);
            Core::$tpl->set('orderitems', $cartInfo['orderitems']);
            Core::$tpl->set('addresslist', $userAddress);
            Core::$tpl->set('billingaddresslist', $userBillingAddress);
            Core::$tpl->set('cart_save', $cartInfo['cart_save'] + $cartInfo['offer_save']);
            Core::$tpl->set('final_qty', $cartInfo['final_qty']);
            Core::$tpl->set('totalprice', $cartInfo['totalprice']);
            Core::$tpl->set('productprice', $cartInfo['subtotalprice']+$cartInfo['cart_save'] + $cartInfo['offer_save']);
            Core::$tpl->set('subtotalprice', $cartInfo['subtotalprice']);
            Core::$tpl->set('cart_gift', $cartInfo['cart_gift']);
            Core::$tpl->set('totalweight', $cartInfo['totalweight']);
        }
        $contryLogic = $this->load('country');
        $countrylist = $contryLogic->getCountries();
        $creditSetting = $this->creditSettingLogic->getOne();
        Core::$tpl->set('creditSetting', $creditSetting);
        $this->load('creditDetail')->checkCredit(); //检测及清理过期积分
        //根据sku_code查询sku的codeno
        $skuLogic = $this->load('sku');
        foreach ($cartInfo['orderitems'] as $key => $value) {
            if($value['sku_code'] && $value['goods_id']){
                $sku = $skuLogic->getOne('goods_id=' . $value['goods_id'] . ' and sku_code="' . $value['sku_code'] . '"');
                if($sku['codeno']){
                    $cartInfo['orderitems'][$key]['sku_codeno']=$sku['codeno'];
                }else{
                    $cartInfo['orderitems'][$key]['sku_codeno']='';
                }
            }else{
                    $cartInfo['orderitems'][$key]['sku_codeno']='';
            }
        }
        Core::$tpl->set('billing_display', $billing_display);
        Core::$tpl->set('countrylist', $countrylist);
        Core::$tpl->set('orderitems', $cartInfo['orderitems']);
        Core::$tpl->set('addresslist', $userAddress);
        Core::$tpl->set('cart_save', $cartInfo['cart_save'] + $cartInfo['offer_save']);
        Core::$tpl->set('final_qty', $cartInfo['final_qty']);
        Core::$tpl->set('totalprice', $cartInfo['totalprice']);
        Core::$tpl->set('subtotalprice', $cartInfo['subtotalprice']);
        Core::$tpl->set('cart_gift', $cartInfo['cart_gift']);
        Core::$tpl->set('totalweight', $cartInfo['totalweight']);
    }

    public function insertOrder($params) {
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $user_id = $this->user_id;
        if (!$user_id) {
            return array('key' => 'User_Error');
        }
        $userAddressLogic = $this->load('userAddress');
        $shippingLogic = $this->load('shipping');
        $address_id = $params['address_id'];
        $shipping_id = $params['shipping_id'];
        $payment_id = $params['payment_id'];
        $order_remark = $params['order_remark'];
        $billing_address_id = $params['billing_address_id'];
        $address = $userAddressLogic->getOneById($address_id);
        if (!$address_id || !$address || $address['user_id'] != $user_id || !$address['country_id']) {
            return array('key' => 'illegal_parameters');
        }
        if($billing_address_id)
        {
            $billingaddress = $userAddressLogic->getOneById($billing_address_id);
            if (!$billingaddress || $billingaddress['user_id'] != $user_id || !$billingaddress['country_id'])
            {
                return array('key' => 'Bill_Address_Error');
            }
        }
        $shipping = $shippingLogic->getOneById($shipping_id);
        if (!$shipping_id || !$shipping) {
            return array('key' => 'Address_Error');
        }
        $language_id = $this->language_id;
        $cartInfo = $this->getGoodsInfo($params, $user_id, $language_id, false);
        if (count($cartInfo['orderitems']) <= 0) {
            return array('key' => 'Cart_Empty');
        }
        $shipping_fee = 0;
        if (!$cartInfo['free_ship']) {
            $cart_param = array(
                'totalweight' => $cartInfo['totalweight'],
                'totalprice' => isset($cartInfo['subtotalprice']) ? $cartInfo['subtotalprice'] : $cartInfo['totalprice'],
                'totalnumber' => $cartInfo['totalqty'],
                'totalvweight' => 0,
            );
            $order_goods_ids = array();
            $order_goods_qtys = array();
            $order_goods_sku_ids = array();
            foreach ($cartInfo['orderitems'] as $item)
            {
                $order_goods_ids[] = $item['goods_id'];
                $order_goods_qtys[$item['goods_id']] = isset($order_goods_qtys[$item['goods_id']]) ? $order_goods_qtys[$item['goods_id']] + $item['qty'] : $item['qty'];
                $order_goods_sku_ids[] = $item['sku_id'];
				$order_sku_qtys[$item['sku_id']] =  $item['qty'];
            }
            $free_shipping = $this->load('SpecialOfferShippingJoinGoods')->getShippingInfo($order_goods_ids, $order_sku_qtys, $order_goods_sku_ids);

            if (isset($free_shipping[$shipping_id])) {
                if ($free_shipping[$shipping_id]['free_shipping_type'] == 1) {
                    $cart_param['totalweight'] = 0;
                    $cart_param['totalnumber'] = 0;
                    $cost = 0;
                } else {
                    $cart_param['totalweight'] = $cartInfo['totalweight'] - $free_shipping[$shipping_id]['weight'];
                    $cart_param['totalnumber'] = $cartInfo['totalqty'] - $free_shipping[$shipping_id]['num'];
                    $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
                }
            }
            else
            {
                $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
            }
            if ($cost === FALSE) {
                return array('key' => 'illegal_parameters');
            }
            $shipping_fee = $this->toolPrice($cost);
        }
        global $current_currency;
        $ipJoinCountryLogic = $this->load('ipJoinCountry');
        $ip = Common::_ip2long(Common::ip());
        $domain = SITE_URL;
        $country_id = $ipJoinCountryLogic->getCountryId($ip);
        $order_itemno = date('ymdhsi');
        $insurance_fee = 0;
        if (_p('insurance')) {
            //运费险
            $insuranceLogic = $this->load('InsuranceJoinLanguage');
            $insurance = $insuranceLogic->getConfig($this->language_id);
            $insurance_param = array(
                'order_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE) + $this->toolPrice($shipping_fee, TRUE),
                'goods_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE),
                'shipping_fee' => $this->toolPrice($shipping_fee, TRUE),
            );
            $insurance_fee = $insuranceLogic->getCost($insurance_param, $insurance['formula_param'], $insurance['formula']);
            $insurance_fee = $this->toolPrice($insurance_fee);
        }
        //积分处理 
        $exp_amout = 0;
        $use_credit = 0;
        if ($params['use_credit']) {
            if (!is_numeric($params['use_credit'])) {
                return array('key' => 'use_credit_illegal_characters');
            }
            $use_credit = Common::queryInt($params['use_credit']);
            $user = $this->load('user')->getOneById($user_id);
            $creditSettingLogic = $this->load('creditSetting');
            $creditInfo = $creditSettingLogic->getCreditInfo($user['credit'], $cartInfo['subtotalprice'], $cartInfo['subtotalprice'] + $shipping_fee);
            if ($use_credit > $creditInfo['max_exp_credit']) {
                return array('key' => 'use_credit_overlow');
            }
            $exp_amout = $this->toolPrice($use_credit / $creditInfo['exchange_credit_scale']);
        }
        //支付手续费处理
        $payment_fee = 0;
        if ($params['payment_id']) {

            $paymentLogic = $this->load('payment');
            $cond = '(language_id=0 or language_id=' . $this->language_id . ') and status=1 and id=' . $payment_id . ' order by listorder asc';
            $payment = $paymentLogic->getOne($cond);
            if ($payment) {
                $temptotalprice = $cartInfo['subtotalprice'] + $shipping_fee + $insurance_fee - $exp_amout;
                $order_param = array(
                    'totalprice' => $this->toolPrice($temptotalprice, TRUE)
                );
                $fee = $paymentLogic->getPaymentFee($order_param, $payment['config_param'], $payment['formula']);
                if ($fee) {
                    $payment_fee = $fee;
                } else {
                    $payment_fee = 0;
                }
            } else {
                return array('key' => 'Payment_Error');
            }
            $payment_fee = $this->toolPrice($payment_fee);
        }
        $cost_payment = $cartInfo['subtotalprice'] - $exp_amout;
        $total_amount = $cartInfo['subtotalprice'] + $shipping_fee - $exp_amout + $insurance_fee;
        $order_payment_amount = $cartInfo['subtotalprice'] + $shipping_fee - $exp_amout + $insurance_fee + $payment_fee;
        $order_data = array(
            'user_id' => $user_id,
            'itemno' => $order_itemno,
            'coupon_code_used' => isset($cartInfo['cart_coupon'][1]) ? $cartInfo['cart_coupon'][1] : 0,
            'total_weight' => $cartInfo['totalweight'],
            'currency_rate' => $current_currency['exchange_rate'],
            'currency_code' => $current_currency['standard_code'],
            'shipping_id' => $shipping_id,
            'payment_fee' => $payment_fee,
            'shipping_corp_id' => $shipping['shipping_corp_id'],
            'cost_shipping' => $shipping_fee,
            'cost_payment' => $cost_payment, //商品支付的金额
            'cost_offer' => $cartInfo['cart_save'] + $exp_amout,
            'total_amount' => $total_amount,
            'final_amount' => $order_payment_amount,
            'ip' => $ip,
            'language_id' => $language_id,
            'country_id' => $country_id,
            'remark' => $order_remark,
            'domain' => Common::strEscape($domain),
            'used_credit' => $use_credit,
            'insurance' => $insurance_fee,
            'create_time' => SYS_TIME,
            'source_device' => $deviceType,
            'source' => $this->getSource(),
            'billing_address_id' => $billing_address_id,
        );
        $order_res = $this->orderLogic->save($order_data);
        if ($order_res) {
            if ($params['payment_id']) {
                global $cfg;
                $orderPaymentLogic = $this->load('orderPayment');
                $currencyLogic = $this->load('currency');
                $base_currency_id = $cfg['sites'][0]['base_currency'];
                $trade_no = date('Ymdhsi', time());
                $pay_amount = $order_res['final_amount'];
                $currency_code = $order_data['currency_code']; //货币三位符
                $currency_conde = 'standard_code="' . $currency_code . '"';
                $currency = $currencyLogic->getOne($currency_conde);
                $payment_data = array(
                    'payment_type' => 1,
                    'trade_no' => $trade_no,
                    'order_id' => $order_res,
                    'user_id' => $user_id,
                    'payment_id' => $payment_id,
                    'amount' => $this->speChangePrice($pay_amount, $currency, TRUE),
                    'base_currency_id' => $base_currency_id,
                    'real_currency_id' => $currency['id'],
                    'real_currency_amount' => $pay_amount,
                    'status' => 0,
                    'create_time' => SYS_TIME,
                );
                $orderPaymentLogic->updateByCond($payment_data);
            }
            $map = Zhtx::createDataMap();
            if (!ORDER_FORMATE) {
                $itemno = date("Ymd") . "-" . $order_res;
            } else {
                global $cfg_order_format;
                $str_format = '';
                if ($cfg_order_format) {
                    eval('$str_format=' . $cfg_order_format);
                } else {
                    $str_format = ORDER_FORMATE;
                }
                $itemno = str_replace("@id", $order_res, $str_format);
            }
            $map->addEntry('itemno', $itemno, DB::VARCHAR);
            $res = $this->orderLogic->update($map, 'id=' . $order_res);
            $order_data['id'] = $order_res;
            $order_data['itemno'] = $itemno;
            $orderAddressLogic = $this->load('orderAddress');
            $orderItemLogic = $this->orderItemLogic;
            $orderOfferLogic = $this->load('orderOffer');
            $order_address_data = array(
                'order_id' => $order_res,
                'first_name' => Common::strEscape($address['first_name']),
                'last_name' => Common::strEscape($address['last_name']),
                'country_id' => $address['country_id'],
                'state' => Common::strEscape($address['state']),
                'city' => Common::strEscape($address['city']),
                'address' => Common::strEscape($address['address']),
                'address_spare' => Common::strEscape($address['address_spare']),
                'postcode' => Common::strEscape($address['postcode']),
                'telephone' => $address['telephone'],
                'mobilephone' => $address['mobilephone'],
                'email' => $address['email'],
            );
            $address_res = $orderAddressLogic->save($order_address_data);
            if (!$address_res) {
                return array('key' => 'address_save_failure');
            }
            $skuLogic = $this->load('sku');
            $product_promotion_amount = 0;
            $property_ids = array();
            $propertys = array();
            foreach ($cartInfo['orderitems'] as $item)
            {
                $skucode = explode('_', $item['sku_code']);
                foreach ($skucode as $key => $value)
                {
                    if($value)
                    {
                        $property_ids[] = $value;
                    }
                }
            }
            if($property_ids)
            {
                $res = $this->propertyLogic->findAll("id in(".join(',',$property_ids).")");
                foreach($res as $key => $value)
                {
                    $propertys[$value['id']] = $value;
                }
            }
            foreach ($cartInfo['orderitems'] as $item) {
                $sku_code_pid = explode('_', $item['sku_code']);
                $order_item_data = array(
                    'order_id' => $order_res,
                    'goods_id' => $item['goods_id'],
                    'sku_code' => $item['sku_code'],
                    'goods_name' => Common::strEscape($item['base_name']),
                    'buy_num' => $item['qty'],
                    'price' => $item['price'],
                    'cost_price' => $item['cost_price'],
                    'weight' => $item['weight'],
                    'product_image' => $item['image'],
                    'status' => 1,
                );
                if($propertys[$sku_code_pid[0]] || $propertys[$sku_code_pid[1]])
                {
                    $order_item_data['sku_value'] = $propertys[$sku_code_pid[0]]['base_name'].'_'.$propertys[$sku_code_pid[1]]['base_name'];
                }
                $item_res = $orderItemLogic->save($order_item_data);
                if ($item_res) {
                    //冻结库存
                    $sku = $skuLogic->getOne('goods_id=' . $item['goods_id'] . ' and sku_code="' . $item['sku_code'] . '"');
                    $sku_data = array(
                        'freeze_nums' => $sku['freeze_nums'] + $item['qty'],
                    );
                    $skuLogic->save($sku_data, $sku['id']);
                    $offer = $item['offer_id'] ? $item['promotions'][$item['offer_id']] : '';
                    if ($item['offer_id'] && empty($item['gifts'])) {//不是赠品促销的情况
                        if ($item['promotion_save'] > 0) {
                            $order_offer_data = array(
                                'offer_base_name' => $offer['default_base_name'],
                                'order_id' => $order_res,
                                'item_id' => $item_res,
                                'offer_id' => $offer['id'],
                                'rule_id' => $item['rule_id'],
                                'amount' => $item['promotion_save'],
                                'order_offer_type' => 301,
                            );
                            $orderOfferLogic->save($order_offer_data);
                            $product_promotion_amount += $item['promotion_save'];
                        }
                    } else {
                        foreach ($item['gifts'] as $gift) {
                            $order_item_gift_data = array(
                                'order_id' => $order_res,
                                'goods_id' => $gift['goods_id'],
                                'sku_code' => $gift['sku_code'],
                                'goods_name' => Common::strEscape($gift['base_name']),
                                'buy_num' => $gift['num'],
                                'price' => $this->toolPrice($gift['price']),
                                'cost_price' => $this->toolPrice($gift['cost_price']),
                                'weight' => $gift['weight'],
                                'product_image' => $gift['image'],
                                'is_gift' => 1,
                                'status' => 1,
                            );
                            $gift_res = $orderItemLogic->save($order_item_gift_data);
                            if ($gift_res) {
                                $order_offer_data = array(
                                    'offer_base_name' => $offer['default_base_name'],
                                    'order_id' => $order_res,
                                    'goods_id' => $gift['goods_id'],
                                    'item_id' => $item_res,
                                    'offer_id' => $offer['id'],
                                    'rule_id' => $item['rule_id'],
                                    'sku_code' => $gift['sku_code'],
                                    'amount' => $this->toolPrice(($gift['sku_price'] - $gift['price']) * $gift['num']),
                                    'order_offer_type' => 301,
                                    'gift_item_id' => $gift_res,
                                );
                                $orderOfferLogic->save($order_offer_data);
                                $product_promotion_amount += $order_offer_data['amount'];
                                //冻结库存
                                $sku = $skuLogic->getOne('goods_id=' . $gift['goods_id'] . ' and sku_code="' . $gift['sku_code'] . '"');
                                $sku_data = array(
                                    'freeze_nums' => $sku['freeze_nums'] + $gift['num'],
                                );
                                $skuLogic->save($sku_data, $sku['id']);
                            }
                        }
                    }
                    $params = array(
                        'buy_counts' => $item['qty'],
                        'cost_offer' => $this->toolPrice($item['aftersave'], TRUE),
                        'cost_amount' => $item['cost_price'] * $item['qty'],
                    );
                    //报表数据
                    ReportFactory::goodsReportAndGoodsLanguageReport($item['goods_id'], $language_id, $country_id, $params);
                }
                //报表数据处理
                ReportFactory::reduceCartCount($item['goods_id'], $item['qty'], $item['add_cart_time'], $user_id);
            }
            if ($cartInfo['cart_promotion'] && $cartInfo['cart_promotion'] != 'nothing') {
                if ($cartInfo['promotion_save'] > 0) {
                    $order_offer_data = array(
                        'offer_base_name' => $cartInfo['promotion_offer']['default_base_name'],
                        'order_id' => $order_res,
                        'offer_id' => $cartInfo['promotion_offer']['id'],
                        'rule_id' => $cartInfo['promotion_rule_id'],
                        'amount' => $cartInfo['promotion_save'],
                        'order_offer_type' => 301,
                    );
                    $orderOfferLogic->save($order_offer_data);
                }
                //礼品
                foreach ($cartInfo['cart_gift'] as $gift) {
                    $order_item_gift_data = array(
                        'order_id' => $order_res,
                        'goods_id' => $gift['goods_id'],
                        'sku_code' => $gift['sku_code'],
                        'goods_name' => Common::strEscape($gift['base_name']),
                        'buy_num' => $gift['num'],
                        'price' => $this->toolPrice($gift['price']),
                        'cost_price' => $this->toolPrice($gift['cost_price']),
                        'weight' => $gift['weight'],
                        'product_image' => $gift['image'],
                        'is_gift' => 1,
                        'status' => 1,
                    );
                    $gift_res = $orderItemLogic->save($order_item_gift_data);
                    if ($gift_res) {
                        $order_offer_data = array(
                            'offer_base_name' => $cartInfo['promotion_offer']['default_base_name'],
                            'order_id' => $order_res,
                            'goods_id' => $gift['goods_id'],
                            'item_id' => $item_res,
                            'offer_id' => $cartInfo['promotion_offer']['id'],
                            'rule_id' => $cartInfo['promotion_rule_id'],
                            'sku_code' => $gift['sku_code'],
                            'amount' => $this->toolPrice($gift['sku_price'] - $gift['price']) * $gift['num'],
                            'order_offer_type' => 301,
                            'gift_item_id' => $gift_res,
                        );
                        $orderOfferLogic->save($order_offer_data);
                        $product_promotion_amount += $order_offer_data['amount'];
                        //冻结库存
                        $sku = $skuLogic->getOne('goods_id=' . $gift['goods_id'] . ' and sku_code="' . $gift['sku_code'] . '"');
                        $sku_data = array(
                            'freeze_nums' => $sku['freeze_nums'] + $gift['num'],
                        );
                        $skuLogic->save($sku_data, $sku['id']);
                    }
                }
            }
            //更新cost_offer
            $update_costPayment_map = Zhtx::createDataMap();
            $update_costPayment_map->addEntry('cost_offer', $cartInfo['cart_save'] + $exp_amout + $product_promotion_amount, DB::FLOAT);
            $this->orderLogic->update($update_costPayment_map, 'id=' . $order_res);
            if (isset($cartInfo['cart_coupon'][1]) && $cartInfo['coupon_save'] > 0) {
                $order_offer_data = array(
                    'offer_base_name' => $cartInfo['coupon_offer']['base_name'],
                    'order_id' => $order_res,
                    'offer_id' => $cartInfo['coupon_offer']['id'],
                    'rule_id' => $cartInfo['coupon_rule_id'],
                    'coupon' => $cartInfo['cart_coupon'][1],
                    'amount' => $cartInfo['coupon_save'],
                    'order_offer_type' => 302,
                );
                $c_res = $orderOfferLogic->save($order_offer_data);
                if ($c_res) {
                    //冻结优惠券
                    $couponLogic = $this->load('coupon');
                    $offerLogic = $this->load('offer');
                    $coupon = $couponLogic->getOne('coupon_code ="' . $cartInfo['cart_coupon'][1] . '"');
                    if ($coupon) {
                        $offer = $offerLogic->getOne('id=' . $coupon['offer_id']);
                        if ($offer['coupon_type'] != 1) {
                            $c_data = array(
                                'order_id' => $order_res,
                                'status' => 3,
                                'using_time' => SYS_TIME,
                            );
                            $couponLogic->save($c_data, $coupon['id']);
                        } else {
                            $c_data = array(
                                'order_id' => $order_res,
                                'using_time' => SYS_TIME,
                            );
                            $couponLogic->save($c_data, $coupon['id']);
                            //更新通用优惠券使用次数
                            $send_num = $offer['send_num'] + 1;
                            $o_data = array(
                                'send_num' => $send_num,
                            );
                            $offerLogic->save($o_data, $offer['id']);
                            $couponuserLogic = $this->load('couponUser');
                            $ou_data = array(
                                'user_id' => $user_id,
                                'order_id' => $order_res,
                                'offer_id' => $coupon['offer_id'],
                                'using_time' => SYS_TIME,
                            );
                            $couponuserLogic->save($ou_data);
                        }
                        _setSession('coupon_code_list', '');
                    }
                }
            }
            //积分抵用金额记录
            if ($use_credit) {
                $order_offer_data = array(
                    'offer_base_name' => '积分抵用',
                    'order_id' => $order_res,
                    'amount' => $exp_amout,
                    'order_offer_type' => 303,
                );
                $orderOfferLogic->save($order_offer_data);
                $this->load('creditDetail')->expCredit($use_credit);
            }
            $params2 = array(
                'order_counts' => 1,
                'order_amount' => $this->toolPrice($cartInfo['subtotalprice'], TRUE),
                'cost_offer' => $this->toolPrice($cartInfo['cart_save'], TRUE),
                'cost_shipping' => $res,
                'order_item_counts' => $cartInfo['totalqty'],
            );
            ReportFactory::salesReportAndUserSalesReport($user_id, $language_id, $country_id, $params2);
            //清除购物车数据
            $this->load('userCart')->clearCart($user_id, $language_id);
            $order_data['payment_id'] = $payment_id;
            EventFactory::addOrderAfter($order_data);
            $this->cleanUserSource();
            $this->cleanSource();
            return $order_data;
        }
    }

    /**
     * 读取商品信息
     */
    public function getGoodsList($params, $user_id, $language_id, $get_cache = true) {
        $sku_id = $params['sku_id'];
        $sku_num = $params['sku_num'];
        $sku_id_arr = explode(',', $sku_id);
        $sku_num_arr = explode(',', $sku_num);
        $new_sku_num_arr = array();
        foreach ($sku_id_arr as $key => $value) {
            $new_sku_num_arr[$value] = $sku_num_arr[$key] ? $sku_num_arr[$key] : 1;
        }
        $type = $params['type'];
        $package_id = $params['package_id'];
        global $data_cache_dir;
        $quick_order_session = Common::queryStr(_s('quick_order_cache'), _c('PHPSESSID'));
        if (!$user_id)
            $user_id = 0;
        $key = $user_id . '_' . $language_id . '_' . $sku_id . '_' . $sku_num . '_quick_order_cache';
        $chk = _chkcahce($key, 'goods_list');
        if (!$get_cache || !$chk || !$quick_order_session) {
            $cond = 's.status=1 and s.id in(' . $sku_id . ')';
            $chk = $this->skuJoinGoodsLogic->findAll($cond);
            $productLogic = $this->load('product');
            $goodsPackageSaleGoodsRelLogic = $this->load('goodsPackageSaleGoodsRel');
            foreach ($chk as $k => $v) {
                $chk[$k]['product_num'] = $new_sku_num_arr[$v['sku_id']];
                $master_property = explode('_', $v['sku_code']);
                $cond = 'goods_id=' . $v['goods_id'] . ' and property_id=' . $master_property[0];
                $productinfo = $productLogic->getOne($cond);
                if ($productinfo['image']) {
                    $chk[$k]['image'] = $productinfo['image'];
                }
                if($chk[$k]['market_price']<=0)
                {
                    $chk[$k]['market_price'] = $chk[$k]['gmarket_price'];
                }
                if($chk[$k]['price']<=0)
                {
                    $chk[$k]['price'] = $chk[$k]['gprice'];
                }
                if($chk[$k]['cost_price']<=0)
                {
                    $chk[$k]['cost_price'] = $chk[$k]['gcost_price'];
                }
                if($chk[$k]['old_price']<=0)
                {
                    $chk[$k]['old_price'] = $chk[$k]['gold_price'];
                }
                if($chk[$k]['weight']<=0)
                {
                    $chk[$k]['weight'] = $chk[$k]['gweight'];
                }
                if($type=='package')
                {
                    $cond = 'goods_id=' . $v['goods_id'] . ' and package_sale_id=' . $package_id;
                    $packageSaleGoodsInfo = $goodsPackageSaleGoodsRelLogic->getOne($cond);
                    if(!$packageSaleGoodsInfo)
                    {
                        $packageSaleGoodsInfo['discount'] = 10;
                    }
                    $chk[$k]['price'] = $chk[$k]['price'] * ($packageSaleGoodsInfo['discount'] / 10);
                }
            }

            if ($chk) {
                _setcahce($key, $chk, 'goods_list');
                _setSession('quick_order_cache', _c('PHPSESSID'));
            }
        }
        return $chk;
    }

    /**
     *  获取商品信息
     */
    public function getGoodsInfo($params, $user_id, $language_id, $get_cache, $product_promotion, $cart_promotion, $cart_coupon, $gift_promotion) {
        $goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $offerJoinLangLogic = $this->load('offerJoinLanguage');
        $goodsJoinLangLogic = $this->load('goodsJoinLanguage');
        $skuLogic = $this->load('sku');
        $product_promotion = json_decode($product_promotion, TRUE);
        $cart_promotion = $cart_promotion;
        $cart_counpon = $cart_coupon ? explode('_', $cart_coupon) : array(0);
        $promotionlist = $offerJoinLangLogic->getListByLanguageId($language_id);
        $promotion_gift = json_decode($gift_promotion, TRUE);
        $orderitems = array();
        $totalPrice = 0;
        $totalQty = 0;
        $totalSave = 0;
        $offer_save = 0;
        $totalweight = 0;
        $giftQty = 0;
        $subtotalprice = 0;
        $gift_outside_price = 0;
        $cart_data = $this->getGoodsList($params, $user_id, $language_id, $get_cache);
        foreach ($cart_data as $key => $item) {
            $property_ids = explode('_', $item['sku_code']);
            $properties = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
            $price = floatval($item['price']);
            $cur_price = AppController::toolPrice($price); //当前货币的价格
            $qty = intval($item['product_num']);
            $subtotal = $cur_price * $qty;
            $save = 0;
            $giftprice = 0;
            $giftweight = 0;
            $goods_gifts = array();
            //注意用户第一次进入购物车默认选中的促销已经用户取消选择促销的情况
            $promotions = $goodsJoinLangLogic->getPromotionOffer($item['goods_id'], $subtotal, $item['product_num'], $language_id, $promotionlist);
            $is_promotion = isset($product_promotion[$item['sku_id']]) && $product_promotion[$item['sku_id']] ? $product_promotion[$item['sku_id']] : FALSE;
            if (!$is_promotion && $promotions) {
                foreach ($promotions as $pk => $pro) {
                    if ($pro['max_offer'] == 1) {
                        $product_promotion[$item['sku_id']] = $pk;
                        $is_promotion = $pk;
                    }
                }
            }
            if ($is_promotion && $is_promotion != 'nothing') {
                $offer = $offerJoinLangLogic->getProductOffer($item, $is_promotion, $qty, $language_id);
                if (isset($offer['gifts']) && $offer['gifts'] && !isset($promotion_gift[$item['sku_id']])) {
                    foreach ($offer['gifts'] as $g) {
                        $gift_sku_code = '';
                        if (!empty($g['attr'])) {
                            foreach ($g['attr'] as $key => $attr) {
                                if (!$gift_sku_code) {
                                    $gift_sku_code = $key;
                                }
                            }
                        } else {
                            $gift_sku_code = '0_0';
                        }
                        $promotion_gift[$item['sku_id']][$g['goods_id']] = array(
                            'offer_id' => $is_promotion,
                            'goods_id' => $g['goods_id'],
                            'sku_code' => $gift_sku_code,
                        );
                    }
                }
                $is_gift = isset($promotion_gift[$item['sku_id']]) && $promotion_gift[$item['sku_id']] ? $promotion_gift[$item['sku_id']] : FALSE;
                if ($offer) {
                    $subtotal = $offer['subtotal'];
                    $pro_save = isset($offer['save']) ? $offer['save'] : 0;
                    $totalPrice -= $pro_save;
                    $save = $pro_save + $save; // _debug($is_gift);
                    if ($is_gift && isset($offer['gifts']) && $offer['gifts']) {
                        foreach ($is_gift as $gift) {
                            $offerGift = isset($offer['gifts'][$gift['goods_id']]) ? $offer['gifts'][$gift['goods_id']] : 0;
                            if ($offerGift && $gift['sku_code']) {
                                $gift_cond = 'goods_id=' . $gift['goods_id'] . ' and sku_code ="' . $gift['sku_code'] . '" and status=1 and stock_nums>0';
                                $gift_sku = $skuLogic->getOne($gift_cond);
                                if ($gift_sku) {
                                    $offerGift['sku_price'] = $gift_sku['price'];
                                    $offerGift['cost_price'] = $gift_sku['cost_price'];
                                    $offerGift['weight'] = $gift_sku['weight'];
                                    $offerGift['sku_code'] = $gift['sku_code'];
                                    $offerGift['attributes'] = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($gift['goods_id'], explode('_', $gift['sku_code']), $language_id);
                                    $giftprice = AppController::toolPrice($offerGift['price']) + $giftprice;
                                    $giftweight = $gift_sku['weight'] * $gift['num'] + $giftweight;
                                    $goods_gifts[] = $offerGift;
                                    $giftQty += $gift['num'];
                                    $totalPrice += AppController::toolPrice($giftprice) * $gift['num'];
                                }
                            }
                        }
                    }
                }
            }
            $market_price = AppController::toolPrice($item['market_price']);
            $offset_price = 0;
            $old_price = AppController::toolPrice($item['old_price']);
            if ($item['special_status'] == 1 && $old_price > $cur_price && $item['end_time'] > time()) {
                $offset_price = ($old_price - $cur_price) * $qty;
            }
            $totalPrice += $cur_price * $qty + $giftprice;
            $subtotalprice = $subtotal + $subtotalprice + $giftprice;
            $totalQty = $qty + $totalQty;
            $totalSave = $offset_price + $totalSave + $save;
            $offer_save = $save + $offer_save;
            $totalweight = $item['weight'] * $qty + $totalweight + $giftweight;
            $gift_outside_price = $gift_outside_price + $subtotal;
            $image = $item['image'];
            if (!$image) {
                $image = $goodsJoinLangLogic->getImage($item['goods_id'], $language_id);
            }//_debug($promotions);
			
			
			
            $orderitems[$key] = array(
                'default_base_name' => $item['default_base_name'],
                'goods_id' => $item['goods_id'],
                'product_id' => $item['product_id'],
                'base_name' => $item['base_name'],
                'codeno' => $item['codeno'],
                'stock_nums'     => $item['stock_nums'],
                'image' => $image,
                'price' => $cur_price,
                'market_price' => $market_price,
                'old_price' => $old_price,
                'special_status' => $item['special_status'],
                'end_time' => $item['end_time'],
                'cost_price' => AppController::toolPrice($item['cost_price']),
                'weight' => $item['weight'],
                'qty' => $item['product_num'],
                'sku_id' => $item['sku_id'],
                'sku_code' => $item['sku_code'],
                'save' => $offset_price,
                'discount' => ceil($price / $item['old_price'] * 100),
                'aftersave' => $save,
                'subtotal' => $subtotal,
                'attributes' => $properties,
                'offer_id' => $is_promotion ? $is_promotion : '',
                'rule_id' => $is_promotion && $is_promotion != 'nothing' && isset($offer['rule_id']) ? $offer['rule_id'] : 0,
                'gifts' => $goods_gifts,
                'promotions' => $promotions,
                'add_cart_time' => $item['create_time'],
                'promotion_save' => $pro_save,
            );
        }
        $car_offer = array();
        $cart_promotion_save = 0;
        $cart_coupon_save = 0;
        $promotion_offer = '';
        $coupon_offer = '';
        $promotion_rule_id = 0;
        $coupon_rule_id = 0;
        if (($cart_promotion && $cart_promotion != 'nothing') || $cart_counpon[0]) {
            $promotion_after_amount = AppController::toolPrice($gift_outside_price, TRUE);
            //购物车促销
            $car_offer1 = $offerJoinLangLogic->getCartOffer($cart_promotion, $promotion_after_amount, $totalQty, $language_id);
            if ($car_offer1) {
                if (isset($car_offer1['gifts']) && $car_offer1['gifts'] && !isset($promotion_gift['cart'])) {

                    foreach ($car_offer1['gifts'] as $g) {
                        $gift_sku_code = '';
                        if (!empty($g['attr'])) {
                            foreach ($g['attr'] as $key => $attr) {
                                if (!$gift_sku_code) {
                                    $gift_sku_code = $key;
                                }
                            }
                        } else {
                            $gift_sku_code = '0_0';
                        }
                        $promotion_gift['cart'][$g['goods_id']] = array(
                            'offer_id' => $cart_promotion,
                            'goods_id' => $g['goods_id'],
                            'sku_code' => $gift_sku_code,
                        );
                    }
                }
                $promotion_offer = $car_offer1['offer'];
                $promotion_rule_id = $car_offer1['rule_id'];
                $cart_promotion_save = isset($car_offer1['cart_save']) ? $car_offer1['cart_save'] : 0;
                $cart_promotion_dis = isset($car_offer1['cart_discount']) ? $car_offer1['cart_discount'] : 1;
                $car_offer['cart_save'] = $cart_promotion_save;
                $car_offer['cart_discount'] = $cart_promotion_dis;
                $car_offer['free_ship'] = $car_offer1['free_ship'];
                if ($cart_promotion_save) {
                    $subtotalprice = $subtotalprice - $cart_promotion_save;
                } elseif ($cart_promotion_dis) {
                    $subtotalprice = $subtotalprice * $cart_promotion_dis;
                }
                $promotion_after_amount = $subtotalprice;
            }
            //优惠券使用
            $car_offer2 = $offerJoinLangLogic->getCartOffer($cart_counpon[0], $promotion_after_amount, $totalQty, $language_id, $cart_data);

            if ($car_offer2) {
                $cond = 'coupon_code="' . $cart_counpon[1] . '"';
                $couponLogic = $this->load('coupon');
                $couponuserLogic = $this->load('couponUser');
                $coupon = $couponLogic->getOne($cond);
                $days = ceil((SYS_TIME - $coupon['create_time']) / 86400);

                $using_num = $car_offer2['offer']['using_num'];
                $cond2 = 'user_id=' . $user_id . ' and offer_id=' . $car_offer2['offer']['id'];
                if ($car_offer2['offer']['coupon_type'] == 1) {
                    $used_num = $couponuserLogic->getCount($cond2);
                } else {
                    $cond2 .= ' and status=2'; //已使用状态#1可用0#不可用2#已使用
                    $used_num = $couponLogic->getCount($cond2);
                }
                if (($car_offer2['offer']['days'] > $days || $car_offer2['offer']['days'] == 0) && ($using_num == 0 || $using_num >= ($used_num + 1))) {
                    $coupon_offer = $car_offer2['offer'];
                    $coupon_rule_id = $car_offer1['rule_id'];
                    $cart_coupon_save = isset($car_offer2['cart_save']) ? $car_offer2['cart_save'] : 0;
                    $cart_coupon_dis = isset($car_offer2['cart_discount']) ? $car_offer2['cart_discount'] : 1;
                    $car_offer['cart_save'] = $cart_coupon_save + $cart_promotion_save;
                    $car_offer['cart_discount'] = $cart_coupon_dis;
                    if ($cart_coupon_save) {
                        $subtotalprice = $subtotalprice - $cart_coupon_save;
                    } elseif ($cart_coupon_dis) {
                        $subtotalprice = $subtotalprice * $cart_coupon_dis;
                    }
                }
            }
        }
        $cart_gift = array();
        if (isset($promotion_gift['cart'])) {
            foreach ($promotion_gift['cart'] as $gift) {
                $offerGift = isset($promotionlist['gifts'][$cart_promotion][$promotion_rule_id][$gift['goods_id']]) ? $promotionlist['gifts'][$cart_promotion][$promotion_rule_id][$gift['goods_id']] : 0;
                if ($offerGift && $gift['sku_code']) {
                    $gift_cond = 'goods_id=' . $gift['goods_id'] . ' and sku_code ="' . $gift['sku_code'] . '" and status=1 and stock_nums>0';
                    $gift_sku = $skuLogic->getOne($gift_cond);
                    if ($gift_sku) {
                        $offerGift['sku_price'] = $gift_sku['price'];
                        $offerGift['cost_price'] = $gift_sku['cost_price'];
                        $offerGift['weight'] = $gift_sku['weight'];
                        $offerGift['sku_code'] = $gift['sku_code'];
                        $offerGift['attributes'] = $goodsProRelLangLogic->getListByGoodsIdAndPropertyIds($gift['goods_id'], explode('_', $gift['sku_code']), $language_id);
                        $subtotalprice = AppController::toolPrice($offerGift['price']) + $subtotalprice;
                        $giftweight = $gift_sku['weight'] * $offerGift['num'] + $giftweight;
                        $cart_gift[] = $offerGift;
                        $giftQty += $offerGift['num'];
                        $totalPrice += AppController::toolPrice($offerGift['price']);
                    }
                }
            }
        }
        //促销信息存放到cookie
        _setSession('product_promotion', json_encode($product_promotion));
        _setSession('gift_promotion', json_encode($promotion_gift));
        return array(
            'orderitems' => $orderitems,
            'totalqty' => $totalQty,
            'final_qty' => $totalQty + $giftQty,
            'totalprice' => AppController::price_format($totalPrice), //还没有参与优惠的总金额
            'totalsave' => AppController::price_format($totalSave), //总的优惠（特价与原价相比）
            'offer_save' => AppController::price_format($offer_save), //商品优惠总额
            'totalweight' => $totalweight,
            'cart_promotion' => $cart_promotion,
            'cart_coupon' => $cart_counpon, //数组            
            'cart_save' => isset($car_offer['cart_save']) ? AppController::price_format($car_offer['cart_save']) : '', //购物车促销优惠节省金额
            'cart_discount' => isset($car_offer['cart_discount']) ? $car_offer['cart_discount'] : '', //购物车促销优惠折扣
            'subtotalprice' => AppController::price_format($subtotalprice), //购物车优惠后的价格
            'promotion_save' => $cart_promotion_save,
            'coupon_save' => $cart_coupon_save,
            'promotion_offer' => $promotion_offer,
            'coupon_offer' => $coupon_offer,
            'promotion_rule_id' => $promotion_rule_id,
            'coupon_rule_id' => $coupon_rule_id,
            'cart_gift' => $cart_gift,
            'free_ship' => isset($car_offer['free_ship']) ? $car_offer['free_ship'] : 0,
        );
    }
    
    /**
     * ajax
     * 获取物流运费 
     */
    public function actionGetShippingFee()
    {
        $params = array(
            'sku_id' => _p('sku_id'),
            'sku_num' => _p('sku_num'),
            'type' => _p('type'),
            'package_id' => _p('package_id'),
            'shipping_id' => Common::queryInt(_p('shipping_id')),
        );
        $return = $this->getCreditInfo($params);
        if($return['promotion_save']>0 && !$return['is_spec'])
        {
            $return['is_show_credit'] = 0;
        }
        else
        {
            $return['is_show_credit'] = 1;
        }
        echo $return ? json_encode($return) : FALSE;
    }
    
    /**
     * 获取当前用户积分的信息
     * @param type $shipping_id 配送方式ID
     * @return boolean 
     */
    public function getCreditInfo($params, $payment_id = 0, $insurance_fee_selected = false, $credits_value_amount = 0)
    {
        $shipping_id = $params['shipping_id'];
        $user_id = $this->checkLogin();
        $language_id = $this->langLogic->language_id;
        $shippingLogic = $this->load('shipping');
        $cartInfo = $this->getGoodsInfo($params, $user_id, $language_id, false);
        $shipping = $shippingLogic->getOneById($shipping_id);
        if (!$shipping_id || !$shipping)
        {
            return false;
        }
        $shipping_fee = 0;
        if (!$cartInfo['free_ship'])
        {
            $cart_param = array(
                'totalweight' => $cartInfo['totalweight'],
                'totalprice' => isset($cartInfo['subtotalprice']) ? $cartInfo['subtotalprice'] : $cartInfo['totalprice'],
                'totalnumber' => $cartInfo['totalqty'],
                'totalvweight' => 0,
            );
            $order_goods_ids = array();
            $order_goods_qtys = array();
            $order_goods_sku_ids = array();
            $orderSum=0;
           foreach ($cartInfo['orderitems'] as $item)
            {
                $order_goods_ids[] = $item['goods_id'];
                $order_goods_qtys[$item['goods_id']] = isset($order_goods_qtys[$item['goods_id']]) ? $order_goods_qtys[$item['goods_id']] + $item['qty'] : $item['qty'];
                $order_goods_sku_ids[] = $item['sku_id'];
				$order_sku_qtys[$item['sku_id']] =  $item['qty'];
                                $orderSum+=$item['qty'];
            }
            $free_shipping = $this->load('SpecialOfferShippingJoinGoods')->getShippingInfo($order_goods_ids, $order_sku_qtys, $order_goods_sku_ids);
            if (isset($free_shipping[$shipping_id]))
            {
                if ($free_shipping[$shipping_id]['free_shipping_type'] == 1)
                {
                    $cart_param['totalweight'] = 0;
                    $cart_param['totalnumber'] = 0;
                    $cost = 0;
                }
                else
                {
                    $cart_param['totalweight'] = $cartInfo['totalweight'] - $free_shipping[$shipping_id]['weight'];
                    $cart_param['totalnumber'] = $cartInfo['totalqty'] - $free_shipping[$shipping_id]['num'];
                    $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
                }
            }
            else
            {
                $cost = $shippingLogic->getShippingCost($cart_param, $shipping['formula_param'], $shipping['formula'], $shipping['discount']);
            }
            if ($cost === FALSE)
            {
                return array('key' => 'illegal_parameters');
            }
            $shipping_fee = $this->toolPrice($cost);
        }
        $user = $this->load('user')->getOneById($this->user_id);
        $creditSettingLogic = $this->load('creditSetting');
        $creditInfo = $creditSettingLogic->getCreditInfo($user['credit'], $cartInfo['subtotalprice'], $cartInfo['subtotalprice'] + $shipping_fee);
        //运费险
        $insuranceLogic = $this->load('InsuranceJoinLanguage');
        $insurance = $insuranceLogic->getConfig($this->language_id);
        $insurance_param = array(
            'order_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE) + $this->toolPrice($shipping_fee, TRUE),
            'goods_totalprice' => $this->toolPrice($cartInfo['subtotalprice'], TRUE),
            'shipping_fee' => $this->toolPrice($shipping_fee, TRUE),
            'orderSum'=>$orderSum,
        );
        $insurance_fee = $insuranceLogic->getCost($insurance_param, $insurance['formula_param'], $insurance['formula']);
        $payment_fee = 0;
        $minus_credits_value_amount = 0;
        if ($payment_id)
        {
            $paymentLogic = $this->load('payment');
            $cond = '(language_id=0 or language_id=' . $this->language_id . ') and status=1 and id=' . $payment_id . ' order by listorder asc';
            $payment = $paymentLogic->getOne($cond);
            if ($payment)
            {
                $temptotalprice = $cartInfo['subtotalprice'] + $shipping_fee;
                if ($insurance_fee_selected)
                {
                    $temptotalprice += $this->toolPrice($insurance_fee);
                }
                //积分抵用费用
                if ($credits_value_amount)
                {
                    $temptotalprice -= $this->toolPrice($credits_value_amount);
                }
                $order_param = array(
                    'totalprice' => $this->toolPrice($temptotalprice, TRUE)
                );
                $fee = $paymentLogic->getPaymentFee($order_param, $payment['config_param'], $payment['formula']);
                if ($fee)
                {
                    $payment_fee = $fee;
                }
                else
                {
                    $payment_fee = 0;
                }
            }
            else
            {
                $payment_fee = 0;
            }
            $payment_fee = $this->toolPrice($payment_fee);
        }
        if(!$payment_fee)
            $minus_credits_value_amount = $credits_value_amount;
            
        $return = array(
            'shipping_fee' => $shipping_fee,
            'payment_fee' => $payment_fee,
            'total_credit' => $user['credit'],
            'max_exp_credit' => $creditInfo ? $creditInfo['max_exp_credit'] : 0,
            'payment_amount' => $cartInfo['subtotalprice'] + $shipping_fee + $payment_fee - $minus_credits_value_amount,
            'exchange_credit_scale' => $creditInfo ? $creditInfo['exchange_credit_scale'] : 1,
            'insurance_fee' => $this->toolPrice($insurance_fee),
            'insurance_default' => $insurance['is_default'],
            'is_spec' => $creditInfo['is_spec'],
        );
        return $return;
    }

    /**
     * 获取配送方式 
     */
    public function actionShippingInfo()
    {
        $params = array(
            'sku_id' => _g('sku_id'),
            'sku_num' => _g('sku_num'),
            'type' => _g('type'),
            'package_id' => _g('package_id'),
        );
        $country_id = _g('country_id');
        if (!$this->load('country')->getCount('id=' . $country_id . ' and status=1'))
        {
            echo 0;
            return;
        }
        $areaCountryRelLogic = $this->load('shippingAreaCountryRel');
        $shippingJoinLangLogic = $this->load('shippingJoinLanguage');
        $shippingLogic = $this->load('shipping');
        $language_id = $this->langLogic->language_id;
        $user_id = $this->checkLogin();
        $product_promotion = array();
        $cart_promotion = 0;
        if (_s('product_promotion'))
        {
            foreach (json_decode(_s('product_promotion')) as $key => $value)
            {
                $product_promotion[$key] = $value;
            }
        }
        if (_s('cart_promotion'))
        {
            $cart_promotion = _s('cart_promotion');
        }
        $area_ids = $areaCountryRelLogic->getListByCountryId($country_id);
        $shipping = array();
        if (!empty($area_ids))
        {
            $shipping = $shippingJoinLangLogic->getShippingByAreaIds($area_ids, $language_id);
        }
        $cartInfo = $this->getGoodsInfo($params, $user_id, $language_id, false);
        $cart_param = array(
            'totalweight' => $cartInfo['totalweight'],
            'totalprice' => isset($cartInfo['subtotalprice']) ? $this->toolPrice($cartInfo['subtotalprice'], TRUE) : $this->toolPrice($cartInfo['totalprice'], TRUE),
            'totalnumber' => $cartInfo['totalqty'],
            'totalvweight' => 0,
        );
        $order_goods_ids = array();
        $order_goods_qtys = array();
        $order_goods_sku_ids = array();
        foreach ($cartInfo['orderitems'] as $item)
            {
                $order_goods_ids[] = $item['goods_id'];
                $order_goods_qtys[$item['goods_id']] = isset($order_goods_qtys[$item['goods_id']]) ? $order_goods_qtys[$item['goods_id']] + $item['qty'] : $item['qty'];
                $order_goods_sku_ids[] = $item['sku_id'];
				$order_sku_qtys[$item['sku_id']] =  $item['qty'];
            }
            $free_shipping = $this->load('SpecialOfferShippingJoinGoods')->getShippingInfo($order_goods_ids, $order_sku_qtys, $order_goods_sku_ids);
        $result = array();
        $corp_ids = array();
        $shippingCorp = array();
        
        foreach ($shipping as $key => $value)
        {
            $cart_param['totalweight'] = $cartInfo['totalweight'];
            //免运费处理
            if (isset($free_shipping[$value['id']]))
            {
                if ($free_shipping[$value['id']]['free_shipping_type'] == 1)
                {
                    $cart_param['totalweight'] = 0;
                    //$cart_param['totalprice'] = 0; 
                    $cart_param['totalnumber'] = 0;
                    $res = 0;
                }
                else
                {
                    $cart_param['totalweight'] = $cartInfo['totalweight'] - $free_shipping[$value['id']]['weight'];
                    //$cart_param['totalprice'] = $cartInfo['totalprice'] - $free_shipping[$value['id']]['price']; 
                    $cart_param['totalnumber'] = $cartInfo['totalqty'] - $free_shipping[$value['id']]['num'];
                    $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
                }
            }
            else
            {
                $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
            }
            if ($res !== FALSE)
            {
                $result[$key] = array(
                    'id' => $value['id'],
                    'base_name' => $value['base_name'] ? $value['base_name'] : $value['default_base_name'],
                    'price' => !$cartInfo['free_ship'] ? $this->toolPrice($res) : 0,
                    'shipping_corp_id' => $value['shipping_corp_id'],
                    'detail' => $value['detail'],
                );
                $corp_ids[$value['shipping_corp_id']] = $value['shipping_corp_id'];
            }
        }
        if (!empty($corp_ids))
        {
            $shippingCorpLogic = $this->load('shippingCorp');
            $cond = 'id in (' . implode(',', $corp_ids) . ')';
            $shippingCorp = $shippingCorpLogic->findAll($cond, TRUE);
        }
        $return = array();
        foreach ($result as $key => $item)
        {
            
            $corp = isset($shippingCorp[$item['shipping_corp_id']]) ? $shippingCorp[$item['shipping_corp_id']] : '';
            $item['image'] = isset($corp['image']) ? $corp['image'] : '';
            $item['corp_base_name'] = isset($corp['base_name']) ? $corp['base_name'] : '';
            $item['corp_href'] = isset($corp['href']) ? $corp['href'] : '';
            $return[$key] = $item;
        }
//        var_dump($cartInfo);
//        var_dump($return);
//            var_dump($cart_param);
//            _debug($free_shipping);
        echo json_encode($return);
    }
    
    /**
     * 获取支付手续费
     */
    public function actionGetPaymentFee()
    {
        $language_id = $this->language_id;
        $payment_id = Common::queryInt(_p('payment_id'));
        $insurance_selected = Common::queryInt(_p('insurance_selected'));
        $credits_value_amount = _p('credits_value_amount');
        $params = array(
            'sku_id' => _p('sku_id'),
            'sku_num' => _p('sku_num'),
            'type' => _p('type'),
            'package_id' => _p('package_id'),
            'shipping_id' => Common::queryInt(_p('shipping_id')),
        );
        
        $return = $this->getCreditInfo($params, $payment_id, $insurance_selected, $credits_value_amount);
        if($return && $insurance_selected)
        {
            $return['payment_amount'] = $return['payment_amount'] + $return['insurance_fee'];
        }
        $paymentLogic = $this->load('payment');
        $cond = '(language_id=0 or language_id=' . $language_id . ') and status=1 and id=' . $payment_id . ' order by listorder desc';
        $payment_info = $paymentLogic->getOne($cond);
        $return['status'] = 0;
        if($return['payment_amount']<$payment_info['min_order_amount']&&$payment_info['min_order_amount']!=0){
            $return['status'] = 1;
        }
        if($return['payment_amount']>$payment_info['max_order_amount']&&$payment_info['max_order_amount']!=0){
            $return['status'] = 2;
        }
//        var_dump($return);
        echo $return ? json_encode($return) : FALSE;
    }
    
    /**
     * ajax
     * 验证消费的积分
     */
    public function actionValidExpCredit()
    {
        $params = array(
            'sku_id' => _p('sku_id'),
            'sku_num' => _p('sku_num'),
            'type' => _p('type'),
            'package_id' => _p('package_id'),
            'shipping_id' => Common::queryInt(_p('shipping_id')),
        );
        $payment_id = Common::queryInt(_p('payment_id'));
        $insurance_selected = Common::queryInt(_p('insurance_selected'));
        $credit = _p('credit');
        $return = array('status' => 0, 'msg' => '', 'credit' => 0, 'amount' => 0);
        if (!is_numeric($credit))
        {
            $return['msg'] = 'This have illegal characters';
            echo json_encode($return);
            return;
        }
        $rs = $this->getCreditInfo($params, $payment_id, $insurance_selected);
        if ($rs)
        {
            if ($credit > $rs['max_exp_credit'])
            {
                $return['status'] = 1;
                $return['msg'] = 'Use only ' . $rs['max_exp_credit'] . ' credits';
                $return['credit'] = $rs['max_exp_credit'];
                $return['amount'] = $this->toolPrice($return['credit'] / $rs['exchange_credit_scale']);
                $return['payment_amount'] = $rs['payment_amount'] - $return['amount'];
                if($insurance_selected)
                {
                    $return['payment_amount'] += $rs['insurance_fee'];
                }
            }
            else
            {
                $return['status'] = 2;
                $return['credit'] = $credit;
                $return['amount'] = $this->toolPrice($credit / $rs['exchange_credit_scale']);
                $return['payment_amount'] = $rs['payment_amount'] - $return['amount'];
                if($insurance_selected)
                {
                    $return['payment_amount'] += $rs['insurance_fee'];
                }
            }
        }
        echo json_encode($return);
    }
    
    /**
     * 效验运费险 
     */
    public function actionValidInsurance()
    {
        $params = array(
            'sku_id' => _p('sku_id'),
            'sku_num' => _p('sku_num'),
            'type' => _p('type'),
            'package_id' => _p('package_id'),
            'shipping_id' => Common::queryInt(_p('shipping_id')),
        );
        $insurance = Common::queryInt(_p('insurance'));
        $rs = $this->getCreditInfo($params);
        if ($insurance)
        {
            $return = array(
                'payment_amount' => $rs['payment_amount'] + $rs['insurance_fee'],
                'insurance_fee' => $rs['insurance_fee'],
            );
        }
        else
        {
            $return = array(
                'payment_amount' => $rs['payment_amount'],
                'insurance_fee' => 0,
            );
        }

        echo json_encode($return);
    }
}
?>
