<?php

/**
 * Description of QuickOrder
 *
 * @author NT
 */
class ShippingToolController extends AppController {

    public function __construct() {
        parent::__construct();
    }

    /**
     * 默认件数为1，国家代码默认cookie
     */
    public function actionDefault() {
        $this->langLogic = $this->load('language');
        $language_id = $this->langLogic->language_id;
        $pri = _p('price');
        $wei = _p('weight');
        $country_id = _p('country_id');
        $quantity = $quantity ? $quantity : ( Common::queryInt(_p('quantity')) ? Common::queryInt(_p('quantity')) : 1);
        $totalweight = $wei * $quantity;
        if ($pri && $wei) {
            if (!$this->load('country')->getCount('id=' . $country_id . ' and status=1')) {
                echo 0;
                return;
            }
            $areaCountryRelLogic = $this->load('shippingAreaCountryRel');
            $area_ids = $areaCountryRelLogic->getListByCountryId($country_id);
            $shipping = array();
            if (!empty($area_ids)) {
                $shippingJoinLangLogic = $this->load('shippingJoinLanguage');
                $shipping = $shippingJoinLangLogic->getShippingByAreaIds($area_ids, $language_id);
            }
            foreach ($shipping as $key => $value) {
                $cart_param['totalweight'] = $totalweight;
                $cart_param["totalnumber"] = $quantity;
                $shippingLogic = $this->load('shipping');
                $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
                if ($res !== FALSE) {
                    $result[$key] = array(
                        'id' => $value['id'],
                        'base_name' => $value['base_name'] ? $value['base_name'] : $value['default_base_name'],
                        'price' => $this->toolPrice($res),
                        'shipping_corp_id' => $value['shipping_corp_id'],
                        'detail' => $value['detail'],
                    );
                    $corp_ids[$value['shipping_corp_id']] = $value['shipping_corp_id'];
                }
            }
            if (!empty($corp_ids)) {
                $shippingCorpLogic = $this->load('shippingCorp');
                $cond = 'id in (' . implode(',', $corp_ids) . ')';
                $shippingCorp = $shippingCorpLogic->findAll($cond, TRUE);
            }
            $return = array();
            foreach ($result as $key => $item) {
                $corp = isset($shippingCorp[$item['shipping_corp_id']]) ? $shippingCorp[$item['shipping_corp_id']] : '';
                $item['image'] = isset($corp['image']) ? $corp['image'] : '';
                $item['corp_base_name'] = isset($corp['base_name']) ? $corp['base_name'] : '';
                $item['corp_href'] = isset($corp['href']) ? $corp['href'] : '';
                $return[$key] = $item;
            }
        }
        $countryLogic = $this->load('country');
        $countrylist = $countryLogic->getCountries();
        $cur_country_id = Common::queryInt(_c('clientCountryID'));
        Core::$tpl->set('cur_country_id', $cur_country_id);
        Core::$tpl->set('countrylist', $countrylist);
        Core::$tpl->set('price', $pri);
        Core::$tpl->set('weight', $wei);
        Core::$tpl->set('return', $return);
    }

    /**
     * 费用=运费+单价*件数
     */
    public function actionCalculate($price, $weight, $quantity, $country_id) {
        $this->langLogic = $this->load('language');
        $language_id = $this->langLogic->language_id;
        $pri = $price ? $price : _p('price');
        $wei = $weight ? $weight : _p('weight');
        $country_id = _p('country_id');
        $quantity = $quantity ? $quantity : ( Common::queryInt(_p('quantity')) ? Common::queryInt(_p('quantity')) : 1);
        $totalweight = $wei * $quantity;
        if ($pri && $wei) {
            //$country_id = _c('clientCountryID');
            if (!$this->load('country')->getCount('id=' . $country_id . ' and status=1')) {
                echo 0;
                return;
            }
            $areaCountryRelLogic = $this->load('shippingAreaCountryRel');
            $area_ids = $areaCountryRelLogic->getListByCountryId($country_id);
            $shipping = array();
            if (!empty($area_ids)) {
                $shippingJoinLangLogic = $this->load('shippingJoinLanguage');
                $shipping = $shippingJoinLangLogic->getShippingByAreaIds($area_ids, $language_id);
            }
            foreach ($shipping as $key => $value) {
                $cart_param['totalweight'] = $totalweight;
                $cart_param["totalnumber"] = $quantity;
                $shippingLogic = $this->load('shipping');
                $res = $shippingLogic->getShippingCost($cart_param, $value['formula_param'], $value['formula'], $value['discount']);
                if ($res !== FALSE) {
                    $result[$key] = array(
                        'id' => $value['id'],
                        'base_name' => $value['base_name'] ? $value['base_name'] : $value['default_base_name'],
                        'price' => $this->toolPrice($res),
                        'shipping_corp_id' => $value['shipping_corp_id'],
                        'detail' => $value['detail'],
                    );
                    $corp_ids[$value['shipping_corp_id']] = $value['shipping_corp_id'];
                }
            }
            if (!empty($corp_ids)) {
                $shippingCorpLogic = $this->load('shippingCorp');
                $cond = 'id in (' . implode(',', $corp_ids) . ')';
                $shippingCorp = $shippingCorpLogic->findAll($cond, TRUE);
            }
            $return = array();
            foreach ($result as $key => $item) {
                $corp = isset($shippingCorp[$item['shipping_corp_id']]) ? $shippingCorp[$item['shipping_corp_id']] : '';
                $item['image'] = isset($corp['image']) ? $corp['image'] : '';
                $item['corp_base_name'] = isset($corp['base_name']) ? $corp['base_name'] : '';
                $item['corp_href'] = isset($corp['href']) ? $corp['href'] : '';
                $return[$key] = $item;
            }
            if ($price && $weight) {
                return $return;
            } else {
                echo json_encode($return);
            }
        } else {
            return $this->showMessage('illegal_parameters');
        }
    }

}
?>
