<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * Description of Task
 * @author hjp <huangjp@35zh.com>
 */

class TaskController extends AppController
{

    public function __construct()
    {

        parent::__construct();
        ignore_user_abort(true);
        set_time_limit(0);
    }
    
    /**
     * 触发事件任务
     * 可单个执行，也可批量执行
     */
    public function actionProcessTask()
    {
        $task_id = _g('task_id');
        $security_key = _g('security_key');
        $taskListLogic = $this->load('taskList');
        if($task_id)
        {
            if(!is_array($task_id))
            {
                $task_id = array();
                $task_id[] = Common::queryInt($task_id);
                $security_key = array();
                $security_key[] = Common::queryStr($security_key);
            }
            $status = $taskListLogic->process($task_id,$security_key);
        }
        else
        {
            $status = 0;
        }
        
        $return = array('status'=>$status);
        echo json_encode($return);
    }
    
    /**
     * 系统每天自动触发部分事件任务
     * @return type
     */
    public function actionProcessPartTask()
    {
        $taskListLogic = $this->load('taskList');
        $language_id = $this->load('language')->language_id;
        $cond = 'status=0 and language_id=' . $language_id . ' and trigger_time <=' . time();
        $count = $taskListLogic->getCount($cond);
        if ($count == 0)
        {
            return;
        }
        $cond .= ' limit ' . 0 . ',' . 20;
        $tasks = $taskListLogic->findAll($cond);
        $task_id = array();
        $security_key = array();
        foreach ($tasks as $task)
        {
            $task_id[] = $task['id'];
            $security_key[] = $task['security_key'];
        }
        echo $status = $taskListLogic->process($task_id,$security_key);
    }

}

?>
