<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Insurance
 *
 * @author rongxiang.xie <QQ:1251679791,359285617 www.35zh.com>
 */
class InsuranceController extends AppController
{
  private $insuranceLogic;
  private $insuranceLanguageLogic;
  public function __construct()
  {
    parent::__construct();
    $this->insuranceLogic = $this->load('insurance');
    $this->insuranceLanguageLogic = $this->load('insuranceLanguage');
  }
  public function actionConfig()
  {
    if(_p())
    {
      $insurance_id = Common::queryInt(_p('id'));
       //获取自定义shipping接口的数据
      $formula_param = array();
      foreach (_p() as $key => $value)
      {
          if (strpos($key, "exp_") !== false)
          {
              $formula_param[$key] = $value;
          }
      }
      $formula_param = json_encode($formula_param);
      $map = Zhtx::createDataMap();
      $map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
      $map->addEntry('formula', _p('formula'), DB::VARCHAR);
      $map->addEntry('formula_param', Common::strEscape($formula_param,false), DB::VARCHAR);
      $map->addEntry('is_default', Common::queryInt(_p('is_default')), DB::INT);
      $res = FALSE;
      if($insurance_id)
      {
        $res = $this->insuranceLogic->updateById($map, $insurance_id);
      }
      else
      {
        $map->addEntry('create_time', SYS_TIME, DB::INT);
        $res = $this->insuranceLogic->insert($map);
        $insurance_id = $res;
      }
      if($res && $insurance_id)
      {
        $lang_map = Zhtx::createDataMap();
        $this->insuranceLanguageLogic->delete('insurance_id=' . $insurance_id);
        foreach (_p('remark') as $key => $value)
        {
            $lang_map->addEntry('insurance_id', $insurance_id);
            $lang_map->addEntry('language_id', $key);
            $lang_map->addEntry('remark', $value);
            $this->insuranceLanguageLogic->insert($lang_map);         
        }
        return $this->success('save_success');
      }
      return $this->showMessage('save_failure');
    }
    else
    {
      $config = $this->insuranceLogic->getOne();
      $insuranceLangs = array();
      foreach($this->insuranceLanguageLogic->findAll('insurance_id='. $config['id']) as $lang)
      {
        $insuranceLangs[$lang['language_id']] = $lang;
      }
      Core::$tpl->set('insurance', $config);
      Core::$tpl->set('formula', $this->getFormula());
      Core::$tpl->set('languages', $this->load('language')->findAll('status=1', true));
      Core::$tpl->set('insuranceLanguages', $insuranceLangs);
    }
  }
  public function actionGetParamForm()
  {
     $api_dir = './api/insurance/';
      $id     =  _g("id");
      $folder =  _g("folder");
      if(!$folder)
		{
			echo "";
			die();
		}
	  $insurance = array();
      if($id)
      {
        $insurance = $this->insuranceLogic->getOne('id=' . $id);
      }
      $param=array();
      if($insurance)
      {
          if($insurance["formula_param"]!="")
          {
              $param = json_decode($insurance["formula_param"],true);
          }
      }
       global $site_info;
		$param['standard_code']  =  $site_info['currency']['standard_code'];
      if(is_file(APP_ROOT.$api_dir.$folder.'/form.php'))
      {
          require_once APP_ROOT.$api_dir.$folder.'/form.php';
      }
      exit();
  }
  
  /**
     * 获得配送列表
     */
    private function getFormula()
    {
        $api_dir = './api/insurance/';
        $formula = array();
        $fp = opendir($api_dir);
        while ($file = readdir($fp))
        {
            if ($file != '.' && $file != '..'&& $file != '.svn')
            {
               if( is_dir($api_dir.$file ) )
			   {
				   $formula_item = array();
				   $formula_item["name"] = trim(file_get_contents($api_dir . $file . '/readme.txt'));
				   $formula_item["formula"] = trim($file);
				   $formula[] = $formula_item;
			   }
			}
        }
        closedir($fp);
        return $formula;
    }
}

?>
