<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Order
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class OrderController extends AppController
{
  private $orderLogic;
  private $langLogic;
  private $logLogic;
  private $skuLogic;
  private $admin_id;
  private $admin_name;
  private $orderPayJoinAddrUserLogic;
  public function __construct()
    {
       parent::__construct();
       $this->langLogic  = $this->load('language');
       $this->orderLogic = $this->load('order');
       $this->logLogic   = $this->load('orderLog');
       $this->skuLogic   = $this->load('sku');
       $this->propertyLogic = $this->load('property');
       $this->orderPayJoinAddrUserLogic = $this->load('OrderJoinPaymentJoinAddress');
       $this->admin_id   = Common::queryInt(_c('admin_id') ? _c('admin_id') : _s('id'));
       $this->admin_name = _c('admin_name') ? _c('admin_name') : _s('user_name');
    }
    public function actionList()
    {
       $countryLogic  = $this->load('country');
       $userLogic     = $this->load('user');
       $shippingLogic = $this->load('shipping');
       $orderPaymentLogic = $this->load('orderPayment');
       $orderLogic     = $this->load('order');
       $order_unpay_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and o.order_status between 100 and 199');
       $order_exceptionpay_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and payment_status=105 and o.order_status between 300 and 399');
       $order_deal_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and o.order_status between 200 and 299 and shipping_status=0');
       $order_shiped_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and o.order_status=204');
       $order_receiving_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and o.order_status between 205 and 299');
       $order_cancel_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and o.order_status between 600 and 699');
       $order_complete_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and shipping_status=205 and o.order_status between 700 and 799');
       $order_return_goods_count = $this->orderPayJoinAddrUserLogic->getOrderStatusCount('1=1 and o.order_status between 300 and 399');
       $where = '1=1';
        if (_g('itemno'))
        {
            $where .= " and o.itemno like '%" . _g('itemno') . "%' ";
        }
        if (_g('user_id'))
        {
            $where .= " and o.user_id = '" . _g('user_id') . "' ";
        }
        if (_g('user_email'))
        {
            $user = $userLogic->getOne("base_name='" . _g('user_email') . "'");
            $where .= " and o.user_id = '" . $user['id'] . "' ";
        }
        if(_g('start_time') && _g('end_time'))
        {
            $where .= ' and o.create_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        }
        else if(_g('start_time'))
        {
            $where .= ' and o.create_time >= ' . strtotime(_g('start_time'));
        }
        else if(_g('end_time'))
        {
            $where .= ' and o.create_time <= ' . strtotime(_g('end_time'));
        }
        if(_g('language_id'))
        {
          $where .= ' and o.language_id=' . _g('language_id');
        }
        if(_g('country_id'))
        {
          $where .= ' and o.country_id=' . _g('country_id');
        }
        if(_g('order_status'))
        {
            if(_g('order_status')==200)
              $where .= ' and shipping_status=0';
            if(_g('order_status')==301)
              $where .= ' and payment_status=105';
            if(_g('order_status')==700)
              $where .= ' and shipping_status=205';
            if(_g('order_status')==204)
              $where .= ' and o.order_status='. _g('order_status') ;
            else if(_g('order_status')==205)
              $where .= ' and o.order_status between '. _g('order_status') . ' and ' . (_g('order_status')+94);
            else if(_g('order_status')==301)
              $where .= ' and o.order_status between '. _g('order_status') . ' and ' . (_g('order_status')+95);
            else
              $where .= ' and o.order_status between '. _g('order_status') . ' and ' . (_g('order_status')+99);
        }
        if(_g('email'))
        {
          $where .= ' and a.email="' . _g('email') . '"';
        }
        $curr_page = Common::queryInt(_g('page'), 1);
        $page_size = Common::queryInt(_g('psize'), 20);
        $sort_obj  = _g('order') ? _g('order') : 'id';
        $sort_type = _g('path') ? _g('path') : 'desc';
        $orderJoinAddrUserLogic = $this->load('OrderJoinAddress');
         if(_g('payment_id'))
        {
          $where .= ' and p.payment_id=' . _g('payment_id');

          $sqlmd5 = md5($where);
          $count  = Common::queryInt(_s($sqlmd5));
          if(!$count)
          {
            $count_array = $this->orderPayJoinAddrUserLogic->getOne($where, array('count(DISTINCT p.order_id) as count'));
            $count     = $count_array['count'];
            _setSession($sqlmd5, $count);
          }
          $page_data = Common::getPages($count, $curr_page, $page_size);
          $order_ids = $this->orderPayJoinAddrUserLogic->getCurrentDatas($where, $page_size, $curr_page);
          $ids = array();
          foreach ($order_ids as $value)
          {
            $ids[] = $value['order_id'];
          }
          $orderList = array();
          if(count($ids) > 0)
          {
            $cond = 'o.id in (' .implode(',', $ids) . ') order by o.'. $sort_obj . ' ' . $sort_type;
            $orderList = $orderJoinAddrUserLogic->findAll($cond);
          }
        }
        else
        {
          $sqlmd5 = md5($where);
          $count  = Common::queryInt(_s($sqlmd5));
          if(!$count)
          {
            $count     = $orderJoinAddrUserLogic->getCount($where);
            _setSession($sqlmd5, $count);
          }
          $page_data = Common::getPages($count, $curr_page, $page_size);
          $where .= ' order by o.' . $sort_obj . ' ' . $sort_type;
          $orderList = $orderJoinAddrUserLogic->getCurrentDatas($where, $page_size, $curr_page);
        }
       $country_id  = array();
       $language_id = array();
       $shipping_id = array();
       $user_id     = array();
       $orderIds    = array();
       foreach ($orderList as $key=>$value)
       {
          $country_id[$value['country_id']]   = $value['country_id'];
          $language_id[$value['language_id']] = $value['language_id'];
          $shipping_id[$value['shipping_id']] = $value['shipping_id'];
          $user_id[$value['user_id']]         = $value['user_id'];
          $orderIds[] = $value['id'];
          $orderPayment = $orderPaymentLogic->findAll('order_id=' . $value['id'] . ' order by payment_type asc');
          $orderList[$key]['payment_id'] = isset($orderPayment[0]['payment_id'])? $orderPayment[0]['payment_id'] : '';
          $orderList[$key]['marked'] = str_pad(decbin($value['marked']), 3, "0", STR_PAD_LEFT);
       }
       $countrys  = $countryLogic->getAll();
       $languages = $this->langLogic->findAll('', TRUE);
       $shipping_id_str = count($shipping_id) > 0 ? implode(',', $shipping_id) : 0;
       $shipping_cond = 'id in (' . $shipping_id_str . ')';
       $shippings = $shippingLogic->getCols($shipping_cond, array('id', 'base_name'), TRUE);
       $payments  = $this->load('payment')->findAll('status=1', true);
       $user_id_str = count($user_id) > 0 ? implode(',', $user_id) : 0;
       $user_cond = 'id in (' . $user_id_str . ')';
       $users = $userLogic->getCols($user_cond, array('id', 'base_name'), TRUE);
       $history_cond = 'user_id in (' . $user_id_str . ') GROUP BY user_id';
       $history_orders_nums = $orderLogic->getCols($history_cond, array('user_id', 'COUNT(user_id) AS user_orders'));
       foreach ($history_orders_nums as $key => $value) {
           $user_orders[$value['user_id']]=$value['user_orders'];
       }
       $remarks = array();
       if(count($orderIds) > 0 )
       {
         $remark_cond = 'order_id in(' . implode(',', $orderIds) . ') order by create_time asc' ;
         $remarks     = $this->load('orderRemark')->findAll($remark_cond);
       }
       $remark_arr  = array();
       foreach ($remarks as $remark)
       {
         $remark_arr[$remark['order_id']] = $remark;
       }
       Core::$tpl->set('user_orders', $user_orders);
       Core::$tpl->set('orderpayment', isset($orderPayment[0])? $orderPayment[0] : '');
       Core::$tpl->set('orderlist', $orderList);
       Core::$tpl->set('countrys', $countrys);
       Core::$tpl->set('languages', $languages);
       Core::$tpl->set('shippings', $shippings);
       Core::$tpl->set('users', $users);
       Core::$tpl->set('payments', $payments);
       Core::$tpl->set('remarks', $remark_arr);
       Core::$tpl->set('pages', $page_data);
       Core::$tpl->set('order_unpay_count', $order_unpay_count);
       Core::$tpl->set('order_exceptionpay_count', $order_exceptionpay_count);
       Core::$tpl->set('order_deal_count', $order_deal_count);
       Core::$tpl->set('order_shiped_count', $order_shiped_count);
       Core::$tpl->set('order_receiving_count', $order_receiving_count);
       Core::$tpl->set('order_cancel_count', $order_cancel_count);
       Core::$tpl->set('order_complete_count', $order_complete_count);
       Core::$tpl->set('order_return_goods_count', $order_return_goods_count);
    }
    /**
     * 订单操作
     * @global type $cfg
     * @return type
     */
    public function actionDetail()
    {
      global $cfg;
      $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
      $order_id = Common::queryInt(_g('id'));
       $order    = $this->orderLogic->getOneById($order_id);
       if(!$order)
       {
           return $this->showMessage('illegal_parameters');
       }
       $orderItemLogic    = $this->load('orderItemJoinSkuProduct');
       $userJoinInfoLogic = $this->load('userJoinInfo');
       $orderAddressLogic = $this->load('orderAddress');
       $shippingLogic     = $this->load('shipping');
       $orderPaymentLogic = $this->load('orderPayment');
       $paymentLogic      = $this->load('payment');
       $currentLogic      = $this->load('currency');
       $countryLogic      = $this->load('country');
       $shippingCorpLogic = $this->load('shippingCorp');
       $deliveryLogic     = $this->load('orderDelivery');
       $deliveryItemLogic = $this->load('orderDeliveryItem');
       $orderOfferLogic   = $this->load('orderOffer');
       $messageLogic      = $this->load('message');
       $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
       $productLogic      = $this->load('product');
       $orderItems  = $orderItemLogic->findAll('i.order_id='. $order_id.' and i.status=1');
       $language_id = $cfg['sites'][0]['base_site'];
       $item_result = array();
       $total_refund_amount = 0;//需要退款的总金额
	   //---  读取属性的基准数组
	   $proLogic = $this->load('property');
	   $propertys = $proLogic->findAll('parent_id=0', true);
       foreach ($orderItems as $item)
       {
          $property_ids = explode('_', $item['sku_code']);
          $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
          $shipinfo      = $deliveryItemLogic->getShipInfo($item['id'], $item['goods_id'], $item['sku_code'], $item['buy_num']);
          $item['shiped_num']   = $shipinfo['shiped_num'];
          $item['unshiped_num'] = $shipinfo['unshiped_num'] - $item['return_num'];
          $item['subtotal']     = $item['price'] * $item['buy_num'];
          $item['attr']  = $attr;
          $cond = 'goods_id='.$item['goods_id'];
          $count = $productLogic->getCount($cond);
		  $goodsinfo  = $this->load('goods')->getOne('id='.$item['goods_id']);
		  $item['gcodeno'] = $goodsinfo['codeno'];
          if($count==1){
            $goodsinfo  = $this->load('goods')->getOne('id='.$item['goods_id']);
            $item['image'] = $goodsinfo['image'];
			$item['gcodeno'] = $goodsinfo['codeno'];
          }else{
            $master_property = explode('_', $item['sku_code']);
            $cond = 'goods_id='.$item['goods_id'].' and property_id='.$master_property[0];
            $productinfo  = $productLogic->getOne($cond);
            if($productinfo['image'])
            {
              $item['image'] = $productinfo['image'];
            }
          }
          if($item['sku_value'])
          {
              $sku_value = explode('_', $item['sku_value']);
              foreach ($sku_value as $key => $value)
              {
                  if($value)
                  {
                      $item['sku_value_items'][] = $value;
                  }
              }
          }
          $item_result[$item['id']] = $item;
          if($item['status'] == 2)
          {
            $total_refund_amount += $item['price'] * $item['return_num'];
          }
       }
//       _debug($item_result);
       $userinfo     = $userJoinInfoLogic->getUserById($order['user_id']);
       $addr_cond    = 'order_id=' . $order['id'];
       $currency_cond = 'standard_code = "' . $order['currency_code'] . '"';
       $orderAddress = $orderAddressLogic->getOne($addr_cond);
       $shipping     = $shippingLogic->findAll('status=1', true);
       $payments     = $paymentLogic->findAll('status=1', true);
       $currency     = $currentLogic->getOne($currency_cond);
       $orderPayment = $orderPaymentLogic->findAll('order_id=' . $order['id'] . ' order by payment_type asc');
       $shippingCorp_id = $shipping[$order['shipping_id']]['shipping_corp_id'];
       $received_record = array();
       $refund_record   = array();
       $refunded_amount = 0;
       foreach ($orderPayment as $pay)
       {
         if($pay['payment_type'] == 1)
         {
            $received_record[] = $pay;
         }
         else
         {
            $refund_record[] = $pay;
            if($pay['status'] == 1)
            {
              $refunded_amount += $pay['amount'];
            }
         }
       }
       $ship_record   = array();//发货记录
       $return_record = array();
       $corp_ids      = array();//物流公司IDS
       $trackObj      = array();
       foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val)
       {
          if($val['delivery_type'] == 1)
          {
             $ship_record[$val['id']] = $val;
          }
          else
          {
             $return_record[] = $val;
          }
          if($val['status'] == 1)
          {
            $corp_ids[]      = $val['shipping_corp_id'];
            $val['delivery_data'] = json_decode($val['delivery_data'],true);
            $trackObj[] = $val;
          }
       }
       $corps = $shippingCorpLogic->findAll('', TRUE);
//      _debug($item_result);
       $marker = array(
           '1' => $lang['undetermined_order'],
           '2' => $lang['order_ship'],
           '3' => $lang['order_return'],
           '4' => $lang['order_refund'],
           '5' => $lang['order_exp'],
           '6' => $lang['order_cancel'],
           '7' => $lang['order_erp'],
           '8' => $lang['order_paid'],
           );
       $source_country = $this->load('ipJoinCountry')->getOne($order['ip'] . ' between  i.startip and i.endip');
       $true_refund = $order['payed']- $order['final_amount'];
       if($order['billing_address_id'])
       {
           $userAddressLogic = $this->load('userAddress');
           $billing_address = $userAddressLogic->getOneById($order['billing_address_id']);
           Core::$tpl->set('billing_address', $billing_address);
       }
       Core::$tpl->set('propertys', $propertys);
       Core::$tpl->set('order', $order);
       Core::$tpl->set('orderItem',  $item_result);
       Core::$tpl->set('user', $userinfo);
       Core::$tpl->set('address', $orderAddress);
       Core::$tpl->set('shippings', $shipping);
	   Core::$tpl->set('corps', $corps);


       Core::$tpl->set('orderpayment', isset($orderPayment[0])? $orderPayment[0] : '');
       Core::$tpl->set('received_record', $received_record);
       Core::$tpl->set('refund_record', $refund_record);
       Core::$tpl->set('payments', $payments);
       Core::$tpl->set('user_currency', $currency);
       Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
       Core::$tpl->set('shippingCorp', $corps[$shippingCorp_id]);
       Core::$tpl->set('shippingCorps', $corps);
       Core::$tpl->set('ship_record', $ship_record);
       Core::$tpl->set('return_record', $return_record);
       Core::$tpl->set('order_log', $this->logLogic->findAll('order_id='.$order_id ));
       Core::$tpl->set('order_offer', $orderOfferLogic->findAll('order_id='.$order_id ));
       Core::$tpl->set('messages', $messageLogic->findAll('order_id='.$order_id . ' order by parent_id asc' ));
       Core::$tpl->set('tracking', $trackObj);
       Core::$tpl->set('language', $this->langLogic->getOneById($order['language_id']));
       Core::$tpl->set('remarks', $this->load('orderRemark')->findAll('order_id=' . $order_id . ' order by create_time desc'));
       Core::$tpl->set('markers' , $marker);
       Core::$tpl->set('true_refund' , $true_refund > 0 ? $true_refund : 0);
       Core::$tpl->set('source_country' , $source_country);
    }
    /**
     * 更改订单状态
     */
    public function actionChangeStatus()
    {
      $order_id = Common::queryInt(_g('order_id'));
      $status   = Common::queryInt(_g('status'));
      $order    = $this->orderLogic->getOneById($order_id);
      $map      = Zhtx::createDataMap();
      if($status == 203)
      {
         if(!$order)
         {
           return $this->showMessage('illegal_operation');
         }
         $cols = array('sum(buy_num) as buy_nums', 'sum(return_num) as return_nums');
         $items = $this->load('orderItem')->getCols('order_id=' . $order_id, $cols);
         $flag  = 0;
         foreach ($items as $item)
         {
           $flag = $item['return_nums'] - $item['buy_nums'];
         }
         if($flag == 0)
         {
           return $this->showMessage('order_return_all');
         }
        if($order['payment_status'] == 201 || ($order['final_amount'] == $order['payed'] && $order['order_status'] == 405))
        {
          $map->addEntry('order_status', 203, DB::INT);
          $map->addEntry('shipping_status', 203, DB::INT);
        }
      }
      else if($status == 205)
      {
         if(!$order || $order['shipping_status'] != 204)
          {
            return $this->showMessage('illegal_operation');
          }

		   $status_data = array(
              'delivery_status'     => 2,
          );
          $this->load('orderDelivery')->saveByCond($status_data, 'order_id=' . $order_id);

		  $status_data = array(
              'sign_time'     => SYS_TIME,
          );
          $this->load('orderDelivery')->saveByCond($status_data, 'order_id=' . $order_id . ' and sign_time=0');

          $map->addEntry('order_status', $status, DB::INT);
          $map->addEntry('shipping_status', $status, DB::INT);
      }
      else if($status == 700)
      {
        if($order && ($order['order_status'] == 205 || $order['order_status'] == 405 || $order['order_status'] == 406))
        {
          $map->addEntry('order_status', $status, DB::INT);
		  EventFactory::orderCompleteAfter($order);
        }
        else
        {
          return $this->showMessage('illegal_operation');
        }
      }
      $res = $this->orderLogic->updateById($map, $order_id);
      $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
      $order_log_data = array(
              'admin_id'    => $this->admin_id,
              'admin_name'  => $this->admin_name,
              'order_id'    => $order_id,
              'result'      => $res ? 1 : 0,
              'remark'      => $lang['operation'] .': '. $this->admin_name . ' ' .$lang['change_order_status'] . ': ' . Common::orderStatus($status),
              'behavior'    => 'order_status_change',
              'create_time' => SYS_TIME,
        );
      $this->logLogic->save($order_log_data);
      return $this->success('operation_success', Common::adminURL('order', 'order', 'detail', array('id' => $order_id)));
    }

    /**
     * 激活订单
     */
    public function actionActivation()
    {
      $order_id = Common::queryInt(_g('id'));
      $order    = $this->orderLogic->getOneById($order_id);
      $map      = Zhtx::createDataMap();

         if(!$order)
         {
           return $this->showMessage('illegal_operation');
         }

          $map->addEntry('order_status', 100, DB::INT);
          $map->addEntry('payment_status', 101, DB::INT);

      $res = $this->orderLogic->updateById($map, $order_id);
      $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
      $order_log_data = array(
              'admin_id'    => $this->admin_id,
              'admin_name'  => $this->admin_name,
              'order_id'    => $order_id,
              'result'      => $res ? 1 : 0,
              'remark'      => $lang['operation'] .': '. $this->admin_name . ' ' .$lang['activation_order_status'] . ': ' . Common::orderStatus('100'),
              'behavior'    => 'activation_order_status',
              'create_time' => SYS_TIME,
        );
      $this->logLogic->save($order_log_data);
      return $this->success('operation_success', Common::adminURL('order', 'order', 'detail', array('id' => $order_id)));
    }

    /**
     * 手工生成收款单
     * 第一次支付成功的时候冻结库存
     * @return type
     */
    public function actionOrderPay()
    {
       $order_id = Common::queryInt(_p('order_id'));
       $order    = $this->orderLogic->getOneById($order_id);
       $current_status = $order['order_status'];
       if(!$order)
       {
          return $this->showMessage('illegal_parameters');
       }
       if($order['order_status'] >= 200)
       {
          return $this->showMessage('completed_payment_reminder');
       }
       $pay_account_type = Common::strEscape(_p('pay_account_type'));
       $pay_account      = Common::strEscape(_p('pay_account'));
       $amount           = _p('amount');
       $pay_type         = _p('pay_type');
       $payment_id       = _p('payment_id');
       $pay_method_no    = Common::strEscape(_p('pay_method_no'));
       $real_currency_id = Common::queryInt(_p('real_currency_id'));
       $remark     = Common::strEscape(_p('remark'));
       if(!$pay_account_type || !$pay_account || !$amount  || !$payment_id)
       {
          return $this->showMessage('form_error_tip');
       }
       $order_payed    = $amount + $order['payed'];
       $order_status   = 103;
       $payment_status = 103;
       $offset_amount  = 0;
       if($order_payed > $order['final_amount'])
       {
          $order_status   = 105;
          $payment_status = 105;
          $offset_amount  = $order_payed - $order['final_amount'];
       }
       else if($order_payed < $order['final_amount'])
       {
           $order_status   = 104;
           $payment_status = 104;
           $offset_amount  = $order['final_amount'] - $order_payed;
       }
       else if($order_payed == $order['final_amount'])
       {
           $order_status   = 201;
           $payment_status = 201;
       }
       $orderPaymentLogic = $this->load('orderPayment');
       $currencyLogic     = $this->load('currency');
       if($real_currency_id)
       {
          $real_currency_cond = 'id=' . $real_currency_id;
       }
       else
       {
          $real_currency_cond = 'standard_code="' . $order['currency_code'] . '"';
       }
       $real_currency = $currencyLogic->getOne($real_currency_cond);
       $trade_no      = date('Ymdhsi', time()) . Common::random(6);
       $order_payment_data = array(
           'order_id' => $order_id,
           'payment_type' => 1,
           'trade_no'     => $trade_no,
           'user_id'      => $order['user_id'],
           'pay_account'  => $pay_account,
           'pay_account_type'     => $pay_account_type,
           'amount'               => $amount/$real_currency['exchange_rate'],
           'base_currency_id'     => Common::queryInt(_s('base_currency_id')),
           'real_currency_id'     => $real_currency['id'],
           'real_currency_amount' => $amount,
           'pay_type' => $pay_type,
           'payment_id' => $payment_id,
           'status' => 1,
           'remark' => Common::strEscape(_p('remark')),
           'create_time' => SYS_TIME,
           'end_time'    => SYS_TIME,
           'payer'       => Common::strEscape(_p('payer')),
           'pay_method_no' => $pay_method_no,
       );
       $res = $orderPaymentLogic->save($order_payment_data);

       //订单操作日记系统记录开始
       $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
       $admin_id   = $this->admin_id;
       $admin_name = $this->admin_name;
       $pay_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'remark'      => $lang['operation'] .': '. $admin_name . ' ' . $lang['create_beneficiary_no'] .': ' . $trade_no .' '. $lang['amount'].': ' . $amount,
               'behavior'    => 'create_beneficiary_record',
               'create_time' => SYS_TIME,
         );
       if ($remark)
      {
        $order_remark_data = array(
            'admin_id'    => $admin_id,
            'admin_name'  => $admin_name,
            'order_id'    => $order_id,
            'ip'          => Common::_ip2long(Common::ip()),
            'remark'      => $remark,
            'marker'      => 7,
            'remark_type' => $order['order_status'],
            'create_time' => SYS_TIME,
          );
          $res = $this->load('orderRemark')->save($order_remark_data);
      }
       if($res)
       {
           $pay_log_data['result'] = 1;
          //判断是否切入人工优惠/增收处理
          if($offset_amount && _p('is_offset'))
          {
            $orderOfferLogic = $this->load('orderOffer');
            $order_offer_data = array(
                'order_id'  => $order_id,
                'amount'   => $offset_amount,
                'order_offer_type' => _p('order_offer_type'),
            );
            $offer_res = $orderOfferLogic->save($order_offer_data);
            if($offer_res)
            {
              $order_status   = 201;
              $payment_status = 201;
            }
            $offer_log_data = array(
                'admin_id'    => $admin_id,
                'admin_name'  => $admin_name,
                'order_id'    => $order_id,
                'result'      => $offer_res ? 1 : 0,
                'remark'      => $lang['operation'] .': '. $admin_name . ' ' .  $lang['add_offer'] .': '. $lang['manual_discount'] . ' ID：' . $offer_res,
                'behavior'    => 'offer_add',
                'create_time' => SYS_TIME,
            );
            $this->logLogic->save($offer_log_data);
          }
          //更新订单状态
           $order_data = array(
               'payed'          => $order_payed,
               'order_status'   => $order_status,
               'payment_status' => $payment_status,
               'act_time'       => SYS_TIME,
           );
           $order_res = $this->orderLogic->save($order_data, $order_id);
           if($order_status == 201 && $payment_status == 201)
           {
                $this->load('goods')->updateBuyCounts($order_id);
           }
           $order_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'result'      => $order_res ? 1 : 0,
               'remark'      => $lang['operation'] .': '. $admin_name . ' ' .$lang['change_order_status'] . ': ' . Common::orderStatus($order_status),
               'behavior'    => 'order_status_change',
               'create_time' => SYS_TIME,
          );
          $this->logLogic->save($order_log_data);
          //第一次支付成功的时候冻结库存
          if($current_status < 104)
          {
            $this->load('orderItem')->updateStock($order_id);
          }
          //成长值
          if($order_res && $payment_status == 201)
          {
            $order['payed']          = $order_payed;
            $order['order_status']   = $order_status;
            $order['payment_status'] = $payment_status;
            GrowthFactory::orderPayAfter($order);
            GrowthFactory::recommendUserFirstPayAfter($order);
            EventFactory::orderPayAfter($order);
            EventFactory::recommendUserFirstPayAfter($order);
            //EventFactory::adminReceivePayment($order);
            CreditFactory::backOrderPayAfter($order);
          }
       }
       else
       {
          $pay_log_data['result'] = 0;
       }
       $this->logLogic->save($pay_log_data);
       return $res ? $this->success('save_success') : $this->showMessage('save_failure');
    }
    /**
     * 人工优惠
     * @return type
     */
    public function actionSystemOffer()
    {
      $order_id = Common::queryInt(_p('order_id'));
      $order    = $this->orderLogic->getOneById($order_id);
      if(!$order)
      {
        return $this->showMessage('illegal_operation');
      }
      if($order['shipping_status'] < 204 && $order['payment_status'] !=406 && $order['order_status'] < 600)
      {
        $offer_type   = _p('offer_type');
        $offer_amount = _p('offer_amount');
        if($offer_amount > $order['final_amount'])
        {
            return $this->showMessage('illegal_parameters');
        }
        $lang       = Common::lang(Core::$controller, Core::$module, Core::$language);
        $admin_id   = _c('admin_id');
        $admin_name = _c('admin_name');
        $orderOfferLogic = $this->load('orderOffer');
        $order_data       = array();
        $order_offer_data = array(
            'order_id'  => $order_id,
             'amount'   => $offer_amount,
        );
        if($offer_type == 1)
        {
          $order_offer_data['offer_base_name']  = '系统人工减金额';
          $order_offer_data['order_offer_type'] = _p('order_reduce_type');
          $order_data['total_amount'] = $order['total_amount']-$offer_amount;
          $order_data['final_amount'] = $order['final_amount']-$offer_amount;

          $order_data['cost_offer']   = $order['cost_offer'] + $offer_amount;
        }
        else if($offer_type == 2)
        {
          $order_offer_data['offer_base_name']  = '系统人工增收金额';
          $order_offer_data['order_offer_type'] = _p('order_add_type');
          $order_data['total_amount'] = $order['total_amount'] + $offer_amount;
          $order_data['final_amount'] = $order['final_amount'] + $offer_amount;
//          if($order['cost_offer'] < $offer_amount)
//          {
//            return $this->showMessage('illegal_operation');
//          }
          $order_data['cost_offer']   = $order['cost_offer'] - $offer_amount;
        }
        $offer_res = $orderOfferLogic->save($order_offer_data);
        $offer_log_data = array(
              'admin_id'    => $admin_id,
              'admin_name'  => $admin_name,
              'order_id'    => $order_id,
              'result'      => $offer_res ? 1 : 0,
              'remark'      => $lang['operation'] .': '. $admin_name . ' ' .  $lang['add_offer'] .': '. $lang['manual_discount'] . ' ID：' . $offer_res,
              'behavior'    => 'offer_add',
              'create_time' => SYS_TIME,
          );
        $this->logLogic->save($offer_log_data);
        if($offer_res)
        {
          $order_res = $this->orderLogic->save($order_data, $order_id);
           $order_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'result'      => $order_res ? 1 : 0,
               'remark'      => $lang['operation'] .': '. $admin_name . ' ' . $lang['change_order_amount'] . ', ' . $lang['order_itemno']. ': '. $order['itemno'] . ' 金额' . $order['currency_code'].$order['final_amount'] . ' 改为' . $order['currency_code'].$order_data['final_amount'],
               'behavior'    => 'order_payment_amount_change',
               'create_time' => SYS_TIME,
          );
          $this->logLogic->save($order_log_data);
        }
      }
      return $this->success('operation_success', Common::adminURL('order', 'order', 'edit', array('id' => $order_id)));
    }

    /**
     * 修改运费
     * @return type
     */
    public function actionUpdateShippingFee()
    {
      $order_id = Common::queryInt(_p('order_id'));
      $order    = $this->orderLogic->getOneById($order_id);
      if(!$order)
      {
        return $this->showMessage('illegal_operation');
      }
      if($order['shipping_status'] < 204 && $order['payment_status'] !=406 && $order['order_status'] < 600)
      {
        $shipping_type   = _p('shipping_type');
        $shipping_amount = _p('shipping_amount');
        $lang       = Common::lang(Core::$controller, Core::$module, Core::$language);
        $admin_id   = _c('admin_id');
        $admin_name = _c('admin_name');
        //$orderOfferLogic = $this->load('orderOffer');
        $order_data       = array();
//        $order_offer_data = array(
//            'order_id'  => $order_id,
//             'amount'   => $shipping_amount,
//        );
        if($shipping_type == 1)
        {
          $order_data['total_amount'] = $order['total_amount']-$shipping_amount;
          $order_data['final_amount'] = $order['final_amount']-$shipping_amount;
          switch (_p('order_shipping_reduce_type')) {
              case '103':
                  if($order['cost_shipping'] < $shipping_amount)
                  {
                      return $this->showMessage('illegal_operation');
                  }
                  $order_data['cost_shipping'] = $order['cost_shipping'] - $shipping_amount;
                  $behavior = 'order_shipping_fee_del';
                  break;
              case '107':
                  if($order['insurance'] < $shipping_amount)
                  {
                      return $this->showMessage('illegal_operation');
                  }
                  $order_data['insurance'] = $order['insurance'] - $shipping_amount;
                  $behavior = 'order_insurance_del';
                  break;
              default:
                  break;
          }
        }
        else if($shipping_type == 2)
        {
          $order_data['total_amount'] = $order['total_amount'] + $shipping_amount;
          $order_data['final_amount'] = $order['final_amount'] + $shipping_amount;
          switch (_p('order_shipping_add_type')) {
              case '203':
                  $order_data['cost_shipping'] = $order['cost_shipping'] + $shipping_amount;
                  $behavior = 'order_shipping_fee_add';
                  break;
              case '207':
                  $order_data['insurance'] = $order['insurance'] + $shipping_amount;
                  $behavior = 'order_insurance_add';
                  break;
              default:
                  break;
          }
        }
        $order_res = $this->orderLogic->save($order_data, $order_id);
        $order_log_data = array(
              'admin_id'    => $admin_id,
              'admin_name'  => $admin_name,
              'order_id'    => $order_id,
              'result'      => $order_res ? 1 : 0,
              'remark'      => $lang['operation'] .': '. $admin_name . ' ' .  $lang[$behavior] .': ID：' . $order_res,
              'behavior'    => $behavior,
              'create_time' => SYS_TIME,
          );
        $this->logLogic->save($order_log_data);
//        if($offer_res)
//        {
//          $order_res = $this->orderLogic->save($order_data, $order_id);
//           $order_log_data = array(
//               'admin_id'    => $admin_id,
//               'admin_name'  => $admin_name,
//               'order_id'    => $order_id,
//               'result'      => $order_res ? 1 : 0,
//               'remark'      => $lang['operation'] .': '. $admin_name . ' ' . $lang['change_order_amount'] . ', ' . $lang['order_itemno']. ': '. $order['itemno'] . ' 金额' . $order['currency_code'].$order['final_amount'] . ' 改为' . $order['currency_code'].$order_data['final_amount'],
//               'behavior'    => 'order_payment_amount_change',
//               'create_time' => SYS_TIME,
//          );
//          $this->logLogic->save($order_log_data);
//        }
      }
      return $this->success('operation_success', Common::adminURL('order', 'order', 'edit', array('id' => $order_id)));
    }

    /**
     * 订单发货处理
     */
    public function actionShip()
    {
       $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
       $order_id = Common::queryInt(_p('order_id'));
       $order    = $this->orderLogic->getOneById($order_id);
       if(!$order)
       {
          return $this->showMessage('illegal_parameters');
       }
       if(!in_array($order['order_status'], array(201, 202, 203, 206)))
       {
          return $this->showMessage('ship_error_tip');
       }
       $corp_id     = Common::queryInt(_p('shipping_corp_id'));
       $shipping_no = Common::strEscape(_p('delivery_no'));
       $country_id  = Common::queryInt(_p('country_id'));
       $state       = _p('state');
       $city        = _p('city');
       $address     = _p('address');
       $ship        = _p('ship');
       if(!$corp_id)
       {
          return $this->showMessage('please_select_corp');
       }
       if(!$shipping_no)
       {
          return $this->showMessage('please_enter_shipping_no');
       }
       if(!$country_id || !$state || !$city || !$address)
       {
          return $this->showMessage('consignee_info_error');
       }
       $orderItemLogic    = $this->load('orderItemJoinSkuProduct');
       $deliveryItemLogic = $this->load('orderDeliveryItem');
       $cond = 'i.order_id='. $order_id . ' and i.status !=0 and i.status !=3';
       $ship_items = $orderItemLogic->findAll($cond);
       $order_status  = 204;
       foreach ($ship_items as $item)
       {
          $shipinfo      = $deliveryItemLogic->getShipInfo($item['id'], $item['goods_id'], $item['sku_code'], $item['buy_num']);
          $unshiped_num  = $shipinfo['unshiped_num'];
          if($item['status'] == 2 )
          {
            $unshiped_num = $unshiped_num - $item['return_num'];
          }
          //发货数量不匹配提醒
          if(isset($ship[$item['id']]) && $ship[$item['id']] > $unshiped_num)
          {
            return $this->showMessage('ship_overflow_tip');
          }
           if(isset($ship[$item['id']]) && $ship[$item['id']] < $unshiped_num)
          {
             $order_status = 206;//部分发货
          }
          else if(!isset($ship[$item['id']]) && $unshiped_num)
          {
             $order_status = 206;
          }
       }
       $shippingCorpLogic = $this->load('shippingCorp');
       $deliveryLogic     = $this->load('orderDelivery');
       $corp = $shippingCorpLogic->getOneById($corp_id);
       $receipt_no    = date('Ymdhsi', SYS_TIME) . Common::random(6);
       $delivery_data = array(
           'receipt_no'    => $receipt_no,
           'delivery_type' => 1,
           'order_id'      => $order_id,
           'user_id'       => $order['user_id'],
           'delivery_no'   => $shipping_no,
           'shipping_id'   => 0,
           'shipping_corp_id' => $corp['id'],
           'shipping_corp_no' => $corp['interface_code'],
           'shipping_cost'    => Common::strEscape(_p('delivery_cost')),
           'create_time'      => SYS_TIME,
           'delivery_time'    => SYS_TIME,
           'status'       => 1,
           'remark'       => Common::strEscape(_p('remark')),
           'first_name'   => Common::strEscape(_p('first_name')),
           'last_name'    => Common::strEscape(_p('last_name')),
           'country_id'   => $country_id,
           'state'        => Common::strEscape($state),
           'city'         => Common::strEscape($city),
           'address'      => Common::strEscape($address),
           'mobilephone'  => Common::strEscape(_p('mobilephone')),
           'telephone'    => Common::strEscape(_p('telephone')),
           'postcode'     => Common::strEscape(_p('postcode')),
        );
       if(_p('insured'))
       {
         $delivery_data['insured']      = _p('insured');
         $delivery_data['insured_cost'] = Common::strEscape(_p('insured_cost'));
       }
       $delivery_res = $deliveryLogic->save($delivery_data);
       $admin_id     = $this->admin_id;
       $admin_name   = $this->admin_name;
       $ship_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'remark'      => $lang['operation'] . ': '. $admin_name .' '.$lang['create_shipping_no'] . ': ' . $shipping_no,
               'behavior'    => 'create_shipping_record',
               'create_time' => SYS_TIME,
         );
       if($delivery_res)
       {
          $ship_log_data['result'] = 1;
          foreach ($ship_items as $item)
          {
            if($ship[$item['id']]){
              $item_data = array(
                  'delivery_id' => $delivery_res,
                  'order_id'    => $order_id,
                  'order_item_id' => $item['id'],
                  'goods_id'      => $item['goods_id'],
                  'sku_code'      => $item['sku_code'],
                  'buy_num'       => $ship[$item['id']],
                  'goods_type'    => $item['is_gift'] ? 2 : 1,
              );
              $deliveryItemLogic->save($item_data);
              //减库存处理
              $sku_delivery_nums = $item['delivery_nums'];
              $sku_data = array(
                   'delivery_nums' => $sku_delivery_nums - $ship[$item['id']],
               );
               $this->skuLogic->save($sku_data, $item['sku_id']);
            }
          }
          //更新订单状态
           $order_data = array(
               'order_status'    => $order_status,
               'shipping_status' => $order_status,
           );
           $order_res = $this->orderLogic->save($order_data, $order_id);
           $order_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'result'      => $order_res ? 1 : 0,
               'remark'      => $lang['operation'] . ': '. $admin_name . ' ' . $lang['change_order_status'].': ' . $order_status,
               'behavior'    => 'order_status_change',
               'create_time' => SYS_TIME,
          );
          $this->logLogic->save($order_log_data);
          if (_p('remark'))
            {
              $order_remark_data = array(
                  'admin_id'    => $admin_id,
                  'admin_name'  => $admin_name,
                  'order_id'    => $order_id,
                  'ip'          => Common::_ip2long(Common::ip()),
                  'remark'      => _p('remark'),
                  'marker'      => 2,
                  'remark_type' => $order['order_status'],
                  'create_time' => SYS_TIME,
                );
                $this->load('orderRemark')->save($order_remark_data);
            }
          if($order_res)
          {
            $order['order_status']    = $order_status;
            $order['shipping_status'] = $order_status;
            EventFactory::orderShipAfter($order);
          }
          return $this->success('save_success');
       }
       else
       {
          $ship_log_data['result'] = 0;
          $this->logLogic->save($ship_log_data);
          return $this->showMessage('save_failure');
       }
    }
    /**
     * 退货处理
     * @return type
     */
    public function actionReturnGoods()
    {
      $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
      $order_id = Common::queryInt(_p('order_id'));
       $order    = $this->orderLogic->getOneById($order_id);
       if(!$order)
       {
          return $this->showMessage('illegal_parameters');
       }
       if(!in_array($order['shipping_status'], array(205, 306)))
       {
          return $this->showMessage('ship_error_tip');
       }
       $corp_id = Common::queryInt(_p('shipping_corp_id'));
       $shipping_no = Common::strEscape(_p('delivery_no'));
       $country_id  = Common::queryInt(_p('country_id'));
       $state       = Common::strEscape(_p('state'));
       $city        = Common::strEscape(_p('city'));
       $address     = Common::strEscape(_p('address'));
       $ship        = _p('return');
       if(!$corp_id)
       {
          return $this->showMessage('please_select_corp');
       }
       if(!$shipping_no)
       {
          return $this->showMessage('please_enter_shipping_no');
       }
       if(!$country_id || !$state || !$city || !$address)
       {
          return $this->showMessage('consignee_info_error');
       }
       $orderItemLogic    = $this->load('orderItemJoinSkuProduct');
       $deliveryItemLogic = $this->load('orderDeliveryItem');
       $cond = 'i.order_id='. $order_id;
       $ship_items = $orderItemLogic->findAll($cond);
       $order_status    = 307;
       $all_return_item = array();//退货的订单项
       $refund_amount   = 0;
       foreach ($ship_items as $item)
       {
          $shipinfo  = $deliveryItemLogic->getShipInfo($item['id'], $item['goods_id'], $item['sku_code'], $item['buy_num']);
          //退货货数量不匹配提醒
          if(isset($ship[$item['id']]) && $ship[$item['id']] > $shipinfo['shiped_num'])
          {
            return $this->showMessage('return_goods_num_error');
          }
          if(isset($ship[$item['id']]) && $ship[$item['id']] < $shipinfo['shiped_num'])
          {
            $order_status  = 306;//部分退货
          }
          else if(!isset($ship[$item['id']]) && $shipinfo['shiped_num'])
          {
                $order_status  = 306;//部分退货
          }
          if(isset($ship[$item['id']]) && $ship[$item['id']])
          {
            $refund_amount += $item['price'] * $ship[$item['id']];
          }
          $all_return_item[$item['id']]  = isset($ship[$item['id']]) && $ship[$item['id']] ? ($item['return_num'] + $ship[$item['id']]) : 0;
       }
       $shippingCorpLogic = $this->load('shippingCorp');
       $deliveryLogic         = $this->load('orderDelivery');
       $corp   = $shippingCorpLogic->getOneById($corp_id);
       $receipt_no    = date('Ymdhsi', SYS_TIME) . Common::random(6);
       $delivery_data = array(
           'receipt_no'    => $receipt_no,
           'delivery_type' => 2,
           'order_id'      => $order_id,
           'user_id'       => $order['user_id'],
           'delivery_no'   => $shipping_no,
           'shipping_id'   => 0,
           'shipping_corp_id' => $corp['id'],
           'shipping_corp_no' => $corp['interface_code'],
           'shipping_cost'    => Common::strEscape(_p('delivery_cost')),
           'create_time'      => SYS_TIME,
           'delivery_time'    => SYS_TIME,
           'status'           => 1,
           'remark'           => Common::strEscape(_p('remark')),
           'first_name'   => Common::strEscape(_p('first_name')),
           'last_name'    => Common::strEscape(_p('last_name')),
           'country_id'   => $country_id,
           'state'        => $state,
           'city'         => $city,
           'address'      => $address,
           'mobilephone'  => Common::strEscape(_p('mobilephone')),
           'telephone'    => Common::strEscape(_p('telephone')),
           'postcode'     => Common::strEscape(_p('postcode')),
        );
       if(_p('insured'))
       {
         $delivery_data['insured']      = _p('insured');
         $delivery_data['insured_cost'] = _p('insured_cost');
       }
       $delivery_res = $deliveryLogic->save($delivery_data);
       $admin_id     = $this->admin_id;
       $admin_name   = $this->admin_name;
       $ship_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'remark'      => $lang['operation'].': '. $admin_name . ' '. $lang['create_returns_no'] . ': ' . $shipping_no,
               'behavior'    => 'create_returns_record',
               'create_time' => SYS_TIME,
         );
       if($delivery_res)
       {
          $ship_log_data['result'] = 1;
          foreach ($ship_items as $item)
          {
            if($ship[$item['id']]){
              $item_data = array(
                  'delivery_id' => $delivery_res,
                  'order_id'    => $order_id,
                  'order_item_id' => $item['id'],
                  'goods_id'      => $item['goods_id'],
                  'sku_code'      => $item['sku_code'],
                  'buy_num'       => $ship[$item['id']],
                  'goods_type'    => $item['is_gift'] ? 2 : 1,
              );
              $deliveryItemLogic->save($item_data);
              //库存恢复处理
              $sku_stock_nums    = $item['stock_nums'];
              $sku_data = array(
                   'stock_nums'    => $sku_stock_nums + $buy_num,
               );
               $this->skuLogic->save($sku_data, $item['sku_id']);
            }
          }
          //更新订单状态
           $order_data = array(
               'final_amount'    => $order['final_amount'] - $refund_amount,
               'payment_status'  => 105,
               'order_status'    => $order_status,
               'shipping_status' => $order_status,
           );
           $order_res = $this->orderLogic->save($order_data, $order_id);
           $order_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'result'      => $order_res ? 1 : 0,
               'remark'      => $lang['operation'].': '. $admin_name . ' ' . $lang['change_order_status'] . ': ' . Common::orderStatus($order_status),
               'behavior'    => 'order_status_change',
               'create_time' => SYS_TIME,
          );
          $this->logLogic->save($order_log_data);
          //更新全部退货的订单项的状态
          if(!empty($all_return_item))
          {
            $itemLogic = $this->load('orderItem');
            foreach($all_return_item as $key => $val)
            {
              if($val)
              {
                $item_map = Zhtx::createDataMap();
                $item_map->addEntry('status', 2, DB::INT);
                $item_map->addEntry('return_num', $val, DB::INT);
                $update_item_cond = 'id =' . $key;
                $itemLogic->update($item_map, $update_item_cond);
              }
            }

          }
          if (_p('remark'))
            {
              $order_remark_data = array(
                  'admin_id'    => $admin_id,
                  'admin_name'  => $admin_name,
                  'order_id'    => $order_id,
                  'ip'          => Common::_ip2long(Common::ip()),
                  'remark'      => _p('remark'),
                  'marker'      => 3,
                  'remark_type' => $order['order_status'],
                  'create_time' => SYS_TIME,
                );
                $res = $this->load('orderRemark')->save($order_remark_data);
            }
          if($order_res)
          {
            $order['final_amount']    = $order_data['final_amount'];
            $order['payment_status']  = $order_data['payment_status'];
            $order['order_status']    = $order_data['order_status'];
            $order['shipping_status'] = $order_data['shipping_status'];
            EventFactory::orderReturnAfter($order);
          }
          return $this->success('save_success');
       }
       else
       {
          $ship_log_data['result'] = 0;
          $this->logLogic->save($ship_log_data);
          return $this->showMessage('save_failure');
       }
    }
    /**
     * 订单编辑
     * @global type $cfg
     * @return type
     */
    public function actionEdit()
    {
      if(_p())
      {
          $order_id = Common::queryInt(_p('id'));
          $order    = $this->orderLogic->getOneById($order_id);
          if(!$order)
          {
              return $this->showMessage('illegal_parameters');
          }
          if($order['shipping_status'] > 203 && $order['order_status'] < 600 && $order['payment_status'] != 406)
          {
              return $this->showMessage('order_edit_tip');
          }
          if(_p('shipping_corp_id') != $order['shipping_corp_id'])
          {
             $order_data = array(
                'shipping_corp_id' =>  _p('shipping_corp_id'),
             );
             $this->orderLogic->save($order_data, $order_id);
          }
         if(_p('total_weight') != $order['total_weight'])
          {
             $order_data = array(
                'total_weight' =>  _p('total_weight'),
             );
             $this->orderLogic->save($order_data, $order_id);
          }

          $address_data = array(
              'address_type' => 1,
              'order_id'      => $order_id,
              'first_name'   => Common::strEscape(_p('first_name')),
              'last_name'    => Common::strEscape(_p('last_name')),
              'country_id'   => Common::queryInt(_p('country_id')),
              'state'        => Common::strEscape(_p('state')),
              'city'         => Common::strEscape(_p('city')),
              'address'      => Common::strEscape(_p('address')),
              'mobilephone'  => Common::strEscape(_p('mobilephone')),
              'telephone'    => Common::strEscape(_p('telephone')),
              'postcode'     => Common::strEscape(_p('postcode')),
         );
         $orderAddressLogic = $this->load('orderAddress');
         $res = $orderAddressLogic->updateByCond($address_data);
         return $res ? $this->success('save_success') : $this->showMessage('save_failure');
      }
      else
      {
         global $cfg;
          $order_id = Common::queryInt(_g('id'));
          $order    = $this->orderLogic->getOneById($order_id);
          if(!$order)
          {
              return $this->showMessage('illegal_parameters');
          }
          if($order['shipping_status'] > 203 && $order['order_status'] < 600 && $order['payment_status'] != 406)
          {
              return $this->showMessage('order_edit_tip');
          }
          $orderItemLogic    = $this->load('orderItemJoinSkuProduct');
          $userJoinInfoLogic = $this->load('userJoinInfo');
          $orderAddressLogic = $this->load('orderAddress');
          $shippingLogic     = $this->load('shipping');
          $orderPaymentLogic = $this->load('orderPayment');
          $paymentLogic      = $this->load('payment');
          $currentLogic      = $this->load('currency');
          $countryLogic      = $this->load('country');
          $shippingCorpLogic = $this->load('shippingCorp');
          $deliveryItemLogic = $this->load('orderDeliveryItem');
          $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
          $orderItems  = $orderItemLogic->findAll('i.order_id='. $order_id);
          $item_result = array();
          foreach ($orderItems as $item)
          {
              $property_ids = explode('_', $item['sku_code']);
              $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $cfg['sites'][0]['base_site']);
              $shipinfo  = $deliveryItemLogic->getShipInfo($item['id'], $item['goods_id'], $item['sku_code'], $item['buy_num']);
              $item['shiped_num']   = $shipinfo['shiped_num'];
              $item['unshiped_num'] = $shipinfo['unshiped_num'];
              $item['subtotal']     = $item['price'] * $item['buy_num'];
              $item['attr']  = $attr;
              $item['codeno'] = $attr['codeno'];
            if($item['sku_value'])
            {
                $sku_value = explode('_', $item['sku_value']);
                foreach ($sku_value as $key => $value)
                {
                    if($value)
                    {
                        $item['sku_value_items'][] = $value;
                    }
                }
            }
              $item_result[] = $item;
          }
          $userinfo     = $userJoinInfoLogic->getUserById($order['user_id']);
          $addr_cond    = 'order_id=' . $order['id'];
          $orderAddress = $orderAddressLogic->getOne($addr_cond);
          $shipping     = $shippingLogic->findAll('status=1', true);
          $payments     = $paymentLogic->findAll('status=1', true);
          $currencys    = $currentLogic->findAll('status=1', true);
          $orderPayment = $orderPaymentLogic->findAll('order_id=' . $order['id'] . ' order by payment_type asc');
          $shippingCorp_id = (int)$shipping[$order['shipping_id']]['shipping_corp_id'];
    //       _debug($item_result);
		  $corps = $shippingCorpLogic->findAll('', TRUE);
		  Core::$tpl->set('corps', $corps);
          Core::$tpl->set('order', $order);
          Core::$tpl->set('orderItem',  $item_result);
          Core::$tpl->set('user', $userinfo);
          Core::$tpl->set('address', $orderAddress);
          Core::$tpl->set('shippings', $shipping);
          Core::$tpl->set('orderpayment', isset($orderPayment[0])? $orderPayment[0] : '');
          Core::$tpl->set('payments', $payments);
          Core::$tpl->set('currencys', $currencys);
          Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
          Core::$tpl->set('shippingCorp', $shippingCorpLogic->getOneById($shippingCorp_id));
      }


    }
    /**
     *  ajax 编辑订单项价格或购买数量
     */
    public function actionEditItemPrice()
    {
      $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
      $item_id = Common::queryInt(_p('item_id'));
      $price   = _p('price');
      $buy_num = _p('buy_num');
      $admin_id     = Common::queryInt(_s('id'));
      $admin_name   = _s('user_name');
      $itemJoinskuLogic  = $this->load('orderItemJoinSku');
      $orderItemLogic    = $this->load('orderItem');
      $orderPaymentLogic = $this->load('orderPayment');
      $old_item = $itemJoinskuLogic->getOneByItemId($item_id);
      $status   = 0;
      if($old_item)
      {
         $old_price   = $old_item['price'];
         $old_buy_num = $old_item['buy_num'];
         $stock_nums  = $old_item['stock_nums'];
         $order       = $this->orderLogic->getOneById($old_item['order_id']);
         $order_status = $order['order_status'];
         $offset_nums  = $buy_num - $old_buy_num;
         $old_total    = $old_price * $old_buy_num;
         $new_total    = $price * $buy_num;
         $offset_price = $new_total - $old_total;
         $over_price   = $order['final_amount'] - $order['payed'] + $offset_price;
         if($offset_nums > $stock_nums)
         {
           $status = 3;//stock overflow
         }
         else
         {
            if($order_status < 104)
            {
              //未支付情况 更新订单项，如金额有改变需更新订单 如数量有变则冻结库存
               $item_data = array(
                   'price'  => $price,
                   'buy_num' => $buy_num,
               );
               $item_res = $orderItemLogic->save($item_data, $item_id);
               if($item_res && $offset_price)
               {
                 $order_data = array(
                     'cost_payment' => $order['cost_payment'] + $offset_price,
                     'total_amount' => $order['total_amount'] + $offset_price,
                     'final_amount' => $order['final_amount'] + $offset_price,
                 );
                 $order_res = $this->orderLogic->save($order_data, $order['id']);
                 $order_log_data = array(
                    'admin_id'    => $admin_id,
                    'admin_name'  => $admin_name,
                    'order_id'    => $order_id,
                    'result'      => $order_res ? 1 : 0,
                    'remark'      => '{operation}: '. $admin_name . '{edit_order}: ' . $order['itemno'],
                    'behavior'    => 'order_editor',
                    'create_time' => SYS_TIME,
                 );
                 $this->logLogic->save($order_log_data);
               }
               /*冻结库存*/
               if($item_res && $offset_nums)
               {
                  $sku_data = array(
                      'freeze_nums' => $old_item['freeze_nums'] + $offset_nums,
                  );
                  $this->skuLogic->save($sku_data, $old_item['sku_id']);
               }
               $status = $order_res ? 6 : 4;
            }
            else if($order_status > 103 && $order_status < 204)
            {
              //已支付情况 更新订单项，如金额有改变需更新订单并提示生成收退款单, 如数量有变则冻结库存
               $item_data = array(
                   'price'  => $price,
                   'buy_num' => $buy_num,
               );
               $item_res = $orderItemLogic->save($item_data, $item_id);
               if($item_res && $offset_price)
               {
                 $order_data = array(
                     'cost_payment' => $order['cost_payment'] + $offset_price,
                     'total_amount' => $order['total_amount'] + $offset_price,
                     'final_amount' => $order['final_amount'] + $offset_price,
                 );
                 if($over_price > 0)
                 {
                    $order_data['order_status']   = 104;//部分付款
                    $order_data['payment_status'] = 104;
                 }
                 else if($over_price < 0)
                 {
                   $order_data['order_status']   = 105;//付款溢出
                   $order_data['payment_status'] = 105;
                 }
                 $order_res = $this->orderLogic->save($order_data, $order['id']);
                 $order_log_data = array(
                    'admin_id'    => $admin_id,
                    'admin_name'  => $admin_name,
                    'order_id'    => $order_id,
                    'result'      => $order_res ? 1 : 0,
                    'remark'      => $lang['operation'] . ': '. $admin_name . ' ' .$lang['change_order_status'] . ': ' . $order['itemno'],
                    'behavior'    => 'order_status_change',
                    'create_time' => SYS_TIME,
                 );
                 $this->logLogic->save($order_log_data);
                 if($order_res && $over_price > 0)
                 {//生成新收款单
                    $pay_cond = 'order_id =' . $order['id'] . ' and payment_type=1 and status=0 and user_id=' . $order['user_id'];
                    $orderPaymentLogic->updateStatus($pay_cond, 4);
                    $trade_no      = date('Ymdhsi', $timestamp) . Common::random(6);
                    $order_payment_data = array(
                        'order_id'    => $order['id'],
                        'payment_type'=> 1,
                        'trade_no'    => $trade_no,
                        'user_id'     => $order['user_id'],
                        'amount'      => $over_price,
                        'status'      => 0,
                        'create_time' => SYS_TIME,
                    );
                    $res = $orderPaymentLogic->save($order_payment_data);
                    $order_log_data = array(
                      'admin_id'    => $admin_id,
                      'admin_name'  => $admin_name,
                      'order_id'    => $order_id,
                      'result'      => $res ? 1 : 0,
                      'remark'      => $lang['operation'] .': '. $admin_name . ' ' . $lang['create_beneficiary_no'] . ': ' . $trade_no,
                      'behavior'    => 'create_beneficiary_record',
                      'create_time' => SYS_TIME,
                  );
                  $this->logLogic->save($order_log_data);
                  $status = 6;
                 }
                 elseif ($order_res && $over_price < 0)
                 {
                    $status = 5;
                 }
               }
               if($item_res && $offset_nums)
               {
                  $sku_data = array(
                      'freeze_nums'   => $old_item['freeze_nums'] - $offset_nums,
                      'delivery_nums' => $old_item['delivery_nums'] + $offset_nums,
                  );
                  $this->skuLogic->save($sku_data, $old_item['sku_id']);
               }
            }
            else
            {
               $status = 1;//未发货情况下才可以编辑
            }
         }
      }
      else
      {
        $status = 2;//illegal_parameters
      }
      echo json_encode(array('status' => $status, 'offset_price' => $offset_price ? $offset_price : 0));
    }
    /**
     * ajax 编辑订单项 修改sku
     */
    public function actionEditItem()
    {
       $orderItemLogic    = $this->load('orderItem');
       $itemJoinSkuLogic  = $this->load('orderItemJoinSku');
       if(_p())
       {
          $status   = 0;
          $item_id  = Common::queryInt(_p('item_id'));
          $sku_code = _p('sku_code');
          if($sku_code)
          {
             $item_cond = 'i.id ='. $item_id;
             $old_item  = $itemJoinSkuLogic->getOne($item_cond);
             $order     = $this->orderLogic->getOneById('id=' . $old_item['order_id']);
                $property_ids = array();
                $propertys = array();
                $skucode = explode('_', $sku_code);
                foreach ($skucode as $key => $value)
                {
                    if($value)
                    {
                        $property_ids[] = $value;
                    }
                }
                if($property_ids)
                {
                    $res = $this->propertyLogic->findAll("id in(".join(',',$property_ids).")");
                    foreach($res as $key => $value)
                    {
                        $propertys[$value['id']] = $value;
                    }
                }
             $item_data = array(
                'sku_code' => $sku_code,
             );
             if($propertys[$skucode[0]] || $propertys[$skucode[1]])
             {
                 $item_data['sku_value'] = $propertys[$skucode[0]]['base_name'].'_'.$propertys[$skucode[1]]['base_name'];
             }
             else
             {
                 $item_data['sku_value'] = '';
             }
             $res = $orderItemLogic->save($item_data, $item_id);
             if($res)
             {  //库存处理
                $new_cond = 'goods_id='.$old_item['goods_id'] . ' and sku_code = "' . $sku_code . '"';
                if($order['order_status'] < 104)
                {//未支付
                   $sku_data = array(
                      'freeze_nums'   => $old_item['freeze_nums'] - $old_item['buy_num'],
                   );
                   $this->skuLogic->save($sku_data, $old_item['sku_id']);
                   $map = Zhtx::createDataMap();
                   $map->addEntry('freeze_nums', 'freeze_nums + ' . $old_item['buy_num'], DB::INT);
                   $this->skuLogic->update($map, $new_cond);
                }
                else if($order['order_status'] > 103 && $order['order_status'] < 202)
                {//已支付
                    $sku_data = array(
                        'delivery_nums' => $old_item['delivery_nums'] - $old_item['buy_num'],
                    );
                    $this->skuLogic->save($sku_data, $old_item['sku_id']);
                    $map = Zhtx::createDataMap();
                    $map->addEntry('delivery_nums', 'delivery_nums + ' . $old_item['buy_num'], DB::INT);
                    $this->skuLogic->update($map, $new_cond);
                }
                $status = 1;
             }
          }
          echo $status;
       }
       else
       {
          $item_id     = Common::queryInt(_g('item_id'));
          $language_id = Common::queryInt(_g('language_id'));
          $orderItem = $orderItemLogic->getOneById($item_id);
          $status    = 0;
          if($orderItem)
          {
              $propertyJoinLangLogic = $this->load('propertyJoinLanguage');
              $orderItem['attributes'] = $propertyJoinLangLogic->getPropertyByGoodsId($orderItem['goods_id'], $language_id);
              $status=1;
          }
          else
          {
            $status = 2;//illegal_parameters
          }
          echo json_encode(array('status' => $status, 'item' => $orderItem));
       }
    }
    /**
     * ajax
     * 缺货登记
     */
    public function actionOutStock()
    {
        $status = 0;
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $item_id      = Common::queryInt(_p('item_id'));
        $is_out_stock = Common::queryInt(_p('out_stock'));//缺货登记
        $admin_id     = $this->admin_id;
        $admin_name   = $this->admin_name;
        $itemJoinskuLogic  = $this->load('orderItemJoinSku');
        $old_item = $itemJoinskuLogic->getOneByItemId($item_id);
        if($old_item){
            $order        = $this->orderLogic->getOneById($old_item['order_id']);
        }
        if($is_out_stock)
        {
            $userLogic     = $this->load('user');
            $outStockLogic = $this->load('outStock');
            $user          = $userLogic->getOneById($order['user_id']);
            $attr          = $this->load('property')->getSkuAttr($old_item['sku_code']);
            $count = $outStockLogic->getCount(' order_id='.$old_item['order_id'] .' and goods_id='.$old_item['goods_id']);
            if($count){
                $res = $outStockLogic->getOne(' order_id='.$old_item['order_id'] .' and goods_id='.$old_item['goods_id']);
                $out_stock_data = array(
                     'num'       => $res['num']+1,
                );
                $outStock = $outStockLogic->save($out_stock_data,$res['id']);
            }else{
                $out_stock_data = array(
                    'order_id' => $old_item['order_id'],
                    'goods_id' => $old_item['goods_id'],
                    'order_item_id' => $old_item['id'],
                    'base_name' => Common::newAddslashes($old_item['goods_name']),
                    'sku_code'  => $old_item['sku_code'],
                    'sku_info'  => $attr,
                    'is_stock'  => 0,
                    'is_send'   => 0,
                    'num'       => $old_item['buy_num'],
                    'user_id'   => $order['user_id'],
                    'email'     => $user['security_email'] ? $user['security_email'] : $user['base_name'],
                    'create_time' => SYS_TIME,
                );
                $outStock = $outStockLogic->save($out_stock_data);
            }
            //记录订单日记
            $order_log_data = array(
                'admin_id'    => $admin_id,
                'admin_name'  => $admin_name,
                'order_id'    => $order['id'],
                'result'      => $order_res ? 1 : 0,
                'remark'      => $lang['operation'] . ': '. $admin_name . ' ' .$lang['edit_order'] . ': ' . $order['itemno'],
                'behavior'    => 'order_editor',
                'create_time' => SYS_TIME,
            );
            $this->logLogic->save($order_log_data);
        }
        if($outStock){
            $status = 1;
        }
        echo $status;
    }
    /**
     * ajax
     * 删除订单项或者缺货登记
     * 已支付和未支付两种情况处理方式
     *
     */
    public function actionDelItem()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $item_id      = Common::queryInt(_p('item_id'));
        $is_out_stock = Common::queryInt(_p('out_stock'));//缺货登记
        $admin_id     = $this->admin_id;
        $admin_name   = $this->admin_name;
        $itemJoinskuLogic  = $this->load('orderItemJoinSku');
        $orderItemLogic    = $this->load('orderItem');
        $orderOfferLogic   = $this->load('orderOffer');
         $item_status      = $is_out_stock ? 3 : 0;//订单项的状态
        $old_item = $itemJoinskuLogic->getOneByItemId($item_id);
        if($old_item)
        {
           $order        = $this->orderLogic->getOneById($old_item['order_id']);
           $order_status = $order['order_status'];
           $order_offers = $orderOfferLogic->findAll('order_id=' . $old_item['order_id']);
            if($order_status < 104)
            {
               //未支付情况
               //修改订单项状态及删除该订单项的促销
               $item_map = Zhtx::createDataMap();
               $item_map->addEntry('status', $item_status, DB::INT);
               $del_item_res = $orderItemLogic->update($item_map, 'id=' . $item_id);
               if($del_item_res)
               {
                  //解冻库存
                  $sku_data = array(
                      'freeze_nums' => $old_item['freeze_nums'] - $old_item['buy_num']
                  );
                  if($is_out_stock)
                  {
                     $userLogic     = $this->load('user');
                     $outStockLogic = $this->load('outStock');
                     $user          = $userLogic->getOneById($order['user_id']);
                     $attr          = $this->load('property')->getSkuAttr($old_item['sku_code']);
                     $out_stock_data = array(
                         'order_id' => $old_item['order_id'],
                         'goods_id' => $old_item['goods_id'],
                         'order_item_id' => $old_item['id'],
                         'base_name' => $old_item['goods_name'],
                         'sku_code'  => $old_item['sku_code'],
                         'sku_info'  => $attr,
                         'is_stock'  => 0,
                         'is_send'   => 0,
                         'num'       => $old_item['buy_num'],
                         'user_id'   => $order['user_id'],
                         'email'     => $user['security_email'] ? $user['security_email'] : $user['base_name'],
                         'create_time' => SYS_TIME,
                     );
                     $sku_data['status'] = 0;
                     $outStockLogic->save($out_stock_data);
                  }
                  else
                  {
                      $orderItemLogic->delete('id=' . $item_id);
                  }
                  $this->skuLogic->save($sku_data, $old_item['sku_id']);
               }
               //删除促销
               $gift_item_ids = array();
               $order_save    = 0;
               $cart_offer_list = array();
               //把购物车的赠品提起出来
               $cart_gift_ids  = array();
               $cart_rule_ids  = array();
               $delelted_offer = array();
               foreach ($order_offers as $value)
               {
                  if($value['item_id'] == $item_id)
                  {
                    if($value['gift_item_id'])
                    {
                      $gift_item_ids[] = $value['gift_item_id'];
                    }
                    $orderOfferLogic->delete('id='. $value['id']);
                    $delelted_offer[] = $value['id'];
                  }
                  else if($value['item_id'] && !$value['gift_item_id'])
                  {
                     $order_save += $value['amount'];
                  }
                  else if(!$value['item_id'] && ($value['order_offer_type'] == 301 || $value['order_offer_type'] == 302))
                  {
                     $cart_offer_list = $value;
                      if($value['gift_item_id'])
                      {
                        $cart_gift_ids[] = $value['gift_item_id'];
                      }
                      $cart_rule_ids[$value['rule_id']] = $value['rule_id'];
                  }

               }
               //移除改单商品的赠品
               $cond   = 'i.order_id =' . $old_item['order_id'] . ' and i.status=1';
               $new_order_item = $itemJoinskuLogic->findAll($cond);
               if(!empty($gift_item_ids))
               {
                  foreach ($new_order_item as $gift)
                  {
                      if(in_array($gift['id'], $gift_item_ids))
                      {
                        $orderItemLogic->delete('id=' . $gift['id']);
                        //解冻库存
                        $sku_gife_data = array(
                            'freeze_nums' => $gift['freeze_nums'] - $gift['buy_num']
                        );
                        $this->skuLogic->save($sku_gife_data, $gift['sku_id']);
                      }
                  }
               }
               //重新计算订单价格
               $gift_outside_totalamount = 0;
               $gift_outside_totalqty    = 0;
               foreach($new_order_item as $_val)
               {
                  $cur_subtotal = $_val['price'] * $_val['buy_num'];
                  if(!$_val['is_gift'])
                  {
                     $gift_outside_totalamount += $cur_subtotal;
                     $gift_outside_totalqty    += $_val['buy_num'];
                  }
               }
               //订单除了礼品外的价格-优惠的金额=购物车优惠条件金额
               $del_rule_ids = array();//不符合要求的规则
               if(!empty($cart_rule_ids))
               {
                  $rule_cond  = 'id in (' . implode(',', $cart_rule_ids) . ')';
                  $offerRuleLogic = $this->load('offerRule');
                  foreach($offerRuleLogic->findAll($rule_cond) as $rule)
                  {
                    if($gift_outside_totalqty < $rule['min_buynum'] && ($gift_outside_totalamount-$order_save) < $rule['min_amount'])
                    {
                       $del_rule_ids[] = $rule['id'];
                    }
                  }
               }
               //移除不符合规则的优惠
               $del_gift_item_ids = array();
                foreach($cart_offer_list as $_offer)
                {
                   if(in_array($_offer['rule_id'], $del_rule_ids))
                   {
                     if($_offer['gift_item_id'])
                     {
                        $del_gift_item_ids[] = $_offer['gift_item_id'];
                     }
                     $orderOfferLogic->delete('id=' . $_offer['id']);
                     $delelted_offer[] = $_offer['id'];
                   }
                }
                //移除订单中不符合条件的赠品
               $total_amount = 0;
               foreach($new_order_item as $_cval)
               {
                  $cur_subtotal = $_cval['price'] * $_cval['buy_num'];
                  if(in_array($_cval['id'], $del_gift_item_ids))
                  {
                     $orderItemLogic->delete('id=' . $_cval['id']);
                      //解冻库存
                      $sku_gife_data = array(
                          'freeze_nums' => $_cval['freeze_nums'] - $_cval['buy_num']
                      );
                      $this->skuLogic->save($sku_gife_data, $_cval['sku_id']);
                  }
                  else  if(!in_array($_cval['id'], !empty($gift_item_ids) ? $gift_item_ids : array(0)))
                  {
                     $total_amount +=  $cur_subtotal;
                  }
               }
               //重新计算订单优惠金额
               $cost_offer  = 0;
               $target_save = 0;
                foreach ($order_offers as $item)
               {
                  if(!in_array($item['id'], !empty($delelted_offer) ? $delelted_offer : array(0)))
                  {
                     $cost_offer += $item['amount'];
                     if(!$item['gift_item_id'])
                     {
                       $target_save += $item['amount'];
                     }
                  }
               }
               //更新订单
               $target_goods_amount = $total_amount - $target_save;
               $order_data = array(
                   'cost_payment' => $target_goods_amount,
                   'cost_offer'   => $cost_offer,
                   'total_amount' => $order['cost_shipping'] + $target_goods_amount,
                   'final_amount' => $order['cost_shipping'] + $target_goods_amount,
               );
               $order_res = $this->orderLogic->save($order_data, $order['id']);
               //记录订单日记
               $order_log_data = array(
                    'admin_id'    => $admin_id,
                    'admin_name'  => $admin_name,
                    'order_id'    => $order['id'],
                    'result'      => $order_res ? 1 : 0,
                    'remark'      => $lang['operation'] . ': '. $admin_name . ' ' .$lang['edit_order'] . ': ' . $order['itemno'],
                    'behavior'    => 'order_editor',
                    'create_time' => SYS_TIME,
                 );
                 $this->logLogic->save($order_log_data);
                 $status = 1;
            }
            else if($order_status > 103 && $order_status < 202)
            {
               //支付情况下
                //删除该订单项及促销
               $item_map = Zhtx::createDataMap();
               $item_map->addEntry('status', $item_status, DB::INT);
               $del_item_res = $orderItemLogic->update($item_map, 'id=' . $item_id);
               if($del_item_res)
               {
                  //解冻库存
                  $sku_data = array(
                      'delivery_nums' => $old_item['delivery_nums'] - $old_item['buy_num']
                  );
                  $this->skuLogic->save($sku_data, $old_item['sku_id']);
               }
               //删除促销
               $gift_item_ids = array();
               $order_save    = 0;
               $cart_offer_list = array();
               //把购物车的赠品提起出来
               $cart_gift_ids  = array();
               $cart_rule_ids  = array();
               $delelted_offer = array();
               foreach ($order_offers as $value)
               {
                  if($value['item_id'] == $item_id)
                  {
                    if($value['gift_item_id'])
                    {
                      $gift_item_ids[] = $value['gift_item_id'];
                    }
                    $orderOfferLogic->delete('id='. $value['id']);
                    $delelted_offer[] = $value['id'];
                  }
                  else if($value['item_id'] && !$value['gift_item_id'])
                  {
                     $order_save += $value['amount'];
                  }
                  else if(!$value['item_id'] && ($value['order_offer_type'] == 301 || $value['order_offer_type'] == 302))
                  {
                     $cart_offer_list = $value;
                      if($value['gift_item_id'])
                      {
                        $cart_gift_ids[] = $value['gift_item_id'];
                      }
                      $cart_rule_ids[$value['rule_id']] = $value['rule_id'];
                  }

               }
               //移除该单商品的赠品
               $cond   = 'i.order_id =' . $old_item['order_id'] . ' and i.status=1';
               $new_order_item = $itemJoinskuLogic->findAll($cond);
               if(!empty($gift_item_ids))
               {
                  foreach ($new_order_item as $gift)
                  {
                      if(in_array($gift['id'], $gift_item_ids))
                      {
                        $orderItemLogic->delete('id=' . $gift['id']);
                        //解冻库存
                        $sku_gife_data = array(
                            'delivery_nums' => $gift['delivery_nums'] - $gift['buy_num']
                        );
                        $this->skuLogic->save($sku_gife_data, $gift['sku_id']);
                      }
                  }
               }
               //重新计算订单价格
               $gift_outside_totalamount = 0;
               $gift_outside_totalqty    = 0;
               foreach($new_order_item as $_val)
               {
                  $cur_subtotal = $_val['price'] * $_val['buy_num'];
                  if(!$_val['is_gift'])
                  {
                     $gift_outside_totalamount += $cur_subtotal;
                     $gift_outside_totalqty    += $_val['buy_num'];
                  }
               }
               //订单除了礼品外的价格-优惠的金额=购物车优惠条件金额
               $del_rule_ids = array();//不符合要求的规则
               if(!empty($cart_rule_ids))
               {
                  $rule_cond  = 'id in (' . implode(',', $cart_rule_ids) . ')';
                  $offerRuleLogic = $this->load('offerRule');
                  foreach($offerRuleLogic->findAll($rule_cond) as $rule)
                  {
                    if($gift_outside_totalqty < $rule['min_buynum'] && ($gift_outside_totalamount-$order_save) < $rule['min_amount'])
                    {
                       $del_rule_ids[] = $rule['id'];
                    }
                  }
               }
               //移除不符合规则的优惠
               $del_gift_item_ids = array();
                foreach($cart_offer_list as $_offer)
                {
                   if(in_array($_offer['rule_id'], $del_rule_ids))
                   {
                     if($_offer['gift_item_id'])
                     {
                        $del_gift_item_ids[] = $_offer['gift_item_id'];
                     }
                     $orderOfferLogic->delete('id=' . $_offer['id']);
                     $delelted_offer[] = $_offer['id'];
                   }
                }
                //移除订单中不符合条件的赠品
               $total_amount = 0;
               foreach($new_order_item as $_cval)
               {
                  $cur_subtotal = $_cval['price'] * $_cval['buy_num'];
                  if(in_array($_cval['id'], $del_gift_item_ids))
                  {
                     $orderItemLogic->delete('id=' . $_cval['id']);
                      //解冻库存
                      $sku_gife_data = array(
                          'delivery_nums' => $_cval['delivery_nums'] - $_cval['buy_num']
                      );
                      $this->skuLogic->save($sku_gife_data, $_cval['sku_id']);
                  }
                  else  if(!in_array($_cval['id'], !empty($gift_item_ids) ? $gift_item_ids : array(0)))
                  {
                     $total_amount +=  $cur_subtotal;
                  }
               }
               //重新计算订单优惠金额
               $cost_offer  = 0;
               $target_save = 0;
                foreach ($order_offers as $item)
               {
                  if(!in_array($item['id'], !empty($delelted_offer) ? $delelted_offer : array(0)))
                  {
                     $cost_offer += $item['amount'];
                     if(!$item['gift_item_id'])
                     {
                       $target_save += $item['amount'];
                     }
                  }
               }
               //更新订单
               $target_goods_amount     = $total_amount - $target_save;
               $target_pay_total_amount = $order['cost_shipping'] + $target_goods_amount;
               $offset_pay_amount       = $target_pay_total_amount - $order['payed'];//计算未支付金额
               $order_data = array(
                   'cost_payment' => $target_goods_amount,
                   'cost_offer'   => $cost_offer,
                   'total_amount' => $target_pay_total_amount,
                   'final_amount' => $target_pay_total_amount,
               );
               if($offset_pay_amount > 0)
               {
                 $order_data['order_status']   = 104;
                 $order_data['payment_status'] = 104;
               }
               else if($offset_pay_amount < 0)
               {
                 $order_data['order_status']   = 105;
                 $order_data['payment_status'] = 105;
               }
               else if($offset_pay_amount == 0)
               {
                 $order_data['order_status']   = 201;
                 $order_data['payment_status'] = 201;
               }
               $order_res = $this->orderLogic->save($order_data, $order['id']);
               //记录订单日记
               $order_log_data = array(
                    'admin_id'    => $admin_id,
                    'admin_name'  => $admin_name,
                    'order_id'    => $order_id,
                    'result'      => $order_res ? 1 : 0,
                    'remark'      => $lang['operation']. ': '. ' ' . $admin_name . $lang['edit_order']. ': ' . $order['itemno'],
                    'behavior'    => 'order_editor',
                    'create_time' => SYS_TIME,
                 );
                 $this->logLogic->save($order_log_data);
                 $status = 1;//生成收款单
                 if($order_res && $offset_pay_amount > 0)
                 {
                     $orderPaymentLogic = $this->load('orderPayment');
                     $pay_cond = 'order_id =' . $order['id'] . ' and payment_type=1 and status=0 and user_id=' . $order['user_id'];
                     $orderPaymentLogic->updateStatus($pay_cond, 4);
                     $trade_no = date('Ymdhsi') . Common::random(6);
                     $pay_data = array(
                         'order_id' => $order['id'],
                         'user_id'  => $order['user_id'],
                         'trade_no' => $trade_no,
                         'payment_type' => 1,
                         'amount' => $offset_pay_amount,
                         'status' => 0,
                     );
                     $pay_rs = $orderPaymentLogic->save($pay_data);
                     $order_log_data = array(
                        'admin_id'    => $admin_id,
                        'admin_name'  => $admin_name,
                        'order_id'    => $order_id,
                        'result'      => $pay_rs ? 1 : 0,
                        'remark'      => $lang['operation'] . ': '. $admin_name . ' '. $lang['create_beneficiary_no'] . ': ' . $trade_no,
                        'behavior'    => 'create_beneficiary_record',
                        'create_time' => SYS_TIME,
                    );
                    $this->logLogic->save($order_log_data);
                    $status = 1;
                 }
                 else if($offset_pay_amount < 0)
                 {
                    $status = 2;//提醒退款
                 }
            }
        }
        else
        {
          $status = 0;//illegal_parameters
        }
        echo $status;
    }
    /**
     * 退款操作 计算退款金额
     * @return type
     */
    public function actionReturnFund()
    {
      if(_p())
      {
         $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
         $order_id = Common::queryInt(_p('order_id'));
         $pay_account_type = Common::strEscape(_p('pay_account_type'));
         $pay_account      = Common::strEscape(_p('pay_account'));
         $amount           = _p('amount');
         $pay_type         = _p('pay_type');
         $payment_id       = _p('payment_id');
         $pay_method_no    = Common::strEscape(_p('pay_method_no'));
         $real_currency_id = Common::queryInt(_p('real_currency_id'));
         $remark = Common::strEscape(_p('remark'));
         if(!$pay_account_type || !$pay_account || !$amount  || !$payment_id)
         {
              return $this->showMessage('form_error_tip');
         }
         $order    = $this->orderLogic->getOneById($order_id);
         if($order && $amount > $order['payed'])
         {
            return $this->showMessage('refund_overflow_tip');
         }
         if($real_currency_id)
          {
              $real_currency_cond = 'id=' . $real_currency_id;
          }
          else
          {
              $real_currency_cond = 'standard_code="' . $order['currency_code'] . '"';
          }
          $orderPaymentLogic = $this->load('orderPayment');
          $currencyLogic     = $this->load('currency');
//          $true_refund   = $orderPaymentLogic->getRefundAmount($order_id);//查询实际要退款的金额
          if($amount > $order['payed'] && $order['shipping_status'] > 300)
          {
            return $this->showMessage('refund_overflow_tip');
          }
          $real_currency = $currencyLogic->getOne($real_currency_cond);

          $trade_no      = date('Ymdhsi', SYS_TIME) . Common::random(6);
         $order_payment_data = array(
           'order_id' => $order_id,
           'payment_type' => 2,
           'trade_no'     => $trade_no,
           'user_id'      => $order['user_id'],
           'pay_account'  => $pay_account,
           'pay_account_type'     => $pay_account_type,
           'amount'               => $amount/$real_currency['exchange_rate'],
           'base_currency_id'     => Common::queryInt(_s('base_currency_id')),
           'real_currency_id'     => $real_currency['id'],
           'real_currency_amount' => $amount,
           'pay_type'   => $pay_type,
           'payment_id' => $payment_id,
           'status' => 1,
           'remark' => Common::strEscape(_p('remark')),
           'create_time' => SYS_TIME,
           'end_time'    => SYS_TIME,
           'payer'       => Common::strEscape(_p('payer')),
           'pay_method_no'     => $pay_method_no,
       );
       $res = $orderPaymentLogic->save($order_payment_data);
       //订单操作日记系统记录开始
       $admin_id   = Common::queryInt(_s('id'));
       $admin_name = $this->admin_name;
       $refund_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'result'      => $res ? 1 : 0,
               'remark'      => $lang['operation'] . ': '. $admin_name . ' ' . $lang['create_refund_no'].': ' . $trade_no .' '. $lang['amount'] .': ' . $amount,
               'behavior'    => 'create_returns_record',
               'create_time' => SYS_TIME,
        );
       $this->logLogic->save($refund_log_data);

       if ($remark)
      {
        $order_remark_data = array(
            'admin_id'    => $admin_id,
            'admin_name'  => $admin_name,
            'order_id'    => $order_id,
            'ip'          => Common::_ip2long(Common::ip()),
            'remark'      => $remark,
            'marker'      => 4,
            'remark_type' => $order['order_status'],
            'create_time' => SYS_TIME,
          );
          $this->load('orderRemark')->save($order_remark_data);
      }

       if($res)
       {
         //更新订单状态
           $order_data = array(
               'payed'          => $order['payed'] - $amount,
               'order_status'   => 405,
               'payment_status' => 405,
           );
           if($order_data['payed'] > $amount )
           {
              $order_data['order_status'] = 405;
              $order_data['payment_status'] = 405;
           }
           else if($order_data['payed'] == 0)
           {
              $order_data['order_status'] = 406;
              $order_data['payment_status'] = 406;
           }
           $order_res = $this->orderLogic->save($order_data, $order_id);
           $order_log_data = array(
               'admin_id'    => $admin_id,
               'admin_name'  => $admin_name,
               'order_id'    => $order_id,
               'result'      => $order_res ? 1 : 0,
               'remark'      => $lang['operation'] . ': '. $admin_name . '' . $lang['change_order_status'] . ': ' . Common::orderStatus($order_data['order_status']),
               'behavior'    => 'order_status_change',
               'create_time' => SYS_TIME,
          );
          $this->logLogic->save($order_log_data);
          if($order_res)
          {
            //邮件积分等做处理
            $order['refund_amount'] = $amount;
            EventFactory::orderRefundAfter($order);
          }
          return $this->success('operation_success');
        }
         return $this->showMessage('operation_failure');
      }
      return $this->showMessage('illegal_operation');
    }
    /**
     * 订单异常、取消、恢复相关操作
     */
    public function actionHandle()
    {
       $order_id     = _p('order_id');
       $order_status = _p('order_status');
       $remark       = _p('remark');
       $order        = $this->orderLogic->getOneById($order_id);
       if(!$order || $order['order_status'] == 700 || $order['order_status'] == 205)
       {
         return $this->showMessage('illegal_operation');
       }
       if($order_status >= 600 && $order['payed'] > 0)
       {
          return $this->showMessage('refund_remind');
       }
       $order_data = array(
           'order_status' => $order_status,
       );
       if($order_status == 201)
       {
         $order_data['payment_status'] = 201;
       }
       $res = $this->orderLogic->save($order_data, $order_id);
       $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
       $admin_id   = $this->admin_id;
       $admin_name = $this->admin_name;
       $order_log_data = array(
              'admin_id'    => $admin_id,
              'admin_name'  => $admin_name,
              'order_id'    => $order_id,
              'result'      => $res ? 1 : 0,
              'remark'      => $lang['operation'] . ': '. $admin_name . '' . $lang['change_order_status'] . ': ' . Common::orderStatus($order_status),
              'behavior'    => 'order_status_change',
              'create_time' => SYS_TIME,
        );
        $this->logLogic->save($order_log_data);
        if ($remark)
        {
          $order_remark_data = array(
              'admin_id'    => $admin_id,
              'admin_name'  => $admin_name,
              'order_id'    => $order_id,
              'ip'          => Common::_ip2long(Common::ip()),
              'remark'      => $remark,
              'marker'      => $order_status > 600 &&  $order_status < 700 ? 6 : 5,
              'remark_type' => $order_status,
              'create_time' => SYS_TIME,
            );
            $this->load('orderRemark')->save($order_remark_data);
        }
        if($res)
        {
          if($order_status == 201)
          {
            $order['payment_status'] = 201;
            GrowthFactory::backOrderPayAfter($order);
            EventFactory::orderPayAfter($order);
            EventFactory::recommendUserFirstPayAfter($order);
            CreditFactory::orderPayAfter($order);
          }
          if($order_status >= 600)
          {
            $order['order_status'] = $order_status;
            EventFactory::orderCancelAfter($order);
          }
          return $this->success('save_success');
        }
       return $this->showMessage('save_failure');
    }
    /**
     * 收款单
     */
    public function actionReceivablesRecord()
    {
      $orderPaymentLogic = $this->load('orderPayment');
      $paymentLogic      = $this->load('payment');
      $where = 'payment_type=1 order by create_time desc, order_id desc';
      $curr_page = Common::queryInt(_g('page'), 1);
      $page_size = Common::queryInt(_g('psize'), 20);
      $count     = $orderPaymentLogic->getCount($where);
      $page_data = Common::getPages($count, $curr_page, $page_size);
      $orderPayment = $orderPaymentLogic->getCurrentDatas($where, $page_size, $curr_page);
      $order_ids = array(0);
      foreach ($orderPayment as $pay)
      {
        $order_ids[$pay['order_id']] = $pay['order_id'];
      }
      $order_id_str = !empty($order_ids) ? implode(',', $order_ids) : array(0);
      $cond     = 'id in (' . $order_id_str . ')';
      $orders   = $this->orderLogic->findAll($cond, TRUE);
      $payments = $paymentLogic->findAll('status=1', true);
      Core::$tpl->set('received_record', $orderPayment);
      Core::$tpl->set('orders', $orders);
      Core::$tpl->set('payments', $payments);
      Core::$tpl->set('pages', $page_data);
      Core::$htmlFile  = 'order/receivables';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
    /**
     *  退款单记录
     */
    public function actionRefundRecord()
    {
      $orderPaymentLogic = $this->load('orderPayment');
      $paymentLogic      = $this->load('payment');
      $where = 'payment_type=2 order by create_time desc, order_id desc ';
      $curr_page = Common::queryInt(_g('page'), 1);
      $page_size = Common::queryInt(_g('psize'), 20);
      $count     = $orderPaymentLogic->getCount($where);
      $page_data = Common::getPages($count, $curr_page, $page_size);
      $orderPayment = $orderPaymentLogic->getCurrentDatas($where, $page_size, $curr_page);
      $order_ids = array(0);
      foreach ($orderPayment as $pay)
      {
        $order_ids[$pay['order_id']] = $pay['order_id'];
      }
      $order_id_str = !empty($order_ids) ? implode(',', $order_ids) : array(0);
      $cond     = 'id in (' . $order_id_str . ')';
      $orders   = $this->orderLogic->findAll($cond, TRUE);
      $payments = $paymentLogic->findAll('status=1', true);
      Core::$tpl->set('refund_record', $orderPayment);
      Core::$tpl->set('orders', $orders);
      Core::$tpl->set('payments', $payments);
      Core::$tpl->set('pages', $page_data);
      Core::$htmlFile  = 'order/refund';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
    /**
     * 发货单
     */
    public function actionShipRecord()
    {
        $deliveryLogic = $this->load('orderDelivery');
        $shippingcorpLogic = $this->load('ShippingCorp');
        $where = 'delivery_type=1 order by create_time desc, order_id  desc ';
        $curr_page = Common::queryInt(_g('page'), 1);
        $page_size = Common::queryInt(_g('psize'), 20);
        $count     = $deliveryLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $deliverys = $deliveryLogic->getCurrentDatas($where, $page_size, $curr_page);

       $ship_record   = array();//发货记录
       $order_ids     = array(0);
       foreach ($deliverys as $val)
       {
          if($val['status'] == 1)
          {
            $val['tracking_data'] = json_decode($val['delivery_data']);
          }
          $order_ids[$val['order_id']] = $val['order_id'];
          $ship_record[$val['id']] = $val;
       }
      $order_id_str = !empty($order_ids) ? implode(',', $order_ids) : array(0);
      $cond     = 'id in (' . $order_id_str . ')';
      $orders   = $this->orderLogic->findAll($cond, TRUE);
      $shippingcorp     = $shippingcorpLogic->findAll('1=1', true);
      Core::$tpl->set('ship_record', $ship_record);
      Core::$tpl->set('orders', $orders);
      Core::$tpl->set('shippingcorp', $shippingcorp);
      Core::$tpl->set('pages', $page_data);
      Core::$tpl->set('type', 1);
      Core::$htmlFile  = 'order/ship';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
    /**
     * 退货单
     */
    public function actionReturnRecord()
    {
       $deliveryLogic = $this->load('orderDelivery');
        $shippingcorpLogic = $this->load('ShippingCorp');
        $where = 'delivery_type=2 order by create_time desc, order_id  desc ';
        $curr_page = Common::queryInt(_g('page'), 1);
        $page_size = Common::queryInt(_g('psize'), 20);
        $count     = $deliveryLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $deliverys = $deliveryLogic->getCurrentDatas($where, $page_size, $curr_page);

       $ship_record   = array();//发货记录
       $order_ids     = array(0);
       foreach ($deliverys as $val)
       {
          if($val['status'] == 1)
          {
            $val['tracking_data'] = json_decode($val['delivery_data']);
          }
          $order_ids[$val['order_id']] = $val['order_id'];
          $ship_record[$val['id']] = $val;
       }
      $order_id_str = !empty($order_ids) ? implode(',', $order_ids) : array(0);
      $cond     = 'id in (' . $order_id_str . ')';
      $orders   = $this->orderLogic->findAll($cond, TRUE);
      $shippingcorp     = $shippingcorpLogic->findAll('1=1', true);
      Core::$tpl->set('ship_record', $ship_record);
      Core::$tpl->set('orders', $orders);
      Core::$tpl->set('shippingcorp', $shippingcorp);
      Core::$tpl->set('pages', $page_data);
      Core::$tpl->set('type', 0);
      Core::$htmlFile  = 'order/ship';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
    /**
     * 收退款单据明细
     */
    public function actionPaymentDetail()
    {
      $id = Common::queryInt(_g('id'));
      $orderPayment  = $this->load('orderPayment');
      $order_payment = $orderPayment->getOneById($id);
      if(!$order_payment)
      {
        return $this->showMessage('illegal_operations');
      }
      $order = $this->orderLogic->getOneById($order_payment['order_id']);
      if(!$order)
      {
        return $this->showMessage('illegal_operations');
      }
      $currency = $this->load('currency')->getOne('standard_code="' . $order['currency_code'] . '"');
      Core::$tpl->set('orderpayment', $order_payment);
      Core::$tpl->set('type', $order_payment['payment_type']);
      Core::$tpl->set('order', $order);
      Core::$tpl->set('currency', $currency);
    }
    /**
     * 发退货单据明细
     */
    public function actionDeliveryDetail()
    {
      global $cfg;
      $language_id = $cfg['sites'][0]['base_site'];
      $id = Common::queryInt(_g('id'));
      $deliveryLogic = $this->load('orderDelivery');
      $deliveryItemLogic  = $this->load('orderDeliveryItemJoinSkuProduct');
      $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
      $delivery      = $deliveryLogic->getOneById($id);
      if(!$delivery)
      {
         return $this->showMessage('illegal_operations');
      }
      $deliveryItems = $deliveryItemLogic->findAll('delivery_id='.$id);
      $goodslist     = array();
      $goods_ids     = array();
      foreach ( $deliveryItems as $item)
      {
         $goods_ids[$item['goods_id']] = $item['goods_id'];
         $property_ids = explode('_', $item['sku_code']);
         $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
         $item['attr'] = $attr;
         $goodslist[]  = $item;
      }
      if(!empty($goods_ids))
      {
        $where  = 'id in (' . implode(',', $goods_ids) . ')';
        $goods_array = $this->load('goods')->findAll($where, TRUE);
      }

	  $delivery["arr_data"] = json_decode($delivery['delivery_data'],true);
      $shippingLogic     = $this->load('shipping');
      $shippingCorpLogic = $this->load('shippingCorp');
      Core::$tpl->set('delivery', $delivery);
      Core::$tpl->set('type', $delivery['delivery_type']);
      Core::$tpl->set('itemlist', $goodslist);
      Core::$tpl->set('order', $this->orderLogic->getOneById($delivery['order_id']));
      Core::$tpl->set('shipping', $shippingLogic->getOneById($delivery['shipping_id']));
      Core::$tpl->set('shippingCorp', $shippingCorpLogic->getOneById($delivery['shipping_corp_id']));
      Core::$tpl->set('user', $this->load('user')->getOneById($delivery['user_id']));
      Core::$tpl->set('country', $this->load('country')->getOneById($delivery['country_id']));
      Core::$tpl->set('countrys', $this->load('country')->findAll("1=1", true));
      Core::$tpl->set('goodslist', $goods_array);
    }

        /**
     * 发退货单据修改
     */
    public function actionDeliverySave() {
        $delivery_id = Common::queryInt(_p('delivery_id'));
        if ($delivery_id) {
            $delivery_no = Common::strEscape(_p('delivery_no')) ? Common::strEscape(_p('delivery_no')) : '';
            $last_name = Common::strEscape(_p('last_name')) ? Common::strEscape(_p('last_name')) : '';
            $first_name = Common::strEscape(_p('first_name')) ? Common::strEscape(_p('first_name')) : '';
            $country_id = Common::queryInt(_p('country_id')) ? Common::queryInt(_p('country_id')) : 0;
            $state = Common::strEscape(_p('state')) ? Common::strEscape(_p('state')) : '';
            $city = Common::strEscape(_p('city')) ? Common::strEscape(_p('city')) : '';
            $address = Common::strEscape(_p('address')) ? Common::strEscape(_p('address')) : '';
            $postcode = Common::strEscape(_p('postcode')) ? Common::strEscape(_p('postcode')) : '';
            $telephone = Common::strEscape(_p('telephone')) ? Common::strEscape(_p('telephone')) : '';
            $mobilephone = Common::strEscape(_p('mobilephone')) ? Common::strEscape(_p('mobilephone')) : '';
            $map = Zhtx::createDataMap();
            if ($delivery_no) {
                $map->addEntry('delivery_no', $delivery_no, DB::VARCHAR);
            }
            if ($last_name) {
                $map->addEntry('last_name', $last_name, DB::VARCHAR);
            }
            if ($first_name) {
                $map->addEntry('first_name', $first_name, DB::VARCHAR);
            }
            if ($country_id) {
                $map->addEntry('country_id', $country_id, DB::INT);
            }
            if ($state) {
                $map->addEntry('state', $state, DB::VARCHAR);
            }
            if ($city) {
                $map->addEntry('city', $city, DB::VARCHAR);
            }
            if ($address) {
                $map->addEntry('address', $address, DB::VARCHAR);
            }
            if ($postcode) {
                $map->addEntry('postcode', $postcode, DB::VARCHAR);
            }
            if ($telephone) {
                $map->addEntry('telephone', $telephone, DB::VARCHAR);
            }
            if ($mobilephone) {
                $map->addEntry('mobilephone', $mobilephone, DB::VARCHAR);
            }
            $deliveryLogic = $this->load('orderDelivery');
            $cond = 'id=' . $delivery_id;
            $deliver_data_res = $deliveryLogic->update($map, $cond);
            //更新id
            $delivery_detail = $deliveryLogic->getOneById($delivery_id);
            $delivery_data = array(
                'receipt_no' =>  mysql_escape_string($delivery_detail['receipt_no']),
                'delivery_type' => $delivery_detail['delivery_type'],
                'order_id' => $delivery_detail['order_id'],
                'user_id' => $delivery_detail['user_id'],
                'delivery_no' => mysql_escape_string($delivery_detail['delivery_no']),
                'shipping_id' => $delivery_detail['shipping_id'],
                'shipping_corp_id' => $delivery_detail['shipping_corp_id'],
                'shipping_corp_no' =>  mysql_escape_string($delivery_detail['shipping_corp_no']),
                'shipping_cost' => $delivery_detail['shipping_cost'],
                'create_time' => $delivery_detail['create_time'],
                'delivery_time' => $delivery_detail['delivery_time'],
                'status' => $delivery_detail['status'],
                'remark' => mysql_escape_string($delivery_detail['remark']),
                'reason' => $delivery_detail['reason'],
                'delivery_data' =>  mysql_escape_string($delivery_detail['delivery_data']),
                'delivery_status' => $delivery_detail['delivery_status'],
                'insured' => $delivery_detail['insured'],
                'insured_cost' => $delivery_detail['insured_cost'],
                'first_name' => mysql_escape_string($delivery_detail['first_name']),
                'last_name' => mysql_escape_string($delivery_detail['last_name']),
                'country_id' => $delivery_detail['country_id'],
                'state' => mysql_escape_string($delivery_detail['state']),
                'city' => mysql_escape_string($delivery_detail['city']),
                'address' => mysql_escape_string($delivery_detail['address']),
                'address_spare' =>  mysql_escape_string($delivery_detail['address_spare']),
                'postcode' => mysql_escape_string($delivery_detail['postcode']),
                'mobilephone' => mysql_escape_string($delivery_detail['mobilephone']),
                'telephone' => mysql_escape_string($delivery_detail['telephone']),
                'email' => $delivery_detail['email'],
                'sign_time' => $delivery_detail['sign_time'],
            );
            $d_res = $deliveryLogic->save($delivery_data);
            if ($d_res) {
                $map = Zhtx::createDataMap();
                $map->addEntry('delivery_id', $d_res, DB::INT);
                $OrderDeliveryItemLogic = $this->load('orderDeliveryItem');
                $rcond = 'delivery_id=' . $delivery_id;
                $OrderDeliveryItemLogic->update($map,$rcond);
                $delete_res = $deliveryLogic->delete($cond);
            }
            if ($deliver_data_res && $d_res && $delete_res) {
                return $this->success('保存成功',ADMIN_ROOT . '?m=order&c=order&a=deliveryDetail&id=' . $d_res);
            } else {
                return $this->error('保存失败',ADMIN_ROOT . '?m=order&c=order&a=deliveryDetail&id=' . $delivery_id);
            }
        } else {
            return $this->error('保存失败');
        }
    }


    public function actionOrderRemark()
    {
       $remark     = _p('remark');
       $is_quick_mark     = _p('quick_mark');
       $order_id   = Common::queryInt(_p('order_id'));
       $admin_id   = $this->admin_id;
       $order = $this->orderLogic->getOneById($order_id);
       if(!$order)
       {
         return $this->showMessage('illegal_operations');
       }
       $admin_name = $this->admin_name;
       $res = FALSE;
      if ($remark)
      {
        $order_remark_data = array(
            'admin_id'    => $admin_id,
            'admin_name'  => $admin_name,
            'order_id'    => $order_id,
            'ip'          => Common::_ip2long(Common::ip()),
            'remark'      => Common::strEscape($remark),
            'marker'      => Common::queryInt(_p('marker')),
            'remark_type' => $order['order_status'],
            'create_time' => SYS_TIME,
          );
          $res = $this->load('orderRemark')->save($order_remark_data);
      }

      if($is_quick_mark){
            return $res ? $this->success('save_success',ADMIN_ROOT.'?m=order&c=Order&a=OrderMark&order_id='.$order_id):$this->showMessage('save_failure',ADMIN_ROOT.'?m=order&c=Order&a=OrderMark&order_id='.$order_id);
      }else{
            return $res ? $this->success('save_success',ADMIN_ROOT.'?m=order&c=order&a=detail&id='.$order_id):$this->showMessage('save_failure',ADMIN_ROOT.'?m=order&c=order&a=detail&id='.$order_id);
      }
    }
    /**
     * 添加新的sku到订单
     */
    public function actionAddSku()
    {

      $order_id = Common::queryInt(_p('order_id'));
      $sku_data = _p('sku');
      $order    = $this->orderLogic->getOneById($order_id);
      if(!$order)
      {
        echo 0;return;
      }
      global $cfg;
      $decimal   = isset($cfg['sites'][0]['home_decimal']) ? $cfg['sites'][0]['home_decimal'] : 0;//小数点问题
      $style     = isset($cfg['sites'][0]['home_price_peri']) ? $cfg['sites'][0]['home_price_peri'] : 0;//进位
      $rate      = $order['currency_rate'];
      $add_sku_amount = 0;
      $add_sku_weight = 0;
      $orderItemLogic = $this->load('orderItem');
      $skuJoinProductLogic = $this->load('skuProductLanguage');
      $goodsLogic = $this->load('goods');
      foreach (explode(',', $sku_data) as $val)
      {
        $sku_arr = explode('-', $val);
        $item_cond    = 'goods_id=' . $sku_arr[0] . ' and sku_code ="' . $sku_arr[1] . '" and order_id=' . $order_id;
        $count   = $orderItemLogic->getCount($item_cond);
        if($count > 0)
        {
          continue;
        }
        $cond = 's.goods_id=' . $sku_arr[0] . ' and s.sku_code ="' . $sku_arr[1] . '" and s.status=1 and s.stock_nums > 0 and l.language_id='.$order['language_id'];
        $sku  = $skuJoinProductLogic->getOne($cond);
        if($sku)
        {
          if($sku['price']>0){
                $sku_price = Common::price_format($sku['price']*$rate, $decimal, $style);
          }else{
               $goods_detail = $goodsLogic->getOneById($sku['goods_id']);
               $sku_price = Common::price_format($goods_detail['price']*$rate, $decimal, $style);
          }
          if($sku['weight']>0){
                $sku_w = $sku['weight'];
          }else{
               $goods_detail = $goodsLogic->getOneById($sku['goods_id']);
               $sku_w = $goods_detail['weight'];
          }
          $order_item_data = array(
              'order_id'   => $order_id,
              'goods_id'   => $sku_arr[0],
              'sku_code'   => $sku_arr[1],
              'goods_name' => Common::newAddslashes($sku['base_name']),
              'buy_num'    => $sku_arr[2],
              'price'      => $sku_price,
              'cost_price' => Common::price_format($sku['cost_price']*$rate, $decimal, $style),
              'weight'     => $sku_w,
              'status'        => 1,
            );
            if($sku['image']){
               $order_item_data['product_image'] =$sku['image'];
            }
            $property_ids = array();
            $propertys = array();
            $skucode = explode('_', $sku_arr[1]);
            foreach ($skucode as $key => $value)
            {
                if($value)
                {
                    $property_ids[] = $value;
                }
            }
            if($property_ids)
            {
                $res = $this->propertyLogic->findAll("id in(".join(',',$property_ids).")");
                foreach($res as $key => $value)
                {
                    $propertys[$value['id']] = $value;
                }
            }
            if($propertys[$skucode[0]] || $propertys[$skucode[1]])
            {
                $order_item_data['sku_value'] = $propertys[$skucode[0]]['base_name'].'_'.$propertys[$skucode[1]]['base_name'];
            }
            else
            {

            }
            $res = $orderItemLogic->save($order_item_data);
            if($res)
            {
              $add_sku_amount += $sku_price*$sku_arr[2];
              $add_sku_weight += $sku['weight']*$sku_arr[2];
            }
        }
        else
        {
          continue;
        }
      }
      $total_weight = $order['total_weight'] + $add_sku_weight;
      $cost_payment = $order['cost_payment'] + $add_sku_amount;
      $total_amount = $order['total_amount'] + $add_sku_amount;
      $final_amount = $order['final_amount'] + $add_sku_amount;
      if($final_amount > $order['payed'] && $order['payed'] > 0)
      {
        $order['payment_status'] = 104;
        $order['order_status']   = 104;
        $order['shipping_status'] = 104;
      }
      $update_order_data = array(
          'total_weight' => $total_weight,
          'cost_payment' => $cost_payment,
          'total_amount' => $total_amount,
          'final_amount' => $final_amount,
          'order_status' => $order['order_status'],
          'payment_status' => $order['payment_status'],
          'shipping_status'=> $order['shipping_status'],
      );
      $result = $this->orderLogic->save($update_order_data, $order_id);
      echo $result ? 1 : 0;
    }
    public function actionPublicRemark()
    {
       $remark     = _p('remark');
       $order_id   = Common::queryInt(_p('order_id'));
       $admin_id   = $this->admin_id;
       $order = $this->orderLogic->getOneById($order_id);
       if(!$order)
       {
         echo 0;exit;
       }
       $admin_name = $this->admin_name;
       $res = FALSE;
      if ($remark)
      {
        $order_remark_data = array(
            'admin_id'    => $admin_id,
            'admin_name'  => $admin_name,
            'order_id'    => $order_id,
            'ip'          => Common::_ip2long(Common::ip()),
            'remark'      => $remark,
            'remark_type' => $order['order_status'],
            'create_time' => SYS_TIME,
          );
          $res = $this->load('orderRemark')->save($order_remark_data);
          if($res)
          {
            echo json_encode(array('status' => 1, 'remark' => $remark));exit;
          }
      }
      echo 0;exit;
    }
    /**
     * 订单标记 ajax
     */
    public function actionMarked() {
        $marked = Common::queryInt(_p('marked'));
        $order_id = Common::queryInt(_p('order_id'));
        $orderinfo = $this->orderLogic->getOneById($order_id);
        $map = Zhtx::createDataMap();
        $map->addEntry('marked', $marked+$orderinfo['marked'], DB::INT);
        $cond = 'id=' . $order_id;
        $this->orderLogic->update($map, $cond);
        echo $marked;
        exit;
    }
    public function actionSendEmail()
    {
        $order_id = Common::queryInt(_p('order_id'));
        $codeno = _p('codeno');
        $order = $this->orderLogic->getOneById($order_id);
        if (!$order)
        {
            $return = array('status' => 0, 'msg' => '');
            echo json_encode($return);
            return;
        }
        $map = Zhtx::createDataMap();
        switch ($codeno)
        {
            case 'remind_pay_for_order':
                EventFactory::remindPayForOrder($order);
                break;
            case 'order_pay_success_tip':
                EventFactory::orderPayAfter($order);
                $map->addEntry('is_email_paid', 'is_email_paid+1', DB::UNSIGNED_TINYINT);
                break;
            case 'order_ship_notice':
                EventFactory::orderShipAfter($order);
                $map->addEntry('is_email_ship', 'is_email_ship+1', DB::UNSIGNED_TINYINT);
                break;
            default:
                $return = array('status' => 0, 'msg' => '');
                echo json_encode($return);
                return;
                break;
        }
        $where = 'id='.$order_id;
        $this->orderLogic->update($map, $where);
        $return = array('status' => 1, 'msg' => '');
        echo json_encode($return);
        return;
    }

    public function actionOrderMark()
    {
        $order_id = Common::queryInt(_g('order_id'));
        Core::$tpl->set('order_id', $order_id);
        Core::$tpl->set('remarks', $this->load('orderRemark')->findAll('order_id=' . $order_id . ' order by create_time asc'));
    }

      public function actionPrintOrder() {
        global $cfg;
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $order_id = Common::queryInt(_g('id'));
        $order = $this->orderLogic->getOneById($order_id);
        if (!$order) {
            return $this->showMessage('illegal_parameters');
        }
        $orderItemLogic = $this->load('orderItemJoinSkuProduct');
        $userJoinInfoLogic = $this->load('userJoinInfo');
        $orderAddressLogic = $this->load('orderAddress');
        $shippingLogic = $this->load('shipping');
        $orderPaymentLogic = $this->load('orderPayment');
        $paymentLogic = $this->load('payment');
        $currentLogic = $this->load('currency');
        $countryLogic = $this->load('country');
        $shippingCorpLogic = $this->load('shippingCorp');
        $deliveryLogic = $this->load('orderDelivery');
        $deliveryItemLogic = $this->load('orderDeliveryItem');
        $orderOfferLogic = $this->load('orderOffer');
        $messageLogic = $this->load('message');
        $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $orderItems = $orderItemLogic->findAll('i.order_id=' . $order_id);
        $language_id = $cfg['sites'][0]['base_site'];
        $item_result = array();
        $total_refund_amount = 0; //需要退款的总金额
        //---  读取属性的基准数组
        $proLogic = $this->load('property');
        $propertys = $proLogic->findAll('parent_id=0', true);
        $order['total_num'] = 0;
        $order['productprice'] = 0;
        foreach ($orderItems as $item) {
            $property_ids = explode('_', $item['sku_code']);
            $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
            $shipinfo = $deliveryItemLogic->getShipInfo($item['id'], $item['goods_id'], $item['sku_code'], $item['buy_num']);
            $item['shiped_num'] = $shipinfo['shiped_num'];
            $item['unshiped_num'] = $shipinfo['unshiped_num'];
            $item['subtotal'] = $item['price'] * $item['buy_num'];
            $item['itemnoweight'] = $item['weight'] * $item['buy_num'];
            $order['productprice'] += $item['subtotal'];
            $order['total_num'] += $item['buy_num'];
            $item['attr'] = $attr;
            $file = UPLOAD_DIR . $item["image"];
            //$thumbfile=UPLOAD_DIR."thumb/128X128/" . $item["image"] ;
            require_once(APP_ROOT . 'conf/site.conf.php');
            require_once(APP_ROOT . "libary/Image.php");
            $thumbfile = Image::getImageURL($item["image"], '150x168');
            if ($fp = fopen($file, 'rb', 0)) {
                $item["base64"] = base64_encode(fread($fp, filesize($file)));
                $size = getimagesize($thumbfile);
                $size = str_replace("=\"", ":", $size[3]);
                $size = str_replace("\"", "px;", $size);
                $item["size"] = $size;
            }
            $goodsinfo = $this->load('goods')->getOne('id=' . $item['goods_id']);
            $item['gcodeno'] = $goodsinfo['codeno'];
            $item_result[$item['id']] = $item;
            if ($item['status'] == 2) {
                $total_refund_amount += $item['price'] * $item['return_num'];
            }
        }
//       _debug($item_result);
        $userinfo = $userJoinInfoLogic->getUserById($order['user_id']);
        $addr_cond = 'order_id=' . $order['id'];
        $currency_cond = 'standard_code = "' . $order['currency_code'] . '"';
        $orderAddress = $orderAddressLogic->getOne($addr_cond);
        $shipping = $shippingLogic->findAll('status=1', true);
        $payments = $paymentLogic->findAll('status=1', true);
        $currency = $currentLogic->getOne($currency_cond);
        $orderPayment = $orderPaymentLogic->findAll('order_id=' . $order['id'] . ' order by payment_type asc');
        $pay_cond = 'order_id=' . $order['id'] . ' and payment_type=1 order by status'; //
        $orderPayment = $orderPaymentLogic->getOne($pay_cond);
        $ordershipping = $shippingLogic->getOne('id=' . $order['shipping_id']);
        $country = $countryLogic->getOne('id=' . $orderAddress['country_id']);
        $shippingCorp_id = $shipping[$order['shipping_id']]['shipping_corp_id'];
        $ship_record = array(); //发货记录
        $return_record = array();
        $corp_ids = array(); //物流公司IDS
        $trackObj = array();
        $tracking_no = array(); //物流单号
        foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val) {
            if ($val['delivery_type'] == 1) {
                $ship_record[$val['id']] = $val;
            } else {
                $return_record[] = $val;
            }
            if ($val['delivery_no'] != '')
                $tracking_no[] = $val['delivery_no'];
            if ($val['status'] == 1) {
                $corp_ids[] = $val['shipping_corp_id'];
                $val['tracking_data'] = json_decode($val['delivery_data']);
                $trackObj[] = $val;
            }
        }
        $order['tracking_no'] = join(' , ', $tracking_no);
        Core::$tpl->set('order', $order);
        Core::$tpl->set('orderItem', $item_result);
        Core::$tpl->set('orderAddress', $orderAddress);
        Core::$tpl->set('ordershipping', $ordershipping);
        Core::$tpl->set('country', $country);
    }


}

?>
