<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Brand
 *
 * @author xrx
 */
class BrandController extends AppController
{

    private $brandLogic;
    private $brandLangLogic;
    private $langLogic;
    private $typeLogic;
    private $goodsLogic;
    private $goodsTagRelLogic;

    public function __construct()
    {
        parent::__construct();
        $this->brandLogic = $this->load('brand');
        $this->brandLangLogic = $this->load('brandLanguage');
        $this->langLogic = $this->load('language');
        $this->typeLogic = $this->load('goodsType');
		$this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->goodsLogic = $this->load('goods');
        $this->goodsTagRelLogic = $this->load('goodsTagRel');
    }

    public function actionAdd()
    {
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
            $name = _p('base_name'.$base_site_id);
            if(!$name)
            {
              return $this->showMessage('default_site_required');
            }
            $data = array(
                'base_name'      => Common::strEscape($name),
                'url'            => Common::strEscape(_p('url')),
                'template_page'  => _p('template_page'),
                'sort_weight'    => Common::queryInt(_p('sort_weight')),
                'listorder'      => Common::queryInt(_p('listorder')),
                'status'         => Common::queryInt(_p('status')),
                'create_time'    => SYS_TIME,
                'goods_type_ids' => _p('goods_type'),
                'image'          => _p('image') ? substr(_p('image'), 7) : '',
            );
            $result  = $this->brandLogic->save($data);

            if ($result)
            {    
                if(!_p('listorder')){
                    $map = Zhtx::createDataMap(); 
                    $map->addEntry('listorder', 10*$result, DB::INT);
                    $this->brandLogic->update($map, 'id='.$result); 
                }
                //如果主表信息更新成功,则更新附表信息 
                $languages = $this->langLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item)
                {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('brand_id', $result, DB::INT);
                    $map->addEntry('language_id', $item["id"], DB::INT);
                    $map->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
                    $map->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
                    $map->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
                    $map->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
                    $map->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
                    /*
                      * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                      * 如果没有,则添加数据,否则更新数据
                      */
                    $this->brandLangLogic->insert($map);
                }
                $diy_url_flag = TRUE;
                 if (_p('page_url'))
                {
                    $diyUrlLogic = $this->load('urlAlisa');
                    $true_url    = Common::frontURL('home', 'product', 'list', array('brand_id[]' => $result), FALSE);
                    $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                    $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url, true);
                    if ($diy_res)
                    {
                        $new_cat_map = Zhtx::createDataMap(); 
                        $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                        $this->brandLogic->update($new_cat_map, 'id='.$result);
                    }
                    else
                    {
                       $diy_url_flag = FALSE;
                    }                    
                }
            }
            return $diy_url_flag ? $this->success('add_success', Common::adminURL('product', 'brand', 'list')) : $this->showMessage('diy_url_already_exists');
        }
        else
        {
            global $template;
            $types     = $this->typeLogic->getList('status=1 order by listorder asc');
            $languages = $this->langLogic->getList('status=1');
            Core::$tpl->set('types', $types['list']);
            Core::$tpl->set('languages', $languages['list']);
            Core::$tpl->set('template', $template['brand']);
            Core::$htmlFile = 'brand/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionEdit()
    {
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
            $name = _p('base_name'.$base_site_id);
            if(!$name)
            {
              return $this->showMessage('default_site_required');
            }
			$id = Common::queryInt(_p('id'));
            $map = Zhtx::createDataMap();
			$map->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
			$map->addEntry('url', Common::strEscape(_p('url')), DB::VARCHAR);
			$map->addEntry('image', Common::strEscape(_p('image')), DB::VARCHAR);
			$map->addEntry('template_page', _p('template_page'), DB::VARCHAR);
			$map->addEntry('goods_type_ids', _p('goods_type'), DB::VARCHAR);			
			$map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
			$map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
			$map->addEntry('create_time', SYS_TIME , DB::INT);
			
			$result = $this->brandLogic->update($map,"id=".$id);
            if ($result)
				{    
					//如果主表信息更新成功,则更新附表信息 
					$languages = $this->langLogic->findALL('status=1', true);
					//更新选中的信息
					foreach ($languages as $item)
					{
						$map = Zhtx::createDataMap();
						$map->addEntry('brand_id', $id, DB::INT);
						$map->addEntry('language_id', $item["id"], DB::INT);
						$map->addEntry('base_name', Common::strEscape(_p('base_name'.$item["id"])), DB::VARCHAR);
						$map->addEntry('title', Common::strEscape(_p('title'.$item["id"])), DB::VARCHAR);
						$map->addEntry('descript', Common::strEscape(_p('descript'.$item["id"])), DB::VARCHAR);
						$map->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail'.$item["id"]),false), DB::VARCHAR);
						$map->addEntry('keywords', Common::strEscape(_p('keywords'.$item["id"])), DB::VARCHAR);
						/*
						 * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
						 * 如果没有,则添加数据,否则更新数据
						 */
						$values = $item["id"];
						if ($this->brandLangLogic->getOne("brand_id = {$id} AND language_id = {$values}"))
						{
							$this->brandLangLogic->update($map, "brand_id = {$id} AND language_id = {$values}");
						} 
						else
						{
							$this->brandLangLogic->insert($map);
						}
					}
					
				}
                //自定义路径
                $diy_url_flag = TRUE;          
                $diyUrlLogic = $this->load('urlAlisa');
                $true_url    = Common::frontURL('home', 'product', 'list', array('brand_id[]' => $id), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url, true);
                if ($diy_res)
                {
                    $new_cat_map = Zhtx::createDataMap(); 
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $this->brandLogic->updateById($new_cat_map, $id);
                }
                else
                {
                    $diy_url_flag = FALSE;
                }                    
            
            return $diy_url_flag ? $this->success('edit_success', Common::adminURL('product', 'brand', 'list')) : $this->showMessage('diy_url_already_exists');
        }
        else
        {
            $id        = Common::queryInt(_g('id')) ;
            $brand = $this->brandLogic->getOne('id=' . $id);
            if (!$brand)
            {
                return $this->showMessage('not_found_record');
            }
		   	$languages = $this->languageJoinCountryLogic->getList('l.status=1');
			$cond = 'brand_id = ' . $id;
			$brandlang = $this->brandLangLogic->getList($cond);
			$brandlang_arr = array();
			foreach ($brandlang['list'] as $value)
			{
				$brandlang_arr[$value['language_id']] = $value;
			}
			
			Core::$tpl->set('brandLanguage', $brandlang_arr);
            Core::$tpl->set('languages', $languages["list"]);
		   
            $selected_type     = '';
            $selected_type_ids = array();
            $selected_array = explode(',', $brand['goods_type_ids']);
            $types = $this->typeLogic->getList('status=1 order by listorder asc');
            foreach ($types['list'] as $type)
            {
                if(in_array($type['id'], $selected_array))
                {
                    $selected_type .= $type['base_name'] . ' ';
                    $selected_type_ids[$type['id']] = $type['id'];
                }
            }
            global $template;
            Core::$tpl->set('types', $types['list']);
            Core::$tpl->set('brand', $brand);
            Core::$tpl->set('selected_type', $selected_type);
             Core::$tpl->set('selected_type_ids', $selected_type_ids);
            Core::$tpl->set('template', $template['brand']);
            Core::$htmlFile = 'brand/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }


        public function actionList() {

        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $where .= ' ORDER BY listorder DESC,id DESC';
        //分页
        $count = $this->brandLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->brandLogic->getCurrentDatas($where, $page_size, $curr_page);
        foreach ($res as $value) {
            $goods_num[$value['id']] = $this->goodsLogic->getCount("brand_id = '{$value['id']}'");
        }
        Core::$tpl->set("goods_num", $goods_num);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('res', $res);
    }

    public function actionGoodsList() {
        //分页用的参数
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        $brand_id = Common::queryInt(_g('brand_id'), 1);
        $pgids = $this->goodsLogic->findAll('brand_id=' . $brand_id);
        $gids = array(0);
        foreach ($pgids as $key => $value) {
            $gids[] = $value['id'];
        }
        if (!$gids) {
            $gids = array(0);
        }
        //获取数据
        $where = ' id in (' . implode(",", $gids) . ') ';
        $goodsLogic = $this->load('goods');
        $count = $goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results = $goodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        Common::sort_rows($results, "listorder", SORT_DESC);
        foreach ($results as $value) {
            $type_ids[$value['goods_type_id']] = $value['goods_type_id'];
        }
        $goods_types = array();
        if (count($type_ids) > 0) {
            $goods_types = $this->load('goodsType')->findAll('id in (' . implode(',', $type_ids) . ')', true);

            $c_cond = 'g.goods_id in(' . implode(",", $gids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
        $where_tag = ' goods_id in (' . implode(",", $gids) . ') ';
        $goods_tag = $this->goodsTagRelLogic->findAll($where_tag, 0, '', array("tag_id", "goods_id"));
        $re = array();
        foreach ($goods_tag as $key => $value) {
            if ($re[$value['goods_id']]) {
                $re[$value['goods_id']] = $re[$value['goods_id']] . ',' . $value['tag_id'];
            } else {
                $re[$value['goods_id']] = $value['tag_id'];
            }
        }
        foreach ($re as $key => $value) {
            $good_tags[$key] = explode(",", $value);
        }
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("tags", $this->load('GoodsTag')->findAll('', true));
        Core::$tpl->set("res", $results);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set("good_tags", $good_tags);
    }

    public function actionAddGoods() {
        $goodsids = explode(",", _p('goods_ids'));
        $brand_id = _p('brand_id');
        if (!empty($goodsids)) {
            $in = implode(',', $goodsids);
            $map = Zhtx::createDataMap();
            $map->addEntry('brand_id', $brand_id, DB::INT);
            $this->goodsLogic->update($map, 'id in(' . $in . ')');
        }
    }

    public function actionDelgoods() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            $in = implode(',', $ids);
            $map = Zhtx::createDataMap();
            $map->addEntry('brand_id', 0, DB::INT);
            $res = $this->goodsLogic->update($map, 'id in(' . $in . ')');
            if ($res) {
                $num = count($ids);
                $staus = 1;
            }
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
/**
     * ajax 更新状态
     */
    public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res    = $this->brandLogic->updateById($map, $id);
        $cond   = 'brand_id = ' . $id;
        foreach($this->brandLangLogic->findAll($cond) as $val)
        {
           $this->brandLangLogic->delCache($val['language_id']);
        }
        
        echo $res ? 1 : 0;
    }
    public function actionPublicGetList()
    {
      $cols = array('id', 'base_name');
      $cond = 'status=1 order by listorder asc';
      echo json_encode($this->brandLogic->getCols($cond, $cols));
    }
     public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          $enum = 0;
          $goodsLogic = $this->load('goods');
          $map = Zhtx::createDataMap();
          foreach ($ids as $id)
          {          
                $where = 'brand_id=' . $id ;
                if ($this->load('goods')->getCount($where)){
                    $brand = $this->load('brand')->getOne('id='.$id);
                    $brand_name .= $brand['base_name'].',';
                    $enum++;
                }else{
                    $brand = $this->load('brand')->getOne('id='.$id);
                    $this->load('urlAlisa')->deleteDiyUrl($brand['page_url']);
                    $res  = $this->brandLogic->delete('id=' . $id);
                    if($res)
                    {   
                      $this->brandLangLogic->delete('brand_id=' . $id);                 
                      $cond = 'brand_id='.$id;
                      $map->addEntry('brand_id', 0, DB::INT);
                      $goodsLogic->update($map, $cond);
                      $num++;
                    }
                }
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    /**
     * 修改排序
     * ajax 
     */
    public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
      $listorder   = Common::queryInt(_p('listorder'));
      $sort_weight = Common::queryInt(_p('sort_weight'));
      $map = Zhtx::createDataMap();
      if($listorder)
      $map->addEntry('listorder', $listorder, DB::INT);
      if($sort_weight)
      $map->addEntry('sort_weight', $sort_weight, DB::INT);
      $res = $this->brandLogic->update($map, 'id=' . $id);
      echo $res ? 1 : 0;
    }

   //批量添加品牌
    public function actionBatchAdd() {
        if (_p()) {
            $name = Common::strEscape(_p("base_name"));
            if (!$name) {
                return $this->showMessage('brand_name_not_empty');
            }
            $name = str_replace("\\r", "", $name);
            $name = str_replace("\\n", ",", $name);
            $nameArr = explode(",", $name);
            $error = array();
            foreach ($nameArr as $val) {
                $Tbasename = $this->brandLogic->getOne("base_name='" . $val . "'");
                if ($Tbasename || !$val) {
                    continue;
                }
                $data = array(
                    'base_name' => Common::strEscape($val),
                    'status' => 1,
                    'create_time' => SYS_TIME,
                );
                $result = $this->brandLogic->save($data);
                if (!$result) {
                    $error[] = 'brand_name ' . $val;
                    continue;
                }
                if ($result) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', $result, DB::INT);
                    $this->brandLogic->update($map, 'id=' . $result);
                    //如果主表信息更新成功,则更新附表信息 
                    $languages = $this->langLogic->findALL('status=1', true);
                    //更新选中的信息
                    foreach ($languages as $item) {
                        $map = Zhtx::createDataMap();
                        $map->addEntry('brand_id', $result, DB::INT);
                        $map->addEntry('language_id', $item["id"], DB::INT);
                        $map->addEntry('base_name', Common::strEscape($val), DB::VARCHAR);
                        $result2=$this->brandLangLogic->insert($map);
                        if (!$result2) {
                            $error[] = 'brand_name ' . $val.' language_id '.$item["id"];
                            continue;
                        }
                    }
                }
            }
            if(!$error){
                return  $this->success('add_success', Common::adminURL('product', 'brand', 'list'));
            }else{
                echo $error;
				die();
            }
        }
    }
}

?>
