<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Category
 *
 * @author xrx
 */
class CategoryController extends AppController
{

    private $catLogic;
    private $languageLogic;
    private $langLogic;
    private $goodsCatLangLogic;
    private $seotplLogic;

    public function __construct()
    {
        parent::__construct();
        $this->catLogic = $this->load('goodsCategory');
        $this->languageLogic = $this->load('language');
        $this->langLogic = $this->load('language');
        $this->goodsCatLangLogic = $this->load('goodsCategoryLanguage');
        $this->seotplLogic = $this->load('seotpl');
        ignore_user_abort(true);
        set_time_limit(0);
    }

    public function actionList()
    {
        $where = '1=1';
        $search = array();
        if (_g('search_value'))
        {

            $where .= " and (base_name like '%" . _g('search_value') . "%'  or id ='" . _g('search_value') . "')";

            $category_show = $this->catLogic->findALL($where . ' order by parent_id asc,listorder desc,id DESC', true);
            foreach ($category_show as $key => $value)
            {
                $value["has_son"] = 0;
                $value["level"] = 1;
                $category_show[$key] = $value;
            }
        }
        else
        {
            $category_id = _g('id') ? intval(_g('id')) : 0;
            //$goodsCategoryJoinLang = $this->load('goodsCategoryJoinLang');
            //$categories = $goodsCategoryJoinLang->findALL($where . ' order by parent_id asc,listorder desc,id DESC');
            $categories = $this->catLogic->findALL($where . ' order by parent_id asc,listorder desc,id DESC');
            $categories = Common::setTreeData($categories);
            Common::getTree($categories, $category_tree, 0);
            $category_show = $this->actionPublicGetCategoryTree($category_tree, $category_id);
        }

        Core::$tpl->set('res', $category_show);
        Core::$tpl->set('search', $search);
        $goods_types = $this->load('goodsType')->findAll('1=1', true);
        Core::$tpl->set("types", $goods_types);
    }

    /**
     *
     * @return type
     */
    public function actionAdd()
    {
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
            $catName = _p('base_name');
            $goods_type_id = Common::queryInt(_p('goods_type_id'));
            $parentId = Common::queryInt(_p('parent_id'));
            $base_name = $catName[$base_site_id];
            if (!$base_name)
            {
                return $this->showMessage('name_not_empty');
            }
            /*
            if (!$goods_type_id)
            {
                return $this->showMessage('please_select_goods_type');
            }
             *
             */
            $cond = 'base_name = "' . $base_name . '" AND parent_id=' . $parentId;
            $cat = $this->catLogic->getCount($cond);
            if ($cat)
            {
                return $this->showMessage('name_already_exists');
            }
            if(_p('page_url'))
            {
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                if(substr($page_url, strlen($page_url)-1) != '/')
                {
                  $page_url = strtolower($page_url.'/');
                }
            }
            $cat_data = array(
                'base_name' => Common::strEscape($base_name),
                'parent_id' => $parentId,
                'goods_type_id' => $goods_type_id,
                'page_url' => Common::strEscape($page_url),
                'sort_weight' => Common::queryInt(_p('sort_weight')),
                'listorder' => Common::queryInt(_p('listorder')),
                'create_time' => SYS_TIME,
                'special_css_class' => _p('special_css_color') ? _p('special_css_color') . '' : '',
                'seo_tpl_id' => Common::queryInt(_p('seo_tpl_id')),
                'seo_goods_tpl_id' => Common::queryInt(_p('seo_goods_tpl_id')),
            );
            $res = $this->catLogic->save($cat_data);
            if ($res)
            {
                if(!_p('listorder')){
                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', 100000-10*$res, DB::INT);
                    $this->catLogic->update($map, 'id='.$res);
                }
                //多语言处理
                $details = Inputer::getOrgPost('detail');;
                $seo_title = _p('title');
                $seo_keywords = _p('keywords');
                $seo_descript = _p('descript');
                $list_template = _p('list_template');
                $goods_template = _p('goods_template');
                $cat_image = _p('image');
                foreach ($catName as $key => $value)
                {
                    $detail = isset($details[$key]) ? $details[$key] : '';
                    $lang_data = array(
                        'base_name' => Common::strEscape($value),
                        'goods_category_id' => $res,
                        'language_id' => $key,
                        'list_template' => isset($list_template[$key]) ? $list_template[$key] : '',
                        'goods_template' => isset($goods_template[$key]) ? $goods_template[$key] : '',
                        'detail' => Common::strEscape($detail, FALSE),
                        'image' => isset($cat_image[$key]) ? Common::strEscape($cat_image[$key]) : '',
                        'title' => isset($seo_title[$key]) ? $seo_title[$key] : '',
                        'keywords' => isset($seo_keywords[$key]) ? $seo_keywords[$key] : '',
                        'descript' => isset($seo_descript[$key]) ? $seo_descript[$key] : '',
                        'status' => Common::queryInt(_p('is_display-' . $key)),
                    );

                    if(_p('is_extentd'))
                    {
                        $cat = $this->catLogic->getOneById($res);
                        if(!$cat)
                        {
                            return $this->showMessage('illegal_parameters');
                        }
                        //修改子分类模版
                        $cond = 'path_id like "' . $cat['path_id'] . '%" and id !=' . $res;
                        $cat_res = $this->catLogic->findAll($cond);
                        $goods_category_ids = array(0);//防止没有子类的时候出现in(,8)
                        foreach($cat_res as $key=>$value){
                            $goods_category_ids[] =$value['id'];
                        }
                        $extend_data = array(
                            'goods_template' => isset($goods_template[$key]) ? $goods_template[$key] : '',
                        );
                        $cond = 'language_id='.$key.' and goods_category_id in (' . implode(',', $goods_category_ids) .')';
                        $this->goodsCatLangLogic->saveByCond($extend_data, $cond);
                    }
                    $this->goodsCatLangLogic->save($lang_data);
                    //更新缓存
                    $this->catLogic->updateListCache($key);
                }
                $path_id = $res . ',';
                if ($parentId)
                {
                    $path_id = $parentId . ',' . $path_id;
                    while ($parentId)
                    {
                        $cat = $this->catLogic->getOne('id=' . $parentId);
                        if ($cat['parent_id'])
                        {
                            $path_id = $cat['parent_id'] . ',' . $path_id;
                        }
                        $parentId = $cat['parent_id'];
                    }
                }

                $new_cat_map = Zhtx::createDataMap();
                $new_cat_map->addEntry('path_id', $path_id, DB::VARCHAR);
                $diy_url_flag = TRUE;
                if ($page_url)
                {
                    $diyUrlLogic = $this->load('urlAlisa');
                    $true_url = Common::frontURL('home', 'product', 'list', array('category_id' => $res), FALSE);
                    $diy_res = $diyUrlLogic->createDiyUrl($page_url, $true_url, true);
                    if ($diy_res)
                    {
                        $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    }
                    else
                    {
                        $diy_url_flag = FALSE;
                    }
                }

                $result = $this->catLogic->update($new_cat_map, 'id=' . $res);
                if ($result)
                {
                    $this->catLogic->updateCache($path_id);
                }
                return $diy_url_flag ? $this->success('add_success', Common::adminURL('product', 'category', 'list')) : $this->showMessage('diy_url_already_exists');
            }
            return $this->showMessage('add_failure');
        }
        else
        {
            $themes = $this->load('theme')->findAll('', true);
            $tplConf = Common::getTplConf();
            $parentId = _g('pid') ? intval(_g('pid')) : 0;
            $categorys = $this->catLogic->getList();
            $parents = array();
            $goods_type_id = 0;
            foreach (Common::getTree($categorys['list']) as $item)
            {
                if ($item['id'] == $parentId)
                {
                    $goods_type_id = $item['goods_type_id'];
                }
                $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
            }
            $languages = $this->langLogic->findAll('status=1');
            $typeLogic = $this->load('goodsType');
            $types = $typeLogic->getList('status=1 order by listorder asc');
            $template = array();
            foreach ($languages as $key => $value)
            {
                $template[$value['id']] = $tplConf[$themes[$value['theme_id']]['theme_dir']];
            }
            $seotpl = $this->seotplLogic->findAll('1=1');
            Core::$tpl->set('seotpl', $seotpl);
            Core::$tpl->set('parentid', $parentId);
            Core::$tpl->set('goods_type_id', $goods_type_id);
            Core::$tpl->set('cats', $parents);
            core::$tpl->set('languages', $languages);
            core::$tpl->set('types', $types['list']);
            core::$tpl->set('template', $template);
            Core::$htmlFile = 'category/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionEdit()
    {
        if (_p())
        {
            $base_site_id = Common::validSiteConfig();
            $id = Common::queryInt(_p('id'));
            $catName = _p('base_name');
            $goods_type_id = Common::queryInt(_p('goods_type_id'));
            $parentId = Common::queryInt(_p('parent_id'));
            $base_name = $catName[$base_site_id];
            $virtual_category = _p('virtual_category');
	    $channelChe = $virtual_category == 1 ? 1 : 0;
            $is_virtual = $virtual_category == 2 ? 1 : 0;
            $cur_cat = $this->catLogic->getOneById($id);
            if (!$cur_cat)
            {
                return $this->showMessage('illegal_parameters');
            }
            if (!$base_name)
            {
                return $this->showMessage('name_not_empty');
            }
            /*
            if (!$goods_type_id)
            {
                return $this->showMessage('please_select_goods_type');
            }
             *
             */
            $cond = 'id != ' . $id . ' AND base_name = "' . $base_name . '" AND parent_id=' . $parentId;
            if ($this->catLogic->getCount($cond))
            {
                return $this->showMessage('name_already_exists');
            }
            $diy_param = array();
            foreach(_p() as $key => $rows)
            {
                if(preg_match("/diy_param-(.*)/i", $key, $matches))
                {
                    $diy_param[$matches[1]] = _p($key);
                }
            }
            $cat_data = array(
                'base_name' => Common::strEscape($base_name),
                'diy_param' => json_encode($diy_param),
                'parent_id' => $parentId,
                'goods_type_id' => $goods_type_id,
                'page_url' => Common::strEscape(_p('page_url')),
                'sort_weight' => Common::queryInt(_p('sort_weight')),
                'listorder' => Common::queryInt(_p('listorder')),
                'create_time' => SYS_TIME,
                'special_css_class' => _p('special_css_color') ? _p('special_css_color') . '' : '',
                'seo_tpl_id' => Common::queryInt(_p('seo_tpl_id')),
                'seo_goods_tpl_id' => Common::queryInt(_p('seo_goods_tpl_id')),
		'is_channel' => $channelChe,
                'is_virtual' => $is_virtual,
            );
            if(!preg_match("/^[(a-z)(A-Z)(0-9)(\/)(\-)]+$/", _p('page_url')) )
            {
                unset($cat_data['page_url']);
            }
            $res = $this->catLogic->save($cat_data, $id);

            $cat_type_map = Zhtx::createDataMap();
            $cat_type_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
            $cond = "goods_type_id=0 and path_id like '" . $cur_cat["path_id"] . "%'";
            $this->catLogic->update($cat_type_map, $cond);

            if ($res)
            {
                $path_id = $id . ',';
                if ($parentId)
                {
                    $path_id = $parentId . ',' . $path_id;
                    while ($parentId)
                    {
                        $cat = $this->catLogic->getOne('id=' . $parentId);
                        if ($cat['parent_id'])
                        {
                            $path_id = $cat['parent_id'] . ',' . $path_id;
                        }
                        $parentId = $cat['parent_id'];
                    }
                }
                $new_cat_map = Zhtx::createDataMap();
                $new_cat_map->addEntry('path_id', $path_id, DB::VARCHAR);

                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                //自定义路径
                $diy_url_flag = TRUE;
                if($virtual_category)
                {
                    $diyUrlLogic = $this->load('urlAlisa');
                    $diyUrlLogic->deleteDiyUrl($cur_cat['page_url']);
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $result = $this->catLogic->update($new_cat_map, 'id=' . $id);
                }
                else
                {
                    if($page_url && substr($page_url, strlen($page_url)-1) != '/')
                    {
                      $page_url = strtolower($page_url.'/');
                    }
                    $diyUrlLogic = $this->load('urlAlisa');
                    $true_url = Common::frontURL('home', 'product', 'list', array('category_id' => $id), FALSE);
                    $diy_res = $diyUrlLogic->createDiyUrl($page_url, $true_url, true);
                    if (!$diy_res)
                    {
                        $diy_url_flag = FALSE;
                    }
                    else
                    {
                        $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                        $result = $this->catLogic->update($new_cat_map, 'id=' . $id);
                    }
                }
                //更新缓存
                if ($result)
                {
                    $this->catLogic->updateCache($path_id);
                }
                //多语言处理
                $details = Inputer::getOrgPost('detail');
                $seo_title = _p('title');
                $seo_keywords = _p('keywords');
                $seo_descript = _p('descript');
                $list_template = _p('list_template');
                $goods_template = _p('goods_template');
                $cat_image = _p('image');
                foreach ($catName as $key => $value)
                {
                    $lang_data = array(
                        'base_name' => Common::strEscape($value),
                        'goods_category_id' => $id,
                        'language_id' => $key,
                        'list_template' => Common::strEscape($list_template[$key]),
                        'goods_template' => Common::strEscape($goods_template[$key]),
                        'detail' => Common::strEscape($details[$key], false),
                        'title' => Common::strEscape($seo_title[$key]),
                        'keywords' => Common::strEscape($seo_keywords[$key]),
                        'descript' => Common::strEscape($seo_descript[$key]),
                        'status' => Common::queryInt(_p('is_display-' . $key)),
                        'image' => isset($cat_image[$key]) ? Common::strEscape($cat_image[$key]) : '',
                    );
                    $this->goodsCatLangLogic->updateByCond($lang_data);
                    if(_p('is_extentd'))
                    {
                        $cat = $this->catLogic->getOneById($id);
                        if(!$cat)
                        {
                            return $this->showMessage('illegal_parameters');
                        }
                        //修改子分类模版
                        $cond = 'path_id like "' . $cat['path_id'] . '%" and id !=' . $id;
                        $cat_res = $this->catLogic->findAll($cond);
                        $goods_category_ids = array(0);//防止没有子类的时候出现in(,8)
                        foreach($cat_res as $value){
                            $goods_category_ids[] =$value['id'];
                        }
                        $extend_data = array(
                            'goods_template' => isset($goods_template[$key]) ? $goods_template[$key] : '',
                        );
                        $cond = 'language_id='.$key.' and goods_category_id in (' . implode(',', $goods_category_ids) .')';
                        $this->goodsCatLangLogic->saveByCond($extend_data, $cond);
                    }
                    //更新缓存
                    $this->catLogic->updateListCache($key);
                }
                if (Common::queryInt(_p('parent_id')) != $cur_cat['parent_id'])
                {
                    $son_cond = 'path_id like"' . $cur_cat['path_id'] . '%" and id !=' . $id;
                    $rel_cond = 'category_path like"' . $cur_cat['path_id'] . '%"';
                    $son_cats = $this->catLogic->findAll($son_cond);

                    foreach ($son_cats as $val)
                    {
                        $son_path_id = str_replace(',' . $cur_cat['path_id'], ',' . $path_id, ',' . $val['path_id']);
                        if (substr($son_path_id, 0, 1) == ',')
                        {
                            $son_path_id = substr($son_path_id, 1);
                        }
                        $map = Zhtx::createDataMap();
                        $map->addEntry('path_id', $son_path_id, DB::VARCHAR);
                        $this->catLogic->update($map, 'id=' . $val['id']);
                    }
                    $goodCatRelLogic = $this->load('goodsCategoryRel');
                    $goodsLangLogic = $this->load('goodsLanguage');
                    $rel_son_cats = $goodCatRelLogic->findAll($rel_cond);
                    foreach ($rel_son_cats as $item)
                    {
                        $son_path_id = str_replace(',' . $cur_cat['path_id'], ',' . $path_id, ',' . $item['category_path']);
                        if (substr($son_path_id, 0, 1) == ',')
                        {
                            $son_path_id = substr($son_path_id, 1);
                        }
                        $map = Zhtx::createDataMap();
                        $map->addEntry('category_path', $son_path_id, DB::VARCHAR);
                        $goodCatRelLogic->update($map, 'id=' . $item['id']);
                        $goodsLangLogic->update($map, 'goods_id=' . $item['goods_id']);
                        //删除缓存
                        $goodsLangLogic->updateCache($item['goods_id']);
                    }
                }
                return $diy_url_flag ? $this->success('save_success', Common::adminURL('product', 'category', 'list')) : $this->showMessage('diy_url_already_exists');
            }
        }
        else
        {
            global $shopping_data_config;
            $themes = $this->load('theme')->findAll('', true);
            $tplConf = Common::getTplConf();
            $id = _g('id') ? intval(_g('id')) : 0;
            $category = $this->catLogic->getOne('id=' . $id);
            if (!$category)
            {
                return $this->showMessage('not_found_record');
            }
            if($category['diy_param']!='')
            {
                $category['diy_param'] = json_decode($category['diy_param'],TRUE);
            }
            //还需要查询多语言
            Core::$tpl->set('category', $category);
            $categorys = $this->catLogic->getList('id !=' . $id);
            $parents = array();
            foreach (Common::getTree($categorys['list']) as $item)
            {
                $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
            }
            Core::$tpl->set('cats', $parents);
            $languages = $this->langLogic->getList('status=1');
            $cond = 'goods_category_id = ' . $id;
            $catlangs = $this->goodsCatLangLogic->getList($cond);
            $catlang_arr = array();
            foreach ($catlangs['list'] as $value)
            {
                $catlang_arr[$value['language_id']] = $value;
            }
            $lang_arr = array();
            $template = array();
            foreach ($languages['list'] as $item)
            {
                $lang_arr[$item['id']] = array(
                    'id' => $item['id'],
                    'base_name' => $item['base_name'],
                    'country_code_2' => $item['country_code_2'],
                    'lang_name' => $catlang_arr[$item['id']]['base_name'],
                    'title' => $catlang_arr[$item['id']]['title'],
                    'keywords' => $catlang_arr[$item['id']]['keywords'],
                    'descript' => $catlang_arr[$item['id']]['descript'],
                    'detail' => $catlang_arr[$item['id']]['detail'],
                    'list_template' => $catlang_arr[$item['id']]['list_template'],
                    'goods_template' => $catlang_arr[$item['id']]['goods_template'],
                    'status' => isset($catlang_arr[$item['id']]) ? $catlang_arr[$item['id']]['status'] : 0,
                    'image' => $catlang_arr[$item['id']]['image'],
                );
                $template[$item['id']] = $tplConf[$themes[$item['theme_id']]['theme_dir']];
            }
            $typeLogic = $this->load('goodsType');
            $types = $typeLogic->getList('status=1 order by listorder asc');

            $seotpl = $this->seotplLogic->findAll('1=1');
            Core::$tpl->set('seotpl', $seotpl);
            Core::$tpl->set('languages', $lang_arr);
            Core::$tpl->set('parentid', $category['parent_id']);
            Core::$tpl->set('types', $types['list']);
            Core::$tpl->set('template', $template);
            Core::$tpl->set('shopping_data_config', $shopping_data_config);
            Core::$htmlFile = 'category/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionPublicGetList()
    {
        $categorys = $this->catLogic->findAll();
        $parents = array();
        foreach (Common::getTree($categorys) as $item)
        {
            $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
        }
        echo json_encode($parents);
    }

    public function actionPublicGetCategoryTree($arr_category, $id)
    {
        $path_id = split(',', $arr_category[$id]["path_id"]);
        unset($path_id[count($path_id) - 1]);
        $path_id_level = substr_count($arr_category[$id]["path_id"], ",");
        $new_category = array();
        foreach ($arr_category as $key => $value)
        {
            $level = substr_count($arr_category[$key]["path_id"], ",");
            $value["level"] = $level;
            $cur_path_id = $arr_category[$key]["path_id"];
            if ($value["parent_id"] != 0)
                $value[$value["parent_id"]]["has_son"] = 1;
            if ($level >= 2 && $id != 0 && $level <= $path_id_level + 1)
            {
                $path_now = join(',', array_slice($path_id, 0, $level - 1)) . ",";
                if (strpos($cur_path_id, $path_now) === 0)
                {
                    //print($cur_path_id." " . $path_now."\n");
                    $new_category[$value["parent_id"]]["straight_root"] = "yes";
                    $new_category[$key] = $value;
                }
            }
            else if ($level < 2 && $id != 0)
            {
                if ($path_id[0] == $value["id"])
                    $value["straight_root"] = "yes";
                $new_category[$key] = $value;
            }
            else if ($id == 0 && $level < 2)
            {
                $new_category[$key] = $value;
            }
        }
        return $new_category;
    }

    public function actionPublicAjax()
    {
        $categorys = $this->catLogic->getList('parent_id=0 order by listorder asc');
        Core::$tpl->set('list', $categorys['list']);
    }

    public function actionPublicAjaxcategory()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $fun = _g("fun");
        $id = _g("id");
        $mid = _g("mid");
        $expt_id = Common::queryInt(_g('expt_id'));
        $html = "<div style=\"width:180px\"><div class=\"bwSelect\">";
        $html .= "<input type=\"text\" class=\"bwSelectText\" readonly=\"readonly\" value=\"" . $lang["top_category"] . "\" />";
        $html .= "<input type=\"hidden\" class=\"bwSelectValue\" value=\"0\" />";
        $html .= "<ul class=\"bwSelectOption\" >";
        $html .= "<li data=\"0\" onclick=\"getGoodsCategorySon" . $mid . "(this,$id,0,'$fun')\">" . $lang["top_category"] . "</li>";

        $categorys = $this->catLogic->getList("parent_id=$id and id<>$expt_id order by listorder desc");
        if (!$categorys["list"])
        {
            echo "";
            die();
        }
        foreach ($categorys["list"] as $key => $value)
        {
            $html .= "<li data=\"0\" onclick=\"getGoodsCategorySon" . $mid . "(this," . $value["id"] . ",1,'$fun')\"> " . $value["base_name"] . "</li>";
        }
        $html .= "</ul>";
        $html .= "</div></div>";
        echo $html;
    }



    public function actionAjaxcategorypath()
    {
        $id = Common::queryInt(_g("id"));
        $expt_id = Common::queryInt(_g('expt_id'));
        $fun = _g("fun");
        if ($id)
        {
            $dcate = $this->catLogic->getOne("id=$id");
            $path = "0," . $dcate["path_id"];
            $arr_path = split(',', $path);
            array_pop($arr_path);
            array_pop($arr_path);
        }
        else
            $arr_path = array(0);
        $data = array();
        foreach ($arr_path as $key => $value)
        {
            if ($value == 0)
                $level = 1;
            else
            {
                $dcate = $this->catLogic->getOne("id=$value");
                $path = $dcate["path_id"] . "0";
            }
            $tmp = array();
            if($expt_id)
            $list = $this->catLogic->getList("parent_id=$value and id<>$expt_id order by listorder desc");
            else
            $list = $this->catLogic->getList("parent_id=$value order by listorder desc");
            $tmp["parent_id"] = $value;
            $tmp["base_name"] = $dcate["base_name"];
            foreach ($list["list"] as $key1 => $value1)
            {
                if ($arr_path[$key + 1] == "" && $value1["id"] == $id)
                    $value1["selected"] = 1;
                if ($value1["id"] == $arr_path[$key + 1])
                    $value1["selected"] = 1;
                $tmp["list"][] = $value1;
            }
            $data[] = $tmp;
        }

        echo json_encode($data);
    }

    /**
     * 分类删除
     * @return type
     */
    public function actionDel()
    {
        $category_id = Common::queryInt(_g('id'));
        $cat = $this->catLogic->getOneById($category_id);
        if (!$cat)
        {
            return $this->showMessage('illegal_parameters');
        }
        $cond = 'path_id like "' . $cat['path_id'] . '%" and id !=' . $category_id;
        $count = $this->catLogic->getCount($cond);
        if ($count > 0)
        {
            return $this->showMessage('has_child_not_delete');
        }
        $relationLogic = $this->load('goodsCategoryRel');
        $cond2 = 'category_path like "' . $cat['path_id'] . '%"';
        $rel_product_count = $relationLogic->getCount($cond2);
        if($rel_product_count > 0)
        {
           return $this->showMessage('has_goods_not_delete');
        }
        $this->load('urlAlisa')->deleteDiyUrl($cat['page_url']);
        $res = $this->catLogic->delete('id=' . $category_id);
        if ($res)
        {
            $this->goodsCatLangLogic->delete('goods_category_id=' . $category_id);
            $relationLogic->delete('goods_category_id=' . $category_id);
        }
        return $this->success('operation_success');
    }

    /**
     * 修改排序
     * ajax
     */
    public function actionPublicEditSort()
    {
        $id = Common::queryInt(_p('id'));
        if (!$id)
        {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $sort_weight = Common::queryInt(_p('sort_weight'));
        $map = Zhtx::createDataMap();
        if ($listorder)
        {
            $map->addEntry('listorder', $listorder, DB::INT);
        }
        if ($sort_weight)
        {
            $map->addEntry('sort_weight', $sort_weight, DB::INT);
        }
        $res = $this->catLogic->update($map, 'id=' . $id);
        if ($res)
        {
            foreach ($this->langLogic->findAll('status=1') as $value)
            {
                $this->catLogic->updateListCache($value['id']);
            }
        }
        echo $res ? 1 : 0;
    }

    /**
     * 批量添加分类
     * @return type
     */
    public function actionBatchAddChild()
    {
        if (_p())
        {
            $parent_id = Common::queryInt(_p('parent_id'));
            $goods_type_id = Common::queryInt(_p('goods_type_id'));
            $languages = $this->langLogic->findALL('status=1', true);
            $base_site_id = Common::validSiteConfig();
            for ($index = 0; $index <= 20; $index++)
            {
                if (!_p('base_name_'.$base_site_id.'_' . $index))
                {
                    continue;
                }
                $cat_data = array(
                    'base_name' => Common::strEscape(_p('base_name_'.$base_site_id.'_' . $index)),
                    'parent_id' => $parent_id,
                    'goods_type_id' => $goods_type_id,
                    'create_time' => SYS_TIME,
                );
                $result = $this->catLogic->save($cat_data);
                if ($result)
                {
                    $path_id = $result . ',';
                    $parentId = $parent_id;
                    if ($parentId)
                    {
                        $path_id = $parentId . ',' . $path_id;
                        while ($parentId)
                        {
                            $cat = $this->catLogic->getOne('id=' . $parentId);
                            if ($cat['parent_id'])
                            {
                                $path_id = $cat['parent_id'] . ',' . $path_id;
                            }
                            $parentId = $cat['parent_id'];
                        }
                    }
                    $new_cat_map = Zhtx::createDataMap();
                    $new_cat_map->addEntry('path_id', $path_id, DB::VARCHAR);
                    $res = $this->catLogic->update($new_cat_map, 'id=' . $result);
                    if ($res)
                    {
                        $this->catLogic->updateCache($path_id);
                    }
                    foreach ($languages as $item)
                    {
                        if (_p('base_name_' . $item["id"] . '_' . $index))
                        {
                            $lang_data = array(
                                'base_name' => Common::strEscape(_p('base_name_' . $item["id"] . '_' . $index)),
                                'goods_category_id' => $result,
                                'language_id' => $item["id"],
                            );
                            $this->goodsCatLangLogic->save($lang_data);
                            //更新缓存
                            $this->catLogic->updateListCache($item["id"]);
                        }
                    }
                }
            }
            return $this->success('save_success', Common::adminURL('product', 'category', 'list'));
        }
        else
        {
            $parentId = Common::queryInt(_g('pid'));
            $categorys = $this->catLogic->getList();
            $parents = array();
            $goods_type_id = 0;
            foreach (Common::getTree($categorys['list']) as $item)
            {
                if ($item['id'] == $parentId)
                {
                    $goods_type_id = $item['goods_type_id'];
                }
                $parents[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
            }
            $languages = $this->langLogic->getList('status=1');
            $typeLogic = $this->load('goodsType');
            $types = $typeLogic->getList('status=1 order by listorder asc');
            for($i=0;$i<20;$i++){
                $index[]=$i;
            }
            Core::$tpl->set('parentid', $parentId);
            Core::$tpl->set('goods_type_id', $goods_type_id);
            Core::$tpl->set('cats', $parents);
            core::$tpl->set('languages', $languages['list']);
            core::$tpl->set('types', $types['list']);
            Core::$tpl->set('index', $index);
        }
    }

    public function actionCheckGoodsCount()
    {
        $this->catLogic->checkGoodsCount();
        echo json_encode(array('msg' => '效验完成'));
    }

    /**
     * ajax 更新状态
     * 更新分类及自分类状态和相关分类下的商品会一起更新单品及sku商品
     */
    public function actionPublicEditStatus()
    {
        $return = 0;
        $id     = Common::queryInt(_g('id'));
        $cat = $this->catLogic->getOneById($id);
        if(!$cat)
        {
            return $this->showMessage('illegal_parameters');
        }
        $status = _g('currentStatus');
        if($status == 1){
            $data['status']  = 1;
            $sku_data['status'] = 1;
        }else{
            $data['status']  = 0;
            $sku_data['status'] = 0;
        }
        $cond = 'goods_category_id=' . $id;
        $res = $this->goodsCatLangLogic->saveByCond($data, $cond);
        $cond = 'path_id like "' . $cat['path_id'] . '%" and id !=' . $id;
        $count = $this->catLogic->getCount($cond);
        //修改父级分类状态
        if($count==1&&$status == 1){
            $cond = 'goods_category_id in (' . substr($cat['path_id'],0,-1) .')';
            $goods_category_res = $this->goodsCatLangLogic->saveByCond($data, $cond);
        }
        //修改子分类状态
        $cond = 'path_id like "' . $cat['path_id'] . '%" and id !=' . $id;
        $cat_res = $this->catLogic->findAll($cond);
        $goods_category_ids = array(0);//防止没有子类的时候出现in(,8)
        foreach($cat_res as $key=>$value){
            $goods_category_ids[] =$value['id'];
        }
        $cond = 'goods_category_id in (' . implode(',', $goods_category_ids) .','.$id.')';
        $goods_category_res = $this->goodsCatLangLogic->saveByCond($data, $cond);

        $cond = 'id in (' . implode(',', $goods_category_ids) .','.$id.')';

        $this->catLogic->saveByCond($data, $cond);

        //下架分类下的商品
        $cond = 'category_path like "' . $cat['path_id'] . '%" group by goods_id';
        $goodsLanguageLogic = $this->load('goodsLanguage');
        $goods_language_res = $goodsLanguageLogic->findAll($cond);
        $goods = array(0);
        foreach($goods_language_res as $key=>$value){
            $goods[] =$value['goods_id'];
        }

        $cond = 'id in (' . implode(',', $goods) .','.$id.')';
        $goods_res = $this->load('goods')->saveByCond($data, $cond);
        if($goods_res){
            $cond = 'goods_id in (' . implode(',', $goods) .','.$id.')';
            $goodsLanguageLogic->saveByCond($data, $cond);
            $this->load('sku')->saveByCond($sku_data, $cond);
            _crearCahce('goods_list');
            _crearCahce('goods_info');
            _crearCahce('category');
            _crearCahce('brand');
            _crearCahce('promotions');
            _crearCahce('navpage');
            _crearCahce('nav');
            _crearCahce('address');
            _crearCahce('user_group');
            _crearCahce('config');
            $cache_dir = APP_ROOT . 'cache/tpl/';
            Dir::delDirAndFile($cache_dir);//清除smarty编译文件
            $return = 1;
        }
        echo $return;
    }
    /**
     * 效验关联页面有效性
     */
    public function actionCheckEffective(){
        $navPageLogic = $this->load("navPage");
        $data = $this->catLogic->findAll("1=1","id,nav_page_id");
        if($data){
            $yarray = array();
            $sarray = array();
            $carray = array();
            foreach($data as $value){
                $pieces = explode(",",$value["nav_page_id"]);
                if($pieces){
                    $yarray[$value["id"]]=$pieces;
                    foreach($pieces as $val){
                        if($val){
                            $sarray[$val]=$val;
                        }
                    }
                }
            }
            foreach($sarray as $value){
                if(!$navPageLogic->getOneById($value)){
                    $res = self::array_searchs($yarray, $value);
                    foreach($res as $v){
                        unset($yarray[$v][array_search($value,$yarray[$v])]);
                        $carray[$v]= $yarray[$v];
                    }
                }
            }
            foreach($carray as $key=>$cval){
                if($key){
                    if($cval){
                        $comma_separated = join(",", $cval);
                    }else{
                        $comma_separated="";
                    }
                    $map = Zhtx::createDataMap();
                    $map->addEntry("nav_page_id", $comma_separated,DB::VARCHAR);
                    $this->catLogic->updateById($map,$key);
                }
            }
            echo json_encode(array('msg' => '效验完成'));
            exit;
        }
        echo json_encode(array('msg' => '效验失败'));
        exit;
    }
    /**
     * 在数组中搜索给定的值 针对 actionCheckEffective() 开发
     * @param type $array
     * @param type $val
     * @return boolean
     */
    private function array_searchs($array,$val){
        if($array){
            $new_array = array();
            foreach($array as $key=>$value){
                $boole = false;
                foreach ($value as $k=>$v){
                    if($v == $val){
                        $new_array[]=$key;
                    }
                }
            }
            return $new_array;
        }
        return false;
    }
}
?>