<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Channel
 *
 * @author ZJH
 */
class ChannelController extends AppController {

    private $category;
    private $channelTag;
    private $channelTagGoodsRel;
    private $channelTagLanguage;
    private $goodsCatRelLogic;
    private $goodsCatLangLogic;
    private $langLogic;

    public function __construct() {
        parent::__construct();
        $this->category = $this->load('goodsCategory');
        $this->channelTag = $this->load('channelTag');
        $this->channelTagGoodsRel = $this->load('channelTagGoodsRel');
        $this->channelTagLanguage = $this->load('channelTagLanguage');
        $this->goodsCatRelLogic = $this->load('goodsCategoryRel');
        $this->goodsCatLangLogic = $this->load('goodsCategoryLanguage');
        $this->langLogic = $this->load('language');
    }

    //频道管理
    public function actionList() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $where = 'is_channel=1';
        $where .= " ORDER BY id DESC";
        $count = $this->category->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->category->getCurrentDatas($where, $page_size, $curr_page);

        foreach ($res as $value) {
            $channel_ids[] = $value['id'];
            $tag_num[$value['id']] = 0;
        }
        if ($channel_ids) {
            $tag_res = $this->channelTag->findAll("category_id in (" . join(',', $channel_ids) . ",0)");
            foreach ($tag_res as $value) {
                $tag_num[$value['category_id']] ++;
            }
        }
        Core::$tpl->set("res", $res);
        Core::$tpl->set("tag_num", $tag_num);
        Core::$tpl->set("pages", $page_data);
    }

    //频道管理 > 设置
    public function actionEdit() {
        if (_p()) {
            $category_id = Common::queryInt(_p('id'), 1);
            $channelSysTag = Common::queryInt(_p('channelSysTag')) == 1 ? 1 : 0;            
            $category_ids    = _p('category_id');
            $map = Zhtx::createDataMap();
            $map->addEntry('is_channel_sys_tag', $channelSysTag, DB::INT);
            if($category_ids)
            $map->addEntry('channel_category_ids', join(',',$category_ids), DB::VARCHAR);
            else
            $map->addEntry('channel_category_ids', '', DB::VARCHAR);
            $res = $this->category->updateById($map, $category_id);

            //多语言处理              
            $details = Inputer::getOrgPost('detail');
            foreach ($details as $key => $value)
            {
                $lang_data = array(
                    'goods_category_id' => $category_id,
                    'language_id' => $key,
                    'channel_detail' => Common::strEscape($details[$key], false),
                );
                $this->goodsCatLangLogic->updateByCond($lang_data);
                //更新缓存
                $this->category->updateListCache($key);
            }
            
            return $res ? $this->success('edit_success', Common::adminURL('product', 'channel', 'list')) : $this->showMessage('edit_failure');
        } else {
            $category_id = Common::queryInt(_g('id'), 1);
            $category = $this->category->getOneById($category_id);
            if (!$category) {
                return $this->error('id_error', Common::adminURL('product', 'channel', 'list'));
            }
            //分类查询
            $category_ids = explode(',', $category['channel_category_ids']);
            foreach ($category_ids as $key => $value)
            {
                $goods_category[$value] = $value;
            }
            
            $languages = $this->langLogic->getList('status=1');
            $cond = 'goods_category_id = ' . $category_id;
            $catlangs = $this->goodsCatLangLogic->getList($cond);
            $catlang_arr = array();
            foreach ($catlangs['list'] as $value)
            {
                $catlang_arr[$value['language_id']] = $value;
            }
            $lang_arr = array();
            foreach ($languages['list'] as $item)
            {
                $lang_arr[$item['id']] = array(
                    'id' => $item['id'],
                    'base_name' => $item['base_name'],
                    'country_code_2' => $item['country_code_2'],
                    'lang_name' => $catlang_arr[$item['id']]['base_name'],
                    'detail' => $catlang_arr[$item['id']]['channel_detail'],
                );
            }
            Core::$tpl->set('goods_category', $goods_category);
            Core::$tpl->set('languages', $lang_arr);
            Core::$tpl->set('category', $category);
            Core::$htmlFile = 'channel/edit';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    //频道管理 > 频道删除
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $category = $this->category->getOne('id=' . $id);
                $this->load('urlAlisa')->deleteDiyUrl($category['page_url']);
                $map = Zhtx::createDataMap();
                $map->addEntry('is_channel', 0, DB::INT);
                $res = $this->category->updateById($map, $id);
                $this->channelTagGoodsRel->delete('category_id=' . $id);
                $channel_tags = $this->channelTag->findAll('category_id=' . $id . " order by listorder desc");
                $tags_ids = array();
                $tags_ids[] = 0;
                foreach ($channel_tags as $value) {
                    $tags_ids[] = $value['id'];
                }
                $this->channelTagLanguage->delete("channel_tag_id in (" . join(',', $tags_ids) . ")");
                $this->channelTag->delete("category_id=" . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    //频道标签列表
    public function actionTagList() {
        $category_id = Common::queryInt(_g('category_id'));
        $category = $this->category->getOneById($category_id);
        if (!$category) {
            return $this->error('id_error', Common::adminURL('product', 'channel', 'list'));
        }
        $res = $this->channelTag->findAll('category_id=' . $category_id . " order by listorder desc");
        if ($res) {
            foreach ($res as $value) {
                $tag_ids[] = $value['id'];
                $good_num[$value['id']] = 0;
            }
            $tag_res = $this->channelTagGoodsRel->findAll("channel_tag_id in (" . join(',', $tag_ids) . ",0)");
            foreach ($tag_res as $value) {
                $good_num[$value['channel_tag_id']] ++;
            }
            Core::$tpl->set("good_num", $good_num);
        }
        Core::$tpl->set('res', $res);
        Core::$tpl->set('category', $category);
        Core::$htmlFile = 'channel/taglist';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    //频道标签 > 新增频道标签
    public function actionAddTag() {
        if (_p()) {
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('required_item');
            }
            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
                'category_id' => Common::queryInt(_g('category_id')),
                'create_time' => SYS_TIME,
            );
            $tag_res = $this->channelTag->saveByCond($data);
            if ($tag_res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
                    $lang_data = array(
                        'language_id' => $key,
                        'channel_tag_id' => $tag_res,
                        'base_name' => Common::strEscape(_p('base_name' . $key)),
                        'status' => Common::queryInt(_p('status' . $key)),
                            //'listorder' => $listorder,
                            //'create_time' => SYS_TIME,
                    );
                    $this->channelTagLanguage->saveByCond($lang_data);
                }

                return $this->success('add_success', Common::adminURL('product', 'channel', 'tagList', array('category_id' => _g('category_id'))));
            }
            return $this->error('add_failure', Common::adminURL('product', 'channel', 'tagList', array('category_id' => _g('category_id'))));
        } else {
            $category_id = Common::queryInt(_g('category_id'));
            $category = $this->category->getOneById($category_id);
            if (!$category) {
                return $this->error('id_error', Common::adminURL('product', 'channel', 'list'));
            }
            $languages = $this->load('language')->findAll('status=1');
            Core::$tpl->set('category', $category);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'channel/tagform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    //频道标签 > 编辑频道标签
    public function actionEditTag() {
        if (_p()) {
            $tag_id = Common::queryInt(_p('id'));
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('required_item');
            }
            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
                'create_time' => SYS_TIME,
            );
            $tag_res = $this->channelTag->saveByCond($data, 'id=' . $tag_id);
            if ($tag_res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
                    $lang_data = array(
                        'language_id' => $key,
                        'channel_tag_id' => $tag_id,
                        'base_name' => Common::strEscape(_p('base_name' . $key)),
                        'status' => Common::queryInt(_p('status' . $key)),
                            //'listorder' => $listorder,
                            //'create_time' => SYS_TIME,
                    );
                    $cond = 'channel_tag_id=' . $tag_id . ' and language_id=' . $key;
                    $this->channelTagLanguage->saveByCond($lang_data, $cond);
                }
                return $this->success('edit_success', Common::adminURL('product', 'channel', 'tagList', array('category_id' => _g('category_id'))));
            }
            return $this->error('edit_failure', Common::adminURL('product', 'channel', 'tagList', array('category_id' => _g('category_id'))));
        } else {
            $category_id = Common::queryInt(_g('category_id'));
            $category = $this->category->getOneById($category_id);
            if (!$category) {
                return $this->error('id_error', Common::adminURL('product', 'channel', 'list'));
            }
            $tag_id = Common::queryInt(_g('id'));
            $tag = $this->channelTag->getOneById($tag_id);
            if (!$tag) {
                return $this->showMessage('not_found_record');
            }
            $tag_cond = 'channel_tag_id=' . $tag_id;
            $lang_data = array();
            $lang = $this->channelTagLanguage->findAll($tag_cond);
            foreach ($lang as $value) {
                $lang_data[$value['language_id']] = $value;
            }
            $languages = $this->load('language')->findAll('status=1');
            Core::$tpl->set('channelTag', $tag);
            Core::$tpl->set('category', $category);
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('langtag', $lang_data);
            Core::$htmlFile = 'channel/tagform';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    //关联商品
    public function actionShowTagGoods() {
        $category_id = Common::queryInt(_g('category_id'));
        $channel_tag_id = Common::queryInt(_g('tag_id'));
        $category = $this->category->getOneById($category_id);
        $channelTag = $this->channelTag->getOneById($channel_tag_id);
        $Exist_goods = $this->channelTagGoodsRel->findAll('channel_tag_id=' . $channel_tag_id . " order by listorder desc");

        $Exist_goods_ids = array();
        foreach ($Exist_goods as $value) {
            $Exist_goods_ids[$value['goods_id']] = $value['goods_id'];
        }
        $results = array();
        $rel_categories = array();
        if (count($Exist_goods_ids)) {
            $cond = 'id in (' . implode(',', $Exist_goods_ids) . ')';
            $results = $this->load('goods')->findAll($cond, true);

            $c_cond = 'g.goods_id in(' . implode(',', $Exist_goods_ids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
        $type_ids = array();
        foreach ($results as $value) {
            $type_ids[$value['goods_type_id']] = $value['goods_type_id'];
        }
        $goods_types = array();
        if (count($type_ids) > 0) {
            $goods_types = $this->load('goodsType')->findAll('id in (' . implode(',', $type_ids) . ')', true);
        }
        foreach ($Exist_goods as $key => $value) {
            $Exist_goods[$key]["good"] = $results[$value['goods_id']];
        }
        Core::$tpl->set("res_rel", $Exist_goods);
        Core::$tpl->set("res", $results);
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("brands", $this->load('brand')->findAll('', true));
        Core::$tpl->set('category', $category);
        Core::$tpl->set('channelTag', $channelTag);
        Core::$htmlFile = 'channel/taggoods';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    //关联商品 > 添加关联商品
    public function actionPublishGoods() {
        $category_id = Common::queryInt(_g('category_id'));
        $channel_tag_id = Common::queryInt(_g('tag_id'));
        $goods_ids = _p('ids');
        $goodsLogic = $this->load('goods');
        if (!$goods_ids) {
            echo json_encode(array('status' => 0, 'msg' => '请先选择商品！'));
            return;
        }
        $Exist_goods = $this->channelTagGoodsRel->findAll('category_id=' . $category_id . ' and channel_tag_id=' . $channel_tag_id);
        $Exist_goods_ids = array();
        foreach ($Exist_goods as $value) {
            $Exist_goods_ids[$value['goods_id']] = $value['goods_id'];
        }
        $goods_ids_arr = explode(',', $goods_ids);
        $new_goods = array_diff($goods_ids_arr, $Exist_goods_ids);
        foreach ($new_goods as $value) {
            if ($goodsLogic->getOne('id=' . $value)) {
                $data = array(
                    'category_id' => $category_id,
                    'channel_tag_id' => $channel_tag_id,
                    'goods_id' => $value,
                );
                $res = $this->channelTagGoodsRel->saveByCond($data);
                $this->channelTagGoodsRel->saveByCond(array('listorder' => $res), 'id=' . $res);
            }
        }
        echo json_encode(array('status' => 1, 'msg' => '添加成功！'));
        return;
    }

    //频道标签 > ajax 修改状态
    public function actionPublicEditTagStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');

        //  $data['status'] = $status;
        //  $cond = 'channel_tag_id=' . $id;
        //  $res = $this->topicTagLanguageLogic->saveByCond($data, $cond);

        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->channelTag->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    //频道标签 > ajax 修改排序
    public function actionPublicQuickEdit() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        if (!is_numeric(_p('listorder'))) {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        if ($listorder)
            $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->channelTag->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }

    //频道标签 > 标签删除
    public function actionDelTag() {
        $tag_id = Common::queryInt(_g('id'));
        $category_id = Common::queryInt(_g('category_id'));
        $this->channelTagGoodsRel->delete('category_id=' . $category_id);
        $this->channelTagLanguage->delete('channel_tag_id=' . $tag_id);
        $this->channelTag->delete('id=' . $tag_id);
        return $this->success('del_success', Common::adminURL('product', 'channel', 'tagList', array('category_id' => $category_id)));
    }

    // 关联商品 > ajax 排序
    public function actionPublicQuickEditTagsRel() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        if (!is_numeric(_p('listorder'))) {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        if ($listorder)
            $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->channelTagGoodsRel->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }

    //关联商品 > 删除商品
    public function actionDelGoods() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->channelTagGoodsRel->delete('id=' . $id);
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

}
