<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of coupon
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class CouponController extends AppController
{
  private $couponLogic;
  private $offerLogic;
  private $langLogic;
  private $ruleLogic;
  private $giftLogic;
  private $itemLogic;
  private $offerLangLogic;
  public function __construct()
  {
    parent::__construct();
    $this->couponLogic = $this->load('coupon');
    $this->offerLogic = $this->load('offer');
    $this->langLogic  = $this->load('language');
    $this->ruleLogic  = $this->load('offerRule');
    $this->giftLogic  = $this->load('offerGift');
    $this->itemLogic  = $this->load('offerItem');
    $this->offerLangLogic  = $this->load('offerLanguage');
  }
  public function actionAdd()
  {
    if(_p())
    {
      $base_site_id = Common::validSiteConfig();
      $base_name  = _p('base_name');
      $default_base_name = $base_name[$base_site_id];       
       if(!$default_base_name)
       {
         return $this->showMessage('default_site_required');
       }
       $start_time = _p('start_time') ? strtotime(_p('start_time')) : 0;
       $end_time   = _p('end_time') ? strtotime(_p('end_time')) : 0;
       if(!$start_time || !$end_time)
       {
         return $this->showMessage('please_select_time_tips');
       }
       else if($start_time > $end_time)
       {
         return $this->showMessage('start_time_over');
       }
       else if($start_time == $end_time)
       {
         return $this->showMessage('start_time_eq_end_time');
       }
       else if($end_time < SYS_TIME)
       {
         return $this->showMessage('end_time_less');
       }
       $status = Common::queryInt(_p('status'));
       $offer_data = array(
           'base_name'   => Common::strEscape($default_base_name),
           'offer_type'  => 2,//优惠券
           'is_spec'     => Common::queryInt(_p('is_spec')),
           'start_time'  => $start_time,
           'end_time'    => $end_time,
           'days'        => Common::queryInt(_p('days')),
           'using_num'   => Common::queryInt(_p('using_num')),
           'send_limit'  => Common::queryInt(_p('send_limit')),
           'prefix'      => _p('prefix'),
           'create_time' => SYS_TIME,
           'status'      => $status,
           'coupon_type'      => Common::queryInt(_p('coupon_type')),
       );
       $coupon_obj = _p('coupon_obj');
       switch ($coupon_obj)
       {
           case 'cart' : 
             $offer_data['is_cart'] = 1; 
             break;
           case 'brand':
             $offer_data['is_brand'] = 1;
             if(!_p('brand_id'))
             {
               return $this->showMessage('please_select_brand');
             }
             $offer_data['brand_id'] = Common::queryInt(_p('brand_id'));
             break;
           case 'category':
             $offer_data['is_category'] = 1;
             if(!_p('category_id'))
             {
               return $this->showMessage('please_select_category');
             }
             $offer_data['category_id'] = Common::queryInt(_p('category_id'));
             break;
           case 'goods':
             $offer_data['is_goods'] = 1;break;
           default : break;
       }
       $offer_result = $this->offerLogic->save($offer_data);
       if($offer_result)
       {
          $detail    = Inputer::getOrgPost('detail');
          foreach ($base_name as $key => $name)
          {
            $lang_data = array(
              'offer_id'    => $offer_result,
              'language_id' => $key,
              'base_name'   => Common::strEscape($name),
              'detail'      => Common::strEscape($detail[$key],false),
            );
            $this->offerLangLogic->save($lang_data);
            //清理缓存
           $this->offerLogic->delCache($key);
          }
          $rule_data = array(
            'offer_id'  => $offer_result,
            'status'    => $status, 
          );
          $buy_cond = Common::queryInt(_p('buy_cond'));
          switch ($buy_cond)
          {
              case 1:
                $rule_data['min_amount'] = _p('min_amount') ? _p('min_amount') : 0;
                break;
              case 2:
                $rule_data['min_buynum'] = Common::queryInt(_p('min_buynum'));
                break;
              case 3:
                $rule_data['min_amount'] = 0;
                $rule_data['min_buynum'] = 0;
                break;
              default : break;
          }
          $offer_cond = Common::queryInt(_p('offer_cond'));
          switch ($offer_cond)
          {
              case 1:
                $rule_data['minus'] = _p('minus') ? _p('minus') : 0;
                break;
              case 2:
                $rule_data['discount'] = _p('discount') ? _p('discount') : 0;
				break;
              case 3:
                $rule_data['free_ship'] = 1;           
              default : break;
          }
          $this->ruleLogic->save($rule_data);
          //商品促销处理
         if($coupon_obj == 'goods')
         {
           $participate_goods_ids = _p('goods_ids');
           foreach ($participate_goods_ids as $value)
           {
                $item_data = array(
                  'offer_id' => $offer_result,
                  'goods_id' => $value,
                );
                $this->itemLogic->save($item_data);
           }
         }
         //自动生成通用优惠券
         if($offer_data['coupon_type']==1)
         {
            $coupon_code     = $offer_data['prefix'];
            $coupon_data = array(
                'offer_id'    => $offer_result,
                'coupon_code' => $coupon_code,
                'create_time' => SYS_TIME,
                'status'      => 1,        
            );
            $c_res = $this->couponLogic->save($coupon_data);
            if($c_res)
            {                
                $offer_update_data = array(
                    'send_limit'    => 0,
                    'send_num' => 0,   
                );
                $this->offerLogic->save($offer_update_data,$offer_result);
            }
         }
         return $this->success('add_success', Common::adminURL('product', 'coupon', 'list'));
       }
       return $this->showMessage('add_failure');
    }
    else
    {
      $sites = $this->langLogic->findAll('status=1');
      Core::$tpl->set('sites', $sites);
      Core::$htmlFile  = 'coupon/form';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
  }
  public function actionEdit()
  {
    if(_p())
    {
      $base_site_id = Common::validSiteConfig();
      $offer_id = Common::queryInt(_p('id'));
      $base_name  = _p('base_name');
      $default_base_name = $base_name[$base_site_id];     
       if(!$default_base_name)
       {
         return $this->showMessage('default_site_required');
       }
       $start_time = _p('start_time') ? strtotime(_p('start_time')) : 0;
       $end_time   = _p('end_time') ? strtotime(_p('end_time')) : 0;
       if(!$start_time || !$end_time)
       {
         return $this->showMessage('please_select_time_tips');
       }
       else if($start_time > $end_time)
       {
         return $this->showMessage('start_time_over');
       }
       else if($start_time == $end_time)
       {
         return $this->showMessage('start_time_eq_end_time');
       }
       else if($end_time < SYS_TIME)
       {
         return $this->showMessage('end_time_less');
       }
       $status = Common::queryInt(_p('status'));
       $offer_data = array(
           'base_name'   => $default_base_name,
           'offer_type'  => 2,//商品优惠
           'is_spec'     => Common::queryInt(_p('is_spec')),
           'start_time'  => $start_time,
           'end_time'    => $end_time,
           'using_num'   => Common::queryInt(_p('using_num')),
           'days'        => Common::queryInt(_p('days')),
           'send_limit'  => Common::queryInt(_p('send_limit')),
           'prefix'      => _p('prefix'),
           'status'      => $status,
       );
       $activity_type = _p('coupon_obj');
       switch ($activity_type)
       {
           case 'cart' : 
             $offer_data['is_cart']     = 1;
             $offer_data['is_goods']    = 0;
             $offer_data['is_brand']    = 0;
             $offer_data['is_category'] = 0;
             break;
           case 'brand':
             $offer_data['is_cart']     = 0;
             $offer_data['is_goods']    = 0;
             $offer_data['is_brand']    = 1;
             $offer_data['is_category'] = 0;
             if(!_p('brand_id'))
             {
               return $this->showMessage('please_select_brand');
             }
             $offer_data['brand_id'] = Common::queryInt(_p('brand_id'));
             break;
           case 'category':
             $offer_data['is_cart']     = 0;
             $offer_data['is_goods']    = 0;
             $offer_data['is_brand']    = 0;
             $offer_data['is_category'] = 1;
             if(!_p('category_id'))
             {
               return $this->showMessage('please_select_category');
             }
             $offer_data['category_id'] = Common::queryInt(_p('category_id'));
             break;
           case 'goods':
             $offer_data['is_cart']     = 0;
             $offer_data['is_goods']    = 1;
             $offer_data['is_brand']    = 0;
             $offer_data['is_category'] = 0;
             break;
           default : break;
       }
       $offer_result = $this->offerLogic->save($offer_data, $offer_id);
       if($offer_result)
       {
         $detail    = Inputer::getOrgPost('detail');
         foreach ($base_name as $key => $name)
         {
           $lang_data = array(
             'offer_id' => $offer_id,
             'language_id' => $key,
             'base_name' => Common::strEscape($name),
             'detail' => Common::strEscape($detail[$key],false),
           );
           $this->offerLangLogic->updateByCond($lang_data);
           //清理缓存
           $this->offerLogic->delCache($key);
         }
         $is_gift   = Common::queryInt(_p('is_gift'));
         $rule_data = array(
           'offer_id'  => $offer_id,
           'free_ship' => Common::queryInt(_p('free_ship')),
           'is_gift'   => $is_gift,
           'status'    => $status, 
         );
         $buy_cond = Common::queryInt(_p('buy_cond'));
         switch ($buy_cond)
         {
            case 1:
              $rule_data['min_amount'] = _p('min_amount') ? _p('min_amount') : 0;
              $rule_data['min_buynum'] = 0;
              break;
            case 2:
              $rule_data['min_buynum'] = Common::queryInt(_p('min_buynum'));
              $rule_data['min_amount'] = 0;
              break;
            case 3:
              $rule_data['min_amount'] = 0;
              $rule_data['min_buynum'] = 0;
              break;
            default : break;
         }
         $offer_cond = Common::queryInt(_p('offer_cond'));
         switch ($offer_cond)
         {
            case 1:
              $rule_data['minus'] = _p('minus') ? _p('minus') : 0;
              $rule_data['discount'] = 0;
              $rule_data['free_ship'] = 0;
              break;
            case 2:
              $rule_data['discount'] = _p('discount') ? _p('discount') : 0;
              $rule_data['minus'] = 0;
              $rule_data['free_ship'] = 0;
			  break;
            case 3:
              $rule_data['free_ship'] = 1;
              $rule_data['discount'] = 0;
              $rule_data['minus'] = 0;
            default : break;
         }
         $rule        = $this->ruleLogic->getOneByOfferId($offer_id);
         $this->ruleLogic->save($rule_data, $rule['id']);
        
         //商品促销处理
         if($activity_type == 'goods')
         {
           $delete_item_cond = 'offer_id='. $offer_id;
           $this->itemLogic->delete($delete_item_cond);
           $participate_goods_ids = _p('goods_ids');
           foreach ($participate_goods_ids as $value)
           {
                $item_data = array(
                  'offer_id' => $offer_id,
                  'goods_id' => $value,
                );
                $this->itemLogic->save($item_data);
           }
         }
         return $this->success('edit_success', Common::adminURL('product', 'coupon', 'list'));
       }
       return $this->showMessage('edit_failure');
    }
    else
    {
      $offer_id = Common::queryInt(_g('id'));
      $offer = $this->offerLogic->getOneById($offer_id);
      if(!$offer)
      {
        return $this->showMessage('not_found_record');
      }
      $offer_rule = $this->ruleLogic->getOneByOfferId($offer_id);      
//      $offer_item_ids  = array();
//      $offer_item_name = ' ';
//      if($offer['is_goods'])
//      {
//        $itemJoinGoodsLogic = $this->load('itemJoinGoods');
//        $offer_item = $itemJoinGoodsLogic->getListByOfferId($offer_id);
//        foreach ($offer_item as $item)
//        {
//          $offer_item_ids[]  = $item['goods_id'];
//          $offer_item_name  .= $item['base_name'] . ' ';
//        }
//      }
      $offer_item      = array();
      $goodslist = array();
      if($offer['is_goods'])
      {
        $itemJoinGoodsLogic = $this->load('itemJoinGoods');
        $offer_item = $itemJoinGoodsLogic->getListByOfferId($offer_id);
        $offer_item_ids  = array();
        foreach ($offer_item as $item)
        {
          $offer_item_ids[]  = $item['goods_id'];
        }
        if(count($offer_item_ids) > 0)
        {
          $goods_ids_str= implode(',', $offer_item_ids);
          $goodslist = $this->load('goods')->findAll('id in(' . $goods_ids_str . ')');
        }       
      }
      $sites = $this->langLogic->findAll('status=1');
      $offer_rel_lang = $this->offerLangLogic->getListByOfferId($offer_id);
      $lang_arr = array();
      foreach ($sites as $item)
      {
        $lang_arr[$item['id']] = array(
            'id' => $item['id'],
            'base_name'      => $item['base_name'],
            'country_code_2' => $item['country_code_2'],
            'lang_name' => isset($offer_rel_lang[$item['id']]) ? $offer_rel_lang[$item['id']]['base_name'] : '',           
            'detail'    => isset($offer_rel_lang[$item['id']]) ? $offer_rel_lang[$item['id']]['detail'] : '',
        );
      }
      if($offer['is_brand'])
      {
         $brandLogic = $this->load('brand');
         $brandlist  = $brandLogic->findAll('status=1');
         Core::$tpl->set('brandlist', $brandlist);
      }
      else if($offer['is_category'])
      {
        $categoryLogic = $this->load('goodsCategory');
        $categorys   = array();
        foreach (Common::getTree($categoryLogic->findAll()) as $item)
        {
            $categorys[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
        }
        Core::$tpl->set('categorylist', $categorys);
      }
      Core::$tpl->set('offer', $offer);
      Core::$tpl->set('offer_rule', $offer_rule);
      Core::$tpl->set('goodslist', $goodslist);
      Core::$tpl->set('sites', $lang_arr);
      Core::$htmlFile  = 'coupon/form';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
  }
  public function actionList()
  {
    //分页用的参数
    $page_size = 20;
    $curr_page = Common::queryInt(_g('page'), 1);
    $prev      = Common::queryInt(_g('prev'));
    $next      = Common::queryInt(_g('next'));
    $cond      = 'offer_type=2 order by id desc';
    //分页
    $count     = $this->offerLogic->getCount($cond);
    $page_data = Common::getPages($count, $curr_page, $page_size, $prev, $next);
    $results   = $this->offerLogic->getCurrentDatas($cond, $page_size, $curr_page);
    foreach ($results as $key => $value) {
        $goods_num[$value['id']] = $this->itemLogic->getCount("offer_id = '{$value['id']}'");
    }
    Core::$tpl->set("goods_num", $goods_num);
    
    Core::$tpl->set("res", $results);
    Core::$tpl->set("pages", $page_data);
  }
  /**
   * 验证该种优惠是否可以用 
   */
  public function actionPublicIsValid()
  {
    $status = 1;
    $offer_id = Common::queryInt(_p('offer_id'));
    $offer    = $this->offerLogic->getOneById($offer_id);
    if(!$offer || $offer['offer_type'] !=2 || $offer['status'] == 0)
    {
      $status = 3;
    }
    else if($offer['end_time'] < time())
    {
      $status = 2;
    }
    echo $status;
  }

  /**
   * 下载优惠券
   */ 
  public function actionDownload()
  {
    $offer_id = Common::queryInt(_p('offer_id'));
    $num      = Common::queryInt(_p('num'));
    $offer    = $this->offerLogic->getOneById($offer_id);
    if(!$offer || $offer['offer_type'] !=2)
    {
      return $this->showMessage('illegal_parameters', Common::adminURL('product', 'Coupon', 'list'));
    }
    $send_limit = $offer['send_limit'];
    $send_num   = $offer['send_num'];
    //$limit      = $num < $offer['send_limit'] ? $num : $offer['send_limit'];
    if($offer['send_limit']==0)
    {
        $limit = $num;
    }
    else
    {
        $limit = $num + $offer['send_num'] < $offer['send_limit'] ? $num : $offer['send_limit'] - $offer['send_num'];
    }
    if(!$limit)
    {
      return $this->showMessage('nothig_download', Common::adminURL('product', 'Coupon', 'list'));
    }
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $filename = iconv("utf-8","GB2312//IGNORE",$offer['base_name']) .'_' .date('YmdHis').".csv";
    header('Pragma: public');
    header('Last-Modified: '.gmdate('D, d M Y H:i:s') . ' GMT');
    header('Cache-Control: no-store, no-cache, must-revalidate');
    header('Cache-Control: pre-check=0, post-check=0, max-age=0');
    header('Content-Transfer-Encoding: binary');
    header('Content-Encoding: none');
    header('Content-type: '.text/csv);//文件类型
    header('Content-Disposition: attachment; filename="'.$filename.'"');//文件名称
    ob_start();
    $resultStr  = iconv("utf-8","GB2312//IGNORE", $lang['coupon_name'] . ',' . $lang['coupon_time'] . ',' . $lang['coupon_code'] . "\n");   
    for($i=0; $i < $limit; $i++)
    {
      //优惠券编号构造
      $coupon_code     = strtoupper($offer['prefix'].date('ymdHis', time()).Common::random(3));
      $coupon_data = array(
          'offer_id'    => $offer_id,
          'coupon_code' => $coupon_code,
          'create_time' => SYS_TIME,
          'status'      => 1,        
      );
      $c_result = $this->couponLogic->save($coupon_data);
      if($c_result)
      {
        $resultStr .= iconv("utf-8","GB2312//IGNORE", $offer['base_name'] . ',' . date('Y-m-d', $offer['start_time']) .$lang['to']. date('Y-m-d', $offer['end_time']). ',' . $coupon_code . "\n");
        //$send_limit--; 
        $send_num++;
      }
    }
    $offer_data = array(
        //'send_limit' => $send_limit,
        'send_num'  => $send_num,
    );
    $this->offerLogic->save($offer_data, $offer_id);
    echo $resultStr;
  }
  public function actionDel()
  {
       $offer_id = Common::queryInt(_g('id'));
       $cond     = 'offer_id=' . $offer_id;
       $this->ruleLogic->delete($cond);
       $this->itemLogic->delete($cond);
       $this->offerLangLogic->delete($cond);
       $this->couponLogic->delete($cond);
	   $this->load('EventCoupon')->delete($cond);
       $res = $this->offerLogic->delete('id=' . $offer_id);
       return $res ? $this->success('delete_success', Common::adminURL('product', 'coupon', 'list')) : $this->showMessage('delete_failure', Common::adminURL('product', 'coupon', 'list'));   
  }
  
}

?>
