<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Freeship
 * 商品包邮
 * @author NT <QQ:415080528 www.35zh.com>
 */
class FreeshipController extends AppController {

    private $specialLogic;
    private $goodsLogic;
    private $catgoryLogic;
    private $brandLogic;
    private $skuLogic;
    private $goodsTagLogic;

    public function __construct() {
        parent::__construct();
        $this->specialLogic = $this->load('specialOffer');
        $this->goodsLogic = $this->load('goods');
        $this->brandLogic = $this->load('brand');
        $this->catgoryLogic = $this->load('goodsCategory');
        $this->skuLogic = $this->load('sku');
        $this->goodsTagLogic = $this->load('goodsTag');
    }

    /**
     * 商品包邮列表 
     */
    public function actionList() {

        //分页用的参数
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        //获取数据
        $where = '1=1 and g.is_free_shipping!=0';
        if (_g('search_value')) {
            $where .= " and ( g.codeno like '%" . _g('search_value') . "%' ";
            $search['search_value'] = _g('search_value');
            $where .= ' or g.base_name like "%' . _g('search_value') . '%")';
        }
        if (_g('status') != '-1' && _g('status') != NULL) {
            $where .= ' and g.status =' . _g('status');
        }
        if (_g('stock_nums') == 2) {
            $where .= ' and g.stock_nums <=0';
        } else if (_g('stock_nums') == 1) {
            $where .= ' and g.stock_nums >0';
        }
        if (_g('brand_id')) {
            $where .= ' and g.brand_id=' . _g('brand_id');
        }
        //分类和标签搜索
        $category_id = Common::queryInt(_g('category_id'));
        $tag_id = Common::queryInt(_g('goods_tag_id'));
        if ($category_id && $tag_id) {
            $search_cat = $this->catgoryLogic->getOneById($category_id);
            $where .= ' and c.category_path like "' . $search_cat['path_id'] . '%" and t.tag_id=' . $tag_id;
        } else if ($category_id) {
            $search_cat = $this->catgoryLogic->getOneById($category_id);
            $where .= ' and c.category_path like "' . $search_cat['path_id'] . '%"';
        } else if ($tag_id) {
            $where .= '  and t.tag_id=' . $tag_id;
        }
        if (_g('orderby')) {
            $where .= ' group by g.id order by g.' . _g('orderby') . ' desc';
        }
        $c_where = $where;
        if ($category_id && $tag_id) {
            $catJoinTagJoinGoodsLogic = $this->load('categoryRelJoinTagRelJoinGoods');
            $count = $catJoinTagJoinGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $catJoinTagJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else if ($category_id) {
            $catJoinGoodsLogic = $this->load('goodsCategoryRelJoinGoods');
            $count = $catJoinGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $catJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else if ($tag_id) {
            $tagJoinGoodsLogic = $this->load('goodsTagRelJoinGoods');
            $count = $tagJoinGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $tagJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else {
            $backGoodsLogic = $this->load('backGoods');
            $count = $backGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $backGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        }
        $goods_ids = array();
        $type_ids = array();
        foreach ($results as $value) {
            $goods_ids[] = $value['id'];
            $type_ids[$value['type_id']] = $value['type_id'];
        }
        $goods_tags = array();
        $rel_categories = array();
        if (!empty($goods_ids)) {
            $tag_cond = 'goods_id in (' . implode(',', $goods_ids) . ')';
            $goodsTagRelLogic = $this->load('goodsTagRel');
            $tags = $goodsTagRelLogic->findAll($tag_cond);
            foreach ($tags as $value) {
                $goods_tags[$value['goods_id']][$value['tag_id']] = $value['tag_id'];
            }

            $c_cond = 'g.goods_id in(' . implode(',', $goods_ids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
        $goods_types = array();
        if (count($type_ids)) {
            $goodsTypeLogic = $this->load('goodsType');
            $goods_types = $goodsTypeLogic->findAll('id in (' . implode(',', $type_ids) . ')', true);
        }
        $goodsTags = $this->goodsTagLogic->findAll('status=1 order by listorder desc', true);
        $allcate = $this->catgoryLogic->findAll('parent_id>=0', false, '', array('id', 'base_name'));
        $allcatejson = json_encode($allcate);
        $allcatejson = str_replace('\"', '', $allcatejson);
        $allcatejson = str_replace('\'', '', $allcatejson);
        Core::$tpl->set("allcatejson", $allcatejson);
        Core::$tpl->set("taglist", $goodsTags);
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("brands", $this->load('brand')->findAll('', true));

        Core::$tpl->set("res", $results);
        Core::$tpl->set("pages", $page_data);
    }

    /**
     * 设置商品包邮
     */
    public function actionAdd() {
        if (_p()) {
            $goods_ids = array();
            $type = _p('goods_promotion_type');
            switch ($type) {
                case 'category':
                    $data['category_id'] = Common::queryInt(_p('category_id'));
                    break;
                case 'goods':
                    $data['is_goods'] = 1;
                    $goods_ids = _p('goods_ids');
                    break;
                case 'brand':
                    $data['brand_id'] = Common::queryInt(_p('brand_id'));
                    break;
                default : break;
            }
            if (_p('is_free_shipping')) {
                $data['is_free_shipping'] = _p('is_free_shipping');
            }

            $goodsLogic = $this->load('goods');
            $rel_goods_ids = array();

            if ($data['category_id']) {
                $categoryRelLogic = $this->load('goodsCategoryRel');
                $category = $this->load('goodsCategory')->getOneById($data['category_id']);
                $cond = 'category_path like"' . $category['path_id'] . '%"';
                $count = $categoryRelLogic->getCount($cond);
                $offset = 0;
                $lim = 500;
                while ($offset < $count) {
                    $limit = ' limit ' . $offset . ',' . $lim;
                    $categries = $categoryRelLogic->findAll($cond . $limit);
                    foreach ($categries as $value) {
                        $rel_goods_ids[$value['goods_id']] = $value['goods_id'];
                    }
                    $offset += $lim;
                }
            } else if ($data['brand_id']) {
                $cond = 'brand_id=' . $data['brand_id'] . ' and status=1';
                $count = $goodsLogic->getCount($cond);
                $offset = 0;
                $lim = 500;
                while ($offset < $count) {
                    $limit = ' limit ' . $offset . ',' . $lim;
                    $goods = $goodsLogic->findAll($cond . $limit);
                    foreach ($goods as $value) {
                        $rel_goods_ids[$value['id']] = $value['id'];
                    }
                    $offset += $lim;
                }
            } else if ($data['is_goods']) {
                $rel_goods_ids = $goods_ids;
            }
            if ($data['is_free_shipping']) {
                $rel_shipping_logic = $this->load('specialOfferShippingRel');
                $shipping_ids = _p('shipping_ids');
                $shipping_map = Zhtx::createDataMap();
                foreach ($rel_goods_ids as $g) {
                    $rel_shipping_logic->delete('goods_id=' . $g);
                    foreach ($shipping_ids as $v) {
                        $shipping_map->addEntry('goods_id', $g, DB::INT);
                        $shipping_map->addEntry('shipping_id', $v, DB::INT);
                        $rel_shipping_logic->insert($shipping_map);
                    }
                }
            }
            $goods_map = Zhtx::createDataMap();
            $goods_map->addEntry('is_free_shipping', $data['is_free_shipping'] ? $data['is_free_shipping'] : 0, DB::INT);
            $where = 'id in (' . implode(',', $rel_goods_ids) . ')';
            $res = $goodsLogic->update($goods_map, $where);
            if ($res) {
                $this->clearGoodsCache();
                return $this->success('operation_success', Common::adminURL('product', 'freeship', 'list'));
            }
            return $this->showMessage('operation_failure');
        }
    }

    /**
     *  编辑商品包邮
     */
    public function actionEdit() {
        if (_p()) {
            $goods_id = Common::queryInt(_p('id'));
            $goods = $this->goodsLogic->getOneById($goods_id);
            if (!$goods) {
                return $this->showMessage('illegal_operation');
            }
            if (_p('is_free_shipping')) {
                $data['is_free_shipping'] = _p('is_free_shipping');
            } else {
                $data['is_free_shipping'] = 0;
            }
            if ($data['is_free_shipping']) {
                $goods_map = Zhtx::createDataMap();
                $goods_map->addEntry('is_free_shipping', $data['is_free_shipping'] ? $data['is_free_shipping'] : 0, DB::INT);
                $where = 'id=' . $goods_id;
                $goods_res = $this->goodsLogic->update($goods_map, $where);
                if ($goods_res) {
                    $rel_shipping_logic = $this->load('specialOfferShippingRel');
                    $rel_shipping_logic->delete('goods_id=' . $goods_id);
                    $shipping_ids = _p('shipping_ids');

                    $shipping_map = Zhtx::createDataMap();
                    foreach ($shipping_ids as $v) {
                        $shipping_map->addEntry('goods_id', $goods_id, DB::INT);
                        $shipping_map->addEntry('shipping_id', $v, DB::INT);
                        $rel_shipping_logic->insert($shipping_map);
                    }
                    $this->clearGoodsCache();
                    return $this->success('operation_success');
                }
            } else {
                $goods_map = Zhtx::createDataMap();
                $goods_map->addEntry('is_free_shipping', 0, DB::INT);
                $where = 'id=' . $goods_id;
                $this->goodsLogic->update($goods_map, $where);
                $this->clearGoodsCache();
                return $this->success('operation_success');
            }
            return $this->showMessage('operation_failure');
        } else {
            $goods_id = Common::queryInt(_g('id'));
            $goods = $this->goodsLogic->getOneById($goods_id);
            if (!$goods) {
                return $this->showMessage('illegal_operation');
            }
            $shippings = array();
            if ($goods['is_free_shipping']) {
                $SpecialShippingLogic = $this->load('specialOfferShippingRel');
                $rel_shippings = $SpecialShippingLogic->findAll('goods_id=' . $goods_id);
                $shipping_ids = array();
                foreach ($rel_shippings as $shipping) {
                    $shipping_ids[$shipping['shipping_id']] = $shipping['shipping_id'];
                }
                if (count($shipping_ids) > 0) {
                    $shippings = $this->load('shipping')->findAll('id in (' . implode(',', $shipping_ids) . ')');
                }
            }
            $shipping_area = $this->load('ShippingArea')->findAll('1=1', true);

            Core::$tpl->set('shipping_area', $shipping_area);
            Core::$tpl->set('goods', $goods);
            Core::$tpl->set('shippings', $shippings);
            Core::$tpl->set('goods_id', $goods_id);
            Core::$htmlFile = 'freeship/edit';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 删除商品包邮
     * @return type
     */
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $map = Zhtx::createDataMap();
                $map->addEntry('is_free_shipping', 0, DB::DECIMAL);
                $cond = 'id = ' . $id;
                $res = $this->goodsLogic->update($map, $cond);
                if ($res) {
                    $rel_shipping_logic = $this->load('specialOfferShippingRel');
                    $rel_shipping_logic->delete('goods_id=' . $id);
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    public function clearGoodsCache() {
        _crearCahce('goods_list');
        _crearCahce('goods_info');
    }

}

?>
