<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Offer
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class OfferController extends AppController
{
  private $offerLogic;
  private $langLogic;
  private $ruleLogic;
  private $giftLogic;
  private $itemLogic;
  private $offerLangLogic;
  public function __construct()
  {
    parent::__construct();
    $this->offerLogic = $this->load('offer');
    $this->langLogic  = $this->load('language');
    $this->ruleLogic  = $this->load('offerRule');
    $this->giftLogic  = $this->load('offerGift');
    $this->itemLogic  = $this->load('offerItem');
    $this->offerLangLogic  = $this->load('offerLanguage');
  }
  public function actionAdd()
  {
    if(_p())
    {
       $base_site_id = Common::validSiteConfig();
      $base_name  = _p('base_name');
      $default_base_name = $base_name[$base_site_id];       
       if(!$default_base_name)
       {
         return $this->showMessage('participate_sites_tips');
       }
       $start_time = _p('start_time') ? strtotime(_p('start_time')) : 0;
       $end_time   = _p('end_time') ? strtotime(_p('end_time')) : 0;
       if(!$start_time || !$end_time)
       {
         return $this->showMessage('please_select_time_tips');
       }
       else if($start_time > $end_time)
       {
         return $this->showMessage('start_time_over');
       }
       else if($start_time == $end_time)
       {
         return $this->showMessage('start_time_eq_end_time');
       }
       else if($end_time < SYS_TIME)
       {
         return $this->showMessage('end_time_less');
       }
       $status = Common::queryInt(_p('status'));
       $offer_data = array(
           'user_group_id' => Common::queryInt(_p('user_group_id')),
           'offer_type'  => 1,//商品优惠
           'is_spec'     => Common::queryInt(_p('is_spec')),
           'start_time'  => $start_time,
           'end_time'    => $end_time,
           'create_time' => SYS_TIME,
           'status'      => $status,
       );
	   $offer_data['base_name']  = $default_base_name;
       $activity_type = _p('activity_type');
       $free_shipping = 0;
       $goods_promotion_type = _p('goods_promotion_type');
       if($activity_type == 'cart')
       {
          $offer_data['is_cart'] = 1;
          $free_shipping = Common::queryInt(_p('free_ship'));
       }
       else if($activity_type == 'goods_promotion')
       {          
          switch ($goods_promotion_type)
          {
              case 'brand':
                $offer_data['is_brand'] = 1;
                if(!_p('brand_id'))
                {
                  return $this->showMessage('please_select_brand');
                }
                $offer_data['brand_id'] = Common::queryInt(_p('brand_id'));
                break;
              case 'category':
                $offer_data['is_category'] = 1;
                if(!_p('category_id'))
                {
                  return $this->showMessage('please_select_category');
                }
                $offer_data['category_id'] = Common::queryInt(_p('category_id'));
                break;
              case 'goods':
                $offer_data['is_goods'] = 1;break;
              default : break;
          }
       }
       else
       {
         return $this->showMessage('please_select_activity_type');
       }       
       $is_gift       = Common::queryInt(_p('is_gift'));      
       $offer_result = $this->offerLogic->save($offer_data);
       if($offer_result)
       {
         $detail    = Inputer::getOrgPost('detail');
         foreach ($base_name as $key => $name)
         {
           $lang_data = array(
             'offer_id' => $offer_result,
             'language_id' => $key,
             'base_name' => Common::strEscape($name),
             'detail' => Common::strEscape($detail[$key],false),
           );
           $this->offerLangLogic->save($lang_data);
           //清理缓存
           $this->offerLogic->delCache($key);
         }
         
         $rule_data = array(
           'offer_id'  => $offer_result,
           'free_ship' => $free_shipping,
           'is_gift'   => $is_gift,
           'status'    => $status, 
         );
         $buy_cond = Common::queryInt(_p('buy_cond'));
         switch ($buy_cond)
         {
            case 1:
              $rule_data['min_amount'] = _p('min_amount') ? _p('min_amount') : 0;
              break;
            case 2:
              $rule_data['min_buynum'] = Common::queryInt(_p('min_buynum'));
              break;
            case 3:
              $rule_data['min_amount'] = 0;
              $rule_data['min_buynum'] = 0;
              break;
            default : break;
         }
         $offer_cond = Common::queryInt(_p('offer_cond'));
         switch ($offer_cond)
         {
            case 1:
              $rule_data['minus'] = _p('minus') ? _p('minus') : 0;
              break;
            case 2:
              $rule_data['discount'] = _p('discount') ? _p('discount') : 0;          
            default : break;
         }
         $rule_result = $this->ruleLogic->save($rule_data);
         if($rule_result)
         {
           if($is_gift)
           {
             $price = _p('price');
             $num   = _p('num');
             $goods_ids = array_unique(_p('goodsId'));
             foreach ($goods_ids as $key => $goods_id)
             {
               $gift_data = array(
                   'offer_id' => $offer_result,
                   'rule_id'  => $rule_result,
                   'goods_id' => $goods_id,
                   'price'    => $price[$key] ? $price[$key] : 0,
                   'num'      => Common::queryInt($num[$key]),
               );
               $this->giftLogic->updateByCond($gift_data);
             }
           }
           
         }
         //商品促销处理
//         if($goods_promotion_type == 'goods')
//         {
//           $participate_goods_ids = _p('goods_ids');
//           foreach ($participate_goods_ids as $value)
//           {
//                $item_data = array(
//                  'offer_id' => $offer_result,
//                  'goods_id' => $value,
//                );
//                $this->itemLogic->save($item_data);
//           }
//         }
         return $this->success('add_success', Common::adminURL('product', 'offer', 'list'));
       }
       return $this->showMessage('add_failure');
    }
    else
    {
      $sites = $this->langLogic->findAll('status=1');
      $userGroups = $this->load('userGroup')->findAll('status=1 order by min_growth asc');
      Core::$tpl->set('userGroups', $userGroups);
      Core::$tpl->set('sites', $sites);
      Core::$htmlFile  = 'offer/form';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
  }
  public function actionEdit()
  {
    if(_p())
    {
      $offer_id = Common::queryInt(_p('id'));
      $base_site_id = Common::validSiteConfig();
      $base_name  = _p('base_name');
      $default_base_name = $base_name[$base_site_id];       
       if(!$default_base_name)
       {
         return $this->showMessage('participate_sites_tips');
       }
       $start_time = _p('start_time') ? strtotime(_p('start_time')) : 0;
       $end_time   = _p('end_time') ? strtotime(_p('end_time')) : 0;
       if(!$start_time || !$end_time)
       {
         return $this->showMessage('please_select_time_tips');
       }
       else if($start_time > $end_time)
       {
         return $this->showMessage('start_time_over');
       }
       else if($start_time == $end_time)
       {
         return $this->showMessage('start_time_eq_end_time');
       }
       else if($end_time < SYS_TIME)
       {
         return $this->showMessage('end_time_less');
       }
       $status = Common::queryInt(_p('status'));
       $offer_data = array(
           'user_group_id' => Common::queryInt(_p('user_group_id')),
           'offer_type'  => 1,//商品优惠
           'is_spec'     => Common::queryInt(_p('is_spec')),
           'start_time'  => $start_time,
           'end_time'    => $end_time,
           'create_time' => SYS_TIME,
           'status'      => $status,
       );       
       $free_shipping = 0;
       $activity_type = _p('activity_type');
       $goods_promotion_type = _p('goods_promotion_type');
	   $offer_data['base_name']  = $default_base_name;
       if($activity_type == 'cart')
       {
          $offer_data['is_cart']     = 1;
          $offer_data['is_goods']    = 0;
          $offer_data['is_brand']    = 0;
          $offer_data['is_category'] = 0;
          $free_shipping             = Common::queryInt(_p('free_ship'));
       }
       else if($activity_type == 'goods_promotion')
       {          
          switch ($goods_promotion_type)
          {
              case 'brand':
                $offer_data['is_cart']     = 0;
                $offer_data['is_goods']    = 0;
                $offer_data['is_brand']    = 1;
                $offer_data['is_category'] = 0;
                $offer_data['category_id'] = 0;
                if(!_p('brand_id'))
                {
                  return $this->showMessage('please_select_brand');
                }
                $offer_data['brand_id'] = Common::queryInt(_p('brand_id'));
                break;
              case 'category':
                $offer_data['is_cart']     = 0;
                $offer_data['is_goods']    = 0;
                $offer_data['is_brand']    = 0;
                $offer_data['is_category'] = 1;
                if(!_p('category_id'))
                {
                  return $this->showMessage('please_select_category');
                }
                $offer_data['category_id'] = Common::queryInt(_p('category_id'));
                break;
              case 'goods':
                $offer_data['is_cart']     = 0;
                $offer_data['is_goods']    = 1;
                $offer_data['is_brand']    = 0;
                $offer_data['is_category'] = 0;
                $offer_data['category_id'] = 0;
                break;
              default : break;
          }
       }
       else
       {
         return $this->showMessage('please_select_activity_type');
       }       
       $offer_result = $this->offerLogic->save($offer_data, $offer_id);
       if($offer_result)
       {
         $detail    = Inputer::getOrgPost('detail');
         foreach ($base_name as $key => $name)
         {
           $lang_data = array(
             'offer_id'    => $offer_id,
             'language_id' => $key,
             'base_name'   => Common::strEscape($name),
             'detail'      => Common::strEscape($detail[$key],false),
           );
           $this->offerLangLogic->updateByCond($lang_data);
           //删除促销缓存
           $this->offerLogic->delCache($key);
         }
         $is_gift   = Common::queryInt(_p('is_gift'));         
         $rule_data = array(
           'offer_id'  => $offer_id,
           'free_ship' => $free_shipping,
           'is_gift'   => $is_gift,
           'status'    => $status, 
         );
         $buy_cond = Common::queryInt(_p('buy_cond'));
         switch ($buy_cond)
         {
            case 1:
              $rule_data['min_amount'] = _p('min_amount') ? _p('min_amount') : 0;
              $rule_data['min_buynum'] = 0;
              break;
            case 2:
              $rule_data['min_buynum'] = Common::queryInt(_p('min_buynum'));
              $rule_data['min_amount'] = 0;
              break;
            case 3:
              $rule_data['min_amount'] = 0;
              $rule_data['min_buynum'] = 0;
              break;
            default : break;
         }
         $offer_cond = Common::queryInt(_p('offer_cond'));
         switch ($offer_cond)
         {
            case 1:
              $rule_data['minus'] = _p('minus') ? _p('minus') : 0;
              $rule_data['discount'] = 0;
              break;
            case 2:
              $rule_data['discount'] = _p('discount') ? _p('discount') : 0;
              $rule_data['minus'] = 0;
            default : break;
         }
         if(!$offer_cond)
         {
           $rule_data['discount'] = 0;
           $rule_data['minus'] = 0;
         }
         $rule        = $this->ruleLogic->getOneByOfferId($offer_id);
         $rule_result = $this->ruleLogic->save($rule_data, $rule['id']);
         if($rule_result)
         {          
           if($is_gift)
           {
             $delete_gift_cond = 'offer_id='.$offer_id . ' and rule_id=' . $rule['id'];
             $this->giftLogic->delete($delete_gift_cond);
             $price = _p('price');
             $num   = _p('num');
             $goods_ids = array_unique(_p('goodsId'));
             foreach ($goods_ids as $key => $goods_id)
             {
               $gift_data = array(
                   'offer_id' => $offer_id,
                   'rule_id'  => $rule['id'],
                   'goods_id' => $goods_id,
                   'price'    => $price[$key] ? $price[$key] : 0,
                   'num'      => Common::queryInt($num[$key]),
               );
               $this->giftLogic->updateByCond($gift_data);
             }
           }
         }
         //商品促销处理
         if($goods_promotion_type == 'goods')
         {
           $delete_item_cond = 'offer_id='. $offer_id;
           $this->itemLogic->delete($delete_item_cond);
           $participate_goods_ids = _p('goods_ids');
           foreach ($participate_goods_ids as $value)
           {
                $item_data = array(
                  'offer_id' => $offer_id,
                  'goods_id' => $value,
                );
                $this->itemLogic->save($item_data);
           }
         }
         else
         {
             $this->itemLogic->delete('offer_id='.$offer_id);
         }
         return $this->success('edit_success', Common::adminURL('product', 'offer', 'list'));
       }
       return $this->showMessage('edit_failure');
    }
    else
    {
      $offer_id = Common::queryInt(_g('id'));
      $offer = $this->offerLogic->getOneById($offer_id);
      if(!$offer)
      {
        return $this->showMessage('not_found_record');
      }
      $offer_rule = $this->ruleLogic->getOneByOfferId($offer_id);
      $offer_gift = array();
      if($offer_rule['is_gift'])
      {
        $giftJoinGoodsLogic = $this->load('giftJoinGoods');
        $offer_gift = $giftJoinGoodsLogic->getListByOfferId($offer_id, $offer_rule['id']);
      }
      $offer_item      = array();
      $goodslist = array();
      if($offer['is_goods'])
      {
        $itemJoinGoodsLogic = $this->load('itemJoinGoods');
        $offer_item = $itemJoinGoodsLogic->getListByOfferId($offer_id);
        $offer_item_ids  = array();
        foreach ($offer_item as $item)
        {
          $offer_item_ids[]  = $item['goods_id'];
        }
        if(count($offer_item_ids) > 0)
        {
          $goods_ids_str= implode(',', $offer_item_ids);
          $goodslist = $this->load('goods')->findAll('id in(' . $goods_ids_str . ')');
        }       
      }
      $sites = $this->langLogic->findAll('status=1');
      $offer_rel_lang = $this->offerLangLogic->getListByOfferId($offer_id);
      $lang_arr = array();
      foreach ($sites as $item)
      {
        $lang_arr[$item['id']] = array(
            'id' => $item['id'],
            'base_name'      => $item['base_name'],
            'country_code_2' => $item['country_code_2'],
            'lang_name' => isset($offer_rel_lang[$item['id']]) ? $offer_rel_lang[$item['id']]['base_name'] : '',           
            'detail'    => isset($offer_rel_lang[$item['id']]) ? $offer_rel_lang[$item['id']]['detail'] : '',
        );
      }
      if($offer['is_brand'])
      {
         $brandLogic = $this->load('brand');
         $brandlist  = $brandLogic->findAll('status=1');
         Core::$tpl->set('brandlist', $brandlist);
      }
      else if($offer['is_category'])
      {
        $categoryLogic = $this->load('goodsCategory');
        $categorys   = array();
        foreach (Common::getTree($categoryLogic->findAll()) as $item)
        {
            $categorys[$item['id']] = str_repeat('　', $item['level']) . $item['base_name'];
        }
        Core::$tpl->set('categorylist', $categorys);
      }
      $userGroups = $this->load('userGroup')->findAll('status=1 order by min_growth asc');
      Core::$tpl->set('offer', $offer);
      Core::$tpl->set('userGroups', $userGroups);
      Core::$tpl->set('offer_rule', $offer_rule);
      Core::$tpl->set('offer_gift', $offer_gift);
      Core::$tpl->set('goodslist', $goodslist);
      Core::$tpl->set('sites', $lang_arr);
      Core::$htmlFile  = 'offer/form';
      Core::$isdisplay = 0;
      Core::$tpl->render(Core::$htmlFile . '.htm');
    }
  }
  public function actionList()
  {
    //分页用的参数
    $page_size = 20;
    $curr_page = Common::queryInt(_g('page'), 1);
    $prev      = Common::queryInt(_g('prev'));
    $next      = Common::queryInt(_g('next'));
    $cond      = 'offer_type=1 order by id desc';
    //分页
    $count     = $this->offerLogic->getCount($cond);
    $page_data = Common::getPages($count, $curr_page, $page_size, $prev, $next);
    $results   = $this->offerLogic->getCurrentDatas($cond, $page_size, $curr_page);
    foreach ($results as $key => $value) {
        $goods_num[$value['id']] = $this->itemLogic->getCount("offer_id = '{$value['id']}'");
    }
    Core::$tpl->set("goods_num", $goods_num);
    Core::$tpl->set("res", $results);
    Core::$tpl->set("pages", $page_data);
  }
  public function actionDelgoods() {
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $ids = _p('ids');
    
    $offerid = (int)_g('offerid');
    $staus = 0;
    $flag = $lang['illegal_operation'];
    if (!empty($ids)) {
        $num = 0;
        foreach ($ids as $id) {
            $res = $this->itemLogic->delete(" offer_id = '{$offerid}' and goods_id = '{$id}'");
            if ($res) {
                $num++;
            }
        }
        $staus = 1;
        $flag = $lang['success_delete'] . $num . $lang['num_records'];
    }
    echo json_encode(array('status' => $staus, 'msg' => $flag));
}
  public function actionGoodsList() {
        //分页用的参数
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        $offerid = Common::queryInt(_g('offerid'), 1);
        $ogids = $this->itemLogic->findAll('offer_id=' . $offerid);
       
        foreach ($ogids as $key => $value) {
            $gids[] = $value['goods_id'];
        }
        //获取数据
        if($gids)
            $where = ' id in (' . implode(",", $gids) . ') ';
        else
            $where = ' id in (0)';
        $goodsLogic = $this->load('goods');
        $count = $goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results = $goodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        Common::sort_rows($results,"listorder",SORT_DESC);
        Core::$tpl->set("res", $results);
        Core::$tpl->set("pages", $page_data);
    }
  
    public function actionAddGoods() {
        $goodsids = explode(",", _p('goods_ids'));
        $offerid = _p('offerid');
        $res = $this->itemLogic->findAll("offer_id='{$offerid}'", true);
        foreach ($res as $key => $value) {
            $ids[] = $value['goods_id'];
        }
        foreach ($goodsids as $key => $value) {
            if (!in_array($value, $ids)) {
                $data = array(
                    'offer_id' => $offerid,
                    'goods_id' => $value,
                );
                $this->itemLogic->saveByCond($data);
            }
        }
    }
   public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res    = $this->offerLogic->updateById($map, $id);
        if($res)
        {
          $coupon_map    = Zhtx::createDataMap();
          $coupon_map->addEntry('status', $status, DB::INT);
          $cond = 'offer_id='.$id.' and using_time=0';
          $this->load('coupon')->update($coupon_map, $cond);
          foreach ($this->langLogic->findAll('status=1') as $item )
          {
            //删除促销缓存
            $this->offerLogic->delCache($item['id']);
          }
        }
        echo $res ? 1 : 0;
    }
    public function actionDel()
    {
       $offer_id = Common::queryInt(_g('id'));
       $cond     = 'offer_id=' . $offer_id;
       $this->giftLogic->delete($cond);
       $this->ruleLogic->delete($cond);
       $this->itemLogic->delete($cond);
       $this->offerLangLogic->delete($cond);
       $res = $this->offerLogic->delete('id=' . $offer_id);
       return $res ? $this->success('delete_success', Common::adminURL('product', 'offer', 'list')) : $this->showMessage('delete_failure', Common::adminURL('product', 'offer', 'list'));
    }
   
}

?>
