<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of coupon
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class PicklistController extends AppController {

    private $langLogic;
    private $goodsLogic;
    private $goodsPackageSaleLogic;
    private $goodsPackageSaleGoodsRelLogic;
    private $goodsPackageSaleLanguageLogic;

    public function __construct() {
        parent::__construct();
        $this->langLogic = $this->load('language');
        $this->goodsLogic = $this->load('goods');
        $this->goodsPackageSaleLogic = $this->load('goodsPackageSale');
        $this->goodsPackageSaleGoodsRelLogic = $this->load('goodsPackageSaleGoodsRel');
        $this->goodsPackageSaleLanguageLogic = $this->load('goodsPackageSaleLanguage');
    }

    public function actionAdd() {
        if (_p()) {

            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
           // if (!$base_name) {
             //   return $this->showMessage('required_item');
          //  }
            if(!Common::queryInt(_p('goods_id'))){
                return $this->showMessage('required_item');
            }
            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'goods_id' => Common::queryInt(_p('goods_id')),
                'create_time' => SYS_TIME,
                'start_time' => strtotime(_p('start_time')),
                'end_time' => strtotime(_p('end_time')),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
            );
            $res = $this->goodsPackageSaleLogic->saveByCond($data);
            if ($res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
					if(!_p('base_name' . $key))
					{
						$lang_base_name = "Package - " . $res;	
					}
					else
					{
						$lang_base_name = _p('base_name' . $key);		
					}
                    $lang_data = array(
                        'language_id' => $key,
                        'package_sale_id' => $res,
                        'base_name' => Common::strEscape($lang_base_name),
                        'status' => Common::queryInt(_p('status' . $key)),
                    );
                    $this->goodsPackageSaleLanguageLogic->saveByCond($lang_data);
                }
				if(!$base_name)
				{
					 $base_data = array(
                        'base_name' => "Package - " . $res,
                    );
                    $this->goodsPackageSaleLogic->saveByCond($base_data," id = '{$res}'");
				}
                return $this->success('add_success', Common::adminURL('product', 'picklist', 'List'));
            }
            return $this->error('add_failure', Common::adminURL('product', 'picklist', 'List'));
        } else {
            $languages = $this->load('language')->findAll('status=1');
            Core::$tpl->set('tags', $tags);
            Core::$tpl->set('languages', $languages);
            Core::$htmlFile = 'picklist/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
    
    public function actionEdit() {
        if (_p()) {
            $id = _p('id');
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
              //  return $this->showMessage('required_item');
            }
            if(!Common::queryInt(_p('goods_id'))){
                return $this->showMessage('required_item');
            }
            $listorder = Common::queryInt(_p('listorder'));
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'goods_id' => Common::queryInt(_p('goods_id')),
                'status' => Common::queryInt(_p('status')),
                'listorder' => $listorder,
            );
            if(_p('start_time'))$data['start_time'] = strtotime(_p('start_time'));
            if(_p('end_time'))$data['end_time'] = strtotime(_p('end_time'));
            $res = $this->goodsPackageSaleLogic->saveByCond($data,"id = '{$id}'");
            if ($res) {
                $languages = $this->load('language')->findAll('status=1', true);
                foreach ($languages as $key => $value) {
					if(!_p('base_name' . $key))
					{
						$lang_base_name = "Package - " . $id;	
					}
					else
					{
						$lang_base_name = _p('base_name' . $key);		
					}
                    $lang_data = array(
                        'base_name' => Common::strEscape($lang_base_name),
                        'status' => Common::queryInt(_p('status' . $key)),
                    );
                    $this->goodsPackageSaleLanguageLogic->saveByCond($lang_data," language_id = '{$key}' and package_sale_id = '{$id}'");
                }
                
				if(!$base_name)
				{
					 $base_data = array(
                        'base_name' => "Package - " . $id,
                    );
                    $this->goodsPackageSaleLogic->saveByCond($base_data," id = '{$id}'");
				}
				
                $res = $this->goodsPackageSaleGoodsRelLogic->findAll("package_sale_id='{$id}'", true);
                foreach ($res as $key => $value) {
                    $ids[] = $value['goods_id'];
                }
                $fgoodsid = Common::queryInt(_p('goods_id'));
//                print_r($fgoodsid);
//                print_r($ids);
//                exit;
                if (in_array($fgoodsid, $ids)){
                    $res = $this->goodsPackageSaleGoodsRelLogic->delete(" package_sale_id = '{$id}' and goods_id = '{$fgoodsid}'");
                }
                
                return $this->success('edit_success', Common::adminURL('product', 'picklist', 'List'));
            }
            return $this->error('edit_failure', Common::adminURL('admin', 'picklist', 'List'));
        } else {
            $id = Common::queryInt(_g('id'));
            $package = $this->goodsPackageSaleLogic->getOneById($id);
            if (!$package) {
                return $this->showMessage('illegal_operation');
            }
            $fgoods = $this->load('goods')->getOneById($package['goods_id']);
            $languages = $this->load('language')->findAll('status=1');
            
            $lang = $this->goodsPackageSaleLanguageLogic->findAll("package_sale_id = '{$id}'");
            foreach ($lang as $value) {
                $lang_data[$value['language_id']] = $value;
            }
            Core::$tpl->set('fgoods', $fgoods);
            Core::$tpl->set('picklist', $package);
            Core::$tpl->set('languages', $languages);
            Core::$tpl->set('lang_data', $lang_data);
            Core::$htmlFile = 'picklist/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionList() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        //分页
        $where = '1=1';
		if(_g('base_name'))
		{
			$where = $where . " and base_name like '%"._g('base_name')."%'"	 ;
		}
        $where .= " ORDER BY id DESC";
        $count = $this->goodsPackageSaleLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->goodsPackageSaleLogic->getCurrentDatas($where, $page_size, $curr_page);
        foreach ($res as $value) {
            $goods_num[$value['id']] = $this->goodsPackageSaleGoodsRelLogic->getCount("package_sale_id = '{$value['id']}'");
        }
        foreach ($res as $key => $value) {
            $res[$key]['goods'] = $this->goodsLogic->getOne("id = {$value['goods_id']}");
        }
        Core::$tpl->set("res", $res);
        Core::$tpl->set("goods_num", $goods_num);
        Core::$tpl->set("pages", $page_data);
    }

    public function actionAddGoods() {
        $goodsids = explode(",", _p('goods_ids'));
        $packagesaleid = _p('package_sale_id');
        $fid = $this->goodsPackageSaleLogic->getOne("id = '{$packagesaleid}'");
        $res = $this->goodsPackageSaleGoodsRelLogic->findAll("package_sale_id='{$packagesaleid}'", true);
        foreach ($res as $key => $value) {
            $ids[] = $value['goods_id'];
        }
        foreach ($goodsids as $key => $value) {
            if (!in_array($value, $ids) && $fid['goods_id'] != $value) {
                $data = array(
                    'package_sale_id' => $packagesaleid,
                    'goods_id' => $value,
                    'discount' => '10',
                    'listorder' => '100',
                );
                $this->goodsPackageSaleGoodsRelLogic->saveByCond($data);
            }
        }
    }

    /**
     * 
     * 获取商品列表
     *  
     */
    public function actionGoodsList() {
        //分页用的参数
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        $package_sale_id = Common::queryInt(_g('package_sale_id'), 1);
        $pgids = $this->goodsPackageSaleGoodsRelLogic->findAll('package_sale_id=' . $package_sale_id . ' order by listorder DESC');
        foreach ($pgids as $key => $value) {
            $gids[] = $value['goods_id'];
            $discount[$value['goods_id']] = $value['discount'];
            $listorder[$value['goods_id']] = $value['listorder'];
        }
        //获取数据
        if($pgids)
            $where = ' id in (' . implode(",", $gids) . ') ';
        else
            $where = ' id in (0)';
        $goodsLogic = $this->load('goods');
        $count = $goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results = $goodsLogic->getCurrentDatas($where, $page_size, $curr_page);
		foreach($results as $key => $value)
		{
			$results[$key]['listorder'] = 	$listorder[$value['id']] ;
		}
		Common::sort_rows($results,"listorder",SORT_DESC);
        Core::$tpl->set("listorder", $listorder);
        Core::$tpl->set("discount", $discount);
        Core::$tpl->set("res", $results);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('package_sale_id', $package_sale_id);
    }
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->goodsPackageSaleLogic->delete(" id = '{$id}'");
                $this->goodsPackageSaleGoodsRelLogic->delete(" package_sale_id = '{$id}'");
                $this->goodsPackageSaleLanguageLogic->delete(" package_sale_id = '{$id}'");
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    public function actionDelgoods() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $package_sale_id = (int)_g('package_sale_id');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->goodsPackageSaleGoodsRelLogic->delete(" package_sale_id = '{$package_sale_id}' and goods_id = '{$id}'");
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    public function actionPublicEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $data['status'] = $status;
        $cond = 'id =' . $id;
        $res = $this->goodsPackageSaleLogic->saveByCond($data, $cond);
        if($res)
        {
            $cond = 'package_sale_id =' . $id;
            $this->goodsPackageSaleLanguageLogic->saveByCond($data, $cond);
        }
        echo $res ? 1 : 0;
    }
    public function actionPublicEditDiscount() {
        $goodsid = Common::queryInt(_p('id'));
        $package_sale_id = Common::queryInt(_p('package_sale_id'));
        $data['discount'] = _p('discount');
        $res = $this->goodsPackageSaleGoodsRelLogic->saveByCond($data, " package_sale_id = '{$package_sale_id}' and goods_id = '{$goodsid}'");
        if ($res){
            
            echo 1;
        }else{
            echo 0;
        }
    }
    
    
    public function actionPublicEditListorder() {
        $goodsid = Common::queryInt(_p('id'));
        $package_sale_id = Common::queryInt(_p('package_sale_id'));
        $data['listorder'] = _p('listorder');
        $res = $this->goodsPackageSaleGoodsRelLogic->saveByCond($data, " package_sale_id = '{$package_sale_id}' and goods_id = '{$goodsid}'");
        if ($res){
            
            echo 1;
        }else{
            echo 0;
        }
    }
    
    
}

?>
