<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Product
 *
 * @author xrx
 */
class ProductController extends AppController {

    private $goodsLogic;
    private $productLogic;
    private $goodsTypeLogic;
    private $catgoryLogic;
    private $brandLogic;
    private $goodsTagLogic;
    private $langLogic;
    private $goodsTypePropertyLogic;
    private $propertyLogic;
    private $goodsCatRelLogic;
    private $goodsTagRelLogic;
    private $goodsProRelLogic;
    private $skuLogic;
    private $goodsBrandTypeLogic;
    private $goodsLangLogic;
    private $skuJoinProductLogic;
    private $goodsSelfRelLogic;
    private $productImageLogic;
    private $goodsCatRelCatLogic;
    private $topicTagGoodsRelLogic;
    private $channelTagGoodsRelLogic;
    private $goodsPackageSaleGoodsRelLogic;

    public function __construct() {
        parent::__construct();
        $this->goodsLogic = $this->load('goods');
        $this->productLogic = $this->load('product');
        $this->goodsTypeLogic = $this->load('goodsType');
        $this->catgoryLogic = $this->load('goodsCategory');
        $this->brandLogic = $this->load('brand');
        $this->goodsTagLogic = $this->load('goodsTag');
        $this->langLogic = $this->load('language');
        $this->goodsTypePropertyLogic = $this->load('goodsTypeProperty');
        $this->propertyLogic = $this->load('property');
        $this->goodsCatRelLogic = $this->load('goodsCategoryRel');
        $this->goodsTagRelLogic = $this->load('goodsTagRel');
        $this->goodsProRelLogic = $this->load('goodsPropertyRel');
        $this->skuLogic = $this->load('sku');
        $this->goodsBrandTypeLogic = $this->load('goodsJoinBrandType');
        $this->goodsLangLogic = $this->load('goodsLanguage');
        $this->skuJoinProductLogic = $this->load('skuJoinProduct');
        $this->goodsSelfRelLogic = $this->load('goodsSelfRel');
        $this->productImageLogic = $this->load('ProductOtherImage');
        $this->goodsCatRelCatLogic = $this->load('goodsCategoryRelCategory');
        $this->topicTagGoodsRelLogic = $this->load('topicTagGoodsRel');
        $this->channelTagGoodsRelLogic = $this->load('channelTagGoodsRel');
        $this->goodsPackageSaleGoodsRelLogic = $this->load('goodsPackageSaleGoodsRel');
    }

    /**
     * 添加商品第二步 
     */
    public function actionStep2() {
        if (_p()) {
            $base_site = Common::validSiteConfig();
            $on_sale = _p('goods_status') ? _p('goods_status') : 0;
            $base_name = _p('base_name');
            $codeno = _p('codeno');
            $category_ids = _p('category_id');
            $goods_price = _p('price');
            $goods_weight = _p('weight');
            $goods_old_price = _p('old_price');
            $goods_cost_price = _p('cost_price');
            $goods_market_price = _p('market_price');
            $goods_visit_counts = _p('visit_counts');
            $goods_buy_counts = _p('buy_counts');
            $goods_wishlist_counts = _p('wishlist_counts');
            $goods_base_name = $base_name[$base_site];
            if (!$goods_base_name) {
                return $this->showMessage('name_not_empty');
            }
            if (!isset($category_ids[0]) || !$category_ids[0]) {
                return $this->showMessage('please_select_category');
            }
            if (!$codeno) {
                //return $this->showMessage('codeno_not_empty');
            }
            if ($codeno) {
                $cond = "codeno='" . $codeno . "'";
                $goods_count = $this->goodsLogic->getCount($cond);
                if ($goods_count > 0) {
                    return $this->showMessage('codeno_already_exists');
                }
            }
            $goods_type_id = _s('current_goods_type_id');
            $goods_data = array(
                'base_name' => Common::strEscape($goods_base_name),
                'codeno' => $codeno,
                'brand_id' => Common::queryInt(_s('current_brand_id'), 0),
                'goods_type_id' => $goods_type_id,
                'create_time' => SYS_TIME,
            );
            $goods_result = $this->goodsLogic->save($goods_data);
            if ($goods_result) {
                //自动设置商品编号为ID
                if (!$codeno) {
                    $codeno = $goods_result;
                    $goods_update_data = array(
                        'codeno' => $codeno,
                    );
                    $this->goodsLogic->save($goods_update_data, $goods_result);
                }
                //关联分类
                $cat_where = 'id in(' . implode(',', $category_ids) . ')';
                $categorylist = $this->catgoryLogic->getList($cat_where);
                foreach ($categorylist['list'] as $cat) {
                    $goods_cat_arr = array(
                        'goods_id' => $goods_result,
                        'goods_category_id' => $cat['id'],
                        'category_path' => $cat['path_id'],
                    );
                    $this->goodsCatRelLogic->save($goods_cat_arr);
                }
                //多语言
                $detail = Inputer::getOrgPost('detail');
                $title = _p('title');
                $keyword = _p('keywords');
                $descript = _p('descript');
                $template_page = _p('template_page');
                foreach ($base_name as $key => $val) {
                    $lang_data = array(
                        'goods_id' => $goods_result,
                        'language_id' => $key,
                        'base_name' => Common::strEscape($val),
                        'detail' => Common::strEscape($detail[$key], FALSE),
                        'title' => Common::strEscape($title[$key]),
                        'keywords' => Common::strEscape($keyword[$key]),
                        'descript' => Common::strEscape($descript[$key]),
                        'template_page' => Common::strEscape($template_page[$key]),
                        'status' => Common::queryInt(_p('is_display-' . $key)),
                        'category_path' => $categorylist['list'][0]['path_id'],
                        'search_keyword' => Common::strEscape($val) . ' ' . $codeno,
                    );
                    $this->goodsLangLogic->save($lang_data);
                }
                //关联标签
                $tag_ids = _p('goods_tag_id');
                if ($tag_ids) {
                    foreach ($tag_ids as $tag) {
                        $tag_map = Zhtx::createDataMap();
                        $tag_map->addEntry('goods_id', $goods_result, DB::INT);
                        $tag_map->addEntry('tag_id', $tag, DB::INT);
                        $this->goodsTagRelLogic->insert($tag_map);
                    }
                }
                //普通属性收集
                $common_property_ids = _p('common_property');
                $master_property_id = _p('master_property_id');
                $sale_property_id = _p('sale_property_id');
                $main_property = array();
                //单品和sku处理            
                $skulist = _p('sku');
                $has_product = array();
                $up_status = false;
                $total_price = array();
                $total_old_price = array();
                $total_cost_price = array();
                $total_market_price = array();
                $total_weight = array();
                $product_con = array();
                $property_ids = array();
                $total_stock = 0;
                if ($master_property_id)
                    $property_ids[] = $master_property_id;
                if ($sale_property_id)
                    $property_ids[] = $sale_property_id;
                foreach ($skulist as $key => $value) {
                    $stock = Common::queryInt($value['stock']);
                    $price = $value['sale_price'] ? $value['sale_price'] : 0;
                    $old_price = $value['old_price'] ? $value['old_price'] : 0;
                    $cost_price = $value['cost_price'] ? $value['cost_price'] : 0;
                    $market_price = $value['market_price'] ? $value['market_price'] : 0;
                    $weight = $value['weight'] ? $value['weight'] : 0;
                    $status = Common::queryInt($value['status']);
                    $pro_array = explode('_', $key);
                    $product_id = 0;
                    if ($pro_array[0]) {
                        $main_property[$master_property_id][] = $pro_array[0];
                        $property_ids[] = $pro_array[0];
                    }
                    if ($pro_array[1]) {
                        $main_property[$sale_property_id][] = $pro_array[1];
                        $property_ids[] = $pro_array[1];
                    }
                    if (isset($has_product[$pro_array[0]])) {
                        $product_id = $has_product[$pro_array[0]];
                        $has_product[$pro_array[1]] = $product_id;
                    } else {
                        $product_data = array(
                            'goods_id' => $goods_result,
                            'base_name' => Common::strEscape($base_name[$base_site]),
                            'property_id' => $pro_array[0],
                            'status' => 1,
                        );
                        $product_id = $this->productLogic->save($product_data);
                        $has_product[$pro_array[0]] = $product_id;
                        $has_product[$pro_array[1]] = $product_id;
                        $product_con[$product_id] = array(
                            'total_price' => array(),
                            'total_cost_price' => array(),
                            'total_market_price' => array(),
                            'total_weight' => array(),
                            'total_stock' => 0,
                            'status' => 0,
                        );
                    }
                    //sku
                    if ($product_id) {
                        $total_price[] = $price;
                        $total_old_price[] = $old_price;
                        $total_cost_price[] = $cost_price;
                        $total_market_price[] = $market_price;
                        $total_weight[] = $weight;
                        $total_stock += $stock;
                        $product_con[$product_id]['total_price'][] = $price;
                        $product_con[$product_id]['total_cost_price'][] = $cost_price;
                        $product_con[$product_id]['total_market_price'][] = $market_price;
                        $product_con[$product_id]['total_weight'][] = $weight;
                        $product_con[$product_id]['total_stock'] += $stock;
                        if ($status) {
                            $up_status = true;
                            $product_con[$product_id]['status'] = $status;
                        }
                        $sku_data = array(
                            'goods_id' => $goods_result,
                            'product_id' => $product_id,
                            'sku_code' => $key,
                            'codeno' => Common::queryStr($value['codeno']),
                            'stock_nums' => $stock,
                            'price' => $price,
                            'cost_price' => $cost_price,
                            //'market_price' => Common::getMarketPrice($price, $market_price),
                            'market_price' => $market_price,
                            'weight' => $weight,
                            'status' => 1,
                            'create_time' => SYS_TIME,
                        );
                        $this->skuLogic->save($sku_data);
                    }
                }
                //图片存放
                $imagelist = _p('image');
                ksort($imagelist);
                foreach ($imagelist as $key => $imgs) {
                    $current_product_id = $key != 0 && isset($has_product[$key]) ? $has_product[$key] : 0;
                    $product_con[$current_product_id]['image'] = substr($imgs[1], 7);
                    foreach ($imgs as $order => $value) {
                        $img_data = array(
                            'goods_id' => $goods_result,
                            'product_id' => $current_product_id,
                            'image' => Common::strEscape(substr($value, 7)),
                            'listorder' => $order,
                        );
                        $this->productImageLogic->save($img_data);
                    }
                }
                //radio属性收集      
                foreach (_p() as $pkey => $pv) {
                    if (strpos($pkey, 'common_property-') !== FALSE) {
                        $split = explode('-', $pkey);
                        $common_property_ids[$split[1]] = array($pv);
                    }
                    //文本属性收集  
                    if (strpos($pkey, 'common_text_property-') !== FALSE) {
                        $split = explode('-', $pkey);
                        //判断是否有该属性
                        $property_info = $this->load('property')->findAll('parent_id=' . $split[1]);
                        $property_base_name_arr = array();
                        if ($property_info) {
                            foreach ($property_info as $key => $value) {
                                if ($value['base_name'] == $pv) {
                                    $pvid = $value['id'];
                                }
                                $property_base_name_arr[] = $value['base_name'];
                                $property_type = $value['type'];
                                $property_parent_id = $value['parent_id'];
                            }
                        } else {
                            $property_info = $this->load('property')->getOne('id=' . $split[1]);
                            $property_type = $property_info['type'];
                            $property_parent_id = $property_info['id'];
                        }
                        if (!in_array($pv, $property_base_name_arr) && $pv != '') {
                            $map = Zhtx::createDataMap();
                            $map->addEntry('base_name', Common::strEscape($pv), DB::VARCHAR);
                            $map->addEntry('value_type', 3, DB::INT);
                            $map->addEntry('type', $property_type, DB::INT);
                            $map->addEntry('parent_id', $property_parent_id, DB::INT);
                            $map->addEntry('required', 1, DB::INT);
                            $map->addEntry('search', 1, DB::INT);
                            $map->addEntry('alias_name', Common::strEscape($pv), DB::VARCHAR);
                            $map->addEntry('create_time', SYS_TIME, DB::INT);
                            $result = $this->propertyLogic->insert($map);
                            if ($result) {
                                $pvid = $result;
                                $map = Zhtx::createDataMap();
                                $map->addEntry('listorder', 10 * $result, DB::INT);
                                $this->propertyLogic->update($map, 'id=' . $result);
                                //如果主表信息更新成功,则更新附表信息 
                                $languages = $this->langLogic->findALL('status=1', true);
                                foreach ($languages as $item) {
                                    $propertyLanguage = Zhtx::createDataMap();
                                    $propertyLanguage->addEntry('property_id', $result, DB::INT);
                                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                                    $propertyLanguage->addEntry('base_name', Common::strEscape($pv), DB::VARCHAR);
                                    $this->load('propertyLanguage')->insert($propertyLanguage);
                                }
                            }
                        }
                        if ($pv) {
                            $common_property_ids[$split[1]] = array($pvid);
                        }
                    }
                }
                //属性存放
                //普通属性收集
                foreach ($common_property_ids as $ckey => $com) {
                    $property_ids[] = $ckey;
                    if (is_array($com)) {
                        foreach ($com as $c) {
                            $property_ids[] = $c;
                        }
                    } else {
                        $property_ids[] = $com;
                    }
                }
                $all_property_ids = array_filter(array_unique($property_ids));
                if (!$all_property_ids) {
                    $all_property_ids = array(0);
                }
                $where = 'id in (' . implode(',', $all_property_ids) . ')';
                $propertyArrayAsId = $this->propertyLogic->findAll($where, true);
                //普通属性存放
                foreach ($common_property_ids as $ckey => $item) {
                    $parent_property = $propertyArrayAsId[$ckey];
                    if (is_array($item)) {
                        foreach ($item as $val) {
                            $com_pro_map = Zhtx::createDataMap();
                            $com_pro_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
                            $com_pro_map->addEntry('goods_id', $goods_result, DB::INT);
                            $com_pro_map->addEntry('property_id', $ckey, DB::INT);
                            $com_pro_map->addEntry('property_name', Common::strEscape($parent_property['base_name']), DB::VARCHAR);
                            $com_pro_map->addEntry('vid', $val, DB::INT);
                            $com_pro_map->addEntry('value_name', Common::strEscape($propertyArrayAsId[$val]['base_name']), DB::VARCHAR);
                            $this->goodsProRelLogic->insert($com_pro_map);
                        }
                    }
                }
                //销售属性存放
                foreach ($main_property as $mkey => $item) {
                    if (is_array($item)) {
                        $parent_property = $propertyArrayAsId[$mkey];
                        foreach ($item as $val) {
                            $current_product_id = isset($has_product[$val]) ? $has_product[$val] : $has_product[0];
                            $com_pro_map = Zhtx::createDataMap();
                            $com_pro_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
                            $com_pro_map->addEntry('goods_id', $goods_result, DB::INT);
                            $com_pro_map->addEntry('product_id', $current_product_id, DB::INT);
                            $com_pro_map->addEntry('property_id', $mkey, DB::INT);
                            $com_pro_map->addEntry('property_name', Common::strEscape($parent_property['base_name']), DB::VARCHAR);
                            $com_pro_map->addEntry('vid', $val, DB::INT);
                            $com_pro_map->addEntry('value_name', Common::strEscape($propertyArrayAsId[$val]['base_name']), DB::VARCHAR);
                            $com_pro_map->addEntry('property_type', $propertyArrayAsId[$val]['type'], DB::INT);
                            $this->goodsProRelLogic->insert($com_pro_map);
                        }
                    }
                }
                //主单品
                $main_product_id = 0;
                if (_p('main_product')) {
                    $main_product_cond = 'goods_id=' . $goods_result . ' and property_id=' . intval(_p('main_product'));
                    $main_product = $this->productLogic->getOne($main_product_cond);
                    $main_product_id = isset($main_product['id']) ? $main_product['id'] : 0;
                }
                sort($total_price);
                sort($total_old_price);
                sort($total_cost_price);
                sort($total_market_price);
                sort($total_weight);
                $update_goods_data = array(
                    'product_id' => $main_product_id,
                    'image' => isset($imagelist[0][1]) ? substr($imagelist[0][1], 7) : '',
                    'stock_nums' => $total_stock,
                    'price' => $goods_price,
                    'old_price' => $goods_old_price,
                    'cost_price' => $goods_cost_price,
                    'market_price' => $goods_market_price,
                    'weight' => $goods_weight,
                    'visit_counts' => $goods_visit_counts,
                    'buy_counts' => $goods_buy_counts,
                    'wishlist_counts' => $goods_wishlist_counts,
                    'up_time' => SYS_TIME,
                    'status' => $on_sale,
                    'listorder' => $goods_result * 10,
                );
                //自定义路径
                $diy_url_flag = TRUE;
                if (_p('page_url')) {
                    $diyUrlLogic = $this->load('urlAlisa');
                    $true_url = Common::frontURL('home', 'product', 'detail', array('goods_id' => $goods_result), FALSE);
                    $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                    $diy_res = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                    if ($diy_res) {
                        $update_goods_data['page_url'] = Common::strEscape($page_url);
                    } else {
                        $diy_url_flag = FALSE;
                    }
                }
                $this->goodsLogic->save($update_goods_data, $goods_result);
                foreach ($product_con as $pkey => $item) {
                    if ($pkey > 0) {
                        $pimage = $item['image'];
                        if (!$pimage) {
                            //$pimage = isset($imagelist[0][1]) ? substr($imagelist[0][1], 7) : '';
                        }
                        sort($item['total_price']);
                        sort($item['total_cost_price']);
                        sort($item['total_market_price']);
                        sort($item['total_weight']);
                        $update_product_data = array(
                            'stock_nums' => $item['total_stock'],
                            'price' => $item['total_price'][0],
                            'cost_price' => $item['total_cost_price'][0],
                            'market_price' => Common::getMarketPrice($item['total_price'][0], $item['total_market_price'][0]),
                            'weight' => $item['total_weight'][0],
                            'status' => 1,
                            'image' => Common::strEscape($pimage),
                            'codeno' => $codeno . '_' . $pkey,
                        );
                        $this->productLogic->save($update_product_data, $pkey);
                    }
                }
                $relation = array();
                foreach (_p() as $key => $value) {
                    $relation_array = explode('_', $key);
                    if ($relation_array[0] == 'relation') {
                        $relation[$key] = $value;
                    }
                }
                foreach ($relation as $rel) {
                    $rel_array = explode('_', $rel);
                    if ($rel_array[0] == 'one') {
                        $relation_array = array(
                            'goods_id' => $goods_result,
                            'goods_rel_id' => $rel_array[1],
                        );
                        $this->goodsSelfRelLogic->save($relation_array);
                    } else if ($rel_array[0] == 'mutual') {
                        $relation_array = array(
                            'goods_id' => $goods_result,
                            'goods_rel_id' => $rel_array[1],
                        );
                        $this->goodsSelfRelLogic->save($relation_array);
                        $relation_array2 = array(
                            'goods_id' => $rel_array[1],
                            'goods_rel_id' => $goods_result,
                        );
                        $this->goodsSelfRelLogic->save($relation_array2);
                    }
                }
                //更新多语言
                $update_lang_data = array(
                    'price' => $total_price[0],
                    'listorder' => $goods_result * 10,
                    'up_time' => SYS_TIME,
                );
                $this->goodsLangLogic->saveByCond($update_lang_data, 'goods_id=' . $goods_result);
                //更新库存
                $this->load('goods')->updateStockNums($goods_result);
                //删除缓存
                $this->goodsLangLogic->updateCache($goods_result);
                _crearCahce('goods_list');
                return $diy_url_flag ? $this->success('add_success', Common::adminURL('product', 'product', 'list')) : $this->showMessage('diy_url_already_exists');
            }
            return $this->showMessage('failure');
        } else {
            $brand_id = Common::queryInt(_s('current_brand_id'));
            $goods_type_id = _s('current_goods_type_id');
            if (!$goods_type_id) {
                return $this->showMessage('please_select_brand_type_after', Common::adminURL('product', 'product', 'step1'));
            }
            $brand = array();
            if ($brand_id) {
                $brand = $this->brandLogic->getOneById($brand_id);
            }
            $type = $this->goodsTypeLogic->getOneById($goods_type_id);
            //添加相似商品
            $goods_id = Common::queryInt(_g('goods_id'));
            $do = Common::strEscape(_g('do'));
            if ($goods_id && $do == 'createsimilar') {
                $goods = $this->goodsLogic->getOne('id=' . $goods_id);
                if (!$goods) {
                    return $this->showMessage('not_found_record');
                }
                $where = 'goods_id =' . $goods_id;
                if (!$type) {
                    //类型被删除后需重新选择类型
                    return $this->_redirect(Common::adminURL('product', 'product', 'step1', array('goods_id' => $goods_id)));
                }
                //所有标签
                $goodsTags = $this->goodsTagLogic->findAll('status=1 order by listorder desc');
                $sites = $this->langLogic->findAll('status=1');
                //分类查询
                $goodsCategoryRels = $this->goodsCatRelLogic->getList($where);
                $relCat_ids = array();
                foreach ($goodsCategoryRels['list'] as $cat) {
                    $relCat_ids[$cat['goods_category_id']] = $cat['goods_category_id'];
                }
                //标签
                $goodsTagRels = $this->goodsTagRelLogic->getList($where);
                $tag_ids = array();
                foreach ($goodsTagRels['list'] as $tag) {
                    $tag_ids[$tag['tag_id']] = $tag['tag_id'];
                }
                //查找属性
                $goods_property_ids = array();
                $main_property_ids = array();
                $goods_property = $this->goodsProRelLogic->findAll($where);
                foreach ($goods_property as $item) {
                    $goods_property_ids[$item['property_id']] = $item['property_id'];
                    $goods_property_ids[$item['vid']] = $item['vid'];
                    if ($item['product_id']) {
                        $main_property_ids[] = $item['property_id'];
                        $main_property_ids[] = $item['vid'];
                    }
                }
                //	  print_r($goods_property_ids);
                $sku_property_list = array();
                if (!empty($main_property_ids)) {
                    $pro_cond = 'id in (' . implode(',', array_filter($main_property_ids)) . ')';
                    $sku_property_list = $this->propertyLogic->findAll($pro_cond, TRUE);
                }
                //单品查询            
                $products = $this->productLogic->findAll($where);
                $product_array = array();
                foreach ($products as $product) {
                    $product['master_name'] = isset($sku_property_list[$product['property_id']]) ? $sku_property_list[$product['property_id']]['base_name'] : '';
                    $product['master_id'] = $product['property_id'];
                    $product_array[$product['id']] = $product;
                }
                //sku查询
                $skus = $this->skuJoinProductLogic->getListByGoodsId($goods_id);
                $sku_array = array();
                $has_itemno = array();
                $sku_code_array = array(); //sku_code的集合
                $sku_master_id_array = array(0); //master_id的集合
                $sku_sale_id_array = array(0); //sale_id的集合
                foreach ($skus as $sku) {
                    $sku_code_array[$sku['sku_code']] = $sku['sku_code'];
                    $sku_code_split = explode('_', $sku['sku_code']);
                    if (!isset($has_itemno[$sku_code_split[0]])) {
                        $sku['has_itemno'] = 1;
                        $has_itemno[$sku_code_split[0]] = 1;
                    }
                    $sku['master_id'] = $sku_code_split[0];
                    $sku['sale_id'] = $sku_code_split[1];
                    $sku['codeno'] = $sku['sku_codeno'];
                    $sku_array[] = $sku;
                    $sku_master_id_array[$sku_code_split[0]] = $sku_code_split[0];
                    $sku_sale_id_array[$sku_code_split[1]] = $sku_code_split[1];
                }
                //多语言
                $goods_rel_lang = $this->goodsLangLogic->getListByGoodsId($goods_id);
                $theme_config = $this->load('theme')->findAll('', true);
                $tplConf = Common::getTplConf();
                $template = array();
                $lang_arr = array();
                foreach ($sites as $item) {
                    $lang_arr[$item['id']] = array(
                        'id' => $item['id'],
                        'base_name' => $item['base_name'],
                        'country_code_2' => $item['country_code_2'],
                        'lang_name' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['base_name'] : '',
                        'title' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['title'] : '',
                        'keywords' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['keywords'] : '',
                        'descript' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['descript'] : '',
                        'detail' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['detail'] : '',
                        'template_page' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['template_page'] : '',
                        'status' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['status'] : 0,
                    );
                    $template[$item['id']] = $tplConf[$theme_config[$item['theme_id']]['theme_dir']]['goods'];
                }
                $master_property = $this->propertyLogic->findAll('listorder<=0 and id in (' . implode(',', $sku_master_id_array) . ')');
                $sale_property = $this->propertyLogic->findAll('listorder<=0 and id in (' . implode(',', $sku_sale_id_array) . ')');
                Core::$tpl->set('master_property', $master_property);
                Core::$tpl->set('sale_property', $sale_property);
                Core::$tpl->set('goods', $goods);
                Core::$tpl->set('taglist', $goodsTags);
                Core::$tpl->set('sites', $lang_arr);
                Core::$tpl->set('products', $product_array);
                Core::$tpl->set('goods_category', $relCat_ids);
                Core::$tpl->set('goods_tag', $tag_ids);
                Core::$tpl->set('goods_property', $goods_property_ids);
                Core::$tpl->set('sku_code_array', $sku_code_array);
                Core::$tpl->set('sku_master_id_array', $sku_master_id_array);
                Core::$tpl->set('sku_sale_id_array', $sku_sale_id_array);
                Core::$tpl->set('skulist', $sku_array);
                Core::$tpl->set('sku_property', $sku_property_list);
                core::$tpl->set('template', $template);
                Core::$tpl->set('do', 'createsimilar');
            } else {
                $sites = $this->langLogic->findAll('status=1');
                $tplConf = Common::getTplConf();
                $template = array();
                foreach ($sites as $key => $value) {
                    $template[$value['id']] = $tplConf[$theme_config[$value['theme_id']]['dir']]['goods'];
                }
                $goodsTags = $this->goodsTagLogic->getList('status=1 order by listorder desc');
                Core::$tpl->set('taglist', $goodsTags['list']);
                Core::$tpl->set('sites', $sites);
                core::$tpl->set('template', $template);
            }
            //商品分类
            $categorys = $this->catgoryLogic->getList('order by listorder asc');
            $cat_tree = array();
            foreach (Common::getTree($categorys['list']) as $item) {
                $cat_tree[$item['id']] = array(
                    'id' => $item['id'],
                    'base_name' => str_repeat('|__ ', $item['level']) . $item['base_name'],
                );
            }
            $theme_config = $this->load('theme')->findAll('', true); //读取模板
            //读取属性
            $propertylist = $this->goodsTypePropertyLogic->getPropertyByTypeId($goods_type_id);
//            _debug($propertylist);
            $brands = $this->brandLogic->getList('status=1 order by listorder desc');
            $sites = $this->langLogic->findAll('status=1');
            foreach ($sites as $key => $value) {
                $siteid[] = $value['id'];
            }
            $sitestr = implode(',', $siteid);
            Core::$tpl->set('sitestr', $sitestr);
            Core::$tpl->set('brandlist', $brands['list']);
            Core::$tpl->set('brand', $brand);
            Core::$tpl->set('goodstype', $type);
            Core::$tpl->set('categorylist', $cat_tree);
            Core::$tpl->set('propertylist', $propertylist);
        }
    }

    /**
     * 添加商品第一步 
     */
    public function actionStep1() {
        if (_p()) {
            if (!_p('goods_type_id')) {
                return $this->showMessage('please_select_brand_type');
            }
            if (_p('goods_id')) {
                $goods_id = Common::queryInt(_p('goods_id'));
                $goods = $this->goodsLogic->getOneById($goods_id);
                if (!$goods) {
                    return $this->showMessage('illegal_parameters');
                }
                if (_p('goods_type_id') != $goods['goods_type_id']) {
                    $this->skuLogic->delete('goods_id=' . $goods_id);
                    $this->productLogic->delete('goods_id=' . $goods_id);
                    $this->productImageLogic->delete('goods_id=' . $goods_id . ' and product_id != 0');
                    $this->goodsProRelLogic->delete('goods_id=' . $goods_id);
                }
                $brand_id = Common::queryInt(_p('brand_id'));
                $goods_data = array(
                    'brand_id' => $brand_id,
                    'goods_type_id' => _p('goods_type_id'),
                );
                if ($this->goodsLogic->save($goods_data, $goods_id)) {
                    return $this->_redirect(ADMIN_ROOT . "?m=product&c=product&a=edit&id=" . $goods_id);
                    return;
                }
            }
            _setSession('current_brand_id', _p('brand_id'));
            _setSession('current_goods_type_id', _p('goods_type_id'));
            if (_s('current_goods_type_id')) {
                return $this->_redirect(ADMIN_ROOT . "?m=product&c=product&a=step2");
            } else {
                return $this->showMessage('please_select_brand_type');
            }
        } else {
            $goods_id = Common::queryInt(_g('goods_id'));
            $goods = $this->goodsLogic->getOneById($goods_id);
            $brands = $this->brandLogic->getList('status=1 order by listorder desc');
            $goostypes = $this->goodsTypeLogic->getList('status=1 order by listorder desc');
            Core::$tpl->set('brandlist', $brands['list']);
            Core::$tpl->set('typelist', $goostypes['list']);
            Core::$tpl->set('goods', $goods);
        }
    }

    /**
     * 添加相似商品
     */
    public function actionAddSimilar() {
        $goods_id = Common::queryInt(_g('id'));
        $goods = $this->goodsLogic->getOneById($goods_id);
        if (!$goods) {
            return $this->showMessage('not_found_record');
        }
        $brand_id = $goods['brand_id'];
        $goods_type_id = $goods['goods_type_id'];
        $brand = $this->brandLogic->getOneById($brand_id);
        $type = $this->goodsTypeLogic->getOneById($goods_type_id);
        if (!$brand || !$type) {
            //类型被删除后需重新选择类型
            return $this->showMessage('goods_info_nocomplete', Common::adminURL('product', 'product', 'step1', array('goods_id' => $goods_id)));
        } else {
            _setSession('current_brand_id', $brand_id);
            _setSession('current_goods_type_id', $goods_type_id);
            return $this->_redirect(ADMIN_ROOT . "?m=product&c=product&a=step2&do=createsimilar&goods_id=" . $goods_id);
        }
    }

    /**
     * 商品编辑
     * @return type 
     */
    public function actionEdit() {
        if (_p()) {
            $on_sale = _p('goods_status') ? _p('goods_status') : 0;
            $goods_id = Common::queryInt(_p('id'));
            $base_site = Common::validSiteConfig();
            $base_name = _p('base_name');
            $codeno = _p('codeno');
            $category_ids = _p('category_id');
            $brand_id = Common::queryInt(_p('brand_id'));
            $goods_price = _p('price');
            $goods_weight = _p('weight');
            $goods_old_price = _p('old_price');
            $goods_cost_price = _p('cost_price');
            $goods_market_price = _p('market_price');
            $goods_visit_counts = _p('visit_counts');
            $goods_buy_counts = _p('buy_counts');
            $goods_wishlist_counts = _p('wishlist_counts');
            $goods_base_name = $base_name[$base_site];
            $goods = $this->goodsLogic->getOneById($goods_id);

            if (!$goods) {
                return $this->showMessage('not_found_record');
            }
            if (!$goods_base_name) {
                return $this->showMessage('name_not_empty');
            }
            if (!isset($category_ids[0]) || !$category_ids[0]) {
                return $this->showMessage('please_select_category');
            }
            if (!$codeno) {
                return $this->showMessage('codeno_not_empty');
            }
            $cond = "codeno='" . $codeno . "' and id !=" . $goods_id;
            $goods_count = $this->goodsLogic->getCount($cond);
            if ($goods_count > 0) {
                return $this->showMessage('codeno_already_exists');
            }
            $goods_type_id = $goods['goods_type_id'];
            $goods_data = array(
                'base_name' => Common::strEscape($goods_base_name),
                'codeno' => $codeno,
                'brand_id' => $brand_id,
            );
            $goods_result = $this->goodsLogic->save($goods_data, $goods_id);
            if ($goods_result) {
                //删除之前的关联的分类               
                $this->goodsCatRelLogic->delete('goods_id=' . $goods_id);
                //关联分类
                $cat_where = 'id in(' . implode(',', $category_ids) . ')';
                $categorylist = $this->catgoryLogic->getList($cat_where);
                foreach ($categorylist['list'] as $cat) {
                    $goods_cat_arr = array(
                        'goods_id' => $goods_id,
                        'goods_category_id' => $cat['id'],
                        'category_path' => $cat['path_id'],
                    );
                    $this->goodsCatRelLogic->save($goods_cat_arr);
                }
                //多语言
                $detail = Inputer::getOrgPost('detail');
                $title = _p('title');
                $keyword = _p('keywords');
                $descript = _p('descript');
                $template_page = _p('template_page');
                foreach ($base_name as $key => $val) {
                    $lang_data = array(
                        'goods_id' => $goods_id,
                        'language_id' => $key,
                        'base_name' => Common::strEscape($val),
                        'detail' => Common::strEscape($detail[$key], FALSE),
                        'title' => Common::strEscape($title[$key]),
                        'keywords' => Common::strEscape($keyword[$key]),
                        'descript' => Common::strEscape($descript[$key]),
                        'template_page' => Common::strEscape($template_page[$key]),
                        'status' => Common::queryInt(_p('is_display-' . $key)),
                        'category_path' => $categorylist['list'][0]['path_id'],
                        'search_keyword' => Common::strEscape($val) . ' ' . $codeno,
                    );
                    global $cfg;
                    if ($cfg['sites'][0]['goods_default_sort'] == 'up_time') {
                        $lang_data['up_time'] = SYS_TIME;
                    }
                    $this->goodsLangLogic->updateByCond($lang_data);
                }
                //删除原有标签
                $delet_tag_cond = 'goods_id=' . $goods_id;
                $this->goodsTagRelLogic->delete($delet_tag_cond);
                //关联标签
                $tag_ids = _p('goods_tag_id');
                if ($tag_ids) {
                    foreach ($tag_ids as $tag) {
                        $tag_map = Zhtx::createDataMap();
                        $tag_map->addEntry('goods_id', $goods_id, DB::INT);
                        $tag_map->addEntry('tag_id', $tag, DB::INT);
                        $this->goodsTagRelLogic->insert($tag_map);
                    }
                }
                //查询单品
                //$products = $this->productLogic->getListByGoodsId($goods_id, FALSE);
                $products = array();
                //普通属性收集
                $common_property_ids = _p('common_property');
                $master_property_id = _p('master_property_id');
                $sale_property_id = _p('sale_property_id');
                $main_property = array();
                //radio属性收集
                foreach (_p() as $pkey => $pv) {
                    if (strpos($pkey, 'common_property-') !== FALSE) {
                        $split = explode('-', $pkey);
                        $common_property_ids[$split[1]] = array($pv);
                    }
                    //文本属性收集  
                    if (strpos($pkey, 'common_text_property-') !== FALSE) {
                        $split = explode('-', $pkey);
                        //判断是否有该属性
                        $property_info = $this->load('property')->findAll('parent_id=' . $split[1]);
                        $property_base_name_arr = array();
                        if ($property_info) {
                            foreach ($property_info as $key => $value) {
                                if ($value['base_name'] == $pv) {
                                    $pvid = $value['id'];
                                }
                                $property_base_name_arr[] = $value['base_name'];
                                $property_type = $value['type'];
                                $property_parent_id = $value['parent_id'];
                            }
                        } else {
                            $property_info = $this->load('property')->getOne('id=' . $split[1]);
                            $property_type = $property_info['type'];
                            $property_parent_id = $property_info['id'];
                        }
                        if (!in_array($pv, $property_base_name_arr) && $pv != '') {
                            $map = Zhtx::createDataMap();
                            $map->addEntry('base_name', Common::strEscape($pv), DB::VARCHAR);
                            $map->addEntry('value_type', 3, DB::INT);
                            $map->addEntry('type', $property_type, DB::INT);
                            $map->addEntry('parent_id', $property_parent_id, DB::INT);
                            $map->addEntry('required', 1, DB::INT);
                            $map->addEntry('search', 1, DB::INT);
                            $map->addEntry('alias_name', Common::strEscape($pv), DB::VARCHAR);
                            $map->addEntry('create_time', SYS_TIME, DB::INT);
                            $result = $this->propertyLogic->insert($map);
                            if ($result) {
                                $pvid = $result;
                                $map = Zhtx::createDataMap();
                                $map->addEntry('listorder', 10 * $result, DB::INT);
                                $this->propertyLogic->update($map, 'id=' . $result);
                                //如果主表信息更新成功,则更新附表信息 
                                $languages = $this->langLogic->findALL('status=1', true);
                                foreach ($languages as $item) {
                                    $propertyLanguage = Zhtx::createDataMap();
                                    $propertyLanguage->addEntry('property_id', $result, DB::INT);
                                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                                    $propertyLanguage->addEntry('base_name', Common::strEscape($pv), DB::VARCHAR);
                                    $this->load('propertyLanguage')->insert($propertyLanguage);
                                }
                            }
                        }
                        if ($pv) {
                            $common_property_ids[$split[1]] = array($pvid);
                        }
                    }
                }
                //单品和sku处理            
                $skulist = _p('sku');
                $has_product = array();
                $up_status = false;
                $old_price = array();
                $total_price = array();
                $total_old_price = array();
                $total_cost_price = array();
                $total_market_price = array();
                $total_weight = array();
                $total_stock = 0;
                $product_con = array();
                $property_ids = array();
                if ($master_property_id)
                    $property_ids[] = $master_property_id;
                if ($sale_property_id)
                    $property_ids[] = $sale_property_id;
                $this->skuLogic->delete('goods_id=' . $goods_id);
                $this->productLogic->delete('goods_id=' . $goods_id);
                foreach ($skulist as $key => $value) {
                    $stock = Common::queryInt($value['stock']);
                    $old_price = $value['old_price'] ? $value['old_price'] : 0;
                    $price = $value['sale_price'] ? $value['sale_price'] : 0;
                    $cost_price = $value['cost_price'] ? $value['cost_price'] : 0;
                    $market_price = $value['market_price'] ? $value['market_price'] : 0;
                    $weight = $value['weight'] ? $value['weight'] : 0;
                    $status = Common::queryInt($value['status']);
                    $pro_array = explode('_', $key);
                    $product_id = 0;
                    if ($pro_array[0]) {
                        $main_property[$master_property_id][$pro_array[0]] = $pro_array[0];
                        $property_ids[] = $pro_array[0];
                    }
                    if ($pro_array[1]) {
                        $main_property[$sale_property_id][$pro_array[1]] = $pro_array[1];
                        $property_ids[] = $pro_array[1];
                    }
                    if (isset($has_product[$pro_array[0]])) {
                        $product_id = $has_product[$pro_array[0]];
                        $has_product[$pro_array[1]] = $product_id;
                    } else {
                        $product_data = array(
                            'goods_id' => $goods_id,
                            'base_name' => Common::strEscape($base_name[$base_site]),
                            'property_id' => $pro_array[0],
                            'status' => 1,
                                // 'itemno'      => $value['itemno'],
                        );
                        $exist_product_id = isset($products[$pro_array[0]]) ? $products[$pro_array[0]]['id'] : 0;
                        $product_res = $this->productLogic->save($product_data, $exist_product_id);
                        $product_id = $exist_product_id ? $exist_product_id : $product_res;
                        $has_product[$pro_array[0]] = $product_id;
                        $has_product[$pro_array[1]] = $product_id;
                        $product_con[$product_id] = array(
                            'old_price' => array(),
                            'total_price' => array(),
                            'total_cost_price' => array(),
                            'total_market_price' => array(),
                            'total_weight' => array(),
                            'total_stock' => 0,
                            'status' => 0,
                        );
                    }

                    //sku
                    if ($product_id) {


                        $total_price[] = $price;
                        $total_old_price[] = $old_price;
                        $total_cost_price[] = $cost_price;
                        $total_market_price[] = $market_price;
                        $total_weight[] = $weight;
                        if ($status)
                            $total_stock += $stock;

                        $product_con[$product_id]['old_price'][] = $old_price;
                        $product_con[$product_id]['total_price'][] = $price;
                        $product_con[$product_id]['total_cost_price'][] = $cost_price;
                        $product_con[$product_id]['total_market_price'][] = $market_price;
                        $product_con[$product_id]['total_weight'][] = $weight;
                        if ($status)
                            $product_con[$product_id]['total_stock'] += $stock;
                        if ($status) {
                            $up_status = true;
                            $product_con[$product_id]['status'] = $status;
                        }

                        $sku_data = array(
                            'goods_id' => $goods_id,
                            'product_id' => $product_id,
                            'sku_code' => $key,
                            'codeno' => Common::queryStr($value['codeno']),
                            'stock_nums' => $stock,
                            'old_price' => $old_price,
                            'price' => $price,
                            'cost_price' => $cost_price,
                            //'market_price' => Common::getMarketPrice($price, $market_price),
                            'market_price' => $market_price,
                            'weight' => $weight,
                            'status' => 1,
                            'update_time' => SYS_TIME,
                        );
						
						
						if($goods['special_offer_id']==0)
						{
							// 重置到初始状态
							$sku_data['special_status'] =  0;
							$sku_data['old_price'] =  0;	
						}
						else
						{
							// 获取特价活动的状态
							$spe_offer = $this->load('SpecialOffer')->getOne("id=".$goods['special_offer_id']);
							if(!$spe_offer)
							{
								$sku_data['special_status'] =  0;
								$sku_data['old_price'] =  0;
								$sku_data['price'] = max($price,$old_price);
							}
							else if(!$goods['special_status'])
							{
								$sku_data['old_price'] = 	$price ;
								$sku_data['price'] = 	$price ;
							}
						}
						
                        $sku_cond = 'goods_id =' . $goods_id . ' and sku_code="' . $key . '"';
                        $sku = $this->skuLogic->getOne($sku_cond);
                        if (!$sku) {
                            $sku_data['create_time'] = SYS_TIME;
                        }
                        $sku_res = $this->skuLogic->save($sku_data, $sku ? $sku['id'] : 0);
                        //记录价格修改
                        if ($sku && $sku_res && ($price != $sku['price'] || $cost_price != $sku['cost_price'] || $market_price || $sku['market_price'])) {
                            $params = array(
                                'goods_id' => $goods_id,
                                'sku_code' => $key,
                                'pre_price' => $sku['price'],
                                'pre_cost_price' => $sku['cost_price'],
                                'pre_market_price' => $sku['market_price'],
                                'price' => $price,
                                'old_price' => $old_price,
                                'cost_price' => $cost_price,
                                'market_price' => $market_price,
                            );
                          //  ReportFactory::goodsPriceReport($params);
                        }
                    }
                }
                //图片存放 先清理原有图片
                $imagelist = _p('image');
                ksort($imagelist);
                $this->productImageLogic->delete('goods_id=' . $goods_id);
                foreach ($imagelist as $key => $imgs) {
                    $current_product_id = $key && isset($has_product[$key]) ? $has_product[$key] : 0;
                    $pimg = '';
                    for ($i = 1; $i < 20; $i++) {
                        if (isset($imgs[$i]) && $imgs[$i]) {
                            $pimg = $imgs[$i];
                            break;
                        }
                    }
                    $product_con[$current_product_id]['image'] = substr($pimg, 7);
                    foreach ($imgs as $order => $value) {
                        $image = substr($value, 7);
                        $img_data = array(
                            'goods_id' => $goods_id,
                            'product_id' => $current_product_id,
                            'image' => Common::strEscape($image),
                            'listorder' => $order,
                        );
                        $this->productImageLogic->save($img_data);
                    }
                }
                //删除之前关联的属性
                $delete_com_pro_cond = 'goods_id=' . $goods_id;
                $this->goodsProRelLogic->delete($delete_com_pro_cond);
                //普通属性收集
                foreach ($common_property_ids as $ckey => $com) {
                    $property_ids[] = $ckey;
                    if (is_array($com)) {
                        foreach ($com as $c) {
                            $property_ids[] = $c;
                        }
                    } else {
                        $property_ids[] = $com;
                    }
                }
                $all_property_ids = array_filter(array_unique($property_ids));
                if (!$all_property_ids) {
                    $all_property_ids = array(0);
                }
                $where = 'id in (' . implode(',', $all_property_ids) . ')';
                $propertyArrayAsId = $this->propertyLogic->findAll($where, true);
                //普通属性存放
                foreach ($common_property_ids as $ckey => $item) {
                    $parent_property = $propertyArrayAsId[$ckey];
                    if (is_array($item)) {
                        foreach ($item as $val) {
							if($val)
							{
                            $com_pro_map = Zhtx::createDataMap();
                            $com_pro_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
                            $com_pro_map->addEntry('goods_id', $goods_id, DB::INT);
                            $com_pro_map->addEntry('property_id', $ckey, DB::INT);
                            $com_pro_map->addEntry('property_name', Common::strEscape($parent_property['base_name']), DB::VARCHAR);
                            $com_pro_map->addEntry('vid', $val, DB::INT);
                            $com_pro_map->addEntry('value_name', Common::strEscape($propertyArrayAsId[$val]['base_name']), DB::VARCHAR);
                            $this->goodsProRelLogic->insert($com_pro_map);
							}
                        }
                    }
                }
                //销售属性存放
                foreach ($main_property as $mkey => $item) {
                    if (is_array($item)) {
                        $parent_property = $propertyArrayAsId[$mkey];
                        foreach ($item as $val) {
                            $current_product_id = isset($has_product[$val]) ? $has_product[$val] : $has_product[0];
                            $com_pro_map = Zhtx::createDataMap();
                            $com_pro_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
                            $com_pro_map->addEntry('goods_id', $goods_id, DB::INT);
                            $com_pro_map->addEntry('product_id', $current_product_id, DB::INT);
                            $com_pro_map->addEntry('property_id', $mkey, DB::INT);
                            $com_pro_map->addEntry('property_name', Common::strEscape($parent_property['base_name']), DB::VARCHAR);
                            $com_pro_map->addEntry('vid', $val, DB::INT);
                            $com_pro_map->addEntry('value_name', Common::strEscape($propertyArrayAsId[$val]['base_name']), DB::VARCHAR);
                            $com_pro_map->addEntry('property_type', $propertyArrayAsId[$val]['type'], DB::INT);
                            $this->goodsProRelLogic->insert($com_pro_map);
                        }
                    }
                }
                //主单品
                $main_product_id = 0;
                if (_p('main_product')) {
                    $main_product_cond = 'goods_id=' . $goods_id . ' and property_id=' . intval(_p('main_product'));
                    $main_product = $this->productLogic->getOne($main_product_cond);
                    $main_product_id = isset($main_product['id']) ? $main_product['id'] : 0;
                }
                sort($total_price);
                sort($total_old_price);
                sort($total_cost_price);
                sort($total_market_price);
                sort($total_weight);
                $gimg = ''; //获取第一张图片
                for ($i = 1; $i < 20; $i++) {
                    if (isset($imagelist[0][$i]) && $imagelist[0][$i]) {
                        $gimg = $imagelist[0][$i];
                        break;
                    }
                }
                $update_goods_data = array(
                    'product_id' => $main_product_id,
                    'image' => Common::strEscape(substr($gimg, 7)),
                    'stock_nums' => $total_stock,
                    'price' => $goods_price,
                    'old_price' => $goods_old_price,
                    'cost_price' => $goods_cost_price,
                    'market_price' => $goods_market_price,
                    'weight' => $goods_weight,
                    'visit_counts' => $goods_visit_counts,
                    'buy_counts' => $goods_buy_counts,
                    'wishlist_counts' => $goods_wishlist_counts,
                    'modify_time' => SYS_TIME,
                    'status' => $on_sale,
                );
				
				if($goods['special_offer_id']==0)
				{
					// 重置到初始状态
					$update_goods_data['special_status'] =  0;
					$update_goods_data['old_price'] =  0;	
					$update_goods_data['discount'] =  10;	
					$update_goods_data['start_time'] =  0;	
					$update_goods_data['end_time'] =  0;	
				}
				else
				{
					// 获取特价活动的状态
					$spe_offer = $this->load('SpecialOffer')->getOne("id=".$goods['special_offer_id']);
					if(!$spe_offer)
					{
						$update_goods_data['special_status'] =  0;
						$update_goods_data['old_price'] =  0;
						$update_goods_data['price'] = max($goods_old_price,$goods_price);
						$update_goods_data['discount'] =  10;	
						$update_goods_data['start_time'] =  0;	
						$update_goods_data['end_time'] =  0;	
						$update_goods_data['special_offer_id'] = 0 ;
					}
					else if($goods['special_status'])
					{
						$discount = (($goods_price/$goods_old_price)*10);
                    	$update_goods_data['discount'] = $discount;
					}
					else if(!$goods['special_status'])
					{
						$update_goods_data['old_price'] = 	$goods_price ;
						$update_goods_data['price'] = 	$goods_price ;
					}
				}
				
				
				
               
                //自定义路径
                $diy_url_flag = TRUE;
                $diyUrlLogic = $this->load('urlAlisa');
                $true_url = Common::frontURL('home', 'product', 'detail', array('goods_id' => $goods_id), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res = $diyUrlLogic->createDiyUrl($page_url, $true_url);
                if ($diy_res) {
                    $update_goods_data['page_url'] = Common::strEscape($page_url);
                } else {
                    $diy_url_flag = FALSE;
                    return $this->showMessage('diy_url_already_exists');
                }
                $this->goodsLogic->save($update_goods_data, $goods_id);
                foreach ($product_con as $pkey => $item) {
                    if ($pkey > 0) {
                        $pimage = $item['image'];
                        if (!$pimage) {
                            //$pimage = isset($imagelist[0][1]) ? substr($imagelist[0][1], 7) : '';
                        }
                        sort($item['total_price']);
                        sort($item['total_cost_price']);
                        sort($item['total_market_price']);
                        sort($item['total_weight']);
                        $update_product_data = array(
                            'stock_nums' => $item['total_stock'],
                            'price' => $item['total_price'][0],
                            'cost_price' => $item['total_cost_price'][0],
                            'market_price' => Common::getMarketPrice($item['total_price'][0], $item['total_market_price'][0]),
                            'weight' => $item['total_weight'][0],
                            'status' => 1,
                            'image' => Common::strEscape($pimage),
                            'codeno' => $codeno . '_' . $pkey,
                        );
                        $this->productLogic->save($update_product_data, $pkey);
                    }
                }
                //删除之前的关联商品 再存储当前关联的关系
                $del_rel_cond = 'goods_id =' . $goods_id . ' or goods_rel_id=' . $goods_id;
                $this->goodsSelfRelLogic->delete($del_rel_cond);
                $relation = array();
                foreach (_p() as $key => $value) {
                    $relation_array = explode('_', $key);
                    if ($relation_array[0] == 'relation') {
                        $relation[$key] = $value;
                    }
                }
                foreach ($relation as $rel) {
                    $rel_array = explode('_', $rel);
                    if ($rel_array[0] == 'one') {
                        $relation_array = array(
                            'goods_id' => $goods_id,
                            'goods_rel_id' => $rel_array[1],
                        );
                        $this->goodsSelfRelLogic->save($relation_array);
                    } else if ($rel_array[0] == 'mutual') {
                        $relation_array = array(
                            'goods_id' => $goods_id,
                            'goods_rel_id' => $rel_array[1],
                        );
                        $this->goodsSelfRelLogic->save($relation_array);
                        $relation_array2 = array(
                            'goods_id' => $rel_array[1],
                            'goods_rel_id' => $goods_id,
                        );
                        $this->goodsSelfRelLogic->save($relation_array2);
                    }
                }
                //更新多语言
                $update_lang_data = array(
                    'price' => $total_price[0],
                );
                $this->goodsLangLogic->saveByCond($update_lang_data, 'goods_id=' . $goods_id);
                //更新库存
                $this->load('goods')->updateStockNums($goods_id);
                //删除缓存
                $this->goodsLangLogic->updateCache($goods_id);
                _crearCahce('goods_list');
                return $diy_url_flag ? $this->success('save_success', Common::adminURL('product', 'product', 'edit', array('id' => $goods_id))) : $this->error('save_failure');
            }
            return $this->showMessage('failure');
        } else {
            //商品查询
            $good_id = _g('id') ? intval(_g('id')) : 0;
            $goods = $this->goodsLogic->getOne('id=' . $good_id);
            if (!$goods) {
                return $this->showMessage('not_found_record');
            }
            $where = 'goods_id =' . $good_id;
            //品牌类型
            $brand_id = $goods['brand_id'];
            $goods_type_id = $goods['goods_type_id'];
            $brand = array();
            if ($brand_id) {
                $brand = $this->brandLogic->getOneById($brand_id);
            }
            $type = $this->goodsTypeLogic->getOneById($goods_type_id);
            if (!$type) {
                //类型被删除后需重新选择类型
                return $this->_redirect(Common::adminURL('product', 'product', 'step1', array('goods_id' => $good_id)));
            }
            //分类查询
            $goodsCategoryRels = $this->goodsCatRelLogic->getList($where);
            $relCat_ids = array();
            foreach ($goodsCategoryRels['list'] as $cat) {
                $relCat_ids[$cat['goods_category_id']] = $cat['goods_category_id'];
            }
            //标签
            $goodsTagRels = $this->goodsTagRelLogic->getList($where);
            $tag_ids = array();
            foreach ($goodsTagRels['list'] as $tag) {
                $tag_ids[$tag['tag_id']] = $tag['tag_id'];
            }
            //查找属性
            $goods_property_ids = array();
            $main_property_ids = array();
            $goods_property = $this->goodsProRelLogic->findAll($where);
            foreach ($goods_property as $item) {
                $goods_property_ids[$item['property_id']] = $item['property_id'];
                $goods_property_ids[$item['vid']] = $item['vid'];
                if ($item['product_id']) {
                    $main_property_ids[] = $item['property_id'];
                    $main_property_ids[] = $item['vid'];
                }
            }
//	  print_r($goods_property_ids);
            $sku_property_list = array();
            if (!empty($main_property_ids)) {
                $pro_cond = 'id in (' . implode(',', array_filter($main_property_ids)) . ')';
                $sku_property_list = $this->propertyLogic->findAll($pro_cond, TRUE);
            }
            //单品查询            
            $products = $this->productLogic->findAll($where);
            $product_array = array();
            foreach ($products as $product) {
                if(!$product['property_id'])
                {
                    continue;
                }
                $product['master_name'] = isset($sku_property_list[$product['property_id']]) ? $sku_property_list[$product['property_id']]['base_name'] : '';
                $product['master_id'] = $product['property_id'];
                $product_array[$product['id']] = $product;
            }
            //sku查询
            $skus = $this->skuJoinProductLogic->getListByGoodsId($good_id);
            $sku_array = array();
            $has_itemno = array();
            $sku_code_array = array(); //sku_code的集合
            $sku_master_id_array = array(0); //master_id的集合
            $sku_sale_id_array = array(0); //sale_id的集合
            foreach ($skus as $sku) {
                $sku_code_array[$sku['sku_code']] = $sku['sku_code'];
                $sku_code_split = explode('_', $sku['sku_code']);
                if (!isset($has_itemno[$sku_code_split[0]])) {
                    $sku['has_itemno'] = 1;
                    $has_itemno[$sku_code_split[0]] = 1;
                }
                $sku['master_id'] = $sku_code_split[0];
                $sku['sale_id'] = $sku_code_split[1];
                $sku['codeno'] = $sku['sku_codeno'];
                $sku_array[] = $sku;
                $sku_master_id_array[$sku_code_split[0]] = $sku_code_split[0];
                $sku_sale_id_array[$sku_code_split[1]] = $sku_code_split[1];
            }
            //所有分类
            $categorys = $this->catgoryLogic->getList('order by listorder asc');
            $cat_tree = array();
            foreach (Common::getTree($categorys['list']) as $item) {
                $cat_tree[$item['id']] = array(
                    'id' => $item['id'],
                    'base_name' => str_repeat('|__ ', $item['level']) . $item['base_name'],
                );
            }
            //所有标签
            $goodsTags = $this->goodsTagLogic->findAll('status=1 order by listorder desc');
            $sites = $this->langLogic->findAll('status=1');
            //所有属性
            $propertylist = $this->goodsTypePropertyLogic->getPropertyByTypeId($goods_type_id);
//      _debug($propertylist);
            //多语言
            $goods_rel_lang = $this->goodsLangLogic->getListByGoodsId($good_id);
            $theme_config = $this->load('theme')->findAll('', true);
            $tplConf = Common::getTplConf();
            $template = array();
            $lang_arr = array();
            foreach ($sites as $item) {
                $lang_arr[$item['id']] = array(
                    'id' => $item['id'],
                    'base_name' => $item['base_name'],
                    'country_code_2' => $item['country_code_2'],
                    'lang_name' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['base_name'] : '',
                    'title' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['title'] : '',
                    'keywords' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['keywords'] : '',
                    'descript' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['descript'] : '',
                    'detail' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['detail'] : '',
                    'template_page' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['template_page'] : '',
                    'status' => isset($goods_rel_lang[$item['id']]) ? $goods_rel_lang[$item['id']]['status'] : 0,
                );
                $template[$item['id']] = $tplConf[$theme_config[$item['theme_id']]['theme_dir']]['goods'];
            }
            //已经关联的商品
            $relationgoods = $this->goodsSelfRelLogic->getRelGoods($good_id);
            //图片
            $images = $this->productImageLogic->getListByGoodsId($good_id);
            ksort($images);
            $default_images = array();
            $product_images = array();
            $d = 2;
            $p = 2;
            foreach ($images as $image) {
                if ($image['product_id'] == 0) {
                    if ($image['image'] != $goods['image']) {
                        $default_images[$d] = $image;
                        $d++;
                    } else {
                        $default_images[1] = $image;
                    }
                } else {
                    if (isset($product_array[$image['product_id']])) {
                        $pimage = $product_array[$image['product_id']]['image'];
                        if ($image['image'] != $pimage) {
                            $product_images[$image['product_id']][$p] = $image;
                            $p++;
                        } else {
                            $product_images[$image['product_id']][1] = $image;
                        }
                    }
                }
            };
            if (!$default_images) {
                $default_images[1]['image'] = $goods['image'];
            }
            ksort($default_images);
            $brands = $this->brandLogic->getList('status=1 order by listorder desc');
            $master_property = $this->propertyLogic->findAll('listorder<=0 and id in (' . implode(',', $sku_master_id_array) . ')');
            $sale_property = $this->propertyLogic->findAll('listorder<=0 and id in (' . implode(',', $sku_sale_id_array) . ')');
            $sites = $this->langLogic->findAll('status=1');
            foreach ($sites as $key => $value) {
                $siteid[] = $value['id'];
            }
			
			$spe_offer = $this->load("SpecialOffer")->getOne("id=".$goods['special_offer_id']);
			Core::$tpl->set('spe_offer', $spe_offer);
            $sitestr = implode(',', $siteid);
            Core::$tpl->set('sitestr', $sitestr);
            Core::$tpl->set('goods', $goods);
            Core::$tpl->set('brand', $brand);
            Core::$tpl->set('brandlist', $brands['list']);
            Core::$tpl->set('goodstype', $type);
            Core::$tpl->set('categorylist', $cat_tree);
            Core::$tpl->set('taglist', $goodsTags);
            Core::$tpl->set('sites', $lang_arr);
            Core::$tpl->set('propertylist', $propertylist);
            Core::$tpl->set('products', $product_array);
            Core::$tpl->set('goods_category', $relCat_ids);
            Core::$tpl->set('goods_tag', $tag_ids);
            Core::$tpl->set('goods_property', $goods_property_ids);
            Core::$tpl->set('sku_code_array', $sku_code_array);
            Core::$tpl->set('sku_master_id_array', $sku_master_id_array);
            Core::$tpl->set('sku_sale_id_array', $sku_sale_id_array);
            Core::$tpl->set('master_property', $master_property);
            Core::$tpl->set('sale_property', $sale_property);
            Core::$tpl->set('skulist', $sku_array);
            Core::$tpl->set('sku_property', $sku_property_list);
            Core::$tpl->set('relationgoods', $relationgoods);
            Core::$tpl->set('default_images', $default_images);
            Core::$tpl->set('product_images', Common::array_sort($product_images));
            core::$tpl->set('template', $template);
            Core::$htmlFile = 'product/step2';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    /**
     * 删除sku 
     */
    public function actionDelSkuByCode() {
        $status = 0;
        $goods_id = Common::queryInt(_p('goods_id'));
        $sku_code = _p('sku_code');
        $property_ids = explode('_', $sku_code);
        $delete_sku_cond = 'goods_id=' . $goods_id . ' and sku_code ="' . $sku_code . '"';
        $del_sku = $this->skuLogic->getOne($delete_sku_cond);
        if ($del_sku) {
            //删除sku
            $del_sku_res = $this->skuLogic->delete($delete_sku_cond);
            if ($del_sku_res) {
                $cond = 'goods_id=' . $goods_id . ' and sku_code like "' . $property_ids[0] . '_%"';
                $count = $this->skuLogic->getCount($cond);
                if ($count <= 0) {
                    $del_product_cond = 'goods_id=' . $goods_id . ' and property_id=' . $property_ids[0];
                    $product = $this->productLogic->getOne($del_product_cond);
                    $this->productLogic->delete($del_product_cond);
                    $del_property_cond = 'goods_id=' . $goods_id . ' and product_id=' . $product['id']
                            . ' and (vid=' . $property_ids[0] . ' or vid=' . $property_ids[1] . ')';
                    $this->goodsProRelLogic->delete($del_property_cond);
                    $del_img_cond = 'goods_id=' . $goods_id . ' and product_id=' . $product['id'];
                    $this->productImageLogic->delete($del_img_cond);
                }
                $sku_count = $this->skuLogic->getCount('goods_id=' . $goods_id . ' and status=1');
                $cols = array('goods_id', 'sum(stock_nums) as stock_nums');
                $skus = $this->skuLogic->getCols('goods_id=' . $goods_id, $cols);
                $stock_nums = 0;
                foreach ($skus as $value) {
                    $stock_nums += $value['stock_nums'];
                }
                //更新商品
                $goods_data = array(
                    'stock_nums' => $stock_nums,
                    'status' => $stock_nums > 0 ? 1 : 0,
                );
                $this->goodsLogic->save($goods_data, $goods_id);
                //更新库存
                $this->load('goods')->updateStockNums($goods_id);
                //清空缓存
                $this->goodsLangLogic->updateCache($goods_id);
                $status = 1;
            }
        } else {
            $status = 2;
        }
        echo $status;
    }

    /**
     * 商品列表页 
     */
    public function actionList() {
        //分页用的参数
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        //获取数据
        $search = array();
        $where = '1=1';
        if (_g('search_value')) {
            $where .= " and ( g.codeno like '%" . _g('search_value') . "%' ";
            $search['search_value'] = _g('search_value');
            $where .= ' or g.base_name like "%' . _g('search_value') . '%")';
        }
        if (_g('base_name')) {
            $where .= ' and g.base_name like "%' . _g('base_name') . '%"';
        }
        if (_g('base_name')) {
            $where .= ' and g.base_name like "%' . _g('base_name') . '%"';
        }
        if (_g('codeno')) {
            $where .= ' and g.codeno ="' . _g('codeno') . '"';
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and g.up_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and g.up_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and g.up_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('status') != '-1' && _g('status') != NULL) {
            $where .= ' and g.status =' . _g('status');
        }
        if (_g('stock_nums') == 2) {
            $where .= ' and g.stock_nums <=0';
        } else if (_g('stock_nums') == 1) {
            $where .= ' and g.stock_nums >0';
        }
        if (_g('brand_id')) {
            $where .= ' and g.brand_id=' . _g('brand_id');
        }
        //分类和标签搜索
        $category_id = Common::queryInt(_g('category_id'));
        $tag_id = Common::queryInt(_g('goods_tag_id'));
        if ($category_id && $tag_id) {
            $search_cat = $this->catgoryLogic->getOneById($category_id);
            $where .= ' and c.category_path like "' . $search_cat['path_id'] . '%" and t.tag_id=' . $tag_id;
        } else if ($category_id) {
            $search_cat = $this->catgoryLogic->getOneById($category_id);
            $where .= ' and c.category_path like "' . $search_cat['path_id'] . '%"';
        } else if ($tag_id) {
            $where .= '  and t.tag_id=' . $tag_id;
        }
        $c_where = $where;
        if (_g('orderby')) {
            $where .= ' group by g.id order by g.' . _g('orderby') . ' desc';
        } else {
            $where .= ' group by g.id  order by g.id desc';
        }
        if ($category_id && $tag_id) {
            $catJoinTagJoinGoodsLogic = $this->load('categoryRelJoinTagRelJoinGoods');
            $count = $catJoinTagJoinGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $catJoinTagJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else if ($category_id) {
            $catJoinGoodsLogic = $this->load('goodsCategoryRelJoinGoods');
            $count = $catJoinGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $catJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else if ($tag_id) {
            $tagJoinGoodsLogic = $this->load('goodsTagRelJoinGoods');
            $count = $tagJoinGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $tagJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else {
            $backGoodsLogic = $this->load('backGoods');
            $count = $backGoodsLogic->getCount($c_where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $results = $backGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        }
        $goods_ids = array();
        $type_ids = array();
        foreach ($results as $value) {
            $goods_ids[] = $value['id'];
            if ($value['type_id']) {
                $type_ids[$value['type_id']] = $value['type_id'];
            }
        }
        $goods_tags = array();
        $rel_categories = array();
        if (!empty($goods_ids)) {
            $tag_cond = 'goods_id in (' . implode(',', $goods_ids) . ')';
            $tags = $this->goodsTagRelLogic->findAll($tag_cond);
            foreach ($tags as $value) {
                $goods_tags[$value['goods_id']][$value['tag_id']] = $value['tag_id'];
            }

            $c_cond = 'g.goods_id in(' . implode(',', $goods_ids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
        $goods_types = array();
        if (count($type_ids)) {
            $goods_types = $this->goodsTypeLogic->findAll('id in (' . implode(',', $type_ids) . ')', true);
        }
        $goodsTags = $this->goodsTagLogic->findAll('status=1 order by listorder desc', true);
        $allcate = $this->catgoryLogic->findAll('parent_id>=0', false, '', array('id', 'base_name'));
        $allcatejson = json_encode($allcate);
        $allcatejson = str_replace('\"', '', $allcatejson);
        $allcatejson = str_replace('\'', '', $allcatejson);
        Core::$tpl->set("res", $results);
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("goodstags", $goods_tags);
        Core::$tpl->set("taglist", $goodsTags);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("brands", $this->brandLogic->findAll('', true));
        Core::$tpl->set("categories", $this->catgoryLogic->findAll('parent_id=0'));
        Core::$tpl->set("allcatejson", $allcatejson);
        Core::$tpl->set('search', $search);
        Core::$tpl->set("pages", $page_data);
    }

    /**
     * 弹出商品选择列表
     * ajax 
     */
    public function actionAddMasterSaleValue() {
        if (_p()) {
            $staus = 0;
            $parent_id = Common::queryInt(_p('id'));
            $property = $this->propertyLogic->getOneById($parent_id);
            if (!$property) {
                echo json_encode(array('status' => $staus));
                exit;
            } else {
                $base_name = _p('base_name');
                $res = $this->propertyLogic->getOne('parent_id=' . $parent_id . ' and base_name="' . $base_name . '"');
                if ($res) {
                    $property = array(
                        'id' => $res['id'],
                        'name' => $res['base_name'],
                        'type' => _p('type'),
                        'parent_id' => $parent_id,
                    );
                    echo json_encode(array('status' => 2, 'data' => $property));
                    exit;
                }
            }
            $base_name = _p('base_name');
            $languages = $this->langLogic->findALL('status=1', true);
            $map = Zhtx::createDataMap();
            $map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $map->addEntry('parent_id', Common::queryInt($parent_id), DB::INT);
            $map->addEntry('image', "", DB::VARCHAR);
            $map->addEntry('value_type', $property['value_type'], DB::INT);
            $map->addEntry('type', $property['type'], DB::INT);
            $map->addEntry('required', $property['required'], DB::INT);
            $map->addEntry('search', $property['search'], DB::INT);
            $map->addEntry('create_time', SYS_TIME, DB::INT);
            $map->addEntry('status', 1, DB::INT);
            $map->addEntry('listorder', 0, DB::INT);
            $result = $this->propertyLogic->insert($map);
            if ($result) {
                foreach ($languages as $item) {
                    $propertyLanguage = Zhtx::createDataMap();
                    $propertyLanguage->addEntry('property_id', $result, DB::INT);
                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $propertyLanguage->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
                    $this->load('propertyLanguage')->insert($propertyLanguage);
                }
                $update_map = Zhtx::createDataMap();
                $update_map->addEntry('listorder', 0, DB::INT);
                $this->propertyLogic->updateById($update_map, $result);
                $staus = 1;
                $property = array(
                    'id' => $result,
                    'name' => $base_name,
                    'type' => _p('type'),
                    'parent_id' => $parent_id,
                );
            }
            echo json_encode(array('status' => $staus, 'data' => $property));
            exit;
        } else {
            $id = Common::queryInt(_g('parent_id'));
            $goods_id = Common::queryInt(_g('goods_id'), 0);
            $type = Common::queryInt(_g('type'));
            $property = $this->propertyLogic->getOne('id=' . $id);
            $skus = $this->skuJoinProductLogic->getListByGoodsId($goods_id);
            $sku_master_id_array = array(0); //master_id的集合
            $sku_sale_id_array = array(0); //sale_id的集合
            foreach ($skus as $sku) {
                $sku_code_split = explode('_', $sku['sku_code']);
                $sku_master_id_array[$sku_code_split[0]] = $sku_code_split[0];
                $sku_sale_id_array[$sku_code_split[1]] = $sku_code_split[1];
            }
            $where = 'status=1 and listorder<=0 and parent_id=' . $id;
            if ($goods_id) {
                if (($type == 1 || $type == 3) && $sku_master_id_array) {
                    $where .= ' and id not in (' . implode(',', $sku_master_id_array) . ')';
                } else if ($sku_sale_id_array) {
                    $where .= ' and id not in (' . implode(',', $sku_sale_id_array) . ')';
                }
            }
            $other_property = $this->propertyLogic->findAll($where);
            Core::$tpl->set('otherproperty', $other_property);
            Core::$tpl->set('property', $property);
            Core::$tpl->set('callback', _g('callback'));
            Core::$tpl->set('type', $type);
            Core::$htmlFile = 'product/addmastersalevalue';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 弹出商品选择列表
     * ajax 
     */
    public function actionPublicRelGoods() {
        //分页用的参数
        $page_size = 15;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'g.status=1';
        if (_g('base_name')) {
            $where .= ' and g.base_name like "%' . Common::strEscape(_g('base_name')) . '%"';
        }
        if (_g('codeno')) {
            $where .= ' and g.codeno ="' . _g('codeno') . '"';
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and g.up_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and g.up_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and g.up_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('brand_id')) {
            $where .= ' and g.brand_id=' . _g('brand_id');
        }
        if (_g('category_id')) {
//       $categoryRel = $this->goodsCatRelLogic->findAll('goods_category_id=' . _g('category_id'));
//       $goods_ids   = array();
//       foreach($categoryRel as $val)
//       {
//         $goods_ids[] = $val['goods_id'];
//       }
//       if(!empty($goods_ids))
//       {
//          $where .= ' and id in (' . implode(',', $goods_ids) . ')';
//       }       
            $search_cat = $this->catgoryLogic->getOneById(_g('category_id'));
            $where .= ' and c.category_path like "' . $search_cat['path_id'] . '%"';
        }
        if (_g('goods_id')) {
            $where .= ' and g.id != ' . _g('goods_id');
        }
        if (_g('special_id')) {
            $where .= ' and g.special_offer_id=0';
        }
        if (_g('psize')) {
            $page_size = Common::queryInt(_g('psize'));
        }
        //分页
        //$count     = $this->goodsLogic->getCount($where);
        //$page_data = Common::getPages($count, $curr_page, $page_size);
        if (_g('orderby')) {
            $where .= ' order by g.' . _g('orderby') . ' desc';
        }
        //$where .= ' limit '. ($curr_page-1) * $page_size . ', '. $page_size;

        if (_g('category_id')) {
            $catJoinGoodsLogic = $this->load('goodsCategoryRelJoinGoods');
            $count = $catJoinGoodsLogic->getCount($where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $goodslist = $catJoinGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        } else {
            $backGoodsLogic = $this->load('backGoods');
            $count = $backGoodsLogic->getCount($where);
            $page_data = Common::getPages($count, $curr_page, $page_size);
            $goodslist = $backGoodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        }

        //$goodslist = $this->goodsLogic->findAll($where);
        $allcate = $this->catgoryLogic->findAll('parent_id>=0', false, '', array('id', 'base_name'));
        $allcatejson = json_encode($allcate);
        $allcatejson = str_replace('\"', '', $allcatejson);
        $allcatejson = str_replace('\'', '', $allcatejson);
        Core::$tpl->set('allcatejson', $allcatejson);
        Core::$tpl->set('goodslist', $goodslist);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('brands', $this->brandLogic->findAll());
        Core::$tpl->set('categories', $this->catgoryLogic->findAll());
        Core::$tpl->set('callback', _g('callback'));
        Core::$htmlFile = 'product/relationgoods';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 构造商品关联的列表
     * ajax 
     */
    public function actionPublicGetRelGoods() {
        if (_p('goods_ids')) {
            $goods_id = _p('goods_ids');
            $goods_array = explode(",", $goods_id);
            $goods_array = array_filter($goods_array);
            $ids = join(",", $goods_array);
            $where = 'id in(' . $ids . ')';
            $cols = array('id', 'base_name', 'image', 'codeno', 'listorder');
            $goodslist = $this->goodsLogic->getCols($where, $cols);
        }
        $return = array(
            'status' => 1,
            'goods_list' => $goodslist,
        );
        echo json_encode($return);
    }

    /**
     * 获取商品关联的分类
     * @return type 
     */
    public function actionGetCategories() {
        $goods_id = Common::queryInt(_g('goods_id'));
        return $this->goodsCatRelLogic->getCategoriesByGoodsId($goods_id);
    }

    /**
     * 
     * 获取取赠品列表 弹窗
     *  
     */
    public function actionPublicGetGift() {
        //分页用的参数
        $page_size = 15;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('base_name')) {
            $where .= ' and base_name like "%' . Common::strEscape(_g('base_name')) . '%"';
        }
        if (_g('codeno')) {
            $where .= ' and codeno ="' . _g('codeno') . '"';
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and up_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and up_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and up_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('brand_id')) {
            $where .= ' and brand_id=' . _g('brand_id');
        }
        if (_g('category_id')) {
            $categoryRel = $this->goodsCatRelLogic->findAll('goods_category_id=' . _g('category_id'));
            $goods_ids = array();
            foreach ($categoryRel as $val) {
                $goods_ids[] = $val['goods_id'];
            }
            if (!empty($goods_ids)) {
                $where .= ' and id in (' . implode(',', $goods_ids) . ')';
            }
        }
        if (_g('psize')) {
            $page_size = Common::queryInt(_g('psize'));
        }
        //分页
        $count = $this->goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        if (_g('orderby')) {
            $where .= ' order by ' . _g('orderby') . ' desc';
        }
        $where .= ' limit ' . ($curr_page - 1) * $page_size . ', ' . $page_size;
        $goodslist = $this->goodsLogic->findAll($where, TRUE);
        Core::$tpl->set('goodslist', $goodslist);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('brands', $this->brandLogic->findAll());
        Core::$tpl->set('categories', $this->catgoryLogic->findAll());
        if (_g('goods')) {
            Core::$htmlFile = 'product/goods';
        } else {
            Core::$tpl->set('index', Common::queryInt(_g('key'), 1));
            Core::$htmlFile = 'product/gift';
        }
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 批量上下架 
     */
    public function actionBatchUpDown() {
        $goods_ids = _p('ids');
        $tag = _p('tag') ? _p('tag') : 'up';
        $flag = 0;
        if (!empty($goods_ids)) {
            $lang_data = array();
            $ids_str = implode(',', $goods_ids);
            $cond = 'goods_id in (' . $ids_str . ')';
            $status = $tag == 'up' ? 1 : 0;
            $goods_cond = 'id in (' . $ids_str . ')';
            $goods_map = Zhtx::createDataMap();
            $goods_map->addEntry('status', $status, DB::INT);
            $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
            if ($tag == 'up') {
                $lang_data['up_time'] = SYS_TIME;
                $lang_data['status'] = 1;
                $goods_map->addEntry('up_time', SYS_TIME, DB::INT);
            } else {
                $lang_data['status'] = 0;
                $goods_map->addEntry('down_time', SYS_TIME, DB::INT);
            }
            $this->goodsLogic->update($goods_map, $goods_cond);
            //站点更新
            $this->goodsLangLogic->saveByCond($lang_data, 'goods_id in (' . $ids_str . ')');
            // 清空缓存
            foreach ($goods_ids as $goods_id) {
                $this->goodsLangLogic->updateCache($goods_id);
            }
            $flag = 1;
        }

        echo $flag;
    }

    /**
     * 批量更新价格
     */
    public function actionBatchPrice() {
        $goods_ids = _p('ids');
        $target_name = _p('target_name');
        $target_value = _p('target_value');
        $type = _p('type');
        $flag = 0;
        if (!empty($goods_ids)) {
            $ids_str = implode(',', $goods_ids);
            $cond = 'goods_id in (' . $ids_str . ')';
            $goods_cond = 'id in (' . $ids_str . ')';
            if ($type == 1) {
                $map = Zhtx::createDataMap();
                $map->addEntry($target_name, 0, DB::DECIMAL);
                $map->addEntry('update_time', SYS_TIME, DB::INT);
                $this->skuLogic->update($map, $cond);
                $goods_map = Zhtx::createDataMap();
                $goods_map->addEntry($target_name, $target_value, DB::DECIMAL);
                $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                $this->goodsLogic->update($goods_map, $goods_cond);
                if ($target_name == 'price') {
                    $lang_map = Zhtx::createDataMap();
                    $lang_map->addEntry($target_name, $target_value, DB::DECIMAL);
                    $this->goodsLangLogic->update($lang_map, 'goods_id in (' . $ids_str . ')');
                }
                $flag = 1;
            } else if ($type == 2) {
                $operators = _p('operators');
                $source = _p('source');
                $skulist = $this->skuLogic->findAll($cond);
                $map = Zhtx::createDataMap();
                foreach ($skulist as $sku) {
                    if ($operators == '+') {
                        $value = $sku[$source] + $target_value;
                    } else if ($operators == '*') {
                        $value = $sku[$source] * $target_value;
                    } else if ($operators == '-') {
                        $value = $sku[$source] - $target_value;
                    }
                    $map->addEntry($target_name, 0, DB::DECIMAL);
                    $map->addEntry('update_time', SYS_TIME, DB::INT);
                    $sku_res = $this->skuLogic->updateById($map, $sku['id']);
                }
                $goodslist = $this->goodsLogic->findAll($goods_cond);
                $goods_map = Zhtx::createDataMap();
                foreach ($goodslist as $goods) {
                    if ($operators == '+') {
                        $value = $goods[$source] + $target_value;
                    } else if ($operators == '*') {
                        $value = $goods[$source] * $target_value;
                    } else if ($operators == '-') {
                        $value = $goods[$source] - $target_value;
                    }
                    $goods_map->addEntry($target_name, $value, DB::INT);
                    $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                    $this->goodsLogic->updateById($goods_map, $goods['id']);
                    if ($target_name == 'price') {
                        $lang_map = Zhtx::createDataMap();
                        $lang_map->addEntry($target_name, $value, DB::DECIMAL);
                        $this->goodsLangLogic->update($lang_map, 'goods_id = ' . $goods['id']);
                    }
                    $flag = 1;
                }
            }
            // 清空缓存
            foreach ($goods_ids as $goods_id) {
                $this->goodsLangLogic->updateCache($goods_id);
            }
        }
        echo $flag;
    }

    /**
     * 批量更新库存
     */
    public function actionBatchStock() {
        $goods_ids = _p('ids');
        $target_value = _p('target_value');
        $flag = 0;
        if (!empty($goods_ids)) {
            $ids_str = implode(',', $goods_ids);
            $cond = 'goods_id in (' . $ids_str . ')';
            $goods_stock = array();
                $map = Zhtx::createDataMap();
                $map->addEntry('stock_nums', $target_value, DB::DECIMAL);
                $map->addEntry('update_time', SYS_TIME, DB::INT);
                $this->skuLogic->update($map, $cond);
                foreach ($this->skuLogic->findAll($cond) as $sku) {
                    $goods_stock[$sku['goods_id']][] = $sku['stock_nums'];
                }
            $goods_map = Zhtx::createDataMap();
            foreach ($goods_stock as $gkey => $goods) {
                $stock = array_sum($goods);
                $goods_map->addEntry('stock_nums', array_sum($goods), DB::INT);
                $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                $this->goodsLogic->updateById($goods_map, $gkey);
                $lang_data['status'] = $stock == 0 ? 0 : 1;
                $this->goodsLangLogic->saveByCond($lang_data, 'goods_id=' . $gkey);
            }
            // 清空缓存
            foreach ($goods_ids as $goods_id) {
                $this->goodsLangLogic->updateCache($goods_id);
            }
            $flag = 1;
        }
        echo $flag;
    }

    /**
     * 批量更新品牌
     */
    public function actionBatchBrand() {
        $goods_ids = _p('ids');
        $brand_id = _p('brand_id');
        $flag = 0;
        if (!empty($goods_ids) && $brand_id) {
            $brand = $this->brandLogic->getOneById($brand_id);
            if ($brand) {
                $goods_map = Zhtx::createDataMap();
                foreach ($goods_ids as $id) {
                    $goods_map->addEntry('brand_id', $brand_id, DB::INT);
                    $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                    $this->goodsLogic->updateById($goods_map, $id);
                    //清空缓存
                    $this->goodsLangLogic->updateCache($id);
                }
                $flag = 1;
            }
        }
        echo $flag;
    }

    /**
     * 批量更新重量
     */
    public function actionBatchWeight() {
        $goods_ids = _p('ids');
        $target_value = _p('target_value');
        $type = _p('type');
        $flag = 0;
        if (!empty($goods_ids)) {
            $ids_str = implode(',', $goods_ids);
            $cond = 'goods_id in (' . $ids_str . ')';
            $goods_cond = 'id in (' . $ids_str . ')';
            if ($type == 1) {
                //跟新goods表
                $goodsmap = Zhtx::createDataMap();
                $goodsmap->addEntry('weight', $target_value, DB::DECIMAL);
                $goodsmap->addEntry('modify_time', SYS_TIME, DB::INT);
                $this->goodsLogic->update($goodsmap, $goods_cond);
                //批量更新重量sku默认为0
                $map = Zhtx::createDataMap();
                $map->addEntry('weight', 0, DB::DECIMAL);
                $map->addEntry('update_time', SYS_TIME, DB::INT);
                $this->skuLogic->update($map, $cond);
            } else if ($type == 2) {
                $operators = _p('operators');
                $goodslist = $this->goodsLogic->findAll($goods_cond);
                $goodsmap = Zhtx::createDataMap();
                foreach ($goodslist as $good) {
                    if ($operators == '+') {
                        $value = $good['weight'] + $target_value;
                    } else if ($operators == '*') {
                        $value = $good['weight'] * $target_value;
                    } else if ($operators == '-') {
                        $value = $good['weight'] - $target_value;
                    }
                    $goodsmap->addEntry('weight', $value, DB::INT);
                    $goodsmap->addEntry('modify_time', SYS_TIME, DB::INT);
                    $this->goodsLogic->updateById($goodsmap, $good['id']);
                }
                //批量更新重量sku默认为0
                $map = Zhtx::createDataMap();
                $map->addEntry('weight', 0, DB::DECIMAL);
                $map->addEntry('update_time', SYS_TIME, DB::INT);
                $this->skuLogic->update($map, $cond);
            }
            // 清空缓存
            foreach ($goods_ids as $goods_id) {
                $this->goodsLangLogic->updateCache($goods_id);
            }
            $flag = 1;
        }
        echo $flag;
    }

    /**
     * 批量更新分类
     */
    public function actionBatchCategory() {
        $goods_ids = _p('ids');
        $category_id = _p('category_id');
        $flag = 0;
        if (!empty($goods_ids) && $category_id) {
            $category = $this->catgoryLogic->getOneById($category_id);
            if ($category) {
                $cond = 'goods_id in (' . implode(',', $goods_ids) . ')';
                $res = $this->goodsCatRelLogic->delete($cond);
                if ($res) {
                    $goods_map = Zhtx::createDataMap();
                    foreach ($goods_ids as $id) {
                        $path = Common::strEscape($category['path_id']);
                        $goods_map->addEntry('goods_id', $id, DB::INT);
                        $goods_map->addEntry('goods_category_id', $category['id'], DB::INT);
                        $goods_map->addEntry('category_path', $path, DB::VARCHAR);
                        $this->goodsCatRelLogic->insert($goods_map);
                        $this->goodsLangLogic->saveByCond(array('category_path' => $path), 'goods_id=' . $id);
                        //删除缓存
                        $this->goodsLangLogic->updateCache($id);
                    }
                    $flag = 1;
                }
            }
        }
        echo $flag;
    }

    /**
     * 批量更新标签
     */
    public function actionBatchTag() {
        $goods_ids = _p('ids');
        $tag_ids = _p('tag_ids');
        $flag = 0;
        if (!empty($goods_ids) && !empty($tag_ids)) {
            $cond = 'goods_id in (' . implode(',', $goods_ids) . ')';
            $res = $this->goodsTagRelLogic->delete($cond);
            if ($res) {
                $goods_map = Zhtx::createDataMap();
                foreach ($goods_ids as $id) {
                    $goods_map->addEntry('goods_id', $id, DB::INT);
                    foreach ($tag_ids as $tag_id) {
                        $goods_map->addEntry('tag_id', $tag_id, DB::INT);
                        $this->goodsTagRelLogic->insert($goods_map);
                    }
                    //清空缓存
                    $this->goodsLangLogic->updateCache($id);
                }
                $flag = 1;
            }
        }
        echo $flag;
    }

    public function actionDel() {
        global $thumb_config;
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['pease_select_delete_obj'];
        if (!empty($ids)) {
            $num = 0;
            $i = 0;
            $commentLogic = $this->load('goodsComment');
            $outStocklogic = $this->load('outStock');
            $giftLogic = $this->load('offerGift');
            $offerItemlogic = $this->load('offerItem');
            
            $productimages = $this->productImageLogic->findAll("goods_id in(".join(',',$ids).")");
            $thumbs = $thumb_config;
            $themes = $this->load('theme')->findAll('', true);
            foreach($themes as $key => $rows)
            {
                if(is_file(APP_ROOT.'res/front/'.$rows['theme_dir'].'/template.conf.php'))
                {
                    require_once(APP_ROOT.'res/front/'.$rows['theme_dir'].'/template.conf.php');
                    if($result['thumb_config'])
                    {
                        $thumbs = array_merge($thumbs,$result['thumb_config']);
                    }
                }
            }
            $thumbs = array_unique($thumbs);            
            foreach($productimages as $key => $rows)
            {
                if(is_file(UPLOAD_DIR.$rows['image']))
                {
                    unlink(UPLOAD_DIR.$rows['image']);
                }
                foreach($thumbs as $key1 => $thumb)
                {
                    if(is_file(UPLOAD_DIR.'thumb/'.$thumb.'/'.$rows['image']) && $thumb != '84x84')
                    {
                        unlink(UPLOAD_DIR.'thumb/'.$thumb.'/'.$rows['image']);
                    }
                }
            }
            
            foreach ($ids as $id) {
                $goods = $this->goodsLogic->getOneById($id);
                if (!$goods) {
                    $i++;
                } else {
                    $res = $this->goodsLogic->delete('id=' . $id);
                    if ($res) {
                        $this->load('urlAlisa')->deleteDiyUrl($goods['page_url']);
                        $this->goodsLangLogic->delete('goods_id=' . $id);
                        $this->skuLogic->delete('goods_id=' . $id);
                        $this->productLogic->delete('goods_id=' . $id);
                        $this->productImageLogic->delete('goods_id=' . $id);
                        $this->goodsProRelLogic->delete('goods_id=' . $id);
                        $this->goodsCatRelLogic->delete('goods_id=' . $id);
                        $this->goodsTagRelLogic->delete('goods_id=' . $id);
                        $this->goodsSelfRelLogic->delete('goods_id=' . $id);
                        $this->topicTagGoodsRelLogic->delete('goods_id=' . $id);
                        $this->channelTagGoodsRelLogic->delete('goods_id=' . $id);
                        $this->goodsPackageSaleGoodsRelLogic->delete('goods_id=' . $id);
                        $commentLogic->delete('goods_id=' . $id);
                        $outStocklogic->delete('goods_id=' . $id);
                        $giftLogic->delete('goods_id=' . $id);
                        $offerItemlogic->delete('goods_id=' . $id);
                        $this->load('UserCart')->delete('goods_id=' . $id);
                        $this->load('UserFavorite')->delete('goods_id=' . $id);

                        $picklist_res = $this->load('GoodsPackageSale')->findAll('goods_id=' . $id);
                        foreach ($picklist_res as $value) {
                            $res = $this->load('goodsPackageSale')->delete(" id = " . $value['id']);
                            $this->load('goodsPackageSaleGoodsRel')->delete(" package_sale_id = " . $value['id']);
                            $this->load('goodsPackageSaleLanguage')->delete(" package_sale_id = " . $value['id']);
                        }
                        //清空缓存
                        $this->goodsLangLogic->updateCache($id);
                        $num++;
                    }
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'] . ', ' . $lang['delete_failure'] . $i . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * 商品搜索 ajax 
     */
    public function actionSearch() {
        $search_key = _p('search_cond');
        $search_value = _p('search_value');
        $cond = '1=1';
        if ($search_key && $search_value) {
            switch ($search_key) {
                case 'base_name' :
                    $cond .= ' and base_name="' . $search_value . '"';
                    break;
                case 'codeno':
                    $cond .= ' and codeno="' . $search_value . '"';
                    break;
                case 'keywords':
                    $cond .= ' and base_name like "%' . $search_value . '%"';
            }
        }
        $goodslist = array();
        $goodslist = $this->goodsLogic->findAll($cond);
        echo json_encode($goodslist);
    }

    /**
     * 修改排序
     * ajax 
     */
    public function actionPublicEditSort() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->goodsLogic->update($map, 'id=' . $id);
        $this->goodsLangLogic->update($map, 'goods_id=' . $id);
        //清除相关缓存
        $this->goodsLangLogic->updateCache($id);
        echo $res ? 1 : 0;
    }

    /**
     * 修改销售价
     * ajax 
     */
    public function actionPublicEditPrice() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $price = _p('price');
        $goods = $this->goodsLogic->getOne("id=" . $id);
        $old_price = $goods['old_price'];
        $map = Zhtx::createDataMap();
        $map->addEntry('price', $price, DB::DECIMAL);
		
		if($goods['special_status'])
		{
			$discount = (((float) $price) / ((float) $old_price)) * 10;
            $map->addEntry('discount', $discount, DB::DECIMAL);
		}
		else
		{
			 $map->addEntry('old_price', $price, DB::DECIMAL);

		}
		
        $res = $this->goodsLogic->update($map, 'id=' . $id);
        if ($res) {
            $map = Zhtx::createDataMap();
            $map->addEntry('price', $price, DB::DECIMAL);
            $this->goodsLangLogic->update($map, 'goods_id=' . $id);
        }
        //清除相关缓存
        $this->goodsLangLogic->updateCache($id);
        echo $res ? 1 : 0;
    }

    /**
     * 修改元原价价
     * ajax 
     */
    public function actionPublicEditOldPrice() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $old_price = _p('old_price');
        $goods = $this->goodsLogic->getOne("id=" . $id);
        $price = $goods['price'];
        $map = Zhtx::createDataMap();
        $map->addEntry('old_price', $old_price, DB::DECIMAL);
        if ((float) $old_price > 0 && (float) $price > 0) {
            $discount = (((float) $price) / ((float) $old_price)) * 10;
            $map->addEntry('discount', $discount, DB::DECIMAL);
        }
        $res = $this->goodsLogic->update($map, 'id=' . $id);
        if ($res) {
            $map = Zhtx::createDataMap();
            $map->addEntry('old_price', $old_price, DB::DECIMAL);
            $this->goodsLangLogic->update($map, 'goods_id=' . $id);
        }
        //清除相关缓存
        $this->goodsLangLogic->updateCache($id);
        echo $res ? 1 : 0;
    }

    /**
     * 修改up_time
     * ajax 
     */
    public function actionUpdateUpTime() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $map = Zhtx::createDataMap();
        $map->addEntry('up_time', SYS_TIME, DB::INT);
        $res = $this->goodsLogic->update($map, 'id=' . $id);
        $this->goodsLangLogic->update($map, 'goods_id=' . $id);
        //清除相关缓存
        $this->goodsLangLogic->updateCache($id);
        echo $res ? 1 : 0;
    }

    public function actionPublicGetGoodsTpl() {
        $category_id = Common::queryInt(_p('category_id'));
        $catlogic = $this->load('goodsCategoryJoinLang');
        $cond = 'c.id=' . $category_id;
        $list = $catlogic->findAll($cond);
        foreach ($list as $value) {
            
        }
    }

    /**
     * ajax 更新状态
     * 更新商品会一起更新单品及sku商品
     */
    public function actionPublicEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $data = array();
        $sku_data = array();
        if ($status == 1) {
            $data['status'] = 1;
            $data['up_time'] = SYS_TIME;
            $sku_data['status'] = 1;
            $map->addEntry('up_time', SYS_TIME, DB::INT);
        } else {
            $sku_data['status'] = 0;
            $data['status'] = 0;
            $map->addEntry('down_time', SYS_TIME, DB::INT);
        }
        $res = $this->load('goods')->updateById($map, $id);
        if ($res) {
            $cond = 'goods_id=' . $id;
            $this->load('product')->saveByCond($sku_data, $cond);
            $this->load('sku')->saveByCond($sku_data, $cond);
            $this->goodsLangLogic->saveByCond($data, $cond);
            //清除相关缓存
            $this->goodsLangLogic->updateCache($id);
        }
        echo $res ? 1 : 0;
    }

    public function actionPublicGetCatInfo() {
        $tr_id = Common::queryInt(_g('tr_id'));
        Core::$tpl->set('tr_id', $tr_id + 1);
        Core::$htmlFile = 'product/category';
        Core::$isdisplay = 0;
        echo Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    public function actionTest() {
        Core::$htmlFile = 'product/test';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 缺货登记商品 
     */
    public function actionOutStock() {
        $outStockLogic = $this->load('outStock');
        $where = '1=1 ';
        $search_value = Common::strEscape(_g('search_value'));
        if ($search_value) {
            $where .= ' and base_name like "%' . $search_value . '%" or goods_id like "%' . $search_value . '%"';
        }
        $where .= ' order by create_time desc';
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $count = $outStockLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results = $outStockLogic->getCurrentDatas($where, $page_size, $curr_page);
        $goods_ids = array(0);
        foreach ($results as $value) {
            $goods_ids[] = $value['goods_id'];
        }
        $cols = array('id', 'codeno', 'image');
        $cond = 'id in(' . implode(',', $goods_ids) . ')';
        $goodslist = $this->goodsLogic->getCols($cond, $cols, TRUE);
        $sku_cond = 'goods_id in(' . implode(',', $goods_ids) . ')';
        //sku现有库存
        $skus = $this->skuLogic->getCols($sku_cond, array('goods_id', 'sku_code', 'stock_nums'));
        $cur_stock = array();
        foreach ($skus as $sku) {
            $cur_stock[$sku['goods_id']][$sku['sku_code']] = $sku['stock_nums'];
        }
        Core::$tpl->set('res', $results);
        Core::$tpl->set('goodslist', $goodslist);
        Core::$tpl->set('stocks', $cur_stock);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 缺货登记sku
     */
    public function actionSkuOutStock() {
        $outStockLogic = $this->load('skuJoinGoods');
        $where = '1=1 and s.stock_nums=0 ';
        $search_value = Common::strEscape(_g('search_value'));
        if ($search_value) {
            $where .= ' and (g.base_name like "%' . $search_value . '%" or s.goods_id like "%' . $search_value . '%" or g.codeno like "%' . $search_value . '%")';
        }
        $where .= ' order by s.create_time desc';
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $count = $outStockLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results = $outStockLogic->getCurrentDatas($where, $page_size, $curr_page);
//        print_r($results);exit;
        $sku_ids = array(0);
        foreach ($results as $v) {
            if ($v['sku_code']) {
                $sku_code = $v['sku_code'];
                $attr = $this->load('property');
                $property_ids = str_replace('_', ',', $sku_code);
                $properties = $attr->findAll('id in (' . $property_ids . ')');
                $son = array();
                $parent_ids = array();
                foreach ($properties as $pro) {
                    $parent_ids[] = $pro['parent_id'];
                    $son[$pro['parent_id']] = $pro['base_name'];
                }
                $parents = $attr->findAll('id in (' . implode(',', $parent_ids) . ')', true);
                $result = array();
                foreach ($son as $key => $value) {
                    $result[] = $parents[$key]['base_name'] . ' : ' . $value . ' ';
                }
                $property[$v['sku_id']] = $result;
            }
        }
        Core::$tpl->set('res', $results);
        Core::$tpl->set('pro', $property);
        Core::$tpl->set('pages', $page_data);
        Core::$htmlFile = 'product/skuoutstock';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    //删除sku并更新库存
    public function actionSkuOutStockDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $sku = $this->skuLogic->getOne(' id=' . (int) $id);
                $goods_id = $sku['goods_id'];
                $delete_sku_cond = ' id =' . (int) $id;
                $del_sku_res = $this->skuLogic->delete($delete_sku_cond);
                if ($del_sku_res) {
                    //更新更新goods表
                    $this->load('goods')->updateStockNums($goods_id);
                    //清空缓存
                    $this->goodsLangLogic->updateCache($goods_id);
                    $num++;
                }
            }
            $staus = 1;
            $flag = '成功删除' . $num . '个SKU';
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    //编辑sku数并更新库存
    public function actionPublicEditStockNum() {
        $suk_id = Common::queryInt(_p('suk_id'));
        if (!$suk_id) {
            echo 0;
            return;
        }
        $num = _p('num');
        $sku = $this->skuLogic->getOne(' id=' . (int) $suk_id);
        $goods_id = $sku['goods_id'];
        $sku_data = array(
            'stock_nums' => $num,
            'status' => 1,
        );
        $sku_res = $this->skuLogic->save($sku_data, (int) $suk_id);
        if ($sku_res) {
            //更新更新goods表
            $this->load('goods')->updateStockNums($goods_id);
            //清空缓存
            $this->goodsLangLogic->updateCache($goods_id);
            $num++;
        }
        echo $sku_res ? 1 : 0;
    }

    /**
     * 缺货登记商品 数据删除 
     */
    public function actionOutStockDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $outStockLogic = $this->load('outStock');
                $res = $outStockLogic->delete('id=' . $id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * 弹出sku商品选择列表
     * ajax 
     */
    public function actionPublicGetSku() {
        //分页用的参数
        $page_size = 10;
        $curr_page = Common::queryInt(_g('page'), 1);
        $language_id = Common::queryInt(_g('language_id'));
        $where = '1=1';
        if (_g('base_name')) {
            $where .= ' and base_name like "%' . Common::strEscape(_g('base_name')) . '%"';
        }
        if (_g('codeno')) {
            $where .= ' and codeno ="' . _g('codeno') . '"';
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and up_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and up_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and up_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('brand_id')) {
            $where .= ' and brand_id=' . _g('brand_id');
        }
        if (_g('category_id')) {
            $categoryRel = $this->goodsCatRelLogic->findAll('goods_category_id=' . _g('category_id'));
            $goods_ids = array();
            foreach ($categoryRel as $val) {
                $goods_ids[] = $val['goods_id'];
            }
            if (!empty($goods_ids)) {
                $where .= ' and id in (' . implode(',', $goods_ids) . ')';
            }
        }
        if (_g('goods_id')) {
            $where .= ' and id != ' . _g('goods_id');
        }
        if (_g('psize')) {
            $page_size = Common::queryInt(_g('psize'));
        }
        $where .= ' and stock_nums>0  and status>0';
        //分页
        $count = $this->goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        if (_g('orderby')) {
            $where .= ' order by ' . _g('orderby') . ' desc';
        }
        $where .= ' limit ' . ($curr_page - 1) * $page_size . ', ' . $page_size;
        $goodslist = $this->goodsLogic->findAll($where);
        $propertyJoinLangLogic = $this->load('propertyJoinLanguage');
        $skulist = array();
        foreach ($goodslist as $goods) {
            $skulist[$goods['id']]['attributes'] = $propertyJoinLangLogic->getPropertyByGoodsId($goods['id'], $language_id);
        }
        Core::$tpl->set('goodslist', $goodslist);
        Core::$tpl->set('skulist', $skulist);
        Core::$tpl->set('order_id', Common::queryInt(_g('order_id')));
        Core::$tpl->set('language_id', $language_id);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('brands', $this->brandLogic->findAll());
        Core::$tpl->set('categories', $this->catgoryLogic->findAll());
        Core::$htmlFile = 'product/goodssku';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    public function actionPublicCheckSku() {
        $goods_id = Common::queryInt(_p('goods_id'));
        $sku_code = _p('sku_code');
        $sku_cond = 'goods_id=' . $goods_id . ' and sku_code ="' . $sku_code . '"';
        if ($this->skuLogic->getCount($sku_cond)) {
            echo 1;
            return;
        }
        echo 0;
        return;
    }

    /**
     * 
     * 获取取赠品列表 弹窗
     *  
     */
    public function actionPublicDlgGoods() {
        //分页用的参数
        $page_size = 10;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('base_name')) {
            $where .= ' and base_name like "%' . Common::strEscape(_g('base_name')) . '%"';
        }
        if (_g('codeno')) {
            $where .= ' and codeno ="' . _g('codeno') . '"';
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and up_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and up_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and up_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('brand_id')) {
            $where .= ' and brand_id=' . _g('brand_id');
        }
        if (_g('category_id')) {
            $categoryRel = $this->goodsCatRelLogic->findAll('goods_category_id=' . _g('category_id'));
            $goods_ids = array();
            foreach ($categoryRel as $val) {
                $goods_ids[] = $val['goods_id'];
            }
            if (!empty($goods_ids)) {
                $where .= ' and id in (' . implode(',', $goods_ids) . ')';
            }
        }
        if (_g('psize')) {
            $page_size = Common::queryInt(_g('psize'));
        }
        //分页
        $count = $this->goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        if (_g('orderby')) {
            $where .= ' order by ' . _g('orderby') . ' desc';
        }
        $where .= ' limit ' . ($curr_page - 1) * $page_size . ', ' . $page_size;
        $goodslist = $this->goodsLogic->findAll($where, TRUE);
        Core::$tpl->set('callback', _g('callback'));
        Core::$tpl->set('form_url', _g('form_url'));
//    $arr_ref = parse_url($_SERVER['HTTP_REFERER']);
//    Core::$tpl->set('form_url', '/'.ADMIN_ROOT.'?'.$arr_ref["query"]);
        Core::$tpl->set('goodslist', $goodslist);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('brands', $this->brandLogic->findAll());
        Core::$tpl->set('categories', $this->catgoryLogic->findAll());
        Core::$htmlFile = 'product/dlggoods';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 到货通知
     * @return type 
     */
    public function actionArrivalNotice() {
        $id = Common::queryInt(_g('id'));
        $outStockLogic = $this->load('outStock');
        $outStock = $outStockLogic->getOneById($id);
        if (!$outStock) {
            return $this->showMessage('illegal_parameters');
        }
        EventFactory::goodsArrivalAfter($outStock);
        //更新发送状态
        $outStock_data = array(
            'is_send' => 1,
            'send_time' => SYS_TIME,
        );
        $outStock_res = $outStockLogic->save($outStock_data, $id);
        return $outStock_res ? $this->success('sent_success') : $this->showMessage('sent_failure');
    }

    /**
     * 设置关联商品
     */
    public function actionSetRelGoods() {
        $relation = _p('relation');
        if ($relation) {
            $goods_id = _p('goods_id');
            $status = 0;
            foreach ($relation as $rel) {
                $rel_array = explode('_', $rel);
                if ($rel_array[0] == 'one') {
                    $relation_array = array(
                        'goods_id' => $goods_id,
                        'goods_rel_id' => $rel_array[1],
                    );
                    $res = $this->goodsSelfRelLogic->save($relation_array);
                } else if ($rel_array[0] == 'mutual') {
                    $relation_array = array(
                        'goods_id' => $goods_id,
                        'goods_rel_id' => $rel_array[1],
                    );
                    $this->goodsSelfRelLogic->save($relation_array);
                    $relation_array2 = array(
                        'goods_id' => $rel_array[1],
                        'goods_rel_id' => $goods_id,
                    );
                    $res = $this->goodsSelfRelLogic->save($relation_array2);
                }
            }
            if ($res)
                $status = 1;
            $return = array(
                'status' => $status,
                'goods_list' => $goodslist,
            );
            echo json_encode($return);
        }
    }

    /*
     * 重置类型
     */

    public function actionRemoveTypes() {
        $data = _p();
        if ($data) {
            $ids = $data['ids'];
            $ids = join(",", $ids);
            if ($ids) {
                /* 修改goods type_id = 0 */
                $goodsLogic = AppController::load('goods');
                $map = Zhtx::createDataMap();
                $map->addEntry('goods_type_id', 0, DB::INT);
                $map->addEntry('product_id', 0, DB::INT);
                $gcond = " id in (" . $ids . ")";
                $goodsLogic->update($map, $gcond);
                /* 修改 z_product_otherimage */
                $productOtherImageLogic = AppController::load('productOtherImage');
                $map = Zhtx::createDataMap();
                $map->addEntry('product_id', 0, DB::INT);
                $icond = " goods_id in (" . $ids . ")";
                $productOtherImageLogic->update($map, $icond);
                /* 删除对应的产品与属性关联数据 */
                $goodsPropertyRelLogic = AppController::load('goodsPropertyRel');
                $pcond = " goods_id in (" . $ids . ")";
                $goodsPropertyRelLogic->delete($pcond);
                /* 删除对应的SKU数据 */
                $skuLogic = AppController::load('sku');
                $scond = " goods_id in (" . $ids . ")";
                $skuLogic->delete($scond);
                echo json_encode(array("success" => true));
                exit;
            }
        }
    }

    //批量更改商品信息
    public function actionbatchmodifygoods() {
        if (_p()) {
            $cate_id = _p('select_cate_id');
            $cate_detail = $this->catgoryLogic->getOneById($cate_id);
            $cate_path = Common::strEscape($cate_detail['path_id']);
            $res = $this->goodsCatRelLogic->findAll($cond = " category_path like '" . $cate_path . "%'", 0, 0, $cols = array("goods_id"));
            $goods_ids = array();
            foreach ($res as $v) {
                $goods_ids[] = $v['goods_id'];
            }
            $goods_ids_count = count($goods_ids);
            $modify = array(
                _p('goods_codeno_check'),
                _p('goods_name_check'),
                _p('brand_id_check'),
                _p('goods_tag_id_check'),
                _p('goods_class_check'),
                _p('goods_state_check'),
                _p('goods_weight_check'),
                _p('goods_stock_check'),
                _p('goods_price_check'),
                _p('type_id_check')
            );
            foreach ($modify as $value) {
                if ($value == 'on') {
                    $is_modify = true;
                    break;
                }
            }
            if ($goods_ids_count == 0) {
                return $this->showMessage('此分类没有商品', Common::adminURL('product', 'product', 'list', array('status' => 1)));
            }
            if (!$is_modify) {
                return $this->showMessage('未选中修改项');
            }

            //分类下有商品且有修改项
            if ($goods_ids_count && $is_modify) {
                $ids_str = implode(',', $goods_ids);
                $cond = 'goods_id in (' . $ids_str . ')';
                $goods_cond = 'id in (' . $ids_str . ')';
                //批量修改商品类型
                if (_p('type_id_check') == 'on' && _p('goods_type_id')) {
                    global $cfg;
                    $goods_type_id = _p('goods_type_id'); //类型id
                    $master_sale_ids = _p('goods_type_master'); //主销售
                    $sale_ids = _p('goods_type_sale'); //副销售
//                    print_r(_p());exit;
                    //取主副销售id
                    $p_cond = 'goods_type_id=' . $goods_type_id . '  and (property_type=1 or property_type=2)';
                    $property_info = $this->goodsTypePropertyLogic->findAll($p_cond);
                    foreach ($property_info as $k => $v) {
                        if ($v['property_type'] == 1) {
                            $master_property_id = $v['property_id'];
                        } elseif ($v['property_type'] == 2) {
                            $sale_property_id = $v['property_id'];
                        }
                    }
                    $master_property_id = $master_property_id ? $master_property_id : 0;
                    $sale_property_id = $sale_property_id ? $sale_property_id : 0;
                    //有主，副销售属性
                    if ($master_sale_ids && $sale_ids) {
                        foreach ($master_sale_ids as $value) {
                            foreach ($sale_ids as $v) {
                                $skulist[$value . '_' . $v] = array(
                                    "stock" => $cfg['sites'][0]['default_stock'],
                                    "status" => 1,
                                );
                            }
                        }
                    }
                    //有主，无副销售属性
                    if ($master_sale_ids && !$sale_ids) {
                        foreach ($master_sale_ids as $value) {
                            $skulist[$value . '_' . 0] = array(
                                "stock" => $cfg['sites'][0]['default_stock'],
                                "status" => 1,
                            );
                        }
                    }
                    //无主，有副销售属性
                    if (!$master_sale_ids && $sale_ids) {
                        foreach ($sale_ids as $v) {
                            $skulist[0 . '_' . $v] = array(
                                "stock" => $cfg['sites'][0]['default_stock'],
                                "status" => 1,
                            );
                        }
                    }
                    //无主，无副销售属性
                    if (!$master_sale_ids && !$sale_ids) {
                        $skulist[0 . '_' . 0] = array(
                            "stock" => $cfg['sites'][0]['default_stock'],
                            "status" => 1,
                        );
                    }
                    foreach ($goods_ids as $id) {
                        $this->skuLogic->delete('goods_id=' . $id);
                        $this->productLogic->delete('goods_id=' . $id);
                        $good_detail = $this->goodsLogic->getOneById($id);
                        //添加sku
                        $stock_nums = 0;
                        $has_product = array();
                        $main_property = array();
                        $property_ids = array($master_property_id, $sale_property_id);
                        foreach ($skulist as $key => $value) {
                            $stock = Common::queryInt($value['stock']);
                            $price = $value['sale_price'] ? $value['sale_price'] : 0;
                            $old_price = $value['old_price'] ? $value['old_price'] : 0;
                            $cost_price = $value['cost_price'] ? $value['cost_price'] : 0;
                            $market_price = $value['market_price'] ? $value['market_price'] : 0;
                            $weight = $value['weight'] ? $value['weight'] : 0;
                            $status = Common::queryInt($value['status']);
                            $pro_array = explode('_', $key);
                            $product_id = 0;
                            if ($pro_array[0]) {
                                $main_property[$master_property_id][] = $pro_array[0];
                                $property_ids[] = $pro_array[0];
                            }
                            if ($pro_array[1]) {
                                $main_property[$sale_property_id][] = $pro_array[1];
                                $property_ids[] = $pro_array[1];
                            }

                            if (isset($has_product[$pro_array[0]])) {
                                $product_id = $has_product[$pro_array[0]];
                                $has_product[$pro_array[1]] = $product_id;
                            } else {
                                $product_data = array(
                                    'goods_id' => $id,
                                    'base_name' => $good_detail['base_name'],
                                    'property_id' => $pro_array[0],
                                );
                                $product_id = $this->load('product')->save($product_data);
                                $has_product[$pro_array[0]] = $product_id;
                                $has_product[$pro_array[1]] = $product_id;
                            }
                            if ($product_id) {
                                $sku_data = array(
                                    'goods_id' => $id,
                                    'product_id' => $product_id,
                                    'sku_code' => $key,
                                    'codeno' => Common::queryStr($value['codeno']),
                                    'stock_nums' => $stock,
                                    'price' => $price,
                                    'cost_price' => $cost_price,
                                    'market_price' => $market_price,
                                    'weight' => $weight,
                                    'status' => $status,
                                    'create_time' => SYS_TIME,
                                );
                                $this->load('sku')->save($sku_data);
                                $stock_nums+=$stock;
                            }
                        }
                        //添加sku end
                        $this->load('goodsPropertyRel')->delete('goods_id=' . $id);
                        $all_property_ids = array_filter(array_unique($property_ids));
                        if (!$all_property_ids) {
                            $all_property_ids = array(0);
                        }
                        $where = 'id in (' . implode(',', $all_property_ids) . ')';
                        $propertyArrayAsId = $this->propertyLogic->findAll($where, true);
                        //商品和属性关联
                        if ($propertyArrayAsId && $main_property) {
                            foreach ($main_property as $mkey => $item) {
                                if (is_array($item)) {
                                    $parent_property = $propertyArrayAsId[$mkey];
                                    $item = array_unique($item);
                                    foreach ($item as $val) {
                                        $current_product_id = isset($has_product[$val]) ? $has_product[$val] : $has_product[0];
                                        $com_pro_map = Zhtx::createDataMap();
                                        $com_pro_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
                                        $com_pro_map->addEntry('goods_id', $id, DB::INT);
                                        $com_pro_map->addEntry('product_id', $current_product_id, DB::INT);
                                        $com_pro_map->addEntry('property_id', $mkey, DB::INT);
                                        $com_pro_map->addEntry('property_name', Common::strEscape($parent_property['base_name']), DB::VARCHAR);
                                        $com_pro_map->addEntry('vid', $val, DB::INT);
                                        $com_pro_map->addEntry('value_name', Common::strEscape($propertyArrayAsId[$val]['base_name']), DB::VARCHAR);
                                        $com_pro_map->addEntry('property_type', $propertyArrayAsId[$val]['type'], DB::INT);
                                        $this->load('goodsPropertyRel')->insert($com_pro_map);
                                    }
                                }
                            }
                        }
                        //商品和属性关联 end
                        //更新goods表类型
                        $goods_map = Zhtx::createDataMap();
                        $goods_map->addEntry('goods_type_id', $goods_type_id, DB::INT);
                        $goods_map->addEntry('stock_nums', $stock_nums, DB::INT);
                        $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                        $this->goodsLogic->updateById($goods_map, $id);
                    }
                }
                //批量重置商品编号
                if (_p('goods_codeno_check') == 'on') {
                    $index = 0;
                    $goods_map = Zhtx::createDataMap();
                    $gl_map = Zhtx::createDataMap();
                    foreach ($goods_ids as $id) {
                        $codeno = _p('pre_codeno');
                        $codeno_start = _p("goods_codeno");
                        if ($codeno_start == "") {
                            $codeno_start = '001';
                        }
                        $strcodeno = str_pad((int) $codeno_start + $index, strlen($codeno_start), 0, STR_PAD_LEFT);
                        $codeno .= $strcodeno;
                        $exist_codeno = $this->goodsLogic->getOne((" codeno='" . $codeno . "'"));
                        if (!$exist_codeno) {
                            $goods_map->addEntry('codeno', $codeno, DB::VARCHAR);
                            $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                            $this->goodsLogic->updateById($goods_map, $id);
                            $goods_detail = $this->goodsLogic->getOne((" id=" . $id));
                            $gl_map->addEntry('search_keyword', $goods_detail['base_name'] . ' ' . $codeno, DB::VARCHAR);
                            $this->goodsLangLogic->update($gl_map, 'goods_id=' . $id);
                        }
                        $index++;
                    }
                }
                //批量重置商品名称
                if (_p('goods_name_check') == 'on') {
                    $index = 0;
                    $goods_map = Zhtx::createDataMap();
                    $p_map = Zhtx::createDataMap();
                    $gl_map = Zhtx::createDataMap();
                    foreach ($goods_ids as $id) {
                        $pre_name = _p('pre_name');
                        $goods_name_start = _p("goods_name");
                        if ($goods_name_start == "") {
                            $goods_name_start = '001';
                        }
                        $strcodeno = str_pad((int) $goods_name_start + $index, strlen($goods_name_start), 0, STR_PAD_LEFT);
                        $pre_name .= $strcodeno;
                        $exist_name = $this->goodsLogic->getOne((" base_name='" . $pre_name . "'"));
                        if (!$exist_name) {
                            $goods_map->addEntry('base_name', $pre_name, DB::VARCHAR);
                            $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                            $this->goodsLogic->updateById($goods_map, $id);
                            $p_map->addEntry('base_name', $pre_name, DB::VARCHAR);
                            $this->productLogic->update($p_map, 'goods_id=' . $id);
                            $goods_detail = $this->goodsLogic->getOne((" id=" . $id));
                            $gl_map->addEntry('base_name', $pre_name, DB::VARCHAR);
                            $gl_map->addEntry('search_keyword', $pre_name . ' ' . $goods_detail['codeno'], DB::VARCHAR);
                            $this->goodsLangLogic->update($gl_map, 'goods_id=' . $id);
                        }
                        $index++;
                    }
                }
                //批量更改品牌
                if (_p('brand_id_check') == 'on') {
                    $brand_id = _p('brand_id');
                    if (!empty($goods_ids) && $brand_id) {
                        $brand = $this->brandLogic->getOneById($brand_id);
                        if ($brand) {
                            $goods_map = Zhtx::createDataMap();
                            foreach ($goods_ids as $id) {
                                $goods_map->addEntry('brand_id', $brand_id, DB::INT);
                                $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                                $this->goodsLogic->updateById($goods_map, $id);
                            }
                        }
                    }
                }
                //批量更改标签
                if (_p('goods_tag_id_check') == 'on') {
                    $tag_ids = _p('goods_tag_id');
                    if (!empty($goods_ids)) {
                        $res = $this->goodsTagRelLogic->delete($cond);
                        if ($res) {
                            $goods_map = Zhtx::createDataMap();
                            foreach ($goods_ids as $id) {
                                $goods_map->addEntry('goods_id', $id, DB::INT);
                                foreach ($tag_ids as $tag_id) {
                                    $goods_map->addEntry('tag_id', $tag_id, DB::INT);
                                    $this->goodsTagRelLogic->insert($goods_map);
                                }
                            }
                        }
                    }
                }
                //批量更新分类
                if (_p('goods_class_check') == 'on') {
                    $category_id = _p('category_id');
                    if (!empty($goods_ids) && $category_id) {
                        $category = $this->catgoryLogic->getOneById($category_id);
                        if ($category) {
                            $res = $this->goodsCatRelLogic->delete($cond);
                            if ($res) {
                                $goods_map = Zhtx::createDataMap();
                                foreach ($goods_ids as $id) {
                                    $path = Common::strEscape($category['path_id']);
                                    $goods_map->addEntry('goods_id', $id, DB::INT);
                                    $goods_map->addEntry('goods_category_id', $category['id'], DB::INT);
                                    $goods_map->addEntry('category_path', $path, DB::VARCHAR);
                                    $this->goodsCatRelLogic->insert($goods_map);
                                    $this->goodsLangLogic->saveByCond(array('category_path' => $path), 'goods_id=' . $id);
                                }
                            }
                        }
                    }
                }
                //上下架,库存，重量，价格
                if (_p('goods_state_check') == 'on' || _p('goods_weight_check') == 'on' || _p('goods_stock_check') == 'on' || _p('goods_price_check') == 'on') {
                    //上下架参数
                    $status = _p('goods_state_on_off') ? 1 : 0;
                    //重量参数
                    $weight_target_value = _p('good_weight_direct_modify');
                    $weight_target_value_operate = _p('good_weight_operate_value');
                    $weight_type = _p('goods_weight_modify_style');
                    $weight_operators = _p('good_weight_operate');
                    //库存参数
                    $stock_target_value = _p('good_stock_direct_modify'); //库存数
                    //价格参数
                    $target_name = _p('target_name');
                    $target_name_operate = _p('goods_price_modified');
                    $target_value = _p('target_value');
                    $target_value_operate = _p('goods_price_operate_value');
                    $price_type = _p('goods_price_modify_style');
                    $operators = _p('goods_price_operate');
                    $source = _p('goods_price_source');
                    //更新sku表
                    $map = Zhtx::createDataMap();
                    if (_p('goods_state_check') == 'on') {
                        $map->addEntry('status', 1, DB::INT);
                        $map->addEntry('update_time', SYS_TIME, DB::INT);
                    }
                    if (_p('goods_weight_check') == 'on') {
                        if ($weight_type) {
                            $map->addEntry('weight', 0, DB::DECIMAL);
                            $map->addEntry('update_time', SYS_TIME, DB::INT);
                        }
                    }
                    if (_p('goods_stock_check') == 'on') {
                        $map->addEntry('stock_nums', $stock_target_value, DB::INT);
                    }
                    if (_p('goods_price_check') == 'on') {
                        if ($price_type == 1) {
                            $map->addEntry($target_name, 0, DB::DECIMAL);
                            $map->addEntry('update_time', SYS_TIME, DB::INT);
                        }
                    }
                    $this->skuLogic->update($map, $cond);
                    //更新goods表
                    $goods_map = Zhtx::createDataMap();
                    if (_p('goods_state_check') == 'on') {
                        $goods_map->addEntry('status', $status, DB::INT);
                        $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                        if ($status) {
                            $lang_data['up_time'] = SYS_TIME;
                            $lang_data['status'] = 1;
                            $goods_map->addEntry('up_time', SYS_TIME, DB::INT);
                        } else {
                            $lang_data['status'] = 0;
                            $goods_map->addEntry('down_time', SYS_TIME, DB::INT);
                        }
                    }
                    if (_p('goods_weight_check') == 'on') {
                        if ($weight_type == 1) {
                            $goods_map->addEntry('weight', $weight_target_value, DB::DECIMAL);
                            $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                        }
                    }
                    if (_p('goods_price_check') == 'on') {
                        if ($price_type == 1) {
                            $goods_map->addEntry($target_name, $target_value, DB::DECIMAL);
                            $goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
                            if ($target_name == 'price') {
                                $lang_data[$target_name] = $target_value;
                            }
                        }
                    }
                    $this->goodsLogic->update($goods_map, $goods_cond);

                    //更新goodslanguage
                    $this->goodsLangLogic->saveByCond($lang_data, 'goods_id in (' . $ids_str . ')');

                    //更新goods表 id foreach 更新+，-，*，
                    $goodslist = $this->goodsLogic->findAll($goods_cond);
                    $foreachgoodsmap = Zhtx::createDataMap();
                    foreach ($goodslist as $good) {
                        if (_p('goods_weight_check') == 'on') {
                            if ($weight_type == 2) {
                                $mark = true;
                                if ($weight_operators == '+') {
                                    $weight_value = $good['weight'] + $weight_target_value_operate;
                                } else if ($weight_operators == '*') {
                                    $weight_value = $good['weight'] * $weight_target_value_operate;
                                } else if ($weight_operators == '-') {
                                    $weight_value = $good['weight'] - $weight_target_value_operate;
                                }
                                $foreachgoodsmap->addEntry('weight', $weight_value, DB::INT);
                                $foreachgoodsmap->addEntry('modify_time', SYS_TIME, DB::INT);
                            }
                        }
                        if (_p('goods_price_check') == 'on') {
                            if ($price_type == 2) {
                                $mark = true;
                                if ($operators == '+') {
                                    $value = $good[$source] + $target_value_operate;
                                } else if ($operators == '*') {
                                    $value = $good[$source] * $target_value_operate;
                                } else if ($operators == '-') {
                                    $value = $good[$source] - $target_value_operate;
                                }
                                $foreachgoodsmap->addEntry($target_name_operate, $value, DB::DECIMAL);
                                $foreachgoodsmap->addEntry('modify_time', SYS_TIME, DB::INT);
                                if ($target_name_operate == 'price') {
                                    $lang_map = Zhtx::createDataMap();
                                    $lang_map->addEntry($target_name_operate, $value, DB::DECIMAL);
                                    $this->goodsLangLogic->update($lang_map, 'goods_id = ' . $good['id']);
                                }
                            }
                        }
                        if ($mark) {
                            $this->goodsLogic->updateById($foreachgoodsmap, $good['id']);
                        }
                    }
                    $skulist = $this->skuLogic->findAll($cond);
                    if (_p('goods_stock_check') == 'on') {
                        //更新good表的库存
                        foreach ($skulist as $sku) {
                            $goods_stock[$sku['goods_id']][] = $sku['stock_nums'];
                        }
                        $goods_stock_map = Zhtx::createDataMap();
                        foreach ($goods_stock as $gkey => $goods) {
                            $stock = array_sum($goods);
                            $goods_stock_map->addEntry('stock_nums', array_sum($goods), DB::INT);
                            $goods_stock_map->addEntry('modify_time', SYS_TIME, DB::INT);
                            $this->goodsLogic->updateById($goods_stock_map, $gkey);
                        }
                    }
                    if (_p('goods_price_check') == 'on') {
                        if ($price_type == 2) {
                            $map = Zhtx::createDataMap();
                            foreach ($skulist as $sku) {
                                $map->addEntry($target_name_operate, 0, DB::DECIMAL);
                                $map->addEntry('update_time', SYS_TIME, DB::INT);
                                $sku_res = $this->skuLogic->updateById($map, $sku['id']);
                            }
                        }
                    }
                }
                //上下架,库存，重量，价格end
                return $this->success('修改成功', Common::adminURL('product', 'product', 'list', array('status' => 1)));
            }
        } else {
            $cate_id = _g("cate_id");
            if ($cate_id) {
                $cate_detail = $this->catgoryLogic->getOneById($cate_id);
                $cate_path = Common::strEscape($cate_detail['path_id']);
                $res = $this->goodsCatRelLogic->findAll($cond = " category_path like '" . $cate_path . "%'", 0, 0, $cols = array("goods_id"));
                $goods_ids = array();
                foreach ($res as $v) {
                    $goods_ids[] = $v['goods_id'];
                }
                $goods_ids_count = count($goods_ids);
                $goodsTags = $this->goodsTagLogic->findAll('status=1 order by listorder desc', true);
                $brands = $this->brandLogic->findAll('', true);
                $types = $this->goodsTypeLogic->getList('status=1 order by listorder desc');
                core::$tpl->set('types', $types['list']);
                Core::$tpl->set("cate_detail", $cate_detail);
                Core::$tpl->set("goods_ids_count", $goods_ids_count);
                Core::$tpl->set("taglist", $goodsTags);
                Core::$tpl->set("brands", $brands);
            } else {
                return $this->showMessage('非法操作');
            }
        }
    }

    /**
     * 获取类型的属性及销售属性的值
     */
    public function actionGetTypeValues() {
        if (_g("typeid")) {
            $propertylist = $this->goodsTypePropertyLogic->getPropertyByTypeId(_g("typeid"));
            Core::$tpl->set("propertylist", $propertylist);
            foreach ($propertylist['master'] as $key => $value) {
                $type_id_master = $key;
            }
            foreach ($propertylist['sale'] as $key => $value) {
                $type_id_sale = $key;
            }
            Core::$tpl->set("type_id_master", $type_id_master);
            Core::$tpl->set("type_id_sale", $type_id_sale);
        }
    }

}

?>
