<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Property
 *
 * @author xrx
 */
class PropertyController extends AppController {

    private $propertyLogic;
    private $goodsTypeLogic;
    private $langLogic;
    private $propertyLangLogic;
    private $goodsTypePropertyLogic;

    public function __construct() {
        parent::__construct();
        $this->propertyLogic = $this->load('property');
        $this->goodsTypeLogic = $this->load('goodsType');
        $this->langLogic = $this->load('language');
        $this->propertyLangLogic = $this->load('propertyLanguage');
        $this->languageJoinCountryLogic = $this->load('languageJoinCountry');
        $this->goodsTypePropertyLogic = $this->load('goodsTypeProperty');
        $this->typePropertyRelLogic = $this->load('goodsTypeProperty');
    }

    public function actionList() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'parent_id=0';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $goodsTypePropertyLogic = $this->load('GoodsTypeProperty');
        if (_g('type_id')) {
            $cols = array('property_id');
            $cond = 'goods_type_id=' . Common::queryInt(_g('type_id'));
            $property_ids = $goodsTypePropertyLogic->getCols($cond, $cols);
            $property_ids_str = array();
            if ($property_ids) {
                foreach ($property_ids as $value) {
                    if ($value['property_id'])
                        $property_ids_str[] = $value['property_id'];
                }
            }else {
                $property_ids_str[] = 0;
            }
            Core::$tpl->set('type_id', Common::queryInt(_g('type_id')));
            $where .= ' and id in (' . implode(',', $property_ids_str) . ')';
        }
        $where .= ' ORDER BY listorder desc,id DESC';
        //分页
        $count = $this->propertyLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->propertyLogic->getCurrentDatas($where, $page_size, $curr_page);
        $pids = array();
        $typeArr = array();
        foreach ($res as $value) {
            $pids[] = $value['id'];
            if (_g('type_id')) {
                if($value["type"]==1){
                    $typeArr["is_master"]=true;
                }
                if($value["type"]==2){
                    $typeArr["is_attach"]=true;
                }
            }
        }
        $array = array();
        if (count($pids) > 0) {
            $cond2 = 'p.property_id in (' . implode(',', $pids) . ')';
            $cols2 = array('distinct p.goods_type_id as id', 'p.property_id as property_id', 't.base_name as base_name');
            $array = $this->load('GoodsTypePropertyJoinType')->getCols($cond2, $cols2);
            $cond3 = 'parent_id in (' . implode(',', $pids) . ') group by parent_id';
            $childArray = $this->propertyLogic->getCols($cond3,array("parent_id,count(id) as counts"));
        }

        $type = array();
        foreach ($array as $_value) {
            $type[$_value['property_id']] = $_value;
        }
        $childCount = array();
        foreach ($childArray as $val){
            $childCount[$val["parent_id"]] = $val["counts"];
        }
		$cur_type = $this->goodsTypeLogic->getOne("id=".(int)_g('type_id'));
		core::$tpl->set('cur_type', $cur_type);
        if (_g('type_id')) {
            //已有普通属性
            $my_propertys = $this->typePropertyRelLogic->getList('goods_type_id=' . Common::queryInt(_g('type_id')).' and property_type=0');
            $publick_property_ids = array();
            foreach ($my_propertys['list'] as $item) {
                $publick_property_ids[] = $item['property_id'];
            }
            Core::$tpl->set("publick_property_ids", join(',',$publick_property_ids));
        }
        Core::$tpl->set("childCount", $childCount);
        Core::$tpl->set("typeArr", $typeArr);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('types', $type);
		
		
    }

    public function actionHowtodel() {

    }

    public function actionValuelist() {
        $id = Common::queryInt(_g('parent_id'), 0);
        $property = $this->propertyLogic->getOne('id=' . $id);
        if (!$property) {
            return $this->showMessage('not_found_record');
        }
        $where = 'parent_id = ' . Common::queryInt(_g('parent_id'), 0) . ' ORDER BY listorder desc,id DESC';
        $res = $this->propertyLogic->getList($where);
        Core::$tpl->set('res', $res['list']);
        Core::$tpl->set('property', $property);
        if (_g('type_id')) {
			$cur_type = $this->goodsTypeLogic->getOne("id=".(int)_g('type_id'));
			core::$tpl->set('cur_type', $cur_type);
            core::$tpl->set('type_id', Common::queryInt(_g('type_id')));
        }
        if (_g('t') == 'text') {
            Core::$htmlFile = 'property/valuetext';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 修改属性
     * ajax
     */
    public function actionPublicEditProperty() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $property = Common::queryStr(_p('property'));
        $base_site_id = Common::validSiteConfig();
        $update_data = array(
            'base_name' => $property,
        );
        $res = $this->propertyLogic->saveByCond($update_data, 'id=' . $id);
        if ($res) {
            $update_lang_data = array(
                'base_name' => $property,
            );
            $this->propertyLangLogic->saveByCond($update_lang_data, 'property_id=' . $id . ' and language_id=' . $base_site_id);
        }
        echo $res ? 1 : 0;
    }

    public function actionAdd() {
        if (_p()) {
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            $type = Common::queryInt(_p('type'));
            if (!$base_name) {
                return $this->showMessage('name_not_empty');
            }
            $type_id = Common::queryInt(_p('type_id'));
            if ($type_id) {
                if ($this->goodsTypePropertyLogic->getOne("goods_type_id={$type_id} and property_type=1") && $type === 1) {
                    return $this->showMessage('已经存在主销售属性,不能重复添加');
                }
                if ($this->goodsTypePropertyLogic->getOne("goods_type_id={$type_id} and property_type=2") && $type === 2) {
                    return $this->showMessage('已经存在附销售属性,不能重复添加');
                }
            }
            $listorder = Common::queryInt(_p('listorder'));
            $map = Zhtx::createDataMap();
            $map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $map->addEntry('listorder', $listorder, DB::INT);
            $map->addEntry('value_type', Common::queryInt(_p('value_type')), DB::INT);
            $map->addEntry('type', $type, DB::INT);
            $map->addEntry('required', Common::queryInt(_p('required')), DB::INT);
            $map->addEntry('search', Common::queryInt(_p('search')), DB::INT);
            if ($type_id) {
                $cur_type = $this->goodsTypeLogic->getOne("id=".$type_id);
                $map->addEntry('alias_name', $cur_type['base_name'].'_'.Common::strEscape($base_name), DB::VARCHAR);   
            }
            else
            {
                $map->addEntry('alias_name', Common::strEscape(_p('alias_name')), DB::VARCHAR);                
            }
            $map->addEntry('create_time', SYS_TIME, DB::INT);
            $result = $this->propertyLogic->insert($map);
            if ($result) {
                if (!_p('listorder')) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', 10 * $result, DB::INT);
                    $this->propertyLogic->update($map, 'id=' . $result);
                }
                //如果主表信息更新成功,则更新附表信息
                $languages = $this->langLogic->findALL('status=1', true);
                //更新选中的信息
                $property_name = "";
                foreach ($languages as $item) {
                    $property_name = Common::strEscape(_p('base_name' . $item["id"]));
                    $propertyLanguage = Zhtx::createDataMap();
                    $propertyLanguage->addEntry('property_id', $result, DB::INT);
                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $propertyLanguage->addEntry('base_name', $property_name, DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
                    $this->propertyLangLogic->insert($propertyLanguage);
                }
                if (!$listorder) {
                    $update_map = Zhtx::createDataMap();
                    $update_map->addEntry('listorder', $result, DB::INT);
                    $this->propertyLogic->updateById($update_map, $result);
                }
                $param = array();
                if ($type_id) {
                    $gtpMap = Zhtx::createDataMap();
                    $gtpMap->addEntry('property_id', $result, DB::INT);
                    $gtpMap->addEntry('property_name', $property_name, DB::VARCHAR);
                    $gtpMap->addEntry('goods_type_id', $type_id, DB::INT);
                    $gtpMap->addEntry('property_type', $type, DB::TINYINT);
                    $gtpMap->addEntry('status', 1, DB::TINYINT);
                    $this->goodsTypePropertyLogic->insert($gtpMap);
                    $param['type_id'] = $type_id;
                }
                return $this->success('edit_success', Common::adminURL('product', 'property', 'list', $param));
            }
            return $this->showMessage('edit_failure');
        } else {
            if (_g('type_id')) {
                core::$tpl->set('type_id', Common::queryInt(_g('type_id')));
            }
            $where = '1=1 order by listorder asc';
            $goodsTypes = $this->goodsTypeLogic->getList($where);
            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            core::$tpl->set('goodstypes', $goodsTypes['list']);
            core::$tpl->set('languages', $languages['list']);
            Core::$htmlFile = "property/form";
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionEdit() {
        if (_p()) {
            $id = Common::queryInt(_p('id'));
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('name_not_empty');
            }
            $property = $this->propertyLogic->getOne('id=' . $id);
            if (!$property) {
                return $this->showMessage('not_found_record');
            }
            $map = Zhtx::createDataMap();
            $type = Common::queryInt(_p('type'));
            $map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $map->addEntry('value_type', Common::queryInt(_p('value_type')), DB::INT);
            $map->addEntry('type', $type, DB::INT);
            $map->addEntry('required', Common::queryInt(_p('required')), DB::INT);
            $map->addEntry('search', Common::queryInt(_p('search')), DB::INT);
            $map->addEntry('alias_name', Common::strEscape(_p('alias_name')), DB::VARCHAR);
            $map->addEntry('create_time', SYS_TIME, DB::INT);
            $result = $this->propertyLogic->update($map, "id=" . $id);
            if ($result) {
                //如果主表信息更新成功,则更新附表信息
                $languages = $this->langLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item) {
                    $propertyLanguage = Zhtx::createDataMap();
                    $propertyLanguage->addEntry('property_id', $id, DB::INT);
                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $propertyLanguage->addEntry('base_name', Common::strEscape(_p('base_name' . $item["id"])), DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
                    $values = $item["id"];
                    if ($this->propertyLangLogic->getOne("property_id = {$id} AND language_id = {$values}")) {
                        $this->propertyLangLogic->update($propertyLanguage, "property_id = {$id} AND language_id = {$values}");
                    } else {
                        $this->propertyLangLogic->insert($propertyLanguage);
                    }
                }
                //更新属性值
                $son_map = Zhtx::createDataMap();
                $son_map->addEntry('value_type', Common::queryInt(_p('value_type')), DB::INT);
                $son_map->addEntry('type', Common::queryInt(_p('type')), DB::INT);
                $son_map->addEntry('required', Common::queryInt(_p('required')), DB::INT);
                $son_map->addEntry('search', Common::queryInt(_p('search')), DB::INT);
                $result = $this->propertyLogic->update($son_map, "parent_id=" . $id);

                $type_id = Common::queryInt(_p('type_id'));
                $param = array();
                if ($type_id) {
                    $param['type_id'] = $type_id;
                }
                return $this->success('edit_success', Common::adminURL('product', 'property', 'list', $param));
            }
        } else {
            $id = Common::queryInt(_g('id'));
            $property = $this->propertyLogic->getOne('id=' . $id);
            if (!$property) {
                return $this->showMessage('not_found_record');
            }
            $properyJoinLangLogic = $this->load('PropertyJoinLanguage');
            $propertyLangs = $properyJoinLangLogic->getListById($id);
            $masterPropertyLang = array();
            $value_list = array();
            foreach ($propertyLangs as $value) {
                if ($value['id'] == $id) {
                    $masterPropertyLang[$value['language_id']] = $value;
                } else {
                    $value_list[$value['language_id']][$value['id']] = $value;
                }
            }

            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            $cond = 'property_id = ' . $id;
            $propertylang = $properyJoinLangLogic->getList($cond);
            $propertylang_arr = array();
            foreach ($propertylang['list'] as $value) {
                $propertylang_arr[$value['language_id']] = $value;
            }
            if (_g('type_id')) {
                core::$tpl->set('type_id', Common::queryInt(_g('type_id')));
            }
            Core::$tpl->set('propertyLanguage', $propertylang_arr);
            Core::$tpl->set('languages', $languages["list"]);
            Core::$tpl->set('property', $property);
            Core::$tpl->set('value_list', $value_list);
            Core::$htmlFile = "property/form";
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionEditValue() {
        if (_p()) {
            $base_site_id = Common::validSiteConfig();
            $base_name = _p('base_name' . $base_site_id);
            if (!$base_name) {
                return $this->showMessage('name_not_empty');
            }
            $id = Common::queryInt(_p('id'));
            $parent_id = Common::queryInt(_g('parent_id'));
            $parent = $this->propertyLogic->getOneById($parent_id);
            $base_data = array(
                'base_name' => Common::strEscape($base_name),
                'listorder' => Common::queryInt(_p('listorder')),
                'sort_weight' => Common::queryInt(_p('sort_weight')),
                'image' => Common::strEscape(_p('image')),
                'value_type' => $parent['value_type'],
                'type' => $parent['type'],
                'required' => $parent['required'],
                'search' => $parent['search'],
            );
            $result = $this->propertyLogic->save($base_data, $id);
            if ($result) {
                //如果主表信息更新成功,则更新附表信息
                $languages = $this->langLogic->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item) {
                    $propertyLanguage = Zhtx::createDataMap();
                    $propertyLanguage->addEntry('property_id', $id, DB::INT);
                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $propertyLanguage->addEntry('base_name', Common::strEscape(_p('base_name' . $item["id"])), DB::VARCHAR);
                    $propertyLanguage->addEntry('title', _p('title' . $item["id"]), DB::VARCHAR);
                    $propertyLanguage->addEntry('keywords', _p('keywords' . $item["id"]), DB::VARCHAR);
                    $propertyLanguage->addEntry('descript', _p('descript' . $item["id"]), DB::VARCHAR);
                    $propertyLanguage->addEntry('detail', Common::strEscape(Inputer::getOrgPost('detail' . $item["id"]), FALSE), DB::VARCHAR);
                    /*
                     * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                     * 如果没有,则添加数据,否则更新数据
                     */
                    $values = $item["id"];
                    if ($this->propertyLangLogic->getOne("property_id = {$id} AND language_id = {$values}")) {
                        $this->propertyLangLogic->update($propertyLanguage, "property_id = {$id} AND language_id = {$values}");
                    } else {
                        $this->propertyLangLogic->insert($propertyLanguage);
                    }
                }
                $data = array('parent_id' => Common::queryInt(_g('parent_id')));
                if (_g('t') == 'text')
                    $data['t'] = 'text';
                $type_id = Common::queryInt(_p('type_id'));
                if ($type_id) {
                    $data['type_id'] = $type_id;
                }
                return $this->success('edit_success', Common::adminURL('product', 'property', 'valuelist', $data));
            }
        } else {
            $id = Common::queryInt(_g('id'));
            $property = $this->propertyLogic->getOne('id=' . $id);
            if (!$property) {
                return $this->showMessage('not_found_record');
            }
            $properyJoinLangLogic = $this->load('PropertyJoinLanguage');
            $propertyLangs = $properyJoinLangLogic->getListById($id);
            $masterPropertyLang = array();
            $value_list = array();
            foreach ($propertyLangs as $value) {
                if ($value['id'] == $id) {
                    $masterPropertyLang[$value['language_id']] = $value;
                } else {
                    $value_list[$value['language_id']][$value['id']] = $value;
                }
            }

            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            $cond = 'property_id = ' . $id;
            $propertylang = $properyJoinLangLogic->getList($cond);
            $propertylang_arr = array();
            foreach ($propertylang['list'] as $value) {
                $propertylang_arr[$value['language_id']] = $value;
            }

            if (_g('type_id')) {
                core::$tpl->set('type_id', Common::queryInt(_g('type_id')));
            }
            Core::$tpl->set('propertyLanguage', $propertylang_arr);
            Core::$tpl->set('languages', $languages["list"]);
            Core::$tpl->set('property', $property);
            Core::$tpl->set('value_list', $value_list);
            if (_g('t') == 'text') {
                Core::$htmlFile = "property/textform";
                Core::$isdisplay = 0;
                Core::$tpl->render(Core::$htmlFile . ".htm");
            } else {
                Core::$htmlFile = "property/valueform";
                Core::$isdisplay = 0;
                Core::$tpl->render(Core::$htmlFile . ".htm");
            }
        }
    }

    public function actionAddValue() {
        if (_p()) {
            $parent_id = Common::queryInt(_p('parent_id'));
            $property = $this->propertyLogic->getOneById($parent_id);
            if (!$property) {
                return $this->showMessage('illegal_parameters');
            }
            $languages = $this->langLogic->findALL('status=1', true);
            $base_site_id = Common::validSiteConfig();
            for ($index = 0; $index <= 10; $index++) {
                if (!_p('base_name_' . $base_site_id . '_' . $index)) {
                    continue;
                }
                $map = Zhtx::createDataMap();
                $map->addEntry('base_name', Common::strEscape(_p('base_name_' . $base_site_id . '_' . $index)), DB::VARCHAR);
                $map->addEntry('parent_id', Common::queryInt(_p('parent_id')), DB::INT);
                $map->addEntry('image', "", DB::VARCHAR);
                $map->addEntry('value_type', $property['value_type'], DB::INT);
                $map->addEntry('type', $property['type'], DB::INT);
                $map->addEntry('required', $property['required'], DB::INT);
                $map->addEntry('search', $property['search'], DB::INT);
                $map->addEntry('create_time', SYS_TIME, DB::INT);
                $result = $this->propertyLogic->insert($map);
                if ($result) {
                    foreach ($languages as $item) {
                        $propertyLanguage = Zhtx::createDataMap();
                        $propertyLanguage->addEntry('property_id', $result, DB::INT);
                        $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                        $propertyLanguage->addEntry('base_name', Common::strEscape(_p('base_name_' . $item["id"] . '_' . $index)), DB::VARCHAR);
                        /*
                         * 没有replace操作,所以要先查询一遍是否有当前shipping_id 和 language_id的数据值
                         * 如果没有,则添加数据,否则更新数据
                         */
                        $this->propertyLangLogic->insert($propertyLanguage);
                    }

                    $update_map = Zhtx::createDataMap();
                    $update_map->addEntry('listorder', $result, DB::INT);
                    $this->propertyLogic->updateById($update_map, $result);
                }
            }
            if (_g('t')) {
                $return_url = array('parent_id' => Common::queryInt(_p('parent_id')), 't' => 'text');
            } else {
                $return_url = array('parent_id' => Common::queryInt(_p('parent_id')));
            }
            $type_id = Common::queryInt(_p('type_id'));
            if ($type_id) {
                $return_url['type_id'] = $type_id;
            }
            return $this->success('edit_success', Common::adminURL('product', 'property', 'valuelist', $return_url));
        } else {
            $id = Common::queryInt(_g('parent_id'));
            $property = $this->propertyLogic->getOne('id=' . $id);
            Core::$tpl->set('property', $property);
            Core::$tpl->set('arrindex', array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
            $languages = $this->languageJoinCountryLogic->getList('l.status=1');
            Core::$tpl->set('languages', $languages["list"]);
            if (_g('type_id')) {
                core::$tpl->set('type_id', Common::queryInt(_g('type_id')));
            }
            if (_g('t') == 'text') {
                Core::$htmlFile = 'property/addtext';
                Core::$isdisplay = 0;
                Core::$tpl->render(Core::$htmlFile . '.htm');
            }
        }
    }

    /**
     * 删除属性 同时删除property_language\goods_type_property\goods_property_rel相关的数据
     */
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            $i = 0;
            $goodsTypeProLogic = $this->load('goodsTypeProperty');
            $goodsPropertyRellogic = $this->load('goodsPropertyRel');
            $properties = $this->propertyLogic->findAll('id in (' . implode(',', $ids) . ')', true);
            foreach ($ids as $id) {
                if ($properties[$id]['type'] == 1 || $properties[$id]['type'] == 2) {
                    $where = 'property_id=' . $id . ' or vid=' . $id;
                    if ($goodsPropertyRellogic->getCount($where)) {
                        $msg = ',' . $lang['has_property_goods_rel'];
                        continue;
                    } else if ($goodsTypeProLogic->getCount('property_id=' . $id . ' or vid=' . $id)) {
                        $msg = ',' . $lang['has_goods_type_property_rel'];
                        continue;
                    } else {
                        $res = $this->propertyLogic->delete('id=' . $id . ' or parent_id=' . $id);
                        if ($res) {
                            $this->propertyLangLogic->delete('property_id=' . $id);
                            $goodsTypeProLogic->delete('property_id=' . $id . ' or vid=' . $id);
                            $goodsPropertyRellogic->delete('property_id=' . $id . ' or vid=' . $id);
                            $num++;
                        }
                    }
                } else {
                    $res = $this->propertyLogic->delete('id=' . $id . ' or parent_id=' . $id);
                    if ($res) {
                        $this->propertyLangLogic->delete('property_id=' . $id);
                        $goodsTypeProLogic->delete('property_id=' . $id . ' or vid=' . $id);
                        $goodsPropertyRellogic->delete('property_id=' . $id . ' or vid=' . $id);
                        $num++;
                    }
                }
            }
            $staus = 1;
            if ($num > 0 && $i > 0) {
                $flag = $lang['success_delete'] . $num . $lang['num_records'] . ', ' . $lang['delete_failure'] . $i . $lang['num_records'];
            } else if ($num > 0) {
                $flag = $lang['success_delete'] . $num . $lang['num_records'];
            } else {
                $flag = $lang['delete_failure'] . $i . $lang['num_records'] . $msg;
            }
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * ajax 更新状态
     */
    public function actionEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->propertyLogic->update($map, 'id =' . $id . ' or parent_id=' . $id);
        if ($res) {
            $goodsTypeProLogic = $this->load('goodsTypeProperty');
            $goodsTypeProLogic->update($map, 'property_id=' . $id . ' or vid=' . $id);
        }
        echo $res ? 1 : 0;
    }

    /**
     * 修改排序
     * ajax
     */
    public function actionPublicEditSort() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $map = Zhtx::createDataMap();
        if (is_numeric(_p('listorder'))) {
            if (!is_numeric(_p('listorder'))) {
                echo 0;
                return;
            }
            $map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
        }
        if (is_numeric(_p('sort_weight'))) {
            if (!is_numeric(_p('sort_weight'))) {
                echo 0;
                return;
            }
            $map->addEntry('sort_weight', Common::queryInt(_p('sort_weight')), DB::INT);
        }

        $res = $this->propertyLogic->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }

}

?>