<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Special
 * 限时特价 免邮管理类
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class SpecialController extends AppController {

    private $specialLogic;
    private $goodsLogic;
    private $catgoryLogic;
    private $brandLogic;
    private $skuLogic;

    public function __construct() {
        parent::__construct();
        $this->specialLogic = $this->load('specialOffer');
        $this->goodsLogic = $this->load('goods');
        $this->brandLogic = $this->load('brand');
        $this->catgoryLogic = $this->load('goodsCategory');
        $this->skuLogic = $this->load('sku');
    }

    /**
     * 特价活动列表 
     */
    public function actionList() {
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);

        $cond = ' 1=1';
        $search_value = Common::strEscape(_g('search_value'));
        if ($search_value) {
            $cond .= ' and base_name like "%' . $search_value . '%"';
        }
        $cond .= ' order by create_time desc';
        $count = $this->specialLogic->getCount($cond);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->specialLogic->getCurrentDatas($cond, $page_size, $curr_page);
        $goodsLogic = $this->load('goods');
        $result = array();
        foreach ($res as $value) {
            $value['goods_num'] = 0;
            $cond = 'special_offer_id =' . $value['id'];
            $value['goods_num'] = $goodsLogic->getCount($cond);
            if ($value['start_time'] > SYS_TIME && $value['sataus'] == 0) {
                //计算距离开始时间 提醒启动活动
                $offset_time = $this->getOffsetTime($value['start_time'] - SYS_TIME);
                $value['msg'] = '距离开始' . $offset_time;
                $value['tip'] = 1;
            } else if ($value['start_time'] < SYS_TIME && $value['end_time'] > SYS_TIME && $value['status']) {
                //活动进行中
                $value['msg'] = '进行中';
                $value['tip'] = 2;
            } else if ($value['start_time'] < SYS_TIME && $value['end_time'] < SYS_TIME && $value['status']) {
                //活动时间已经过期 提醒停止活动
                $value['msg'] = '活动时间结束，请关闭';
                $value['tip'] = 3;
            } else if (($value['start_time'] < SYS_TIME || $value['start_time'] == SYS_TIME) && $value['end_time'] > SYS_TIME && $value['status'] == 0) {
                //活动时间已经到 提醒启动活动
                $value['msg'] = '活动时间到，请开启';
                $value['tip'] = 4;
            } else {
                $value['msg'] = '活动结束';
                $value['tip'] = 5;
            }
            $result[] = $value;
        }
        Core::$tpl->set('res', $result);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 新增加限时特价活动及免邮
     */
    public function actionAdd() {
        if (_p()) {
            $base_name = _p('base_name');
            if (!$base_name) {
                return $this->showMessage('name_is_not_empty');
            }
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'start_time' => strtotime(_p('start_time')),
                'end_time' => strtotime(_p('end_time')),
            );
            $goods_ids = array();
            $type = _p('goods_promotion_type');
            switch ($type) {
                case 'category':
                    $data['category_id'] = Common::queryInt(_p('category_id'));
                    break;
                case 'goods':
                    $data['is_goods'] = 1;
                    $goods_ids = _p('goods_ids');
                    break;
                case 'brand':
                    $data['brand_id'] = Common::queryInt(_p('brand_id'));
                    break;
                default : break;
            }
            $data['discount'] = _p('discount');
          
                $data['status'] = 0;
            $img_arr = _p('image');
            $data['image'] = $img_arr[1];
            $res_id = $this->specialLogic->save($data);
            if ($res_id) {
				$res = $this->specialLogic->getOneById($res_id);
                $goodsLogic = $this->load('goods');
                $rel_goods_ids = array(0);
               
                if ($data['category_id']) {
                    $categoryRelLogic = $this->load('goodsCategoryRelJoinGoods');
                    $category = $this->load('goodsCategory')->getOneById($data['category_id']);
                    $cond = 'c.category_path like "' . $category['path_id'] . '%" and g.special_offer_id=0';
                    $rel_goods_ids=$categoryRelLogic->findAll($cond,false,'',array('g.id'));
					
                } else if ($data['brand_id']) {
                    
					$cond = 'brand_id=' . $data['brand_id'] . ' and special_offer_id=0';
					$rel_goods_ids=$this->goodsLogic->findAll($cond,false,'',array('id'));
                    
                } else if ($data['is_goods']) {
                    //$rel_goods_ids = $goods_ids;
                }
				
				//print_r($rel_goods_ids);
				$goodsLogic = $this->load('goods');
				foreach($rel_goods_ids as $value)
				{
					
					if(!$value['id'])
						continue ;
					
					$goods_map = Zhtx::createDataMap();
					$goods_map->addEntry('start_time', $res['start_time'], DB::INT);
					$goods_map->addEntry('end_time', $res['end_time'], DB::INT);
					$goods_map->addEntry('discount', $res['discount'], DB::DECIMAL);
					$goods_map->addEntry('old_price', 'price', DB::DECIMAL);
					$goods_map->addEntry('special_offer_id', $res['id'], DB::INT);
					$goods_map->addEntry('special_status', 0, DB::INT);
					$goods_res = $goodsLogic->updateById($goods_map, $value['id']);
					
			
					
						//修改sku价格
					$sku_map = Zhtx::createDataMap();
					$sku_map->addEntry('old_price', 'price', DB::DECIMAL);
					$sku_map->addEntry('special_status', 0, DB::INT);
					$where = 'goods_id =' . $value['id'];
					$this->skuLogic->update($sku_map, $where);
				}
				
                //修改数据前，剔除特价状态为开启，价格为0或者存在原价的商品。
                
                $this->clearGoodsCache();
                return $this->success('operation_success', Common::adminURL('product', 'special', 'list'));
            }
            return $this->showMessage('operation_failure');
        } else {
            Core::$htmlFile = 'special/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     *  编辑限时特价
     *  活动进行过程中不允许编辑
     */
    public function actionEdit() {
        if (_p()) {
            $special_id = Common::queryInt(_p('id'));
            $special = $this->specialLogic->getOneById($special_id);
            $base_name = _p('base_name');
            if (!$base_name) {
                return $this->showMessage('name_is_not_empty');
            }
            $data = array(
                'base_name' => Common::strEscape($base_name),
                'start_time' => strtotime(_p('start_time')),
                'end_time' => strtotime(_p('end_time')),
                'category_id' => 0,
                'brand_id' => 0,
                'is_goods' => 0,
            );
           
            $data['discount'] = _p('discount');
            $img_arr = _p('image');
            $data['image'] = $img_arr[1];
            $res = $this->specialLogic->save($data, $special_id);
            return $this->success('operation_success');
            
        } else {
            $special_id = Common::queryInt(_g('id'));
            $special = $this->specialLogic->getOneById($special_id);
            if (!$special) {
                return $this->showMessage('illegal_operation');
            }
            $goodslist = array();

            Core::$tpl->set('special', $special);
            Core::$tpl->set('goodslist', $goodslist);
            Core::$tpl->set('shippings', $shippings);
            Core::$tpl->set('brandlist', $brandList);
            Core::$tpl->set('special_id', $special_id);
            Core::$htmlFile = 'special/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 限时特价活动开启(不修改原价，统一在添加商品的时候，保存原价，这里只修改价格和状态)
     * @return type 
     */
    public function actionStart() {
        $special_id = Common::queryInt(_g('id'));
        $special = $this->specialLogic->getOneById($special_id);
        if (!$special) {
            return $this->showMessage('illegal_operation');
        }
        if ($special['end_time'] < SYS_TIME || $special['status'] == 1) {
            return $this->showMessage('illegal_operation');
        }
        $goodsLogic = $this->load('goods');
		
        $discount = $special['discount'] ? $special['discount'] : 10;
        
        $cond = 'special_status=0 and special_offer_id=' . $special_id;
        $rel_goods = $goodsLogic->findAll($cond);
        $rel_goods_ids = array(0);
        foreach ($rel_goods as $value) {
			$map = Zhtx::createDataMap();
			$map->addEntry('price', 'old_price*(discount/10)', DB::DECIMAL);
			$map->addEntry('special_status', 1, DB::INT);
			$res = $goodsLogic->updateById($map, $value['id']);
            
			
			 $sku_map = Zhtx::createDataMap();
          //  $sku_map->addEntry('old_price', 'price', DB::DECIMAL);
            $sku_map->addEntry('price', 'old_price*' . $value['discount'] / 10, DB::DECIMAL);
            $sku_map->addEntry('special_status', 1, DB::INT);
            $where = ' goods_id =' . $value['id'] ;
            $this->skuLogic->update($sku_map, $where);
        }
        
           

            $this->clearGoodsCache();
      
			$special_map = Zhtx::createDataMap();
            $special_map->addEntry('status', 1, DB::INT);
            $this->specialLogic->updateById($special_map, $special_id) ;

            return $this->success('sctivity_start');
    }

    /**
     * 限时特价关闭停止
     * @return type
     */
    public function actionClose() {
        $special_id = Common::queryInt(_g('id'));
        $special = $this->specialLogic->getOneById($special_id);
        if (!$special) {
            return $this->showMessage('illegal_operation');
        }
        if ($special['status'] == 0) {
            return $this->showMessage('illegal_operation');
        }
        $goodsLogic = $this->load('goods');
        //goods表先更新原价
        $map = Zhtx::createDataMap();
        $map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
        $cond = ' special_offer_id = ' . $special_id;
        $res = $goodsLogic->update($map, $cond);
        
        $map = Zhtx::createDataMap();
        $map->addEntry('old_price', 0, DB::DECIMAL);
        $map->addEntry('start_time', 0, DB::INT);
        $map->addEntry('end_time', 0, DB::INT);
        $map->addEntry('discount', 10, DB::INT);
        $map->addEntry('special_status', 0, DB::INT);
        $map->addEntry('special_offer_id', 0, DB::INT);
        //商品为特价状态，并且原价大于0
        $cond = 'special_offer_id = ' . $special_id;
        $rel_goods = $goodsLogic->findAll($cond);
        $rel_goods_ids = array(0);
        foreach ($rel_goods as $value) {
            $rel_goods_ids[$value['id']] = $value['id'];
        }
        $res = $goodsLogic->update($map, $cond);
        if ($res) {
            //修改sku价格
            //sku表先更新原价
            $sku_map = Zhtx::createDataMap();
            $sku_map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
            $where = '  goods_id in (' . implode(',', $rel_goods_ids) . ')';
            $this->skuLogic->update($sku_map, $where);
            
            $sku_map = Zhtx::createDataMap();
            $sku_map->addEntry('old_price', 0, DB::DECIMAL);
            $sku_map->addEntry('special_status', 0, DB::INT);
            //商品sku原价大于0
            $where = 'goods_id in (' . implode(',', $rel_goods_ids) . ')';
            $this->skuLogic->update($sku_map, $where);

            $this->clearGoodsCache();
            $special_map = Zhtx::createDataMap();
            $special_map->addEntry('status', 0, DB::INT);
            if ($this->specialLogic->updateById($special_map, $special_id)) {
                return $this->success('sctivity_stop');
            }
        }

        return $this->showMessage('sctivity_stop_failure');
    }

    /**
     * 限时特价清理
     * @return type
     */
    public function actionDel() {
        $special_id = Common::queryInt(_g('id'));
        $special = $this->specialLogic->getOneById($special_id);
        if (!$special) {
            return $this->showMessage('illegal_operation');
        }
        $special_shipping_logic = $this->load('specialOfferShippingRel');
        $goodsLogic = $this->load('goods');
        $map = Zhtx::createDataMap();
        $map->addEntry('price', 'old_price', DB::DECIMAL);
        $cond = ' old_price>0 and special_offer_id = ' . $special_id;
        $res = $goodsLogic->update($map, $cond);
        $map = Zhtx::createDataMap();
        $map->addEntry('old_price', 0, DB::DECIMAL);
        $map->addEntry('start_time', 0, DB::INT);
        $map->addEntry('end_time', 0, DB::INT);
        $map->addEntry('discount', 10, DB::INT);
        $map->addEntry('special_status', 0, DB::INT);
        $map->addEntry('special_offer_id', 0, DB::INT);
        //商品为特价状态，并且原价大于0
        $cond = 'special_offer_id = ' . $special_id;
        $rel_goods = $goodsLogic->findAll($cond);
        $rel_goods_ids = array(0);
        foreach ($rel_goods as $value) {
            $rel_goods_ids[$value['id']] = $value['id'];
        }
        $res = $goodsLogic->update($map, $cond);
        if ($res) {
            //修改sku价格
            //sku表先更新原价
            $sku_map = Zhtx::createDataMap();
            $sku_map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
            $where = '  goods_id in (' . implode(',', $rel_goods_ids) . ')';
            $this->skuLogic->update($sku_map, $where);
            
            $sku_map = Zhtx::createDataMap();
            $sku_map->addEntry('old_price', 0, DB::DECIMAL);
            $sku_map->addEntry('special_status', 0, DB::INT);
            //商品sku原价大于0
            $where = ' goods_id in (' . implode(',', $rel_goods_ids) . ')';
            $this->skuLogic->update($sku_map, $where);

            $special_shipping_logic->delete('special_offer_id=' . $special_id);
            $this->specialLogic->delete('id=' . $special_id);
            $this->clearGoodsCache();
            return $this->success('delete_success');
        }
        return $this->showMessage('delete_failure');
    }

    /**
     * 活动时间计算
     * @param type $time
     * @return string
     */
    public function getOffsetTime($time) {
        $hour = '3600';
        $day = $hour * 24;
        $week = $day * 7;
        $month = $day * 30;
        if ($time / $month > 1) {
            $result = round($time / $month) . '个月';
        } else if ($time / $week > 1) {
            $result = round($time / $week) . '个星期';
        } else if ($time / $day > 1) {
            $result = round($time / $day) . '天';
        } else if ($time / $hour > 1) {
            $result = round($time / $hour) . '小时';
        } else if ($time / 60 > 1) {
            $result = round($time / 60) . '分';
        } else {
            $result = $time . '秒';
        }
        return $result;
    }

    public function clearGoodsCache() {
        _crearCahce('goods_list');
        _crearCahce('goods_info');
    }

    /**
     * 
     * 关联商品 ajax
     *  
     */
    public function actionAddGoodsAjax() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $special_id = _p('special_id');
//        $specialOfferLogic = $this->load('specialOffer');
//        $res = $specialOfferLogic->getOne('id=' . $special_id);
        $res = $this->specialLogic->getOne('id=' . $special_id);

        $data = array(
            'base_name' => $res['base_name'],
            'start_time' => strtotime($res['start_time']),
            'end_time' => strtotime($res['end_time']),
        );
        $staus = 0;
        $flag = $lang['pease_select_add_obj'];
        if (!empty($ids)) {
            //修改数据前，剔除特价状态为开启，或者存在原价的商品。
            
			foreach($ids as $id)
			{
				
				$goodsLogic = $this->load('goods');
				
				$goods = $goodsLogic->getOneById($id);
				if(!$goods || $goods['special_offer_id'])
					continue ;
				$goods_map = Zhtx::createDataMap();
				$goods_map->addEntry('start_time', $res['start_time'], DB::INT);
				$goods_map->addEntry('end_time', $res['end_time'], DB::INT);
				$goods_map->addEntry('discount', $res['discount'], DB::DECIMAL);
				$goods_map->addEntry('old_price', 'price', DB::DECIMAL);
				$goods_map->addEntry('modify_time', SYS_TIME, DB::INT);
				$goods_map->addEntry('special_offer_id', $res['id'], DB::INT);
				if ($res['status']) {
					$goods_map->addEntry('price', 'old_price*' . $res['discount'] / 10, DB::DECIMAL);
					$goods_map->addEntry('special_status', 1, DB::INT);
				} else {
					//$goods_map->addEntry('price', 'price', DB::DECIMAL);
					$goods_map->addEntry('special_status', 0, DB::INT);
				}
				$goods_res = $goodsLogic->updateById($goods_map, $id);
				
		
				
					//修改sku价格
					$sku_map = Zhtx::createDataMap();
					$sku_map->addEntry('old_price', 'price', DB::DECIMAL);
					if ($res['status']) {
						$sku_map->addEntry('price', 'price*' . $res['discount'] / 10, DB::DECIMAL);
						$sku_map->addEntry('special_status', 1, DB::INT);
					} else {
						//$sku_map->addEntry('price', 'price', DB::DECIMAL);
						$sku_map->addEntry('special_status', 0, DB::INT);
					}
					$where = 'goods_id =' . $id;
					$this->skuLogic->update($sku_map, $where);
			}
            //清空缓存
            $this->clearGoodsCache();
            $staus = 1;
            $flag = $lang['success_add'] ;
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * 
     * 获取商品列表
     *  
     */
    public function actionGoodsList() {
        //分页用的参数
        $page_size = Common::queryInt(_g('psize'), 20);
        $curr_page = Common::queryInt(_g('page'), 1);
        $special_id = Common::queryInt(_g('id'), 1);
        $res = $this->specialLogic->getOne('id=' . $special_id);
        if ($res['end_time'] < SYS_TIME) {
            $explire = 1;
        }
        //获取数据(列表出现old_price=0的，提示为数据错误)
        $where = 'special_offer_id=' . $special_id . ' order by up_time desc';
        $goodsLogic = $this->load('goods');
        $count = $goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results = $goodsLogic->getCurrentDatas($where, $page_size, $curr_page);

        $goods_ids = array();
        $type_ids = array();
        foreach ($results as $value) {
            $goods_ids[] = $value['id'];
            $type_ids[$value['goods_type_id']] = $value['goods_type_id'];
        }
        $goods_tags = array();
        $rel_categories = array();
        if (!empty($goods_ids)) {
            $tag_cond = 'goods_id in (' . implode(',', $goods_ids) . ')';
            $goodsTagRelLogic = $this->load('goodsTagRel');
            $tags = $goodsTagRelLogic->findAll($tag_cond);
            foreach ($tags as $value) {
                $goods_tags[$value['goods_id']][$value['tag_id']] = $value['tag_id'];
            }

            $c_cond = 'g.goods_id in(' . implode(',', $goods_ids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
        $goods_types = array();
        if (count($type_ids)) {
            $goodsTypeLogic = $this->load('goodsType');
            $goods_types = $goodsTypeLogic->findAll('id in (' . implode(',', $type_ids) . ')', true);
        }
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("brands", $this->load('brand')->findAll('', true));
        Core::$tpl->set("res", $results);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('special_id', $special_id);
        Core::$tpl->set('explire', $explire ? $explire : 0);
    }

    /**
     * 
     * 获取商品列表 弹窗
     *  
     */
    public function actionPublicDlgGoods() {
        //分页用的参数
        $page_size = 10;
        $curr_page = Common::queryInt(_g('page'), 1);
        $special_id = Common::queryInt(_g('special_id'), 1);
        $where = 'special_status=0 and old_price=0 and special_offer_id=0';
        if (_g('base_name')) {
            $where .= ' and base_name like "%' . Common::strEscape(_g('base_name')) . '%"';
        }
        if (_g('codeno')) {
            $where .= ' and codeno ="' . _g('codeno') . '"';
        }
        if (_g('start_time') && _g('end_time')) {
            $where .= ' and up_time between ' . strtotime(_g('start_time')) . ' and ' . strtotime(_g('end_time'));
        } else if (_g('start_time')) {
            $where .= ' and up_time >= ' . strtotime(_g('start_time'));
        } else if (_g('end_time')) {
            $where .= ' and up_time <= ' . strtotime(_g('end_time'));
        }
        if (_g('brand_id')) {
            $where .= ' and brand_id=' . _g('brand_id');
        }
        if (_g('category_id')) {
            $categoryRel = $this->load('goodsCategoryRel')->findAll('goods_category_id=' . _g('category_id'));
            $goods_ids = array();
            foreach ($categoryRel as $val) {
                $goods_ids[] = $val['goods_id'];
            }
            if (!empty($goods_ids)) {
                $where .= ' and id in (' . implode(',', $goods_ids) . ')';
            }
        }
        if (_g('psize')) {
            $page_size = Common::queryInt(_g('psize'));
        }
        //分页
        $count = $this->goodsLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        if (_g('orderby')) {
            $where .= ' order by ' . _g('orderby') . ' desc';
        }
        $where .= ' limit ' . ($curr_page - 1) * $page_size . ', ' . $page_size;
        $goodslist = $this->goodsLogic->findAll($where, TRUE);
        Core::$tpl->set('special_id', $special_id);
        Core::$tpl->set('goodslist', $goodslist);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('brands', $this->brandLogic->findAll());
        Core::$tpl->set('categories', $this->catgoryLogic->findAll());
        Core::$htmlFile = 'special/dlggoods';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 
     * 删除关联商品
     *  
     */
    public function actionDelGoods() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['pease_select_delete_obj'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $goodsLogic = $this->load('goods');
                $map = Zhtx::createDataMap();
                $map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
                $map->addEntry('old_price', 0, DB::DECIMAL);
                $map->addEntry('start_time', 0, DB::INT);
                $map->addEntry('end_time', 0, DB::INT);
                $map->addEntry('discount', 10, DB::INT);
                $map->addEntry('special_status', 0, DB::INT);
                $map->addEntry('special_offer_id', 0, DB::INT);
                $cond = 'id = ' . $id;
                $res = $goodsLogic->update($map, $cond);
                if ($res) {
                    //修改sku价格
                    $sku_map = Zhtx::createDataMap();
                    $sku_map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
                    $sku_map->addEntry('old_price', 0, DB::DECIMAL);
                    $sku_map->addEntry('special_status', 0, DB::INT);
                    $where = ' goods_id=' . $id;
                    $this->skuLogic->update($sku_map, $where);
                }
                $num++;
            }
            $this->clearGoodsCache();
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'] . ', ' . $lang['delete_failure'] . $i . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * 修改折扣
     * ajax 
     */
    public function actionPublicEditDiscount() {
        $id = Common::queryInt(_p('id'));
        $special_id = Common::queryInt(_p('special_id'));
        $special = $this->specialLogic->getOneById($special_id);
        if (!$id) {
            echo 0;
            return;
        }
        $map = Zhtx::createDataMap();
        if (_p('discount')) {
            if (!is_numeric(_p('discount'))) {
                echo 0;
                return;
            }
			if($special['status'])
           		$map->addEntry('price', 'old_price*' . _p('discount') / 10, DB::DECIMAL);
			
            $map->addEntry('discount', _p('discount'), DB::DECIMAL);
        }
        $res = $this->goodsLogic->update($map, ' id=' . $id);
      
        echo $res ? 1 : 0;
            //}
            //echo 1;
       
    }

    /**
     * 修改时间
     * ajax 
     */
    public function actionPublicEditTime() {
        $id = Common::queryInt(_p('id'));
        $time = _p('time');
        if (!$id) {
            echo 0;
            return;
        }
        if (_p('timetype') == 1) {
            $time_type = 'start_time';
        } else if (_p('timetype') == 2) {
            $time_type = 'end_time';
        }
        $map = Zhtx::createDataMap();
        if ($time) {
            if (strtotime($time) <= 0) {
                echo 0;
                return;
            }
            $map->addEntry($time_type, strtotime($time), DB::INT);
        }
        $res = $this->goodsLogic->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }

    /**
     * 删除到期商品
     * @return type
     */
    public function actionDelExplireGoods() {
        $special_id = Common::queryInt(_g('id'));
        $special = $this->specialLogic->getOneById($special_id);
        if (!$special) {
            return $this->showMessage('illegal_operation');
        }
        $cond = 'end_time<' . SYS_TIME . ' and special_offer_id=' . $special_id;
        $explireGoods = $this->goodsLogic->findAll($cond);
        if (empty($explireGoods)) {
            return $this->success('delete_success');
        }
        foreach ($explireGoods as $key => $value) {
                $map = Zhtx::createDataMap();
                $map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
                $map->addEntry('old_price', 0, DB::DECIMAL);
                $map->addEntry('start_time', 0, DB::INT);
                $map->addEntry('end_time', 0, DB::INT);
                $map->addEntry('discount', 10, DB::INT);
                $map->addEntry('special_status', 0, DB::INT);
                $map->addEntry('special_offer_id', 0, DB::INT);
                $cond = 'id = ' . $value['id'];
                $res = $this->goodsLogic->update($map, $cond);
                if ($res) {
                    //修改sku价格
                    $sku_map = Zhtx::createDataMap();
                    $sku_map->addEntry('price', 'GREATEST(price,old_price)', DB::DECIMAL);
                    $sku_map->addEntry('old_price', 0, DB::DECIMAL);
                    $where = 'goods_id=' . $value['id'];
                    $res_sku = $this->skuLogic->update($sku_map, $where);
                }
        }
        if ($res) {
            $this->clearGoodsCache();
            return $this->success('delete_success');
        }
        return $this->showMessage('delete_failure');
    }

}

?>
