<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Tag
 *
 * @author xrx
 */
class TagController extends AppController
{

    private $tagLogic;
    private $tagLangLogic;
    private $langLogic;
    private $goodstagrel;
    public function __construct()
    {
        parent::__construct();
        $this->tagLogic = $this->load('goodsTag');
        $this->tagLangLogic = $this->load('goodsTagLanguage');
        $this->langLogic = $this->load('language');
        $this->goodstagrel = $this->load('GoodsTagRel');
    }

    /**
     * 上传图片未处理
     * @return type 
     */
    public function actionAdd()
    {
        if (_p())
        {
            $base_site = Common::validSiteConfig();
            $tagName   = _p('base_name');
            $tip_texts = _p('tip_text');
            $base_name = $tagName[$base_site];
            if (!$base_name)
            {
                return $this->showMessage('name_not_empty');
            }
            /*
            if(!$tip_texts[$base_site])
            {
                return $this->showMessage('tip_text_tips');
            }
             * 
             */
            $where   = 'base_name = "' . $base_name . '"';
            $has_tag = $this->tagLogic->getOne($where);
            if ($has_tag)
            {
                return $this->showMessage('name_already_exists');
            }
            $tag_data = array(
                'base_name'     => Common::strEscape($base_name),
                'tip_text'      => $tip_texts[$base_site],
                'template_page' => _p('template_page'),
                'sort_weight'   => Common::queryInt(_p('sort_weight')),
                'listorder'     => Common::queryInt(_p('listorder')),
                'is_search'     => Common::queryInt(_p('is_search')),
                'create_time'   => SYS_TIME,
                'status'        => Common::queryInt(_p('status')),
                'special_css_class' => _p('special_css_color') ? _p('special_css_color') . ';' : '',
            );
            $res = $this->tagLogic->save($tag_data);
            if ($res)
            {
                if(!_p('listorder')){
                    $map = Zhtx::createDataMap(); 
                    $map->addEntry('listorder', 10*$res, DB::INT);
                    $this->tagLogic->update($map, 'id='.$res);  
                }
                //多语言处理               
                $details      = Inputer::getOrgPost('detail');
                $seo_title    = _p('title');
                $seo_keywords = _p('keywords');
                $seo_descript = _p('descript');
				$tip_image = _p('tip_image');
                foreach ($tagName as $key => $value)
                {
                    $lang_data = array(
                        'base_name'   => Common::strEscape($value),
                        'goods_tag_id'=> $res,
                        'language_id' => $key,
                        'tip_text'    => Common::strEscape($tip_texts[$key]) ,
						'tip_image'    => Common::strEscape($tip_image[$key]),
                        'detail'      => Common::strEscape($details[$key],false),
                        'title'       => Common::strEscape($seo_title[$key]),
                        'keywords'    => Common::strEscape($seo_keywords[$key]),
                        'descript'    => Common::strEscape($seo_descript[$key]),
                    );
                    $this->tagLangLogic->save($lang_data);
                }
                $diy_url_flag = TRUE;
                 if (_p('page_url'))
                {
                    $diyUrlLogic = $this->load('urlAlisa');
                    $true_url    = Common::frontURL('home', 'product', 'list', array('tag_id[]' => $res), FALSE);
                    $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                    $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url, TRUE);
                    if ($diy_res)
                    {
                        $new_cat_map = Zhtx::createDataMap(); 
                        $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                        $this->tagLogic->update($new_cat_map,'id='.$res);
                    }
                    else
                    {
                       $diy_url_flag = FALSE;
                    }                    
                } 
                _crearCahce('tag');//清理缓存
               return $diy_url_flag ? $this->success('add_success', Common::adminURL('product', 'tag', 'list')) : $this->showMessage('diy_url_already_exists');
            }
        }
        else
        {
            global $template;
            $languages = $this->langLogic->getList('status=1');
            core::$tpl->set('languages', $languages['list']);
            core::$tpl->set('template', $template['tag']);
            Core::$htmlFile = 'tag/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionEdit()
    {
        if (_p())
        {
			$id      = Common::queryInt(_p('id'));
            $base_site = Common::validSiteConfig();
            $tagName   = _p('base_name');
            $tip_texts = _p('tip_text');
            $base_name = $tagName[$base_site];
            if (!$base_name)
            {
                return $this->showMessage('name_not_empty');
            }
            /*
            if(!$tip_texts[$base_site])
            {
                return $this->showMessage('tip_text_tips');
            }
             * 
             */
            $tag_data = array(
                'base_name'     => Common::strEscape($base_name),
                'tip_text'      => $tip_texts[$base_site],
                'template_page' => _p('template_page'),
                'sort_weight'   => Common::queryInt(_p('sort_weight')),
                'listorder'     => Common::queryInt(_p('listorder')),
                'is_search'     => Common::queryInt(_p('is_search')),
                'status'        => Common::queryInt(_p('status')),
                'special_css_class' => _p('special_css_color') ? _p('special_css_color') . ';' : '',
            );
            $res = $this->tagLogic->save($tag_data, $id);
            if ($res)
            {
                //多语言处理               
                $details      = Inputer::getOrgPost('detail');
                $seo_title    = _p('title');
                $seo_keywords = _p('keywords');
                $seo_descript = _p('descript');
				$tip_image = _p('tip_image');
                foreach ($tagName as $key => $value)
                {
                    $lang_data = array(
                        'base_name'   => Common::strEscape($value),
                        'goods_tag_id'=> $id,
                        'language_id' => $key,
                        'tip_text'    => Common::strEscape($tip_texts[$key]),
						'tip_image'   => Common::strEscape($tip_image[$key]),
                        'detail'      => Common::strEscape($details[$key],false),
                        'title'       => Common::strEscape($seo_title[$key]),
                        'keywords'    => Common::strEscape($seo_keywords[$key]),
                        'descript'    => Common::strEscape($seo_descript[$key]),
                    );                   
                    $this->tagLangLogic->updateByCond($lang_data);                
                }
                //自定义路径
                $diy_url_flag = TRUE;                
                $diyUrlLogic = $this->load('urlAlisa');
                $true_url    = Common::frontURL('home', 'product', 'list', array('tag_id[]' => $id), FALSE);
                $page_url = str_replace(array('?', '&', '%'), '-', _p('page_url'));
                $diy_res     = $diyUrlLogic->createDiyUrl($page_url, $true_url, true);
                if ($diy_res)
                {
                    $new_cat_map = Zhtx::createDataMap(); 
                    $new_cat_map->addEntry('page_url', Common::strEscape($page_url), DB::VARCHAR);
                    $this->tagLogic->update($new_cat_map, 'id='.$id);
                }
                else
                {
                    $diy_url_flag = FALSE;
                }
                 _crearCahce('tag');//清理缓存
               return $diy_url_flag ? $this->success('edit_success', Common::adminURL('product', 'tag', 'list')) : $this->showMessage('diy_url_already_exists');            
            }
        }
        else
        {
            $id  = _g('id') ? intval(_g('id')) : 0;
            $tag = $this->tagLogic->getOne('id=' . $id);
            if (!$tag)
            {
                return $this->showMessage('not_found_record');
            }
            $tagLangs     = $this->tagLangLogic->getList('goods_tag_id=' . $id);
            $tag_lang_arr = array();
            foreach ($tagLangs['list'] as $item)
            {
                $tag_lang_arr[$item['language_id']] = $item;
            }
            $languages   = $this->langLogic->getList('status=1');
            $lang_arr    = array();
            foreach ($languages['list'] as $item)
            {
                $lang_arr[] = array(
                    'id'             => $item['id'],
                    'base_name'      => $item['base_name'],
                    'country_code_2' => $item['country_code_2'],
                    'lang_name' => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['base_name'] : '',
                    'tip_text'      => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['tip_text'] : '',
                    'tip_image'      => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['tip_image'] : '',
                    'detail'         => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['detail'] : '',
                    'title'          => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['title'] : '',
                    'keywords'       => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['keywords'] : '',
                    'descript'       => isset($tag_lang_arr[$item['id']]) ? $tag_lang_arr[$item['id']]['descript'] : '',
                );
            }
            global $template;
            core::$tpl->set('goodstag', $tag);
            core::$tpl->set('languages', $lang_arr);
            core::$tpl->set('template', $template['tag']);
            Core::$htmlFile = 'tag/form';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionList()
    {
       $page_size = 20;
       $curr_page = Common::queryInt(_g('page'), 1);
        $where = '';
        if (_p('search_value') && _p('search_cond'))
        {
            $where .= _p('search_cond') . " = '" . _p('search_value') . "' ";
        }
		$where .= " ORDER BY listorder DESC,id DESC";
        //分页
        $count     = $this->tagLogic->getCount($where);      
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res  = $this->tagLogic->getCurrentDatas($where, $page_size, $curr_page);
        foreach ($res as $value) {
            $goods_num[$value['id']] = $this->goodstagrel->getCount("tag_id = '{$value['id']}'");
        }
        Core::$tpl->set("goods_num", $goods_num);
	Core::$tpl->set("pages", $page_data);       
        Core::$tpl->set('res', $res);
    }     
    
    
    
    public function actionGoodsList() {
        //分页用的参数
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $tag_id = Common::queryInt(_g('tag_id'), 1);
        $pgids = $this->goodstagrel->findAll('tag_id=' . $tag_id);
		$tags = $this->tagLogic->getOneById($tag_id);
		
        $gids = array(0);
        foreach ($pgids as $key => $value) {
            $gids[] = $value['goods_id'];
        }
        //获取数据
        $where = ' id in (' . implode(",", $gids) . ') ';
        $goodsLogic = $this->load('goods');
        //$results = $goodsLogic->findAll($where);
        //分页
        $count     = $goodsLogic->getCount($where);      
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $results  = $goodsLogic->getCurrentDatas($where, $page_size, $curr_page);
        Common::sort_rows($results,"up_time",SORT_DESC);
        foreach ($results as $value) {
            $type_ids[$value['goods_type_id']] = $value['goods_type_id'];
        }
        $goods_types = array();
        if (count($type_ids) > 0) {
            $goods_types = $this->load('goodsType')->findAll('id in (' . implode(',', $type_ids) . ')', true);
            
            $c_cond = 'g.goods_id in(' . implode(",", $gids) . ')';
            $categories = $this->load('goodsCategoryRelCategory')->findAll($c_cond);
            foreach ($categories as $value) {
                $rel_categories[$value['goods_id']][] = $value;
            }
        }
		Core::$tpl->set("tags", $tags);
        Core::$tpl->set("rel_category", $rel_categories);
        Core::$tpl->set("types", $goods_types);
        Core::$tpl->set("brands", $this->load('brand')->findAll('', true));
        Core::$tpl->set("res", $results);
        Core::$tpl->set("pages", $page_data);
    }
    
    public function actionAddGoods() {
        $goodsids = explode(",", _p('goods_ids'));
        $tag_id = _p('tag_id');
        $res = $this->goodstagrel->findAll("tag_id='{$tag_id}'", true);
        foreach ($res as $key => $value) {
            $ids[] = $value['goods_id'];
        }
        foreach ($goodsids as $key => $value) {
            if (!in_array($value, $ids)) {
                $data = array(
                    'tag_id' => $tag_id,
                    'goods_id' => $value,
                );
                $this->goodstagrel->saveByCond($data);
            }
        }
    }
    
    
    public function actionDelgoods() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $tag_id = (int)_g('tag_id');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            foreach ($ids as $id) {
                $res = $this->goodstagrel->delete(" tag_id = '{$tag_id}' and goods_id = '{$id}'");
                if ($res) {
                    $num++;
                }
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    
	public function actionDelGoodsAll(){
		$tag_id = (int)_g('tag_id');		
		if($this->goodstagrel->delete(" tag_id = '{$tag_id}'")){
			return $this->success("success");
		}
		return $this->message("failure");
	}
    /**
     * ajax 更新状态
     */   
     public function actionDel()
    {
        $lang  = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids   = _p('ids');
        $staus = 0;
        $flag  = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          foreach ($ids as $id)
          {     if($id < 6)
                {
                  continue;
                }
                $tag = $this->tagLogic->getOneById($id);
                $this->load('urlAlisa')->deleteDiyUrl($tag['page_url']);
                $res  = $this->tagLogic->delete('id=' . $id);
                if($res)
                {   
                  $this->tagLangLogic->delete('goods_tag_id=' . $id);
                  $relationLogic = $this->load('goodsTagRel');
                  $relationLogic->delete('tag_id=' . $id);
                  $num++;
                }            
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'];
        }
         _crearCahce('tag');//清理缓存
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
    /**
     * 修改排序
     * ajax 
     */
    public function actionPublicEditSort()
    {
      $id        = Common::queryInt(_p('id'));
      if(!$id)
      {
        echo 0;return;
      }
      $listorder   = Common::queryInt(_p('listorder'));
      $sort_weight = Common::queryInt(_p('sort_weight'));
      $map = Zhtx::createDataMap();
      if($listorder)
      {
        $map->addEntry('listorder', $listorder, DB::INT);
      }
      if($sort_weight)
      {
        $map->addEntry('sort_weight', $sort_weight, DB::INT);
      }
      $res = $this->tagLogic->update($map, 'id=' . $id);
       _crearCahce('tag');//清理缓存
      echo $res ? 1 : 0;
    }
	
	public function actionPublicEditSearchStatus()
	{
		 $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('is_search', $status, DB::INT);
        $res   =  $this->tagLogic->updateById($map, $id);
         _crearCahce('tag');//清理缓存
        echo $res ? 1 : 0;
	}
	
	 public function actionPublicEditStatus()
    {
        $id     = Common::queryInt(_g('id'));
        $status = _g('currentStatus') ? 1 : 0;
        $map    = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res   =  $this->tagLogic->updateById($map, $id);
         _crearCahce('tag');//清理缓存
        echo $res ? 1 : 0;
    }
}

?>
