<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GoodsType
 *
 * @author Administrator
 */
class TypeController extends AppController {

    private $typeLogic;
    private $languageLogic;
    private $propertyLogic;
    private $typePropertyRelLogic;

    public function __construct() {
        parent::__construct();
        $this->typeLogic = $this->load('goodsType');
        $this->languageLogic = $this->load('language');
        $this->propertyLogic = $this->load('property');
        $this->typePropertyRelLogic = $this->load('goodsTypeProperty');
    }

    /**
     * 弹出属性选择列表
     * ajax
     */
    public function actionPublicRelProperty() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'parent_id=0';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }
        $goodsTypePropertyLogic = $this->load('GoodsTypeProperty');
        if (_g('type_id')) {
            $cols = array('property_id');
            $cond = 'goods_type_id=' . Common::queryInt(_g('type_id'));
            $property_ids = $goodsTypePropertyLogic->getCols($cond, $cols);
            $property_ids_str = array();
            foreach ($property_ids as $value) {
                if ($value['property_id'])
                    $property_ids_str[] = $value['property_id'];
            }
            $where .= ' and id in (' . implode(',', $property_ids_str) . ')';
        }
        if (_g('type')) {
            $type = _g('type') == 3 ? 0 : _g('type');
            $where .= ' and type=' . $type;
        }
        $where .= ' ORDER BY id DESC';
        //分页
        $count = $this->propertyLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->propertyLogic->getCurrentDatas($where, $page_size, $curr_page);
        $pids = array();
        foreach ($res as $value) {
            $pids[] = $value['id'];
        }
        $array = array();
        if (count($pids) > 0) {
            $cond2 = 'p.property_id in (' . implode(',', $pids) . ')';
            $cols2 = array('distinct p.goods_type_id as id', 'p.property_id as property_id', 't.base_name as base_name');
            $array = $this->load('GoodsTypePropertyJoinType')->getCols($cond2, $cols2);
        }
        $type = array();
        foreach ($array as $_value) {
            $type[$_value['property_id']] = $_value;
        }
        Core::$tpl->set("property_ids", explode(',', _g('ids')));
        Core::$tpl->set("dialog_ids", _g('ids'));
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('res', $res);
        Core::$tpl->set('types', $type);
        Core::$tpl->set('callback', _g('callback'));
        Core::$htmlFile = 'type/relationproperty';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 构造属性关联的列表
     * ajax
     */
    public function actionPublicGetRelProperty() {
        if (_p('property_ids')) {
            $where = 'id in(' . _p('property_ids') . ')';
            $cols = array('id', 'base_name', 'listorder');
            $propertylist = $this->propertyLogic->getCols($where, $cols);
        }
        $return = array(
            'status' => 1,
            'property_list' => $propertylist,
        );
        echo json_encode($return);
    }

    /**
     * 添加属性
     * ajax
     */
    public function actionAddProperty() {
        if (_p()) {
            $staus = 0;
            $type = Common::queryInt(_p('type')) == 3 ? 0 : Common::queryInt(_p('type'));
            if (Common::queryInt(_p('type')) == 3)
                $value_type = Common::queryInt(_p('value_type'));
            else
                $value_type = 1;
            $base_name = _p('base_name');
            if (!$base_name) {
                echo json_encode(array('status' => $staus));
                exit;
            }
            $alias_name = _p('alias_name');
            $type_base_name = _p('type_base_name');
            if ($alias_name == '' && $type_base_name != '') {
                $alias_name = $type_base_name . '_' . $base_name;
            }
            $listorder = Common::queryInt(_p('listorder'));
            $map = Zhtx::createDataMap();
            $map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $map->addEntry('listorder', $listorder, DB::INT);
            $map->addEntry('value_type', $value_type, DB::INT);
            $map->addEntry('type', $type, DB::INT);
            $map->addEntry('required', Common::queryInt(_p('required')), DB::INT);
            $map->addEntry('search', Common::queryInt(_p('search')), DB::INT);
            $map->addEntry('alias_name', Common::strEscape($alias_name), DB::VARCHAR);
            $map->addEntry('create_time', SYS_TIME, DB::INT);
            $result = $this->propertyLogic->insert($map);
            if ($result) {
                if (!_p('listorder')) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', 10 * $result, DB::INT);
                    $this->propertyLogic->update($map, 'id=' . $result);
                }
                //如果主表信息更新成功,则更新附表信息
                $languages = $this->load('language')->findALL('status=1', true);
                //更新选中的信息
                foreach ($languages as $item) {
                    $propertyLanguage = Zhtx::createDataMap();
                    $propertyLanguage->addEntry('property_id', $result, DB::INT);
                    $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                    $propertyLanguage->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
                    $this->load('propertyLanguage')->insert($propertyLanguage);
                }
                if (!$listorder) {
                    $update_map = Zhtx::createDataMap();
                    $update_map->addEntry('listorder', $result, DB::INT);
                    $this->propertyLogic->updateById($update_map, $result);
                }
                $staus = 1;
                $property = array(
                    'id' => $result,
                    'name' => $base_name,
                    'type' => _p('type'),
                );
                echo json_encode(array('status' => $staus, 'data' => $property));
                exit;
            }
            echo json_encode(array('status' => $staus));
            exit;
        } else {
            $where = '1=1 order by listorder asc';
            $goodsTypes = $this->load('goodsType')->getList($where);
            core::$tpl->set('goodstypes', $goodsTypes['list']);
            $type = Common::queryInt(_g('type'));
            Core::$tpl->set('type', $type);
        }
    }

    /**
     * 导出类型
     */
    public function actionExport() {
        if (_g()) {
            $goods_type_id = Common::queryInt(_g('id'));
            $pagesize = Common::queryInt(_g('pagesize'));
            $pagenum = Common::queryInt(_g('pagenum'));
            if (!$goods_type_id) {
                return $this->showMessage('illegal_operation');
            }
            $goods_type = $this->typeLogic->getOne('id=' . $goods_type_id);
            if (!$goods_type) {
                return $this->showMessage('illegal_operation');
            }
            $pagesize = $pagesize ? $pagesize : 2000;
            $pagenum = $pagenum ? $pagenum : 1;
            $offset = ($pagenum - 1) * $pagesize;
            $cond = 'goods_type_id=' . $goods_type_id . ' limit ' . $offset . ',' . $pagesize;
            $res = $this->typePropertyRelLogic->findAll($cond, false, '', array('goods_type_id', 'property_name', 'property_id', 'property_type'));
            $property_ids = array();
            $property_res = array();
            foreach ($res as $key => $v) {
                $property_ids[$v['property_id']] = $v['property_id'];
            }
            $pro_where = 'parent_id in(' . implode(',', $property_ids) . ')';
            $property = $this->propertyLogic->findAll($pro_where, false, '', array('base_name', 'parent_id'));
            foreach ($property_ids as $key => $value) {
                foreach ($property as $k => $v) {
                    if ($v['parent_id'] == $key) {
                        $property_res[$key][] = $v['base_name'];
                    }
                }
            }
            header("Content-Type: application/force-download");
            header("Content-Type: application/octet-stream");
            header("Content-Type: application/download");
            header("Pragma: no-cache");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            header("Content-type: application/vnd.ms-excel; charset=utf8");
            header("Content-Disposition: inline; filename=\"" . $goods_type['base_name'] . ".csv\"");
            header("Content-Transfer-Encoding: binary");
            echo "Property Name,Property Value,Property Type(#0 common property #1 master sale propertry #2 sale property)\r\n";
            foreach ($res as $key => $data) {
                $data['property_value'] = implode(',', $property_res[$data['property_id']]);
                $data['property_value'] = htmlspecialchars_decode(Common::strEscape($data['property_value']));
                echo '"' . $data['property_name'] . '"' . ',' . '"' . $data['property_value'] . '"' . ',' . '"' . $data['property_type'] . '"' . "\r\n";
            }
            exit();
        }
    }

    public function actionHowtodel() {

    }

    /**
     * 导入类型
     */
    public function actionImport() {
        if (_g() && _g('do')) {
            $base_name = Common::queryStr(_g('base_name'));
            $csv_file = Common::queryStr(_g('file'));
            $status = 0;
            if (!$csv_file) {
                echo json_encode(array('status' => 2));
                exit;
            }
            if (!$base_name) {
                $base_name = substr($csv_file, 0, strpos($csv_file, '.csv'));
            }
            $type = $this->typeLogic->getOne('base_name="' . $base_name . '"');
            if ($type) {
                echo json_encode(array('status' => 3));
                exit;
            }
            if (!file_exists(UPLOAD_DIR . "attachment/csv/goods_type/" . $csv_file)) {
                echo json_encode(array('status' => 4));
                exit;
            }
            $type_map = Zhtx::createDataMap();
            $type_map->addEntry('base_name', Common::strEscape($base_name), DB::VARCHAR);
            $type_map->addEntry('status', 1, DB::INT);
            $res = $this->typeLogic->insert($type_map);
            if ($res) {
                $map = Zhtx::createDataMap();
                $map->addEntry('listorder', $res * 10, DB::INT);
                $this->typeLogic->update($map, 'id=' . $res);
            }
            require_once("./plugins/system/PHPExcel.php");
            require_once("./plugins/system/PHPExcel/Writer/CSV.php");
            require_once("./plugins/system/PHPExcel/IOFactory.php");
            $reader = PHPExcel_IOFactory::createReader('CSV'); //
            $excel = $reader->load(UPLOAD_DIR . "attachment/csv/goods_type/" . $csv_file); //
            $sheet = $excel->getSheet(0);
            $row = $sheet->getHighestRow(); // 取得总行数
            $col = $sheet->getHighestColumn(); // 取得总列数
            for ($index = 2; $index <= $row; $index++) {
                $property_name = trim(Common::strEscape($sheet->getCellByColumnAndRow(0, $index)->getValue()));
                $property_value = trim(Common::strEscape($sheet->getCellByColumnAndRow(1, $index)->getValue()));
                $property_type = trim(Common::strEscape($sheet->getCellByColumnAndRow(2, $index)->getValue()));

                $property_map = Zhtx::createDataMap();
                $property_map->addEntry('base_name', Common::strEscape($property_name), DB::VARCHAR);
                $property_map->addEntry('parent_id', 0, DB::INT);
                $property_map->addEntry('status', 1, DB::INT);
                $property_map->addEntry('type', $property_type, DB::INT);
                $property_map->addEntry('alias_name', Common::strEscape($base_name . ' ' . $property_name), DB::VARCHAR);
                $property_map->addEntry('create_time', SYS_TIME, DB::INT);
                switch ($property_type) {
                    case 1:
                        $value_type = 1;
                        break;
                    case 2:
                        $value_type = 1;
                        break;
                    default:
                        $value_type = 2;
                        break;
                }
                $property_map->addEntry('value_type', $value_type, DB::TINYINT);
                $property_res = $this->propertyLogic->insert($property_map);
                if ($property_res) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', $property_res * 10, DB::INT);
                    $this->propertyLogic->update($map, 'id=' . $property_res);
                    //如果主表信息更新成功,则更新附表信息
                    $languages = $this->load('language')->findALL('status=1', true);
                    foreach ($languages as $item) {
                        $propertyLanguage = Zhtx::createDataMap();
                        $propertyLanguage->addEntry('property_id', $property_res, DB::INT);
                        $propertyLanguage->addEntry('language_id', $item["id"], DB::INT);
                        $propertyLanguage->addEntry('base_name', Common::strEscape($property_name), DB::VARCHAR);
                        $this->load('propertyLanguage')->insert($propertyLanguage);
                    }
                }
                $goods_type_property = explode(',', $property_value);
                foreach ($goods_type_property as $key => $value) {
                    $property_value_map = Zhtx::createDataMap();
                    $property_value_map->addEntry('base_name', Common::strEscape($value), DB::VARCHAR);
                    $property_value_map->addEntry('parent_id', $property_res, DB::INT);
                    $property_value_map->addEntry('status', 1, DB::INT);
                    $property_value_map->addEntry('type', $property_type, DB::INT);
                    $property_value_map->addEntry('alias_name', Common::strEscape($base_name . ' ' . $value), DB::VARCHAR);
                    $property_value_map->addEntry('create_time', SYS_TIME, DB::INT);
                    $property_value_map->addEntry('value_type', $value_type, DB::TINYINT);
                    $property_value_res = $this->propertyLogic->insert($property_value_map);

                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', $property_value_res * 10, DB::INT);
                    $this->propertyLogic->update($map, 'id=' . $property_value_res);
                }
                $type_map = Zhtx::createDataMap();
                $type_map->addEntry('property_id', $property_res, DB::INT);
                $type_map->addEntry('property_name', Common::strEscape($property_name), DB::VARCHAR);
                $type_map->addEntry('goods_type_id', $res, DB::INT);
                $type_map->addEntry('property_type', $property_type, DB::TINYINT);
                $type_map->addEntry('status', 1, DB::INT);
                $this->typePropertyRelLogic->insert($type_map);
                $status = 1;
            }
            echo json_encode(array('status' => $status, 'href' => Common::adminURL('product', 'type', 'list')));
            exit;
        } else {
            //读取CSV表格
            $csvList = $this->getCsvList();
            Core::$tpl->set('csvList', $csvList);
        }
    }

    /**
     * 获取csv文件列表
     * @return type
     */
    private function getCsvList($seo_dir = 'goods_type') {
        $files = array();
        $fp = opendir(UPLOAD_DIR . "attachment/csv/" . $seo_dir . "/");
        while ($file = readdir($fp)) {
            if ($file != '.' && $file != '..' && $file != '.svn') {
                if (is_file(UPLOAD_DIR . "attachment/csv/" . $seo_dir . "/" . $file)) {
                    $file_item = array();
                    $fileInfos = pathinfo($file);
                    $file_name = basename($file, '.' . $fileInfos['extension']);
                    if (in_array($fileInfos['extension'], array('csv', 'csvx'))) {
                        $file_item["name"] = $file_name;
                        $file_item["file"] = $file;
                        $files[] = $file_item;
                    }
                }
            }
        }
        closedir($fp);
        return $files;
    }

    public function actionList() {
        $page_size = 20;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = '1=1';
        if (_g('base_name')) {
            $where .= " and base_name like '%" . _g('base_name') . "%'";
        }

        $where .= ' ORDER BY listorder DESC,id DESC';
        //分页
        $count = $this->typeLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $res = $this->typeLogic->getCurrentDatas($where, $page_size, $curr_page);
        $typeids = "";
		$ids = array(0);
        foreach ($res as &$val) {
            if ($val["id"]) {
                $typeids.=$val["id"] . ",";
            }
			$ids[] = $val["id"] ;
        }
		
        //分页
        $gres = $this->load('goods')->getCols('goods_type_id in ('.join(',',$ids).') group by goods_type_id', $cols = array("goods_type_id","count(*) as v"));
		foreach($gres as $value)
		{
			$g_type_counts[$value['goods_type_id']] = 	$value['v'] ;
		}
        $typeids = trim($typeids, ",");
        if($typeids)
        {
            $gtpres = $this->typePropertyRelLogic->getCols("goods_type_id in(" . join(',',$ids) . ") group by goods_type_id", array("goods_type_id,count(id) as counts"));
            $typeCount = array();
            foreach ($gtpres as &$gval) {
                $typeCount[$gval["goods_type_id"]] = $gval["counts"];
            }
        }
        Core::$tpl->set("typeCount", $typeCount);
		Core::$tpl->set("g_type_counts", $g_type_counts);
        Core::$tpl->set("pages", $page_data);
        Core::$tpl->set('types', $res);
    }

    public function actionAdd() {
        if (_p()) {
            $name = _p('base_name');
            if (!$name) {
                return $this->showMessage('name_not_empty');
            }
            $existed = $this->typeLogic->getOne('base_name = "' . $name . '"');
            if ($existed) {
                return $this->showMessage('name_already_exists');
            }

            $type_map = Zhtx::createDataMap();
            $type_map->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
            $type_map->addEntry('listorder', Common::queryInt(_p('listorder')), DB::INT);
            $type_map->addEntry('status', Common::queryInt(_p('status')), DB::INT);
            $res = $this->typeLogic->insert($type_map);
            if ($res) {
                if (!_p('listorder')) {
                    $map = Zhtx::createDataMap();
                    $map->addEntry('listorder', 10 * $res, DB::INT);
                    $this->typeLogic->update($map, 'id=' . $res);
                }
                if (_p('master_sale') || _p('sale') || _p('common_property')) {
                    $property_ids = array();
                    $master_sale = _p('master_sale');
                    $is_sale = _p('sale');
                    $other_property = _p('common_property');
                    if ($master_sale)
                        $property_ids[] = $master_sale;
                    if ($is_sale)
                        $property_ids[] = $is_sale;
                    foreach ($other_property as $pro) {
                        if ($pro)
                            $property_ids[] = $pro;
                    }
                    $propertyIds = implode(',', $property_ids);

                    $cond = 'id in (' . $propertyIds . ')';
                    $propertys = $this->propertyLogic->getList($cond);
                    foreach ($propertys['list'] as $item) {
                        $property_data = array(
                            'goods_type_id' => $res,
                            'property_id' => $item['id'],
                            'property_name' => $item['base_name'],
                            'status' => $item['status'],
                            'property_type' => $item['type'],
                        );
                        $this->typePropertyRelLogic->save($property_data);
                    }
                }
            }
            return $res ? $this->success('add_success', Common::adminURL('product', 'type', 'list')) : $this->showMessage('failure');
        } else {
            //属性
            $propertyList = $this->propertyLogic->getList('parent_id=0');
            $master_sale = array();
            $sale = array();
            $other_property = array();
            foreach ($propertyList['list'] as $item) {
                if ($item['type'] == 1) {
                    $master_sale[] = $item;
                } else if ($item['type'] == 2) {
                    $sale[] = $item;
                } else {
                    $other_property[] = $item;
                }
            }
            Core::$tpl->set('master_sale_property', $master_sale);
            Core::$tpl->set('sale_property', $sale);
            Core::$tpl->set('other_property', $other_property);
            Core::$htmlFile = "type/form";
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    public function actionEdit() {
        if (_p()) {
            $id = _p('id') ? intval(_p('id')) : 0;
            $name = _p('base_name');
            if (!$name) {
                return $this->showMessage('name_not_empty');
            }
            $cond = 'id !=' . $id . ' AND base_name = "' . $name . '"';
            $existed = $this->typeLogic->getOne($cond);
            if ($existed) {
                return $this->showMessage('name_already_exists');
            }
            $type_map = Zhtx::createDataMap();
            $type_map->addEntry('base_name', Common::strEscape($name), DB::VARCHAR);
            $type_map->addEntry('listorder', _p('listorder'), DB::INT);
            $type_map->addEntry('status', _p('status'), DB::INT);
            $res = $this->typeLogic->update($type_map, 'id=' . $id);
            if ($res) {
                if (_p('master_sale') || _p('sale') || _p('common_property')) {
                    $property_ids = array();
                    $master_sale = _p('master_sale');
                    $is_sale = _p('sale');
                    $other_property = _p('common_property');
                    if ($master_sale)
                        $property_ids[] = $master_sale;
                    if ($is_sale)
                        $property_ids[] = $is_sale;
                    foreach ($other_property as $pro) {
                        if ($pro)
                            $property_ids[] = $pro;
                    }
                    $propertyIds = implode(',', $property_ids);
                    $cond = 'id in (' . $propertyIds . ')';
                    $propertys = $this->propertyLogic->findAll($cond);
                    $existed_pro = array();
                    $existed_pro_ids = array();
                    $typePropertys = $this->typePropertyRelLogic->findAll('goods_type_id=' . $id);
                    foreach ($typePropertys as $_v) {
                        $existed_pro[$_v['property_id']] = $_v;
                        $existed_pro_ids[] = $_v['property_id'];
                    }

                    foreach ($propertys as $item) {
                        $property_data = array(
                            'goods_type_id' => $id,
                            'property_id' => $item['id'],
                            'property_name' => $item['base_name'],
                            'status' => $item['status'],
                            'property_type' => $item['type'],
                        );
                        $cur_id = isset($existed_pro[$item['id']]) ? $existed_pro[$item['id']]['id'] : 0;
                        $this->typePropertyRelLogic->save($property_data, $cur_id);
                    }
                    $diff = array_diff($existed_pro_ids, $property_ids);
                    if (!empty($diff)) {
                        $del_cond = 'goods_type_id =' . $id . ' and property_id in (' . implode(',', $diff) . ')';
                        $this->typePropertyRelLogic->delete($del_cond);
                    }
                }
            }
            return $res ? $this->success('add_success', Common::adminURL('product', 'type', 'list')) : $this->showMessage('failure');
        } else {
            $id = _g('id') ? intval(_g('id')) : 0;
            $type = $this->typeLogic->getOne('id =' . $id);
            if (!$type) {
                return $this->showMessage('not_found_record');
            }
            //属性
            $my_propertys = $this->typePropertyRelLogic->getList('goods_type_id=' . $id);
            $my_pro_arr = array();
            $existmasterSale = 0;
            $existsale = 0;
            foreach ($my_propertys['list'] as $item) {
                if ($item['property_type'] == 1) {
                    $existmasterSale = $item['property_id'];
                } else if ($item['property_type'] == 2) {
                    $existsale = $item['property_id'];
                } else {
                    $my_pro_arr[$item['property_id']] = $item['property_id'];
                    $property_ids[] = $item['property_id'];
                }
            }

            $propertyList = $this->propertyLogic->getList('parent_id=0');
            $master_sale = array();
            $sale = array();
            $other_property = array();
            foreach ($propertyList['list'] as $item) {
                if ($item['type'] == 1) {
                    $master_sale[$item['id']] = $item;
                } else if ($item['type'] == 2) {
                    $sale[$item['id']] = $item;
                } else {
                    $other_property[$item['id']] = $item;
                }
            }
            Core::$tpl->set('property_ids', implode(',', $property_ids));
            Core::$tpl->set('type', $type);
            Core::$tpl->set('master_sale_property', $master_sale);
            Core::$tpl->set('sale_property', $sale);
            Core::$tpl->set('other_property', $other_property);
            Core::$tpl->set('mymaster', $existmasterSale);
            Core::$tpl->set('mysale', $existsale);
            Core::$tpl->set('mypropertys', $my_pro_arr);
            Core::$htmlFile = "type/form";
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . ".htm");
        }
    }

    /**
     * ajax 更新状态
     */
    public function actionPublicEditStatus() {
        $id = Common::queryInt(_g('id'));
        $status = _g('currentStatus');
        $map = Zhtx::createDataMap();
        $map->addEntry('status', $status, DB::INT);
        $res = $this->typeLogic->updateById($map, $id);
        echo $res ? 1 : 0;
    }

    /**
     * 删除类型 同时删除类型与属性间的关系表数据
     */
    public function actionDel() {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _g('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids)) {
            $num = 0;
            $enum = 0;
            foreach ($ids as $id) {
                $where = 'goods_type_id=' . $id;
				$g_count = $this->load('goods')->getCount($where) ;
                if ($g_count) {
                    $goodsType = $this->load('goodsType')->getOne('id=' . $id);
                    $enum++;
					$flag =  $lang['delete_failure'] . $g_count . "个商品" . $lang['has_type_goods_rel'];
					return $this->error($flag, Common::adminURL('product', 'type', 'list'));
                } else {
                    $res = $this->typeLogic->delete('id=' . $id);
                    if ($res) {
                        $this->typePropertyRelLogic->delete('goods_type_id=' . $id);
                        $num++;
                    }
					 $flag = $lang['success_delete'] . $num . $lang['num_records'] ;
					 return $this->success($flag, Common::adminURL('product', 'type', 'list'));

                }
            }
			
            $staus = 1;
            ;
        }
       // echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

    /**
     * 修改排序
     * ajax
     */
    public function actionPublicEditSort() {
        $id = Common::queryInt(_p('id'));
        if (!$id) {
            echo 0;
            return;
        }
        $listorder = Common::queryInt(_p('listorder'));
        $map = Zhtx::createDataMap();
        $map->addEntry('listorder', $listorder, DB::INT);
        $res = $this->typeLogic->update($map, 'id=' . $id);
        echo $res ? 1 : 0;
    }
    
    /**
     * 关联已有普通属性
     */
    public function actionSetPublicProperty()
    {
        if (_p()) {
            $id = _p('id') ? intval(_p('id')) : 0;
            $type = $this->typeLogic->getOne('id =' . $id);
            if (!$type) {
                $return = array('status'=>0,'msg'=>'not_found_record');
                echo json_encode($return);
                return;
            }
            $other_property = explode(',',_p('property_ids'));
            $property_ids = array();
            foreach ($other_property as $pro) {
                $pro = Common::queryInt($pro);
                if ($pro){
                    $property_ids[] = $pro;
                }
            }
            if($property_ids)
            {
                $propertyIds = implode(',', $property_ids);
                $cond = 'id in (' . $propertyIds . ')';
                $propertys = $this->propertyLogic->findAll($cond);
            }
            $existed_pro = array();
            $existed_pro_ids = array();
            $typePropertys = $this->typePropertyRelLogic->findAll('goods_type_id=' . $id .' and property_type=0');
            foreach ($typePropertys as $_v) {
                $existed_pro[$_v['property_id']] = $_v;
                $existed_pro_ids[] = $_v['property_id'];
            }

            foreach ($propertys as $item) {
                $property_data = array(
                    'goods_type_id' => $id,
                    'property_id' => $item['id'],
                    'property_name' => $item['base_name'],
                    'status' => $item['status'],
                    'property_type' => $item['type'],
                );
                $cur_id = isset($existed_pro[$item['id']]) ? $existed_pro[$item['id']]['id'] : 0;
                $this->typePropertyRelLogic->save($property_data, $cur_id);
            }
            $diff = array_diff($existed_pro_ids, $property_ids);
            if (!empty($diff)) {
                $del_cond = 'goods_type_id =' . $id . ' and property_id in (' . implode(',', $diff) . ')'.' and property_type=0';
                $this->typePropertyRelLogic->delete($del_cond);
            } 
            $return = array('status'=>1,'msg'=>'success');
            echo json_encode($return);
            return;    
        }
    }

}

?>
