<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Cart
 *
 * @author zjh <QQ:1134137194 www.35zh.com>
 */
class CartController extends AppController {

    private $userCartLogic;
    private $goodsLogic;

    public function __construct() {
        parent::__construct();
        $this->userCartLogic = $this->load('userCart');
        $this->goodsLogic = $this->load('goods');
    }

    public function actionList() {
        $cond = '1=1';
        $current_page = Common::queryInt(_g('page'), 1);
        $limit = Common::queryInt(_g('limit'), 20);
        $date_id = Common::queryInt(_g('date_id'));
        if (_g('start_time')) {
            $cond .= ' and create_time>=' . strtotime(_g('start_time'));
            $now = _g('start_time');
        }  else {
            $now = date('Y-m-d', SYS_TIME);
        }
        if (_g('end_time')) {
            $cond .= ' and create_time<' . strtotime(_g('end_time'));
        }
        if (_g('language_id')) {
            $cond .= ' and language_id = ' . _g('language_id');
        }
        
        $cols = array(
            'id as cart_id','goods_id', 'sum(product_num) as cart_counts','language_id','create_time'
        );
        $cond .= ' group by goods_id order by cart_counts desc';
        $count = $this->userCartLogic->findAll($cond,false,"",$cols);
		
        $count = count($count);
        $pages = Common::getPages($count, $current_page, $limit);
        $list = $this->userCartLogic->getCurrentDatas($cond, $limit, $current_page, $cols);
        $goods_ids = array(0);
        foreach ($list as $item) {
            $goods_ids[] = $item['goods_id'];
        }
        $cols = array('id','base_name as goods_name','codeno as goods_number','image','visit_counts','buy_counts','wishlist_counts','comment_counts',);
        $goods_cond = 'id in (' . join(',', $goods_ids) . ')';
        $goods = $this->goodsLogic->getCols($goods_cond, $cols);
        
        foreach($list as $key=>$value){
            foreach($goods as $k=>$v){
                if($value['goods_id']==$v['id']){
                    $list[$key]+=$goods[$k];
                }
            }
        }
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        
        Core::$tpl->set('page', $current_page);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('sites', $this->load('language')->findAll());
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_s_time', _g('start_time'));
        Core::$tpl->set('selected_e_time', _g('end_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('date_id', $date_id);
    }
    
    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if (!empty($ids))
        {
            $num = 0;
            foreach ($ids as $id)
            {
                $res = $this->userCartLogic->delete('goods_id=' . $id);
                $num++;
            }
            $staus = 1;
            $flag = $lang['success_delete'] . $num . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }

}

?>
