<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Goods_sale
 *
 * @author NT <QQ:415080528 www.35zh.com>
 */
class Goods_saleController extends AppController
{

    private $languageLogic;
    private $goodsLogic;
    private $goodsCategoryLogic;
    private $goodstpl;

    public function __construct()
    {
        parent::__construct();
        $this->languageLogic = $this->load('language');
        $this->goodsLogic = $this->load('goods');
        $this->goodsCategoryLogic = $this->load('goodsCategory');
        $csv_tpl = array();
        $csv_tpl[] = "\"Goods ID\"";
        $csv_tpl[] = "\"Goods_name\"";
        $csv_tpl[] = "\"CodeNo\"";
        $csv_tpl[] = "\"Stock\"";
        $csv_tpl[] = "\"Sold\"";
        $csv_tpl[] = "\"Sales Amount\"";
        $csv_tpl[] = "\"Orders Count\"";
        $csv_tpl[] = "\"Visit Counts\"";
        $csv_tpl[] = "\"Review Counts\"";
        $csv_tpl[] = "\"Wishlist Counts\"";
        $this->goodstpl = $csv_tpl;
    }

    public function actionList()
    {
        $current_page = Common::queryInt(_g('page'), 1);
        $date_id = Common::queryInt(_g('date_id'));
        $cond = '1=1';
        if (_g('codeno'))
        {
            $goodsdata = $this->goodsLogic->getOne("codeno='" . Common::queryStr(_g('codeno')) . "'");
            if ($goodsdata)
            {
                $cond .= ' and oi.goods_id=' . $goodsdata['id'];
            }
            else
            {
                return $this->showMessage('goods_codeno_error');
            }
        }
        if (_g('category_id'))
        {
            $cate = $this->goodsCategoryLogic->getOne("id=" . Common::queryInt(_g('category_id')));
            if ($cate)
            {
                $cond .= ' and gcr.category_path like "' . $cate['path_id'] . '%"';
            }
            else
            {
                return $this->showMessage('goods_category_error');
            }
        }
        if (_g('start_time'))
        {
            $cond .= ' and o.create_time >=' . strtotime(_g('start_time'));
        }
        if (_g('end_time'))
        {
            $cond .= ' and o.create_time <' . strtotime(_g('end_time'));
        }
        if (_g('language_id'))
        {
            $cond .= ' and o.language_id=' . Common::queryInt(_g('language_id'));
        }
        if (_g('order_status'))
        {
            $cond .= ' and o.order_status=' . Common::queryInt(_g('order_status'));
        }
        $mid_sql = ' from z_order_item as oi left join z_order as o on oi.order_id = o.id left join z_goods_category_rel as gcr on oi.goods_id=gcr.goods_id where ' . $cond;

        $orderItemJoinOrderLogic = $this->load('OrderItemJoinOrderJoinGoodsCategoryRel');
        $cols = array(
            'oi.goods_id as goods_id', 'oi.goods_name as base_name', 'oi.product_image as image', 'sum(oi.buy_num) as sales_counts', 'sum(oi.price/o.currency_rate) as sale_amount', 'count(distinct o.id) as order_counts','g.buy_counts as buy_counts'
        );
        $cond .=' group by oi.goods_id order by buy_counts desc';
        $count_sql = 'SELECT count(DISTINCT oi.goods_id) AS count ' . $mid_sql;
        $count_array = $orderItemJoinOrderLogic->query($count_sql);
        $count = $count_array[0]['count'];
        $list = $orderItemJoinOrderLogic->getCurrentDatas($cond, 20, $current_page, $cols);
        $pages = Common::getPages($count, $current_page, 20);
        $goods_ids = array();
        foreach ($list as $key => $rows)
        {
            $goods_ids[] = $rows['goods_id'];
        }
        if ($goods_ids)
        {
            $goodsJoinLanguageLogic = $this->load('GoodsJoinLanguage');
            if (_g('language_id'))
                $goods_res = $goodsJoinLanguageLogic->findAll('l.goods_id in(' . join(',', $goods_ids) . ') and l.language_id=' . Common::queryInt(_g('language_id')));
            else
                $goods_res = $goodsJoinLanguageLogic->findAll('l.goods_id in(' . join(',', $goods_ids) . ')');
            $goods = array();
            foreach ($goods_res as $key => $rows)
            {
                $goods[$rows['id']] = $rows;
            }
            Core::$tpl->set('goods', $goods);
        }
        Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_s_time', _g('start_time'));
        Core::$tpl->set('selected_e_time', _g('end_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('selected_order_status', _g('order_status'));
        Core::$tpl->set('date_id', $date_id);
        $allcate = $this->goodsCategoryLogic->findAll('parent_id>=0', false, '', array('id', 'base_name'));
        $allcatejson = json_encode($allcate);
        $allcatejson = str_replace('\"', '', $allcatejson);
        $allcatejson = str_replace('\'', '', $allcatejson);
        Core::$tpl->set('allcatejson', $allcatejson);
    }

    public function actionExport()
    {
        if (_p())
        {
            $current_page = Common::queryInt(_p('page'), 1);
            $pagesize = Common::queryInt(_p('pagesize'), 2000);
            $cond = '1=1';
            if (_p('codeno'))
            {
                $goodsdata = $this->goodsLogic->getOne("codeno='" . Common::queryStr(_p('codeno')) . "'");
                if ($goodsdata)
                {
                    $cond .= ' and oi.goods_id=' . $goodsdata['id'];
                }
                else
                {
                    return $this->showMessage('goods_codeno_error');
                }
            }
            if (_p('category_id'))
            {
                $cate = $this->goodsCategoryLogic->getOne("id=" . Common::queryInt(_p('category_id')));
                if ($cate)
                {
                    $cond .= ' and gcr.category_path like "' . $cate['path_id'] . '%"';
                }
                else
                {
                    return $this->showMessage('goods_category_error');
                }
            }
            if (_p('start_time'))
            {
                $cond .= ' and o.create_time >=' . strtotime(_p('start_time'));
            }
            if (_p('end_time'))
            {
                $cond .= ' and o.create_time <' . strtotime(_p('end_time'));
            }
            if (_p('language_id'))
            {
                $cond .= ' and o.language_id=' . Common::queryInt(_p('language_id'));
            }
            if (_p('order_status'))
            {
                $cond .= ' and o.order_status=' . Common::queryInt(_p('order_status'));
            }
            $mid_sql = ' from z_order_item as oi left join z_order as o on oi.order_id = o.id left join z_goods_category_rel as gcr on oi.goods_id=gcr.goods_id where ' . $cond;

            $orderItemJoinOrderLogic = $this->load('OrderItemJoinOrderJoinGoodsCategoryRel');
            $cols = array(
                'oi.goods_id as goods_id', 'oi.goods_name as base_name', 'oi.product_image as image', 'sum(oi.buy_num) as buy_counts', 'sum(oi.price/o.currency_rate) as sale_amount', 'count(distinct o.id) as order_counts'
            );
            $cond .=' group by oi.goods_id order by buy_counts desc';
            $count_sql = 'SELECT count(DISTINCT oi.goods_id) AS count ' . $mid_sql;
            $count_array = $orderItemJoinOrderLogic->query($count_sql);
            $count = $count_array[0]['count'];
            $list = $orderItemJoinOrderLogic->getCurrentDatas($cond, $pagesize, $current_page, $cols);
            $pages = Common::getPages($count, $current_page, $pagesize);
            $goods_ids = array();
            foreach ($list as $key => $rows)
            {
                $goods_ids[] = $rows['goods_id'];
            }
            if ($goods_ids)
            {
                $goodsJoinLanguageLogic = $this->load('GoodsJoinLanguage');
                if (_p('language_id'))
                    $goods_res = $goodsJoinLanguageLogic->findAll('l.goods_id in(' . join(',', $goods_ids) . ') and l.language_id=' . Common::queryInt(_p('language_id')));
                else
                    $goods_res = $goodsJoinLanguageLogic->findAll('l.goods_id in(' . join(',', $goods_ids) . ')');
                $goods = array();
                foreach ($goods_res as $key => $rows)
                {
                    $goods[$rows['id']] = $rows;
                }
                $file_name = "Goods-Sales-Report-"._p('start_time').'_'._p('end_time').'-' . _p('category_id') . "-" . $pagesize . "-" . $pagenum . "-" . $page_list['total_pages'] . ".csv";
                header("Content-Type: application/force-download");
                header("Content-Type: application/octet-stream");
                header("Content-Type: application/download");
                header("Pragma: no-cache");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Content-type: application/vnd.ms-excel; charset=utf8");
                header("Content-Disposition: inline; filename=\"" . $file_name . "\"");
                header("Content-Transfer-Encoding: binary");
                $publicproperty = array();
                $excel_title = $this->set_menu($ex_type);
                $excel_title = implode(',', $excel_title);
                $excel_title.="\r\n";
                echo $excel_title;
                foreach ($list as $key => $data)
                {
                    if (!empty($data))
                    {
                        $tpl_cache.='"';
                        $tpl_cache.=$data["goods_id"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$data["base_name"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$goods[$data["goods_id"]]["codeno"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$goods[$data["goods_id"]]["stock_nums"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$data["buy_counts"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$data["sale_amount"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$data["order_counts"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$goods[$data["goods_id"]]["visit_counts"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$goods[$data["goods_id"]]["comment_counts"];
                        $tpl_cache.='",';

                        $tpl_cache.='"';
                        $tpl_cache.=$goods[$data["goods_id"]]["wishlist_counts"];
                        $tpl_cache.='"';
                        $tpl_cache.="\r\n";
                    }
                }
                echo $tpl_cache;
                exit;
            }
            else
            {
                return $this->showMessage('not_found_record');
            }
        }
        else
        {
            Core::$tpl->set('sites', $this->languageLogic->findAll('status=1'));
        }
    }

    private function set_menu($ex_type)
    {
        return $this->goodstpl;
    }

}

?>