<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SearchKeywords
 *
 * @author NT <QQ:415080528 www.35zh.com>
 */
class Order_moneyController extends AppController {

    private $userReportLogic;
    private $languageLogic;
    private $orderLogic;
    private $language_id;

    public function __construct() {
        parent::__construct();
        $this->userReportLogic = $this->load('userReport');
        $this->languageLogic = $this->load('language');
        $this->orderLogic = $this->load('order');
    }

    public function actionList() {
        $base_sites    = Common::validSiteConfig();
        $language    =  $this->languageLogic->getOneById($base_sites);
        $this->language_id = $language['id'];
        $cond = '1=1';
        $current_page = Common::queryInt(_g('page'), 1);
        $limit = Common::queryInt(_g('limit'), 31);
        $date_id = Common::queryInt(_g('counttype'));
        $ddzt = Common::queryInt(_g('ddzt'));

        if (_g('language_id')) {
            $cond .= ' and language_id = ' . _g('language_id');
        }else{
            $cond .= ' and language_id = '.$this->language_id;
        }
        
        switch ($ddzt) {
            case 1:
                    $ddztcn = "全部";
                   
                break;
            case 2:
                    $ddztcn = "已付款";
                    $cond .= ' and order_status in (200,201,700,205,105,202,203,204)';
                break;
            case 3:
                    $ddztcn = "未付款";
                    $cond .= ' and order_status not in (200,201,700,205,105,202,203,204)';
                break;
            default:
                break;
        }
        
        switch ($date_id) {
            case 1:
                if (_g('date')) {
                    $year = date('Y',strtotime(_g('date')));
                }  else {
                    $year = date('Y',time());
                }
                $start_time =  strtotime($year.'-01-01');
                $end_time =  strtotime($year.'-12-31')+60*60*24;
                $cond .= ' and create_time>=' . $start_time.' and create_time<' . $end_time;
                $cols = array(
                    'count(*) as num','sum(final_amount/currency_rate) as c', "MONTH(FROM_UNIXTIME(create_time, '%Y-%m-%d')) as t"
                );
                $counttype = "月";
                break;
            case 2:
                if (_g('date')) {
                    $date = date('Y-m-d',strtotime(_g('date')));
                }  else {
                    $date = date('Y-m-d',time());
                }
                $start_time =  strtotime($date);
                $end_time =  strtotime("+1 months",$start_time);
                $cond .= ' and create_time>=' . $start_time.' and create_time<' . $end_time;
                $cols = array(
                    'count(*) as num','sum(final_amount/currency_rate) as c', "DAYOFMONTH(FROM_UNIXTIME(create_time, '%Y-%m-%d')) as t"
                );
                $counttype = "日";
                break;
            default:
                if (_g('date')) {
                    $year = date('Y',strtotime(_g('date')));
                }  else {
                    $year = date('Y',time());
                }
                $start_time =  strtotime($year.'-01-01');
                $end_time =  strtotime($year.'-12-31')+60*60*24;
                $cond .= ' and create_time>=' . $start_time.' and create_time<' . $end_time;
                $cols = array(
                    'count(*) as num','sum(final_amount/currency_rate) as c', "MONTH(FROM_UNIXTIME(create_time, '%Y-%m-%d')) as t"
                );
                $counttype = "月";
                break;
        }
        $cond .= ' group by t order by t desc';
        $count = $this->orderLogic->findAll($cond,false,"",$cols);
        $count = count($count);
        $pages = Common::getPages($count, $current_page, $limit);
        $list = $this->orderLogic->getCurrentDatas($cond, $limit, $current_page, $cols);
        //循环，伪造 天数 为空的数组
        if($date_id == 2){
            foreach ($list as $key => $value) {
                $lists[$value[t]] = $value;
            }
            $total_days = date('t',  strtotime($date));
            $total_days = (int)$total_days;
            for ($index = 1; $index <= $total_days; $index++) {
                if(!$lists[$index]){
                    $lists[$index]['num']=0;
                    $lists[$index]['0']=0;
                    $lists[$index]['c']=0;
                    $lists[$index]['1']=$index;
                    $lists[$index]['t']=$index;
                }
            }
            unset($list);
            $list = $lists;
            krsort($list);
        }
        $ccount = 0;
        foreach ($list as $value) {
            $ccount+=$value[c];
        }
        foreach ($list as $k=>$v) {
            $list[$k]['persent'] = $v['c']/$ccount*100;
        }
        //排序
        $languages = $this->languageLogic->findAll();

        Core::$tpl->set('page', $current_page);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('sites', $this->load('language')->findAll());
        Core::$tpl->set('res', $list);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('ddzt', $ddztcn);
        Core::$tpl->set('ccount', $ccount);
        Core::$tpl->set('cursite', $languages[_g('language_id')-1]['base_name']);
        Core::$tpl->set('selected_date', _g('date'));
        Core::$tpl->set('limit', $limit);
        Core::$tpl->set('counttype', $counttype);
        Core::$tpl->set('selected_site', _g('language_id')?_g('language_id'):$this->language_id);
        Core::$tpl->set('now', $now);
    }

}

?>