<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SearchKeywords
 *
 * @author NT <QQ:415080528 www.35zh.com>
 */
class SearchKeywordsController extends AppController {

    private $userReportLogic;
    private $languageLogic;
    private $countryLogic;
    private $userKeywordsLogic;

    public function __construct() {
        parent::__construct();
        $this->userReportLogic = $this->load('userReport');
        $this->languageLogic = $this->load('language');
        $this->countryLogic = $this->load('country');
        $this->userKeywordsLogic = $this->load('userKeywords');
    }

    public function actionList() {
        $cond = '1=1';
        $current_page = Common::queryInt(_g('page'), 1);
        $limit = Common::queryInt(_g('limit'), 20);
        $date_id = Common::queryInt(_g('date_id'));
        if (_g('start_time')) {
            $cond .= ' and create_time>=' . strtotime(_g('start_time'));
            $now = _g('start_time');
        }  else {
            $now = date('Y-m-d', SYS_TIME);
        }
        if (_g('end_time')) {
            $cond .= ' and create_time<' . strtotime(_g('end_time'));
        }
        if (_g('language_id')) {
            $cond .= ' and language_id = ' . _g('language_id');
        }
        $cols = array(
            'id', 'keywords','language_id', 'count(id) as search_counts',' max(id) as maxid ',
        );
        $cond .= ' group by keywords order by search_counts desc';
        $count = $this->userKeywordsLogic->findAll($cond,false,"",$cols);
		
        $count = count($count);
        $pages = Common::getPages($count, $current_page, $limit);
        $list = $this->userKeywordsLogic->getCurrentDatas($cond, $limit, $current_page, $cols);
        $max_ids = array();
        $arr_name = array(0);
        //排序
        foreach($list as $value)
		{       $max_ids[]=$value['maxid'];
			$arr_name[] = "'".str_replace("'","\'",$value['keywords'])."'";
		}
		$res = $this->load('keywordsurl')->findAll('base_name in(' . join(',',$arr_name) . ")",false);
		foreach($res as $value)
		{
			$arr_red[$value['base_name']] = 1 ;	
		}
		$res = $this->load('searchkeywords')->findAll('base_name in(' . join(',',$arr_name) . ")",false);
		foreach($res as $value)
		{
			$arr_lev[$value['base_name']] = 1 ;	
		}
        $max_ids = $max_ids? implode(',', $max_ids):0;   
	$maxid_list = $this->userKeywordsLogic->findAll("id in(".$max_ids.")");
        foreach ($maxid_list as $key => $value) {
            $result_nums[$value['id']] = $value['result_num'];
        }
        foreach ($list as $key => $value) {
            $list_id[$value['maxid']] = $value;
        }
        $languageLogic = $this->load('language');
        $languages = $languageLogic->findAll('', true);
        
		Core::$tpl->set('arr_red', $arr_red);
		Core::$tpl->set('arr_lev', $arr_lev);
        Core::$tpl->set('page', $current_page);
        Core::$tpl->set('languages', $languages);
        Core::$tpl->set('sites', $this->load('language')->findAll());
        Core::$tpl->set('result_nums', $result_nums);
        Core::$tpl->set('res', $list_id);
        Core::$tpl->set('pages', $pages);
        Core::$tpl->set('selected_s_time', _g('start_time'));
        Core::$tpl->set('selected_e_time', _g('end_time'));
        Core::$tpl->set('selected_site', _g('language_id'));
        Core::$tpl->set('date_id', $date_id);
    }

    public function actionDel()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $ids = _p('ids');
        $staus = 0;
        $flag = $lang['illegal_operation'];
        if(!empty($ids))
        {
          $num = 0;
          $enum = 0;
          foreach ($ids as $id)
          {          
                $userKeywords = $this->userKeywordsLogic->getOne('id=' . $id);
                $res = $this->userKeywordsLogic->delete('keywords="' . $userKeywords['keywords'].'"');
                if($res)
                    $num++;
                else
                    $enum++;
          }
          $staus = 1;
          $flag = $lang['success_delete']. $num . $lang['num_records'].','.$lang['delete_failure']. $enum . $lang['num_records'];
        }
        echo json_encode(array('status' => $staus, 'msg' => $flag));
    }
}

?>
