<?php

/**
 * 清理订单
 *
 * @author ZJH
 */
class ClearUnpaidOrderController extends AppController {

    private $logLogic;
    private $admin_id;
    private $admin_name;
    private $orderLogic;

    public function __construct() {
        parent::__construct();
        $this->orderLogic = $this->load('order');
        $this->logLogic = $this->load('orderLog');
        $this->admin_id = Common::queryInt(_c('admin_id') ? _c('admin_id') : _s('id'));
        $this->admin_name = _c('admin_name') ? _c('admin_name') : _s('user_name');
    }

    public function actionDefault() {
        global $cfg;
        $NowTime = time();
        $orderTime = $cfg['sites'][0]['order_cancel_time'];
        if ($orderTime != 0) {
            $orderLogic = $this->load('order');
            $orderData = $orderLogic->findAll("payment_status=101 and order_status!=601");
            $order_status = 601;
            $remark = "Plan_cleaning";
            foreach ($orderData as $Oval) {
                $order = $this->orderLogic->getOneById($Oval['id']);
                $order['order_status'] = $order_status;
                EventFactory::orderCancelAfter($order);
                $create_time = strtotime(date('Y-m-d', strtotime('+' . $orderTime . ' day', strtotime(date('Y-m-d H:i:s', $Oval['create_time'])))));
                if ($create_time <= $NowTime) {
                    $order_data = array(
                        'order_status' => $order_status,
                    );
                    $res = $orderLogic->save($order_data, $Oval['id']);
                    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
                    $admin_id = $this->admin_id;
                    $admin_name = $this->admin_name;
                    $order_log_data = array(
                        'admin_id' => $admin_id,
                        'admin_name' => $admin_name,
                        'order_id' => $Oval['id'],
                        'result' => $res ? 1 : 0,
                        'remark' => $lang['operation'] . ': ' . $admin_name . '' . $lang['change_order_status'] . ': ' . Common::orderStatus($order_status),
                        'behavior' => 'order_status_change',
                        'create_time' => SYS_TIME,
                    );
                    $this->logLogic->save($order_log_data);
                    if ($remark) {
                        $order_remark_data = array(
                            'admin_id' => $admin_id,
                            'admin_name' => $admin_name,
                            'order_id' => $Oval['id'],
                            'ip' => Common::_ip2long(Common::ip()),
                            'remark' => $remark,
                            'marker' => $order_status > 600 && $order_status < 700 ? 6 : 5,
                            'remark_type' => $order_status,
                            'create_time' => SYS_TIME,
                        );
                        $this->load('orderRemark')->save($order_remark_data);
                    }
                }
            }
            echo "订单过期自动作废-OK";
        } else {
            echo "未开启订单自动作废时间[网站设置]";
        }
    }

}
