<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Payment
 *
 * @author hjp
 */
class SNSController extends AppController
{

    public function __construct()
    {
        $this->apisnslogic = $this->load("apisns");
        $this->languageLogic = $this->load('language');
        $this->userapiLogic = $this->load("userapi");
        $this->userLogic = $this->load('user');
        $this->lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    }

    /**
     * 加载配置
     */
    public function loadConfig()
    {
        $api_type = _g('api_type');
        $sns = $this->apisnslogic->getOne("api_type='" . $api_type . "' and status=1 and (language_id=0 or language_id=" . $this->languageLogic->real_language_id . ")");
        return json_decode($sns['api_param'], true);
    }

    /**
     * 接口跳转
     */
    public function actionRedirect()
    {
        $api_type = _g('api_type');
        if (is_file(APP_ROOT . 'api/login/' . $api_type . '/script.php'))
        {
            require_once APP_ROOT . 'api/login/' . $api_type . '/script.php';
            $login = new $api_type();
            $login->SetConfig($this->loadConfig());
            $url = $login->redirectURL();
            header("Location: " . $url);
            exit();
        }
        else
        {
            echo "SNS TYPE ERROR";
            die();
        }
    }

    /**
     * 回调
     */
    public function actionCallBack()
    {
        $api_type = _g('api_type');
        if (is_file(APP_ROOT . 'api/login/' . $api_type . '/script.php'))
        {
            require_once APP_ROOT . 'api/login/' . $api_type . '/script.php';
            $login = new $api_type();
            $login->SetConfig($this->loadConfig());
            $result = $login->CallBack();
            //--处理
            //print_r($result);
            if ($result)
            {
                $this->authentication($result);
            }
            else
            {
                die('Call back Error');
            }
            exit();
        }
        else
        {
            echo "SNS TYPE ERROR";
            die();
        }
    }

    public function actionDefault()
    {
        echo "SNS Default";
    }

    private function authentication($param)
    {
        $api_type = $param['api_type'];
        $sns = $this->apisnslogic->getOne("api_type='" . $api_type . "' and status=1 and (language_id=0 or language_id=" . $this->languageLogic->real_language_id . ")");
        if ($sns)
        {
            $api_id = $sns['id'];
            $api_key = $param['api_id'];
            $user_email = $param['user_email'];

            $cond = "api_id =" . $api_id . " and api_key='" . $api_key . "'";
            $userapi = $this->userapiLogic->getOne($cond);
            if (!$userapi)
            {
                //用户第一次使用第三方登录，跳转至API注册页面     
                $data = array();
                $data['api_id'] = $api_id;
                $data['api_key'] = $api_key;
                $data['type'] = $api_type;
                $data['api_email'] = $user_email;
                if ($user_email != "")
                {
                    $this->fast_register($param);
                }
                else
                {       
                    $_SESSION['api_login_apiID']=$api_id;
                    $_SESSION['api_login_apikey']=$api_key;
                }
                $ref = Common::frontURL('home', 'apilogin', 'register', $data);
                return $this->_redirect($ref);
            }
            else
            {
                $this->login($userapi['user_id']);
            }
        }
        else
        {
            die('SNS TYPE ERROR');
        }
    }

    private function login($user_id)
    {
        $cond = 'id =' . $user_id;
        $userinfo = $this->userLogic->getOne($cond);
        $name = $userinfo['base_name'];
        $password = $userinfo['password'];
        if (!$name)
        {
            echo "<script>alert('".$this->lang['login_name_is_empty']."');</script>";
            die();
            //return $this->showMessage('login_name_is_empty');
        }
        if (!$password)
        {
            echo "<script>alert('".$this->lang['login_password_is_empty']."');</script>";
            die();
            //return $this->showMessage('login_password_is_empty');
        }
        $user = $this->userLogic->login($name, $password, TRUE);
        if ($user)
        {
            _setSession('user_id', $user['id']);
            _setSession('user_base_name', $user['base_name']);
            $this->userLogic->_checkCookieCart($user['id']);
            $now = time();
            $log_data = array(
                'language_id' => $this->languageLogic->language_id,
                'user_id' => $user['id'],
                'create_year' => date('Y', $now),
                'create_month' => date('Ym', $now),
                'create_day' => date('Ymd', $now),
                'last_ip' => Common::_ip2long(Common::ip()),
            );
            $logLogic = $this->load('userLoginLog');
            $logLogic->save($log_data);
            $ref = Common::frontURL('home', 'account', 'index');
            return $this->_redirect($ref);
        }
        echo "<script>alert('".$this->lang['login_failure']."');</script>";
        die();
        //return $this->showMessage('login_failure');
    }

    private function fast_register($param)
    {
        $api_type = $param['api_type'];
        $sns = $this->apisnslogic->getOne("api_type='" . $api_type . "' and status=1 and (language_id=0 or language_id=" . $this->languageLogic->real_language_id . ")");
        if ($sns)
        {
            
            $api_id = $sns['id'];
            $api_key = $param['api_id'];
            $user_email = $param['user_email'];
            
            $cond = "api_id =" . $api_id . " and api_key='" . $api_key . "'";
            $userapi = $this->userapiLogic->getOne($cond);
            if ($userapi)
            {
                $this->login($userapi['user_id']);
            }
            $security_email = $user_email;
            $password = '123456';
            
            if (!Common::isEmail($security_email))
            {                
                echo "<script>alert('".$this->lang['please_enter_email']."');</script>";
                die();
                //return $this->showMessage('please_enter_email');
            }
            //如果邮箱已注册过就直接绑定
            if($this->userLogic->isExistName($security_email))
            {
                $user = $this->userLogic->getOne("base_name='".$security_email."'");
                $userapi_data = array(
                    'user_id' => $user['id'],
                    'api_id' => $api_id,
                    'api_key' => $api_key,
                );
                $this->userapiLogic->save($userapi_data);
                $this->login($user['id']);
                $ref = Common::frontURL('home', 'account', 'index');   
                return $this->_redirect($ref);
                die();                             
            }
            $domain = SITE_URL;
            $ipJoinCountryLogic = $this->load('ipJoinCountry');
            $ip = Common::_ip2long(Common::ip());
            $groupLogic = $this->load('userGroup');
            $default_group_id = 0;
            foreach ($groupLogic->getAll() as $key => $value)
            {
              if($value['is_default'] == 1)
              {
                $default_group_id = $key;
              }
            }
            $user_data = array(
                'base_name' => $security_email,
                'password' => md5(md5($password)),
                'status' => 1,
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'question' => _p('question'),
                'answer' => _p('answer'),
                'source' => $this->getSource(),
                'language_id' => $this->languageLogic->language_id,
                'country_id' => $ipJoinCountryLogic->getCountryId($ip),
                'user_group_id' => $default_group_id,
                'create_time' => SYS_TIME,
				'parent_user_id' => (int)$this->getUserSource(),
            );
            $register = $this->userLogic->save($user_data);            
            if ($register)
            {
                if ($api_id != "" && $api_key != "")
                {
                    $userapi_data = array(
                        'user_id' => $register,
                        'api_id' => (int) $api_id,
                        'api_key' => $api_key,
                    );
                    $apisns = $this->apisnslogic->getOne("id=" . ((int) $api_id));
                    if ($apisns)
                        $this->userapiLogic->save($userapi_data);
                }
                _setSession('user_id', $register);
                _setSession('user_base_name', $security_email);
                $this->userLogic->_checkCookieCart($register);
                $now = time();
                $log_data = array(
                    'language_id' => $this->languageLogic->language_id,
                    'user_id' => $register,
                    'create_year' => date('Y', $now),
                    'create_month' => date('Ym', $now),
                    'create_day' => date('Ymd', $now),
                    'last_ip' => $ip,
                );
                $logLogic = $this->load('userLoginLog');
                $logLogic->save($log_data);
                $this->login($register);
                $ref = Common::frontURL('home', 'account', 'index');                
                $user = array(
                    'id' => $register,
                    'base_name'   => $security_email,
                    'language_id' => $this->languageLogic->language_id ,
                );
                GrowthFactory::userRegisterAfter($user);
                EventFactory::userRegisterAfter($user);
                CreditFactory::userRegisterAfter($user);
                ReportFactory::userReport($user_data);
				$this->cleanUserSource();
                return $this->_redirect($ref);
            }
            echo "<script>alert('".$this->lang['register_failure']."');</script>";
            die();
            //return $this->showMessage('register_failure');
        }
        else
        {
            die('SNS TYPE ERROR');
        }
    }

}
?>

