<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of IndexController
 *
 * @author hjp <huangjp@35zh.com>
 */
class AccountController extends AppController
{

    private $lang;
    private $userinfoLogic;
    private $userLogic;
    private $user_id;
    private $userAddressLogic;
    private $orderLogic;
    private $userFavoriteLogic;
    private $userGroupJoinLanguageLogic;
    private $languageLogic;

    public function __construct()
    {
        parent::__construct();
        $this->lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $user_id = (int)$this->checkLogin();
        if (!$user_id)
        {
            if (strtolower(_g('a')) != 'trackingorder' && strtolower(_g('a')) != 'trackingorderdetail' && strtolower(_g('a')) != 'trackno')
            {
                if (_p('ajax'))
                {
                    $return = array('status' => 0, 'msg' => $this->lang['please_login_after']);
                    echo json_encode($return);
                    return;
                }
                else
                {
                    return $this->_redirect(Common::frontURL('wap', 'user', 'login',array('ref'=>$_SERVER['REQUEST_URI'])));
                }
            }
        }
        else
        {
            $this->user_id = $user_id;
        }
        $this->userLogic = $this->load('user');
        $this->userinfoLogic = $this->load('userInfo');
        $this->userAddressLogic = $this->load('userAddress');
        $this->orderLogic = $this->load('order');
        $this->userFavoriteLogic = $this->load('userFavorite');
        $this->userGroupJoinLanguageLogic = $this->load('UserGroupJoinLanguage');
        $this->languageLogic = $this->load('language');
        $this->before();
    }
	
	public function actionPurchaseList()
	{
		$language_id = $this->languageLogic->language_id;
        $page_size = 8;
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'o.user_id =' . $this->user_id . ' and o.create_time>='.strtotime("-6 month") . ' and g.id is not null group by oi.goods_id';
		$logic = $this->load('orderJoinOrderItemJoinGoods') ;
		$count = $logic->getCount($where,true);
        $page_data = Common::getPages($count, $curr_page, $page_size);
//        Core::$tpl->set('orders', $this->orderLogic->getListByUserId($this->user_id, ($curr_page-1) * $page_size, $page_size));
        $goods_list = $logic->getCurrentDatas($where.' order by nid desc', $page_size, $curr_page);
      	$ids=array(0);
		foreach($goods_list as $value)
		{
			$ids[]=$value['goods_id'] ;	
		}
		$res = $this->load('GoodsJoinLanguage')->findALL('l.goods_id in ('.join(',',$ids).') and l.language_id='.$language_id,true);
		foreach($goods_list as $key => $value)
		{
			$goods_list[$key]['good'] = $res[$value['goods_id']];
		}
		 Core::$tpl->set('goods_list', $goods_list);
		 Core::$tpl->set('pages', $page_data);
		Core::$tpl->set('seo_title', 'Purchase List');
		
	}
	
    public function actionIndex()
    {
        //最近订单
        Core::$tpl->set('recent_orders', $this->orderLogic->getListByUserId($this->user_id, 0, 10));
        Core::$tpl->set('recent_msg', $this->load('message')->getMsgByUserId($this->user_id, 0, 10));
        //推荐商品
        $orders = $this->orderLogic->getListByUserId($this->user_id);
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $GoodsPropertyRel = $this->load('GoodsPropertyRel');
        $goods_ids = array();
        foreach ($orders as $key => $value)
        {
            $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $value['id']);
            foreach ($orderItems as $key1 => $value1)
            {
                $goods_ids[] = $value1['goods_id'];
            }
        }
        $property_ids = array();
        if (!empty($goods_ids))
        {//空数据不要进行查询
            $propertys = $GoodsPropertyRel->findAll('goods_id in(' . join(',', $goods_ids) . ')');
            foreach ($propertys as $key => $value)
            {
                $property_ids[] = $value['vid'];
            }
            $property_ids = array_unique($property_ids);
        }
        Core::$tpl->set('property_ids', join(',', $property_ids));
        //会员信息
        $user = $this->userLogic->getOne('id=' . $this->user_id);
        Core::$tpl->set('user', $user);
        $userinfo = $this->userinfoLogic->getOne('user_id=' . $this->user_id);
        Core::$tpl->set('userinfo', $userinfo);
        //会员消息计数
        $message_count = $this->load('message')->getCount('type=0 or (user_id =' . $this->user_id . ' and type=1 ) and parent_id=0 and status=1');
        Core::$tpl->set('message_count', $message_count);
        //会员等级
        $language_id = $this->load('language')->language_id;
        $user_current_level = $this->userGroupJoinLanguageLogic->getUserGroupById($user['user_group_id'], $language_id);
        if ($user_current_level)
        {
            $user_next_level = $this->userGroupJoinLanguageLogic->getOne('ug.min_growth>' . $user['growth'] . ' and language_id=' . $language_id . ' order by ug.min_growth asc limit 1');
            Core::$tpl->set('user_current_level', $user_current_level);
            Core::$tpl->set('user_next_level', $user_next_level);
        }
        //会员信息完成百分比
        $arrcomplete = array("first_name", "last_name", "country_id", "street", "postcode", "city", "state", "email", "mobilephone", "telephone");
        $tempuncomplete = count($arrcomplete);
        if (!$userinfo)
        {
            $tempuncomplete = 0;
        }
        else
        {
            for ($index = 0; $index < count($arrcomplete); $index++)
            {
                if ($userinfo[$arrcomplete[$index]] == "")
                {
                    $tempuncomplete--;
                }
            }
        }
        $userinfo_percent = (int) ($tempuncomplete * 10 / count($arrcomplete)) * 10;
        Core::$tpl->set('userinfo_percent', $userinfo_percent);
        Core::$tpl->set('big_title', $this->lang['my_account']);
    }

    public function before()
    {
        if(!$this->user_id)
			return ;
		$myorder_count = $this->orderLogic->getCount('user_id=' . $this->user_id);
        Core::$tpl->set('address_count', $this->userAddressLogic->getCount('user_id=' . $this->user_id));
        Core::$tpl->set('myorder_count', $myorder_count);

        $favoriteLogic = $this->load('userFavoriteJoinGoods');
        Core::$tpl->set('favorite_count', $favoriteLogic->getCountByUserId($this->user_id));
        //会员未读信息
        $m_unread_count = $this->load('message')->getCount('(user_id =' . $this->user_id . ' and type=1 ) and parent_id=0 and status=1 and is_user_readed=0 ');
        Core::$tpl->set('m_unread_count', $m_unread_count);
    }

    public function actionOrders()
    {
        global $cfg;
		/*
        $order_cancel_time = $cfg['sites'][0]['order_cancel_time'] * 86400;
        $update_cond = 'user_id =' . $this->user_id . ' and payment_status = 101 and (create_time +' . $order_cancel_time . ') < ' . time();
        $map = Zhtx::createDataMap();
        $map->addEntry('order_status', 600, DB::INT);
        $this->orderLogic->update($map, $update_cond);
		*/
        //分页用的参数
        $language_id  = $this->languageLogic->language_id;
        $page_size = $cfg['sites'][2]['order_list_number'] ? $cfg['sites'][$language_id]['order_list_number'] : 20;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'user_id =' . $this->user_id;
        $count = $this->orderLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $orders = $this->orderLogic->getListByUserId($this->user_id, ($curr_page - 1) * $page_size, $page_size);
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $currencyLogic = $this->load('currency');
        $currencys = $currencyLogic->findAll('status=1');
        foreach ($currencys as $ckey => $curitem)
        {
            $currencys[$currencys[$ckey]['standard_code']] = $curitem;
        }
        foreach ($orders as $key => $rows)
        {
            $orders[$key]['itemtotal'] = 0;
            $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $rows['id']);
            foreach ($orderItems as $item)
            {
                $orders[$key]['itemtotal']+=$item['buy_num'];
                $orders[$key]['image'] = $item['image'];
            }
            $orders[$key]['currency'] = $currencys[$rows['currency_code']];
            $orders[$key]['lcoin'] = $currencys[$rows['currency_code']]['symbol_left'];
            $orders[$key]['rcoin'] = $currencys[$rows['currency_code']]['symbol_right'];
        }
        Core::$tpl->set('big_title', $this->lang['my_order']);
        Core::$tpl->set('orders', $orders);
        Core::$tpl->set('pages', $page_data);
    }

    /**
     * 订单详情
     * 可以考虑把订单的信息展示的更全面些 
     */
    public function actionOrderDetail()
    {
        $order_id = Common::queryInt(_g('order_id'));
        $order = $this->orderLogic->getOneById($order_id);
        if (!$order)
        {
            $this->exception();
        }
        if ($order['user_id'] != $this->user_id) {
            return $this->showMessage('not_found_record');
        }
        $deliveryLogic = $this->load('orderDelivery');
        $orderAddressLogic = $this->load('orderAddress');
        $orderPaymentLogic = $this->load('orderPayment');
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $pay_cond = 'order_id=' . $order_id . ' and payment_type=1 and user_id=' . $this->user_id . ''; //支付方式
        $orderPayment = $orderPaymentLogic->getOne($pay_cond);
        $orderAddress = $orderAddressLogic->getOne('order_id=' . $order_id);
        $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $order_id);
        $item_result = array();
        $language_id = $this->load('language')->language_id;
        $order['totalnum'] = 0;
        $currencyLogic = $this->load('currency');
        $currency_code = $order['currency_code']; //货币三位符
        $currency_conde = 'standard_code="' . $currency_code . '"';
        $currency = $currencyLogic->getOne($currency_conde);
        foreach ($orderItems as $item)
        {
            $property_ids = explode('_', $item['sku_code']);
            $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
            $item['subtotal'] = $item['price'] * $item['buy_num'];
            $item['attr'] = $attr;
            if($item['sku_value'])
            {
                $sku_value = explode('_', $item['sku_value']);
                foreach ($sku_value as $key => $value)
                {
                    if($value)
                    {
                        $item['sku_value_items'][] = $value;
                    }
                }
            }
            $item_result[$item['id']] = $item;
            $order['totalnum'] += $item['buy_num'];
        }

        //物流信息
        $ship_record = array(); //发货记录
        $return_record = array();
        $corp_ids = array(); //物流公司IDS
        $trackObj = array();
        $tracking_no = array(); //物流单号
        foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val)
        {
            if ($val['delivery_type'] == 1)
            {
                $ship_record[] = $val;
            }
            else
            {
                $return_record[] = $val;
            }
            if ($val['delivery_no'] != '')
                $tracking_no[] = $val['delivery_no'];
            if ($val['status'] == 1)
            {
                //$corp_ids[]      = $val['shipping_corp_id'];
                 $val['delivery_data'] = json_decode($val['delivery_data'],true);
				 $shippingCorpLogic      = $this->load('shippingCorp');
                 $shipping_corp  = $shippingCorpLogic->getOne('id='.$val['shipping_corp_id']);
                 $val['shipping_corp_name'] = $shipping_corp['base_name'];
                 $trackObj[] = $val;
            }
        }
        $order['tracking_no'] = join(' , ', $tracking_no);
        $order['currency'] = $currency;
        Core::$tpl->set('trackObj', $trackObj);
        Core::$tpl->set('big_title', $this->lang['order_info']);
        Core::$tpl->set('order', $order);
        Core::$tpl->set('orderPayment', $orderPayment);
        Core::$tpl->set('orderAddress', $orderAddress);
        Core::$tpl->set('orderItems', $item_result);
        Core::$tpl->set('lcoin', $currency['symbol_left']);
        Core::$tpl->set('rcoin', $currency['symbol_right']);
        Core::$tpl->set('country', $this->load('country')->getOne('id=' . $orderAddress['country_id']));
        Core::$tpl->set('payment', $this->load('payment')->getOne('id=' . $orderPayment['payment_id']));
    }

    /**
     * 非会员可追踪显示订单基本信息
     */
    public function actionTrackingOrder()
    {
        if (_p()||_g('itemno'))
        {
            $order_number = Common::queryStr(_p('itemno')) ? Common::queryStr(_p('itemno')) : Common::queryStr(_g('itemno'));
            $order = $this->orderLogic->getOne("itemno='" . mysql_escape_string($order_number) . "'");
            if (!$order)
            {
                $this->exception();
            }
            $order_id = $order['id'];
            $deliveryLogic = $this->load('orderDelivery');
            $orderAddressLogic = $this->load('orderAddress');
            $orderPaymentLogic = $this->load('orderPayment');
            $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
            $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
            $pay_cond = 'order_id=' . $order_id . ' and payment_type=1'; //支付成功单据  and status=1
            $orderPayment = $orderPaymentLogic->getOne($pay_cond);
            $orderAddress = $orderAddressLogic->getOne('order_id=' . $order_id);
            $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $order_id);
            $item_result = array();
            $language_id = $this->load('language')->language_id;
            $order['totalnum'] = 0;
            foreach ($orderItems as $item)
            {
                $property_ids = explode('_', $item['sku_code']);
                $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
                $item['subtotal'] = $item['price'] * $item['buy_num'];
                $item['attr'] = $attr;
                if($item['sku_value'])
                {
                    $sku_value = explode('_', $item['sku_value']);
                    foreach ($sku_value as $key => $value)
                    {
                        if($value)
                        {
                            $item['sku_value_items'][] = $value;
                        }
                    }
                }
                $item_result[$item['id']] = $item;
                $order['totalnum'] += $item['buy_num'];
            }

            //物流信息
            $ship_record = array(); //发货记录
            $return_record = array();
            $corp_ids = array(); //物流公司IDS
            $trackObj = array();
            $tracking_no = array(); //物流单号
            foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val)
            {
                if ($val['delivery_type'] == 1)
                {
                    $ship_record[] = $val;
                }
                else
                {
                    $return_record[] = $val;
                }
                if ($val['delivery_no'] != '')
                    $tracking_no[] = $val['delivery_no'];
                if ($val['status'] == 1)
                {
                    //$corp_ids[]      = $val['shipping_corp_id'];
                    $val['delivery_data'] = json_decode($val['delivery_data'],true);
                    $shippingCorpLogic      = $this->load('shippingCorp');
                    $shipping_corp  = $shippingCorpLogic->getOne('id='.$val['shipping_corp_id']);
                    $val['shipping_corp_name'] = $shipping_corp['base_name'];
                    $trackObj[] = $val;
                }
            }
            $order['tracking_no'] = join(' , ', $tracking_no);
            Core::$tpl->set('big_title', $this->lang['tracking_order']);
            Core::$tpl->set('order', $order);
            Core::$tpl->set('orderPayment', $orderPayment);
            Core::$tpl->set('orderAddress', $orderAddress);
            Core::$tpl->set('trackObj', $trackObj);
            Core::$tpl->set('orderItems', $item_result);
            Core::$tpl->set('country', $this->load('country')->getOne('id=' . $orderAddress['country_id']));
            Core::$tpl->set('payment', $this->load('payment')->getOne('id=' . $orderPayment['payment_id']));
            Core::$htmlFile = 'account/trackingorderdetail';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }else{
            Core::$tpl->set('big_title', $this->lang['tracking_order']);
        }
        

    }

    /**
     * 查看及修改个人信息
     * @return type 
     */
    public function actionProfile()
    {
        if (_p() && _p('ajax'))
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $user_id = $this->checkLogin();
            /*
            if (!_p('first_name'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_first_name']);
                echo json_encode($return);
                return;
            }
            if (!_p('last_name'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_last_name']);
                echo json_encode($return);
                return;
            }
            if (!_p('email'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_email']);
                echo json_encode($return);
                return;
            }
            if (!_p('street'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_address']);
                echo json_encode($return);
                return;
            }
            if (!_p('city'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_city']);
                echo json_encode($return);
                return;
            }
            if (!_p('state'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_state']);
                echo json_encode($return);
                return;
            }
            if (!_p('country_id'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_select_country']);
                echo json_encode($return);
                return;
            }
            */
            
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $user_id);
            $info_id = $userinfo ? $userinfo['id'] : 0;
            $info_data = array(
                'user_id' => $user_id,
                'email' => Common::strEscape(strip_tags(_p('email'))),
                'postcode' => Common::strEscape(strip_tags(_p('postcode'))),
                'first_name' => Common::strEscape(strip_tags(_p('first_name'))),
                'last_name' => Common::strEscape(strip_tags(_p('last_name'))),
                'sex' => _p('sex'),
                'mobilephone' => Common::strEscape(strip_tags(_p('mobilephone'))),
                'telephone' => Common::strEscape(strip_tags(_p('telephone'))),
                'street' => Common::strEscape(strip_tags(_p('street'))),
                'city' => Common::strEscape(strip_tags(_p('city'))),
                'state' => Common::strEscape(strip_tags(_p('state'))),
                'country_id' => Common::queryInt(_p('country_id')),
            );
            $res = $this->userinfoLogic->save($info_data, $info_id);
            //作为配送地址
            if ($res && _p('asShippingAdderss'))
            {
                unset($info_data['sex']);
                unset($info_data['street']);
                $info_data['address'] = Common::strEscape(strip_tags(_p('street')));
                $info_data['is_master'] = 1;
                $cond = 'user_id=' . $this->user_id . ' and is_master=1';
                $map = Zhtx::createDataMap();
                $map->createEntry($info_data);
                $this->userAddressLogic->replaceByCond($map, $cond);
            }
            if ($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else if (_p())
        {
            $user_id = $this->checkLogin();
            if (!_p('first_name'))
            {
                return $this->showMessage('required_item');
            }
            if (!_p('last_name'))
            {
                return $this->showMessage('required_item');
            }
            if (!_p('email'))
            {
                return $this->showMessage('required_item');
            }
            if (!_p('state'))
            {
                return $this->showMessage('required_item');
            }
            if (!_p('country_id'))
            {
                return $this->showMessage('required_item');
            }
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $user_id);
            $info_id = $userinfo ? $userinfo['id'] : 0;
            $info_data = array(
                'user_id' => $user_id,
                'email' => _p('email'),
                'postcode' => Common::strEscape(strip_tags(_p('postcode'))),
                'first_name' => Common::strEscape(strip_tags(_p('first_name'))),
                'last_name' => Common::strEscape(strip_tags(_p('last_name'))),
                'sex' => _p('sex'),
                'mobilephone' => Common::strEscape(strip_tags(_p('mobilephone'))),
                'telephone' => Common::strEscape(strip_tags(_p('telephone'))),
                'street' => Common::strEscape(strip_tags(_p('street'))),
                'city' => Common::strEscape(strip_tags(_p('city'))),
                'state' => Common::strEscape(strip_tags(_p('state'))),
                'country_id' => Common::queryInt(_p('country_id')),
            );
            $res = $this->userinfoLogic->save($info_data, $info_id);
            //作为配送地址
            if ($res && _p('asShippingAdderss'))
            {
                unset($info_data['sex']);
                unset($info_data['street']);
                $info_data['address'] = Common::strEscape(strip_tags(_p('street')));
                $info_data['is_master'] = 1;
                $cond = 'user_id=' . $this->user_id . ' and is_master=1';
                $map = Zhtx::createDataMap();
                $map->createEntry($info_data);
                $this->userAddressLogic->replaceByCond($map, $cond);
            }
            return $res ? $this->success('save_success') : $this->showMessage('save_failure');
        }
        else
        {
            $user_id = $this->checkLogin();
            if (!$user_id)
            {
                $current_url = urlencode(Common::frontURL('wap', 'account', 'profile'));
                return $this->showMessage('please_login_after', Common::frontURL('wap', 'user', 'login', array('ref' => $current_url)));
            }
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $user_id);
            $countryLogic = $this->load('country');
            Core::$tpl->set('userinfo', $userinfo);
            Core::$tpl->set('countrys', $countryLogic->findALL('status=1', TRUE));
            Core::$tpl->set('big_title', $this->lang['my_profile']);
        }
    }

    public function actionChangepwd()
    {
        if (_p() && _p('ajax'))
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $oldpassword = _p('oldpassword');
            $newpassword = _p('newpassword');
            $user_data = array();
            $ischangepwd = false;
            if ($oldpassword || $newpassword)
            {
                if ($oldpassword != $newpassword)
                {
                    $return = array('status' => 0, 'msg' => $this->lang['two_password_not_match']);
                    echo json_encode($return);
                    return;
                }
            }

            $user_data['question'] = _p('question');

            if (_p('answer'))
            {
                $user_data['answer'] = _p('answer');
            }
            if (!count($user_data))
            {
                $return = array('status' => 0, 'msg' => $this->lang['not_enter_anything']);
                echo json_encode($return);
                return;
            }
            $res = $this->userLogic->save($user_data, $this->user_id);
            if ($ischangepwd)
            {
                _setSession('user_id', '');
                setcookie('user_id', '', 0, '/');
            }
            if ($res)
            {
                $post_data = array(
                    'codeno'  => 'edit_password_tip',
                    'user_id' =>  $user['id']
                );
                EventFactory::getRemoteData(SITE_PROTOCOL . SITE_URL . '/index.php?m=wap&c=email&a=RealTimeTrigger', $post_data, '', '', 2);
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            Core::$tpl->set('user', $this->userLogic->getOneById($this->user_id));
            Core::$tpl->set('big_title', $this->lang['change_password']);
        }
    }

    public function actionFavorites()
    {
        $favoriteLogic = $this->load('userFavoriteJoinGoods');
        global $cfg;
        $language_id = $this->languageLogic->language_id;
        $page_size = $cfg['sites'][$language_id]['user_favorite_list_number'] ? $cfg['sites'][$language_id]['user_favorite_list_number'] : 8;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $where = 'user_id =' . $this->user_id;
        $count = $favoriteLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('favorites', $favoriteLogic->getListByUserId($this->user_id, ($curr_page - 1) * $page_size, $page_size));
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('big_title', $this->lang['my_favorites']);
    }

    public function actionDelFavorites()
    {
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        $favoriteLogic = $this->load('userFavorite');
        $favorites_id = Common::queryInt(_g('id'));
        $userfavorite = $favoriteLogic->getOne('id='.$favorites_id);
        $cond = 'user_id =' . $this->user_id . ' and id=' . $favorites_id;
        $res = $favoriteLogic->delete($cond);
        $this->load('goods')->updateWishlistCount($userfavorite['goods_id'], true);
        if ($res)
        {
            $return = array('status' => 1, 'msg' => $this->lang['delete_success']);
            echo json_encode($return);
            return;
        }
        else
        {
            $return = array('status' => 0, 'msg' => $this->lang['delete_failure']);
            echo json_encode($return);
            return;
        }
    }

    public function actionEditAddress()
    {
        if (_p())
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $address_id = Common::queryInt(_p('address_id'));
            $address = $this->userAddressLogic->getOneById($address_id);
            if (!$address || $address['user_id'] != $this->user_id)
            {
                $return = array('status' => 0, 'msg' => $this->lang['illegal_parameters']);
                echo json_encode($return);
                return;
            }
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $mobilephone = Common::strEscape(strip_tags(_p('mobilephone')));
            $telephone = Common::strEscape(strip_tags(_p('telephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'),0);
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id || !$mobilephone)
            {
                $return = array('status' => 0, 'msg' => $this->lang['required_tip']);
                echo json_encode($return);
                return;
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $mobilephone,
                'telephone' => $telephone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
            );
            $res = $this->userAddressLogic->save($data, $address_id);
            if ($res && $is_master)
            {
                $cond = 'id !=' . $address_id . ' and user_id=' . $this->user_id . ' and is_master=1  and address_type=0';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            if ($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            $address_id = Common::queryInt(_g('id'));
            $address = $this->userAddressLogic->getOneById($address_id);
            if (!$address || $address['user_id'] != $this->user_id)
            {
                return $this->showMessage('illegal_parameters');
            }
            $countryLogic = $this->load('country');
            Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
            Core::$tpl->set('address', $address);
            Core::$tpl->set('big_title', $this->lang['edit_address']);
        }
    }

    public function actionDelAddress()
    {
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        $address_id = Common::queryInt(_g('id'));
        $address = $this->userAddressLogic->getOneById($address_id);
        if (!$address || $address['user_id'] != $this->user_id)
        {
            $return = array('status' => 1, 'msg' => $this->lang['illegal_parameters']);
            echo json_encode($return);
            return;
        }
        $res = $this->userAddressLogic->delete('id=' . $address_id);
        if ($res)
        {
            $return = array('status' => 1, 'msg' => $this->lang['operation_success']);
            echo json_encode($return);
            return;
        }
        else
        {
            $return = array('status' => 0, 'msg' => $this->lang['operation_failure']);
            echo json_encode($return);
            return;
        }
    }

    public function actionAddAddress()
    {
        if (_p())
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $phone = Common::strEscape(strip_tags(_p('mobilephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'),0);
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id)
            {
                $return = array('status' => 0, 'msg' => $this->lang['required_tip']);
                echo json_encode($return);
                return;
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $phone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
                'create_time' => SYS_TIME,
            );
            $res = $this->userAddressLogic->save($data);
            if ($res && $is_master)
            {
                $cond = 'id !=' . $res . ' and user_id=' . $this->user_id . ' and is_master=1 and address_type=0';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            if ($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            Core::$tpl->set('big_title', $this->lang['add_address']);
            $countryLogic = $this->load('country');
            Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
        }
    }

    public function actionAddress()
    {
        $addresses = $this->userAddressLogic->getListByUserId($this->user_id);
        $countryLogic = $this->load('country');
        Core::$tpl->set('addresses', $addresses);
        Core::$tpl->set('big_title', $this->lang['my_address_books']);
    }


    public function actionBillingAddress()
    {
        $addresses = $this->userAddressLogic->getListByUserId($this->user_id,1);
        $countryLogic = $this->load('country');
        Core::$tpl->set('addresses', $addresses);
        Core::$tpl->set('big_title', $this->lang['my_billing_address']);
    }
    
    public function actionAddBillingAddress()
    {
        if (_p())
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address = Common::strEscape(strip_tags(_p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $phone = Common::strEscape(strip_tags(_p('mobilephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'),0);
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id)
            {
                $return = array('status' => 0, 'msg' => $this->lang['required_tip']);
                echo json_encode($return);
                return;
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $phone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
                'create_time' => SYS_TIME,
                'address_type' => 1,
            );
            $res = $this->userAddressLogic->save($data);
            if ($res && $is_master)
            {
                $cond = 'id !=' . $res . ' and user_id=' . $this->user_id . ' and is_master=1 and address_type=1';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            if ($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            Core::$tpl->set('big_title', $this->lang['add_billing_address']);
            $countryLogic = $this->load('country');
            Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
        }
    }
    public function actionEditBillingAddress()
    {
        if (_p())
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $address_id = Common::queryInt(_p('address_id'));
            $address = $this->userAddressLogic->getOneById($address_id);
            if (!$address || $address['user_id'] != $this->user_id)
            {
                $return = array('status' => 0, 'msg' => $this->lang['illegal_parameters']);
                echo json_encode($return);
                return;
            }
            $first_name = Common::strEscape(strip_tags(_p('first_name')));
            $last_name = Common::strEscape(strip_tags(_p('last_name')));
            $address =Common::strEscape(strip_tags( _p('address')));
            $postcode = Common::strEscape(strip_tags(_p('postcode')));
            $city = Common::strEscape(strip_tags(_p('city')));
            $state = Common::strEscape(strip_tags(_p('state')));
            $country_id = _p('country_id');
            $mobilephone = Common::strEscape(strip_tags(_p('mobilephone')));
            $telephone = Common::strEscape(strip_tags(_p('telephone')));
            $email = _p('email');
            $is_master = Common::queryInt(_p('is_master'),0);
            if (!$first_name || !$last_name || !$address || !$city || !$state || !$country_id || !$mobilephone)
            {
                $return = array('status' => 0, 'msg' => $this->lang['required_tip']);
                echo json_encode($return);
                return;
            }
            $data = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'address' => $address,
                'city' => $city,
                'state' => $state,
                'user_id' => $this->user_id,
                'country_id' => $country_id,
                'mobilephone' => $mobilephone,
                'telephone' => $telephone,
                'postcode' => $postcode,
                'email' => $email,
                'is_master' => $is_master,
            );
            $res = $this->userAddressLogic->save($data, $address_id);
            if ($res && $is_master)
            {
                $cond = 'id !=' . $address_id . ' and user_id=' . $this->user_id . ' and is_master=1  and address_type=1';
                $map = Zhtx::createDataMap();
                $map->addEntry('is_master', 0, DB::INT);
                $this->userAddressLogic->update($map, $cond);
            }
            if ($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            $address_id = Common::queryInt(_g('id'));
            $address = $this->userAddressLogic->getOneById($address_id);
            if (!$address || $address['user_id'] != $this->user_id)
            {
                return $this->showMessage('illegal_parameters');
            }
            $countryLogic = $this->load('country');
            Core::$tpl->set('countrys', $countryLogic->findAll('status=1', true));
            Core::$tpl->set('address', $address);
            Core::$tpl->set('big_title', $this->lang['edit_billing_address']);
        }
    }
    /**
     * 订单留言
     * @return type 
     */
    public function actionMessage()
    {
        if (_p())
        {
            $order_id = Common::queryInt(_p('order_id'));
            $order = $this->orderLogic->getOneById($order_id);
            if (!_p('content'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['required_item']);
                echo json_encode($return);
                return;
            }
            if (!$order || $order['user_id'] != $this->user_id)
            {
                $return = array('status' => 0, 'msg' => $this->lang['illegal_parameters']);
                echo json_encode($return);
                return;
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code')))
            {
                $return = array('status' => 0, 'msg' => $this->lang['code_error_tips']);
                echo json_encode($return);
                return;
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_URL;
            $user = $this->userLogic->getOne('id=' . $this->user_id);
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $this->user_id);
            $user_name = $user['base_name'];
            if ($userinfo)
            {
                if ($userinfo['first_name'] != '' || $userinfo['last_name'] != '')
                {
                    $user_name = $userinfo['first_name'] . ' ' . $userinfo['last_name'];
                }
            }
            $data = array(
                'user_id' => $this->user_id,
                'order_id' => $order_id,
                'order_no' => $order['itemno'],
                'base_name' => $order['itemno'] . ' Message',
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => 1,
                'status' => 1,
                'user_name' => $user_name,
                'language_id' => $this->load('language')->language_id,
                'is_user_readed' => 1,
				'is_admin_readed' => 0,
                'create_time' => SYS_TIME,
            );
            $res = $this->load('message')->save($data);
            if ($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
    }

    /**
     * 留言详情 
     */
    public function actionMessageDetail()
    {
        $messageLogic = $this->load('message');
        if (_p())
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $message_id = Common::queryInt(_p('message_id'));
            $message = $this->load('message')->getOneById($message_id);
            if (!$message || $message['type'] == 0)
            {
                $return = array('status' => 0, 'msg' => $this->lang['illegal_operation']);
                echo json_encode($return);
                return;
            }
            if (!_p('content'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['required_item']);
                echo json_encode($return);
                return;
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code')))
            {
                $return = array('status' => 0, 'msg' => $this->lang['code_error_tips']);
                echo json_encode($return);
                return;
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_PROTOCOL . SITE_URL;
            $user = $this->userLogic->getOne('id=' . $this->user_id);
            $userinfo = $this->userinfoLogic->getOne('user_id=' . $this->user_id);
            $user_name = $user['base_name'];
            if ($userinfo)
            {
                if ($userinfo['first_name'] != '' || $userinfo['last_name'] != '')
                {
                    $user_name = $userinfo['first_name'] . ' ' . $userinfo['last_name'];
                }
            }
            $data = array(
                'user_id' => $this->user_id,
                'parent_id' => $message['id'],
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => 1,
                'status' => 1,
                'user_name' => Common::strEscape(strip_tags($user_name)),
                'language_id' => $this->load('language')->language_id,
                'is_user_readed' => 1,
                'create_time' => SYS_TIME,
            );
			
			
			
            $res = $messageLogic->save($data);
            if ($res)
            {
         		$messageLogic->save(array('is_admin_readed' => 0), $message['id']);
				$return = array('status' => 1, 'msg' => $this->lang['save_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            $message_id = Common::queryInt(_g('message_id'));
            $messages = $messageLogic->getMsgDetail($message_id, $this->user_id);
            if (empty($messages))
            {
                return $this->showMessage('illegal_operation');
            }
            $message = array();
            $replay = array();
            foreach ($messages as $value)
            {
                if ($value['parent_id'])
                {
                    if (!$value['user_name'])
                    {
                        $user = $this->userLogic->getOne('id=' . $this->user_id);
                        $userinfo = $this->userinfoLogic->getOne('user_id=' . $this->user_id);
                        $user_name = $user['base_name'];
                        if ($userinfo)
                        {
                            if ($userinfo['first_name'] != '' || $userinfo['last_name'] != '')
                            {
                                $user_name = $userinfo['first_name'] . ' ' . $userinfo['last_name'];
                            }
                        }
                        $value['user_name'] = $user_name;
                    }
                    $replay[] = $value;
                }
                else
                {
                    $message = $value;
                }
            }
            $data = array(
                'is_user_readed' => 1,
            );
            $res = $messageLogic->save($data, $message_id);
            Core::$tpl->set('message', $message);
            Core::$tpl->set('replay', $replay);
            Core::$tpl->set('big_title', $this->lang['view_message']);
        }
    }

    /**
     * 用户中心留言
     * @return type 
     */
    public function actionLeaveMessage()
    {
        if (_p())
        {
            require_once(APP_ROOT . 'libary/MobileDetect.php');
            $detect = new Mobile_Detect;
            $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            if (!_p('username'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_username']);
                echo json_encode($return);
                return;
            }
            if (!_p('title'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_title']);
                echo json_encode($return);
                return;
            }
            if (!_p('content'))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_content']);
                echo json_encode($return);
                return;
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code')))
            {
                $return = array('status' => 0, 'msg' => $this->lang['code_error_tips']);
                echo json_encode($return);
                return;
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_URL;
            //自定义变量
            $keys = _p('exp_key');
            $values = _p('exp_value');
            $contact = array();
            foreach ($keys as $k => $v)
            {
                if ($values[$k])
                {
                    $contact[] = array($v, $values[$k]);
                }
            }
            $data = array(
                'user_id' => $this->user_id,
                'base_name' => Common::strEscape(strip_tags(_p('title'))),
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => 1,
                'status' => 1,
                'user_name' => Common::strEscape(_p('username')) == '' ? Common::strEscape(strip_tags(_s('user_base_name'))) : Common::strEscape(strip_tags(_p('username'))),
                'contact' => json_encode($contact),
                'language_id' => $this->load('language')->language_id,
                'is_user_readed' => 1,
                'create_time' => SYS_TIME,
                'source_device' => $deviceType,
            );
            $res = $this->load('message')->save($data);
            if ($res)
            {   $email = _p('email');
                if ($email) {
                  EventFactory::userLeaveMessageAfter($email, $res,$data['language_id']);
                }
                $return = array('status' => 1, 'msg' => $this->lang['save_success'], 'id' => $res);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['save_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            $userInfoLogic = $this->load('UserJoinInfo');
            $user = $userInfoLogic->getOne('u.id=' . $this->user_id);
            Core::$tpl->set('user', $user);
            Core::$tpl->set('big_title', $this->lang['leave_a_message']);
        }
    }

    /**
     * 我的留言 
     */
    public function actionMyMessage()
    {
        global $cfg;
        $language_id = $this->load('language')->language_id;
        $page_size = $cfg['sites'][$language_id]['message_list_number'] ? $cfg['sites'][$language_id]['message_list_number'] : 8;
        $page_size = Common::queryInt(_g('psize'), $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $messageLogic = $this->load('message');
        $where = '(type=0 or (user_id =' . $this->user_id . ' and type=1 )) and parent_id=0 and status=1 order by is_user_readed asc,id desc';
        $count = $messageLogic->getCount($where);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        $messages = $messageLogic->getCurrentDatas($where, $page_size, $curr_page);
        Core::$tpl->set('messages', $messages);
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('big_title', $this->lang['my_message']);
    }
	
	// 兼容PC以及WAP的一些出现不同名的函数
	public function actionMyAddress()
	{
		header("Location: "."m-account-address.html");
		exit();
	}
	
	public function actionEditPassword()
	{
		header("Location: "."m-account-changepwd.html");
		exit();
	}
	
	public function actionMyProfile()
	{
		header("Location: "."m-account-profile.html");
		exit();
	}
        /**
    * 我的积分 
    */
   public function actionCreditList()
   {
     global $cfg;
     $language_id  = $this->languageLogic->language_id;
     $page_size = $cfg['sites'][$language_id]['credit_list_number'] ? $cfg['sites'][$language_id]['credit_list_number'] : 15;
     $page_size = Common::queryInt(_g('psize'), $page_size);
     $curr_page = Common::queryInt(_g('page'), 1);
     $creditLogic = $this->load('CreditDetail');
     $where     = 'user_id =' . $this->user_id ;
     $total = $creditLogic->query('select sum(useful_credit) as total from z_credit_detail where '. $where);
     $count     = $creditLogic->getCount($where);
     $page_data = Common::getPages($count, $curr_page, $page_size);
     $where .= ' order by create_time desc';
     $credit  = $creditLogic->getCurrentDatas($where, $page_size, $curr_page);
     $creditSetting = $this->load('creditSetting')->getOne();
     Core::$tpl->set('total', $total[0]['total']);
     Core::$tpl->set('save', $total[0]['total']/$creditSetting['exchange_credit_scale']);
     Core::$tpl->set('credit', $credit);
     Core::$tpl->set('pages', $page_data);
     Core::$tpl->set('big_title', $this->lang['credit_list']);
   }   
   /**
    * 我的成长值 
    */
    public function actionGrowthList()
   {
     global $cfg;
     $language_id  = $this->languageLogic->language_id;
     $page_size = $cfg['sites'][$language_id]['growth_list_number'] ? $cfg['sites'][$language_id]['growth_list_number'] : 15;
     $page_size = Common::queryInt(_g('psize'), $page_size);
     $curr_page = Common::queryInt(_g('page'), 1);
     $growthLogic = $this->load('GrowthDetail');
     $where     = 'user_id =' . $this->user_id ;
     $total = $growthLogic->query('select sum(growth) as total from z_growth_detail where '. $where);
     $count     = $growthLogic->getCount($where);
     $page_data = Common::getPages($count, $curr_page, $page_size);
     $where  .= ' order by create_time desc';
     $growth  = $growthLogic->getCurrentDatas($where, $page_size, $curr_page);
     Core::$tpl->set('total', $total[0]['total']);
     Core::$tpl->set('growth', $growth);
     Core::$tpl->set('pages', $page_data);
     Core::$tpl->set('big_title', $this->lang['growth_list']);
   }   
    /**
    * 我的优惠券
    */
   public function actionCouponList()
   {
     global $cfg;
     $language_id  = $this->languageLogic->language_id;
     $page_size = $cfg['sites'][$language_id]['coupon_list_number'] ? $cfg['sites'][$language_id]['coupon_list_number'] : 15;
     $page_size = Common::queryInt(_g('psize'), $page_size);
     $curr_page = Common::queryInt(_g('page'), 1);     
	 $couponLogic = $this->load('Coupon');
     $where = 'user_id =' . $this->user_id . ' ORDER BY id DESC';
     $count     = $couponLogic->getCount($where);
     $page_data = Common::getPages($count, $curr_page, $page_size);
     $coupon  = $couponLogic->getCurrentDatas($where, $page_size, $curr_page);	 
	 $offer_ids = array(0);
     foreach($coupon as $item)
     {
        $offer_ids[] = $item['offer_id'];
     }
	 $offerList = $this->load('offer')->findAll('id in(' . implode(',', $offer_ids) . ',0)', TRUE);
     $cols = array('base_name', 'offer_id');
	 $offerlanLogic = $this->load('offerLanguage');
     $offer = $offerlanLogic->findAll("offer_id in(" . implode(',', $offer_ids) . ",0) and language_id=" . $language_id);
     $coupon_offer = array();
     foreach ($offer as $value)
     {
       $coupon_offer[$value['offer_id']] = $value['base_name'];
     }	 
	 
	  foreach ($coupon as $key => $_val) 
	  		{
                $cur_offer = $offerList[$_val['offer_id']];
                if ($cur_offer) 
				{
                    if ( time()>=$cur_offer['end_time']) 
					{
                        $coupon[$key]['status'] = 0;
                    }
                }
				else
				{
					$coupon[$key]['status'] = 0;	
				}
            }
	 
	 Core::$tpl->set('coupon_offer', $coupon_offer);
	 Core::$tpl->set('offerList', $offerList);
     Core::$tpl->set('coupon', $coupon);
     Core::$tpl->set('pages', $page_data);
     Core::$tpl->set('big_title', $this->lang['coupon_list']);
   }
   /**
    * 用户中心邮箱订阅
    */
   public function actionNewsletter()
   {
     $newsletterLogic = $this->load('newsletter');
     $status = 0;
     $msg = '';
     if(_p())
     {
       $subscription = Common::queryInt(_p('subscription'));
       $ip      = Common::_ip2long(Common::ip());
       $domain  = SITE_PROTOCOL.SITE_URL;
       $email   = _c('user_base_name')?_c('user_base_name'):_s('user_base_name');
       $data = array(
           'email'  => $email,           
           'ip'     => $ip,
           'domain' => Common::strEscape($domain),
           'status' => $subscription,           
           'language_id' => $this->languageLogic->language_id,
           'create_time' => SYS_TIME,
           'source_device' => 'phone',
       );
       $cond = 'email = "'. $email . '"';
       if($subscription){
            $res  = $newsletterLogic->saveByCond($data, $cond);
       }else{
           $res = $newsletterLogic->delete($cond);
       }
       if($res){
        $status = 1;
        $msg = $this->lang['add_success'];
       }
       $return = array(
            'status' => $status,
            'msg' => $msg,
        );
       echo json_encode($return);
       exit;
     }
     else
     {
       $email   = _s('user_base_name');
       $cond    = 'email = "'. $email . '"';       
       Core::$tpl->set('newsletter', $newsletterLogic->getOne($cond));
       Core::$tpl->set('big_title', $this->lang['newsletter_subscription']);
     }
   }
   
   /**
     * 非会员可追踪显示订单基本信息
     */
    public function actionTrackNo()
    {
        if (_g())
        {
            $order_number = Common::queryStr(_g('itemno'));
            $order = $this->orderLogic->getOne("itemno='" . mysql_escape_string($order_number) . "'");
            if (!$order)
            {
                $this->exception();
            }
            $order_id = $order['id'];
            $deliveryLogic = $this->load('orderDelivery');
            $orderAddressLogic = $this->load('orderAddress');
            $orderPaymentLogic = $this->load('orderPayment');
            $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
            $goodsPropertyRelLangLogic = $this->load('goodsPropertyRelLanguage');
            $pay_cond = 'order_id=' . $order_id . ' and payment_type=1 and status=1'; //支付成功单据
            $orderPayment = $orderPaymentLogic->getOne($pay_cond);
            $orderAddress = $orderAddressLogic->getOne('order_id=' . $order_id);
            $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $order_id);
            $item_result = array();
            $language_id = $this->load('language')->language_id;
            $order['totalnum'] = 0;
            foreach ($orderItems as $item)
            {
                $property_ids = explode('_', $item['sku_code']);
                $attr = $goodsPropertyRelLangLogic->getListByGoodsIdAndPropertyIds($item['goods_id'], $property_ids, $language_id);
                $item['subtotal'] = $item['price'] * $item['buy_num'];
                $item['attr'] = $attr;
                if($item['sku_value'])
                {
                    $sku_value = explode('_', $item['sku_value']);
                    foreach ($sku_value as $key => $value)
                    {
                        if($value)
                        {
                            $item['sku_value_items'][] = $value;
                        }
                    }
                }
                $item_result[$item['id']] = $item;
                $order['totalnum'] += $item['buy_num'];
            }

            //物流信息
            $ship_record = array(); //发货记录
            $return_record = array();
            $corp_ids = array(); //物流公司IDS
            $trackObj = array();
            $tracking_no = array(); //物流单号
            foreach ($deliveryLogic->findAll('order_id=' . $order['id']) as $val)
            {
                if ($val['delivery_type'] == 1)
                {
                    $ship_record[] = $val;
                }
                else
                {
                    $return_record[] = $val;
                }
                if ($val['delivery_no'] != '')
                    $tracking_no[] = $val['delivery_no'];
                if ($val['status'] == 1)
                {
                    //$corp_ids[]      = $val['shipping_corp_id'];
                    $val['delivery_data'] = json_decode($val['delivery_data'],true);
                    $val['delivery_data']['data'] = array_reverse($val['delivery_data']['data']);//倒叙
                    $shippingCorpLogic      = $this->load('shippingCorp');
                    $shipping_corp  = $shippingCorpLogic->getOne('id='.$val['shipping_corp_id']);
                    $val['shipping_corp_name'] = $shipping_corp['base_name'];
                    $trackObj[] = $val;
                }
                
            }
            
            $order['tracking_no'] = join(' , ', $tracking_no);
            Core::$tpl->set('big_title', $this->lang['tracking_order']);
            Core::$tpl->set('order', $order);
            Core::$tpl->set('orderPayment', $orderPayment);
            Core::$tpl->set('orderAddress', $orderAddress);
            Core::$tpl->set('trackObj', $trackObj);
            Core::$tpl->set('orderItems', $item_result);
            Core::$tpl->set('country', $this->load('country')->getOne('id=' . $orderAddress['country_id']));
            Core::$tpl->set('payment', $this->load('payment')->getOne('id=' . $orderPayment['payment_id']));
            Core::$htmlFile = 'account/trackno';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }
    
        /**
     * 所有商品评论列表
     * @return type 
     */
    public function actionComments() {
        global $cfg;
        $page_size = Common::queryInt(_g('psize'), 10);
        $curr_page = Common::queryInt(_g('page'), 1);
        $commonLogic = $this->load("CommonJoinGoodsLangeageJoinGoods");
        $language_id = $this->languageLogic->language_id;
        $where = "l.language_id=" . $language_id . " and c.status=1 order by c.id desc";
        $count = $commonLogic->getCount($where);
        $result = $commonLogic->getCurrentDatas($where, $page_size, $curr_page);
        $page_data = Common::getPages($count, $curr_page, $page_size);
        Core::$tpl->set('result', $result);
        Core::$tpl->set('pages', $page_data);
        Core::$htmlFile = 'account/comments';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }
}

?>
