<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Article
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class ArticleController extends AppController
{
  private $langLogic;
  public function __construct()
   {
     parent::__construct();
     $this->langLogic = $this->load('language');
   }
   /**
    * 新闻中心 
    */
   public function actionList()
   {
      
      $articleJoinLangLogic = $this->load('articleJoinLanguage');
      //分页用的参数
      global $cfg;
      $language_id = $this->langLogic->language_id;
      $page_size = $cfg['sites'][$language_id]['article_list_number'] ? $cfg['sites'][$language_id]['article_list_number'] : 20;
      $page_size = Common::queryInt(_g('psize'), $page_size);
      $curr_page = Common::queryInt(_g('page'), 1);
      $cond = 'l.language_id='. $this->langLogic->language_id . ' and l.status=1';
      if(_g('article_category_id')){
          $breadcrumb = array();
          $article_category_id = _g('article_category_id');
          $articlecategoryLogic = $this->load('articleCategory');
          $res = $articlecategoryLogic->getOne('id='.$article_category_id);
          $cond .= " and category_url like '".$res['path_id']."%'";
          $category_res = explode(',', substr($res['path_id'], 0, -1));
          foreach ($category_res as $key => $value) {
              $categorys = $articlecategoryLogic->getOne('id='.$value);
              $res = array(
                  'base_name' => $categorys['base_name'],
                  'id' => $categorys['id'],
              );
              $breadcrumb[] = $res;
          }
      }
      $count      = $articleJoinLangLogic->getCount($cond);      
      $page_data  = Common::getPages($count, $curr_page, $page_size);
      $cond .= ' order by a.create_time desc limit '. ($curr_page-1) * $page_size . ',' . $curr_page * $page_size;
      $news = $articleJoinLangLogic->findAll($cond);   
      Core::$tpl->set('breadcrumb', $breadcrumb);
      Core::$tpl->set('news', $news);
      Core::$tpl->set('pages', $page_data);  
   }
   public function actionDetail()
   {
	  $article_id   = Common::queryInt(_g('id'));
      $articleLogic = $this->load('article');
      $articleJoinLangLogic = $this->load('articleJoinLanguage');
      $article = $articleJoinLangLogic->getArticleById($article_id, $this->langLogic->language_id);
      if(!$article)
      {
        return $this->exception();
      }
      $is_read = FALSE;
      if(_c('article_read'))
      {
        $article_read = json_decode(_c('article_read'));
        if(in_array($article_id, $article_read))
        {
          $is_read = TRUE;
        }
        else
        {
          array_push($article_read, $article_id);
          setcookie('article_read', json_encode($article_read));
        }
      }
      else
      {
         setcookie('article_read', json_encode(array($article_id)));
      }
      if(!$is_read)
      {
        $article['visit_counts'] = $article['visit_counts'] + 1;
        $map = Zhtx::createDataMap();
        $map->addEntry('visit_counts', $article['visit_counts'], DB::INT);
        $articleLogic->updateById($map, $article['id']);
      }
      $breadcrumb = array();
      if($article['category_url']){
          $articlecategoryLogic = $this->load('articleCategory');
          $category_res = explode(',', substr($article['category_url'], 0, -1));
          foreach ($category_res as $key => $value) {
              $categorys = $articlecategoryLogic->getOne('id='.$value, "", $cond);
              $res = array(
                  'base_name' => $categorys['base_name'],
                  'id' => $categorys['id'],
              );
              $breadcrumb[] = $res;
          }
          
          
      }
      $next_article = $articleJoinLangLogic->getAdjacentById($article['category_url'],$this->langLogic->language_id,$article_id,"next");
      $prev_article = $articleJoinLangLogic->getAdjacentById($article['category_url'],$this->langLogic->language_id,$article_id,"prev");
      
      Core::$tpl->set('next_article', $next_article[0]);
      Core::$tpl->set('prev_article', $prev_article[0]);
      
      Core::$tpl->set('breadcrumb', $breadcrumb);
      Core::$tpl->set('article', $article);
   }  
}

?>
