<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of IndexController
 *
 * @author hjp <huangjp@35zh.com>
 */
class CartController extends AppController
{

    private $lang;
    private $cartLogic;
    private $skuLogic;
    private $skuProductLangLogic;
    private $languageLogic;
    private $goodsProRelLangLogic;
    private $cartJoinSkuLogic;

    public function __construct()
    {
        parent::__construct();
        $this->lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $this->cartLogic = $this->load('userCart');
        $this->skuLogic = $this->load('sku');
        $this->skuProductLangLogic = $this->load('skuProductLanguage');
        $this->languageLogic = $this->load('language');
        $this->goodsProRelLangLogic = $this->load('goodsPropertyRelLanguage');
        $this->cartJoinSkuLogic = $this->load('cartJoinSku');
    }

    /**
     * 把商品添加到购物车
     * 同一个单品数量不叠加 以最新的为主
     * ajax 
     */
    public function actionAjaxAdd()
    {
        $goods_id = Common::queryInt(_p('goods_id'));
        $sale_id = Common::queryInt(_p('sale_id'));
        $master_sale_id = Common::queryInt(_p('master_sale_id'));
        $qty = Common::queryInt(_p('qty'), 1);
        if($qty<=0)
        {
            $qty=1;
        }
        $user_id = $this->checkLogin(); //用户ID；           
        $language_id = $this->languageLogic->language_id;
        $return = $this->cartLogic->addToCart($goods_id, $sale_id, $master_sale_id, $qty);
        if($return['status'])
        EventFactory::addCartAfter($user_id);
        //清理购物车缓存
        $this->cartLogic->clearCartCache($user_id, $language_id);
        echo json_encode($return);
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        exit;
    }

    /**
     * 购物车列表
     */
    public function actionList()
    {
        $language_id = $this->languageLogic->language_id;
        $user_id = $this->checkLogin();
        $cartJoinSkuLogic = $this->load('cartJoinSku');
        $cartinfo = $cartJoinSkuLogic->getCartInfo($user_id, $language_id);
        Core::$tpl->set('big_title', $this->lang['shopping_cart']);
        if (empty($cartinfo['orderitems']))
        {
            Core::$htmlFile = 'cart/empty';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
        else
        {
            $cart_promotions = array();
            $offerJoinLangLogic = $this->load('offerJoinLanguage');
            $cart_promotions = $offerJoinLangLogic->getCartOffers($this->toolPrice($cartinfo['totalprice'], TRUE) - $this->toolPrice($cartinfo['offer_save'], TRUE), $cartinfo['totalqty'], $language_id);
            $totalprice = $cartinfo['totalprice'];
            $totalsave = $cartinfo['totalsave'];
            $subtotalprice = $cartinfo['subtotalprice'];
            $cart_pro = $cartinfo['cart_promotion'];
            if ($cart_pro != 'nothing' && !$cart_pro)
            {
                foreach ($cart_promotions as $ck => $cpro)
                {
                    if ($cpro['max_offer'] == 1)
                    {
                        $cart_pro = $ck;
                        $cart_save = $this->toolPrice($cpro['cart_save']);
                        //$totalprice = $totalprice - $cart_save;
//                  $totalsave  = $totalsave + $cart_save;
                        $subtotalprice = $subtotalprice - $cart_save;
                        _setSession('cart_promotion', $cart_pro);
                        $cartinfo['promotion_save'] = $cart_save;
                        break;
                    }
                }
            }
            $couponLogic = $this->load('coupon');
            $coupons = array();
            //读取用户提交通用优惠券
            //$coupons = $couponLogic->getValidCommon();
            if ($user_id)
            {
                $coupons_valid = $couponLogic->getValidByUserId($user_id);
                if ($coupons_valid)
                {
                    if ($coupons)
                    {
                        $coupons = array_merge($coupons, $coupons_valid);
                    }
                    else
                    {
                        $coupons = $coupons_valid;
                    }
                }
            }
            if(!$coupons)
            {
                //_setSession('cart_coupon', '');
                //$cartinfo['coupon_save'] = 0;
            }
            
            Core::$tpl->set('coupons', $coupons);
            Core::$tpl->set('skulist', $cartinfo['orderitems']);
            Core::$tpl->set('totalprice', $cartinfo['totalprice']);
            Core::$tpl->set('subtotalprice', $subtotalprice);
            Core::$tpl->set('totalsaveprice', $cartinfo['totalsave']);
            Core::$tpl->set('cart_promotion', $cartinfo['cart_promotion']);
            Core::$tpl->set('cart_gift', $cartinfo['cart_gift']);
            Core::$tpl->set('cart_buynum', $cartinfo['final_qty']); //加上赠品的数量
            Core::$tpl->set('cart_promotions', $cart_promotions);
            Core::$tpl->set('cart_coupon', $cartinfo['cart_coupon']);
            Core::$tpl->set('cart_save', $cartinfo['cart_save']);
            Core::$tpl->set('promotion_save', $this->price_format($cartinfo['promotion_save']));
            Core::$tpl->set('coupon_save', $this->price_format($cartinfo['coupon_save']));
			$paymentLogic = $this->load('payment');
            $payment = $paymentLogic->getOne("interface_type='paypal' and (language_id=0 or language_id=" . $language_id . ')');
            $is_ecpay_checkout = TRUE;
            if (!$payment)
            {
                $is_ecpay_checkout = FALSE;
            }
            else
            {
                $config_param = json_decode($payment['config_param'], true);
                if (!$config_param['exp_express_checkout'] || !$config_param['exp_api_username'] || !$config_param['exp_api_password'] || !$config_param['exp_api_sign'])
                {
                    $is_ecpay_checkout = FALSE;
                }
            }
            Core::$tpl->set('is_ecpay_checkout', $is_ecpay_checkout);
        }
    }

    /**
     * 修改购物车单品数量
     * @return type 
     */
    public function actionChangeSkuNumInCart()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $goods_id = Common::queryInt(_p('goods_id'));
        $sku_code = _p('sku_code');
        $qty = Common::queryInt(_p('qty'), 1);
        if($qty<=0)
        {
            $qty=1;
        }
        $status = 0;
        $msg = '';
        if (!$goods_id || !$sku_code)
        {
            echo json_encode(array('status' => 0, 'msg' => ''));
            return;
        }
        $cond = 'goods_id=' . $goods_id . ' and sku_code="' . $sku_code . '"';
        $sku = $this->skuLogic->getOne($cond);
        if (!$sku)
        {
            echo json_encode(array('status' => 0, 'msg' => ''));
            return;
        }
        if (($qty) <= $sku['stock_nums'])
        {
            $status = 1;
        }
        else
        {
            $msg = $lang['qty_can_not_be_greater_than'] . $sku['stock_nums'];
        }
        //更新购物车
        if ($status == 1)
        {
            $user_id = $this->checkLogin();
            if ($user_id)
            {
                $cond = 'user_id=' . $user_id . ' and goods_id=' . $goods_id . ' and sku_code="' . $sku_code . '"';
                $map = Zhtx::createDataMap();
                $map->addEntry('product_num', $qty, DB::INT);
                $res = $this->cartLogic->update($map, $cond);
                if (!$res)
                {
                    $status = 0;
                }
            }
            else
            {
                $cart_data = json_decode(_c('cartsku'), TRUE);
                $reset_data = array();
                foreach ($cart_data as $cart)
                {
                    if ($cart['goods_id'] == $goods_id && $cart['sku_code'] == $sku_code)
                    {
                        $cart['product_num'] = $qty;
                    }
                    $reset_data[] = $cart;
                }
                setcookie('cartsku', json_encode($reset_data), time() + 7 * 86400, '/');
            }
        }
        //移除优惠
        if ($status == 1)
        {
            $this->delOffer($sku['id']);
        }
        $this->cartLogic->clearCartCache($user_id, $this->languageLogic->language_id);
        echo json_encode(array('status' => $status, 'msg' => $msg));
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        exit;
    }

    /**
     * 清理优惠
     * @param type $sku_id 
     */
    public function delOffer($sku_id)
    {
        $promotion = array();
        foreach (json_decode(_s('product_promotion')) as $key => $val)
        {
            if ($key != $sku_id)
            {
                $promotion[$key] = $val;
            }
        }
        //促销信息存放到cookie
        _setSession('product_promotion', json_encode($promotion)); //关闭浏览器失效                        
        $promotion_gift = array();
        foreach (json_decode(_s('gift_promotion')) as $key => $val)
        {
            if ($key != $sku_id && $key != 'cart')
            {
                foreach ($val as $v)
                {
                    $promotion_gift[$key][$v->goods_id] = array(
                        'offer_id' => $v->offer_id,
                        'goods_id' => $v->goods_id,
                        'sku_code' => $v->sku_code,
                    );
                }
            }
        }
        _setSession('gift_promotion', json_encode($promotion_gift)); //关闭浏览器失效 
        _setSession('cart_promotion', '');
        _setSession('cart_coupon', '');
    }

     /**
     * 购物车优惠券使用 如有促销需考虑是否可以重叠 
     */
    public function actionCartCoupon()
    {
        global $current_currency;
        $language_id = $this->languageLogic->language_id;
        $offer_coupon = _p('offer_id');
        $totalqty = _p('totalqty');
        $cart_promotion = _s('cart_promotion') != 'nothing' ? Common::queryInt(_s('cart_promotion')) : 0;
        $offerLogic = $this->load('offer');
		
		if(_p('manual_coupon'))
		{
			$cur_coupon = $this->load('coupon')->getOne('coupon_code ="' . _p('manual_coupon') . '"  and status=1');
			$offer_coupon =  (int)$cur_coupon['offer_id']."_". $cur_coupon['coupon_code'];		}
		else
        	$offer_coupon = _p('offer_id');
		
        $offer_id = explode('_', $offer_coupon);
        if (!$offer_coupon)
        {
            _setSession('cart_coupon', '');
            echo json_encode(array('status' => 5));
            return;
        }
        $coupon = $this->load('coupon')->getOne('coupon_code ="' . $offer_id[1] . '"  and status=1');
        if (!$coupon || ($coupon['user_id'] != 0 && $coupon['user_id'] != $this->checkLogin()))
        {
            echo json_encode(array('status' => 2));
            return; //优惠券被冻结
        }
        $cond = 'id in (' . $offer_id[0] . ',' . $cart_promotion . ') and status=1 and start_time<=' . time() . ' and end_time>' . time();
        $offers = $offerLogic->findAll($cond, TRUE);
        $cart_offer = array();
        if (!isset($offers[$offer_id[0]]))
        {
            $cart_offer['status'] = 2; //提示优惠券已经过期
        }
        else if (isset($offers[$cart_promotion]) && ($offers[$cart_promotion]['is_spec'] != 1 || $offers[$offer_id[0]]['is_spec'] != 1))
        {
            $cart_offer['status'] = 3; //提示优惠券与促销不可以重叠使用
        }
        else
        {
            $totalprice = $this->toolPrice(floatval(_p('totalprice')), TRUE);
            _setSession('cart_coupon', $offer_coupon);
            
                $product_promotion = json_decode(_s('product_promotion'), TRUE);
                $promotion_gift = json_decode(_s('gift_promotion'), TRUE);
                $cartInfo = $this->cartJoinSkuLogic->getCartPrice($this->checkLogin(), $product_promotion, $promotion_gift, $language_id, _s('cart_promotion') ,$offer_coupon);
				$use_counts = $this->load('couponUser')->getCount("user_id=".(int)$this->checkLogin()." and offer_id=" .$offer_id[0]) ;

                if ($cartInfo['coupon_offer'])
                {
                    //$rule = $cartInfo['coupon_offer']['offer']['offer_rule'][$cartInfo['coupon_offer']['rule_id']];   
                    $offerRuleLogic = $this->load('OfferRule');
                    $rule = $offerRuleLogic->getOneByOfferId($offer_id[0]);
					
                    //var_dump($rule);
                    if($rule['min_amount']>0 && $cartInfo['totalprice']<$this->toolPrice($rule['min_amount']))
                    {
                        $cart_offer['msg'] = str_replace('[0]',$current_currency['symbol_left'].$this->price_format($rule['min_amount']).$current_currency['symbol_right'],$this->lang['coupon_amount_limit']);
                    }
                    else if($rule['min_buynum']>0  && $cartInfo['final_qty']<$rule['min_buynum'])
                    {
                        $cart_offer['msg'] = str_replace('[0]',$rule['min_buynum'],$this->lang['coupon_amount_limit']);
                    }
					else if($offers[$offer_id[0]]['using_num'] && $use_counts>= $offers[$offer_id[0]]['using_num'])
					{
						 $cart_offer['msg'] = str_replace('[0]',$offers[$offer_id[0]]['using_num'],$this->lang['coupon_used_limit']);	
					}
                    else
                    {
                        $cart_offer['status'] = 1;
                        $cart_offer['cart_save'] = $this->price_format($cartInfo['cart_save']);
                        $cart_offer['subtotalprice'] = $this->price_format($cartInfo['totalprice']);
                        $cart_offer['gifts'] = $cartInfo['gifts'];
                        $cart_offer['promotion_save'] = $this->price_format($cartInfo['promotion_save']);
                        $cart_offer['coupon_save'] = $this->price_format($cartInfo['coupon_save']);
                       _setSession('cart_coupon', $offer_coupon);
                    }
                }
                else
                {
                    $cart_offer['status'] = 0;
                	$cart_offer['msg'] = $this->lang['coupon_use_cond'];
//                    $offerRuleLogic = $this->load('OfferRule');
//                    $offerRule = $offerRuleLogic->getOneByOfferId($offer_id[0]);
//                    if($offerRule['min_amount']>0)
//                    {
//                        $cart_offer['msg'] = str_replace('[0]',$current_currency['symbol_left'].$this->price_format($offerRule['min_amount']).$current_currency['symbol_right'],$this->lang['coupon_amount_limit']);
//                    }
//                    else if($offerRule['min_buynum']>0)
//                    {
//                        $cart_offer['msg'] = str_replace('[0]',$offerRule['min_buynum'],$this->lang['coupon_amount_limit']);
//                    }
                }
        }
        echo json_encode($cart_offer);
    }   
    
    /**
     * 游客删除以及用户购物单品删除
     *  
     */
    public function actionDel()
    {
        $goods_id = _p('goods_id') ? intval(_p('goods_id')) : 0;
        $sku_code = _p('code') ? _p('code') : '';
        $sku_id = _p('sku_id');
        $user_id = $this->checkLogin();
        $reduce_count = 0;
        $create_time = 0;
        if ($user_id && $sku_code)
        {
            $cart = $this->cartLogic->getOneByUserId($user_id, $goods_id, $sku_code);
            if ($cart)
            {
                $reduce_count = $cart['product_num'];
                $create_time = $cart['create_time'];
                $this->cartLogic->delete('id =' . $cart['id']);
            }
        }
        else if ($sku_code)
        {
            $cart_data = _c('cartsku') ? json_decode(_c('cartsku')) : array();
            $reset_data = array();
            foreach ($cart_data as $cart)
            {
                if ($cart->goods_id != $goods_id || $cart->sku_code != $sku_code)
                {
                    $reset_data[] = $cart;
                }
                else
                {
                    $reduce_count = $cart->product_num;
                    $create_time = $cart->create_time;
                }
            }
            setcookie('cartsku', json_encode($reset_data), time() + 7 * 86400, '/');
        }
        //删除优惠
        $this->delOffer($sku_id);
        //清理购物车缓存
        $this->cartLogic->clearCartCache($user_id, $this->languageLogic->language_id);
        ReportFactory::reduceCartCount($goods_id, $reduce_count, $create_time, $user_id);
        echo 1;
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        exit;
    }

    /**
     * 商品促销异步操作
     * @global type $cfg 
     */
    public function actionProductOffer()
    {
        $language_id = $this->languageLogic->language_id;
        $sku_id = _p('sku_id');
        $offer_id = _p('offer_id');
        $qty = _p('qty');
        $result = array();
        $sku = $this->skuLogic->getOneById($sku_id);
        if ($offer_id)
        {
            $offerJoinLangLogic = $this->load('offerJoinLanguage');
            $offer = $offerJoinLangLogic->getProductOffer($sku, $offer_id, $qty, $language_id);
            if ($offer)
            {
                $promotion = json_decode(_s('product_promotion'), true);
                $promotion[$sku_id] = $offer_id;
                //促销信息存放到cookie
                _setSession('product_promotion', json_encode($promotion)); //关闭浏览器失效              
                if (isset($offer['gifts']) && $offer['gifts'])
                {
                    $promotion_gift = json_decode(_s('gift_promotion'), true);

                    foreach ($offer['gifts'] as $item)
                    {
                        $gift_sku_code = '';
                        $attr_html = '';
                        if (!empty($item['attr']))
                        {
                            foreach ($item['attr'] as $key => $attr)
                            {
                                if (!$gift_sku_code)
                                {
                                    $gift_sku_code = $key;
                                }
                                $attr_html .= '<option value="' . $key . '">' . $attr . '</option>';
                            }
                        }
                        else
                        {
                            $gift_sku_code = '0_0';
                        }
                            if(!is_array($promotion_gift[$sku_id]))
                            {
                                $promotion_gift[$sku_id] = array();
                            }
                            $promotion_gift[$sku_id][$item['goods_id']] = array(
                                'offer_id' => $offer_id,
                                'goods_id' => $item['goods_id'],
                                'sku_code' => $gift_sku_code,
                            );
                            $result['gifts'][] = array(
                                'image' => $item['image'],
                                'goods_id' => $item['goods_id'],
                                'base_name' => $item['base_name'],
                                'num' => $item['num'],
                                'price' => $this->toolPrice($item['price']),
                                'attr' => $attr_html,
                            );
                    }
                    //赠品信息存放到cookie
                    _setSession('gift_promotion', json_encode($promotion_gift)); //关闭浏览器失效
                }
                $cartInfo = $this->cartJoinSkuLogic->getCartPrice($this->checkLogin(), $promotion, $promotion_gift, $language_id);
                $result['subtotal'] = $this->price_format($offer['subtotal']);
                $result['totalsave'] = $this->price_format($cartInfo['totalsave']);
                $result['totalprice'] = $this->price_format($cartInfo['totalprice']);
                $result['status'] = 1;
                _setSession('cart_coupon', ''); //关闭浏览器失效
                _setSession('cart_promotion', 'nothing'); //关闭浏览器失效
            }
            else
            {
                $result['status'] = 0;
            }
        }
        else
        {
            $promotion = json_decode(_s('product_promotion'), TRUE);
            $promotion[$sku['id']] = 'nothing';
            //unset($promotion[$sku['id']]);
            $promotion_gift = json_decode(_s('gift_promotion'), TRUE);
            $promotion_gift[$sku['id']] = 'nothing';
            //unset($promotion_gift[$sku['id']]);
            //促销信息存放到cookie
            _setSession('product_promotion', json_encode($promotion)); //关闭浏览器失效
            _setSession('gift_promotion', json_encode($promotion_gift)); //关闭浏览器失效
            _setSession('cart_coupon', ''); //关闭浏览器失效
            _setSession('cart_promotion', 'nothing'); //关闭浏览器失效
            if ($sku)
            {
                $cartInfo = $this->cartJoinSkuLogic->getCartPrice($this->checkLogin(), $promotion, $promotion_gift, $language_id);
//              _debug($cartInfo);
                $subtotal_true = $this->toolPrice($sku['price']) * $qty;
                $result['subtotal'] = $subtotal_true;
                $result['totalsave'] = $this->price_format($cartInfo['totalsave']);
                $result['totalprice'] = $this->price_format($cartInfo['totalprice']);
                $result['status'] = 1;
            }
            else
            {
                $result['status'] = 0;
            }
        }
        echo json_encode($result);
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        exit;
    }

    /*
     * 购物车促销优惠 如有优惠券要考虑是否可以重叠使用
     */

    public function actionCartOffer()
    {
        $language_id = $this->languageLogic->language_id;
        $offer_id = Common::queryInt(_p('offer_id'));
        $result = array();
        if ($offer_id)
        {
            $cart_coupon = _s('cart_coupon') ? explode('_', _s('cart_coupon')) : array(0);
            $offerLogic = $this->load('offer');
            $cond = 'id in (' . $offer_id . ',' . $cart_coupon[0] . ') and is_cart=1 and status=1 and start_time <= ' . SYS_TIME . ' and end_time >=' . SYS_TIME;
            $offers = $offerLogic->findAll($cond, TRUE);
            if (!isset($offers[$offer_id]))
            {
                $result['status'] = 2; //提示促销已经过期
            }
            else if (isset($offers[$cart_coupon[0]]) && (!$offers[$cart_coupon[0]]['is_spec'] || !$offers[$offer_id]['is_spec']))
            {
                $result['status'] = 3; //提示优惠券与促销不可以重叠使用
            }
            else
            {
                $product_promotion = json_decode(_s('product_promotion'), TRUE);
                $promotion_gift = json_decode(_s('gift_promotion'), TRUE);
                _setSession('cart_promotion', $offer_id);
                $cartInfo = $this->cartJoinSkuLogic->getCartPrice($this->checkLogin(), $product_promotion, $promotion_gift, $language_id, $offer_id, _s('cart_coupon'));
                if ($cartInfo['totalprice'])
                {
                    $result['status'] = 1;
                    $result['cart_save'] = $this->price_format($cartInfo['cart_save']);
                    $result['subtotalprice'] = $this->price_format($cartInfo['totalprice']);
                    $result['promotion_save'] = $this->price_format($cartInfo['promotion_save']);
                    $result['coupon_save'] = $this->price_format($cartInfo['coupon_save']);
                    $result['gifts'] = $cartInfo['gifts'];
                }
                else
                {
                    $result['status'] = 0;
                }
            }
        }
        else
        {
            $result['subtotalprice'] = _p('totalprice');
            $result['status'] = 5;
            _setSession('cart_promotion', 'nothing');
        }
				_setSession('cart_coupon', '');

        echo json_encode($result);
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        exit;
    }

    /**
     * 赠品选择sku_code 
     */
    public function actionSetGiftSkuCode()
    {
        $goods_id = Common::queryInt(_p('goods_id'));
        $sku_code = _p('sku_code');
        $sku_id = _p('sku_id');
        $promotion_gift = array();
        foreach (json_decode(_s('gift_promotion')) as $key => $val)
        {
            foreach ($val as $v)
            {
                if ($key == $sku_id && $v->goods_id == $goods_id)
                {
                    $v->sku_code = $sku_code;
                }
                $promotion_gift[$key][$v->goods_id] = array(
                    'offer_id' => $v->offer_id,
                    'goods_id' => $v->goods_id,
                    'sku_code' => $v->sku_code,
                );
            }
        }
        _setSession('gift_promotion', json_encode($promotion_gift)); //关闭浏览器失效 
        echo 1;
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        exit;
    }
    public function actionAjaxCheckSku()
    {
        //$lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $goods_id = Common::queryInt(_p('goods_id'));
        $sale_id = Common::queryInt(_p('sale_id'));
        $master_sale_id = Common::queryInt(_p('master_sale_id'));
        $qty = Common::queryInt(_p('qty'), 1);
        if($qty<=0)
        {
            $qty=1;
        }
        $res = $this->skuLogic->getOne("goods_id = {$goods_id} and sku_code = '{$master_sale_id}_{$sale_id}'");
        
        
        if($qty>$res['stock_nums']){
            $return['status'] = 0;
            $return['msg'] = "out of stock";
        }else{
            $return['status'] = 1;
            $return['skuid'] = $res['id'];
        }
        echo json_encode($return);
        exit;
    }

}

?>
