<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Channel
 *
 * @author ZJH
 */
class ChannelController extends AppController {

    private $category;
    private $channelTag;
    private $channelTagGoodsRel;
    private $channelTagLanguage;
    private $goodsTagLogic;
    private $languageLogic;

    public function __construct() {
        parent::__construct();
        $this->category = $this->load('goodsCategoryJoinLang');
        $this->channelTag = $this->load('channelTag');
        $this->channelTagGoodsRel = $this->load('channelTagGoodsRel');
        $this->channelTagLanguage = $this->load('channelTagLanguage');
        $this->goodsTagLogic = $this->load('goodsTag');
        $this->languageLogic = $this->load('language');
    }

    public function actionDetail() {        
        $language_id = $this->languageLogic->language_id;
        $category_id= Common::queryInt(_g('category_id'),0);
        $category = $this->category->getOne("c.is_channel=1 and l.status=1 and l.goods_category_id=".$category_id." and l.language_id=".$language_id);
        if(!$category)
        {
            return $this->exception();
        }
        if($category['is_channel_sys_tag'])
        {
            $tagLogic = $this->load('goodsTagJoinLanguage');
            $tags = $tagLogic->findAll('t.status=1 and t.is_search=1 and l.language_id='.$language_id);
            Core::$tpl->set('tags', $tags);
        }
        
        $cond     = 't.category_id='. $category_id . ' and l.language_id=' . $language_id . ' and l.status = 1 order by t.listorder desc';
        $channelTags = $this->load('channelTagLanguageJoinTag')->findAll($cond);
        $cond2    = 'category_id=' . $category_id . ' order by listorder desc';
        $goods_ids = $this->load('channelTagGoodsRel')->findAll($cond2);
        $rel_goods_ids = array();
        $unique_goods_ids = array();
        foreach ($goods_ids as $value)
        {
          $rel_goods_ids[$value['channel_tag_id']][] = $value['goods_id'];
          $unique_goods_ids[$value['goods_id']]    = $value['goods_id'];
        }
        $goodsList = array();
        if(count($unique_goods_ids) > 0)
        {
          $cond3     = 'l.goods_id in (' . implode(',', $unique_goods_ids) . ') and l.status=1 limit 5000';
          $goodses   = $this->load('goodsJoinLanguage')->findAll($cond3);
          foreach ($goodses as $value)
          {
            $goodsList[$value['id']] = $value;
          }
        }
        Core::$tpl->set('channelTags', $channelTags);
        Core::$tpl->set('rel_goods_ids', $rel_goods_ids);
        Core::$tpl->set('channel_goodsList', $goodsList);
    
        Core::$tpl->set('category', $category);
        Core::$tpl->set('big_title', $category['base_name']); 
        Core::$htmlFile = 'channel/detail';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

}
