<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of product
 *
 * @author xrx
 */
class DailyController extends AppController {

    private $goodsJoinLangLogic;
    private $goodsLangLogic;
    private $productLogic;
    private $goodsLogic;
    private $languageLogic;

    public function __construct() {
        parent::__construct();
        $this->goodsJoinLangLogic = $this->load('goodsJoinLanguage');
        $this->goodsLangLogic = $this->load('goodsLanguage');
        $this->productLogic = $this->load('product');
        $this->goodsLogic = $this->load('goods');
        $this->languageLogic = $this->load('language');
    }

    /**
     * 商品详情页
     * 多语言
     */
    
    public function actionList() {
        global $cfg;
        if(_g("create_time")){
            $thisday = strtotime(_g("create_time"));
        }else{
            $thisday = strtotime(date('Y-m-d',time()));
            $_GET[create_time] = date('Y-m-d',time());
        }
        $nextday = $thisday+86400;
        $language_id = $this->languageLogic->language_id;
        $orderby = isset($cfg['sites'][0]['goods_default_sort']) ? $cfg['sites'][0]['goods_default_sort'] : 'goods_id ';
        $seq = ' desc';
        $orderby = $orderby == 'create_time' ? 'l.goods_id' : 'l.' . $orderby;
        $page_size = $cfg['sites'][$language_id]['daily_list_number'] ? $cfg['sites'][$language_id]['daily_list_number'] : 20;
        $query = array('listorder' => 1, 'order' => 1, 'psize' => $page_size);
        $curr_page = Common::queryInt(_g('page'), 1);
        $in_stock_cond = '';
        if (_g('oquery'))
        {
            $oquery = explode('-', _g('oquery')); //oquery = 1-2-3-4 (展示方式-显示数量-字段-升降)
            $seq = $oquery[3] == 1 ? ' desc' : ' asc';
            if($oquery[1])
            $page_size = $oquery[1] ;
            switch ($oquery[2])
            {
                case 1:
                    $seq = ' desc';
                    break;
                case 2:
                    $orderby = 'g.price ';
                    break;
                case 3:
                    $orderby = 'g.buy_counts ';
                    break;
                case 4:
                    $orderby = 'g.comment_counts ';
                    break;
                case 5:
                    $orderby = 'g.wishlist_counts ';
                    break;
                case 6:
                    $orderby = 'g.visit_counts ';
                    break;
                case 7:
                    $orderby = 'l.goods_id ';
                    $seq = ' desc';
                    break;
                default :break;
            }
            $query = array(
                'listorder' => $oquery[3] ? $oquery[3] : 1,
                'order' => $oquery[2] ? $oquery[2] : 1,
                'psize' => $page_size
            );
            //只显示有货
            if($oquery[4])
            {
                $in_stock_cond = ' and g.stock_nums>0 ';
                $query['in_stock'] = 1;
            }
        }
        
        $res = $this->goodsJoinLangLogic->findAll(" g.create_time >= '{$thisday}' and g.create_time < '{$nextday}' and l.language_id = '".$language_id."'".$in_stock_cond,1);
        $page_data = Common::getPages(sizeof($res), $curr_page, $page_size);
        
        
        $where = 'g.create_time >= '.$thisday.' and g.create_time < '.$nextday.' and l.language_id = '.$language_id.$in_stock_cond.' order by ' . $orderby . $seq;
        $goodsList = $this->goodsJoinLangLogic->getCurrentDatas($where, $page_size, $curr_page);
        
        $time = time();
        for($i = $time-86400*15; $i < $time ;$i+=86400){
          $last15[] = strftime('%Y-%m-%d',$i);
        }
        Core::$tpl->set('last15days', array_reverse($last15));
        Core::$tpl->set('goods_list', $goodsList);
        Core::$tpl->set('oquery', $query);
        Core::$tpl->set('total', sizeof($res));
        Core::$tpl->set('pages', $page_data);
        Core::$tpl->set('daily', 1);
    }
}

?>