<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Module
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class ModuleController extends AppController
{

    private $langLogic;
    private $messageLogic;

    public function __construct()
    {
        parent::__construct();
        $this->langLogic = $this->load('language');
		$this->lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $this->messageLogic = $this->load('message');
        ignore_user_abort(true);
        set_time_limit(0);
    }

    public function actionFeedback()
    {
        if (_p())
        {
            require_once(APP_ROOT . 'libary/MobileDetect.php');
            $detect = new Mobile_Detect;
            $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
            if (!_p('username') || !_p('title') || !_p('content'))
            {
                return $this->showMessage('required_item');
            }
            if (!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code')))
            {
                return $this->showMessage('code_error_tips');
            }
            $ip = Common::_ip2long(Common::ip());
            $domain = SITE_URL;
            //自定义变量
            $keys = _p('exp_key');
            $values = _p('exp_value');
            $contact = array();
            foreach ($keys as $k => $v)
            {
                if ($values[$k])
                {
                    $contact[] = array($v, $values[$k]);
                }
            }
            $user_id = $this->checkLogin();
            $data = array(
                'user_id' => $user_id ? $user_id : 0,
                'user_name' => Common::strEscape(strip_tags(_p('username'))),
                'base_name' => Common::strEscape(strip_tags(_p('title'))),
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'detail' => Common::strEscape(strip_tags(_p('content'))),
                'type' => $user_id ? 1 : 2,
                'contact' => json_encode($contact),
                'status' => 1,
                'language_id' => $this->langLogic->language_id,
                'is_user_readed' => 1,
                'source_device' => $deviceType,
                'create_time'    => SYS_TIME,
            );
            $res = $this->messageLogic->save($data);
            $email = _p('email');
            if ($res && $email) {
                EventFactory::userLeaveMessageAfter($email, $res,$data['language_id']);
            }
            return $res ? $this->success('save_success','/feedback.html') : $this->showMessage('save_failure');
        }
        else
        {
            Core::$tpl->set('big_title', $this->lang['feedback']);
            $user_id = $this->checkLogin();
            if($user_id)
            {
                $uri = explode("html",$_SERVER[REQUEST_URI]);
                $this->_redirect('/h-account-leaveMessage.html'.$uri[1]);
            }
        }
    }

    /**
     * 异常提示页面 
     */
    public function actionNotice()
    {
        $id = Common::queryStr(_g('id'), 'server_is_busy');
        $status = Common::queryInt(_g('status'));
        Core::$tpl->set('big_title', $this->lang['system_notice']);
        Core::$tpl->set('nkey', $id);
        Core::$tpl->set('status', $status);
    }

    /**
     * 404异常提示页面 
     */
    public function actionException()
    {
        header('HTTP/1.1 404 Unauthorized');
        header('status: 404 Unauthorized');
        Core::$htmlFile = 'common/404';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    /**
     * 邮箱订阅 
     */
    public function actionSubmitNewsletter()
    {

        $email = _p('email');
        if (!Common::isEmail($email))
        {
            echo 0;
            die();
        }
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $ip = Common::_ip2long(Common::ip());
        $source = $this->getSource();
        $newsletterLogic = $this->load('newsletter');
        $langLogic = $this->load('language');
        $map = Zhtx::createDataMap();
        $map->addEntry('email', $email, DB::VARCHAR);
        $map->addEntry('source', $source, DB::VARCHAR);
        $map->addEntry('language_id', $langLogic->language_id, DB::VARCHAR);
        $map->addEntry('domain', $_SERVER['SERVER_NAME'], DB::VARCHAR);
        $map->addEntry('ip', $ip, DB::INT);
        $map->addEntry('status', 1, DB::INT);
        $map->addEntry('create_time', SYS_TIME, DB::INT);
        $map->addEntry('source_device', $deviceType, DB::VARCHAR);
        $res = $newsletterLogic->insert($map);
        if ($res)
        {
            echo 1;
        }
        else
        {
            echo 0;
        }
    }

    /**
     * 更换地区 
     */
    public function actionChangeMyDelivery()
    {
        $code = _g('code');
        $logic = $this->load('country');
        $myCountry = $logic->getOne("country_code_2 like '" . $code . "'");
        if ($myCountry)
        {
            setcookie('clientCountryID', $myCountry['id'], time() + 86400 * 7);
            setcookie('clientCountryCode2', $myCountry['country_code_2'], time() + 86400 * 7);
            setcookie('clientCountryCode3', $myCountry['country_code_3'], time() + 86400 * 7);
            setcookie('clientCountryName', $myCountry['base_name'], time() + 86400 * 7);
        }
        else
        {
            $cur_language_id = $this->load('language')->language_id;
            $default_language = $this->load('language')->getOneById($cur_language_id);
            $default_country = $this->load('country')->getOneById($default_language["country_id"]);
            if ($default_country)
            {
                setcookie('clientCountryID', $default_country['id'], time() + 86400 * 7);
                setcookie('clientCountryCode2', $default_country['country_code_2'], time() + 86400 * 7);
                setcookie('clientCountryCode3', $default_country['country_code_3'], time() + 86400 * 7);
                setcookie('clientCountryName', $default_country['base_name'], time() + 86400 * 7);
            }
            else
            {
                setcookie('clientCountryID', 229, time() + 86400 * 7);
                setcookie('clientCountryCode2', "US", time() + 86400 * 7);
                setcookie('clientCountryCode3', "USA", time() + 86400 * 7);
                setcookie('clientCountryName', "United States", time() + 86400 * 7);
            }
        }
        echo 1;
    }

    /**
     * 同步数据 
     */
    public function actionSynchro()
    {
        $codeno = _g('codeno');
        $taskListLogic = $this->load('taskList');
        $taskList = $taskListLogic->getOne('codeno="' . $codeno . '"');
        if (!$taskList)
        {
            echo 0;
            exit;
        }
        $info = explode('_', $codeno);
        $params = json_decode($taskList['params'], TRUE);
        $logic = $this->load($params[0]);

        $dest_cond = 'language_id =' . $info[0] . ' order by id asc limit ' . $info[3] . ',' . $info[4];
        $source_cond = 'language_id =' . $info[1] . ' order by id asc limit ' . $info[3] . ',' . $info[4];
        $dest = $logic->findAll($dest_cond);
        $source = $logic->findAll($source_cond);
        foreach ($dest as $key => $value)
        {
            $exists_dest[$value[$params[1]]] = $value;
        }
        $success = 0;
        $failure = 0;
        foreach ($source as $key => $value)
        {
            $map = Zhtx::createDataMap();
            $exist_obj = isset($exists_dest[$value[$params[1]]]) ? $exists_dest[$value[$params[1]]] : '';
            unset($value['id']);
            unset($value['language_id']);
            if (!$exist_obj)
            {
                $map->addEntry($params[1], $value[$params[1]], DB::INT);
                $map->addEntry('language_id', $info[0]);
                foreach ($value as $field => $v)
                {
                    if (is_int($field))
                    {
                        continue;
                    }
                    if ($field == 'detail')
                    {
                        $map->addEntry($field, Common::strEscape($v, FALSE));
                    }
                    else
                    {
                        $map->addEntry($field, Common::strEscape($v));
                    }
                }
                if ($logic->insert($map))
                {
                    $success++;
                }
                else
                {
                    $failure++;
                }
            }
            else
            {
                foreach ($value as $field => $v)
                {
                    if (is_int($field))
                    {
                        continue;
                    }
                    if ((!$exist_obj[$field] || $params[2]) && $v)
                    {
                        if ($field == 'detail')
                        {
                            $map->addEntry($field, Common::strEscape($v, FALSE));
                        }
                        else
                        {
                            $map->addEntry($field, Common::strEscape($v));
                        }
                    }
                }
                if ($map->getData())
                {
                    if ($logic->updateById($map, $exist_obj['id']))
                    {
                        $success++;
                    }
                    else
                    {
                        $failure++;
                    }
                }
            }
        }
        $task_map = Zhtx::createDataMap();
        if ($failure === 0)
        {
            $task_map->addEntry('status', 1, DB::INT);
            $task_map->addEntry('result', 'Success', DB::VARCHAR);
        }
        else
        {
            $task_map->addEntry('status', 2, DB::INT);
            $task_map->addEntry('result', '成功同步' . $success . '记录\,同步失败' . $failure . '记录', DB::VARCHAR);
        }
        if ($task_map->getData())
        {
            $taskListLogic->updateById($task_map, $taskList['id']);
        }
        echo 1;
        exit;
    }

    /**
     * 前台屏蔽登录
     */
    public function actionLogin()
    {
        global $cfg;        
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        if (_p())
        {
            $username=trim(_p('username'));
            $password=trim(_p('password'));
            $return = array();
            if($username=='' || $password=='')
            {
                $return = array('status' => 0, 'msg' => $lang['please_enter_username_or_password']);
            }
            else if($username==trim($cfg['sites'][0]['authorize_page_username']) && $password==trim($cfg['sites'][0]['authorize_page_password']))
            {
                _setSession('front_user',$username);
                $return = array('status' => 1, 'msg' => $lang['login_success']);
            }
            else
            {
                $return = array('status' => 0, 'msg' => $lang['login_username_or_password_error']);
            }
            echo json_encode($return);
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
        else
        {
            
        }
    }
	
	public function action404()
	{
		header('HTTP/1.1 ' . $status . ' Unauthorized');
        header('status: ' . $status . ' Unauthorized');
		Core::$htmlFile = "common/404";
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . ".htm");
        exit;
	}
	
	 public function actionPage()
    {
        $tpl = _g('tpl');
        Core::$htmlFile = "module/" . $tpl;
		Core::$isdisplay = 0;
		Core::$tpl->render(Core::$htmlFile . ".htm");
    }

}

?>
