<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of IndexController
 *
 * @author hjp <huangjp@35zh.com>
 */
class UserController extends AppController
{

    private $lang;
    private $userLogic;

    public function __construct()
    {
        parent::__construct();
        $this->lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $this->userLogic = $this->load('user');
    }

    public function actionRegister()
    {
        if (_p() && _p('ajax'))
        {
            require_once(APP_ROOT . 'libary/MobileDetect.php');
    	    $detect = new Mobile_Detect;
    	    $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
			Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $return = array();
            $security_email = _p('email');
            $password = _p('password');
            $confirm_password = _p('confirm_password');

            if (!Common::isEmail($security_email))
            {
                $return = array('status' => 0, 'msg' => $this->lang['please_enter_email']);
                echo json_encode($return);
                return;
            }
            if ($this->userLogic->isExistName($security_email))
            {
                $return = array('status' => 0, 'msg' => $this->lang['user_email_exist']);
                echo json_encode($return);
                return;
            }
            if (!$password || !$confirm_password)
            {
                $return = array('status' => 0, 'msg' => $this->lang['password_is_empty']);
                echo json_encode($return);
                return;
            }
            if (!Common::isPassword($password))
            {
                $return = array('status' => 0, 'msg' => $this->lang['password_tip']);
                echo json_encode($return);
                return;
            }
            if ($password && $confirm_password != $password)
            {
                $return = array('status' => 0, 'msg' => $this->lang['two_password_not_match']);
                echo json_encode($return);
                return;
            }
            if(!_p('code') || strtolower(_p('code')) != strtolower(_s('validate_code')))
            {
                $return=array('status'=>0,'msg'=>$this->lang['code_error_tips']); 
                echo json_encode($return);
                return;
            }
            $domain = SITE_PROTOCOL . SITE_URL;
            $langLogic = $this->load('language');
            $ipJoinCountryLogic = $this->load('ipJoinCountry');
            $ip = Common::_ip2long(Common::ip());
            $default_group_id = $this->load('userGroup')->getDefaultGroupId();
            $source = $this->getSource() ? $this->getSource() : SITE_URL;
            $user_data = array(
                'base_name' => $security_email,
                'password' => md5(md5($password)),
                'status' => 1,
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'question' => _p('question'),
                'answer' => _p('answer'),
                'source' => $source,
                'language_id' => $langLogic->language_id,
                'country_id' => $ipJoinCountryLogic->getCountryId($ip),
                'user_group_id' => $default_group_id,
                'create_time' => SYS_TIME,
		'source_device' => $deviceType,
                'parent_user_id' => (int)$this->getUserSource(),
            );
            $register = $this->userLogic->save($user_data);
            if ($register)
            {
                _setSession('user_id', $register);
                _setSession('user_base_name', $security_email);
                _setSession('user_sign', md5(md5($security_email . $register)));
                _setSession('user_group', $default_group_id);
                setcookie('user_id', $register, 0, '/');
                setcookie('user_base_name', $security_email, 0, '/');
                setcookie('user_sign', md5(md5($security_email . $register)), 0, '/');
                setcookie('user_group',$default_group_id, 0, '/');
                $this->userLogic->_checkCookieCart($register);
                $now = time();
                $log_data = array(
                    'language_id' => $langLogic->language_id,
                    'user_id' => $register,
                    'create_year' => date('Y', $now),
                    'create_month' => date('Ym', $now),
                    'create_day' => date('Ymd', $now),
                    'last_ip' => $ip,
                );
                $logLogic = $this->load('userLoginLog');
                $logLogic->save($log_data);
                //增加NEWSLETTER
                $this->load('newsletter')->saveRegisterEmail($security_email);
                $ref = _s('ref') ? _s('ref') : Common::frontURL('wap', 'account', 'index');
                $user = array(
                    'id' => $register,
                    'base_name'   => $security_email,
                    'language_id' => $langLogic->language_id ,
                );
				$this->cleanUserSource();
                GrowthFactory::userRegisterAfter($user);
                GrowthFactory::recommendUserAfter($user);
                GrowthFactory::dailyLoginAfter($user);
                CreditFactory::dailyLoginAfter($user);
                EventFactory::userRegisterAfter($user);
                CreditFactory::userRegisterAfter($user);
                ReportFactory::userReport($user_data);
                $return = array('status' => 1, 'msg' => '', 'ref' => $ref);
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['code_error_tips']);
            }
            echo json_encode($return);
            return;
        }
        else if (_p())
        {
             require_once(APP_ROOT . 'libary/MobileDetect.php');
    	    $detect = new Mobile_Detect;
    	    $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
			$security_email = _p('email');
            $password = _p('password');
            $confirm_password = _p('confirm_password');

            if (!Common::isEmail($security_email))
            {
                return $this->showMessage('please_enter_email');
            }
            if ($this->userLogic->isExistName($security_email))
            {
                return $this->showMessage('user_email_exist');
            }
            if (!$password || !$confirm_password)
            {
                return $this->showMessage('password_is_empty');
            }
            if (!Common::isPassword($password))
            {
                return $this->showMessage('password_tip');
            }
            if ($password && $confirm_password != $password)
            {
                return $this->showMessage('two_password_not_match');
            }
//            if(!_p('validateCode') || strtolower(_p('validateCode')) != strtolower(_s('validate_code')))
//            {
//               return $this->showMessage('code_error_tips');
//            }
            $domain = SITE_PROTOCOL . SITE_URL;
            $langLogic = $this->load('language');
            $ipJoinCountryLogic = $this->load('ipJoinCountry');
            $ip = Common::_ip2long(Common::ip());
            $default_group_id = $this->load('userGroup')->getDefaultGroupId();
            $source = $this->getSource() ? $this->getSource() : SITE_URL;
            $user_data = array(
                'base_name' => $security_email,
                'password' => md5(md5($password)),
                'status' => 1,
                'ip' => $ip,
                'domain' => Common::strEscape($domain),
                'question' => _p('question'),
                'answer' => _p('answer'),
                'source' => $source,
                'language_id' => $langLogic->language_id,
                'country_id' => $ipJoinCountryLogic->getCountryId($ip),
                'user_group_id' => $default_group_id,
                'create_time' => SYS_TIME,
		'source_device' => $deviceType,
                'parent_user_id' => $this->getUserSource(),
            );
            $register = $this->userLogic->save($user_data);
            if ($register)
            {
                _setSession('user_id', $register);
                _setSession('user_base_name', $security_email);
                _setSession('user_sign', md5(md5($security_email . $register)));
                _setSession('user_group', $default_group_id);
                setcookie('user_id', $register, 0, '/');
                setcookie('user_base_name', $security_email, 0, '/');
                setcookie('user_sign', md5(md5($security_email . $register)), 0, '/');
                setcookie('user_group',$default_group_id, 0, '/');
                $this->userLogic->_checkCookieCart($register);
                $now = time();
                $log_data = array(
                    'language_id' => $langLogic->language_id,
                    'user_id' => $register,
                    'create_year' => date('Y', $now),
                    'create_month' => date('Ym', $now),
                    'create_day' => date('Ymd', $now),
                    'last_ip' => $ip,
                );
                $logLogic = $this->load('userLoginLog');
                $logLogic->save($log_data);
                //增加NEWSLETTER
                $this->load('newsletter')->saveRegisterEmail($security_email);
                $ref = _s('ref') ? _s('ref') : Common::frontURL('wap', 'account', 'index');
                ReportFactory::userReport($user_data);
                $user = array(
                    'id' => $register,
                    'base_name'   => $security_email,
                    'language_id' => $langLogic->language_id ,
                );
				$user['realpwd'] = _p('password');
                GrowthFactory::userRegisterAfter($user);
                GrowthFactory::recommendUserAfter($user);
                GrowthFactory::dailyLoginAfter($user);
                CreditFactory::dailyLoginAfter($user);
                EventFactory::userRegisterAfter($user);
                CreditFactory::userRegisterAfter($user);
				ReportFactory::userReport($user_data);
                return $this->_redirect($ref);
            }
            return $this->showMessage('register_failure');
        }
        else
        {
            Core::$tpl->set('big_title', $this->lang['register']);
            Core::$htmlFile = 'user/register';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    public function actionLogin()
    {
        if (_p() && _p('ajax'))
        {
            Core::$htmlFile = 'common/ajax';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
            $return = array();
            $name = _p('name');
            $password = _p('password');
            if (!$name)
            {
                $return = array('status' => 0, 'msg' => $this->lang['login_name_is_empty']);
                echo json_encode($return);
                return;
            }
            if (!$password)
            {
                $return = array('status' => 0, 'msg' => $this->lang['login_password_is_empty']);
                echo json_encode($return);
                return;
            }
            $user = $this->userLogic->login($name, $password);
            if ($user)
            {
                $this->userLogic->_checkCookieCart($user['id']);
                $langLogic = $this->load('language');
                $now = time();
                $log_data = array(
                    'language_id' => $langLogic->language_id,
                    'user_id' => $user['id'],
                    'create_year' => date('Y', $now),
                    'create_month' => date('Ym', $now),
                    'create_day' => date('Ymd', $now),
                    'last_ip' => Common::_ip2long(Common::ip()),
                );
                $logLogic = $this->load('userLoginLog');
                $logLogic->save($log_data);
                GrowthFactory::dailyLoginAfter($user);
                CreditFactory::dailyLoginAfter($user);
                $this->load('creditDetail')->checkCredit();
                $return = array('status' => 1, 'msg' => '', 'ref' => _p('ref'));
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['login_failure']);
            }
            echo json_encode($return);
            return;
        }
        else if (_p())
        {
            $name = _p('name');
            $password = _p('password');
            if (!$name)
            {
                return $this->showMessage('login_name_is_empty');
            }
            if (!$password)
            {
                return $this->showMessage('login_password_is_empty');
            }
            $user = $this->userLogic->login($name, $password);
            if ($user)
            {
                $this->userLogic->_checkCookieCart($user['id']);
                $langLogic = $this->load('language');
                $now = time();
                $log_data = array(
                    'language_id' => $langLogic->language_id,
                    'user_id' => $user['id'],
                    'create_year' => date('Y', $now),
                    'create_month' => date('Ym', $now),
                    'create_day' => date('Ymd', $now),
                    'last_ip' => Common::_ip2long(Common::ip()),
                );
                $logLogic = $this->load('userLoginLog');
                $logLogic->save($log_data);
                GrowthFactory::dailyLoginAfter($user);
                CreditFactory::dailyLoginAfter($user);
                $this->load('creditDetail')->checkCredit();
                return $this->_redirect(_s('ref'));
            }
            return $this->showMessage('login_failure');
        }
        else
        {

            $ref = _g('ref');
            if ($ref)
            {
                //_setSession('ref', $ref);
            }
            else
            {
                $ref = $_SERVER['HTTP_REFERER'];
                //_setSession('ref', $ref);
            }
            if ($this->checkLogin())
            {
                return $this->_redirect($ref);
            }
            Core::$tpl->set('big_title', $this->lang['login']);
            Core::$htmlFile = 'user/login';
            Core::$isdisplay = 0;
            Core::$tpl->render(Core::$htmlFile . '.htm');
        }
    }

    /**
     * 登出
     * @return type
     */
    public function actionLogout()
    {
        _setSession('user_id', '');
        _setSession('user_base_name', '');
        setcookie('user_id', '', time() - 86400);
        setcookie('user_base_name', '', time() - 86400);
        session_destroy();
        return $this->_redirect(Common::frontURL('wap', 'user', 'login'));
    }
    public function actionIsLoginAjax()
    {
       $user_id = $this->checkLogin();
       if($user_id)
       {
         echo json_encode(array('status' => 1,'user' => array('user_id' => $user_id)));
       }
       else
       {
         echo json_encode(array('status' => 0,'msg' => ''));
       }
    }
    /**
     * 会员收藏商品
     */
    public function actionAddFavorites()
    {
        $user_id = $this->checkLogin();
        $status = 0;
        if ($user_id)
        {
            $goods_id = _p('goods_id');
            $goodsLogic = $this->load('goods');
            $goods = $goodsLogic->getOneById($goods_id);
            if ($goods)
            {
                $favoriteLogic = $this->load('userFavorite');
                $cond = 'goods_id=' . $goods_id . ' and user_id=' . $user_id;
                $exist = $favoriteLogic->getOne($cond);
                if ($exist)
                {
                    $status = 3;
                }
                else
                {
                    $favorite_data = array(
                        'user_id' => $user_id,
                        'goods_id' => $goods_id,
                        'create_time' => SYS_TIME,
                    );
                    $res = $favoriteLogic->save($favorite_data);
                    if ($res)
                    {
                        $this->load('goods')->updateWishlistCount($goods_id);
                        $status = 1;
                    }
                }
            }
        }
        else
        {
            $status = 2;
        }
        echo $status;
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }
   /*
    * 优惠券激活
    */
    public function actionActCoupon()
    {
      $lang     = Common::lang(Core::$controller, Core::$module, Core::$language);     
      $user_id = $this->checkLogin();
      if(!$user_id)
      {
        echo json_encode(array('status' => 0, 'msg' => $lang['login_tip']));return;
      }
      $code = _p('code');
      $cond = 'coupon_code="' . $code . '"';
      $couponLogic = $this->load('coupon');
      $couponuserLogic = $this->load('couponUser');
      $coupon = $couponLogic->getOne($cond);
      if($coupon)
      {
         $offer = $this->load('offer')->getOneById($coupon['offer_id']);
         if(SYS_TIME > $offer['end_time'])
         {
           echo json_encode(array('status' => 0, 'msg' => $lang['coupon_has_expired']));return;
         }
         if($coupon['status']==2 || $coupon['status']==3)
         {
           echo json_encode(array('status' => 0, 'msg' => $lang['coupon_code_has_been_used']));return;
         }
         if($coupon['user_id'])
         {
           echo json_encode(array('status' => 0, 'msg' => $lang['coupon_has_been_activated']));return;
         }
         $cart_promotion = _s('cart_promotion') != 'nothing' ? Common::queryInt(_s('cart_promotion')) : 0;
         $offer_promotion = $this->load('offer')->getOneById($cart_promotion);
         $days  = ceil((SYS_TIME-$coupon['create_time'])/86400);
         $using_num = $offer['using_num'];
         $cond2  = 'user_id='. $user_id . ' and offer_id=' . $offer['id'];
         if($offer['coupon_type']==1)
         {
            $used_num  = $couponuserLogic->getCount($cond2);
         }
         else
         {
             $cond2 .=' and status=2';
            $used_num  = $couponLogic->getCount($cond2);
         }        
         if($offer['status'] == 1 && $offer['end_time'] > SYS_TIME && ($using_num == 0 || $using_num >= ($used_num + 1)))
         {
           $map = Zhtx::createDataMap();
           if($offer['coupon_type']!=1)
           {
               $map->addEntry('user_id', $user_id, DB::INT);
           }
           $map->addEntry('act_time', SYS_TIME, DB::INT);
           $offer_coupon = $coupon['offer_id'].'_'.$coupon['coupon_code'];
           if($offer['is_spec'] == 1)
           {
               if($offer_promotion)
               {
                   if($offer_promotion['is_spec']==1)
                   {
                       _setSession('cart_coupon', $offer_coupon);
                   }
               }
               else
               {
                   _setSession('cart_coupon', $offer_coupon);
               }
           }
            else
            {
                if (!$offer_promotion) {
                   _setSession('cart_coupon', $offer_coupon);
                }
            }
           if(!$couponLogic->update($map, $cond))
           {
             echo json_encode(array('status' => 1, 'msg' => $lang['coupon_activation_failure']));return;
           }
         }
         else if($offer['status'] != 1)
         {
             echo json_encode(array('status' => 0, 'msg' => $lang['coupon_status_no_available']));return;
         }
         else if($offer['end_time'] < SYS_TIME)
         {
             echo json_encode(array('status' => 0, 'msg' => $lang['coupon_has_expired']));return;
         }
         else
         {
           echo json_encode(array('status' => 0, 'msg' => str_replace('[0]',$using_num,$lang['coupon_limit_tip'])));return;
         }
      }
      else
      {
        echo json_encode(array('status' => 0, 'msg' => $lang['coupon_code_not_exsited']));return;
      }
      //记录用户提交的通用优惠券
      if($offer['coupon_type']==1)
      {
        $coupon_code_str = _setSession('coupon_code_list');
        $coupon_code_list = array();
        if($coupon_code_str)
        {
            $coupon_code_list = unserialize($coupon_code_str);
        }
        if(!in_array($coupon['id'], $coupon_code_list))
        {
            $coupon_code_list[] = $coupon['id'];
            _setSession('coupon_code_list', serialize($coupon_code_list));            
        }
      }
      echo json_encode(array('status' => 1, 'msg' => $lang['coupon_activation_success']));
    }
    /**
     * ajax 添加配送地址 
     */
    public function actionAddAddress()
    {
        $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
        $user_id = $this->checkLogin();
        $status = 0;
        $msg = $lang['save_failure'];
        if (_p())
        {
            $country_id = _p('country_id');
            if (is_array(_p('country_id')))
            {
                $country_id = $country_id[0];
            }
            if (!$country_id || !$this->load('country')->getOneById(Common::queryInt($country_id)))
            {
                echo json_encode(array('status' => 0, 'msg' => $lang['please_select_country']));
                return;
            }
            if (!_p('state'))
            {
                echo json_encode(array('status' => 0, 'msg' => $lang['please_enter_state']));
                return;
            }
            if (!_p('city'))
            {
                echo json_encode(array('status' => 0, 'msg' => $lang['please_enter_city']));
                return;
            }
            if (!_p('address'))
            {
                echo json_encode(array('status' => 0, 'msg' => $lang['please_enter_address']));
                return;
            }
            if (!_p('mobilephone'))
            {
                echo json_encode(array('status' => 0, 'msg' => $lang['please_enter_mobilephone']));
                return;
            }
            $addressLogic = $this->load('userAddress');
            if ($user_id)
            {
                $address_id = Common::queryInt(_p('id'));
                $data = array(
                    'first_name' => Common::strEscape(strip_tags(_p('first_name'))),
                    'last_name' => Common::strEscape(strip_tags(_p('last_name'))),
                    'state' => Common::strEscape(_p('state')),
                    'city' => Common::strEscape(strip_tags(_p('city'))),
                    'postcode' => Common::strEscape(strip_tags(_p('postcode'))),
                    'country_id' => $country_id,
                    'address' => Common::strEscape(strip_tags(_p('address'))),
                    'address_spare' => Common::strEscape(strip_tags(_p('address_spare'))),
                    'email' => Common::strEscape(_p('email')),
                    'mobilephone' => Common::strEscape(strip_tags(_p('mobilephone'))),
                    'telephone' => Common::strEscape(strip_tags(_p('telephone'))),
                    'is_master' => Common::strEscape(_p('is_master')),
                    'user_id' => $user_id,
                    'address_type'   => Common::queryInt(_p('address_type'),0),
                );
                $flag = $addressLogic->save($data, $address_id);
                if ($flag)
                {
                    if ($address_id)
                    {
                        $map = Zhtx::createDataMap();
                        $map->addEntry('is_master', 0, DB::INT);
                        $addressLogic->update($map, 'id !=' . $address_id. ' and address_type='.$data['address_type']);
                    }
                    $status = 1;
                }
                else
                {
                    $status = 0;
                }
            }
            else
            {
                $email = _p('email');
                if (!Common::isEmail($email))
                {
                    echo json_encode(array('status' => 0, 'msg' => $lang['not_email']));
                    return;
                }
                if ($this->userLogic->isExistName($email))
                {
                    echo json_encode(array('status' => 0, 'msg' => $lang['email_is_used']));
                    return;
                }
                $domain = SITE_PROTOCOL . SITE_URL;
                ;
                $langLogic = $this->load('language');
                $ipJoinCountryLogic = $this->load('ipJoinCountry');
                $ip = Common::_ip2long(Common::ip());
                $password = Common::random(8);
                $default_group_id = $this->load('userGroup')->getDefaultGroupId();
                $source = $this->getSource() ? $this->getSource() : SITE_URL;
                $user_data = array(
                    'base_name' => $email,
                    'password' => md5(md5($password)),
                    'status' => 1,
                    'ip' => $ip,
                    'domain' => Common::strEscape($domain),
                    'source' => $source,
                    'language_id' => $langLogic->language_id,
                    'country_id' => $ipJoinCountryLogic->getCountryId($ip),
                    'create_time' => SYS_TIME,
                    'parent_user_id' => $this->getUserSource(),
                    'user_group_id' => $default_group_id,
                );
                $register = $this->userLogic->save($user_data);
                if ($register)
                {
                    $isreg = true;
                    _setSession('user_id', $register);
                    _setSession('user_base_name', $email);
                    _setSession('user_sign', md5(md5($email . $register)));
                    _setSession('user_password', $password);
                    _setSession('user_group', $default_group_id);
                    setcookie('user_id', $register);
                    setcookie('user_base_name', $email);
                    setcookie('user_sign', md5(md5($email . $register)));
                    setcookie('user_group',$default_group_id, 0, '/');
                    $this->userLogic->_checkCookieCart($register);
                    $now = time();
                    $log_data = array(
                        'language_id' => $langLogic->language_id,
                        'user_id' => $register,
                        'create_year' => date('Y', $now),
                        'create_month' => date('Ym', $now),
                        'create_day' => date('Ymd', $now),
                        'last_ip' => $ip,
                    );
                    $logLogic = $this->load('userLoginLog');
                    $logLogic->save($log_data);
                    //增加NEWSLETTER
                    $this->load('newsletter')->saveRegisterEmail($email);
                    $user = array(
                            'id' => $register,
                            'base_name'   => $email,
                            'language_id' => $langLogic->language_id ,
                        );
                        GrowthFactory::userRegisterAfter($user);
                        GrowthFactory::recommendUserAfter($user);
                        GrowthFactory::dailyLoginAfter($user);
                        CreditFactory::dailyLoginAfter($user);
                        EventFactory::userRegisterAfter($user);
                        CreditFactory::userRegisterAfter($user);
                        ReportFactory::userReport($user_data);
                    $data = array(
                        'first_name' => Common::strEscape(strip_tags(_p('first_name'))),
                        'last_name' => Common::strEscape(strip_tags(_p('last_name'))),
                        'state' => Common::strEscape(_p('state')),
                        'city' => Common::strEscape(strip_tags(_p('city'))),
                        'postcode' => Common::strEscape(strip_tags(_p('postcode'))),
                        'country_id' => $country_id,
                        'address' => Common::strEscape(strip_tags(_p('address'))),
                        'address_spare' => Common::strEscape(strip_tags(_p('address_spare'))),
                        'email' => Common::strEscape(_p('email')),
                        'mobilephone' => Common::strEscape(strip_tags(_p('mobilephone'))),
                        'telephone' => Common::strEscape(strip_tags(_p('telephone'))),
                        'is_master' => Common::strEscape(_p('is_master')),
                        'user_id' => $register,
                    );
                    $flag = $addressLogic->save($data);
                    if ($flag)
                    {
                        
                        $status = 1;
                        $msg = $lang['save_success'];
                    }
                }
            }
        }
        if($isreg)
        echo json_encode(array('status' => $status, 'msg' => $msg,'isreg' => 1));
        else
        echo json_encode(array('status' => $status, 'msg' => $msg,'isreg' => 0));
    }

    /**
     * ajax 
     * 通过ID获取配送地址 
     */
    public function actionGetAddressById()
    {
        $address_id = Common::queryInt(_p('id'));
        $address = $this->load('userAddress')->getOneById($address_id);
        echo $address ? json_encode($address) : 0;
    }

    /**
     * 找回密码
     */
    public function actionForgetPassword()
    {
        if (_p())
        {
            $channel = _p('channel');
            $email = _p('email');
            if (!$email || !Common::isEmail($email))
            {
                return $this->showMessage('please_enter_valid_email');
            }
            $cond = 'base_name ="' . $email . '"';
            $user = $this->userLogic->getOne($cond);
            if (!$user)
            {
                return $this->showMessage('this_email_not_register');
            }
            //unset($user['password']);
            //unset($user['answer']);
            Core::$tpl->set('big_title', $this->lang['forgetpassword']);
            if($channel == 3)
            {           
              $email_url = explode('@', $email);
              $email_url = 'http://email.' . $email_url[1];
              //发邮件
               EventFactory::sendPassword($user);
              Core::$tpl->set('channel', $channel);
              Core::$tpl->set('user', $user);
              Core::$tpl->set('email_url', $email_url);
              Core::$htmlFile  = 'user/email';
              Core::$isdisplay = 0;
              Core::$tpl->render(Core::$htmlFile . '.htm'); 
            }
            else if ($channel == 1)
            {
                $email_url = explode('@', $email);
                $email_url = 'http://email.' . $email_url[1];
                //发邮件
                EventFactory::forgotPassword($user);
                Core::$tpl->set('channel', $channel);
                Core::$tpl->set('user', $user);
                Core::$tpl->set('email_url', $email_url);
                Core::$htmlFile = 'user/email';
                Core::$isdisplay = 0;
                Core::$tpl->render(Core::$htmlFile . '.htm');
            }
            else if ($channel == 2)
            {
                if(!$user['question'] || !$user['answer'])
                {
                    Core::$tpl->set('channel', $channel);
                    Core::$tpl->set('channel_question_tip', 1);
                    Core::$htmlFile = 'user/email';
                    Core::$isdisplay = 0;
                    Core::$tpl->render(Core::$htmlFile . '.htm');
                }
                else
                {
                    Core::$tpl->set('channel', $channel);
                    Core::$tpl->set('user', $user);
                    Core::$htmlFile = 'user/question';
                    Core::$isdisplay = 0;
                    Core::$tpl->render(Core::$htmlFile . '.htm');
                }
            }
        }
        else
        {
            Core::$tpl->set('big_title', $this->lang['forgetpassword']);
        }
    }

    /**
     * 回答问题 （找回密码步骤2）
     * @return type 
     */
    public function actionAnswerQuestion()
    {
        if (_p())
        {
            $user_id = Common::queryInt(_p('user_id'));
            $user = $this->userLogic->getOneById($user_id);
            if (!$user)
            {
                return $this->showMessage('illegal_parameters',Common::frontURL('wap', 'user', 'forgetPassword'));
            }
            $answer = _p('answer');
            if ($answer == $user['answer'])
            {
                $security_key = md5(md5($user['base_name'] . $user['id'] . $answer));
                unset($user['password']);
                unset($user['answer']);
                Core::$tpl->set('big_title', $this->lang['forgetpassword']);
                Core::$tpl->set('user', $user);
                Core::$tpl->set('security_key', $security_key);
                Core::$htmlFile = 'user/changepassword';
                Core::$isdisplay = 0;
                Core::$tpl->render(Core::$htmlFile . '.htm');
            }
            else
            {
                return $this->showMessage('answer_is_error',Common::frontURL('wap', 'user', 'forgetPassword'));
            }
        }
        else
        {
            return $this->showMessage('illegal_operation',Common::frontURL('wap', 'user', 'forgetPassword'));
        }
    }

    /**
     * 修改密码
     * @return type 
     */
    public function actionChangePassword()
    {
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
        if (_p())
        {
            $user_id = Common::queryInt(_p('user_id'));
            $user = $this->userLogic->getOneById($user_id);
            if (!$user)
            {
                $return = array('status' => 0, 'msg' => $this->lang['illegal_parameters']);
                echo json_encode($return);
                return;
            }
            $security_key = _p('security_key');
            if ($security_key != md5(md5($user['base_name'] . $user['id'] . $user['answer'])))
            {
                $return = array('status' => 0, 'msg' => $this->lang['illegal_operation']);
                echo json_encode($return);
                return;
            }
            $password = _p('password');
            $confirm_password = _p('Confirm_password');
            if (!Common::isPassword($password))
            {
                $return = array('status' => 0, 'msg' => $this->lang['password_tip']);
                echo json_encode($return);
                return;
            }
            if ($confirm_password != $password)
            {
                $return = array('status' => 0, 'msg' => $this->lang['two_password_not_match']);
                echo json_encode($return);
                return;
            }
            $map = Zhtx::createDataMap();
            $map->addEntry('password', md5(md5($password)), DB::VARCHAR);
            $res = $this->userLogic->updateById($map, $user_id);      
            if($res)
            {
                $return = array('status' => 1, 'msg' => $this->lang['operation_success']);
                echo json_encode($return);
                return;
            }
            else
            {
                $return = array('status' => 0, 'msg' => $this->lang['operation_failure']);
                echo json_encode($return);
                return;
            }
        }
        else
        {
            $return = array('status' => 0, 'msg' => $this->lang['illegal_operation']);
            echo json_encode($return);
            return;
        }
    }

    /**
     *  激活邮件 重设密码 (24小时内失效)
     *  发送到邮箱的地址如 http://www.35zh.com?index.php?m=home&c=user&a=forgetPasswordReset&user_id=$user_id&t=$seng_time&sign=$sign
     *  user_id 用户ID
     *  timestamp 发送时间
     *  sign md5(md5(user_id.base_name.ip.timestamp))签名方式
     */
    public function actionForgetPasswordReset()
    {
        $user_id = Common::queryInt(_g('user_id'));
        $timestamp = Common::queryInt(_g('t'));
        $sign = _g('sign');
        $user = $this->userLogic->getOneById($user_id);
        if (!$user)
        {
            return $this->showMessage('illegal_operation');
        }
        if ((SYS_TIME - $timestamp) > 86400)
        {
            //通知邮件已经过期失效 跳转到可以重新发邮件的页面（未处理）
            return $this->showMessage('email_invalid_tip', Common::frontURL('wap', 'user', 'forgetPassword'));
        }
        $valid_sign = md5(md5($user_id . $user['base_name'] . $user['ip'] . $timestamp));
        if ($sign != $valid_sign)
        {
            return $this->showMessage('illegal_parameters');
        }
        $security_key = md5(md5($user['base_name'] . $user['id'] . $user['answer']));
        unset($user['password']);
        unset($user['answer']);
        Core::$tpl->set('big_title', $this->lang['forgetpassword']);
        Core::$tpl->set('user', $user);
        Core::$tpl->set('security_key', $security_key);
        Core::$htmlFile = 'user/changepassword';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }
    
    /**
     * 邮箱订阅 
     */
    public function actionNewsletter()
    {

        $email = _p('email');
        if (!Common::isEmail($email))
        {
            echo 0;
            die();
        }
        require_once(APP_ROOT . 'libary/MobileDetect.php');
        $detect = new Mobile_Detect;
        $deviceType = ($detect->isMobile() ? ($detect->isTablet() ? 'tablet' : 'phone') : 'computer');
        $ip = Common::_ip2long(Common::ip());
        $source = $this->getSource();
        $newsletterLogic = $this->load('newsletter');
        $langLogic = $this->load('language');
        $map = Zhtx::createDataMap();
        $map->addEntry('email', $email, DB::VARCHAR);
        $map->addEntry('source', $source, DB::VARCHAR);
        $map->addEntry('language_id', $langLogic->language_id, DB::VARCHAR);
        $map->addEntry('domain', $_SERVER['SERVER_NAME'], DB::VARCHAR);
        $map->addEntry('ip', $ip, DB::INT);
        $map->addEntry('status', 1, DB::INT);
        $map->addEntry('create_time', SYS_TIME, DB::INT);
        $map->addEntry('source_device', $deviceType, DB::VARCHAR);
        $res = $newsletterLogic->insert($map);
        if ($res)
        {
                $return = array('status' => 1, 'msg' => $this->lang['operation_success']);
                echo json_encode($return);
                return;
        }
        else
        {
                $return = array('status' => 0, 'msg' => $this->lang['operation_failure']);
                echo json_encode($return);
                return;
        }
    }
    
    /**
     * 验证码生成 
     */
    public function actionCreateValidateCode()
    {
       require_once(APP_ROOT . 'libary/ValidateCode.php');
       $codeObj = new ValidateCode();
       $codeObj->createImg();
       _setSession('validate_code', $codeObj->getCode());
       $codeObj->outPut();
    }
}

?>
