<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Wechat
 *
 * @author huangjp <huangjp@35zh.com>
 */
class WechatController extends AppController
{

    private $token;
    private $menu_api = 'https://api.weixin.qq.com/cgi-bin/menu/create?access_token=';
    private $delete_menu_api = 'https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=';
    private $access_token_api = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&';
    private $create_qrcode_api = 'https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=';
    private $show_qrcode_api = 'https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=';

    public function __construct()
    {
        parent::__construct();
        $this->token = 'ikFLJooeNLGG';
    }

    public function actionCallback()
    {
        //$this->valid();
        $this->responseMsg();
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    public function actionBindMenu()
    {
        $button = array();
        $button['button'][] = array('name' => 'Menu', 'sub_button' => array(array('type' => 'view', 'name' => 'MOBILE', 'url' => 'http://m1055.demo.zhcart.com/-i73.html')));
        $button['button'][] = array('name' => 'Order', 'type' => 'click', 'key' => 'V1001_TODAY_ORDER');

        $token_res = Common::getRemoteData($this->access_token_api . 'appid=wx04eb2b399c4197f5&secret=b7662117fe375eb8a826e370081355e6');
        $access_token = json_decode($token_res, TRUE);
        //var_dump($access_token);
        //echo json_encode($button);
        //先删除旧菜单再绑定新菜单
        Common::getRemoteData($this->delete_menu_api . $access_token['access_token']);
        $res = Common::getRemoteData($this->menu_api . $access_token['access_token'], '', '', 60, json_encode($button));
        var_dump($res);
    }
    
    public function actionGetQrcode()
    {
        $token_res = Common::getRemoteData($this->access_token_api . 'appid=wx04eb2b399c4197f5&secret=b7662117fe375eb8a826e370081355e6');
        $access_token = json_decode($token_res, TRUE);
        $param = array();
        $param['action_name'] = 'QR_LIMIT_SCENE';
        $param['action_info'] = array('scene'=>array('scene_id'=>123));
        $ticket_res = Common::getRemoteData($this->create_qrcode_api . $access_token['access_token'], '', '', 60, json_encode($param));
        echo $ticket_res;
        $ticket = json_decode($ticket_res, TRUE);
        var_dump($ticket);
        echo $qrcode = Common::getRemoteData($this->show_qrcode_api . $ticket);
    }

    public function actionBind()
    {
        if (_p())
        {
            
        }
        else
        {
            $openid = Common::queryStr(_g('openid'));
            if (!$openid)
            {
                $this->exception();
            }
            _s('openid', $openid);
            //检查是否已登录
            $user_id = $this->checkLogin();
            if (!$user_id)
            {
                header("Location: " . Common::frontURL('wap', 'user', 'login'));
                return;
            }
            if ($this->checkBind($openid))
            {
                $this->wechatShowMessage("Bind Successed");
            }
            else
            {
                $userWechatLogicLogic = $this->load('UserWechat');
                $data = array();
                $data['user_id'] = $user_id;
                $map = Zhtx::createDataMap();
                $map->createEntry($data);
                $res = $userWechatLogicLogic->update($map, "openid='" . $openid . "'");
                if ($res)
                {
                    $this->wechatShowMessage("Bind Success");
                }
                else
                {
                    $this->wechatShowMessage("Bind Fail");
                }
            }
        }
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    public function actionUnbind()
    {
        if (_p())
        {
            
        }
        else
        {
            $openid = Common::queryStr(_g("openid"));
            $userWechatLogicLogic = $this->load('UserWechat');
            $data = array();
            $data['user_id'] = 0;
            $map = Zhtx::createDataMap();
            $map->createEntry($data);
            $res = $userWechatLogicLogic->update($map, "openid='" . $openid . "'");
            if ($res)
            {
                $this->wechatShowMessage("Unbind Success");
            }
            else
            {
                $this->wechatShowMessage("Unbind Fail");
            }
        }
        Core::$htmlFile = 'common/ajax';
        Core::$isdisplay = 0;
        Core::$tpl->render(Core::$htmlFile . '.htm');
    }

    private function wechatShowMessage($cotent)
    {
        $html = "<!DOCTYPE HTML>\r\n<html>\r\n<head><head><body>";
        $html .=$cotent;
        $html .= "</body></html>";
        echo $html;
        exit();
    }

    private function checkBind($openid)
    {
        //检查是否绑定了账号
        $userWechatLogicLogic = $this->load('UserWechat');
        $userwechat = $userWechatLogicLogic->getOne("openid='" . $openid . "'");
        if ($userwechat)
        {
            if ($userwechat['user_id'])
                $bindstatus = $userwechat['user_id'];
            else
                $bindstatus = false;
        }
        else
            $bindstatus = false;
        return $bindstatus;
    }

    private function getOrders($user_id)
    {
        $orderLogic = $this->load('order');
        $orders = $orderLogic->findAll('user_id=' . $user_id);
        $orderItemJoinSkuLogic = $this->load('orderItemJoinSkuProduct');
        $currencyLogic = $this->load('currency');
        $currencys = $currencyLogic->findAll('status=1');
        foreach ($currencys as $ckey => $curitem)
        {
            $currencys[$currencys[$ckey]['standard_code']] = $curitem;
        }
        foreach ($orders as $key => $rows)
        {
            $orders[$key]['itemtotal'] = 0;
            $orderItems = $orderItemJoinSkuLogic->findAll('i.order_id=' . $rows['id']);
            foreach ($orderItems as $item)
            {
                $orders[$key]['itemtotal']+=$item['buy_num'];
                $orders[$key]['image'] = $item['image'];
            }
            $orders[$key]['lcoin'] = $currencys[$rows['currency_code']]['symbol_left'];
            $orders[$key]['rcoin'] = $currencys[$rows['currency_code']]['symbol_right'];
        }
        return $orders;
    }

    public function responseMsg()
    {
        //get post data, May be due to the different environments
        $postStr = $this->parseData();
        if ($this->checkSignature() && !empty($postStr))
        {
            if ($postStr['MsgType'] == 'event')
            {
                /**
                 * 订阅时，给用户发出的事件提醒
                 */
                if ($postStr['Event'] == 'subscribe')
                {
//					$sql = "insert into member_weixin set openid='".$postStr['FromUserName']."',intime='".date('Y-m-d H:i:s')."'";
//					$sql = "select * from weixin_reply where `type` = 1 limit 1";

                    /**
                     * 1、添加微信公众账号ID 到数据库，以备后续推送使用
                     * 2、获取一条微信回复信息
                     */
                    $data = array();
                    $data['openid'] = $postStr['FromUserName'];
                    $data['intime'] = time();
                    $userWechatLogic = $this->load('userWechat');
                    $userWechatLogic->save($data);

                    $reply = array("reply_type" => 1, "title" => "中恒ZHCART", "img" => "http://img-cdn2.paixie.net/apppic/union/20130705/137300848322867.mp3", "desc" => "欢迎来到中恒天下xxx" . $postStr['FromUserName'] . mysql_error());
                    if ($reply['reply_type'] == 1)
                    {
                        $msgType = 'text';
                        $contentStr = $reply['desc'];
                    }
                    elseif ($reply['reply_type'] == 3)
                    {
                        $msgType = 'music';
                        $contentStr['title'] = $reply['title'];
                        $contentStr['desc'] = $reply['desc'];
                        $contentStr['img'] = $reply['img'];
                    }
                    else
                    {
                        $msgType = 'news';
                        $contentStr[0]['title'] = $reply['title'];
                        $contentStr[0]['desc'] = $reply['desc'];
                        $contentStr[0]['img'] = $reply['img'];
                        $contentStr[0]['url'] = $reply['url'];
                    }
                    $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                }
                elseif ($postStr['Event'] == 'unsubscribe')
                {
                    $userWechatLogicLogic = $this->load('UserWechat');
                    $userWechatLogicLogic->delete("openid='" . $postStr['FromUserName'] . "'");
                    $msgType = "text";
                    $contentStr = '感谢关注中恒天下!<a href="http://m1055.demo.zhcart.com/m-wechat-bind.html?openid=' . $postStr['FromUserName'] . '">点击再次绑定ZHCart账号</a>';
                    $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                }
                elseif (strtolower($postStr['Event']) == 'click')
                {  //自定义菜单点击事件
                    if ($postStr['EventKey'] == 'V1001_TODAY_ORDER')
                    {
                        //检查是是否绑定了
                        $bindstaus = $this->checkBind($postStr['FromUserName']);
                        if (!$bindstaus)
                        {
                            $msgType = "text";
                            $contentStr = '感谢关注中恒天下!<a href="http://m1055.demo.zhcart.com/m-wechat-bind.html?openid=' . $postStr['FromUserName'] . '">点击绑定ZHCart账号</a>';
                            $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                        }
                        else
                        {
                            //根据openid获取用户账号 列出订单
                            $user_id = $bindstaus;
                            $orders = $this->getOrders($user_id);
                            $msgType = "text";
                            $contentStr = '';
                            if ($orders)
                            {
                                foreach ($orders as $key => $rows)
                                {
                                    $contentStr .="Order No.:\r\n" . $rows['itemno'] . "\r\nAmount:\r\n" . $rows['currency_code'] . $rows['final_amount'] . "\r\n----------\r\n";
                                }
                            }
                            else
                            {
                                $contentStr = 'No Order';
                            }
                            $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                        }
                    }
                    else if ($postStr['Event'] == 'LOCATION')
                    {
                        $desc = "您现在所在的位置是经度：" . $postStr["Latitude"] . ",纬度：" . $postStr["Latitude"];
                        $reply = array("reply_type" => 1, "desc" => $desc);
                        if ($reply['reply_type'] == 1)
                        {
                            $msgType = 'text';
                            $contentStr = $reply['desc'];
                        }
                        $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                    }
                }
            }
            else
            {
                $keyword = strtolower(trim($postStr['Content']));
                if ($keyword == 'bind')
                {
                    $msgType = "text";
                    $contentStr = '感谢关注中恒天下!<a href="http://m1055.demo.zhcart.com/m-wechat-bind.html?openid=' . $postStr['FromUserName'] . '">点击绑定ZHCart账号</a>';
                    $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                }
                elseif ($keyword == 'unbind')
                {
                    $msgType = "text";
                    $contentStr = '解除绑定后将不再享受微信特权，确认要解除绑定请点击<a href="http://m1055.demo.zhcart.com/m-wechat-unbind.html?openid=' . $postStr['FromUserName'] . '">解除绑定</a>进行操作';
                    $this->sendText($postStr['FromUserName'], $postStr['ToUserName'], $msgType, $contentStr);
                }
            }
//            $data = array();
//            $data['content'] = trim($postStr['Content']);
//            $map = Zhtx::createDataMap();
//            $map->createEntry($data);
//            $wechatLogic = $this->load('wechat', 'wechat');
//            $wechatLogic->insert($map);
            $fp = fopen("log-wechat.txt", "a");
            flock($fp, LOCK_EX);
            fwrite($fp, json_encode($postStr) . "\r\n");
            flock($fp, LOCK_UN);
            fclose($fp);
        }
        else
        {
            echo '';
            exit();
        }
    }

    public function sendText($toUsername, $fromUsername, $msgType, $content)
    {
        $ntime = time();
        if ($msgType == 'text')
        {
            $textTpl = "<xml>
						<ToUserName><![CDATA[%s]]></ToUserName>
						<FromUserName><![CDATA[%s]]></FromUserName>
						<CreateTime>%s</CreateTime>
						<MsgType><![CDATA[%s]]></MsgType>
						<Content><![CDATA[%s]]></Content>
						<FuncFlag>0</FuncFlag>
						</xml>";
            $resultStr = sprintf($textTpl, $toUsername, $fromUsername, $ntime, $msgType, $content);
        }
        elseif ($msgType == 'news')
        {
            $resultStr = "<xml>
							 <ToUserName><![CDATA[" . $toUsername . "]]></ToUserName>
							 <FromUserName><![CDATA[" . $fromUsername . "]]></FromUserName>
							 <CreateTime>" . $ntime . "</CreateTime>
							 <MsgType><![CDATA[" . $msgType . "]]></MsgType>
							 <ArticleCount>" . count($content) . "</ArticleCount>
							 <Articles>";
            foreach ($content as $val)
            {
                $resultStr .= "<item>
							 <Title><![CDATA[" . $val['title'] . "]]></Title> 
							 <Description><![CDATA[" . $val['desc'] . "]]></Description>
							 <PicUrl><![CDATA[" . $val['img'] . "]]></PicUrl>
							 <Url><![CDATA[" . $val['url'] . "]]></Url>
							 </item>";
            }
            $resultStr .= "</Articles>
							 <FuncFlag>1</FuncFlag>
						</xml> ";
        }
        elseif ($msgType == 'music')
        {
            $resultStr = "<xml>
							 <ToUserName><![CDATA[" . $toUsername . "]]></ToUserName>
							 <FromUserName><![CDATA[" . $fromUsername . "]]></FromUserName>
							 <CreateTime>" . $ntime . "</CreateTime>
							 <MsgType><![CDATA[" . $msgType . "]]></MsgType>
							 <Music>
							 <Title><![CDATA[" . $content['title'] . "]]></Title>
							 <Description><![CDATA[" . $content['desc'] . "]]></Description>
							 <MusicUrl><![CDATA[" . $content['img'] . "]]></MusicUrl>
							 <HQMusicUrl><![CDATA[" . $content['img'] . "]]></HQMusicUrl>
							 </Music>
							 <FuncFlag>0</FuncFlag>
						</xml> ";
        }
        echo $resultStr;
    }

    public function parseData()
    {
        $return = array();
        $postStr = $GLOBALS["HTTP_RAW_POST_DATA"];
        if (!empty($postStr))
        {
            $postObj = simplexml_load_string($postStr, 'SimpleXMLElement', LIBXML_NOCDATA);
            $postObj = json_encode($postObj);
            $postObj = json_decode($postObj, 1);
            return $postObj;
        }
        else
        {
            return $return;
        }
    }

    private function valid()
    {
        $echoStr = $_GET["echostr"];

        //valid signature , option
        if ($this->checkSignature())
        {
            echo $echoStr;
            exit;
        }
    }

    private function checkSignature()
    {
        $signature = $_GET["signature"];
        $timestamp = $_GET["timestamp"];
        $nonce = $_GET["nonce"];

        $token = $this->token;
        $tmpArr = array($token, $timestamp, $nonce);
        sort($tmpArr, SORT_STRING);
        $tmpStr = implode($tmpArr);
        $tmpStr = sha1($tmpStr);

        if ($tmpStr == $signature)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

}

?>
