<?php
/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
class AdminMenuLogic extends BaseLogic
{
    public function __construct() 
    {
        parent::__construct();
        $this->table      = 'AdminMenuTable';
        $this->cache_type = 'menus';
    }
    public function save($data, $primary)
    {
        $map = Zhtx::createDataMap();
        if(isset($data['name']))
            $map->addEntry('name', $data['name'], DB::VARCHAR);
        if(isset($data['parent_id']))
            $map->addEntry('parent_id', $data['parent_id'], DB::VARCHAR);
        if(isset($data['m']))
            $map->addEntry('m', $data['m'], DB::VARCHAR);
        if(isset($data['c']))
            $map->addEntry('c', $data['c'], DB::VARCHAR);
        if(isset($data['a']))
            $map->addEntry('a', $data['a'], DB::VARCHAR);
        if(isset($data['data']))
            $map->addEntry('data', $data['data'], DB::VARCHAR);
        if(isset($data['level']))
            $map->addEntry('level', $data['level'], DB::INT);
        if(isset($data['listorder']))
            $map->addEntry('listorder', $data['listorder'], DB::INT);
        if(isset($data['display']))
            $map->addEntry('display', $data['display'], DB::VARCHAR);
        
        if($primary)
        {
            $return = $this->updateById($map, $primary);
        }
        else
        {
            $return = $this->insert($map);
        }
        return $return;
    }
  
  /**
   * @param $menus 
   * @return type 
   */ 
   public function getMenusByParentId($parent_id = 0, $get_cache = true)
   {
        global $data_cache_dir;       
        $key = "admin_menu_list"; //缓存key        
        $chk = _chkcahce($key, $this->cache_type, TRUE);
        if (!$get_cache || !$chk )
        {  
            $chk  = $this->getList();
           _setcahce($key, $chk, $this->cache_type);
        }
        $result = array();
        foreach ($chk['list'] as $val)
        {
            if($val['parent_id'] == $parent_id)
            {
                $result[] = $val;
            }
        }                     
        return $result;
       
   }
   public function getMenus($get_cache = true)
   {
       global $data_cache_dir;       
        $key = "admin_menu_list"; //缓存key        
        $chk = _chkcahce($key, $this->cache_type, TRUE);
        if (!$get_cache || !$chk )
        {  
            $cond = '1=1 order by listorder desc';
            $chk  = $this->getList($cond);
           _setcahce($key, $chk, $this->cache_type);
        }
                        
        return $chk['list'];
   }


   public function getMenusByIds($menuIds)
   {
       $menu_cond  = 'id in ('.implode(',', $menuIds).') AND display = 1';
       $res        = $this->getList($menu_cond);
       $adminMenu = array();
       foreach ($res['list'] as $value) {
           if($value['parent_id'] == '0')
           {
               $adminMenu['topMenus'][] = $value;
           }
           else
           {
               if($value['level'] == 2)
               {
                   $adminMenu['leftMenus'][$value['id']] = $value;                 
               }
               else
               {                  
                   $adminMenu['childs'][$value['id']] = $value;
               }              
           }
       }
	   return $adminMenu;
   }
   public function updateCache()
   {
       global $data_cache_dir;       
       $key = "admin_menu_list"; //缓存key   
       $cond = '1=1 order by listorder desc';
       $chk  = $this->getList($cond);
       _setcahce($key, $chk, $this->cache_type);
   }
  
}

?>
