<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of BrandJoinLanguageLogic
 *
 * @author xrx <QQ:1251679791 www.35zh.com>
 */
class BrandJoinLanguageLogic extends BaseLogic
{
   public function __construct()
   {
     parent::__construct();
     $this->table = 'BrandJoinLanguageView';
     $this->cache_type = 'brand';
   }
   
   public function getListByLanguageId($language_id, $get_cache=true)
   {
     global $data_cache_dir;
     $key = $language_id . '_brand_list';
     $chk = _chkcahce($key, $this->cache_type);
     if(!$get_cache || !$chk)
     {
       $cond = 'b.status = 1 and l.language_id='. $language_id . ' order by b.listorder asc';
       $chk = $this->findAll($cond,true);
       _setcahce($key, $chk, $this->cache_type);
     }
     return $chk;
   }
   
   public function getItem($id, $language_id=0,$get_cache=true)
	{
		global $data_cache_dir;
       	$key     = $id .'_'.$language_id . '_brand';
        $result  = _chkcahce($key, $this->cache_type);
        if(!$get_cache || !$result)
        {
        	$cond = 'b.id = '.$id.' and l.language_id='. $language_id ;
            $result = $this->getOne($cond);
            _setcahce($key, $result, $this->cache_type);
		}
	    return $result;			
	}
    public function getBrands($params)
    {
       $language_id = isset($params['language_id']) ? $params['language_id'] : 0;
       $offset      = isset($params['offset']) ? $params['offset']: 0;
       $limit       = isset($params['limit']) ? $params['limit']: 20;
       if(!$language_id)
        {
           $langLogic   = $this->load('language');
           $language_id = $langLogic->language_id;
        }
        $cond = 'l.language_id='. $language_id . ' limit ' . $offset . ','. $limit;
        return $this->findAll($cond);
    }
}

?>